import { Resource, ResourceProps } from 'aws-cdk-lib';
import { IConstruct } from 'constructs';
import { IdentityCenterPrincipalType, IIdentityCenterPrincipal } from './lib/identity-center-principal';
export interface IUser {
    readonly userId: string;
}
export declare abstract class UserBase extends Resource implements IUser, IIdentityCenterPrincipal {
    readonly abstract principalId: string;
    readonly principalType: IdentityCenterPrincipalType;
    readonly abstract userId: string;
    constructor(scope: IConstruct, id: string, props?: ResourceProps);
}
export declare class User {
    static fromUserId(scope: IConstruct, id: string, userId: string): IUser;
}
