"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.includesAll = exports.flattenedOrUndefined = exports.flatten = exports.definedFieldsOrUndefined = exports.definedFields = exports.definedElementsOrUndefined = exports.definedElements = exports.undefinedIfNoKeys = exports.trimString = void 0;
function trimString(input, length) {
    if (input.length <= length) {
        return input;
    }
    else {
        const prefixLength = Math.floor(length / 2);
        const suffixLength = Math.floor(length / 2);
        const prefix = input.substring(0, prefixLength);
        const suffix = input.substring(input.length - suffixLength);
        return `${prefix}${suffix}`;
    }
}
exports.trimString = trimString;
function undefinedIfNoKeys(obj) {
    const allUndefined = Object.values(obj).every(val => val === undefined);
    return allUndefined ? undefined : obj;
}
exports.undefinedIfNoKeys = undefinedIfNoKeys;
function definedElements(obj) {
    return obj.filter((x) => {
        return x !== undefined;
    });
}
exports.definedElements = definedElements;
function definedElementsOrUndefined(obj) {
    const defined = definedElements(obj);
    return defined.length === 0 ? undefined : defined;
}
exports.definedElementsOrUndefined = definedElementsOrUndefined;
function definedFields(obj) {
    return Object.keys(obj).reduce((prev, cur) => {
        const key = cur;
        if (obj[key] !== undefined) {
            prev[key] = obj[key];
        }
        return prev;
    }, {});
}
exports.definedFields = definedFields;
function definedFieldsOrUndefined(obj) {
    return undefinedIfNoKeys(definedFields(obj));
}
exports.definedFieldsOrUndefined = definedFieldsOrUndefined;
function flatten(obj) {
    return obj.reduce((prev, cur) => {
        return prev.concat(cur);
    }, []);
}
exports.flatten = flatten;
function flattenedOrUndefined(obj) {
    return definedElementsOrUndefined(flatten(obj));
}
exports.flattenedOrUndefined = flattenedOrUndefined;
function includesAll(obj, values) {
    for (let x of values) {
        if (!obj.includes(x)) {
            return false;
        }
    }
    return true;
}
exports.includesAll = includesAll;
//# sourceMappingURL=data:application/json;base64,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