"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.contextAwareString = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
function contextAwareString(scope, token, defined) {
    return aws_cdk_lib_1.Lazy.uncachedString({
        produce: (context) => {
            const objectScope = aws_cdk_lib_1.Stage.of(scope);
            const contextScope = aws_cdk_lib_1.Stage.of(context.scope);
            return objectScope === contextScope ? token : defined;
        },
    });
}
exports.contextAwareString = contextAwareString;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGF6eS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy91dGlscy9sYXp5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDZDQUEyRDtBQUkzRCxTQUFnQixrQkFBa0IsQ0FBQyxLQUFpQixFQUFFLEtBQWEsRUFBRSxPQUFlO0lBQ2xGLE9BQU8sa0JBQUksQ0FBQyxjQUFjLENBQUM7UUFDekIsT0FBTyxFQUFFLENBQUMsT0FBd0IsRUFBRSxFQUFFO1lBQ3BDLE1BQU0sV0FBVyxHQUFHLG1CQUFLLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxDQUFDO1lBQ3BDLE1BQU0sWUFBWSxHQUFHLG1CQUFLLENBQUMsRUFBRSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsQ0FBQztZQUM3QyxPQUFPLFdBQVcsS0FBSyxZQUFZLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDO1FBQ3hELENBQUM7S0FDRixDQUFDLENBQUM7QUFDTCxDQUFDO0FBUkQsZ0RBUUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJUmVzb2x2ZUNvbnRleHQsIExhenksIFN0YWdlIH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgSUNvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG5cbmV4cG9ydCBmdW5jdGlvbiBjb250ZXh0QXdhcmVTdHJpbmcoc2NvcGU6IElDb25zdHJ1Y3QsIHRva2VuOiBzdHJpbmcsIGRlZmluZWQ6IHN0cmluZyk6IHN0cmluZyB7XG4gIHJldHVybiBMYXp5LnVuY2FjaGVkU3RyaW5nKHtcbiAgICBwcm9kdWNlOiAoY29udGV4dDogSVJlc29sdmVDb250ZXh0KSA9PiB7XG4gICAgICBjb25zdCBvYmplY3RTY29wZSA9IFN0YWdlLm9mKHNjb3BlKTtcbiAgICAgIGNvbnN0IGNvbnRleHRTY29wZSA9IFN0YWdlLm9mKGNvbnRleHQuc2NvcGUpO1xuICAgICAgcmV0dXJuIG9iamVjdFNjb3BlID09PSBjb250ZXh0U2NvcGUgPyB0b2tlbiA6IGRlZmluZWQ7XG4gICAgfSxcbiAgfSk7XG59XG4iXX0=