# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
import os
import sys
import pathlib

on_rtd = os.environ.get('READTHEDOCS') == 'True'
if not on_rtd:
    readme_path = (
        pathlib.Path(__file__)
        .parent.resolve()
        .parent.resolve()
        .parent.joinpath("README.rst")
    )
    readme_target = pathlib.Path(__file__).parent.joinpath("readme.rst")
    with readme_target.open("w") as outf:
        outf.write(readme_path.read_text())

sys.path.insert(0, os.path.abspath('../..'))
sys.setrecursionlimit(1500)


# -- Project information -----------------------------------------------------

project = 'mmu'
copyright = '2022, R. Urlus'
author = 'R. Urlus'

# The full version, including alpha/beta/rc tags
release = '0.1.0rc4'


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'autoapi.extension',
    'sphinx.ext.napoleon',
    'sphinx.ext.autosectionlabel',
]
autoapi_dirs = ['../../mmu']
autoapi_generate_api_docs = False

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = []

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
import sphinx_rtd_theme
html_theme = "sphinx_rtd_theme"
html_theme_path = [sphinx_rtd_theme.get_html_theme_path()]
html_show_sourcelink = True

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = []
master_doc = 'index'

# -- Extension configuration -------------------------------------------------
