"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhoneAssociation = exports.PSTNResources = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/* eslint-disable @typescript-eslint/indent */
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const pstn_function_1 = require("../resources/pstn/pstn-function");
class PSTNResources extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.lambda = this.ensureLambda();
        const PSTNResourceProvider = new custom_resources_1.Provider(this, 'PSTNResourceProvider', {
            onEventHandler: this.lambda,
        });
        this.pstnCustomResource = new aws_cdk_lib_1.CustomResource(this, 'pstnCustomResource', {
            serviceToken: PSTNResourceProvider.serviceToken,
            properties: { ...props },
        });
    }
    ensureLambda() {
        const stack = aws_cdk_lib_1.Stack.of(this);
        const constructName = 'PSTNResources';
        const existing = stack.node.tryFindChild(constructName);
        /* istanbul ignore next */
        if (existing) {
            return existing;
        }
        const pstnCustomResourceRole = new aws_iam_1.Role(this, 'pstnCustomResourceRole', {
            description: 'Amazon Chime PSTN Resources',
            assumedBy: new aws_iam_1.ServicePrincipal('lambda.amazonaws.com'),
            inlinePolicies: {
                ['chimePolicy']: new aws_iam_1.PolicyDocument({
                    statements: [
                        new aws_iam_1.PolicyStatement({
                            resources: ['*'],
                            actions: [
                                'chime:*VoiceProfileDomain*',
                                'kms:CreateGrant',
                                'kms:DescribeKey',
                                'chime:*MediaInsightsPipelineConfiguration*',
                                'chime:CreateSipRule',
                                'chime:DeleteSipRule',
                                'chime:UpdateSipRule',
                                'chime:GetSipRule',
                                'chime:CreateSipMediaApplication',
                                'chime:DeleteSipMediaApplication',
                                'chime:GetPhoneNumberOrder',
                                'chime:SearchAvailablePhoneNumbers',
                                'chime:CreatePhoneNumberOrder',
                                'chime:DeletePhoneNumber',
                                'chime:GetPhoneNumber',
                                'chime:CreateVoiceConnector',
                                'chime:PutVoiceConnectorStreamingConfiguration',
                                'chime:PutVoiceConnectorTermination',
                                'chime:PutVoiceConnectorOrigination',
                                'chime:PutVoiceConnectorLoggingConfiguration',
                                'chime:ListPhoneNumbers',
                                'chime:AssociatePhoneNumbersWithVoiceConnector',
                                'chime:DisassociatePhoneNumbersFromVoiceConnector',
                                'chime:DeleteVoiceConnector',
                                'chime:PutSipMediaApplicationAlexaSkillConfiguration',
                                'chime:PutSipMediaApplicationLoggingConfiguration',
                                'logs:GetLogDelivery',
                                'logs:DeleteLogDelivery',
                                'logs:ListLogDeliveries',
                                'logs:CreateLogGroup',
                                'logs:DescribeResourcePolicies',
                                'logs:PutResourcePolicy',
                                'logs:DescribeLogGroups',
                                'logs:CreateLogDelivery',
                                'lambda:GetPolicy',
                                'lambda:AddPermission',
                                'iam:PutRolePolicy',
                                'iam:CreateServiceLinkedRole',
                            ],
                        }),
                        new aws_iam_1.PolicyStatement({
                            resources: [
                                `arn:aws:ssm:${stack.region}:${stack.account}:parameter/chime/*`,
                            ],
                            actions: [
                                'ssm:PutParameter',
                                'ssm:GetParameter',
                                'ssm:DeleteParameter',
                            ],
                        }),
                    ],
                }),
            },
            managedPolicies: [
                aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'),
            ],
        });
        const fn = new pstn_function_1.PstnFunction(this, 'pstnResourcesFunction', {
            role: pstnCustomResourceRole,
            timeout: aws_cdk_lib_1.Duration.seconds(60),
        });
        // const fn = new Function(this, 'pstnResourcesFunction', {
        //   runtime: Runtime.NODEJS_18_X,
        //   architecture: Architecture.ARM_64,
        //   role: pstnCustomResourceRole,
        //   timeout: Duration.seconds(60),
        //   handler: 'index.handler',
        //   code: Code.fromAsset(path.join(__dirname, '../../src/resources/pstn')),
        // });
        return fn;
    }
}
exports.PSTNResources = PSTNResources;
_a = JSII_RTTI_SYMBOL_1;
PSTNResources[_a] = { fqn: "cdk-amazon-chime-resources.PSTNResources", version: "2.2.6" };
class PhoneAssociation extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.phoneAssociationResource = new custom_resources_1.AwsCustomResource(this, 'phoneAssociation', {
            onCreate: {
                service: 'Chime',
                action: 'associatePhoneNumbersWithVoiceConnector',
                region: 'us-east-1',
                parameters: {
                    E164PhoneNumbers: [props.e164PhoneNumber],
                    VoiceConnectorId: props.voiceConnectorId,
                    ForceAssociate: true,
                },
                physicalResourceId: custom_resources_1.PhysicalResourceId.of(aws_cdk_lib_1.Names.uniqueId(this)),
            },
            onDelete: {
                service: 'Chime',
                action: 'disassociatePhoneNumbersFromVoiceConnector',
                region: 'us-east-1',
                parameters: {
                    E164PhoneNumbers: [props.e164PhoneNumber],
                    VoiceConnectorId: props.voiceConnectorId,
                },
                physicalResourceId: custom_resources_1.PhysicalResourceId.of(aws_cdk_lib_1.Names.uniqueId(this)),
            },
            policy: custom_resources_1.AwsCustomResourcePolicy.fromSdkCalls({
                resources: custom_resources_1.AwsCustomResourcePolicy.ANY_RESOURCE,
            }),
        });
    }
}
exports.PhoneAssociation = PhoneAssociation;
_b = JSII_RTTI_SYMBOL_1;
PhoneAssociation[_b] = { fqn: "cdk-amazon-chime-resources.PhoneAssociation", version: "2.2.6" };
//# sourceMappingURL=data:application/json;base64,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