import { Construct } from 'constructs';
export declare enum NotificationTargetType {
    EVENTBRIDGE = "EventBridge",
    SNS = "SNS",
    SQS = "SQS"
}
export declare enum Protocol {
    TCP = "TCP",
    UDP = "UDP"
}
export interface Termination {
    /**
     * Calling Regions for VoiceConnector (optional)
     *
     * @default - ['US']
     */
    readonly callingRegions: Array<string>;
    /**
     * CPS Limit
     *
     * @default - 1
     */
    readonly cps?: number;
    /**
     * termination IP for VoiceConnector (optional)
     *
     * @default - none
     */
    readonly terminationCidrs: Array<string>;
}
export interface VoiceConnectorLoggingConfiguration {
    readonly enableSIPLogs?: boolean;
    readonly enableMediaMetricLogs?: boolean;
}
export interface MediaInsightsConfiguration {
    readonly disabled: boolean;
    readonly configurationArn: string;
}
export interface Routes {
    readonly host: string;
    readonly port: number;
    readonly protocol: Protocol;
    readonly priority: number;
    readonly weight: number;
}
export interface Streaming {
    readonly enabled: boolean;
    /**
     * Streaming data retention for VoiceConnector
     *
     * @default - 0
     */
    readonly dataRetention: number;
    /**
     * Streaming data retention for VoiceConnector
     *
     * @default - 0
     */
    readonly notificationTargets: Array<NotificationTargetType>;
    readonly mediaInsightsConfiguration?: MediaInsightsConfiguration;
}
/**
 * Props for `SipMediaApplication`.
 */
export interface VoiceConnectorProps {
    /**
     * region for SipMediaApplication(required) - Must us-east-1 or us-west-2 and in the same region as the SipMediaApplication Lambda handler
     *
     * @default - same region as stack deployment
     */
    readonly region?: string;
    /**
     * name for VoiceConnector
     *
     * @default - unique ID for resource
     */
    readonly name?: string;
    /**
     * Encryption boolean for VoiceConnector
     *
     * @default - False
     */
    readonly encryption?: boolean;
    readonly termination?: Termination;
    readonly origination?: Array<Routes>;
    readonly streaming?: Streaming;
    readonly loggingConfiguration?: VoiceConnectorLoggingConfiguration;
}
export declare class ChimeVoiceConnector extends Construct {
    readonly voiceConnectorId: string;
    constructor(scope: Construct, id: string, props: VoiceConnectorProps);
}
