import { HttpRequest as __HttpRequest } from "@aws-sdk/protocol-http";
import { decorateServiceException as __decorateServiceException, expectBoolean as __expectBoolean, expectInt32 as __expectInt32, expectNonNull as __expectNonNull, expectNumber as __expectNumber, expectObject as __expectObject, expectString as __expectString, map as __map, parseEpochTimestamp as __parseEpochTimestamp, parseRfc3339DateTimeWithOffset as __parseRfc3339DateTimeWithOffset, resolvedPath as __resolvedPath, throwDefaultError, } from "@aws-sdk/smithy-client";
import { v4 as generateIdempotencyToken } from "uuid";
import { ChimeSDKMediaPipelinesServiceException as __BaseException } from "../models/ChimeSDKMediaPipelinesServiceException";
import { BadRequestException, ConflictException, ForbiddenException, NotFoundException, ResourceLimitExceededException, ServiceFailureException, ServiceUnavailableException, ThrottledClientException, UnauthorizedClientException, } from "../models/models_0";
export const se_CreateMediaCapturePipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sdk-media-capture-pipelines";
    let body;
    body = JSON.stringify({
        ...(input.ChimeSdkMeetingConfiguration != null && {
            ChimeSdkMeetingConfiguration: se_ChimeSdkMeetingConfiguration(input.ChimeSdkMeetingConfiguration, context),
        }),
        ClientRequestToken: input.ClientRequestToken ?? generateIdempotencyToken(),
        ...(input.SinkArn != null && { SinkArn: input.SinkArn }),
        ...(input.SinkType != null && { SinkType: input.SinkType }),
        ...(input.SourceArn != null && { SourceArn: input.SourceArn }),
        ...(input.SourceType != null && { SourceType: input.SourceType }),
        ...(input.Tags != null && { Tags: se_TagList(input.Tags, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_CreateMediaConcatenationPipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sdk-media-concatenation-pipelines";
    let body;
    body = JSON.stringify({
        ClientRequestToken: input.ClientRequestToken ?? generateIdempotencyToken(),
        ...(input.Sinks != null && { Sinks: se_ConcatenationSinkList(input.Sinks, context) }),
        ...(input.Sources != null && { Sources: se_ConcatenationSourceList(input.Sources, context) }),
        ...(input.Tags != null && { Tags: se_TagList(input.Tags, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_CreateMediaInsightsPipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/media-insights-pipelines";
    let body;
    body = JSON.stringify({
        ClientRequestToken: input.ClientRequestToken ?? generateIdempotencyToken(),
        ...(input.KinesisVideoStreamRecordingSourceRuntimeConfiguration != null && {
            KinesisVideoStreamRecordingSourceRuntimeConfiguration: se_KinesisVideoStreamRecordingSourceRuntimeConfiguration(input.KinesisVideoStreamRecordingSourceRuntimeConfiguration, context),
        }),
        ...(input.KinesisVideoStreamSourceRuntimeConfiguration != null && {
            KinesisVideoStreamSourceRuntimeConfiguration: se_KinesisVideoStreamSourceRuntimeConfiguration(input.KinesisVideoStreamSourceRuntimeConfiguration, context),
        }),
        ...(input.MediaInsightsPipelineConfigurationArn != null && {
            MediaInsightsPipelineConfigurationArn: input.MediaInsightsPipelineConfigurationArn,
        }),
        ...(input.MediaInsightsRuntimeMetadata != null && {
            MediaInsightsRuntimeMetadata: se_MediaInsightsRuntimeMetadata(input.MediaInsightsRuntimeMetadata, context),
        }),
        ...(input.S3RecordingSinkRuntimeConfiguration != null && {
            S3RecordingSinkRuntimeConfiguration: se_S3RecordingSinkRuntimeConfiguration(input.S3RecordingSinkRuntimeConfiguration, context),
        }),
        ...(input.Tags != null && { Tags: se_TagList(input.Tags, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_CreateMediaInsightsPipelineConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/media-insights-pipeline-configurations";
    let body;
    body = JSON.stringify({
        ClientRequestToken: input.ClientRequestToken ?? generateIdempotencyToken(),
        ...(input.Elements != null && { Elements: se_MediaInsightsPipelineConfigurationElements(input.Elements, context) }),
        ...(input.MediaInsightsPipelineConfigurationName != null && {
            MediaInsightsPipelineConfigurationName: input.MediaInsightsPipelineConfigurationName,
        }),
        ...(input.RealTimeAlertConfiguration != null && {
            RealTimeAlertConfiguration: se_RealTimeAlertConfiguration(input.RealTimeAlertConfiguration, context),
        }),
        ...(input.ResourceAccessRoleArn != null && { ResourceAccessRoleArn: input.ResourceAccessRoleArn }),
        ...(input.Tags != null && { Tags: se_TagList(input.Tags, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_CreateMediaLiveConnectorPipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sdk-media-live-connector-pipelines";
    let body;
    body = JSON.stringify({
        ClientRequestToken: input.ClientRequestToken ?? generateIdempotencyToken(),
        ...(input.Sinks != null && { Sinks: se_LiveConnectorSinkList(input.Sinks, context) }),
        ...(input.Sources != null && { Sources: se_LiveConnectorSourceList(input.Sources, context) }),
        ...(input.Tags != null && { Tags: se_TagList(input.Tags, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_DeleteMediaCapturePipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/sdk-media-capture-pipelines/{MediaPipelineId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "MediaPipelineId", () => input.MediaPipelineId, "{MediaPipelineId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_DeleteMediaInsightsPipelineConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/media-insights-pipeline-configurations/{Identifier}";
    resolvedPath = __resolvedPath(resolvedPath, input, "Identifier", () => input.Identifier, "{Identifier}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_DeleteMediaPipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sdk-media-pipelines/{MediaPipelineId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "MediaPipelineId", () => input.MediaPipelineId, "{MediaPipelineId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "DELETE",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_GetMediaCapturePipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/sdk-media-capture-pipelines/{MediaPipelineId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "MediaPipelineId", () => input.MediaPipelineId, "{MediaPipelineId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_GetMediaInsightsPipelineConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/media-insights-pipeline-configurations/{Identifier}";
    resolvedPath = __resolvedPath(resolvedPath, input, "Identifier", () => input.Identifier, "{Identifier}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_GetMediaPipelineCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sdk-media-pipelines/{MediaPipelineId}";
    resolvedPath = __resolvedPath(resolvedPath, input, "MediaPipelineId", () => input.MediaPipelineId, "{MediaPipelineId}", false);
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_ListMediaCapturePipelinesCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sdk-media-capture-pipelines";
    const query = map({
        "next-token": [, input.NextToken],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_ListMediaInsightsPipelineConfigurationsCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/media-insights-pipeline-configurations";
    const query = map({
        "next-token": [, input.NextToken],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_ListMediaPipelinesCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/sdk-media-pipelines";
    const query = map({
        "next-token": [, input.NextToken],
        "max-results": [() => input.MaxResults !== void 0, () => input.MaxResults.toString()],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_ListTagsForResourceCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {};
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/tags";
    const query = map({
        arn: [, __expectNonNull(input.ResourceARN, `ResourceARN`)],
    });
    let body;
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "GET",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_TagResourceCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/tags";
    const query = map({
        operation: [, "tag-resource"],
    });
    let body;
    body = JSON.stringify({
        ...(input.ResourceARN != null && { ResourceARN: input.ResourceARN }),
        ...(input.Tags != null && { Tags: se_TagList(input.Tags, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_UntagResourceCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    const resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` + "/tags";
    const query = map({
        operation: [, "untag-resource"],
    });
    let body;
    body = JSON.stringify({
        ...(input.ResourceARN != null && { ResourceARN: input.ResourceARN }),
        ...(input.TagKeys != null && { TagKeys: se_TagKeyList(input.TagKeys, context) }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "POST",
        headers,
        path: resolvedPath,
        query,
        body,
    });
};
export const se_UpdateMediaInsightsPipelineConfigurationCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/media-insights-pipeline-configurations/{Identifier}";
    resolvedPath = __resolvedPath(resolvedPath, input, "Identifier", () => input.Identifier, "{Identifier}", false);
    let body;
    body = JSON.stringify({
        ...(input.Elements != null && { Elements: se_MediaInsightsPipelineConfigurationElements(input.Elements, context) }),
        ...(input.RealTimeAlertConfiguration != null && {
            RealTimeAlertConfiguration: se_RealTimeAlertConfiguration(input.RealTimeAlertConfiguration, context),
        }),
        ...(input.ResourceAccessRoleArn != null && { ResourceAccessRoleArn: input.ResourceAccessRoleArn }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const se_UpdateMediaInsightsPipelineStatusCommand = async (input, context) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const headers = {
        "content-type": "application/json",
    };
    let resolvedPath = `${basePath?.endsWith("/") ? basePath.slice(0, -1) : basePath || ""}` +
        "/media-insights-pipeline-status/{Identifier}";
    resolvedPath = __resolvedPath(resolvedPath, input, "Identifier", () => input.Identifier, "{Identifier}", false);
    let body;
    body = JSON.stringify({
        ...(input.UpdateStatus != null && { UpdateStatus: input.UpdateStatus }),
    });
    return new __HttpRequest({
        protocol,
        hostname,
        port,
        method: "PUT",
        headers,
        path: resolvedPath,
        body,
    });
};
export const de_CreateMediaCapturePipelineCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CreateMediaCapturePipelineCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.MediaCapturePipeline != null) {
        contents.MediaCapturePipeline = de_MediaCapturePipeline(data.MediaCapturePipeline, context);
    }
    return contents;
};
const de_CreateMediaCapturePipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmediapipelines#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const de_CreateMediaConcatenationPipelineCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CreateMediaConcatenationPipelineCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.MediaConcatenationPipeline != null) {
        contents.MediaConcatenationPipeline = de_MediaConcatenationPipeline(data.MediaConcatenationPipeline, context);
    }
    return contents;
};
const de_CreateMediaConcatenationPipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmediapipelines#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const de_CreateMediaInsightsPipelineCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CreateMediaInsightsPipelineCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.MediaInsightsPipeline != null) {
        contents.MediaInsightsPipeline = de_MediaInsightsPipeline(data.MediaInsightsPipeline, context);
    }
    return contents;
};
const de_CreateMediaInsightsPipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmediapipelines#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const de_CreateMediaInsightsPipelineConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CreateMediaInsightsPipelineConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.MediaInsightsPipelineConfiguration != null) {
        contents.MediaInsightsPipelineConfiguration = de_MediaInsightsPipelineConfiguration(data.MediaInsightsPipelineConfiguration, context);
    }
    return contents;
};
const de_CreateMediaInsightsPipelineConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmediapipelines#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const de_CreateMediaLiveConnectorPipelineCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CreateMediaLiveConnectorPipelineCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.MediaLiveConnectorPipeline != null) {
        contents.MediaLiveConnectorPipeline = de_MediaLiveConnectorPipeline(data.MediaLiveConnectorPipeline, context);
    }
    return contents;
};
const de_CreateMediaLiveConnectorPipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmediapipelines#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const de_DeleteMediaCapturePipelineCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeleteMediaCapturePipelineCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_DeleteMediaCapturePipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const de_DeleteMediaInsightsPipelineConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeleteMediaInsightsPipelineConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_DeleteMediaInsightsPipelineConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmediapipelines#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const de_DeleteMediaPipelineCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_DeleteMediaPipelineCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_DeleteMediaPipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const de_GetMediaCapturePipelineCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetMediaCapturePipelineCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.MediaCapturePipeline != null) {
        contents.MediaCapturePipeline = de_MediaCapturePipeline(data.MediaCapturePipeline, context);
    }
    return contents;
};
const de_GetMediaCapturePipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const de_GetMediaInsightsPipelineConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetMediaInsightsPipelineConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.MediaInsightsPipelineConfiguration != null) {
        contents.MediaInsightsPipelineConfiguration = de_MediaInsightsPipelineConfiguration(data.MediaInsightsPipelineConfiguration, context);
    }
    return contents;
};
const de_GetMediaInsightsPipelineConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const de_GetMediaPipelineCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_GetMediaPipelineCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.MediaPipeline != null) {
        contents.MediaPipeline = de_MediaPipeline(data.MediaPipeline, context);
    }
    return contents;
};
const de_GetMediaPipelineCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const de_ListMediaCapturePipelinesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListMediaCapturePipelinesCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.MediaCapturePipelines != null) {
        contents.MediaCapturePipelines = de_MediaCapturePipelineSummaryList(data.MediaCapturePipelines, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const de_ListMediaCapturePipelinesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmediapipelines#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const de_ListMediaInsightsPipelineConfigurationsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListMediaInsightsPipelineConfigurationsCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.MediaInsightsPipelineConfigurations != null) {
        contents.MediaInsightsPipelineConfigurations = de_MediaInsightsPipelineConfigurationSummaryList(data.MediaInsightsPipelineConfigurations, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const de_ListMediaInsightsPipelineConfigurationsCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmediapipelines#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const de_ListMediaPipelinesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListMediaPipelinesCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.MediaPipelines != null) {
        contents.MediaPipelines = de_MediaPipelineList(data.MediaPipelines, context);
    }
    if (data.NextToken != null) {
        contents.NextToken = __expectString(data.NextToken);
    }
    return contents;
};
const de_ListMediaPipelinesCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "ResourceLimitExceededException":
        case "com.amazonaws.chimesdkmediapipelines#ResourceLimitExceededException":
            throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const de_ListTagsForResourceCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_ListTagsForResourceCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.Tags != null) {
        contents.Tags = de_TagList(data.Tags, context);
    }
    return contents;
};
const de_ListTagsForResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const de_TagResourceCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_TagResourceCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_TagResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const de_UntagResourceCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_UntagResourceCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_UntagResourceCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const de_UpdateMediaInsightsPipelineConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_UpdateMediaInsightsPipelineConfigurationCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.MediaInsightsPipelineConfiguration != null) {
        contents.MediaInsightsPipelineConfiguration = de_MediaInsightsPipelineConfiguration(data.MediaInsightsPipelineConfiguration, context);
    }
    return contents;
};
const de_UpdateMediaInsightsPipelineConfigurationCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmediapipelines#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
export const de_UpdateMediaInsightsPipelineStatusCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_UpdateMediaInsightsPipelineStatusCommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
const de_UpdateMediaInsightsPipelineStatusCommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestJsonErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "BadRequestException":
        case "com.amazonaws.chimesdkmediapipelines#BadRequestException":
            throw await de_BadRequestExceptionRes(parsedOutput, context);
        case "ConflictException":
        case "com.amazonaws.chimesdkmediapipelines#ConflictException":
            throw await de_ConflictExceptionRes(parsedOutput, context);
        case "ForbiddenException":
        case "com.amazonaws.chimesdkmediapipelines#ForbiddenException":
            throw await de_ForbiddenExceptionRes(parsedOutput, context);
        case "NotFoundException":
        case "com.amazonaws.chimesdkmediapipelines#NotFoundException":
            throw await de_NotFoundExceptionRes(parsedOutput, context);
        case "ServiceFailureException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceFailureException":
            throw await de_ServiceFailureExceptionRes(parsedOutput, context);
        case "ServiceUnavailableException":
        case "com.amazonaws.chimesdkmediapipelines#ServiceUnavailableException":
            throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
        case "ThrottledClientException":
        case "com.amazonaws.chimesdkmediapipelines#ThrottledClientException":
            throw await de_ThrottledClientExceptionRes(parsedOutput, context);
        case "UnauthorizedClientException":
        case "com.amazonaws.chimesdkmediapipelines#UnauthorizedClientException":
            throw await de_UnauthorizedClientExceptionRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            throwDefaultError({
                output,
                parsedBody,
                exceptionCtor: __BaseException,
                errorCode,
            });
    }
};
const map = __map;
const de_BadRequestExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    if (data.RequestId != null) {
        contents.RequestId = __expectString(data.RequestId);
    }
    const exception = new BadRequestException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_ConflictExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    if (data.RequestId != null) {
        contents.RequestId = __expectString(data.RequestId);
    }
    const exception = new ConflictException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_ForbiddenExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    if (data.RequestId != null) {
        contents.RequestId = __expectString(data.RequestId);
    }
    const exception = new ForbiddenException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_NotFoundExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    if (data.RequestId != null) {
        contents.RequestId = __expectString(data.RequestId);
    }
    const exception = new NotFoundException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_ResourceLimitExceededExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    if (data.RequestId != null) {
        contents.RequestId = __expectString(data.RequestId);
    }
    const exception = new ResourceLimitExceededException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_ServiceFailureExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    if (data.RequestId != null) {
        contents.RequestId = __expectString(data.RequestId);
    }
    const exception = new ServiceFailureException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_ServiceUnavailableExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    if (data.RequestId != null) {
        contents.RequestId = __expectString(data.RequestId);
    }
    const exception = new ServiceUnavailableException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_ThrottledClientExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    if (data.RequestId != null) {
        contents.RequestId = __expectString(data.RequestId);
    }
    const exception = new ThrottledClientException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const de_UnauthorizedClientExceptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body;
    if (data.Code != null) {
        contents.Code = __expectString(data.Code);
    }
    if (data.Message != null) {
        contents.Message = __expectString(data.Message);
    }
    if (data.RequestId != null) {
        contents.RequestId = __expectString(data.RequestId);
    }
    const exception = new UnauthorizedClientException({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body);
};
const se_AmazonTranscribeCallAnalyticsProcessorConfiguration = (input, context) => {
    return {
        ...(input.CallAnalyticsStreamCategories != null && {
            CallAnalyticsStreamCategories: se_CategoryNameList(input.CallAnalyticsStreamCategories, context),
        }),
        ...(input.ContentIdentificationType != null && { ContentIdentificationType: input.ContentIdentificationType }),
        ...(input.ContentRedactionType != null && { ContentRedactionType: input.ContentRedactionType }),
        ...(input.EnablePartialResultsStabilization != null && {
            EnablePartialResultsStabilization: input.EnablePartialResultsStabilization,
        }),
        ...(input.FilterPartialResults != null && { FilterPartialResults: input.FilterPartialResults }),
        ...(input.LanguageCode != null && { LanguageCode: input.LanguageCode }),
        ...(input.LanguageModelName != null && { LanguageModelName: input.LanguageModelName }),
        ...(input.PartialResultsStability != null && { PartialResultsStability: input.PartialResultsStability }),
        ...(input.PiiEntityTypes != null && { PiiEntityTypes: input.PiiEntityTypes }),
        ...(input.PostCallAnalyticsSettings != null && {
            PostCallAnalyticsSettings: se_PostCallAnalyticsSettings(input.PostCallAnalyticsSettings, context),
        }),
        ...(input.VocabularyFilterMethod != null && { VocabularyFilterMethod: input.VocabularyFilterMethod }),
        ...(input.VocabularyFilterName != null && { VocabularyFilterName: input.VocabularyFilterName }),
        ...(input.VocabularyName != null && { VocabularyName: input.VocabularyName }),
    };
};
const se_AmazonTranscribeProcessorConfiguration = (input, context) => {
    return {
        ...(input.ContentIdentificationType != null && { ContentIdentificationType: input.ContentIdentificationType }),
        ...(input.ContentRedactionType != null && { ContentRedactionType: input.ContentRedactionType }),
        ...(input.EnablePartialResultsStabilization != null && {
            EnablePartialResultsStabilization: input.EnablePartialResultsStabilization,
        }),
        ...(input.FilterPartialResults != null && { FilterPartialResults: input.FilterPartialResults }),
        ...(input.LanguageCode != null && { LanguageCode: input.LanguageCode }),
        ...(input.LanguageModelName != null && { LanguageModelName: input.LanguageModelName }),
        ...(input.PartialResultsStability != null && { PartialResultsStability: input.PartialResultsStability }),
        ...(input.PiiEntityTypes != null && { PiiEntityTypes: input.PiiEntityTypes }),
        ...(input.ShowSpeakerLabel != null && { ShowSpeakerLabel: input.ShowSpeakerLabel }),
        ...(input.VocabularyFilterMethod != null && { VocabularyFilterMethod: input.VocabularyFilterMethod }),
        ...(input.VocabularyFilterName != null && { VocabularyFilterName: input.VocabularyFilterName }),
        ...(input.VocabularyName != null && { VocabularyName: input.VocabularyName }),
    };
};
const se_ArtifactsConcatenationConfiguration = (input, context) => {
    return {
        ...(input.Audio != null && { Audio: se_AudioConcatenationConfiguration(input.Audio, context) }),
        ...(input.CompositedVideo != null && {
            CompositedVideo: se_CompositedVideoConcatenationConfiguration(input.CompositedVideo, context),
        }),
        ...(input.Content != null && { Content: se_ContentConcatenationConfiguration(input.Content, context) }),
        ...(input.DataChannel != null && {
            DataChannel: se_DataChannelConcatenationConfiguration(input.DataChannel, context),
        }),
        ...(input.MeetingEvents != null && {
            MeetingEvents: se_MeetingEventsConcatenationConfiguration(input.MeetingEvents, context),
        }),
        ...(input.TranscriptionMessages != null && {
            TranscriptionMessages: se_TranscriptionMessagesConcatenationConfiguration(input.TranscriptionMessages, context),
        }),
        ...(input.Video != null && { Video: se_VideoConcatenationConfiguration(input.Video, context) }),
    };
};
const se_ArtifactsConfiguration = (input, context) => {
    return {
        ...(input.Audio != null && { Audio: se_AudioArtifactsConfiguration(input.Audio, context) }),
        ...(input.CompositedVideo != null && {
            CompositedVideo: se_CompositedVideoArtifactsConfiguration(input.CompositedVideo, context),
        }),
        ...(input.Content != null && { Content: se_ContentArtifactsConfiguration(input.Content, context) }),
        ...(input.Video != null && { Video: se_VideoArtifactsConfiguration(input.Video, context) }),
    };
};
const se_AttendeeIdList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const se_AudioArtifactsConfiguration = (input, context) => {
    return {
        ...(input.MuxType != null && { MuxType: input.MuxType }),
    };
};
const se_AudioConcatenationConfiguration = (input, context) => {
    return {
        ...(input.State != null && { State: input.State }),
    };
};
const se_CategoryNameList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const se_ChannelDefinition = (input, context) => {
    return {
        ...(input.ChannelId != null && { ChannelId: input.ChannelId }),
        ...(input.ParticipantRole != null && { ParticipantRole: input.ParticipantRole }),
    };
};
const se_ChannelDefinitions = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return se_ChannelDefinition(entry, context);
    });
};
const se_ChimeSdkMeetingConcatenationConfiguration = (input, context) => {
    return {
        ...(input.ArtifactsConfiguration != null && {
            ArtifactsConfiguration: se_ArtifactsConcatenationConfiguration(input.ArtifactsConfiguration, context),
        }),
    };
};
const se_ChimeSdkMeetingConfiguration = (input, context) => {
    return {
        ...(input.ArtifactsConfiguration != null && {
            ArtifactsConfiguration: se_ArtifactsConfiguration(input.ArtifactsConfiguration, context),
        }),
        ...(input.SourceConfiguration != null && {
            SourceConfiguration: se_SourceConfiguration(input.SourceConfiguration, context),
        }),
    };
};
const se_ChimeSdkMeetingLiveConnectorConfiguration = (input, context) => {
    return {
        ...(input.Arn != null && { Arn: input.Arn }),
        ...(input.CompositedVideo != null && {
            CompositedVideo: se_CompositedVideoArtifactsConfiguration(input.CompositedVideo, context),
        }),
        ...(input.MuxType != null && { MuxType: input.MuxType }),
        ...(input.SourceConfiguration != null && {
            SourceConfiguration: se_SourceConfiguration(input.SourceConfiguration, context),
        }),
    };
};
const se_CompositedVideoArtifactsConfiguration = (input, context) => {
    return {
        ...(input.GridViewConfiguration != null && {
            GridViewConfiguration: se_GridViewConfiguration(input.GridViewConfiguration, context),
        }),
        ...(input.Layout != null && { Layout: input.Layout }),
        ...(input.Resolution != null && { Resolution: input.Resolution }),
    };
};
const se_CompositedVideoConcatenationConfiguration = (input, context) => {
    return {
        ...(input.State != null && { State: input.State }),
    };
};
const se_ConcatenationSink = (input, context) => {
    return {
        ...(input.S3BucketSinkConfiguration != null && {
            S3BucketSinkConfiguration: se_S3BucketSinkConfiguration(input.S3BucketSinkConfiguration, context),
        }),
        ...(input.Type != null && { Type: input.Type }),
    };
};
const se_ConcatenationSinkList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return se_ConcatenationSink(entry, context);
    });
};
const se_ConcatenationSource = (input, context) => {
    return {
        ...(input.MediaCapturePipelineSourceConfiguration != null && {
            MediaCapturePipelineSourceConfiguration: se_MediaCapturePipelineSourceConfiguration(input.MediaCapturePipelineSourceConfiguration, context),
        }),
        ...(input.Type != null && { Type: input.Type }),
    };
};
const se_ConcatenationSourceList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return se_ConcatenationSource(entry, context);
    });
};
const se_ContentArtifactsConfiguration = (input, context) => {
    return {
        ...(input.MuxType != null && { MuxType: input.MuxType }),
        ...(input.State != null && { State: input.State }),
    };
};
const se_ContentConcatenationConfiguration = (input, context) => {
    return {
        ...(input.State != null && { State: input.State }),
    };
};
const se_DataChannelConcatenationConfiguration = (input, context) => {
    return {
        ...(input.State != null && { State: input.State }),
    };
};
const se_ExternalUserIdList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const se_FragmentSelector = (input, context) => {
    return {
        ...(input.FragmentSelectorType != null && { FragmentSelectorType: input.FragmentSelectorType }),
        ...(input.TimestampRange != null && { TimestampRange: se_TimestampRange(input.TimestampRange, context) }),
    };
};
const se_GridViewConfiguration = (input, context) => {
    return {
        ...(input.ContentShareLayout != null && { ContentShareLayout: input.ContentShareLayout }),
        ...(input.PresenterOnlyConfiguration != null && {
            PresenterOnlyConfiguration: se_PresenterOnlyConfiguration(input.PresenterOnlyConfiguration, context),
        }),
    };
};
const se_IssueDetectionConfiguration = (input, context) => {
    return {
        ...(input.RuleName != null && { RuleName: input.RuleName }),
    };
};
const se_KeywordMatchConfiguration = (input, context) => {
    return {
        ...(input.Keywords != null && { Keywords: se_KeywordMatchWordList(input.Keywords, context) }),
        ...(input.Negate != null && { Negate: input.Negate }),
        ...(input.RuleName != null && { RuleName: input.RuleName }),
    };
};
const se_KeywordMatchWordList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const se_KinesisDataStreamSinkConfiguration = (input, context) => {
    return {
        ...(input.InsightsTarget != null && { InsightsTarget: input.InsightsTarget }),
    };
};
const se_KinesisVideoStreamRecordingSourceRuntimeConfiguration = (input, context) => {
    return {
        ...(input.FragmentSelector != null && { FragmentSelector: se_FragmentSelector(input.FragmentSelector, context) }),
        ...(input.Streams != null && { Streams: se_RecordingStreamList(input.Streams, context) }),
    };
};
const se_KinesisVideoStreamSourceRuntimeConfiguration = (input, context) => {
    return {
        ...(input.MediaEncoding != null && { MediaEncoding: input.MediaEncoding }),
        ...(input.MediaSampleRate != null && { MediaSampleRate: input.MediaSampleRate }),
        ...(input.Streams != null && { Streams: se_Streams(input.Streams, context) }),
    };
};
const se_LambdaFunctionSinkConfiguration = (input, context) => {
    return {
        ...(input.InsightsTarget != null && { InsightsTarget: input.InsightsTarget }),
    };
};
const se_LiveConnectorRTMPConfiguration = (input, context) => {
    return {
        ...(input.AudioChannels != null && { AudioChannels: input.AudioChannels }),
        ...(input.AudioSampleRate != null && { AudioSampleRate: input.AudioSampleRate }),
        ...(input.Url != null && { Url: input.Url }),
    };
};
const se_LiveConnectorSinkConfiguration = (input, context) => {
    return {
        ...(input.RTMPConfiguration != null && {
            RTMPConfiguration: se_LiveConnectorRTMPConfiguration(input.RTMPConfiguration, context),
        }),
        ...(input.SinkType != null && { SinkType: input.SinkType }),
    };
};
const se_LiveConnectorSinkList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return se_LiveConnectorSinkConfiguration(entry, context);
    });
};
const se_LiveConnectorSourceConfiguration = (input, context) => {
    return {
        ...(input.ChimeSdkMeetingLiveConnectorConfiguration != null && {
            ChimeSdkMeetingLiveConnectorConfiguration: se_ChimeSdkMeetingLiveConnectorConfiguration(input.ChimeSdkMeetingLiveConnectorConfiguration, context),
        }),
        ...(input.SourceType != null && { SourceType: input.SourceType }),
    };
};
const se_LiveConnectorSourceList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return se_LiveConnectorSourceConfiguration(entry, context);
    });
};
const se_MediaCapturePipelineSourceConfiguration = (input, context) => {
    return {
        ...(input.ChimeSdkMeetingConfiguration != null && {
            ChimeSdkMeetingConfiguration: se_ChimeSdkMeetingConcatenationConfiguration(input.ChimeSdkMeetingConfiguration, context),
        }),
        ...(input.MediaPipelineArn != null && { MediaPipelineArn: input.MediaPipelineArn }),
    };
};
const se_MediaInsightsPipelineConfigurationElement = (input, context) => {
    return {
        ...(input.AmazonTranscribeCallAnalyticsProcessorConfiguration != null && {
            AmazonTranscribeCallAnalyticsProcessorConfiguration: se_AmazonTranscribeCallAnalyticsProcessorConfiguration(input.AmazonTranscribeCallAnalyticsProcessorConfiguration, context),
        }),
        ...(input.AmazonTranscribeProcessorConfiguration != null && {
            AmazonTranscribeProcessorConfiguration: se_AmazonTranscribeProcessorConfiguration(input.AmazonTranscribeProcessorConfiguration, context),
        }),
        ...(input.KinesisDataStreamSinkConfiguration != null && {
            KinesisDataStreamSinkConfiguration: se_KinesisDataStreamSinkConfiguration(input.KinesisDataStreamSinkConfiguration, context),
        }),
        ...(input.LambdaFunctionSinkConfiguration != null && {
            LambdaFunctionSinkConfiguration: se_LambdaFunctionSinkConfiguration(input.LambdaFunctionSinkConfiguration, context),
        }),
        ...(input.S3RecordingSinkConfiguration != null && {
            S3RecordingSinkConfiguration: se_S3RecordingSinkConfiguration(input.S3RecordingSinkConfiguration, context),
        }),
        ...(input.SnsTopicSinkConfiguration != null && {
            SnsTopicSinkConfiguration: se_SnsTopicSinkConfiguration(input.SnsTopicSinkConfiguration, context),
        }),
        ...(input.SqsQueueSinkConfiguration != null && {
            SqsQueueSinkConfiguration: se_SqsQueueSinkConfiguration(input.SqsQueueSinkConfiguration, context),
        }),
        ...(input.Type != null && { Type: input.Type }),
        ...(input.VoiceAnalyticsProcessorConfiguration != null && {
            VoiceAnalyticsProcessorConfiguration: se_VoiceAnalyticsProcessorConfiguration(input.VoiceAnalyticsProcessorConfiguration, context),
        }),
    };
};
const se_MediaInsightsPipelineConfigurationElements = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return se_MediaInsightsPipelineConfigurationElement(entry, context);
    });
};
const se_MediaInsightsRuntimeMetadata = (input, context) => {
    return Object.entries(input).reduce((acc, [key, value]) => {
        if (value === null) {
            return acc;
        }
        acc[key] = value;
        return acc;
    }, {});
};
const se_MeetingEventsConcatenationConfiguration = (input, context) => {
    return {
        ...(input.State != null && { State: input.State }),
    };
};
const se_PostCallAnalyticsSettings = (input, context) => {
    return {
        ...(input.ContentRedactionOutput != null && { ContentRedactionOutput: input.ContentRedactionOutput }),
        ...(input.DataAccessRoleArn != null && { DataAccessRoleArn: input.DataAccessRoleArn }),
        ...(input.OutputEncryptionKMSKeyId != null && { OutputEncryptionKMSKeyId: input.OutputEncryptionKMSKeyId }),
        ...(input.OutputLocation != null && { OutputLocation: input.OutputLocation }),
    };
};
const se_PresenterOnlyConfiguration = (input, context) => {
    return {
        ...(input.PresenterPosition != null && { PresenterPosition: input.PresenterPosition }),
    };
};
const se_RealTimeAlertConfiguration = (input, context) => {
    return {
        ...(input.Disabled != null && { Disabled: input.Disabled }),
        ...(input.Rules != null && { Rules: se_RealTimeAlertRuleList(input.Rules, context) }),
    };
};
const se_RealTimeAlertRule = (input, context) => {
    return {
        ...(input.IssueDetectionConfiguration != null && {
            IssueDetectionConfiguration: se_IssueDetectionConfiguration(input.IssueDetectionConfiguration, context),
        }),
        ...(input.KeywordMatchConfiguration != null && {
            KeywordMatchConfiguration: se_KeywordMatchConfiguration(input.KeywordMatchConfiguration, context),
        }),
        ...(input.SentimentConfiguration != null && {
            SentimentConfiguration: se_SentimentConfiguration(input.SentimentConfiguration, context),
        }),
        ...(input.Type != null && { Type: input.Type }),
    };
};
const se_RealTimeAlertRuleList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return se_RealTimeAlertRule(entry, context);
    });
};
const se_RecordingStreamConfiguration = (input, context) => {
    return {
        ...(input.StreamArn != null && { StreamArn: input.StreamArn }),
    };
};
const se_RecordingStreamList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return se_RecordingStreamConfiguration(entry, context);
    });
};
const se_S3BucketSinkConfiguration = (input, context) => {
    return {
        ...(input.Destination != null && { Destination: input.Destination }),
    };
};
const se_S3RecordingSinkConfiguration = (input, context) => {
    return {
        ...(input.Destination != null && { Destination: input.Destination }),
    };
};
const se_S3RecordingSinkRuntimeConfiguration = (input, context) => {
    return {
        ...(input.Destination != null && { Destination: input.Destination }),
        ...(input.RecordingFileFormat != null && { RecordingFileFormat: input.RecordingFileFormat }),
    };
};
const se_SelectedVideoStreams = (input, context) => {
    return {
        ...(input.AttendeeIds != null && { AttendeeIds: se_AttendeeIdList(input.AttendeeIds, context) }),
        ...(input.ExternalUserIds != null && { ExternalUserIds: se_ExternalUserIdList(input.ExternalUserIds, context) }),
    };
};
const se_SentimentConfiguration = (input, context) => {
    return {
        ...(input.RuleName != null && { RuleName: input.RuleName }),
        ...(input.SentimentType != null && { SentimentType: input.SentimentType }),
        ...(input.TimePeriod != null && { TimePeriod: input.TimePeriod }),
    };
};
const se_SnsTopicSinkConfiguration = (input, context) => {
    return {
        ...(input.InsightsTarget != null && { InsightsTarget: input.InsightsTarget }),
    };
};
const se_SourceConfiguration = (input, context) => {
    return {
        ...(input.SelectedVideoStreams != null && {
            SelectedVideoStreams: se_SelectedVideoStreams(input.SelectedVideoStreams, context),
        }),
    };
};
const se_SqsQueueSinkConfiguration = (input, context) => {
    return {
        ...(input.InsightsTarget != null && { InsightsTarget: input.InsightsTarget }),
    };
};
const se_StreamChannelDefinition = (input, context) => {
    return {
        ...(input.ChannelDefinitions != null && {
            ChannelDefinitions: se_ChannelDefinitions(input.ChannelDefinitions, context),
        }),
        ...(input.NumberOfChannels != null && { NumberOfChannels: input.NumberOfChannels }),
    };
};
const se_StreamConfiguration = (input, context) => {
    return {
        ...(input.FragmentNumber != null && { FragmentNumber: input.FragmentNumber }),
        ...(input.StreamArn != null && { StreamArn: input.StreamArn }),
        ...(input.StreamChannelDefinition != null && {
            StreamChannelDefinition: se_StreamChannelDefinition(input.StreamChannelDefinition, context),
        }),
    };
};
const se_Streams = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return se_StreamConfiguration(entry, context);
    });
};
const se_Tag = (input, context) => {
    return {
        ...(input.Key != null && { Key: input.Key }),
        ...(input.Value != null && { Value: input.Value }),
    };
};
const se_TagKeyList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return entry;
    });
};
const se_TagList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        return se_Tag(entry, context);
    });
};
const se_TimestampRange = (input, context) => {
    return {
        ...(input.EndTimestamp != null && { EndTimestamp: Math.round(input.EndTimestamp.getTime() / 1000) }),
        ...(input.StartTimestamp != null && { StartTimestamp: Math.round(input.StartTimestamp.getTime() / 1000) }),
    };
};
const se_TranscriptionMessagesConcatenationConfiguration = (input, context) => {
    return {
        ...(input.State != null && { State: input.State }),
    };
};
const se_VideoArtifactsConfiguration = (input, context) => {
    return {
        ...(input.MuxType != null && { MuxType: input.MuxType }),
        ...(input.State != null && { State: input.State }),
    };
};
const se_VideoConcatenationConfiguration = (input, context) => {
    return {
        ...(input.State != null && { State: input.State }),
    };
};
const se_VoiceAnalyticsProcessorConfiguration = (input, context) => {
    return {
        ...(input.SpeakerSearchStatus != null && { SpeakerSearchStatus: input.SpeakerSearchStatus }),
        ...(input.VoiceToneAnalysisStatus != null && { VoiceToneAnalysisStatus: input.VoiceToneAnalysisStatus }),
    };
};
const de_AmazonTranscribeCallAnalyticsProcessorConfiguration = (output, context) => {
    return {
        CallAnalyticsStreamCategories: output.CallAnalyticsStreamCategories != null
            ? de_CategoryNameList(output.CallAnalyticsStreamCategories, context)
            : undefined,
        ContentIdentificationType: __expectString(output.ContentIdentificationType),
        ContentRedactionType: __expectString(output.ContentRedactionType),
        EnablePartialResultsStabilization: __expectBoolean(output.EnablePartialResultsStabilization),
        FilterPartialResults: __expectBoolean(output.FilterPartialResults),
        LanguageCode: __expectString(output.LanguageCode),
        LanguageModelName: __expectString(output.LanguageModelName),
        PartialResultsStability: __expectString(output.PartialResultsStability),
        PiiEntityTypes: __expectString(output.PiiEntityTypes),
        PostCallAnalyticsSettings: output.PostCallAnalyticsSettings != null
            ? de_PostCallAnalyticsSettings(output.PostCallAnalyticsSettings, context)
            : undefined,
        VocabularyFilterMethod: __expectString(output.VocabularyFilterMethod),
        VocabularyFilterName: __expectString(output.VocabularyFilterName),
        VocabularyName: __expectString(output.VocabularyName),
    };
};
const de_AmazonTranscribeProcessorConfiguration = (output, context) => {
    return {
        ContentIdentificationType: __expectString(output.ContentIdentificationType),
        ContentRedactionType: __expectString(output.ContentRedactionType),
        EnablePartialResultsStabilization: __expectBoolean(output.EnablePartialResultsStabilization),
        FilterPartialResults: __expectBoolean(output.FilterPartialResults),
        LanguageCode: __expectString(output.LanguageCode),
        LanguageModelName: __expectString(output.LanguageModelName),
        PartialResultsStability: __expectString(output.PartialResultsStability),
        PiiEntityTypes: __expectString(output.PiiEntityTypes),
        ShowSpeakerLabel: __expectBoolean(output.ShowSpeakerLabel),
        VocabularyFilterMethod: __expectString(output.VocabularyFilterMethod),
        VocabularyFilterName: __expectString(output.VocabularyFilterName),
        VocabularyName: __expectString(output.VocabularyName),
    };
};
const de_ArtifactsConcatenationConfiguration = (output, context) => {
    return {
        Audio: output.Audio != null ? de_AudioConcatenationConfiguration(output.Audio, context) : undefined,
        CompositedVideo: output.CompositedVideo != null
            ? de_CompositedVideoConcatenationConfiguration(output.CompositedVideo, context)
            : undefined,
        Content: output.Content != null ? de_ContentConcatenationConfiguration(output.Content, context) : undefined,
        DataChannel: output.DataChannel != null ? de_DataChannelConcatenationConfiguration(output.DataChannel, context) : undefined,
        MeetingEvents: output.MeetingEvents != null
            ? de_MeetingEventsConcatenationConfiguration(output.MeetingEvents, context)
            : undefined,
        TranscriptionMessages: output.TranscriptionMessages != null
            ? de_TranscriptionMessagesConcatenationConfiguration(output.TranscriptionMessages, context)
            : undefined,
        Video: output.Video != null ? de_VideoConcatenationConfiguration(output.Video, context) : undefined,
    };
};
const de_ArtifactsConfiguration = (output, context) => {
    return {
        Audio: output.Audio != null ? de_AudioArtifactsConfiguration(output.Audio, context) : undefined,
        CompositedVideo: output.CompositedVideo != null
            ? de_CompositedVideoArtifactsConfiguration(output.CompositedVideo, context)
            : undefined,
        Content: output.Content != null ? de_ContentArtifactsConfiguration(output.Content, context) : undefined,
        Video: output.Video != null ? de_VideoArtifactsConfiguration(output.Video, context) : undefined,
    };
};
const de_AttendeeIdList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return __expectString(entry);
    });
    return retVal;
};
const de_AudioArtifactsConfiguration = (output, context) => {
    return {
        MuxType: __expectString(output.MuxType),
    };
};
const de_AudioConcatenationConfiguration = (output, context) => {
    return {
        State: __expectString(output.State),
    };
};
const de_CategoryNameList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return __expectString(entry);
    });
    return retVal;
};
const de_ChannelDefinition = (output, context) => {
    return {
        ChannelId: __expectInt32(output.ChannelId),
        ParticipantRole: __expectString(output.ParticipantRole),
    };
};
const de_ChannelDefinitions = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return de_ChannelDefinition(entry, context);
    });
    return retVal;
};
const de_ChimeSdkMeetingConcatenationConfiguration = (output, context) => {
    return {
        ArtifactsConfiguration: output.ArtifactsConfiguration != null
            ? de_ArtifactsConcatenationConfiguration(output.ArtifactsConfiguration, context)
            : undefined,
    };
};
const de_ChimeSdkMeetingConfiguration = (output, context) => {
    return {
        ArtifactsConfiguration: output.ArtifactsConfiguration != null
            ? de_ArtifactsConfiguration(output.ArtifactsConfiguration, context)
            : undefined,
        SourceConfiguration: output.SourceConfiguration != null ? de_SourceConfiguration(output.SourceConfiguration, context) : undefined,
    };
};
const de_ChimeSdkMeetingLiveConnectorConfiguration = (output, context) => {
    return {
        Arn: __expectString(output.Arn),
        CompositedVideo: output.CompositedVideo != null
            ? de_CompositedVideoArtifactsConfiguration(output.CompositedVideo, context)
            : undefined,
        MuxType: __expectString(output.MuxType),
        SourceConfiguration: output.SourceConfiguration != null ? de_SourceConfiguration(output.SourceConfiguration, context) : undefined,
    };
};
const de_CompositedVideoArtifactsConfiguration = (output, context) => {
    return {
        GridViewConfiguration: output.GridViewConfiguration != null
            ? de_GridViewConfiguration(output.GridViewConfiguration, context)
            : undefined,
        Layout: __expectString(output.Layout),
        Resolution: __expectString(output.Resolution),
    };
};
const de_CompositedVideoConcatenationConfiguration = (output, context) => {
    return {
        State: __expectString(output.State),
    };
};
const de_ConcatenationSink = (output, context) => {
    return {
        S3BucketSinkConfiguration: output.S3BucketSinkConfiguration != null
            ? de_S3BucketSinkConfiguration(output.S3BucketSinkConfiguration, context)
            : undefined,
        Type: __expectString(output.Type),
    };
};
const de_ConcatenationSinkList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return de_ConcatenationSink(entry, context);
    });
    return retVal;
};
const de_ConcatenationSource = (output, context) => {
    return {
        MediaCapturePipelineSourceConfiguration: output.MediaCapturePipelineSourceConfiguration != null
            ? de_MediaCapturePipelineSourceConfiguration(output.MediaCapturePipelineSourceConfiguration, context)
            : undefined,
        Type: __expectString(output.Type),
    };
};
const de_ConcatenationSourceList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return de_ConcatenationSource(entry, context);
    });
    return retVal;
};
const de_ContentArtifactsConfiguration = (output, context) => {
    return {
        MuxType: __expectString(output.MuxType),
        State: __expectString(output.State),
    };
};
const de_ContentConcatenationConfiguration = (output, context) => {
    return {
        State: __expectString(output.State),
    };
};
const de_DataChannelConcatenationConfiguration = (output, context) => {
    return {
        State: __expectString(output.State),
    };
};
const de_ExternalUserIdList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return __expectString(entry);
    });
    return retVal;
};
const de_FragmentSelector = (output, context) => {
    return {
        FragmentSelectorType: __expectString(output.FragmentSelectorType),
        TimestampRange: output.TimestampRange != null ? de_TimestampRange(output.TimestampRange, context) : undefined,
    };
};
const de_GridViewConfiguration = (output, context) => {
    return {
        ContentShareLayout: __expectString(output.ContentShareLayout),
        PresenterOnlyConfiguration: output.PresenterOnlyConfiguration != null
            ? de_PresenterOnlyConfiguration(output.PresenterOnlyConfiguration, context)
            : undefined,
    };
};
const de_IssueDetectionConfiguration = (output, context) => {
    return {
        RuleName: __expectString(output.RuleName),
    };
};
const de_KeywordMatchConfiguration = (output, context) => {
    return {
        Keywords: output.Keywords != null ? de_KeywordMatchWordList(output.Keywords, context) : undefined,
        Negate: __expectBoolean(output.Negate),
        RuleName: __expectString(output.RuleName),
    };
};
const de_KeywordMatchWordList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return __expectString(entry);
    });
    return retVal;
};
const de_KinesisDataStreamSinkConfiguration = (output, context) => {
    return {
        InsightsTarget: __expectString(output.InsightsTarget),
    };
};
const de_KinesisVideoStreamRecordingSourceRuntimeConfiguration = (output, context) => {
    return {
        FragmentSelector: output.FragmentSelector != null ? de_FragmentSelector(output.FragmentSelector, context) : undefined,
        Streams: output.Streams != null ? de_RecordingStreamList(output.Streams, context) : undefined,
    };
};
const de_KinesisVideoStreamSourceRuntimeConfiguration = (output, context) => {
    return {
        MediaEncoding: __expectString(output.MediaEncoding),
        MediaSampleRate: __expectInt32(output.MediaSampleRate),
        Streams: output.Streams != null ? de_Streams(output.Streams, context) : undefined,
    };
};
const de_LambdaFunctionSinkConfiguration = (output, context) => {
    return {
        InsightsTarget: __expectString(output.InsightsTarget),
    };
};
const de_LiveConnectorRTMPConfiguration = (output, context) => {
    return {
        AudioChannels: __expectString(output.AudioChannels),
        AudioSampleRate: __expectString(output.AudioSampleRate),
        Url: __expectString(output.Url),
    };
};
const de_LiveConnectorSinkConfiguration = (output, context) => {
    return {
        RTMPConfiguration: output.RTMPConfiguration != null
            ? de_LiveConnectorRTMPConfiguration(output.RTMPConfiguration, context)
            : undefined,
        SinkType: __expectString(output.SinkType),
    };
};
const de_LiveConnectorSinkList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return de_LiveConnectorSinkConfiguration(entry, context);
    });
    return retVal;
};
const de_LiveConnectorSourceConfiguration = (output, context) => {
    return {
        ChimeSdkMeetingLiveConnectorConfiguration: output.ChimeSdkMeetingLiveConnectorConfiguration != null
            ? de_ChimeSdkMeetingLiveConnectorConfiguration(output.ChimeSdkMeetingLiveConnectorConfiguration, context)
            : undefined,
        SourceType: __expectString(output.SourceType),
    };
};
const de_LiveConnectorSourceList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return de_LiveConnectorSourceConfiguration(entry, context);
    });
    return retVal;
};
const de_MediaCapturePipeline = (output, context) => {
    return {
        ChimeSdkMeetingConfiguration: output.ChimeSdkMeetingConfiguration != null
            ? de_ChimeSdkMeetingConfiguration(output.ChimeSdkMeetingConfiguration, context)
            : undefined,
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.CreatedTimestamp))
            : undefined,
        MediaPipelineArn: __expectString(output.MediaPipelineArn),
        MediaPipelineId: __expectString(output.MediaPipelineId),
        SinkArn: __expectString(output.SinkArn),
        SinkType: __expectString(output.SinkType),
        SourceArn: __expectString(output.SourceArn),
        SourceType: __expectString(output.SourceType),
        Status: __expectString(output.Status),
        UpdatedTimestamp: output.UpdatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.UpdatedTimestamp))
            : undefined,
    };
};
const de_MediaCapturePipelineSourceConfiguration = (output, context) => {
    return {
        ChimeSdkMeetingConfiguration: output.ChimeSdkMeetingConfiguration != null
            ? de_ChimeSdkMeetingConcatenationConfiguration(output.ChimeSdkMeetingConfiguration, context)
            : undefined,
        MediaPipelineArn: __expectString(output.MediaPipelineArn),
    };
};
const de_MediaCapturePipelineSummary = (output, context) => {
    return {
        MediaPipelineArn: __expectString(output.MediaPipelineArn),
        MediaPipelineId: __expectString(output.MediaPipelineId),
    };
};
const de_MediaCapturePipelineSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return de_MediaCapturePipelineSummary(entry, context);
    });
    return retVal;
};
const de_MediaConcatenationPipeline = (output, context) => {
    return {
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.CreatedTimestamp))
            : undefined,
        MediaPipelineArn: __expectString(output.MediaPipelineArn),
        MediaPipelineId: __expectString(output.MediaPipelineId),
        Sinks: output.Sinks != null ? de_ConcatenationSinkList(output.Sinks, context) : undefined,
        Sources: output.Sources != null ? de_ConcatenationSourceList(output.Sources, context) : undefined,
        Status: __expectString(output.Status),
        UpdatedTimestamp: output.UpdatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.UpdatedTimestamp))
            : undefined,
    };
};
const de_MediaInsightsPipeline = (output, context) => {
    return {
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.CreatedTimestamp))
            : undefined,
        KinesisVideoStreamRecordingSourceRuntimeConfiguration: output.KinesisVideoStreamRecordingSourceRuntimeConfiguration != null
            ? de_KinesisVideoStreamRecordingSourceRuntimeConfiguration(output.KinesisVideoStreamRecordingSourceRuntimeConfiguration, context)
            : undefined,
        KinesisVideoStreamSourceRuntimeConfiguration: output.KinesisVideoStreamSourceRuntimeConfiguration != null
            ? de_KinesisVideoStreamSourceRuntimeConfiguration(output.KinesisVideoStreamSourceRuntimeConfiguration, context)
            : undefined,
        MediaInsightsPipelineConfigurationArn: __expectString(output.MediaInsightsPipelineConfigurationArn),
        MediaInsightsRuntimeMetadata: output.MediaInsightsRuntimeMetadata != null
            ? de_MediaInsightsRuntimeMetadata(output.MediaInsightsRuntimeMetadata, context)
            : undefined,
        MediaPipelineArn: __expectString(output.MediaPipelineArn),
        MediaPipelineId: __expectString(output.MediaPipelineId),
        S3RecordingSinkRuntimeConfiguration: output.S3RecordingSinkRuntimeConfiguration != null
            ? de_S3RecordingSinkRuntimeConfiguration(output.S3RecordingSinkRuntimeConfiguration, context)
            : undefined,
        Status: __expectString(output.Status),
    };
};
const de_MediaInsightsPipelineConfiguration = (output, context) => {
    return {
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.CreatedTimestamp))
            : undefined,
        Elements: output.Elements != null ? de_MediaInsightsPipelineConfigurationElements(output.Elements, context) : undefined,
        MediaInsightsPipelineConfigurationArn: __expectString(output.MediaInsightsPipelineConfigurationArn),
        MediaInsightsPipelineConfigurationId: __expectString(output.MediaInsightsPipelineConfigurationId),
        MediaInsightsPipelineConfigurationName: __expectString(output.MediaInsightsPipelineConfigurationName),
        RealTimeAlertConfiguration: output.RealTimeAlertConfiguration != null
            ? de_RealTimeAlertConfiguration(output.RealTimeAlertConfiguration, context)
            : undefined,
        ResourceAccessRoleArn: __expectString(output.ResourceAccessRoleArn),
        UpdatedTimestamp: output.UpdatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.UpdatedTimestamp))
            : undefined,
    };
};
const de_MediaInsightsPipelineConfigurationElement = (output, context) => {
    return {
        AmazonTranscribeCallAnalyticsProcessorConfiguration: output.AmazonTranscribeCallAnalyticsProcessorConfiguration != null
            ? de_AmazonTranscribeCallAnalyticsProcessorConfiguration(output.AmazonTranscribeCallAnalyticsProcessorConfiguration, context)
            : undefined,
        AmazonTranscribeProcessorConfiguration: output.AmazonTranscribeProcessorConfiguration != null
            ? de_AmazonTranscribeProcessorConfiguration(output.AmazonTranscribeProcessorConfiguration, context)
            : undefined,
        KinesisDataStreamSinkConfiguration: output.KinesisDataStreamSinkConfiguration != null
            ? de_KinesisDataStreamSinkConfiguration(output.KinesisDataStreamSinkConfiguration, context)
            : undefined,
        LambdaFunctionSinkConfiguration: output.LambdaFunctionSinkConfiguration != null
            ? de_LambdaFunctionSinkConfiguration(output.LambdaFunctionSinkConfiguration, context)
            : undefined,
        S3RecordingSinkConfiguration: output.S3RecordingSinkConfiguration != null
            ? de_S3RecordingSinkConfiguration(output.S3RecordingSinkConfiguration, context)
            : undefined,
        SnsTopicSinkConfiguration: output.SnsTopicSinkConfiguration != null
            ? de_SnsTopicSinkConfiguration(output.SnsTopicSinkConfiguration, context)
            : undefined,
        SqsQueueSinkConfiguration: output.SqsQueueSinkConfiguration != null
            ? de_SqsQueueSinkConfiguration(output.SqsQueueSinkConfiguration, context)
            : undefined,
        Type: __expectString(output.Type),
        VoiceAnalyticsProcessorConfiguration: output.VoiceAnalyticsProcessorConfiguration != null
            ? de_VoiceAnalyticsProcessorConfiguration(output.VoiceAnalyticsProcessorConfiguration, context)
            : undefined,
    };
};
const de_MediaInsightsPipelineConfigurationElements = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return de_MediaInsightsPipelineConfigurationElement(entry, context);
    });
    return retVal;
};
const de_MediaInsightsPipelineConfigurationSummary = (output, context) => {
    return {
        MediaInsightsPipelineConfigurationArn: __expectString(output.MediaInsightsPipelineConfigurationArn),
        MediaInsightsPipelineConfigurationId: __expectString(output.MediaInsightsPipelineConfigurationId),
        MediaInsightsPipelineConfigurationName: __expectString(output.MediaInsightsPipelineConfigurationName),
    };
};
const de_MediaInsightsPipelineConfigurationSummaryList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return de_MediaInsightsPipelineConfigurationSummary(entry, context);
    });
    return retVal;
};
const de_MediaInsightsRuntimeMetadata = (output, context) => {
    return Object.entries(output).reduce((acc, [key, value]) => {
        if (value === null) {
            return acc;
        }
        acc[key] = __expectString(value);
        return acc;
    }, {});
};
const de_MediaLiveConnectorPipeline = (output, context) => {
    return {
        CreatedTimestamp: output.CreatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.CreatedTimestamp))
            : undefined,
        MediaPipelineArn: __expectString(output.MediaPipelineArn),
        MediaPipelineId: __expectString(output.MediaPipelineId),
        Sinks: output.Sinks != null ? de_LiveConnectorSinkList(output.Sinks, context) : undefined,
        Sources: output.Sources != null ? de_LiveConnectorSourceList(output.Sources, context) : undefined,
        Status: __expectString(output.Status),
        UpdatedTimestamp: output.UpdatedTimestamp != null
            ? __expectNonNull(__parseRfc3339DateTimeWithOffset(output.UpdatedTimestamp))
            : undefined,
    };
};
const de_MediaPipeline = (output, context) => {
    return {
        MediaCapturePipeline: output.MediaCapturePipeline != null ? de_MediaCapturePipeline(output.MediaCapturePipeline, context) : undefined,
        MediaConcatenationPipeline: output.MediaConcatenationPipeline != null
            ? de_MediaConcatenationPipeline(output.MediaConcatenationPipeline, context)
            : undefined,
        MediaInsightsPipeline: output.MediaInsightsPipeline != null
            ? de_MediaInsightsPipeline(output.MediaInsightsPipeline, context)
            : undefined,
        MediaLiveConnectorPipeline: output.MediaLiveConnectorPipeline != null
            ? de_MediaLiveConnectorPipeline(output.MediaLiveConnectorPipeline, context)
            : undefined,
    };
};
const de_MediaPipelineList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return de_MediaPipelineSummary(entry, context);
    });
    return retVal;
};
const de_MediaPipelineSummary = (output, context) => {
    return {
        MediaPipelineArn: __expectString(output.MediaPipelineArn),
        MediaPipelineId: __expectString(output.MediaPipelineId),
    };
};
const de_MeetingEventsConcatenationConfiguration = (output, context) => {
    return {
        State: __expectString(output.State),
    };
};
const de_PostCallAnalyticsSettings = (output, context) => {
    return {
        ContentRedactionOutput: __expectString(output.ContentRedactionOutput),
        DataAccessRoleArn: __expectString(output.DataAccessRoleArn),
        OutputEncryptionKMSKeyId: __expectString(output.OutputEncryptionKMSKeyId),
        OutputLocation: __expectString(output.OutputLocation),
    };
};
const de_PresenterOnlyConfiguration = (output, context) => {
    return {
        PresenterPosition: __expectString(output.PresenterPosition),
    };
};
const de_RealTimeAlertConfiguration = (output, context) => {
    return {
        Disabled: __expectBoolean(output.Disabled),
        Rules: output.Rules != null ? de_RealTimeAlertRuleList(output.Rules, context) : undefined,
    };
};
const de_RealTimeAlertRule = (output, context) => {
    return {
        IssueDetectionConfiguration: output.IssueDetectionConfiguration != null
            ? de_IssueDetectionConfiguration(output.IssueDetectionConfiguration, context)
            : undefined,
        KeywordMatchConfiguration: output.KeywordMatchConfiguration != null
            ? de_KeywordMatchConfiguration(output.KeywordMatchConfiguration, context)
            : undefined,
        SentimentConfiguration: output.SentimentConfiguration != null
            ? de_SentimentConfiguration(output.SentimentConfiguration, context)
            : undefined,
        Type: __expectString(output.Type),
    };
};
const de_RealTimeAlertRuleList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return de_RealTimeAlertRule(entry, context);
    });
    return retVal;
};
const de_RecordingStreamConfiguration = (output, context) => {
    return {
        StreamArn: __expectString(output.StreamArn),
    };
};
const de_RecordingStreamList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return de_RecordingStreamConfiguration(entry, context);
    });
    return retVal;
};
const de_S3BucketSinkConfiguration = (output, context) => {
    return {
        Destination: __expectString(output.Destination),
    };
};
const de_S3RecordingSinkConfiguration = (output, context) => {
    return {
        Destination: __expectString(output.Destination),
    };
};
const de_S3RecordingSinkRuntimeConfiguration = (output, context) => {
    return {
        Destination: __expectString(output.Destination),
        RecordingFileFormat: __expectString(output.RecordingFileFormat),
    };
};
const de_SelectedVideoStreams = (output, context) => {
    return {
        AttendeeIds: output.AttendeeIds != null ? de_AttendeeIdList(output.AttendeeIds, context) : undefined,
        ExternalUserIds: output.ExternalUserIds != null ? de_ExternalUserIdList(output.ExternalUserIds, context) : undefined,
    };
};
const de_SentimentConfiguration = (output, context) => {
    return {
        RuleName: __expectString(output.RuleName),
        SentimentType: __expectString(output.SentimentType),
        TimePeriod: __expectInt32(output.TimePeriod),
    };
};
const de_SnsTopicSinkConfiguration = (output, context) => {
    return {
        InsightsTarget: __expectString(output.InsightsTarget),
    };
};
const de_SourceConfiguration = (output, context) => {
    return {
        SelectedVideoStreams: output.SelectedVideoStreams != null ? de_SelectedVideoStreams(output.SelectedVideoStreams, context) : undefined,
    };
};
const de_SqsQueueSinkConfiguration = (output, context) => {
    return {
        InsightsTarget: __expectString(output.InsightsTarget),
    };
};
const de_StreamChannelDefinition = (output, context) => {
    return {
        ChannelDefinitions: output.ChannelDefinitions != null ? de_ChannelDefinitions(output.ChannelDefinitions, context) : undefined,
        NumberOfChannels: __expectInt32(output.NumberOfChannels),
    };
};
const de_StreamConfiguration = (output, context) => {
    return {
        FragmentNumber: __expectString(output.FragmentNumber),
        StreamArn: __expectString(output.StreamArn),
        StreamChannelDefinition: output.StreamChannelDefinition != null
            ? de_StreamChannelDefinition(output.StreamChannelDefinition, context)
            : undefined,
    };
};
const de_Streams = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return de_StreamConfiguration(entry, context);
    });
    return retVal;
};
const de_Tag = (output, context) => {
    return {
        Key: __expectString(output.Key),
        Value: __expectString(output.Value),
    };
};
const de_TagList = (output, context) => {
    const retVal = (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        if (entry === null) {
            return null;
        }
        return de_Tag(entry, context);
    });
    return retVal;
};
const de_TimestampRange = (output, context) => {
    return {
        EndTimestamp: output.EndTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.EndTimestamp)))
            : undefined,
        StartTimestamp: output.StartTimestamp != null
            ? __expectNonNull(__parseEpochTimestamp(__expectNumber(output.StartTimestamp)))
            : undefined,
    };
};
const de_TranscriptionMessagesConcatenationConfiguration = (output, context) => {
    return {
        State: __expectString(output.State),
    };
};
const de_VideoArtifactsConfiguration = (output, context) => {
    return {
        MuxType: __expectString(output.MuxType),
        State: __expectString(output.State),
    };
};
const de_VideoConcatenationConfiguration = (output, context) => {
    return {
        State: __expectString(output.State),
    };
};
const de_VoiceAnalyticsProcessorConfiguration = (output, context) => {
    return {
        SpeakerSearchStatus: __expectString(output.SpeakerSearchStatus),
        VoiceToneAnalysisStatus: __expectString(output.VoiceToneAnalysisStatus),
    };
};
const deserializeMetadata = (output) => ({
    httpStatusCode: output.statusCode,
    requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
    extendedRequestId: output.headers["x-amz-id-2"],
    cfId: output.headers["x-amz-cf-id"],
});
const collectBody = (streamBody = new Uint8Array(), context) => {
    if (streamBody instanceof Uint8Array) {
        return Promise.resolve(streamBody);
    }
    return context.streamCollector(streamBody) || Promise.resolve(new Uint8Array());
};
const collectBodyString = (streamBody, context) => collectBody(streamBody, context).then((body) => context.utf8Encoder(body));
const isSerializableHeaderValue = (value) => value !== undefined &&
    value !== null &&
    value !== "" &&
    (!Object.getOwnPropertyNames(value).includes("length") || value.length != 0) &&
    (!Object.getOwnPropertyNames(value).includes("size") || value.size != 0);
const parseBody = (streamBody, context) => collectBodyString(streamBody, context).then((encoded) => {
    if (encoded.length) {
        return JSON.parse(encoded);
    }
    return {};
});
const parseErrorBody = async (errorBody, context) => {
    const value = await parseBody(errorBody, context);
    value.message = value.message ?? value.Message;
    return value;
};
const loadRestJsonErrorCode = (output, data) => {
    const findKey = (object, key) => Object.keys(object).find((k) => k.toLowerCase() === key.toLowerCase());
    const sanitizeErrorCode = (rawValue) => {
        let cleanValue = rawValue;
        if (typeof cleanValue === "number") {
            cleanValue = cleanValue.toString();
        }
        if (cleanValue.indexOf(",") >= 0) {
            cleanValue = cleanValue.split(",")[0];
        }
        if (cleanValue.indexOf(":") >= 0) {
            cleanValue = cleanValue.split(":")[0];
        }
        if (cleanValue.indexOf("#") >= 0) {
            cleanValue = cleanValue.split("#")[1];
        }
        return cleanValue;
    };
    const headerKey = findKey(output.headers, "x-amzn-errortype");
    if (headerKey !== undefined) {
        return sanitizeErrorCode(output.headers[headerKey]);
    }
    if (data.code !== undefined) {
        return sanitizeErrorCode(data.code);
    }
    if (data["__type"] !== undefined) {
        return sanitizeErrorCode(data["__type"]);
    }
};
