import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { ChimeSDKMediaPipelinesClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ChimeSDKMediaPipelinesClient";
import { DeleteMediaInsightsPipelineConfigurationRequest } from "../models/models_0";
/**
 * @public
 *
 * The input for {@link DeleteMediaInsightsPipelineConfigurationCommand}.
 */
export interface DeleteMediaInsightsPipelineConfigurationCommandInput extends DeleteMediaInsightsPipelineConfigurationRequest {
}
/**
 * @public
 *
 * The output of {@link DeleteMediaInsightsPipelineConfigurationCommand}.
 */
export interface DeleteMediaInsightsPipelineConfigurationCommandOutput extends __MetadataBearer {
}
/**
 * @public
 * <p>Deletes the specified configuration settings.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { ChimeSDKMediaPipelinesClient, DeleteMediaInsightsPipelineConfigurationCommand } from "@aws-sdk/client-chime-sdk-media-pipelines"; // ES Modules import
 * // const { ChimeSDKMediaPipelinesClient, DeleteMediaInsightsPipelineConfigurationCommand } = require("@aws-sdk/client-chime-sdk-media-pipelines"); // CommonJS import
 * const client = new ChimeSDKMediaPipelinesClient(config);
 * const input = { // DeleteMediaInsightsPipelineConfigurationRequest
 *   Identifier: "STRING_VALUE", // required
 * };
 * const command = new DeleteMediaInsightsPipelineConfigurationCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @param DeleteMediaInsightsPipelineConfigurationCommandInput - {@link DeleteMediaInsightsPipelineConfigurationCommandInput}
 * @returns {@link DeleteMediaInsightsPipelineConfigurationCommandOutput}
 * @see {@link DeleteMediaInsightsPipelineConfigurationCommandInput} for command's `input` shape.
 * @see {@link DeleteMediaInsightsPipelineConfigurationCommandOutput} for command's `response` shape.
 * @see {@link ChimeSDKMediaPipelinesClientResolvedConfig | config} for ChimeSDKMediaPipelinesClient's `config` shape.
 *
 * @throws {@link BadRequestException} (client fault)
 *  <p>The input parameters don't match the service's restrictions.</p>
 *
 * @throws {@link ConflictException} (client fault)
 *  <p>The request could not be processed because of conflict in the current state of the
 *          resource.</p>
 *
 * @throws {@link ForbiddenException} (client fault)
 *  <p>The client is permanently forbidden from making the request.</p>
 *
 * @throws {@link NotFoundException} (client fault)
 *  <p>One or more of the resources in the request does not exist in the system.</p>
 *
 * @throws {@link ServiceFailureException} (server fault)
 *  <p>The service encountered an unexpected error.</p>
 *
 * @throws {@link ServiceUnavailableException} (server fault)
 *  <p>The service is currently unavailable.</p>
 *
 * @throws {@link ThrottledClientException} (client fault)
 *  <p>The client exceeded its request rate limit.</p>
 *
 * @throws {@link UnauthorizedClientException} (client fault)
 *  <p>The client is not currently authorized to make the request.</p>
 *
 *
 */
export declare class DeleteMediaInsightsPipelineConfigurationCommand extends $Command<DeleteMediaInsightsPipelineConfigurationCommandInput, DeleteMediaInsightsPipelineConfigurationCommandOutput, ChimeSDKMediaPipelinesClientResolvedConfig> {
    readonly input: DeleteMediaInsightsPipelineConfigurationCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: DeleteMediaInsightsPipelineConfigurationCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: ChimeSDKMediaPipelinesClientResolvedConfig, options?: __HttpHandlerOptions): Handler<DeleteMediaInsightsPipelineConfigurationCommandInput, DeleteMediaInsightsPipelineConfigurationCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
