"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateListSubChannels = void 0;
const ChimeSDKMessagingClient_1 = require("../ChimeSDKMessagingClient");
const ListSubChannelsCommand_1 = require("../commands/ListSubChannelsCommand");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListSubChannelsCommand_1.ListSubChannelsCommand(input), ...args);
};
async function* paginateListSubChannels(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof ChimeSDKMessagingClient_1.ChimeSDKMessagingClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected ChimeSDKMessaging | ChimeSDKMessagingClient");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
exports.paginateListSubChannels = paginateListSubChannels;
