import { HttpHandlerOptions as __HttpHandlerOptions } from "@aws-sdk/types";
import { ChimeSDKVoiceClient } from "./ChimeSDKVoiceClient";
import { AssociatePhoneNumbersWithVoiceConnectorCommandInput, AssociatePhoneNumbersWithVoiceConnectorCommandOutput } from "./commands/AssociatePhoneNumbersWithVoiceConnectorCommand";
import { AssociatePhoneNumbersWithVoiceConnectorGroupCommandInput, AssociatePhoneNumbersWithVoiceConnectorGroupCommandOutput } from "./commands/AssociatePhoneNumbersWithVoiceConnectorGroupCommand";
import { BatchDeletePhoneNumberCommandInput, BatchDeletePhoneNumberCommandOutput } from "./commands/BatchDeletePhoneNumberCommand";
import { BatchUpdatePhoneNumberCommandInput, BatchUpdatePhoneNumberCommandOutput } from "./commands/BatchUpdatePhoneNumberCommand";
import { CreatePhoneNumberOrderCommandInput, CreatePhoneNumberOrderCommandOutput } from "./commands/CreatePhoneNumberOrderCommand";
import { CreateProxySessionCommandInput, CreateProxySessionCommandOutput } from "./commands/CreateProxySessionCommand";
import { CreateSipMediaApplicationCallCommandInput, CreateSipMediaApplicationCallCommandOutput } from "./commands/CreateSipMediaApplicationCallCommand";
import { CreateSipMediaApplicationCommandInput, CreateSipMediaApplicationCommandOutput } from "./commands/CreateSipMediaApplicationCommand";
import { CreateSipRuleCommandInput, CreateSipRuleCommandOutput } from "./commands/CreateSipRuleCommand";
import { CreateVoiceConnectorCommandInput, CreateVoiceConnectorCommandOutput } from "./commands/CreateVoiceConnectorCommand";
import { CreateVoiceConnectorGroupCommandInput, CreateVoiceConnectorGroupCommandOutput } from "./commands/CreateVoiceConnectorGroupCommand";
import { CreateVoiceProfileCommandInput, CreateVoiceProfileCommandOutput } from "./commands/CreateVoiceProfileCommand";
import { CreateVoiceProfileDomainCommandInput, CreateVoiceProfileDomainCommandOutput } from "./commands/CreateVoiceProfileDomainCommand";
import { DeletePhoneNumberCommandInput, DeletePhoneNumberCommandOutput } from "./commands/DeletePhoneNumberCommand";
import { DeleteProxySessionCommandInput, DeleteProxySessionCommandOutput } from "./commands/DeleteProxySessionCommand";
import { DeleteSipMediaApplicationCommandInput, DeleteSipMediaApplicationCommandOutput } from "./commands/DeleteSipMediaApplicationCommand";
import { DeleteSipRuleCommandInput, DeleteSipRuleCommandOutput } from "./commands/DeleteSipRuleCommand";
import { DeleteVoiceConnectorCommandInput, DeleteVoiceConnectorCommandOutput } from "./commands/DeleteVoiceConnectorCommand";
import { DeleteVoiceConnectorEmergencyCallingConfigurationCommandInput, DeleteVoiceConnectorEmergencyCallingConfigurationCommandOutput } from "./commands/DeleteVoiceConnectorEmergencyCallingConfigurationCommand";
import { DeleteVoiceConnectorGroupCommandInput, DeleteVoiceConnectorGroupCommandOutput } from "./commands/DeleteVoiceConnectorGroupCommand";
import { DeleteVoiceConnectorOriginationCommandInput, DeleteVoiceConnectorOriginationCommandOutput } from "./commands/DeleteVoiceConnectorOriginationCommand";
import { DeleteVoiceConnectorProxyCommandInput, DeleteVoiceConnectorProxyCommandOutput } from "./commands/DeleteVoiceConnectorProxyCommand";
import { DeleteVoiceConnectorStreamingConfigurationCommandInput, DeleteVoiceConnectorStreamingConfigurationCommandOutput } from "./commands/DeleteVoiceConnectorStreamingConfigurationCommand";
import { DeleteVoiceConnectorTerminationCommandInput, DeleteVoiceConnectorTerminationCommandOutput } from "./commands/DeleteVoiceConnectorTerminationCommand";
import { DeleteVoiceConnectorTerminationCredentialsCommandInput, DeleteVoiceConnectorTerminationCredentialsCommandOutput } from "./commands/DeleteVoiceConnectorTerminationCredentialsCommand";
import { DeleteVoiceProfileCommandInput, DeleteVoiceProfileCommandOutput } from "./commands/DeleteVoiceProfileCommand";
import { DeleteVoiceProfileDomainCommandInput, DeleteVoiceProfileDomainCommandOutput } from "./commands/DeleteVoiceProfileDomainCommand";
import { DisassociatePhoneNumbersFromVoiceConnectorCommandInput, DisassociatePhoneNumbersFromVoiceConnectorCommandOutput } from "./commands/DisassociatePhoneNumbersFromVoiceConnectorCommand";
import { DisassociatePhoneNumbersFromVoiceConnectorGroupCommandInput, DisassociatePhoneNumbersFromVoiceConnectorGroupCommandOutput } from "./commands/DisassociatePhoneNumbersFromVoiceConnectorGroupCommand";
import { GetGlobalSettingsCommandInput, GetGlobalSettingsCommandOutput } from "./commands/GetGlobalSettingsCommand";
import { GetPhoneNumberCommandInput, GetPhoneNumberCommandOutput } from "./commands/GetPhoneNumberCommand";
import { GetPhoneNumberOrderCommandInput, GetPhoneNumberOrderCommandOutput } from "./commands/GetPhoneNumberOrderCommand";
import { GetPhoneNumberSettingsCommandInput, GetPhoneNumberSettingsCommandOutput } from "./commands/GetPhoneNumberSettingsCommand";
import { GetProxySessionCommandInput, GetProxySessionCommandOutput } from "./commands/GetProxySessionCommand";
import { GetSipMediaApplicationAlexaSkillConfigurationCommandInput, GetSipMediaApplicationAlexaSkillConfigurationCommandOutput } from "./commands/GetSipMediaApplicationAlexaSkillConfigurationCommand";
import { GetSipMediaApplicationCommandInput, GetSipMediaApplicationCommandOutput } from "./commands/GetSipMediaApplicationCommand";
import { GetSipMediaApplicationLoggingConfigurationCommandInput, GetSipMediaApplicationLoggingConfigurationCommandOutput } from "./commands/GetSipMediaApplicationLoggingConfigurationCommand";
import { GetSipRuleCommandInput, GetSipRuleCommandOutput } from "./commands/GetSipRuleCommand";
import { GetSpeakerSearchTaskCommandInput, GetSpeakerSearchTaskCommandOutput } from "./commands/GetSpeakerSearchTaskCommand";
import { GetVoiceConnectorCommandInput, GetVoiceConnectorCommandOutput } from "./commands/GetVoiceConnectorCommand";
import { GetVoiceConnectorEmergencyCallingConfigurationCommandInput, GetVoiceConnectorEmergencyCallingConfigurationCommandOutput } from "./commands/GetVoiceConnectorEmergencyCallingConfigurationCommand";
import { GetVoiceConnectorGroupCommandInput, GetVoiceConnectorGroupCommandOutput } from "./commands/GetVoiceConnectorGroupCommand";
import { GetVoiceConnectorLoggingConfigurationCommandInput, GetVoiceConnectorLoggingConfigurationCommandOutput } from "./commands/GetVoiceConnectorLoggingConfigurationCommand";
import { GetVoiceConnectorOriginationCommandInput, GetVoiceConnectorOriginationCommandOutput } from "./commands/GetVoiceConnectorOriginationCommand";
import { GetVoiceConnectorProxyCommandInput, GetVoiceConnectorProxyCommandOutput } from "./commands/GetVoiceConnectorProxyCommand";
import { GetVoiceConnectorStreamingConfigurationCommandInput, GetVoiceConnectorStreamingConfigurationCommandOutput } from "./commands/GetVoiceConnectorStreamingConfigurationCommand";
import { GetVoiceConnectorTerminationCommandInput, GetVoiceConnectorTerminationCommandOutput } from "./commands/GetVoiceConnectorTerminationCommand";
import { GetVoiceConnectorTerminationHealthCommandInput, GetVoiceConnectorTerminationHealthCommandOutput } from "./commands/GetVoiceConnectorTerminationHealthCommand";
import { GetVoiceProfileCommandInput, GetVoiceProfileCommandOutput } from "./commands/GetVoiceProfileCommand";
import { GetVoiceProfileDomainCommandInput, GetVoiceProfileDomainCommandOutput } from "./commands/GetVoiceProfileDomainCommand";
import { GetVoiceToneAnalysisTaskCommandInput, GetVoiceToneAnalysisTaskCommandOutput } from "./commands/GetVoiceToneAnalysisTaskCommand";
import { ListAvailableVoiceConnectorRegionsCommandInput, ListAvailableVoiceConnectorRegionsCommandOutput } from "./commands/ListAvailableVoiceConnectorRegionsCommand";
import { ListPhoneNumberOrdersCommandInput, ListPhoneNumberOrdersCommandOutput } from "./commands/ListPhoneNumberOrdersCommand";
import { ListPhoneNumbersCommandInput, ListPhoneNumbersCommandOutput } from "./commands/ListPhoneNumbersCommand";
import { ListProxySessionsCommandInput, ListProxySessionsCommandOutput } from "./commands/ListProxySessionsCommand";
import { ListSipMediaApplicationsCommandInput, ListSipMediaApplicationsCommandOutput } from "./commands/ListSipMediaApplicationsCommand";
import { ListSipRulesCommandInput, ListSipRulesCommandOutput } from "./commands/ListSipRulesCommand";
import { ListSupportedPhoneNumberCountriesCommandInput, ListSupportedPhoneNumberCountriesCommandOutput } from "./commands/ListSupportedPhoneNumberCountriesCommand";
import { ListTagsForResourceCommandInput, ListTagsForResourceCommandOutput } from "./commands/ListTagsForResourceCommand";
import { ListVoiceConnectorGroupsCommandInput, ListVoiceConnectorGroupsCommandOutput } from "./commands/ListVoiceConnectorGroupsCommand";
import { ListVoiceConnectorsCommandInput, ListVoiceConnectorsCommandOutput } from "./commands/ListVoiceConnectorsCommand";
import { ListVoiceConnectorTerminationCredentialsCommandInput, ListVoiceConnectorTerminationCredentialsCommandOutput } from "./commands/ListVoiceConnectorTerminationCredentialsCommand";
import { ListVoiceProfileDomainsCommandInput, ListVoiceProfileDomainsCommandOutput } from "./commands/ListVoiceProfileDomainsCommand";
import { ListVoiceProfilesCommandInput, ListVoiceProfilesCommandOutput } from "./commands/ListVoiceProfilesCommand";
import { PutSipMediaApplicationAlexaSkillConfigurationCommandInput, PutSipMediaApplicationAlexaSkillConfigurationCommandOutput } from "./commands/PutSipMediaApplicationAlexaSkillConfigurationCommand";
import { PutSipMediaApplicationLoggingConfigurationCommandInput, PutSipMediaApplicationLoggingConfigurationCommandOutput } from "./commands/PutSipMediaApplicationLoggingConfigurationCommand";
import { PutVoiceConnectorEmergencyCallingConfigurationCommandInput, PutVoiceConnectorEmergencyCallingConfigurationCommandOutput } from "./commands/PutVoiceConnectorEmergencyCallingConfigurationCommand";
import { PutVoiceConnectorLoggingConfigurationCommandInput, PutVoiceConnectorLoggingConfigurationCommandOutput } from "./commands/PutVoiceConnectorLoggingConfigurationCommand";
import { PutVoiceConnectorOriginationCommandInput, PutVoiceConnectorOriginationCommandOutput } from "./commands/PutVoiceConnectorOriginationCommand";
import { PutVoiceConnectorProxyCommandInput, PutVoiceConnectorProxyCommandOutput } from "./commands/PutVoiceConnectorProxyCommand";
import { PutVoiceConnectorStreamingConfigurationCommandInput, PutVoiceConnectorStreamingConfigurationCommandOutput } from "./commands/PutVoiceConnectorStreamingConfigurationCommand";
import { PutVoiceConnectorTerminationCommandInput, PutVoiceConnectorTerminationCommandOutput } from "./commands/PutVoiceConnectorTerminationCommand";
import { PutVoiceConnectorTerminationCredentialsCommandInput, PutVoiceConnectorTerminationCredentialsCommandOutput } from "./commands/PutVoiceConnectorTerminationCredentialsCommand";
import { RestorePhoneNumberCommandInput, RestorePhoneNumberCommandOutput } from "./commands/RestorePhoneNumberCommand";
import { SearchAvailablePhoneNumbersCommandInput, SearchAvailablePhoneNumbersCommandOutput } from "./commands/SearchAvailablePhoneNumbersCommand";
import { StartSpeakerSearchTaskCommandInput, StartSpeakerSearchTaskCommandOutput } from "./commands/StartSpeakerSearchTaskCommand";
import { StartVoiceToneAnalysisTaskCommandInput, StartVoiceToneAnalysisTaskCommandOutput } from "./commands/StartVoiceToneAnalysisTaskCommand";
import { StopSpeakerSearchTaskCommandInput, StopSpeakerSearchTaskCommandOutput } from "./commands/StopSpeakerSearchTaskCommand";
import { StopVoiceToneAnalysisTaskCommandInput, StopVoiceToneAnalysisTaskCommandOutput } from "./commands/StopVoiceToneAnalysisTaskCommand";
import { TagResourceCommandInput, TagResourceCommandOutput } from "./commands/TagResourceCommand";
import { UntagResourceCommandInput, UntagResourceCommandOutput } from "./commands/UntagResourceCommand";
import { UpdateGlobalSettingsCommandInput, UpdateGlobalSettingsCommandOutput } from "./commands/UpdateGlobalSettingsCommand";
import { UpdatePhoneNumberCommandInput, UpdatePhoneNumberCommandOutput } from "./commands/UpdatePhoneNumberCommand";
import { UpdatePhoneNumberSettingsCommandInput, UpdatePhoneNumberSettingsCommandOutput } from "./commands/UpdatePhoneNumberSettingsCommand";
import { UpdateProxySessionCommandInput, UpdateProxySessionCommandOutput } from "./commands/UpdateProxySessionCommand";
import { UpdateSipMediaApplicationCallCommandInput, UpdateSipMediaApplicationCallCommandOutput } from "./commands/UpdateSipMediaApplicationCallCommand";
import { UpdateSipMediaApplicationCommandInput, UpdateSipMediaApplicationCommandOutput } from "./commands/UpdateSipMediaApplicationCommand";
import { UpdateSipRuleCommandInput, UpdateSipRuleCommandOutput } from "./commands/UpdateSipRuleCommand";
import { UpdateVoiceConnectorCommandInput, UpdateVoiceConnectorCommandOutput } from "./commands/UpdateVoiceConnectorCommand";
import { UpdateVoiceConnectorGroupCommandInput, UpdateVoiceConnectorGroupCommandOutput } from "./commands/UpdateVoiceConnectorGroupCommand";
import { UpdateVoiceProfileCommandInput, UpdateVoiceProfileCommandOutput } from "./commands/UpdateVoiceProfileCommand";
import { UpdateVoiceProfileDomainCommandInput, UpdateVoiceProfileDomainCommandOutput } from "./commands/UpdateVoiceProfileDomainCommand";
import { ValidateE911AddressCommandInput, ValidateE911AddressCommandOutput } from "./commands/ValidateE911AddressCommand";
/**
 * @public
 * <p>The Amazon Chime SDK telephony APIs in this section enable developers to create PSTN calling solutions that use Amazon Chime SDK Voice Connectors, and Amazon Chime SDK SIP media applications. Developers can
 *           also order and manage phone numbers, create and manage Voice Connectors and SIP media applications, and run voice analytics.</p>
 */
export declare class ChimeSDKVoice extends ChimeSDKVoiceClient {
    /**
     * @public
     * <p>Associates phone numbers with the specified Amazon Chime SDK Voice Connector.</p>
     */
    associatePhoneNumbersWithVoiceConnector(args: AssociatePhoneNumbersWithVoiceConnectorCommandInput, options?: __HttpHandlerOptions): Promise<AssociatePhoneNumbersWithVoiceConnectorCommandOutput>;
    associatePhoneNumbersWithVoiceConnector(args: AssociatePhoneNumbersWithVoiceConnectorCommandInput, cb: (err: any, data?: AssociatePhoneNumbersWithVoiceConnectorCommandOutput) => void): void;
    associatePhoneNumbersWithVoiceConnector(args: AssociatePhoneNumbersWithVoiceConnectorCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: AssociatePhoneNumbersWithVoiceConnectorCommandOutput) => void): void;
    /**
     * @public
     * <p>Associates phone numbers with the specified Amazon Chime SDK Voice Connector group.</p>
     */
    associatePhoneNumbersWithVoiceConnectorGroup(args: AssociatePhoneNumbersWithVoiceConnectorGroupCommandInput, options?: __HttpHandlerOptions): Promise<AssociatePhoneNumbersWithVoiceConnectorGroupCommandOutput>;
    associatePhoneNumbersWithVoiceConnectorGroup(args: AssociatePhoneNumbersWithVoiceConnectorGroupCommandInput, cb: (err: any, data?: AssociatePhoneNumbersWithVoiceConnectorGroupCommandOutput) => void): void;
    associatePhoneNumbersWithVoiceConnectorGroup(args: AssociatePhoneNumbersWithVoiceConnectorGroupCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: AssociatePhoneNumbersWithVoiceConnectorGroupCommandOutput) => void): void;
    /**
     * @public
     * <p>
     *          Moves phone numbers into the
     *          <b>Deletion queue</b>. Phone numbers must be disassociated from any users or Amazon Chime SDK Voice Connectors before they can be deleted.
     *       </p>
     *          <p>
     *          Phone numbers remain in the
     *          <b>Deletion queue</b> for 7 days before they are deleted permanently.
     *       </p>
     */
    batchDeletePhoneNumber(args: BatchDeletePhoneNumberCommandInput, options?: __HttpHandlerOptions): Promise<BatchDeletePhoneNumberCommandOutput>;
    batchDeletePhoneNumber(args: BatchDeletePhoneNumberCommandInput, cb: (err: any, data?: BatchDeletePhoneNumberCommandOutput) => void): void;
    batchDeletePhoneNumber(args: BatchDeletePhoneNumberCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: BatchDeletePhoneNumberCommandOutput) => void): void;
    /**
     * @public
     * <p>Updates one or more phone numbers.</p>
     */
    batchUpdatePhoneNumber(args: BatchUpdatePhoneNumberCommandInput, options?: __HttpHandlerOptions): Promise<BatchUpdatePhoneNumberCommandOutput>;
    batchUpdatePhoneNumber(args: BatchUpdatePhoneNumberCommandInput, cb: (err: any, data?: BatchUpdatePhoneNumberCommandOutput) => void): void;
    batchUpdatePhoneNumber(args: BatchUpdatePhoneNumberCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: BatchUpdatePhoneNumberCommandOutput) => void): void;
    /**
     * @public
     * <p>Creates an order for phone numbers to be provisioned. For numbers outside the U.S., you must use the Amazon Chime SDK SIP media application dial-in product type.</p>
     */
    createPhoneNumberOrder(args: CreatePhoneNumberOrderCommandInput, options?: __HttpHandlerOptions): Promise<CreatePhoneNumberOrderCommandOutput>;
    createPhoneNumberOrder(args: CreatePhoneNumberOrderCommandInput, cb: (err: any, data?: CreatePhoneNumberOrderCommandOutput) => void): void;
    createPhoneNumberOrder(args: CreatePhoneNumberOrderCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreatePhoneNumberOrderCommandOutput) => void): void;
    /**
     * @public
     * <p>Creates a proxy session for the specified Amazon Chime SDK Voice Connector for
     *             the specified participant phone numbers.</p>
     */
    createProxySession(args: CreateProxySessionCommandInput, options?: __HttpHandlerOptions): Promise<CreateProxySessionCommandOutput>;
    createProxySession(args: CreateProxySessionCommandInput, cb: (err: any, data?: CreateProxySessionCommandOutput) => void): void;
    createProxySession(args: CreateProxySessionCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateProxySessionCommandOutput) => void): void;
    /**
     * @public
     * <p>Creates a SIP media application. For more information about SIP media applications, see <a href="https://docs.aws.amazon.com/chime-sdk/latest/ag/manage-sip-applications.html">Managing SIP media applications
     *            and rules</a> in the <i>Amazon Chime SDK Administrator Guide</i>.</p>
     */
    createSipMediaApplication(args: CreateSipMediaApplicationCommandInput, options?: __HttpHandlerOptions): Promise<CreateSipMediaApplicationCommandOutput>;
    createSipMediaApplication(args: CreateSipMediaApplicationCommandInput, cb: (err: any, data?: CreateSipMediaApplicationCommandOutput) => void): void;
    createSipMediaApplication(args: CreateSipMediaApplicationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateSipMediaApplicationCommandOutput) => void): void;
    /**
     * @public
     * <p>Creates an outbound call to a phone number from the phone number specified
     *          in the request, and it invokes the endpoint of the specified
     *          <code>sipMediaApplicationId</code>.</p>
     */
    createSipMediaApplicationCall(args: CreateSipMediaApplicationCallCommandInput, options?: __HttpHandlerOptions): Promise<CreateSipMediaApplicationCallCommandOutput>;
    createSipMediaApplicationCall(args: CreateSipMediaApplicationCallCommandInput, cb: (err: any, data?: CreateSipMediaApplicationCallCommandOutput) => void): void;
    createSipMediaApplicationCall(args: CreateSipMediaApplicationCallCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateSipMediaApplicationCallCommandOutput) => void): void;
    /**
     * @public
     * <p>Creates a SIP rule, which can be used to run a SIP media application as a target for a specific trigger type. For more information about SIP rules, see <a href="https://docs.aws.amazon.com/chime-sdk/latest/ag/manage-sip-applications.html">Managing SIP media applications
     *            and rules</a> in the <i>Amazon Chime SDK Administrator Guide</i>.</p>
     */
    createSipRule(args: CreateSipRuleCommandInput, options?: __HttpHandlerOptions): Promise<CreateSipRuleCommandOutput>;
    createSipRule(args: CreateSipRuleCommandInput, cb: (err: any, data?: CreateSipRuleCommandOutput) => void): void;
    createSipRule(args: CreateSipRuleCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateSipRuleCommandOutput) => void): void;
    /**
     * @public
     * <p>Creates an Amazon Chime SDK Voice Connector. For more information about
     *           Voice Connectors,
     *          see <a href="https://docs.aws.amazon.com/chime-sdk/latest/ag/voice-connector-groups.html">Managing Amazon Chime SDK Voice Connector groups</a> in the <i>Amazon Chime SDK
     *             Administrator Guide</i>.</p>
     */
    createVoiceConnector(args: CreateVoiceConnectorCommandInput, options?: __HttpHandlerOptions): Promise<CreateVoiceConnectorCommandOutput>;
    createVoiceConnector(args: CreateVoiceConnectorCommandInput, cb: (err: any, data?: CreateVoiceConnectorCommandOutput) => void): void;
    createVoiceConnector(args: CreateVoiceConnectorCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateVoiceConnectorCommandOutput) => void): void;
    /**
     * @public
     * <p>Creates an Amazon Chime SDK Voice Connector group under the administrator's
     *          AWS account. You can associate Amazon Chime SDK Voice Connectors with the
     *          Voice Connector group by including <code>VoiceConnectorItems</code> in the
     *          request. </p>
     *          <p>You can include Voice Connectors from different AWS Regions in your group.
     *          This creates a fault tolerant mechanism for fallback in case of availability events.</p>
     */
    createVoiceConnectorGroup(args: CreateVoiceConnectorGroupCommandInput, options?: __HttpHandlerOptions): Promise<CreateVoiceConnectorGroupCommandOutput>;
    createVoiceConnectorGroup(args: CreateVoiceConnectorGroupCommandInput, cb: (err: any, data?: CreateVoiceConnectorGroupCommandOutput) => void): void;
    createVoiceConnectorGroup(args: CreateVoiceConnectorGroupCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateVoiceConnectorGroupCommandOutput) => void): void;
    /**
     * @public
     * <p>Creates a voice profile, which consists of an enrolled user and their latest voice print.</p>
     *          <important>
     *             <p>Before creating any voice profiles, you must provide all notices and obtain all consents from the speaker as required under applicable privacy and biometrics laws, and as required under the
     *          <a href="https://aws.amazon.com/service-terms/">AWS service terms</a> for the Amazon Chime SDK.</p>
     *          </important>
     *          <p>For more information about voice profiles and voice analytics, see <a href="https://docs.aws.amazon.com/chime-sdk/latest/dg/pstn-voice-analytics.html">Using Amazon Chime SDK Voice Analytics</a>
     *       in the <i>Amazon Chime SDK Developer Guide</i>.</p>
     */
    createVoiceProfile(args: CreateVoiceProfileCommandInput, options?: __HttpHandlerOptions): Promise<CreateVoiceProfileCommandOutput>;
    createVoiceProfile(args: CreateVoiceProfileCommandInput, cb: (err: any, data?: CreateVoiceProfileCommandOutput) => void): void;
    createVoiceProfile(args: CreateVoiceProfileCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateVoiceProfileCommandOutput) => void): void;
    /**
     * @public
     * <p>Creates a voice profile domain, a collection of voice profiles, their voice prints, and encrypted enrollment audio.</p>
     *          <important>
     *             <p>Before creating any voice profiles, you must provide all notices and obtain all consents from the speaker as required under applicable privacy and biometrics laws, and as required under the
     *          <a href="https://aws.amazon.com/service-terms/">AWS service terms</a> for the Amazon Chime SDK.</p>
     *          </important>
     *          <p>For more information about voice profile domains, see <a href="https://docs.aws.amazon.com/chime-sdk/latest/dg/pstn-voice-analytics.html">Using Amazon Chime SDK Voice Analytics</a>
     *          in the <i>Amazon Chime SDK Developer Guide</i>.</p>
     */
    createVoiceProfileDomain(args: CreateVoiceProfileDomainCommandInput, options?: __HttpHandlerOptions): Promise<CreateVoiceProfileDomainCommandOutput>;
    createVoiceProfileDomain(args: CreateVoiceProfileDomainCommandInput, cb: (err: any, data?: CreateVoiceProfileDomainCommandOutput) => void): void;
    createVoiceProfileDomain(args: CreateVoiceProfileDomainCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: CreateVoiceProfileDomainCommandOutput) => void): void;
    /**
     * @public
     * <p>Moves the specified phone number into the
     *          <b>Deletion queue</b>. A phone number must
     *          be disassociated from any users or Amazon Chime SDK Voice Connectors before it can be
     *          deleted.</p>
     *          <p>Deleted phone numbers remain in the
     *          <b>Deletion queue</b> queue for 7 days before
     *          they are deleted permanently.</p>
     */
    deletePhoneNumber(args: DeletePhoneNumberCommandInput, options?: __HttpHandlerOptions): Promise<DeletePhoneNumberCommandOutput>;
    deletePhoneNumber(args: DeletePhoneNumberCommandInput, cb: (err: any, data?: DeletePhoneNumberCommandOutput) => void): void;
    deletePhoneNumber(args: DeletePhoneNumberCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeletePhoneNumberCommandOutput) => void): void;
    /**
     * @public
     * <p>Deletes the specified proxy session from the specified Amazon Chime SDK Voice
     *             Connector.</p>
     */
    deleteProxySession(args: DeleteProxySessionCommandInput, options?: __HttpHandlerOptions): Promise<DeleteProxySessionCommandOutput>;
    deleteProxySession(args: DeleteProxySessionCommandInput, cb: (err: any, data?: DeleteProxySessionCommandOutput) => void): void;
    deleteProxySession(args: DeleteProxySessionCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteProxySessionCommandOutput) => void): void;
    /**
     * @public
     * <p>Deletes a SIP media application.</p>
     */
    deleteSipMediaApplication(args: DeleteSipMediaApplicationCommandInput, options?: __HttpHandlerOptions): Promise<DeleteSipMediaApplicationCommandOutput>;
    deleteSipMediaApplication(args: DeleteSipMediaApplicationCommandInput, cb: (err: any, data?: DeleteSipMediaApplicationCommandOutput) => void): void;
    deleteSipMediaApplication(args: DeleteSipMediaApplicationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteSipMediaApplicationCommandOutput) => void): void;
    /**
     * @public
     * <p>Deletes a SIP rule.</p>
     */
    deleteSipRule(args: DeleteSipRuleCommandInput, options?: __HttpHandlerOptions): Promise<DeleteSipRuleCommandOutput>;
    deleteSipRule(args: DeleteSipRuleCommandInput, cb: (err: any, data?: DeleteSipRuleCommandOutput) => void): void;
    deleteSipRule(args: DeleteSipRuleCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteSipRuleCommandOutput) => void): void;
    /**
     * @public
     * <p>Deletes an Amazon Chime SDK Voice Connector. Any phone numbers associated
     *          with the Amazon Chime SDK Voice Connector must be disassociated from it before it
     *          can be deleted.</p>
     */
    deleteVoiceConnector(args: DeleteVoiceConnectorCommandInput, options?: __HttpHandlerOptions): Promise<DeleteVoiceConnectorCommandOutput>;
    deleteVoiceConnector(args: DeleteVoiceConnectorCommandInput, cb: (err: any, data?: DeleteVoiceConnectorCommandOutput) => void): void;
    deleteVoiceConnector(args: DeleteVoiceConnectorCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteVoiceConnectorCommandOutput) => void): void;
    /**
     * @public
     * <p>Deletes the emergency calling details from the specified Amazon Chime SDK Voice
     *          Connector.</p>
     */
    deleteVoiceConnectorEmergencyCallingConfiguration(args: DeleteVoiceConnectorEmergencyCallingConfigurationCommandInput, options?: __HttpHandlerOptions): Promise<DeleteVoiceConnectorEmergencyCallingConfigurationCommandOutput>;
    deleteVoiceConnectorEmergencyCallingConfiguration(args: DeleteVoiceConnectorEmergencyCallingConfigurationCommandInput, cb: (err: any, data?: DeleteVoiceConnectorEmergencyCallingConfigurationCommandOutput) => void): void;
    deleteVoiceConnectorEmergencyCallingConfiguration(args: DeleteVoiceConnectorEmergencyCallingConfigurationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteVoiceConnectorEmergencyCallingConfigurationCommandOutput) => void): void;
    /**
     * @public
     * <p>Deletes an Amazon Chime SDK Voice Connector group. Any <code>VoiceConnectorItems</code>
     *          and phone numbers associated with the group must be removed before it can be
     *          deleted.</p>
     */
    deleteVoiceConnectorGroup(args: DeleteVoiceConnectorGroupCommandInput, options?: __HttpHandlerOptions): Promise<DeleteVoiceConnectorGroupCommandOutput>;
    deleteVoiceConnectorGroup(args: DeleteVoiceConnectorGroupCommandInput, cb: (err: any, data?: DeleteVoiceConnectorGroupCommandOutput) => void): void;
    deleteVoiceConnectorGroup(args: DeleteVoiceConnectorGroupCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteVoiceConnectorGroupCommandOutput) => void): void;
    /**
     * @public
     * <p>Deletes the origination settings for the specified Amazon Chime SDK Voice Connector. </p>
     *          <note>
     *             <p>If emergency calling is configured for the Voice Connector, it must be
     *          deleted prior to deleting the origination settings.</p>
     *          </note>
     */
    deleteVoiceConnectorOrigination(args: DeleteVoiceConnectorOriginationCommandInput, options?: __HttpHandlerOptions): Promise<DeleteVoiceConnectorOriginationCommandOutput>;
    deleteVoiceConnectorOrigination(args: DeleteVoiceConnectorOriginationCommandInput, cb: (err: any, data?: DeleteVoiceConnectorOriginationCommandOutput) => void): void;
    deleteVoiceConnectorOrigination(args: DeleteVoiceConnectorOriginationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteVoiceConnectorOriginationCommandOutput) => void): void;
    /**
     * @public
     * <p>Deletes the proxy configuration from the specified Amazon Chime SDK Voice Connector.</p>
     */
    deleteVoiceConnectorProxy(args: DeleteVoiceConnectorProxyCommandInput, options?: __HttpHandlerOptions): Promise<DeleteVoiceConnectorProxyCommandOutput>;
    deleteVoiceConnectorProxy(args: DeleteVoiceConnectorProxyCommandInput, cb: (err: any, data?: DeleteVoiceConnectorProxyCommandOutput) => void): void;
    deleteVoiceConnectorProxy(args: DeleteVoiceConnectorProxyCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteVoiceConnectorProxyCommandOutput) => void): void;
    /**
     * @public
     * <p>Deletes a Voice Connector's streaming configuration.</p>
     */
    deleteVoiceConnectorStreamingConfiguration(args: DeleteVoiceConnectorStreamingConfigurationCommandInput, options?: __HttpHandlerOptions): Promise<DeleteVoiceConnectorStreamingConfigurationCommandOutput>;
    deleteVoiceConnectorStreamingConfiguration(args: DeleteVoiceConnectorStreamingConfigurationCommandInput, cb: (err: any, data?: DeleteVoiceConnectorStreamingConfigurationCommandOutput) => void): void;
    deleteVoiceConnectorStreamingConfiguration(args: DeleteVoiceConnectorStreamingConfigurationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteVoiceConnectorStreamingConfigurationCommandOutput) => void): void;
    /**
     * @public
     * <p>Deletes the termination settings for the specified Amazon Chime SDK Voice Connector.</p>
     *          <note>
     *             <p>If emergency calling is configured for the Voice Connector, it must be
     *          deleted prior to deleting the termination settings.</p>
     *          </note>
     */
    deleteVoiceConnectorTermination(args: DeleteVoiceConnectorTerminationCommandInput, options?: __HttpHandlerOptions): Promise<DeleteVoiceConnectorTerminationCommandOutput>;
    deleteVoiceConnectorTermination(args: DeleteVoiceConnectorTerminationCommandInput, cb: (err: any, data?: DeleteVoiceConnectorTerminationCommandOutput) => void): void;
    deleteVoiceConnectorTermination(args: DeleteVoiceConnectorTerminationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteVoiceConnectorTerminationCommandOutput) => void): void;
    /**
     * @public
     * <p>Deletes the specified SIP credentials used by your equipment to
     *          authenticate during call termination.</p>
     */
    deleteVoiceConnectorTerminationCredentials(args: DeleteVoiceConnectorTerminationCredentialsCommandInput, options?: __HttpHandlerOptions): Promise<DeleteVoiceConnectorTerminationCredentialsCommandOutput>;
    deleteVoiceConnectorTerminationCredentials(args: DeleteVoiceConnectorTerminationCredentialsCommandInput, cb: (err: any, data?: DeleteVoiceConnectorTerminationCredentialsCommandOutput) => void): void;
    deleteVoiceConnectorTerminationCredentials(args: DeleteVoiceConnectorTerminationCredentialsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteVoiceConnectorTerminationCredentialsCommandOutput) => void): void;
    /**
     * @public
     * <p>Deletes a voice profile, including its voice print and enrollment data. WARNING: This action is not reversible.</p>
     */
    deleteVoiceProfile(args: DeleteVoiceProfileCommandInput, options?: __HttpHandlerOptions): Promise<DeleteVoiceProfileCommandOutput>;
    deleteVoiceProfile(args: DeleteVoiceProfileCommandInput, cb: (err: any, data?: DeleteVoiceProfileCommandOutput) => void): void;
    deleteVoiceProfile(args: DeleteVoiceProfileCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteVoiceProfileCommandOutput) => void): void;
    /**
     * @public
     * <p>Deletes all voice profiles in the domain. WARNING: This action is not reversible.</p>
     */
    deleteVoiceProfileDomain(args: DeleteVoiceProfileDomainCommandInput, options?: __HttpHandlerOptions): Promise<DeleteVoiceProfileDomainCommandOutput>;
    deleteVoiceProfileDomain(args: DeleteVoiceProfileDomainCommandInput, cb: (err: any, data?: DeleteVoiceProfileDomainCommandOutput) => void): void;
    deleteVoiceProfileDomain(args: DeleteVoiceProfileDomainCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DeleteVoiceProfileDomainCommandOutput) => void): void;
    /**
     * @public
     * <p>Disassociates the specified phone numbers from the specified
     *          Amazon Chime SDK Voice Connector.</p>
     */
    disassociatePhoneNumbersFromVoiceConnector(args: DisassociatePhoneNumbersFromVoiceConnectorCommandInput, options?: __HttpHandlerOptions): Promise<DisassociatePhoneNumbersFromVoiceConnectorCommandOutput>;
    disassociatePhoneNumbersFromVoiceConnector(args: DisassociatePhoneNumbersFromVoiceConnectorCommandInput, cb: (err: any, data?: DisassociatePhoneNumbersFromVoiceConnectorCommandOutput) => void): void;
    disassociatePhoneNumbersFromVoiceConnector(args: DisassociatePhoneNumbersFromVoiceConnectorCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DisassociatePhoneNumbersFromVoiceConnectorCommandOutput) => void): void;
    /**
     * @public
     * <p>Disassociates the specified phone numbers from the specified Amazon Chime SDK Voice
     *          Connector group.</p>
     */
    disassociatePhoneNumbersFromVoiceConnectorGroup(args: DisassociatePhoneNumbersFromVoiceConnectorGroupCommandInput, options?: __HttpHandlerOptions): Promise<DisassociatePhoneNumbersFromVoiceConnectorGroupCommandOutput>;
    disassociatePhoneNumbersFromVoiceConnectorGroup(args: DisassociatePhoneNumbersFromVoiceConnectorGroupCommandInput, cb: (err: any, data?: DisassociatePhoneNumbersFromVoiceConnectorGroupCommandOutput) => void): void;
    disassociatePhoneNumbersFromVoiceConnectorGroup(args: DisassociatePhoneNumbersFromVoiceConnectorGroupCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: DisassociatePhoneNumbersFromVoiceConnectorGroupCommandOutput) => void): void;
    /**
     * @public
     * <p>Retrieves the global settings for the Amazon Chime SDK Voice Connectors in an AWS account.</p>
     */
    getGlobalSettings(args: GetGlobalSettingsCommandInput, options?: __HttpHandlerOptions): Promise<GetGlobalSettingsCommandOutput>;
    getGlobalSettings(args: GetGlobalSettingsCommandInput, cb: (err: any, data?: GetGlobalSettingsCommandOutput) => void): void;
    getGlobalSettings(args: GetGlobalSettingsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetGlobalSettingsCommandOutput) => void): void;
    /**
     * @public
     * <p>Retrieves details for the specified phone number ID, such as associations,
     *          capabilities, and product type.</p>
     */
    getPhoneNumber(args: GetPhoneNumberCommandInput, options?: __HttpHandlerOptions): Promise<GetPhoneNumberCommandOutput>;
    getPhoneNumber(args: GetPhoneNumberCommandInput, cb: (err: any, data?: GetPhoneNumberCommandOutput) => void): void;
    getPhoneNumber(args: GetPhoneNumberCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetPhoneNumberCommandOutput) => void): void;
    /**
     * @public
     * <p>Retrieves details for the specified phone number order, such as the order
     *          creation timestamp, phone numbers in E.164 format, product type, and
     *          order status.</p>
     */
    getPhoneNumberOrder(args: GetPhoneNumberOrderCommandInput, options?: __HttpHandlerOptions): Promise<GetPhoneNumberOrderCommandOutput>;
    getPhoneNumberOrder(args: GetPhoneNumberOrderCommandInput, cb: (err: any, data?: GetPhoneNumberOrderCommandOutput) => void): void;
    getPhoneNumberOrder(args: GetPhoneNumberOrderCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetPhoneNumberOrderCommandOutput) => void): void;
    /**
     * @public
     * <p>Retrieves the phone number settings for the administrator's AWS account,
     *          such as the default outbound calling name.</p>
     */
    getPhoneNumberSettings(args: GetPhoneNumberSettingsCommandInput, options?: __HttpHandlerOptions): Promise<GetPhoneNumberSettingsCommandOutput>;
    getPhoneNumberSettings(args: GetPhoneNumberSettingsCommandInput, cb: (err: any, data?: GetPhoneNumberSettingsCommandOutput) => void): void;
    getPhoneNumberSettings(args: GetPhoneNumberSettingsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetPhoneNumberSettingsCommandOutput) => void): void;
    /**
     * @public
     * <p>Retrieves the specified proxy session details for the specified Amazon Chime SDK Voice Connector.</p>
     */
    getProxySession(args: GetProxySessionCommandInput, options?: __HttpHandlerOptions): Promise<GetProxySessionCommandOutput>;
    getProxySession(args: GetProxySessionCommandInput, cb: (err: any, data?: GetProxySessionCommandOutput) => void): void;
    getProxySession(args: GetProxySessionCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetProxySessionCommandOutput) => void): void;
    /**
     * @public
     * <p>Retrieves the information for a SIP media application, including name,
     *          AWS Region, and endpoints.</p>
     */
    getSipMediaApplication(args: GetSipMediaApplicationCommandInput, options?: __HttpHandlerOptions): Promise<GetSipMediaApplicationCommandOutput>;
    getSipMediaApplication(args: GetSipMediaApplicationCommandInput, cb: (err: any, data?: GetSipMediaApplicationCommandOutput) => void): void;
    getSipMediaApplication(args: GetSipMediaApplicationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetSipMediaApplicationCommandOutput) => void): void;
    /**
     * @public
     * <p>Gets the Alexa Skill configuration for the SIP media application.</p>
     */
    getSipMediaApplicationAlexaSkillConfiguration(args: GetSipMediaApplicationAlexaSkillConfigurationCommandInput, options?: __HttpHandlerOptions): Promise<GetSipMediaApplicationAlexaSkillConfigurationCommandOutput>;
    getSipMediaApplicationAlexaSkillConfiguration(args: GetSipMediaApplicationAlexaSkillConfigurationCommandInput, cb: (err: any, data?: GetSipMediaApplicationAlexaSkillConfigurationCommandOutput) => void): void;
    getSipMediaApplicationAlexaSkillConfiguration(args: GetSipMediaApplicationAlexaSkillConfigurationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetSipMediaApplicationAlexaSkillConfigurationCommandOutput) => void): void;
    /**
     * @public
     * <p>Retrieves the logging configuration for the specified SIP media application.</p>
     */
    getSipMediaApplicationLoggingConfiguration(args: GetSipMediaApplicationLoggingConfigurationCommandInput, options?: __HttpHandlerOptions): Promise<GetSipMediaApplicationLoggingConfigurationCommandOutput>;
    getSipMediaApplicationLoggingConfiguration(args: GetSipMediaApplicationLoggingConfigurationCommandInput, cb: (err: any, data?: GetSipMediaApplicationLoggingConfigurationCommandOutput) => void): void;
    getSipMediaApplicationLoggingConfiguration(args: GetSipMediaApplicationLoggingConfigurationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetSipMediaApplicationLoggingConfigurationCommandOutput) => void): void;
    /**
     * @public
     * <p>Retrieves the details of a SIP rule, such as the rule ID, name, triggers, and
     *          target endpoints.</p>
     */
    getSipRule(args: GetSipRuleCommandInput, options?: __HttpHandlerOptions): Promise<GetSipRuleCommandOutput>;
    getSipRule(args: GetSipRuleCommandInput, cb: (err: any, data?: GetSipRuleCommandOutput) => void): void;
    getSipRule(args: GetSipRuleCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetSipRuleCommandOutput) => void): void;
    /**
     * @public
     * <p>Retrieves the details of the specified speaker search task.</p>
     */
    getSpeakerSearchTask(args: GetSpeakerSearchTaskCommandInput, options?: __HttpHandlerOptions): Promise<GetSpeakerSearchTaskCommandOutput>;
    getSpeakerSearchTask(args: GetSpeakerSearchTaskCommandInput, cb: (err: any, data?: GetSpeakerSearchTaskCommandOutput) => void): void;
    getSpeakerSearchTask(args: GetSpeakerSearchTaskCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetSpeakerSearchTaskCommandOutput) => void): void;
    /**
     * @public
     * <p>Retrieves details for the specified Amazon Chime SDK Voice Connector, such as
     *          timestamps,name, outbound host, and encryption requirements.</p>
     */
    getVoiceConnector(args: GetVoiceConnectorCommandInput, options?: __HttpHandlerOptions): Promise<GetVoiceConnectorCommandOutput>;
    getVoiceConnector(args: GetVoiceConnectorCommandInput, cb: (err: any, data?: GetVoiceConnectorCommandOutput) => void): void;
    getVoiceConnector(args: GetVoiceConnectorCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetVoiceConnectorCommandOutput) => void): void;
    /**
     * @public
     * <p>Retrieves the emergency calling configuration details for the specified Voice Connector.</p>
     */
    getVoiceConnectorEmergencyCallingConfiguration(args: GetVoiceConnectorEmergencyCallingConfigurationCommandInput, options?: __HttpHandlerOptions): Promise<GetVoiceConnectorEmergencyCallingConfigurationCommandOutput>;
    getVoiceConnectorEmergencyCallingConfiguration(args: GetVoiceConnectorEmergencyCallingConfigurationCommandInput, cb: (err: any, data?: GetVoiceConnectorEmergencyCallingConfigurationCommandOutput) => void): void;
    getVoiceConnectorEmergencyCallingConfiguration(args: GetVoiceConnectorEmergencyCallingConfigurationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetVoiceConnectorEmergencyCallingConfigurationCommandOutput) => void): void;
    /**
     * @public
     * <p>Retrieves details for the specified Amazon Chime SDK Voice Connector group,
     *          such as timestamps,name, and associated <code>VoiceConnectorItems</code>.</p>
     */
    getVoiceConnectorGroup(args: GetVoiceConnectorGroupCommandInput, options?: __HttpHandlerOptions): Promise<GetVoiceConnectorGroupCommandOutput>;
    getVoiceConnectorGroup(args: GetVoiceConnectorGroupCommandInput, cb: (err: any, data?: GetVoiceConnectorGroupCommandOutput) => void): void;
    getVoiceConnectorGroup(args: GetVoiceConnectorGroupCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetVoiceConnectorGroupCommandOutput) => void): void;
    /**
     * @public
     * <p>Retrieves the logging configuration settings for the specified Voice Connector.
     *          Shows whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.</p>
     */
    getVoiceConnectorLoggingConfiguration(args: GetVoiceConnectorLoggingConfigurationCommandInput, options?: __HttpHandlerOptions): Promise<GetVoiceConnectorLoggingConfigurationCommandOutput>;
    getVoiceConnectorLoggingConfiguration(args: GetVoiceConnectorLoggingConfigurationCommandInput, cb: (err: any, data?: GetVoiceConnectorLoggingConfigurationCommandOutput) => void): void;
    getVoiceConnectorLoggingConfiguration(args: GetVoiceConnectorLoggingConfigurationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetVoiceConnectorLoggingConfigurationCommandOutput) => void): void;
    /**
     * @public
     * <p>Retrieves the origination settings for the specified Voice Connector.</p>
     */
    getVoiceConnectorOrigination(args: GetVoiceConnectorOriginationCommandInput, options?: __HttpHandlerOptions): Promise<GetVoiceConnectorOriginationCommandOutput>;
    getVoiceConnectorOrigination(args: GetVoiceConnectorOriginationCommandInput, cb: (err: any, data?: GetVoiceConnectorOriginationCommandOutput) => void): void;
    getVoiceConnectorOrigination(args: GetVoiceConnectorOriginationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetVoiceConnectorOriginationCommandOutput) => void): void;
    /**
     * @public
     * <p>Retrieves the proxy configuration details for the specified Amazon Chime SDK Voice
     *             Connector.</p>
     */
    getVoiceConnectorProxy(args: GetVoiceConnectorProxyCommandInput, options?: __HttpHandlerOptions): Promise<GetVoiceConnectorProxyCommandOutput>;
    getVoiceConnectorProxy(args: GetVoiceConnectorProxyCommandInput, cb: (err: any, data?: GetVoiceConnectorProxyCommandOutput) => void): void;
    getVoiceConnectorProxy(args: GetVoiceConnectorProxyCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetVoiceConnectorProxyCommandOutput) => void): void;
    /**
     * @public
     * <p>Retrieves the streaming configuration details for the specified Amazon Chime SDK
     *          Voice Connector. Shows whether media streaming is enabled for sending to Amazon
     *          Kinesis. It also shows the retention period, in hours, for the Amazon Kinesis data.</p>
     */
    getVoiceConnectorStreamingConfiguration(args: GetVoiceConnectorStreamingConfigurationCommandInput, options?: __HttpHandlerOptions): Promise<GetVoiceConnectorStreamingConfigurationCommandOutput>;
    getVoiceConnectorStreamingConfiguration(args: GetVoiceConnectorStreamingConfigurationCommandInput, cb: (err: any, data?: GetVoiceConnectorStreamingConfigurationCommandOutput) => void): void;
    getVoiceConnectorStreamingConfiguration(args: GetVoiceConnectorStreamingConfigurationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetVoiceConnectorStreamingConfigurationCommandOutput) => void): void;
    /**
     * @public
     * <p>Retrieves the termination setting details for the specified Voice Connector.</p>
     */
    getVoiceConnectorTermination(args: GetVoiceConnectorTerminationCommandInput, options?: __HttpHandlerOptions): Promise<GetVoiceConnectorTerminationCommandOutput>;
    getVoiceConnectorTermination(args: GetVoiceConnectorTerminationCommandInput, cb: (err: any, data?: GetVoiceConnectorTerminationCommandOutput) => void): void;
    getVoiceConnectorTermination(args: GetVoiceConnectorTerminationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetVoiceConnectorTerminationCommandOutput) => void): void;
    /**
     * @public
     * <p>Retrieves information about the last time a <code>SIP OPTIONS</code> ping
     *          was received from your SIP infrastructure for the specified Amazon Chime SDK Voice
     *          Connector.</p>
     */
    getVoiceConnectorTerminationHealth(args: GetVoiceConnectorTerminationHealthCommandInput, options?: __HttpHandlerOptions): Promise<GetVoiceConnectorTerminationHealthCommandOutput>;
    getVoiceConnectorTerminationHealth(args: GetVoiceConnectorTerminationHealthCommandInput, cb: (err: any, data?: GetVoiceConnectorTerminationHealthCommandOutput) => void): void;
    getVoiceConnectorTerminationHealth(args: GetVoiceConnectorTerminationHealthCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetVoiceConnectorTerminationHealthCommandOutput) => void): void;
    /**
     * @public
     * <p>Retrieves the details of the specified voice profile.</p>
     */
    getVoiceProfile(args: GetVoiceProfileCommandInput, options?: __HttpHandlerOptions): Promise<GetVoiceProfileCommandOutput>;
    getVoiceProfile(args: GetVoiceProfileCommandInput, cb: (err: any, data?: GetVoiceProfileCommandOutput) => void): void;
    getVoiceProfile(args: GetVoiceProfileCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetVoiceProfileCommandOutput) => void): void;
    /**
     * @public
     * <p>Retrieves the details of the specified voice profile domain.</p>
     */
    getVoiceProfileDomain(args: GetVoiceProfileDomainCommandInput, options?: __HttpHandlerOptions): Promise<GetVoiceProfileDomainCommandOutput>;
    getVoiceProfileDomain(args: GetVoiceProfileDomainCommandInput, cb: (err: any, data?: GetVoiceProfileDomainCommandOutput) => void): void;
    getVoiceProfileDomain(args: GetVoiceProfileDomainCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetVoiceProfileDomainCommandOutput) => void): void;
    /**
     * @public
     * <p>Retrieves the details of a voice tone analysis task.</p>
     */
    getVoiceToneAnalysisTask(args: GetVoiceToneAnalysisTaskCommandInput, options?: __HttpHandlerOptions): Promise<GetVoiceToneAnalysisTaskCommandOutput>;
    getVoiceToneAnalysisTask(args: GetVoiceToneAnalysisTaskCommandInput, cb: (err: any, data?: GetVoiceToneAnalysisTaskCommandOutput) => void): void;
    getVoiceToneAnalysisTask(args: GetVoiceToneAnalysisTaskCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: GetVoiceToneAnalysisTaskCommandOutput) => void): void;
    /**
     * @public
     * <p>Lists the available AWS Regions in which you can create an Amazon Chime SDK Voice Connector.</p>
     */
    listAvailableVoiceConnectorRegions(args: ListAvailableVoiceConnectorRegionsCommandInput, options?: __HttpHandlerOptions): Promise<ListAvailableVoiceConnectorRegionsCommandOutput>;
    listAvailableVoiceConnectorRegions(args: ListAvailableVoiceConnectorRegionsCommandInput, cb: (err: any, data?: ListAvailableVoiceConnectorRegionsCommandOutput) => void): void;
    listAvailableVoiceConnectorRegions(args: ListAvailableVoiceConnectorRegionsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListAvailableVoiceConnectorRegionsCommandOutput) => void): void;
    /**
     * @public
     * <p>Lists the phone numbers for an administrator's Amazon Chime SDK account.</p>
     */
    listPhoneNumberOrders(args: ListPhoneNumberOrdersCommandInput, options?: __HttpHandlerOptions): Promise<ListPhoneNumberOrdersCommandOutput>;
    listPhoneNumberOrders(args: ListPhoneNumberOrdersCommandInput, cb: (err: any, data?: ListPhoneNumberOrdersCommandOutput) => void): void;
    listPhoneNumberOrders(args: ListPhoneNumberOrdersCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListPhoneNumberOrdersCommandOutput) => void): void;
    /**
     * @public
     * <p>Lists the phone numbers for the specified Amazon Chime SDK account,
     *          Amazon Chime SDK user, Amazon Chime SDK Voice Connector, or Amazon Chime SDK Voice
     *          Connector group.</p>
     */
    listPhoneNumbers(args: ListPhoneNumbersCommandInput, options?: __HttpHandlerOptions): Promise<ListPhoneNumbersCommandOutput>;
    listPhoneNumbers(args: ListPhoneNumbersCommandInput, cb: (err: any, data?: ListPhoneNumbersCommandOutput) => void): void;
    listPhoneNumbers(args: ListPhoneNumbersCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListPhoneNumbersCommandOutput) => void): void;
    /**
     * @public
     * <p>Lists the proxy sessions for the specified Amazon Chime SDK Voice Connector.</p>
     */
    listProxySessions(args: ListProxySessionsCommandInput, options?: __HttpHandlerOptions): Promise<ListProxySessionsCommandOutput>;
    listProxySessions(args: ListProxySessionsCommandInput, cb: (err: any, data?: ListProxySessionsCommandOutput) => void): void;
    listProxySessions(args: ListProxySessionsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListProxySessionsCommandOutput) => void): void;
    /**
     * @public
     * <p>Lists the SIP media applications  under the administrator's AWS account.</p>
     */
    listSipMediaApplications(args: ListSipMediaApplicationsCommandInput, options?: __HttpHandlerOptions): Promise<ListSipMediaApplicationsCommandOutput>;
    listSipMediaApplications(args: ListSipMediaApplicationsCommandInput, cb: (err: any, data?: ListSipMediaApplicationsCommandOutput) => void): void;
    listSipMediaApplications(args: ListSipMediaApplicationsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListSipMediaApplicationsCommandOutput) => void): void;
    /**
     * @public
     * <p>Lists the SIP rules under the administrator's AWS account.</p>
     */
    listSipRules(args: ListSipRulesCommandInput, options?: __HttpHandlerOptions): Promise<ListSipRulesCommandOutput>;
    listSipRules(args: ListSipRulesCommandInput, cb: (err: any, data?: ListSipRulesCommandOutput) => void): void;
    listSipRules(args: ListSipRulesCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListSipRulesCommandOutput) => void): void;
    /**
     * @public
     * <p>Lists the countries that you can order phone numbers from.</p>
     */
    listSupportedPhoneNumberCountries(args: ListSupportedPhoneNumberCountriesCommandInput, options?: __HttpHandlerOptions): Promise<ListSupportedPhoneNumberCountriesCommandOutput>;
    listSupportedPhoneNumberCountries(args: ListSupportedPhoneNumberCountriesCommandInput, cb: (err: any, data?: ListSupportedPhoneNumberCountriesCommandOutput) => void): void;
    listSupportedPhoneNumberCountries(args: ListSupportedPhoneNumberCountriesCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListSupportedPhoneNumberCountriesCommandOutput) => void): void;
    /**
     * @public
     * <p>Returns a list of the tags in a given resource.</p>
     */
    listTagsForResource(args: ListTagsForResourceCommandInput, options?: __HttpHandlerOptions): Promise<ListTagsForResourceCommandOutput>;
    listTagsForResource(args: ListTagsForResourceCommandInput, cb: (err: any, data?: ListTagsForResourceCommandOutput) => void): void;
    listTagsForResource(args: ListTagsForResourceCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListTagsForResourceCommandOutput) => void): void;
    /**
     * @public
     * <p>Lists the Amazon Chime SDK Voice Connector groups in the administrator's AWS
     *          account.</p>
     */
    listVoiceConnectorGroups(args: ListVoiceConnectorGroupsCommandInput, options?: __HttpHandlerOptions): Promise<ListVoiceConnectorGroupsCommandOutput>;
    listVoiceConnectorGroups(args: ListVoiceConnectorGroupsCommandInput, cb: (err: any, data?: ListVoiceConnectorGroupsCommandOutput) => void): void;
    listVoiceConnectorGroups(args: ListVoiceConnectorGroupsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListVoiceConnectorGroupsCommandOutput) => void): void;
    /**
     * @public
     * <p>Lists the Amazon Chime SDK Voice Connectors in the administrators
     *          AWS account.</p>
     */
    listVoiceConnectors(args: ListVoiceConnectorsCommandInput, options?: __HttpHandlerOptions): Promise<ListVoiceConnectorsCommandOutput>;
    listVoiceConnectors(args: ListVoiceConnectorsCommandInput, cb: (err: any, data?: ListVoiceConnectorsCommandOutput) => void): void;
    listVoiceConnectors(args: ListVoiceConnectorsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListVoiceConnectorsCommandOutput) => void): void;
    /**
     * @public
     * <p>Lists the SIP credentials for the specified Amazon Chime SDK Voice Connector.</p>
     */
    listVoiceConnectorTerminationCredentials(args: ListVoiceConnectorTerminationCredentialsCommandInput, options?: __HttpHandlerOptions): Promise<ListVoiceConnectorTerminationCredentialsCommandOutput>;
    listVoiceConnectorTerminationCredentials(args: ListVoiceConnectorTerminationCredentialsCommandInput, cb: (err: any, data?: ListVoiceConnectorTerminationCredentialsCommandOutput) => void): void;
    listVoiceConnectorTerminationCredentials(args: ListVoiceConnectorTerminationCredentialsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListVoiceConnectorTerminationCredentialsCommandOutput) => void): void;
    /**
     * @public
     * <p>Lists the specified voice profile domains in the administrator's AWS account.
     *          </p>
     */
    listVoiceProfileDomains(args: ListVoiceProfileDomainsCommandInput, options?: __HttpHandlerOptions): Promise<ListVoiceProfileDomainsCommandOutput>;
    listVoiceProfileDomains(args: ListVoiceProfileDomainsCommandInput, cb: (err: any, data?: ListVoiceProfileDomainsCommandOutput) => void): void;
    listVoiceProfileDomains(args: ListVoiceProfileDomainsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListVoiceProfileDomainsCommandOutput) => void): void;
    /**
     * @public
     * <p>Lists the voice profiles in a voice profile domain.</p>
     */
    listVoiceProfiles(args: ListVoiceProfilesCommandInput, options?: __HttpHandlerOptions): Promise<ListVoiceProfilesCommandOutput>;
    listVoiceProfiles(args: ListVoiceProfilesCommandInput, cb: (err: any, data?: ListVoiceProfilesCommandOutput) => void): void;
    listVoiceProfiles(args: ListVoiceProfilesCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ListVoiceProfilesCommandOutput) => void): void;
    /**
     * @public
     * <p>Updates the Alexa Skill configuration for the SIP media application.</p>
     */
    putSipMediaApplicationAlexaSkillConfiguration(args: PutSipMediaApplicationAlexaSkillConfigurationCommandInput, options?: __HttpHandlerOptions): Promise<PutSipMediaApplicationAlexaSkillConfigurationCommandOutput>;
    putSipMediaApplicationAlexaSkillConfiguration(args: PutSipMediaApplicationAlexaSkillConfigurationCommandInput, cb: (err: any, data?: PutSipMediaApplicationAlexaSkillConfigurationCommandOutput) => void): void;
    putSipMediaApplicationAlexaSkillConfiguration(args: PutSipMediaApplicationAlexaSkillConfigurationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: PutSipMediaApplicationAlexaSkillConfigurationCommandOutput) => void): void;
    /**
     * @public
     * <p>Updates the logging configuration for the specified SIP media application.</p>
     */
    putSipMediaApplicationLoggingConfiguration(args: PutSipMediaApplicationLoggingConfigurationCommandInput, options?: __HttpHandlerOptions): Promise<PutSipMediaApplicationLoggingConfigurationCommandOutput>;
    putSipMediaApplicationLoggingConfiguration(args: PutSipMediaApplicationLoggingConfigurationCommandInput, cb: (err: any, data?: PutSipMediaApplicationLoggingConfigurationCommandOutput) => void): void;
    putSipMediaApplicationLoggingConfiguration(args: PutSipMediaApplicationLoggingConfigurationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: PutSipMediaApplicationLoggingConfigurationCommandOutput) => void): void;
    /**
     * @public
     * <p>Updates a Voice Connector's emergency calling configuration.</p>
     */
    putVoiceConnectorEmergencyCallingConfiguration(args: PutVoiceConnectorEmergencyCallingConfigurationCommandInput, options?: __HttpHandlerOptions): Promise<PutVoiceConnectorEmergencyCallingConfigurationCommandOutput>;
    putVoiceConnectorEmergencyCallingConfiguration(args: PutVoiceConnectorEmergencyCallingConfigurationCommandInput, cb: (err: any, data?: PutVoiceConnectorEmergencyCallingConfigurationCommandOutput) => void): void;
    putVoiceConnectorEmergencyCallingConfiguration(args: PutVoiceConnectorEmergencyCallingConfigurationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: PutVoiceConnectorEmergencyCallingConfigurationCommandOutput) => void): void;
    /**
     * @public
     * <p>Updates a Voice Connector's logging configuration.</p>
     */
    putVoiceConnectorLoggingConfiguration(args: PutVoiceConnectorLoggingConfigurationCommandInput, options?: __HttpHandlerOptions): Promise<PutVoiceConnectorLoggingConfigurationCommandOutput>;
    putVoiceConnectorLoggingConfiguration(args: PutVoiceConnectorLoggingConfigurationCommandInput, cb: (err: any, data?: PutVoiceConnectorLoggingConfigurationCommandOutput) => void): void;
    putVoiceConnectorLoggingConfiguration(args: PutVoiceConnectorLoggingConfigurationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: PutVoiceConnectorLoggingConfigurationCommandOutput) => void): void;
    /**
     * @public
     * <p>Updates a Voice Connector's origination settings.</p>
     */
    putVoiceConnectorOrigination(args: PutVoiceConnectorOriginationCommandInput, options?: __HttpHandlerOptions): Promise<PutVoiceConnectorOriginationCommandOutput>;
    putVoiceConnectorOrigination(args: PutVoiceConnectorOriginationCommandInput, cb: (err: any, data?: PutVoiceConnectorOriginationCommandOutput) => void): void;
    putVoiceConnectorOrigination(args: PutVoiceConnectorOriginationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: PutVoiceConnectorOriginationCommandOutput) => void): void;
    /**
     * @public
     * <p>Puts the specified proxy configuration to the specified Amazon Chime SDK Voice Connector.</p>
     */
    putVoiceConnectorProxy(args: PutVoiceConnectorProxyCommandInput, options?: __HttpHandlerOptions): Promise<PutVoiceConnectorProxyCommandOutput>;
    putVoiceConnectorProxy(args: PutVoiceConnectorProxyCommandInput, cb: (err: any, data?: PutVoiceConnectorProxyCommandOutput) => void): void;
    putVoiceConnectorProxy(args: PutVoiceConnectorProxyCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: PutVoiceConnectorProxyCommandOutput) => void): void;
    /**
     * @public
     * <p>Updates a Voice Connector's streaming configuration settings.</p>
     */
    putVoiceConnectorStreamingConfiguration(args: PutVoiceConnectorStreamingConfigurationCommandInput, options?: __HttpHandlerOptions): Promise<PutVoiceConnectorStreamingConfigurationCommandOutput>;
    putVoiceConnectorStreamingConfiguration(args: PutVoiceConnectorStreamingConfigurationCommandInput, cb: (err: any, data?: PutVoiceConnectorStreamingConfigurationCommandOutput) => void): void;
    putVoiceConnectorStreamingConfiguration(args: PutVoiceConnectorStreamingConfigurationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: PutVoiceConnectorStreamingConfigurationCommandOutput) => void): void;
    /**
     * @public
     * <p>Updates a Voice Connector's termination settings.</p>
     */
    putVoiceConnectorTermination(args: PutVoiceConnectorTerminationCommandInput, options?: __HttpHandlerOptions): Promise<PutVoiceConnectorTerminationCommandOutput>;
    putVoiceConnectorTermination(args: PutVoiceConnectorTerminationCommandInput, cb: (err: any, data?: PutVoiceConnectorTerminationCommandOutput) => void): void;
    putVoiceConnectorTermination(args: PutVoiceConnectorTerminationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: PutVoiceConnectorTerminationCommandOutput) => void): void;
    /**
     * @public
     * <p>Updates a Voice Connector's termination credentials.</p>
     */
    putVoiceConnectorTerminationCredentials(args: PutVoiceConnectorTerminationCredentialsCommandInput, options?: __HttpHandlerOptions): Promise<PutVoiceConnectorTerminationCredentialsCommandOutput>;
    putVoiceConnectorTerminationCredentials(args: PutVoiceConnectorTerminationCredentialsCommandInput, cb: (err: any, data?: PutVoiceConnectorTerminationCredentialsCommandOutput) => void): void;
    putVoiceConnectorTerminationCredentials(args: PutVoiceConnectorTerminationCredentialsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: PutVoiceConnectorTerminationCredentialsCommandOutput) => void): void;
    /**
     * @public
     * <p>Restores a deleted phone number.</p>
     */
    restorePhoneNumber(args: RestorePhoneNumberCommandInput, options?: __HttpHandlerOptions): Promise<RestorePhoneNumberCommandOutput>;
    restorePhoneNumber(args: RestorePhoneNumberCommandInput, cb: (err: any, data?: RestorePhoneNumberCommandOutput) => void): void;
    restorePhoneNumber(args: RestorePhoneNumberCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: RestorePhoneNumberCommandOutput) => void): void;
    /**
     * @public
     * <p>Searches the provisioned phone numbers in an organization.</p>
     */
    searchAvailablePhoneNumbers(args: SearchAvailablePhoneNumbersCommandInput, options?: __HttpHandlerOptions): Promise<SearchAvailablePhoneNumbersCommandOutput>;
    searchAvailablePhoneNumbers(args: SearchAvailablePhoneNumbersCommandInput, cb: (err: any, data?: SearchAvailablePhoneNumbersCommandOutput) => void): void;
    searchAvailablePhoneNumbers(args: SearchAvailablePhoneNumbersCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: SearchAvailablePhoneNumbersCommandOutput) => void): void;
    /**
     * @public
     * <p>Starts a speaker search task.</p>
     *          <important>
     *             <p>Before starting any speaker search tasks, you must provide all notices and obtain all consents from the speaker as required under applicable privacy and biometrics laws, and as required under the
     *          <a href="https://aws.amazon.com/service-terms/">AWS service terms</a> for the Amazon Chime SDK.</p>
     *          </important>
     */
    startSpeakerSearchTask(args: StartSpeakerSearchTaskCommandInput, options?: __HttpHandlerOptions): Promise<StartSpeakerSearchTaskCommandOutput>;
    startSpeakerSearchTask(args: StartSpeakerSearchTaskCommandInput, cb: (err: any, data?: StartSpeakerSearchTaskCommandOutput) => void): void;
    startSpeakerSearchTask(args: StartSpeakerSearchTaskCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: StartSpeakerSearchTaskCommandOutput) => void): void;
    /**
     * @public
     * <p>Starts a voice tone analysis task. For more information about voice tone analysis, see
     *          <a href="https://docs.aws.amazon.com/chime-sdk/latest/dg/pstn-voice-analytics.html">Using Amazon Chime SDK voice analytics</a>
     *          in the <i>Amazon Chime SDK Developer Guide</i>.</p>
     *          <important>
     *             <p>Before starting any voice tone analysis tasks, you must provide all notices and obtain all consents from the speaker as required under applicable privacy and biometrics laws, and as required under the
     *          <a href="https://aws.amazon.com/service-terms/">AWS service terms</a> for the Amazon Chime SDK.</p>
     *          </important>
     */
    startVoiceToneAnalysisTask(args: StartVoiceToneAnalysisTaskCommandInput, options?: __HttpHandlerOptions): Promise<StartVoiceToneAnalysisTaskCommandOutput>;
    startVoiceToneAnalysisTask(args: StartVoiceToneAnalysisTaskCommandInput, cb: (err: any, data?: StartVoiceToneAnalysisTaskCommandOutput) => void): void;
    startVoiceToneAnalysisTask(args: StartVoiceToneAnalysisTaskCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: StartVoiceToneAnalysisTaskCommandOutput) => void): void;
    /**
     * @public
     * <p>Stops a speaker search task.</p>
     */
    stopSpeakerSearchTask(args: StopSpeakerSearchTaskCommandInput, options?: __HttpHandlerOptions): Promise<StopSpeakerSearchTaskCommandOutput>;
    stopSpeakerSearchTask(args: StopSpeakerSearchTaskCommandInput, cb: (err: any, data?: StopSpeakerSearchTaskCommandOutput) => void): void;
    stopSpeakerSearchTask(args: StopSpeakerSearchTaskCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: StopSpeakerSearchTaskCommandOutput) => void): void;
    /**
     * @public
     * <p>Stops a voice tone analysis task.</p>
     */
    stopVoiceToneAnalysisTask(args: StopVoiceToneAnalysisTaskCommandInput, options?: __HttpHandlerOptions): Promise<StopVoiceToneAnalysisTaskCommandOutput>;
    stopVoiceToneAnalysisTask(args: StopVoiceToneAnalysisTaskCommandInput, cb: (err: any, data?: StopVoiceToneAnalysisTaskCommandOutput) => void): void;
    stopVoiceToneAnalysisTask(args: StopVoiceToneAnalysisTaskCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: StopVoiceToneAnalysisTaskCommandOutput) => void): void;
    /**
     * @public
     * <p>Adds a tag to the specified resource.</p>
     */
    tagResource(args: TagResourceCommandInput, options?: __HttpHandlerOptions): Promise<TagResourceCommandOutput>;
    tagResource(args: TagResourceCommandInput, cb: (err: any, data?: TagResourceCommandOutput) => void): void;
    tagResource(args: TagResourceCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: TagResourceCommandOutput) => void): void;
    /**
     * @public
     * <p>Removes tags from a resource.</p>
     */
    untagResource(args: UntagResourceCommandInput, options?: __HttpHandlerOptions): Promise<UntagResourceCommandOutput>;
    untagResource(args: UntagResourceCommandInput, cb: (err: any, data?: UntagResourceCommandOutput) => void): void;
    untagResource(args: UntagResourceCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UntagResourceCommandOutput) => void): void;
    /**
     * @public
     * <p>Updates global settings for the Amazon Chime SDK Voice Connectors in an AWS account.</p>
     */
    updateGlobalSettings(args: UpdateGlobalSettingsCommandInput, options?: __HttpHandlerOptions): Promise<UpdateGlobalSettingsCommandOutput>;
    updateGlobalSettings(args: UpdateGlobalSettingsCommandInput, cb: (err: any, data?: UpdateGlobalSettingsCommandOutput) => void): void;
    updateGlobalSettings(args: UpdateGlobalSettingsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateGlobalSettingsCommandOutput) => void): void;
    /**
     * @public
     * <p>Updates phone number details, such as product type or calling name, for the
     *          specified phone number ID. You can update one phone number detail at a time. For
     *          example, you can update either the product type or the calling name in one action.</p>
     *          <p>For numbers outside the U.S., you must use the Amazon Chime SDK SIP Media
     *          Application Dial-In product type.</p>
     *          <p>Updates to outbound calling names can take 72 hours to complete. Pending
     *          updates to outbound calling names must be complete before you can request another
     *          update.</p>
     */
    updatePhoneNumber(args: UpdatePhoneNumberCommandInput, options?: __HttpHandlerOptions): Promise<UpdatePhoneNumberCommandOutput>;
    updatePhoneNumber(args: UpdatePhoneNumberCommandInput, cb: (err: any, data?: UpdatePhoneNumberCommandOutput) => void): void;
    updatePhoneNumber(args: UpdatePhoneNumberCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdatePhoneNumberCommandOutput) => void): void;
    /**
     * @public
     * <p>Updates the phone number settings for the administrator's AWS account, such
     *          as the default outbound calling name. You can update the default outbound calling
     *          name once every seven days. Outbound calling names can take up to 72 hours to
     *          update.</p>
     */
    updatePhoneNumberSettings(args: UpdatePhoneNumberSettingsCommandInput, options?: __HttpHandlerOptions): Promise<UpdatePhoneNumberSettingsCommandOutput>;
    updatePhoneNumberSettings(args: UpdatePhoneNumberSettingsCommandInput, cb: (err: any, data?: UpdatePhoneNumberSettingsCommandOutput) => void): void;
    updatePhoneNumberSettings(args: UpdatePhoneNumberSettingsCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdatePhoneNumberSettingsCommandOutput) => void): void;
    /**
     * @public
     * <p>Updates the specified proxy session details, such as voice or SMS capabilities.</p>
     */
    updateProxySession(args: UpdateProxySessionCommandInput, options?: __HttpHandlerOptions): Promise<UpdateProxySessionCommandOutput>;
    updateProxySession(args: UpdateProxySessionCommandInput, cb: (err: any, data?: UpdateProxySessionCommandOutput) => void): void;
    updateProxySession(args: UpdateProxySessionCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateProxySessionCommandOutput) => void): void;
    /**
     * @public
     * <p>Updates the details of the specified SIP media application.</p>
     */
    updateSipMediaApplication(args: UpdateSipMediaApplicationCommandInput, options?: __HttpHandlerOptions): Promise<UpdateSipMediaApplicationCommandOutput>;
    updateSipMediaApplication(args: UpdateSipMediaApplicationCommandInput, cb: (err: any, data?: UpdateSipMediaApplicationCommandOutput) => void): void;
    updateSipMediaApplication(args: UpdateSipMediaApplicationCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateSipMediaApplicationCommandOutput) => void): void;
    /**
     * @public
     * <p>Invokes the AWS Lambda function associated with the SIP media application and
     *          transaction ID in an update request. The Lambda function can then return a new set
     *          of actions.</p>
     */
    updateSipMediaApplicationCall(args: UpdateSipMediaApplicationCallCommandInput, options?: __HttpHandlerOptions): Promise<UpdateSipMediaApplicationCallCommandOutput>;
    updateSipMediaApplicationCall(args: UpdateSipMediaApplicationCallCommandInput, cb: (err: any, data?: UpdateSipMediaApplicationCallCommandOutput) => void): void;
    updateSipMediaApplicationCall(args: UpdateSipMediaApplicationCallCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateSipMediaApplicationCallCommandOutput) => void): void;
    /**
     * @public
     * <p>Updates the details of the specified SIP rule.</p>
     */
    updateSipRule(args: UpdateSipRuleCommandInput, options?: __HttpHandlerOptions): Promise<UpdateSipRuleCommandOutput>;
    updateSipRule(args: UpdateSipRuleCommandInput, cb: (err: any, data?: UpdateSipRuleCommandOutput) => void): void;
    updateSipRule(args: UpdateSipRuleCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateSipRuleCommandOutput) => void): void;
    /**
     * @public
     * <p>Updates the details for the specified Amazon Chime SDK Voice Connector.</p>
     */
    updateVoiceConnector(args: UpdateVoiceConnectorCommandInput, options?: __HttpHandlerOptions): Promise<UpdateVoiceConnectorCommandOutput>;
    updateVoiceConnector(args: UpdateVoiceConnectorCommandInput, cb: (err: any, data?: UpdateVoiceConnectorCommandOutput) => void): void;
    updateVoiceConnector(args: UpdateVoiceConnectorCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateVoiceConnectorCommandOutput) => void): void;
    /**
     * @public
     * <p>Updates the settings for the specified Amazon Chime SDK Voice Connector group.</p>
     */
    updateVoiceConnectorGroup(args: UpdateVoiceConnectorGroupCommandInput, options?: __HttpHandlerOptions): Promise<UpdateVoiceConnectorGroupCommandOutput>;
    updateVoiceConnectorGroup(args: UpdateVoiceConnectorGroupCommandInput, cb: (err: any, data?: UpdateVoiceConnectorGroupCommandOutput) => void): void;
    updateVoiceConnectorGroup(args: UpdateVoiceConnectorGroupCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateVoiceConnectorGroupCommandOutput) => void): void;
    /**
     * @public
     * <p>Updates the specified voice profile’s voice print and refreshes its expiration timestamp.</p>
     *          <important>
     *             <p>As a condition of using this feature, you acknowledge that the collection, use, storage, and retention of
     *             your caller’s biometric identifiers and biometric information (“biometric data”) in the form of a digital voiceprint
     *             requires the caller’s informed consent via a written release. Such consent is required under various state laws,
     *             including biometrics laws in Illinois, Texas, Washington and other state privacy laws.</p>
     *             <p>You must provide a written release to each caller through a process that clearly reflects each caller’s informed
     *             consent before using Amazon Chime SDK Voice Insights service, as required under the terms of your agreement
     *             with AWS governing your use of the service.</p>
     *          </important>
     */
    updateVoiceProfile(args: UpdateVoiceProfileCommandInput, options?: __HttpHandlerOptions): Promise<UpdateVoiceProfileCommandOutput>;
    updateVoiceProfile(args: UpdateVoiceProfileCommandInput, cb: (err: any, data?: UpdateVoiceProfileCommandOutput) => void): void;
    updateVoiceProfile(args: UpdateVoiceProfileCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateVoiceProfileCommandOutput) => void): void;
    /**
     * @public
     * <p>Updates the settings for the specified voice profile domain.</p>
     */
    updateVoiceProfileDomain(args: UpdateVoiceProfileDomainCommandInput, options?: __HttpHandlerOptions): Promise<UpdateVoiceProfileDomainCommandOutput>;
    updateVoiceProfileDomain(args: UpdateVoiceProfileDomainCommandInput, cb: (err: any, data?: UpdateVoiceProfileDomainCommandOutput) => void): void;
    updateVoiceProfileDomain(args: UpdateVoiceProfileDomainCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: UpdateVoiceProfileDomainCommandOutput) => void): void;
    /**
     * @public
     * <p>Validates an address to be used for 911 calls made with Amazon Chime SDK Voice
     *          Connectors. You can use validated addresses in a Presence Information Data Format
     *          Location Object file that you include in SIP requests. That helps ensure that addresses
     *          are routed to the appropriate Public Safety Answering Point.</p>
     */
    validateE911Address(args: ValidateE911AddressCommandInput, options?: __HttpHandlerOptions): Promise<ValidateE911AddressCommandOutput>;
    validateE911Address(args: ValidateE911AddressCommandInput, cb: (err: any, data?: ValidateE911AddressCommandOutput) => void): void;
    validateE911Address(args: ValidateE911AddressCommandInput, options: __HttpHandlerOptions, cb: (err: any, data?: ValidateE911AddressCommandOutput) => void): void;
}
