# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['CloudIntegrationGcpArgs', 'CloudIntegrationGcp']

@pulumi.input_type
class CloudIntegrationGcpArgs:
    def __init__(__self__, *,
                 json_key: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 service: pulumi.Input[str],
                 additional_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 force_save: Optional[pulumi.Input[bool]] = None,
                 metric_filter_regex: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 service_refresh_rate_in_minutes: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a CloudIntegrationGcp resource.
        :param pulumi.Input[str] json_key: Private key for a Google Cloud Platform (GCP) service account within your project.
               The account must be at least granted Monitoring Viewer permissions. This key must be in the JSON format generated by GCP.
        :param pulumi.Input[str] project_id: The Google Cloud Platform (GCP) Project Id
        :param pulumi.Input[str] service: A value denoting which cloud service this service integrates with
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] additional_tags: A list of point tag key-values to add to every point ingested using this integration
        :param pulumi.Input[Sequence[pulumi.Input[str]]] categories: A list of Google Cloud Platform (GCP) services.  Valid values are `APPENGINE`, 
               `BIGQUERY`, `BIGTABLE`, `CLOUDFUNCTIONS`, `CLOUDIOT`, `CLOUDSQL`, `CLOUDTASKS`, `COMPUTE`, `CONTAINER`,
               `DATAFLOW`, `DATAPROC`, `DATASTORE`, `FIREBASEDATABASE`, `FIREBASEHOSTING`, `FIRESTORE`, `INTERCONNECT`,
               `LOADBALANCING`, `LOGGING`, `ML`, `MONITORING`, `PUBSUB`, `REDIS`, `ROUTER`, `SERVICERUNTIME`, `SPANNER`, `STORAGE`,
               `TPU`, `VPN`
        :param pulumi.Input[bool] force_save: Forces this resource to save, even if errors are present
        :param pulumi.Input[str] metric_filter_regex: A regular expression that a metric name must match (case-insensitively) in order to be ingested
        :param pulumi.Input[str] name: The human-readable name of this integration
        :param pulumi.Input[int] service_refresh_rate_in_minutes: How often, in minutes, to refresh the service
        """
        pulumi.set(__self__, "json_key", json_key)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "service", service)
        if additional_tags is not None:
            pulumi.set(__self__, "additional_tags", additional_tags)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if force_save is not None:
            pulumi.set(__self__, "force_save", force_save)
        if metric_filter_regex is not None:
            pulumi.set(__self__, "metric_filter_regex", metric_filter_regex)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_refresh_rate_in_minutes is not None:
            pulumi.set(__self__, "service_refresh_rate_in_minutes", service_refresh_rate_in_minutes)

    @property
    @pulumi.getter(name="jsonKey")
    def json_key(self) -> pulumi.Input[str]:
        """
        Private key for a Google Cloud Platform (GCP) service account within your project.
        The account must be at least granted Monitoring Viewer permissions. This key must be in the JSON format generated by GCP.
        """
        return pulumi.get(self, "json_key")

    @json_key.setter
    def json_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "json_key", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The Google Cloud Platform (GCP) Project Id
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[str]:
        """
        A value denoting which cloud service this service integrates with
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[str]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="additionalTags")
    def additional_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A list of point tag key-values to add to every point ingested using this integration
        """
        return pulumi.get(self, "additional_tags")

    @additional_tags.setter
    def additional_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "additional_tags", value)

    @property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of Google Cloud Platform (GCP) services.  Valid values are `APPENGINE`, 
        `BIGQUERY`, `BIGTABLE`, `CLOUDFUNCTIONS`, `CLOUDIOT`, `CLOUDSQL`, `CLOUDTASKS`, `COMPUTE`, `CONTAINER`,
        `DATAFLOW`, `DATAPROC`, `DATASTORE`, `FIREBASEDATABASE`, `FIREBASEHOSTING`, `FIRESTORE`, `INTERCONNECT`,
        `LOADBALANCING`, `LOGGING`, `ML`, `MONITORING`, `PUBSUB`, `REDIS`, `ROUTER`, `SERVICERUNTIME`, `SPANNER`, `STORAGE`,
        `TPU`, `VPN`
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "categories", value)

    @property
    @pulumi.getter(name="forceSave")
    def force_save(self) -> Optional[pulumi.Input[bool]]:
        """
        Forces this resource to save, even if errors are present
        """
        return pulumi.get(self, "force_save")

    @force_save.setter
    def force_save(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_save", value)

    @property
    @pulumi.getter(name="metricFilterRegex")
    def metric_filter_regex(self) -> Optional[pulumi.Input[str]]:
        """
        A regular expression that a metric name must match (case-insensitively) in order to be ingested
        """
        return pulumi.get(self, "metric_filter_regex")

    @metric_filter_regex.setter
    def metric_filter_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_filter_regex", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The human-readable name of this integration
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceRefreshRateInMinutes")
    def service_refresh_rate_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        How often, in minutes, to refresh the service
        """
        return pulumi.get(self, "service_refresh_rate_in_minutes")

    @service_refresh_rate_in_minutes.setter
    def service_refresh_rate_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "service_refresh_rate_in_minutes", value)


@pulumi.input_type
class _CloudIntegrationGcpState:
    def __init__(__self__, *,
                 additional_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 force_save: Optional[pulumi.Input[bool]] = None,
                 json_key: Optional[pulumi.Input[str]] = None,
                 metric_filter_regex: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 service_refresh_rate_in_minutes: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering CloudIntegrationGcp resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] additional_tags: A list of point tag key-values to add to every point ingested using this integration
        :param pulumi.Input[Sequence[pulumi.Input[str]]] categories: A list of Google Cloud Platform (GCP) services.  Valid values are `APPENGINE`, 
               `BIGQUERY`, `BIGTABLE`, `CLOUDFUNCTIONS`, `CLOUDIOT`, `CLOUDSQL`, `CLOUDTASKS`, `COMPUTE`, `CONTAINER`,
               `DATAFLOW`, `DATAPROC`, `DATASTORE`, `FIREBASEDATABASE`, `FIREBASEHOSTING`, `FIRESTORE`, `INTERCONNECT`,
               `LOADBALANCING`, `LOGGING`, `ML`, `MONITORING`, `PUBSUB`, `REDIS`, `ROUTER`, `SERVICERUNTIME`, `SPANNER`, `STORAGE`,
               `TPU`, `VPN`
        :param pulumi.Input[bool] force_save: Forces this resource to save, even if errors are present
        :param pulumi.Input[str] json_key: Private key for a Google Cloud Platform (GCP) service account within your project.
               The account must be at least granted Monitoring Viewer permissions. This key must be in the JSON format generated by GCP.
        :param pulumi.Input[str] metric_filter_regex: A regular expression that a metric name must match (case-insensitively) in order to be ingested
        :param pulumi.Input[str] name: The human-readable name of this integration
        :param pulumi.Input[str] project_id: The Google Cloud Platform (GCP) Project Id
        :param pulumi.Input[str] service: A value denoting which cloud service this service integrates with
        :param pulumi.Input[int] service_refresh_rate_in_minutes: How often, in minutes, to refresh the service
        """
        if additional_tags is not None:
            pulumi.set(__self__, "additional_tags", additional_tags)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if force_save is not None:
            pulumi.set(__self__, "force_save", force_save)
        if json_key is not None:
            pulumi.set(__self__, "json_key", json_key)
        if metric_filter_regex is not None:
            pulumi.set(__self__, "metric_filter_regex", metric_filter_regex)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if service_refresh_rate_in_minutes is not None:
            pulumi.set(__self__, "service_refresh_rate_in_minutes", service_refresh_rate_in_minutes)

    @property
    @pulumi.getter(name="additionalTags")
    def additional_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A list of point tag key-values to add to every point ingested using this integration
        """
        return pulumi.get(self, "additional_tags")

    @additional_tags.setter
    def additional_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "additional_tags", value)

    @property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of Google Cloud Platform (GCP) services.  Valid values are `APPENGINE`, 
        `BIGQUERY`, `BIGTABLE`, `CLOUDFUNCTIONS`, `CLOUDIOT`, `CLOUDSQL`, `CLOUDTASKS`, `COMPUTE`, `CONTAINER`,
        `DATAFLOW`, `DATAPROC`, `DATASTORE`, `FIREBASEDATABASE`, `FIREBASEHOSTING`, `FIRESTORE`, `INTERCONNECT`,
        `LOADBALANCING`, `LOGGING`, `ML`, `MONITORING`, `PUBSUB`, `REDIS`, `ROUTER`, `SERVICERUNTIME`, `SPANNER`, `STORAGE`,
        `TPU`, `VPN`
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "categories", value)

    @property
    @pulumi.getter(name="forceSave")
    def force_save(self) -> Optional[pulumi.Input[bool]]:
        """
        Forces this resource to save, even if errors are present
        """
        return pulumi.get(self, "force_save")

    @force_save.setter
    def force_save(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_save", value)

    @property
    @pulumi.getter(name="jsonKey")
    def json_key(self) -> Optional[pulumi.Input[str]]:
        """
        Private key for a Google Cloud Platform (GCP) service account within your project.
        The account must be at least granted Monitoring Viewer permissions. This key must be in the JSON format generated by GCP.
        """
        return pulumi.get(self, "json_key")

    @json_key.setter
    def json_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "json_key", value)

    @property
    @pulumi.getter(name="metricFilterRegex")
    def metric_filter_regex(self) -> Optional[pulumi.Input[str]]:
        """
        A regular expression that a metric name must match (case-insensitively) in order to be ingested
        """
        return pulumi.get(self, "metric_filter_regex")

    @metric_filter_regex.setter
    def metric_filter_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_filter_regex", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The human-readable name of this integration
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Google Cloud Platform (GCP) Project Id
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        A value denoting which cloud service this service integrates with
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="serviceRefreshRateInMinutes")
    def service_refresh_rate_in_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        How often, in minutes, to refresh the service
        """
        return pulumi.get(self, "service_refresh_rate_in_minutes")

    @service_refresh_rate_in_minutes.setter
    def service_refresh_rate_in_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "service_refresh_rate_in_minutes", value)


class CloudIntegrationGcp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 force_save: Optional[pulumi.Input[bool]] = None,
                 json_key: Optional[pulumi.Input[str]] = None,
                 metric_filter_regex: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 service_refresh_rate_in_minutes: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides a Wavefront Cloud Integration for GCP. This allows GCP cloud integrations to be created,
        updated, and deleted.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_wavefront as wavefront

        gcp = wavefront.CloudIntegrationGcp("gcp",
            json_key=\"\"\"{...your gcp key ...}

        \"\"\",
            project_id="example-gcp-project")
        ```

        ## Import

        GCP Cloud Integrations can be imported using the `id`, e.g.

        ```sh
         $ pulumi import wavefront:index/cloudIntegrationGcp:CloudIntegrationGcp gcp a411c16b-3cf7-4f03-bf11-8ca05aab898d
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] additional_tags: A list of point tag key-values to add to every point ingested using this integration
        :param pulumi.Input[Sequence[pulumi.Input[str]]] categories: A list of Google Cloud Platform (GCP) services.  Valid values are `APPENGINE`, 
               `BIGQUERY`, `BIGTABLE`, `CLOUDFUNCTIONS`, `CLOUDIOT`, `CLOUDSQL`, `CLOUDTASKS`, `COMPUTE`, `CONTAINER`,
               `DATAFLOW`, `DATAPROC`, `DATASTORE`, `FIREBASEDATABASE`, `FIREBASEHOSTING`, `FIRESTORE`, `INTERCONNECT`,
               `LOADBALANCING`, `LOGGING`, `ML`, `MONITORING`, `PUBSUB`, `REDIS`, `ROUTER`, `SERVICERUNTIME`, `SPANNER`, `STORAGE`,
               `TPU`, `VPN`
        :param pulumi.Input[bool] force_save: Forces this resource to save, even if errors are present
        :param pulumi.Input[str] json_key: Private key for a Google Cloud Platform (GCP) service account within your project.
               The account must be at least granted Monitoring Viewer permissions. This key must be in the JSON format generated by GCP.
        :param pulumi.Input[str] metric_filter_regex: A regular expression that a metric name must match (case-insensitively) in order to be ingested
        :param pulumi.Input[str] name: The human-readable name of this integration
        :param pulumi.Input[str] project_id: The Google Cloud Platform (GCP) Project Id
        :param pulumi.Input[str] service: A value denoting which cloud service this service integrates with
        :param pulumi.Input[int] service_refresh_rate_in_minutes: How often, in minutes, to refresh the service
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudIntegrationGcpArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Wavefront Cloud Integration for GCP. This allows GCP cloud integrations to be created,
        updated, and deleted.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_wavefront as wavefront

        gcp = wavefront.CloudIntegrationGcp("gcp",
            json_key=\"\"\"{...your gcp key ...}

        \"\"\",
            project_id="example-gcp-project")
        ```

        ## Import

        GCP Cloud Integrations can be imported using the `id`, e.g.

        ```sh
         $ pulumi import wavefront:index/cloudIntegrationGcp:CloudIntegrationGcp gcp a411c16b-3cf7-4f03-bf11-8ca05aab898d
        ```

        :param str resource_name: The name of the resource.
        :param CloudIntegrationGcpArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudIntegrationGcpArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 force_save: Optional[pulumi.Input[bool]] = None,
                 json_key: Optional[pulumi.Input[str]] = None,
                 metric_filter_regex: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 service_refresh_rate_in_minutes: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudIntegrationGcpArgs.__new__(CloudIntegrationGcpArgs)

            __props__.__dict__["additional_tags"] = additional_tags
            __props__.__dict__["categories"] = categories
            __props__.__dict__["force_save"] = force_save
            if json_key is None and not opts.urn:
                raise TypeError("Missing required property 'json_key'")
            __props__.__dict__["json_key"] = json_key
            __props__.__dict__["metric_filter_regex"] = metric_filter_regex
            __props__.__dict__["name"] = name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if service is None and not opts.urn:
                raise TypeError("Missing required property 'service'")
            __props__.__dict__["service"] = service
            __props__.__dict__["service_refresh_rate_in_minutes"] = service_refresh_rate_in_minutes
        super(CloudIntegrationGcp, __self__).__init__(
            'wavefront:index/cloudIntegrationGcp:CloudIntegrationGcp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            categories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            force_save: Optional[pulumi.Input[bool]] = None,
            json_key: Optional[pulumi.Input[str]] = None,
            metric_filter_regex: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            service: Optional[pulumi.Input[str]] = None,
            service_refresh_rate_in_minutes: Optional[pulumi.Input[int]] = None) -> 'CloudIntegrationGcp':
        """
        Get an existing CloudIntegrationGcp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] additional_tags: A list of point tag key-values to add to every point ingested using this integration
        :param pulumi.Input[Sequence[pulumi.Input[str]]] categories: A list of Google Cloud Platform (GCP) services.  Valid values are `APPENGINE`, 
               `BIGQUERY`, `BIGTABLE`, `CLOUDFUNCTIONS`, `CLOUDIOT`, `CLOUDSQL`, `CLOUDTASKS`, `COMPUTE`, `CONTAINER`,
               `DATAFLOW`, `DATAPROC`, `DATASTORE`, `FIREBASEDATABASE`, `FIREBASEHOSTING`, `FIRESTORE`, `INTERCONNECT`,
               `LOADBALANCING`, `LOGGING`, `ML`, `MONITORING`, `PUBSUB`, `REDIS`, `ROUTER`, `SERVICERUNTIME`, `SPANNER`, `STORAGE`,
               `TPU`, `VPN`
        :param pulumi.Input[bool] force_save: Forces this resource to save, even if errors are present
        :param pulumi.Input[str] json_key: Private key for a Google Cloud Platform (GCP) service account within your project.
               The account must be at least granted Monitoring Viewer permissions. This key must be in the JSON format generated by GCP.
        :param pulumi.Input[str] metric_filter_regex: A regular expression that a metric name must match (case-insensitively) in order to be ingested
        :param pulumi.Input[str] name: The human-readable name of this integration
        :param pulumi.Input[str] project_id: The Google Cloud Platform (GCP) Project Id
        :param pulumi.Input[str] service: A value denoting which cloud service this service integrates with
        :param pulumi.Input[int] service_refresh_rate_in_minutes: How often, in minutes, to refresh the service
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudIntegrationGcpState.__new__(_CloudIntegrationGcpState)

        __props__.__dict__["additional_tags"] = additional_tags
        __props__.__dict__["categories"] = categories
        __props__.__dict__["force_save"] = force_save
        __props__.__dict__["json_key"] = json_key
        __props__.__dict__["metric_filter_regex"] = metric_filter_regex
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["service"] = service
        __props__.__dict__["service_refresh_rate_in_minutes"] = service_refresh_rate_in_minutes
        return CloudIntegrationGcp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalTags")
    def additional_tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A list of point tag key-values to add to every point ingested using this integration
        """
        return pulumi.get(self, "additional_tags")

    @property
    @pulumi.getter
    def categories(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of Google Cloud Platform (GCP) services.  Valid values are `APPENGINE`, 
        `BIGQUERY`, `BIGTABLE`, `CLOUDFUNCTIONS`, `CLOUDIOT`, `CLOUDSQL`, `CLOUDTASKS`, `COMPUTE`, `CONTAINER`,
        `DATAFLOW`, `DATAPROC`, `DATASTORE`, `FIREBASEDATABASE`, `FIREBASEHOSTING`, `FIRESTORE`, `INTERCONNECT`,
        `LOADBALANCING`, `LOGGING`, `ML`, `MONITORING`, `PUBSUB`, `REDIS`, `ROUTER`, `SERVICERUNTIME`, `SPANNER`, `STORAGE`,
        `TPU`, `VPN`
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter(name="forceSave")
    def force_save(self) -> pulumi.Output[Optional[bool]]:
        """
        Forces this resource to save, even if errors are present
        """
        return pulumi.get(self, "force_save")

    @property
    @pulumi.getter(name="jsonKey")
    def json_key(self) -> pulumi.Output[str]:
        """
        Private key for a Google Cloud Platform (GCP) service account within your project.
        The account must be at least granted Monitoring Viewer permissions. This key must be in the JSON format generated by GCP.
        """
        return pulumi.get(self, "json_key")

    @property
    @pulumi.getter(name="metricFilterRegex")
    def metric_filter_regex(self) -> pulumi.Output[Optional[str]]:
        """
        A regular expression that a metric name must match (case-insensitively) in order to be ingested
        """
        return pulumi.get(self, "metric_filter_regex")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The human-readable name of this integration
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The Google Cloud Platform (GCP) Project Id
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def service(self) -> pulumi.Output[str]:
        """
        A value denoting which cloud service this service integrates with
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="serviceRefreshRateInMinutes")
    def service_refresh_rate_in_minutes(self) -> pulumi.Output[Optional[int]]:
        """
        How often, in minutes, to refresh the service
        """
        return pulumi.get(self, "service_refresh_rate_in_minutes")

