# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'AlertTargetRoute',
    'CloudIntegrationNewRelicMetricFilter',
    'DashboardParameterDetail',
    'DashboardSection',
    'DashboardSectionRow',
    'DashboardSectionRowChart',
    'DashboardSectionRowChartChartSetting',
    'DashboardSectionRowChartSource',
]

@pulumi.output_type
class AlertTargetRoute(dict):
    def __init__(__self__, *,
                 method: str,
                 target: str,
                 filter: Optional[Mapping[str, str]] = None):
        """
        :param str method: The notification method used for notification target. One of `WEBHOOK`, `EMAIL`, `PAGERDUTY`.
        """
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "target", target)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @property
    @pulumi.getter
    def method(self) -> str:
        """
        The notification method used for notification target. One of `WEBHOOK`, `EMAIL`, `PAGERDUTY`.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def target(self) -> str:
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def filter(self) -> Optional[Mapping[str, str]]:
        return pulumi.get(self, "filter")


@pulumi.output_type
class CloudIntegrationNewRelicMetricFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appName":
            suggest = "app_name"
        elif key == "metricFilterRegex":
            suggest = "metric_filter_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudIntegrationNewRelicMetricFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudIntegrationNewRelicMetricFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudIntegrationNewRelicMetricFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_name: str,
                 metric_filter_regex: str):
        """
        :param str app_name: The name of a NewRelic App
        :param str metric_filter_regex: A regular expression that a metric name must match (case-insensitively) in order to be ingested
        """
        pulumi.set(__self__, "app_name", app_name)
        pulumi.set(__self__, "metric_filter_regex", metric_filter_regex)

    @property
    @pulumi.getter(name="appName")
    def app_name(self) -> str:
        """
        The name of a NewRelic App
        """
        return pulumi.get(self, "app_name")

    @property
    @pulumi.getter(name="metricFilterRegex")
    def metric_filter_regex(self) -> str:
        """
        A regular expression that a metric name must match (case-insensitively) in order to be ingested
        """
        return pulumi.get(self, "metric_filter_regex")


@pulumi.output_type
class DashboardParameterDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"
        elif key == "hideFromView":
            suggest = "hide_from_view"
        elif key == "parameterType":
            suggest = "parameter_type"
        elif key == "valuesToReadableStrings":
            suggest = "values_to_readable_strings"
        elif key == "dynamicFieldType":
            suggest = "dynamic_field_type"
        elif key == "queryValue":
            suggest = "query_value"
        elif key == "tagKey":
            suggest = "tag_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardParameterDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardParameterDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardParameterDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_value: str,
                 hide_from_view: bool,
                 label: str,
                 name: str,
                 parameter_type: str,
                 values_to_readable_strings: Mapping[str, str],
                 dynamic_field_type: Optional[str] = None,
                 query_value: Optional[str] = None,
                 tag_key: Optional[str] = None):
        """
        :param str default_value: The default value of the parameter
        :param bool hide_from_view: If `true` the parameter will only be shown on the edit view of the dashboard
        :param str label: The label for the parameter
        :param str name: The name of the parameters
        :param str parameter_type: The type of the parameter. `SIMPLE`, `LIST`, or `DYNAMIC`
        :param Mapping[str, str] values_to_readable_strings: A string->string map.  At least one of the keys must match the value of
               `default_value`
        :param str dynamic_field_type: For `DYNAMIC` parameter types, the type of the field. Valid options are `SOURCE`,
               `SOURCE_TAG`, `METRIC_NAME`, `TAG_KEY`, `MATCHING_SOURCE_TAG`
        :param str query_value: For `DYNAMIC` parameter types, the query to execute to return values
        :param str tag_key: for `TAG_KEY` dynamic field types, the tag key to return
        """
        pulumi.set(__self__, "default_value", default_value)
        pulumi.set(__self__, "hide_from_view", hide_from_view)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parameter_type", parameter_type)
        pulumi.set(__self__, "values_to_readable_strings", values_to_readable_strings)
        if dynamic_field_type is not None:
            pulumi.set(__self__, "dynamic_field_type", dynamic_field_type)
        if query_value is not None:
            pulumi.set(__self__, "query_value", query_value)
        if tag_key is not None:
            pulumi.set(__self__, "tag_key", tag_key)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> str:
        """
        The default value of the parameter
        """
        return pulumi.get(self, "default_value")

    @property
    @pulumi.getter(name="hideFromView")
    def hide_from_view(self) -> bool:
        """
        If `true` the parameter will only be shown on the edit view of the dashboard
        """
        return pulumi.get(self, "hide_from_view")

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        The label for the parameter
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the parameters
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parameterType")
    def parameter_type(self) -> str:
        """
        The type of the parameter. `SIMPLE`, `LIST`, or `DYNAMIC`
        """
        return pulumi.get(self, "parameter_type")

    @property
    @pulumi.getter(name="valuesToReadableStrings")
    def values_to_readable_strings(self) -> Mapping[str, str]:
        """
        A string->string map.  At least one of the keys must match the value of
        `default_value`
        """
        return pulumi.get(self, "values_to_readable_strings")

    @property
    @pulumi.getter(name="dynamicFieldType")
    def dynamic_field_type(self) -> Optional[str]:
        """
        For `DYNAMIC` parameter types, the type of the field. Valid options are `SOURCE`,
        `SOURCE_TAG`, `METRIC_NAME`, `TAG_KEY`, `MATCHING_SOURCE_TAG`
        """
        return pulumi.get(self, "dynamic_field_type")

    @property
    @pulumi.getter(name="queryValue")
    def query_value(self) -> Optional[str]:
        """
        For `DYNAMIC` parameter types, the query to execute to return values
        """
        return pulumi.get(self, "query_value")

    @property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> Optional[str]:
        """
        for `TAG_KEY` dynamic field types, the tag key to return
        """
        return pulumi.get(self, "tag_key")


@pulumi.output_type
class DashboardSection(dict):
    def __init__(__self__, *,
                 name: str,
                 rows: Sequence['outputs.DashboardSectionRow']):
        """
        :param str name: Name of this section
        :param Sequence['DashboardSectionRowArgs'] rows: See dashboard section rows
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rows", rows)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of this section
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def rows(self) -> Sequence['outputs.DashboardSectionRow']:
        """
        See dashboard section rows
        """
        return pulumi.get(self, "rows")


@pulumi.output_type
class DashboardSectionRow(dict):
    def __init__(__self__, *,
                 charts: Sequence['outputs.DashboardSectionRowChart']):
        """
        :param Sequence['DashboardSectionRowChartArgs'] charts: Charts in this section. See dashboard chart
        """
        pulumi.set(__self__, "charts", charts)

    @property
    @pulumi.getter
    def charts(self) -> Sequence['outputs.DashboardSectionRowChart']:
        """
        Charts in this section. See dashboard chart
        """
        return pulumi.get(self, "charts")


@pulumi.output_type
class DashboardSectionRowChart(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chartSetting":
            suggest = "chart_setting"
        elif key == "chartAttribute":
            suggest = "chart_attribute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardSectionRowChart. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardSectionRowChart.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardSectionRowChart.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 chart_setting: 'outputs.DashboardSectionRowChartChartSetting',
                 name: str,
                 sources: Sequence['outputs.DashboardSectionRowChartSource'],
                 summarization: str,
                 units: str,
                 base: Optional[int] = None,
                 chart_attribute: Optional[str] = None,
                 description: Optional[str] = None):
        """
        :param 'DashboardSectionRowChartChartSettingArgs' chart_setting: Chart settings. See chart settings
        :param str name: Name of the source
        :param Sequence['DashboardSectionRowChartSourceArgs'] sources: Query expression to plot on the chart. See chart source queries
        :param str summarization: Summarization strategy for the chart. MEAN is default. Valid options are, `MEAN`, 
               `MEDIAN`, `MIN`, `MAX`, `SUM`, `COUNT`, `LAST`, `FIRST`
        :param str units: String to label the units of the chart on the Y-Axis
        :param int base: The base of logarithmic scale charts. Omit or set to 0 for the default linear scale. Usually set to 10 for the traditional logarithmic scale.
        :param str description: Description of the chart
        """
        pulumi.set(__self__, "chart_setting", chart_setting)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "summarization", summarization)
        pulumi.set(__self__, "units", units)
        if base is not None:
            pulumi.set(__self__, "base", base)
        if chart_attribute is not None:
            pulumi.set(__self__, "chart_attribute", chart_attribute)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="chartSetting")
    def chart_setting(self) -> 'outputs.DashboardSectionRowChartChartSetting':
        """
        Chart settings. See chart settings
        """
        return pulumi.get(self, "chart_setting")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the source
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.DashboardSectionRowChartSource']:
        """
        Query expression to plot on the chart. See chart source queries
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter
    def summarization(self) -> str:
        """
        Summarization strategy for the chart. MEAN is default. Valid options are, `MEAN`, 
        `MEDIAN`, `MIN`, `MAX`, `SUM`, `COUNT`, `LAST`, `FIRST`
        """
        return pulumi.get(self, "summarization")

    @property
    @pulumi.getter
    def units(self) -> str:
        """
        String to label the units of the chart on the Y-Axis
        """
        return pulumi.get(self, "units")

    @property
    @pulumi.getter
    def base(self) -> Optional[int]:
        """
        The base of logarithmic scale charts. Omit or set to 0 for the default linear scale. Usually set to 10 for the traditional logarithmic scale.
        """
        return pulumi.get(self, "base")

    @property
    @pulumi.getter(name="chartAttribute")
    def chart_attribute(self) -> Optional[str]:
        return pulumi.get(self, "chart_attribute")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Description of the chart
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class DashboardSectionRowChartChartSetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoColumnTags":
            suggest = "auto_column_tags"
        elif key == "columnTags":
            suggest = "column_tags"
        elif key == "customTags":
            suggest = "custom_tags"
        elif key == "expectedDataSpacing":
            suggest = "expected_data_spacing"
        elif key == "fixedLegendDisplayStats":
            suggest = "fixed_legend_display_stats"
        elif key == "fixedLegendEnabled":
            suggest = "fixed_legend_enabled"
        elif key == "fixedLegendFilterField":
            suggest = "fixed_legend_filter_field"
        elif key == "fixedLegendFilterLimit":
            suggest = "fixed_legend_filter_limit"
        elif key == "fixedLegendFilterSort":
            suggest = "fixed_legend_filter_sort"
        elif key == "fixedLegendHideLabel":
            suggest = "fixed_legend_hide_label"
        elif key == "fixedLegendPosition":
            suggest = "fixed_legend_position"
        elif key == "fixedLegendUseRawStats":
            suggest = "fixed_legend_use_raw_stats"
        elif key == "groupBySource":
            suggest = "group_by_source"
        elif key == "invertDynamicLegendHoverControl":
            suggest = "invert_dynamic_legend_hover_control"
        elif key == "lineType":
            suggest = "line_type"
        elif key == "numTags":
            suggest = "num_tags"
        elif key == "plainMarkdownContent":
            suggest = "plain_markdown_content"
        elif key == "showHosts":
            suggest = "show_hosts"
        elif key == "showLabels":
            suggest = "show_labels"
        elif key == "showRawValues":
            suggest = "show_raw_values"
        elif key == "sortValuesDescending":
            suggest = "sort_values_descending"
        elif key == "sparklineDecimalPrecision":
            suggest = "sparkline_decimal_precision"
        elif key == "sparklineDisplayColor":
            suggest = "sparkline_display_color"
        elif key == "sparklineDisplayFontSize":
            suggest = "sparkline_display_font_size"
        elif key == "sparklineDisplayHorizontalPosition":
            suggest = "sparkline_display_horizontal_position"
        elif key == "sparklineDisplayPostfix":
            suggest = "sparkline_display_postfix"
        elif key == "sparklineDisplayPrefix":
            suggest = "sparkline_display_prefix"
        elif key == "sparklineDisplayValueType":
            suggest = "sparkline_display_value_type"
        elif key == "sparklineDisplayVerticalPosition":
            suggest = "sparkline_display_vertical_position"
        elif key == "sparklineFillColor":
            suggest = "sparkline_fill_color"
        elif key == "sparklineLineColor":
            suggest = "sparkline_line_color"
        elif key == "sparklineSize":
            suggest = "sparkline_size"
        elif key == "sparklineValueColorMapApplyTo":
            suggest = "sparkline_value_color_map_apply_to"
        elif key == "sparklineValueColorMapColors":
            suggest = "sparkline_value_color_map_colors"
        elif key == "sparklineValueColorMapValues":
            suggest = "sparkline_value_color_map_values"
        elif key == "sparklineValueColorMapValuesV2s":
            suggest = "sparkline_value_color_map_values_v2s"
        elif key == "sparklineValueTextMapTexts":
            suggest = "sparkline_value_text_map_texts"
        elif key == "sparklineValueTextMapThresholds":
            suggest = "sparkline_value_text_map_thresholds"
        elif key == "stackType":
            suggest = "stack_type"
        elif key == "tagMode":
            suggest = "tag_mode"
        elif key == "timeBasedColoring":
            suggest = "time_based_coloring"
        elif key == "windowSize":
            suggest = "window_size"
        elif key == "y0ScaleSiBy1024":
            suggest = "y0_scale_si_by1024"
        elif key == "y0UnitAutoscaling":
            suggest = "y0_unit_autoscaling"
        elif key == "y1ScaleSiBy1024":
            suggest = "y1_scale_si_by1024"
        elif key == "y1UnitAutoscaling":
            suggest = "y1_unit_autoscaling"
        elif key == "y1Units":
            suggest = "y1_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardSectionRowChartChartSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardSectionRowChartChartSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardSectionRowChartChartSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 auto_column_tags: Optional[bool] = None,
                 column_tags: Optional[str] = None,
                 custom_tags: Optional[Sequence[str]] = None,
                 expected_data_spacing: Optional[int] = None,
                 fixed_legend_display_stats: Optional[Sequence[str]] = None,
                 fixed_legend_enabled: Optional[bool] = None,
                 fixed_legend_filter_field: Optional[str] = None,
                 fixed_legend_filter_limit: Optional[int] = None,
                 fixed_legend_filter_sort: Optional[str] = None,
                 fixed_legend_hide_label: Optional[bool] = None,
                 fixed_legend_position: Optional[str] = None,
                 fixed_legend_use_raw_stats: Optional[bool] = None,
                 group_by_source: Optional[bool] = None,
                 invert_dynamic_legend_hover_control: Optional[bool] = None,
                 line_type: Optional[str] = None,
                 max: Optional[float] = None,
                 min: Optional[float] = None,
                 num_tags: Optional[int] = None,
                 plain_markdown_content: Optional[str] = None,
                 show_hosts: Optional[bool] = None,
                 show_labels: Optional[bool] = None,
                 show_raw_values: Optional[bool] = None,
                 sort_values_descending: Optional[bool] = None,
                 sparkline_decimal_precision: Optional[int] = None,
                 sparkline_display_color: Optional[str] = None,
                 sparkline_display_font_size: Optional[str] = None,
                 sparkline_display_horizontal_position: Optional[str] = None,
                 sparkline_display_postfix: Optional[str] = None,
                 sparkline_display_prefix: Optional[str] = None,
                 sparkline_display_value_type: Optional[str] = None,
                 sparkline_display_vertical_position: Optional[str] = None,
                 sparkline_fill_color: Optional[str] = None,
                 sparkline_line_color: Optional[str] = None,
                 sparkline_size: Optional[str] = None,
                 sparkline_value_color_map_apply_to: Optional[str] = None,
                 sparkline_value_color_map_colors: Optional[Sequence[str]] = None,
                 sparkline_value_color_map_values: Optional[Sequence[int]] = None,
                 sparkline_value_color_map_values_v2s: Optional[Sequence[float]] = None,
                 sparkline_value_text_map_texts: Optional[Sequence[str]] = None,
                 sparkline_value_text_map_thresholds: Optional[Sequence[float]] = None,
                 stack_type: Optional[str] = None,
                 tag_mode: Optional[str] = None,
                 time_based_coloring: Optional[bool] = None,
                 window_size: Optional[int] = None,
                 windowing: Optional[str] = None,
                 xmax: Optional[float] = None,
                 xmin: Optional[float] = None,
                 y0_scale_si_by1024: Optional[bool] = None,
                 y0_unit_autoscaling: Optional[bool] = None,
                 y1_scale_si_by1024: Optional[bool] = None,
                 y1_unit_autoscaling: Optional[bool] = None,
                 y1_units: Optional[str] = None,
                 y1max: Optional[float] = None,
                 y1min: Optional[float] = None,
                 ymax: Optional[float] = None,
                 ymin: Optional[float] = None):
        """
        :param str type: Chart Type. `line` refers to the Line Plot, `scatter` to the Point Plot, `stacked-area` to 
               the Stacked Area plot, `table` to the Tabular View, `scatterploy-xy` to Scatter Plot, `markdown-widget` to the
               Markdown display, and `sparkline` to the Single Stat view. Valid options are `line`, `scatterplot`,
               `stacked-area`, `stacked-column`, `table`, `scatterplot-xy`, `markdown-widget`, `sparkline`, `globe`, `nodemap`,
               `top-k`, `status-list`, `histogram`
        :param bool auto_column_tags: deprecated
        :param str column_tags: deprecated
        :param Sequence[str] custom_tags: For the tabular view, a list of point tags to display when using the `custom` tag display mode
        :param int expected_data_spacing: Threshold (in seconds) for time delta between consecutive points in a series
               above which a dotted line will replace a solid in in line plots. Default 60
        :param Sequence[str] fixed_legend_display_stats: For a chart with a fixed legend, a list of statistics to display in the legend
        :param bool fixed_legend_enabled: Whether to enable a fixed tabular legend adjacent to the chart
        :param str fixed_legend_filter_field: Statistic to use for determining whether a series is displayed on the fixed legend.
               Valid options are `CURRENT`, `MEAN`, `MEDIAN`, `SUM`, `MIN`, `MAX`, `COUNT`
        :param int fixed_legend_filter_limit: Number of series to include in the fixed legend
        :param str fixed_legend_filter_sort: Whether to display `TOP` or `BOTTOM` ranked series in a fixed legend. Valid options
               are `TOP`, and `BOTTOM`
        :param bool fixed_legend_hide_label: deprecated
        :param str fixed_legend_position: Where the fixed legend should be displayed with respect ot the chart.
               Valid options are `RIGHt`, `TOP`, `LEFT`, `BOTTOM`
        :param bool fixed_legend_use_raw_stats: If `true`, the legend uses non-summarized stats instead of summarized
        :param bool group_by_source: For the tabular view, whether to group multi metrics into a single row by a common source.
               If `false`, each source is displayed in its own row.  if `true`, multiple metrics for the same host will be displayed as different
               columns in the same row
        :param bool invert_dynamic_legend_hover_control: Whether to disable the display of the floating legend (but
               reenable it when the ctrl-key is pressed)
        :param str line_type: Plot interpolation type.  `linear` is default. Valid options are `linear`, `step-before`, 
               `step-after`, `basis`, `cardinal`, `monotone`
        :param float max: Max value of the Y-axis. Set to null or leave blank for auto
        :param float min: Min value of the Y-axis. Set to null or leave blank for auto
        :param int num_tags: For the tabular view, how many point tags to display
        :param str plain_markdown_content: The markdown content for a Markdown display, in plain text.
        :param bool show_hosts: For the tabular view, whether to display sources. Default is `true`
        :param bool show_labels: For the tabular view, whether to display labels. Default is `true`
        :param bool show_raw_values: For the tabular view, whether to display raw values. Default is `false`
        :param bool sort_values_descending: For the tabular view, whether to display display values in descending order. Default is `false`
        :param int sparkline_decimal_precision: For the single stat view, the decimal precision of the displayed number
        :param str sparkline_display_color: For the single stat view, the color of the displayed text (when not dynamically determined). 
               Values should be in `rgba(,,,,)` format
        :param str sparkline_display_font_size: For the single stat view, the font size of the displayed text, in percent
        :param str sparkline_display_horizontal_position: For the single stat view, the horizontal position of the displayed text.
               Valid options are `MIDDLE`, `LEFT`, `RIGHT`
        :param str sparkline_display_postfix: For the single stat view, a string to append to the displayed text
        :param str sparkline_display_prefix: For the single stat view, a string to add before the displayed text
        :param str sparkline_display_value_type: For the single stat view, where to display the name of the query or the value of the query.
               Valid options are `VALUE` or `LABEL`
        :param str sparkline_display_vertical_position: deprecated
        :param str sparkline_fill_color: For the single stat view, the color of the background fill.  Values should be
               in `rgba(,,,,)`
        :param str sparkline_line_color: For the single stat view, the color of the line.  Values should be in `rgba(,,,,)` format
        :param str sparkline_size: For the single stat view, This determines whether the sparkline of the statistic is displayed in the chart `BACKGROUND`, `BOTTOM`, or `NONE`.
               Valid options are `BACKGROUND`, `BOTTOM`, `NONE`
        :param str sparkline_value_color_map_apply_to: For the single stat view, whether to apply dyunamic color settings to 
               the displayed `TEXT` or `BACKGROUND`. Valid options are `TEXT` or `BACKGROUND`
        :param Sequence[str] sparkline_value_color_map_colors: For the single stat view, A list of colors that differing query values map to. 
               Must contain one more element than `sparkline_value_color_map_values_v2`. Values should be in `rgba(,,,,)`
        :param Sequence[int] sparkline_value_color_map_values: deprecated
        :param Sequence[float] sparkline_value_color_map_values_v2s: For the single stat view, a list of boundaries for mapping different
               query values to colors.  Must contain one less element than `sparkline_value_color_map_colors`
        :param Sequence[str] sparkline_value_text_map_texts: For the single stat view, a list of display text values that different query
               values map to.  Must contain one more element than `sparkline_value_text_map_thresholds`
        :param Sequence[float] sparkline_value_text_map_thresholds: For the single stat view, a list of threshold boundaries for 
               mapping different query values to display text.  Must contain one less element than `sparkline_value_text_map_text`
        :param str stack_type: Type of stacked chart (applicable only if chart type is `stacked`). `zero` (default) means
               stacked from y=0. `expand` means normalized from 0 to 1.  `wiggle` means minimize weighted changes. `silhouette` means to
               center the stream. Valid options are `zero`, `expand`, `wiggle`, `silhouette`, `bars`
        :param str tag_mode: For the tabular view, which mode to use to determine which point tags to display.
               Valid options are `all`, `top`, or `custom`
        :param bool time_based_coloring: For x-y scatterplots, whether to color more recent points as darker than older points
        :param int window_size: Width, in minutes, of the time window to use for `last` windowing
        :param str windowing: For the tabular view, whether to use the full time window for the query or the last X minutes.
               Valid options are `full` or `last`
        :param float xmax: For x-y scatterplots, max value for the X-axis. Set to null for auto
        :param float xmin: For x-y scatterplots, min value for the X-axis. Set to null for auto
        :param bool y0_scale_si_by1024: Whether to scale numerical magnitude labels for left Y-axis by 1024 in the IEC/Binary manner (instead of by 1000 like SI)
        :param bool y0_unit_autoscaling: Whether to automatically adjust magnitude labels and units for the left Y-axis to favor smaller magnitudes and larger units
        :param bool y1_scale_si_by1024: Whether to scale numerical magnitude labels for right Y-axis by 1024 in the IEC/Binary manner (instead of by 1000 like SI)
        :param bool y1_unit_autoscaling: Whether to automatically adjust magnitude labels and units for the right Y-axis to favor smaller magnitudes and larger units
        :param str y1_units: For plots with multiple Y-axes, units for right side Y-axis
        :param float y1max: For plots with multiple Y-axes, max value for the right side Y-axis. Set null for auto
        :param float y1min: For plots with multiple Y-axes, min value for the right side Y-axis. Set null for auto
        :param float ymax: For x-y scatterplots, max value for the Y-axis. Set to null for auto
        :param float ymin: For x-y scatterplots, min value for the Y-axis. Set to null for auto
        """
        pulumi.set(__self__, "type", type)
        if auto_column_tags is not None:
            pulumi.set(__self__, "auto_column_tags", auto_column_tags)
        if column_tags is not None:
            pulumi.set(__self__, "column_tags", column_tags)
        if custom_tags is not None:
            pulumi.set(__self__, "custom_tags", custom_tags)
        if expected_data_spacing is not None:
            pulumi.set(__self__, "expected_data_spacing", expected_data_spacing)
        if fixed_legend_display_stats is not None:
            pulumi.set(__self__, "fixed_legend_display_stats", fixed_legend_display_stats)
        if fixed_legend_enabled is not None:
            pulumi.set(__self__, "fixed_legend_enabled", fixed_legend_enabled)
        if fixed_legend_filter_field is not None:
            pulumi.set(__self__, "fixed_legend_filter_field", fixed_legend_filter_field)
        if fixed_legend_filter_limit is not None:
            pulumi.set(__self__, "fixed_legend_filter_limit", fixed_legend_filter_limit)
        if fixed_legend_filter_sort is not None:
            pulumi.set(__self__, "fixed_legend_filter_sort", fixed_legend_filter_sort)
        if fixed_legend_hide_label is not None:
            pulumi.set(__self__, "fixed_legend_hide_label", fixed_legend_hide_label)
        if fixed_legend_position is not None:
            pulumi.set(__self__, "fixed_legend_position", fixed_legend_position)
        if fixed_legend_use_raw_stats is not None:
            pulumi.set(__self__, "fixed_legend_use_raw_stats", fixed_legend_use_raw_stats)
        if group_by_source is not None:
            pulumi.set(__self__, "group_by_source", group_by_source)
        if invert_dynamic_legend_hover_control is not None:
            pulumi.set(__self__, "invert_dynamic_legend_hover_control", invert_dynamic_legend_hover_control)
        if line_type is not None:
            pulumi.set(__self__, "line_type", line_type)
        if max is not None:
            pulumi.set(__self__, "max", max)
        if min is not None:
            pulumi.set(__self__, "min", min)
        if num_tags is not None:
            pulumi.set(__self__, "num_tags", num_tags)
        if plain_markdown_content is not None:
            pulumi.set(__self__, "plain_markdown_content", plain_markdown_content)
        if show_hosts is not None:
            pulumi.set(__self__, "show_hosts", show_hosts)
        if show_labels is not None:
            pulumi.set(__self__, "show_labels", show_labels)
        if show_raw_values is not None:
            pulumi.set(__self__, "show_raw_values", show_raw_values)
        if sort_values_descending is not None:
            pulumi.set(__self__, "sort_values_descending", sort_values_descending)
        if sparkline_decimal_precision is not None:
            pulumi.set(__self__, "sparkline_decimal_precision", sparkline_decimal_precision)
        if sparkline_display_color is not None:
            pulumi.set(__self__, "sparkline_display_color", sparkline_display_color)
        if sparkline_display_font_size is not None:
            pulumi.set(__self__, "sparkline_display_font_size", sparkline_display_font_size)
        if sparkline_display_horizontal_position is not None:
            pulumi.set(__self__, "sparkline_display_horizontal_position", sparkline_display_horizontal_position)
        if sparkline_display_postfix is not None:
            pulumi.set(__self__, "sparkline_display_postfix", sparkline_display_postfix)
        if sparkline_display_prefix is not None:
            pulumi.set(__self__, "sparkline_display_prefix", sparkline_display_prefix)
        if sparkline_display_value_type is not None:
            pulumi.set(__self__, "sparkline_display_value_type", sparkline_display_value_type)
        if sparkline_display_vertical_position is not None:
            pulumi.set(__self__, "sparkline_display_vertical_position", sparkline_display_vertical_position)
        if sparkline_fill_color is not None:
            pulumi.set(__self__, "sparkline_fill_color", sparkline_fill_color)
        if sparkline_line_color is not None:
            pulumi.set(__self__, "sparkline_line_color", sparkline_line_color)
        if sparkline_size is not None:
            pulumi.set(__self__, "sparkline_size", sparkline_size)
        if sparkline_value_color_map_apply_to is not None:
            pulumi.set(__self__, "sparkline_value_color_map_apply_to", sparkline_value_color_map_apply_to)
        if sparkline_value_color_map_colors is not None:
            pulumi.set(__self__, "sparkline_value_color_map_colors", sparkline_value_color_map_colors)
        if sparkline_value_color_map_values is not None:
            pulumi.set(__self__, "sparkline_value_color_map_values", sparkline_value_color_map_values)
        if sparkline_value_color_map_values_v2s is not None:
            pulumi.set(__self__, "sparkline_value_color_map_values_v2s", sparkline_value_color_map_values_v2s)
        if sparkline_value_text_map_texts is not None:
            pulumi.set(__self__, "sparkline_value_text_map_texts", sparkline_value_text_map_texts)
        if sparkline_value_text_map_thresholds is not None:
            pulumi.set(__self__, "sparkline_value_text_map_thresholds", sparkline_value_text_map_thresholds)
        if stack_type is not None:
            pulumi.set(__self__, "stack_type", stack_type)
        if tag_mode is not None:
            pulumi.set(__self__, "tag_mode", tag_mode)
        if time_based_coloring is not None:
            pulumi.set(__self__, "time_based_coloring", time_based_coloring)
        if window_size is not None:
            pulumi.set(__self__, "window_size", window_size)
        if windowing is not None:
            pulumi.set(__self__, "windowing", windowing)
        if xmax is not None:
            pulumi.set(__self__, "xmax", xmax)
        if xmin is not None:
            pulumi.set(__self__, "xmin", xmin)
        if y0_scale_si_by1024 is not None:
            pulumi.set(__self__, "y0_scale_si_by1024", y0_scale_si_by1024)
        if y0_unit_autoscaling is not None:
            pulumi.set(__self__, "y0_unit_autoscaling", y0_unit_autoscaling)
        if y1_scale_si_by1024 is not None:
            pulumi.set(__self__, "y1_scale_si_by1024", y1_scale_si_by1024)
        if y1_unit_autoscaling is not None:
            pulumi.set(__self__, "y1_unit_autoscaling", y1_unit_autoscaling)
        if y1_units is not None:
            pulumi.set(__self__, "y1_units", y1_units)
        if y1max is not None:
            pulumi.set(__self__, "y1max", y1max)
        if y1min is not None:
            pulumi.set(__self__, "y1min", y1min)
        if ymax is not None:
            pulumi.set(__self__, "ymax", ymax)
        if ymin is not None:
            pulumi.set(__self__, "ymin", ymin)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Chart Type. `line` refers to the Line Plot, `scatter` to the Point Plot, `stacked-area` to 
        the Stacked Area plot, `table` to the Tabular View, `scatterploy-xy` to Scatter Plot, `markdown-widget` to the
        Markdown display, and `sparkline` to the Single Stat view. Valid options are `line`, `scatterplot`,
        `stacked-area`, `stacked-column`, `table`, `scatterplot-xy`, `markdown-widget`, `sparkline`, `globe`, `nodemap`,
        `top-k`, `status-list`, `histogram`
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="autoColumnTags")
    def auto_column_tags(self) -> Optional[bool]:
        """
        deprecated
        """
        return pulumi.get(self, "auto_column_tags")

    @property
    @pulumi.getter(name="columnTags")
    def column_tags(self) -> Optional[str]:
        """
        deprecated
        """
        return pulumi.get(self, "column_tags")

    @property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[Sequence[str]]:
        """
        For the tabular view, a list of point tags to display when using the `custom` tag display mode
        """
        return pulumi.get(self, "custom_tags")

    @property
    @pulumi.getter(name="expectedDataSpacing")
    def expected_data_spacing(self) -> Optional[int]:
        """
        Threshold (in seconds) for time delta between consecutive points in a series
        above which a dotted line will replace a solid in in line plots. Default 60
        """
        return pulumi.get(self, "expected_data_spacing")

    @property
    @pulumi.getter(name="fixedLegendDisplayStats")
    def fixed_legend_display_stats(self) -> Optional[Sequence[str]]:
        """
        For a chart with a fixed legend, a list of statistics to display in the legend
        """
        return pulumi.get(self, "fixed_legend_display_stats")

    @property
    @pulumi.getter(name="fixedLegendEnabled")
    def fixed_legend_enabled(self) -> Optional[bool]:
        """
        Whether to enable a fixed tabular legend adjacent to the chart
        """
        return pulumi.get(self, "fixed_legend_enabled")

    @property
    @pulumi.getter(name="fixedLegendFilterField")
    def fixed_legend_filter_field(self) -> Optional[str]:
        """
        Statistic to use for determining whether a series is displayed on the fixed legend.
        Valid options are `CURRENT`, `MEAN`, `MEDIAN`, `SUM`, `MIN`, `MAX`, `COUNT`
        """
        return pulumi.get(self, "fixed_legend_filter_field")

    @property
    @pulumi.getter(name="fixedLegendFilterLimit")
    def fixed_legend_filter_limit(self) -> Optional[int]:
        """
        Number of series to include in the fixed legend
        """
        return pulumi.get(self, "fixed_legend_filter_limit")

    @property
    @pulumi.getter(name="fixedLegendFilterSort")
    def fixed_legend_filter_sort(self) -> Optional[str]:
        """
        Whether to display `TOP` or `BOTTOM` ranked series in a fixed legend. Valid options
        are `TOP`, and `BOTTOM`
        """
        return pulumi.get(self, "fixed_legend_filter_sort")

    @property
    @pulumi.getter(name="fixedLegendHideLabel")
    def fixed_legend_hide_label(self) -> Optional[bool]:
        """
        deprecated
        """
        return pulumi.get(self, "fixed_legend_hide_label")

    @property
    @pulumi.getter(name="fixedLegendPosition")
    def fixed_legend_position(self) -> Optional[str]:
        """
        Where the fixed legend should be displayed with respect ot the chart.
        Valid options are `RIGHt`, `TOP`, `LEFT`, `BOTTOM`
        """
        return pulumi.get(self, "fixed_legend_position")

    @property
    @pulumi.getter(name="fixedLegendUseRawStats")
    def fixed_legend_use_raw_stats(self) -> Optional[bool]:
        """
        If `true`, the legend uses non-summarized stats instead of summarized
        """
        return pulumi.get(self, "fixed_legend_use_raw_stats")

    @property
    @pulumi.getter(name="groupBySource")
    def group_by_source(self) -> Optional[bool]:
        """
        For the tabular view, whether to group multi metrics into a single row by a common source.
        If `false`, each source is displayed in its own row.  if `true`, multiple metrics for the same host will be displayed as different
        columns in the same row
        """
        return pulumi.get(self, "group_by_source")

    @property
    @pulumi.getter(name="invertDynamicLegendHoverControl")
    def invert_dynamic_legend_hover_control(self) -> Optional[bool]:
        """
        Whether to disable the display of the floating legend (but
        reenable it when the ctrl-key is pressed)
        """
        return pulumi.get(self, "invert_dynamic_legend_hover_control")

    @property
    @pulumi.getter(name="lineType")
    def line_type(self) -> Optional[str]:
        """
        Plot interpolation type.  `linear` is default. Valid options are `linear`, `step-before`, 
        `step-after`, `basis`, `cardinal`, `monotone`
        """
        return pulumi.get(self, "line_type")

    @property
    @pulumi.getter
    def max(self) -> Optional[float]:
        """
        Max value of the Y-axis. Set to null or leave blank for auto
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> Optional[float]:
        """
        Min value of the Y-axis. Set to null or leave blank for auto
        """
        return pulumi.get(self, "min")

    @property
    @pulumi.getter(name="numTags")
    def num_tags(self) -> Optional[int]:
        """
        For the tabular view, how many point tags to display
        """
        return pulumi.get(self, "num_tags")

    @property
    @pulumi.getter(name="plainMarkdownContent")
    def plain_markdown_content(self) -> Optional[str]:
        """
        The markdown content for a Markdown display, in plain text.
        """
        return pulumi.get(self, "plain_markdown_content")

    @property
    @pulumi.getter(name="showHosts")
    def show_hosts(self) -> Optional[bool]:
        """
        For the tabular view, whether to display sources. Default is `true`
        """
        return pulumi.get(self, "show_hosts")

    @property
    @pulumi.getter(name="showLabels")
    def show_labels(self) -> Optional[bool]:
        """
        For the tabular view, whether to display labels. Default is `true`
        """
        return pulumi.get(self, "show_labels")

    @property
    @pulumi.getter(name="showRawValues")
    def show_raw_values(self) -> Optional[bool]:
        """
        For the tabular view, whether to display raw values. Default is `false`
        """
        return pulumi.get(self, "show_raw_values")

    @property
    @pulumi.getter(name="sortValuesDescending")
    def sort_values_descending(self) -> Optional[bool]:
        """
        For the tabular view, whether to display display values in descending order. Default is `false`
        """
        return pulumi.get(self, "sort_values_descending")

    @property
    @pulumi.getter(name="sparklineDecimalPrecision")
    def sparkline_decimal_precision(self) -> Optional[int]:
        """
        For the single stat view, the decimal precision of the displayed number
        """
        return pulumi.get(self, "sparkline_decimal_precision")

    @property
    @pulumi.getter(name="sparklineDisplayColor")
    def sparkline_display_color(self) -> Optional[str]:
        """
        For the single stat view, the color of the displayed text (when not dynamically determined). 
        Values should be in `rgba(,,,,)` format
        """
        return pulumi.get(self, "sparkline_display_color")

    @property
    @pulumi.getter(name="sparklineDisplayFontSize")
    def sparkline_display_font_size(self) -> Optional[str]:
        """
        For the single stat view, the font size of the displayed text, in percent
        """
        return pulumi.get(self, "sparkline_display_font_size")

    @property
    @pulumi.getter(name="sparklineDisplayHorizontalPosition")
    def sparkline_display_horizontal_position(self) -> Optional[str]:
        """
        For the single stat view, the horizontal position of the displayed text.
        Valid options are `MIDDLE`, `LEFT`, `RIGHT`
        """
        return pulumi.get(self, "sparkline_display_horizontal_position")

    @property
    @pulumi.getter(name="sparklineDisplayPostfix")
    def sparkline_display_postfix(self) -> Optional[str]:
        """
        For the single stat view, a string to append to the displayed text
        """
        return pulumi.get(self, "sparkline_display_postfix")

    @property
    @pulumi.getter(name="sparklineDisplayPrefix")
    def sparkline_display_prefix(self) -> Optional[str]:
        """
        For the single stat view, a string to add before the displayed text
        """
        return pulumi.get(self, "sparkline_display_prefix")

    @property
    @pulumi.getter(name="sparklineDisplayValueType")
    def sparkline_display_value_type(self) -> Optional[str]:
        """
        For the single stat view, where to display the name of the query or the value of the query.
        Valid options are `VALUE` or `LABEL`
        """
        return pulumi.get(self, "sparkline_display_value_type")

    @property
    @pulumi.getter(name="sparklineDisplayVerticalPosition")
    def sparkline_display_vertical_position(self) -> Optional[str]:
        """
        deprecated
        """
        return pulumi.get(self, "sparkline_display_vertical_position")

    @property
    @pulumi.getter(name="sparklineFillColor")
    def sparkline_fill_color(self) -> Optional[str]:
        """
        For the single stat view, the color of the background fill.  Values should be
        in `rgba(,,,,)`
        """
        return pulumi.get(self, "sparkline_fill_color")

    @property
    @pulumi.getter(name="sparklineLineColor")
    def sparkline_line_color(self) -> Optional[str]:
        """
        For the single stat view, the color of the line.  Values should be in `rgba(,,,,)` format
        """
        return pulumi.get(self, "sparkline_line_color")

    @property
    @pulumi.getter(name="sparklineSize")
    def sparkline_size(self) -> Optional[str]:
        """
        For the single stat view, This determines whether the sparkline of the statistic is displayed in the chart `BACKGROUND`, `BOTTOM`, or `NONE`.
        Valid options are `BACKGROUND`, `BOTTOM`, `NONE`
        """
        return pulumi.get(self, "sparkline_size")

    @property
    @pulumi.getter(name="sparklineValueColorMapApplyTo")
    def sparkline_value_color_map_apply_to(self) -> Optional[str]:
        """
        For the single stat view, whether to apply dyunamic color settings to 
        the displayed `TEXT` or `BACKGROUND`. Valid options are `TEXT` or `BACKGROUND`
        """
        return pulumi.get(self, "sparkline_value_color_map_apply_to")

    @property
    @pulumi.getter(name="sparklineValueColorMapColors")
    def sparkline_value_color_map_colors(self) -> Optional[Sequence[str]]:
        """
        For the single stat view, A list of colors that differing query values map to. 
        Must contain one more element than `sparkline_value_color_map_values_v2`. Values should be in `rgba(,,,,)`
        """
        return pulumi.get(self, "sparkline_value_color_map_colors")

    @property
    @pulumi.getter(name="sparklineValueColorMapValues")
    def sparkline_value_color_map_values(self) -> Optional[Sequence[int]]:
        """
        deprecated
        """
        return pulumi.get(self, "sparkline_value_color_map_values")

    @property
    @pulumi.getter(name="sparklineValueColorMapValuesV2s")
    def sparkline_value_color_map_values_v2s(self) -> Optional[Sequence[float]]:
        """
        For the single stat view, a list of boundaries for mapping different
        query values to colors.  Must contain one less element than `sparkline_value_color_map_colors`
        """
        return pulumi.get(self, "sparkline_value_color_map_values_v2s")

    @property
    @pulumi.getter(name="sparklineValueTextMapTexts")
    def sparkline_value_text_map_texts(self) -> Optional[Sequence[str]]:
        """
        For the single stat view, a list of display text values that different query
        values map to.  Must contain one more element than `sparkline_value_text_map_thresholds`
        """
        return pulumi.get(self, "sparkline_value_text_map_texts")

    @property
    @pulumi.getter(name="sparklineValueTextMapThresholds")
    def sparkline_value_text_map_thresholds(self) -> Optional[Sequence[float]]:
        """
        For the single stat view, a list of threshold boundaries for 
        mapping different query values to display text.  Must contain one less element than `sparkline_value_text_map_text`
        """
        return pulumi.get(self, "sparkline_value_text_map_thresholds")

    @property
    @pulumi.getter(name="stackType")
    def stack_type(self) -> Optional[str]:
        """
        Type of stacked chart (applicable only if chart type is `stacked`). `zero` (default) means
        stacked from y=0. `expand` means normalized from 0 to 1.  `wiggle` means minimize weighted changes. `silhouette` means to
        center the stream. Valid options are `zero`, `expand`, `wiggle`, `silhouette`, `bars`
        """
        return pulumi.get(self, "stack_type")

    @property
    @pulumi.getter(name="tagMode")
    def tag_mode(self) -> Optional[str]:
        """
        For the tabular view, which mode to use to determine which point tags to display.
        Valid options are `all`, `top`, or `custom`
        """
        return pulumi.get(self, "tag_mode")

    @property
    @pulumi.getter(name="timeBasedColoring")
    def time_based_coloring(self) -> Optional[bool]:
        """
        For x-y scatterplots, whether to color more recent points as darker than older points
        """
        return pulumi.get(self, "time_based_coloring")

    @property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[int]:
        """
        Width, in minutes, of the time window to use for `last` windowing
        """
        return pulumi.get(self, "window_size")

    @property
    @pulumi.getter
    def windowing(self) -> Optional[str]:
        """
        For the tabular view, whether to use the full time window for the query or the last X minutes.
        Valid options are `full` or `last`
        """
        return pulumi.get(self, "windowing")

    @property
    @pulumi.getter
    def xmax(self) -> Optional[float]:
        """
        For x-y scatterplots, max value for the X-axis. Set to null for auto
        """
        return pulumi.get(self, "xmax")

    @property
    @pulumi.getter
    def xmin(self) -> Optional[float]:
        """
        For x-y scatterplots, min value for the X-axis. Set to null for auto
        """
        return pulumi.get(self, "xmin")

    @property
    @pulumi.getter(name="y0ScaleSiBy1024")
    def y0_scale_si_by1024(self) -> Optional[bool]:
        """
        Whether to scale numerical magnitude labels for left Y-axis by 1024 in the IEC/Binary manner (instead of by 1000 like SI)
        """
        return pulumi.get(self, "y0_scale_si_by1024")

    @property
    @pulumi.getter(name="y0UnitAutoscaling")
    def y0_unit_autoscaling(self) -> Optional[bool]:
        """
        Whether to automatically adjust magnitude labels and units for the left Y-axis to favor smaller magnitudes and larger units
        """
        return pulumi.get(self, "y0_unit_autoscaling")

    @property
    @pulumi.getter(name="y1ScaleSiBy1024")
    def y1_scale_si_by1024(self) -> Optional[bool]:
        """
        Whether to scale numerical magnitude labels for right Y-axis by 1024 in the IEC/Binary manner (instead of by 1000 like SI)
        """
        return pulumi.get(self, "y1_scale_si_by1024")

    @property
    @pulumi.getter(name="y1UnitAutoscaling")
    def y1_unit_autoscaling(self) -> Optional[bool]:
        """
        Whether to automatically adjust magnitude labels and units for the right Y-axis to favor smaller magnitudes and larger units
        """
        return pulumi.get(self, "y1_unit_autoscaling")

    @property
    @pulumi.getter(name="y1Units")
    def y1_units(self) -> Optional[str]:
        """
        For plots with multiple Y-axes, units for right side Y-axis
        """
        return pulumi.get(self, "y1_units")

    @property
    @pulumi.getter
    def y1max(self) -> Optional[float]:
        """
        For plots with multiple Y-axes, max value for the right side Y-axis. Set null for auto
        """
        return pulumi.get(self, "y1max")

    @property
    @pulumi.getter
    def y1min(self) -> Optional[float]:
        """
        For plots with multiple Y-axes, min value for the right side Y-axis. Set null for auto
        """
        return pulumi.get(self, "y1min")

    @property
    @pulumi.getter
    def ymax(self) -> Optional[float]:
        """
        For x-y scatterplots, max value for the Y-axis. Set to null for auto
        """
        return pulumi.get(self, "ymax")

    @property
    @pulumi.getter
    def ymin(self) -> Optional[float]:
        """
        For x-y scatterplots, min value for the Y-axis. Set to null for auto
        """
        return pulumi.get(self, "ymin")


@pulumi.output_type
class DashboardSectionRowChartSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryBuilderEnabled":
            suggest = "query_builder_enabled"
        elif key == "scatterPlotSource":
            suggest = "scatter_plot_source"
        elif key == "sourceDescription":
            suggest = "source_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardSectionRowChartSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardSectionRowChartSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardSectionRowChartSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 query: str,
                 disabled: Optional[bool] = None,
                 query_builder_enabled: Optional[bool] = None,
                 scatter_plot_source: Optional[str] = None,
                 source_description: Optional[str] = None):
        """
        :param str name: Name of the source
        :param str query: Query expression to plot on the chart
        :param bool disabled: Whether the source is disabled
        :param bool query_builder_enabled: Whether oir not this source line should have the query builder enabled
        :param str scatter_plot_source: For scatter plots, does this query source the X-axis or the Y-axis, `X`, or `Y`.
        :param str source_description: A description for the purpose of this source
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "query", query)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if query_builder_enabled is not None:
            pulumi.set(__self__, "query_builder_enabled", query_builder_enabled)
        if scatter_plot_source is not None:
            pulumi.set(__self__, "scatter_plot_source", scatter_plot_source)
        if source_description is not None:
            pulumi.set(__self__, "source_description", source_description)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the source
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        Query expression to plot on the chart
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        Whether the source is disabled
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="queryBuilderEnabled")
    def query_builder_enabled(self) -> Optional[bool]:
        """
        Whether oir not this source line should have the query builder enabled
        """
        return pulumi.get(self, "query_builder_enabled")

    @property
    @pulumi.getter(name="scatterPlotSource")
    def scatter_plot_source(self) -> Optional[str]:
        """
        For scatter plots, does this query source the X-axis or the Y-axis, `X`, or `Y`.
        """
        return pulumi.get(self, "scatter_plot_source")

    @property
    @pulumi.getter(name="sourceDescription")
    def source_description(self) -> Optional[str]:
        """
        A description for the purpose of this source
        """
        return pulumi.get(self, "source_description")


