# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[str],
                 customer: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[str] email: The (unique) identifier of the user to create. Must be a valid email address
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permissions: List of permission to grant to this user.  Valid options are
               `agent_management`, `alerts_management`, `dashboard_management`, `embedded_charts`, `events_management`, `external_links_management`,
               `host_tag_management`, `metrics_management`, `user_management`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_groups: List of user groups to this user
        """
        pulumi.set(__self__, "email", email)
        if customer is not None:
            pulumi.set(__self__, "customer", customer)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if user_groups is not None:
            pulumi.set(__self__, "user_groups", user_groups)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[str]:
        """
        The (unique) identifier of the user to create. Must be a valid email address
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def customer(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "customer")

    @customer.setter
    def customer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of permission to grant to this user.  Valid options are
        `agent_management`, `alerts_management`, `dashboard_management`, `embedded_charts`, `events_management`, `external_links_management`,
        `host_tag_management`, `metrics_management`, `user_management`
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter(name="userGroups")
    def user_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of user groups to this user
        """
        return pulumi.get(self, "user_groups")

    @user_groups.setter
    def user_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_groups", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 customer: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[str] email: The (unique) identifier of the user to create. Must be a valid email address
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permissions: List of permission to grant to this user.  Valid options are
               `agent_management`, `alerts_management`, `dashboard_management`, `embedded_charts`, `events_management`, `external_links_management`,
               `host_tag_management`, `metrics_management`, `user_management`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_groups: List of user groups to this user
        """
        if customer is not None:
            pulumi.set(__self__, "customer", customer)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if user_groups is not None:
            pulumi.set(__self__, "user_groups", user_groups)

    @property
    @pulumi.getter
    def customer(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "customer")

    @customer.setter
    def customer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The (unique) identifier of the user to create. Must be a valid email address
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of permission to grant to this user.  Valid options are
        `agent_management`, `alerts_management`, `dashboard_management`, `embedded_charts`, `events_management`, `external_links_management`,
        `host_tag_management`, `metrics_management`, `user_management`
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter(name="userGroups")
    def user_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of user groups to this user
        """
        return pulumi.get(self, "user_groups")

    @user_groups.setter
    def user_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_groups", value)


class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a Wavefront User Resource. This allows users to be created, updated, and deleted.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_wavefront as wavefront

        basic = wavefront.User("basic", email="test+tftesting@example.com")
        ```

        ## Import

        Users can be imported using the `id`, e.g.

        ```sh
         $ pulumi import wavefront:index/user:User some_user test@example.com
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] email: The (unique) identifier of the user to create. Must be a valid email address
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permissions: List of permission to grant to this user.  Valid options are
               `agent_management`, `alerts_management`, `dashboard_management`, `embedded_charts`, `events_management`, `external_links_management`,
               `host_tag_management`, `metrics_management`, `user_management`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_groups: List of user groups to this user
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Wavefront User Resource. This allows users to be created, updated, and deleted.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_wavefront as wavefront

        basic = wavefront.User("basic", email="test+tftesting@example.com")
        ```

        ## Import

        Users can be imported using the `id`, e.g.

        ```sh
         $ pulumi import wavefront:index/user:User some_user test@example.com
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer: Optional[pulumi.Input[str]] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["customer"] = customer
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            __props__.__dict__["permissions"] = permissions
            __props__.__dict__["user_groups"] = user_groups
        super(User, __self__).__init__(
            'wavefront:index/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            customer: Optional[pulumi.Input[str]] = None,
            email: Optional[pulumi.Input[str]] = None,
            permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            user_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] email: The (unique) identifier of the user to create. Must be a valid email address
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permissions: List of permission to grant to this user.  Valid options are
               `agent_management`, `alerts_management`, `dashboard_management`, `embedded_charts`, `events_management`, `external_links_management`,
               `host_tag_management`, `metrics_management`, `user_management`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_groups: List of user groups to this user
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["customer"] = customer
        __props__.__dict__["email"] = email
        __props__.__dict__["permissions"] = permissions
        __props__.__dict__["user_groups"] = user_groups
        return User(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def customer(self) -> pulumi.Output[str]:
        return pulumi.get(self, "customer")

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[str]:
        """
        The (unique) identifier of the user to create. Must be a valid email address
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Sequence[str]]:
        """
        List of permission to grant to this user.  Valid options are
        `agent_management`, `alerts_management`, `dashboard_management`, `embedded_charts`, `events_management`, `external_links_management`,
        `host_tag_management`, `metrics_management`, `user_management`
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter(name="userGroups")
    def user_groups(self) -> pulumi.Output[Sequence[str]]:
        """
        List of user groups to this user
        """
        return pulumi.get(self, "user_groups")

