# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/CLI_Version.ipynb (unless otherwise specified).

__all__ = ["logger"]

# Cell

from typing import *

# Internal Cell

import typer
import logging
from tabulate import tabulate
import pandas as pd

from ..client import Client
from ..logger import get_logger, set_level

# Internal Cell

app = typer.Typer()

# Cell

logger = get_logger(__name__)

# Internal Cell


def version() -> None:
    """Return the server and client versions."""
    try:
        df = pd.Series(Client.version(), name="Version").to_frame()

        typer.echo(tabulate(df, headers="keys", tablefmt="plain"))

    except Exception as e:
        typer.echo(message=f"Error: {e}", err=True)
        raise typer.Exit(code=1)


# Internal Cell


app.command()(version)
