# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class DuosFirecloudGroupModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'duos_id': 'str',
        'firecloud_group_name': 'str',
        'firecloud_group_email': 'str',
        'created_by': 'str',
        'created': 'str',
        'last_synced': 'str'
    }

    attribute_map = {
        'id': 'id',
        'duos_id': 'duosId',
        'firecloud_group_name': 'firecloudGroupName',
        'firecloud_group_email': 'firecloudGroupEmail',
        'created_by': 'createdBy',
        'created': 'created',
        'last_synced': 'lastSynced'
    }

    def __init__(self, id=None, duos_id=None, firecloud_group_name=None, firecloud_group_email=None, created_by=None, created=None, last_synced=None, local_vars_configuration=None):  # noqa: E501
        """DuosFirecloudGroupModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._duos_id = None
        self._firecloud_group_name = None
        self._firecloud_group_email = None
        self._created_by = None
        self._created = None
        self._last_synced = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if duos_id is not None:
            self.duos_id = duos_id
        if firecloud_group_name is not None:
            self.firecloud_group_name = firecloud_group_name
        if firecloud_group_email is not None:
            self.firecloud_group_email = firecloud_group_email
        if created_by is not None:
            self.created_by = created_by
        if created is not None:
            self.created = created
        if last_synced is not None:
            self.last_synced = last_synced

    @property
    def id(self):
        """Gets the id of this DuosFirecloudGroupModel.  # noqa: E501

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :return: The id of this DuosFirecloudGroupModel.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this DuosFirecloudGroupModel.

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :param id: The id of this DuosFirecloudGroupModel.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def duos_id(self):
        """Gets the duos_id of this DuosFirecloudGroupModel.  # noqa: E501

        DUOS dataset identifier  # noqa: E501

        :return: The duos_id of this DuosFirecloudGroupModel.  # noqa: E501
        :rtype: str
        """
        return self._duos_id

    @duos_id.setter
    def duos_id(self, duos_id):
        """Sets the duos_id of this DuosFirecloudGroupModel.

        DUOS dataset identifier  # noqa: E501

        :param duos_id: The duos_id of this DuosFirecloudGroupModel.  # noqa: E501
        :type: str
        """

        self._duos_id = duos_id

    @property
    def firecloud_group_name(self):
        """Gets the firecloud_group_name of this DuosFirecloudGroupModel.  # noqa: E501

        Name of Firecloud managed group  # noqa: E501

        :return: The firecloud_group_name of this DuosFirecloudGroupModel.  # noqa: E501
        :rtype: str
        """
        return self._firecloud_group_name

    @firecloud_group_name.setter
    def firecloud_group_name(self, firecloud_group_name):
        """Sets the firecloud_group_name of this DuosFirecloudGroupModel.

        Name of Firecloud managed group  # noqa: E501

        :param firecloud_group_name: The firecloud_group_name of this DuosFirecloudGroupModel.  # noqa: E501
        :type: str
        """

        self._firecloud_group_name = firecloud_group_name

    @property
    def firecloud_group_email(self):
        """Gets the firecloud_group_email of this DuosFirecloudGroupModel.  # noqa: E501

        Email of Firecloud managed group  # noqa: E501

        :return: The firecloud_group_email of this DuosFirecloudGroupModel.  # noqa: E501
        :rtype: str
        """
        return self._firecloud_group_email

    @firecloud_group_email.setter
    def firecloud_group_email(self, firecloud_group_email):
        """Sets the firecloud_group_email of this DuosFirecloudGroupModel.

        Email of Firecloud managed group  # noqa: E501

        :param firecloud_group_email: The firecloud_group_email of this DuosFirecloudGroupModel.  # noqa: E501
        :type: str
        """

        self._firecloud_group_email = firecloud_group_email

    @property
    def created_by(self):
        """Gets the created_by of this DuosFirecloudGroupModel.  # noqa: E501

        The TDR service account which created this group  # noqa: E501

        :return: The created_by of this DuosFirecloudGroupModel.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this DuosFirecloudGroupModel.

        The TDR service account which created this group  # noqa: E501

        :param created_by: The created_by of this DuosFirecloudGroupModel.  # noqa: E501
        :type: str
        """

        self._created_by = created_by

    @property
    def created(self):
        """Gets the created of this DuosFirecloudGroupModel.  # noqa: E501

        Time when TDR created this group  # noqa: E501

        :return: The created of this DuosFirecloudGroupModel.  # noqa: E501
        :rtype: str
        """
        return self._created

    @created.setter
    def created(self, created):
        """Sets the created of this DuosFirecloudGroupModel.

        Time when TDR created this group  # noqa: E501

        :param created: The created of this DuosFirecloudGroupModel.  # noqa: E501
        :type: str
        """

        self._created = created

    @property
    def last_synced(self):
        """Gets the last_synced of this DuosFirecloudGroupModel.  # noqa: E501

        Last time TDR queried DUOS for its dataset's authorized users  # noqa: E501

        :return: The last_synced of this DuosFirecloudGroupModel.  # noqa: E501
        :rtype: str
        """
        return self._last_synced

    @last_synced.setter
    def last_synced(self, last_synced):
        """Sets the last_synced of this DuosFirecloudGroupModel.

        Last time TDR queried DUOS for its dataset's authorized users  # noqa: E501

        :param last_synced: The last_synced of this DuosFirecloudGroupModel.  # noqa: E501
        :type: str
        """

        self._last_synced = last_synced

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DuosFirecloudGroupModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DuosFirecloudGroupModel):
            return True

        return self.to_dict() != other.to_dict()
