# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from data_repo_client.configuration import Configuration


class JournalEntryModel(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'resource_key': 'str',
        'user': 'str',
        'resource_type': 'IamResourceTypeEnum',
        'class_name': 'str',
        'method_name': 'str',
        'entry_type': 'str',
        'when': 'str',
        'mutation': 'object',
        'note': 'str'
    }

    attribute_map = {
        'id': 'id',
        'resource_key': 'resourceKey',
        'user': 'user',
        'resource_type': 'resourceType',
        'class_name': 'className',
        'method_name': 'methodName',
        'entry_type': 'entryType',
        'when': 'when',
        'mutation': 'mutation',
        'note': 'note'
    }

    def __init__(self, id=None, resource_key=None, user=None, resource_type=None, class_name=None, method_name=None, entry_type=None, when=None, mutation=None, note=None, local_vars_configuration=None):  # noqa: E501
        """JournalEntryModel - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._resource_key = None
        self._user = None
        self._resource_type = None
        self._class_name = None
        self._method_name = None
        self._entry_type = None
        self._when = None
        self._mutation = None
        self._note = None
        self.discriminator = None

        self.id = id
        self.resource_key = resource_key
        self.user = user
        self.resource_type = resource_type
        self.class_name = class_name
        self.method_name = method_name
        self.entry_type = entry_type
        self.when = when
        if mutation is not None:
            self.mutation = mutation
        if note is not None:
            self.note = note

    @property
    def id(self):
        """Gets the id of this JournalEntryModel.  # noqa: E501

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :return: The id of this JournalEntryModel.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this JournalEntryModel.

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :param id: The id of this JournalEntryModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def resource_key(self):
        """Gets the resource_key of this JournalEntryModel.  # noqa: E501

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :return: The resource_key of this JournalEntryModel.  # noqa: E501
        :rtype: str
        """
        return self._resource_key

    @resource_key.setter
    def resource_key(self, resource_key):
        """Sets the resource_key of this JournalEntryModel.

        Unique identifier for a dataset, snapshot, etc.   # noqa: E501

        :param resource_key: The resource_key of this JournalEntryModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and resource_key is None:  # noqa: E501
            raise ValueError("Invalid value for `resource_key`, must not be `None`")  # noqa: E501

        self._resource_key = resource_key

    @property
    def user(self):
        """Gets the user of this JournalEntryModel.  # noqa: E501

        the email address of the user who performed this action  # noqa: E501

        :return: The user of this JournalEntryModel.  # noqa: E501
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this JournalEntryModel.

        the email address of the user who performed this action  # noqa: E501

        :param user: The user of this JournalEntryModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and user is None:  # noqa: E501
            raise ValueError("Invalid value for `user`, must not be `None`")  # noqa: E501

        self._user = user

    @property
    def resource_type(self):
        """Gets the resource_type of this JournalEntryModel.  # noqa: E501


        :return: The resource_type of this JournalEntryModel.  # noqa: E501
        :rtype: IamResourceTypeEnum
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this JournalEntryModel.


        :param resource_type: The resource_type of this JournalEntryModel.  # noqa: E501
        :type: IamResourceTypeEnum
        """
        if self.local_vars_configuration.client_side_validation and resource_type is None:  # noqa: E501
            raise ValueError("Invalid value for `resource_type`, must not be `None`")  # noqa: E501

        self._resource_type = resource_type

    @property
    def class_name(self):
        """Gets the class_name of this JournalEntryModel.  # noqa: E501

        the class name that made this journal entry  # noqa: E501

        :return: The class_name of this JournalEntryModel.  # noqa: E501
        :rtype: str
        """
        return self._class_name

    @class_name.setter
    def class_name(self, class_name):
        """Sets the class_name of this JournalEntryModel.

        the class name that made this journal entry  # noqa: E501

        :param class_name: The class_name of this JournalEntryModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and class_name is None:  # noqa: E501
            raise ValueError("Invalid value for `class_name`, must not be `None`")  # noqa: E501

        self._class_name = class_name

    @property
    def method_name(self):
        """Gets the method_name of this JournalEntryModel.  # noqa: E501

        the method name that made this journal entry  # noqa: E501

        :return: The method_name of this JournalEntryModel.  # noqa: E501
        :rtype: str
        """
        return self._method_name

    @method_name.setter
    def method_name(self, method_name):
        """Sets the method_name of this JournalEntryModel.

        the method name that made this journal entry  # noqa: E501

        :param method_name: The method_name of this JournalEntryModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and method_name is None:  # noqa: E501
            raise ValueError("Invalid value for `method_name`, must not be `None`")  # noqa: E501

        self._method_name = method_name

    @property
    def entry_type(self):
        """Gets the entry_type of this JournalEntryModel.  # noqa: E501

        the type of journal entry created  # noqa: E501

        :return: The entry_type of this JournalEntryModel.  # noqa: E501
        :rtype: str
        """
        return self._entry_type

    @entry_type.setter
    def entry_type(self, entry_type):
        """Sets the entry_type of this JournalEntryModel.

        the type of journal entry created  # noqa: E501

        :param entry_type: The entry_type of this JournalEntryModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and entry_type is None:  # noqa: E501
            raise ValueError("Invalid value for `entry_type`, must not be `None`")  # noqa: E501
        allowed_values = ["CREATE", "UPDATE", "DELETE"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and entry_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `entry_type` ({0}), must be one of {1}"  # noqa: E501
                .format(entry_type, allowed_values)
            )

        self._entry_type = entry_type

    @property
    def when(self):
        """Gets the when of this JournalEntryModel.  # noqa: E501

        timestamp of journal entry creation  # noqa: E501

        :return: The when of this JournalEntryModel.  # noqa: E501
        :rtype: str
        """
        return self._when

    @when.setter
    def when(self, when):
        """Sets the when of this JournalEntryModel.

        timestamp of journal entry creation  # noqa: E501

        :param when: The when of this JournalEntryModel.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and when is None:  # noqa: E501
            raise ValueError("Invalid value for `when`, must not be `None`")  # noqa: E501

        self._when = when

    @property
    def mutation(self):
        """Gets the mutation of this JournalEntryModel.  # noqa: E501

        An optional map included with the journal entry.  Entries in the map ending with .json are entries that likely contain JSON encoded strings.  # noqa: E501

        :return: The mutation of this JournalEntryModel.  # noqa: E501
        :rtype: object
        """
        return self._mutation

    @mutation.setter
    def mutation(self, mutation):
        """Sets the mutation of this JournalEntryModel.

        An optional map included with the journal entry.  Entries in the map ending with .json are entries that likely contain JSON encoded strings.  # noqa: E501

        :param mutation: The mutation of this JournalEntryModel.  # noqa: E501
        :type: object
        """

        self._mutation = mutation

    @property
    def note(self):
        """Gets the note of this JournalEntryModel.  # noqa: E501

        A note about the journal entry  # noqa: E501

        :return: The note of this JournalEntryModel.  # noqa: E501
        :rtype: str
        """
        return self._note

    @note.setter
    def note(self, note):
        """Sets the note of this JournalEntryModel.

        A note about the journal entry  # noqa: E501

        :param note: The note of this JournalEntryModel.  # noqa: E501
        :type: str
        """

        self._note = note

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JournalEntryModel):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, JournalEntryModel):
            return True

        return self.to_dict() != other.to_dict()
