# mypy-boto3-cloudwatch

[![PyPI - mypy-boto3-cloudwatch](https://img.shields.io/pypi/v/mypy-boto3-cloudwatch.svg?color=blue)](https://pypi.org/project/mypy-boto3-cloudwatch)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-cloudwatch.svg?color=blue)](https://pypi.org/project/mypy-boto3-cloudwatch)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.CloudWatch 1.12.28](https://boto3.amazonaws.com/v1/documentation/api/1.12.28/reference/services/cloudwatch.html#CloudWatch) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.5](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-cloudwatch](#mypy-boto3-cloudwatch)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `CloudWatch` service.

```bash
python -m pip install boto3-stubs[mypy-boto3-cloudwatch]
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import cloudwatch
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_cloudwatch as cloudwatch

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("cloudwatch")
client: cloudwatch.CloudWatchClient = boto3.client("cloudwatch")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: cloudwatch.CloudWatchClient = session.client("cloudwatch")

# Do you prefer resource approach? We've got you covered!
resource: cloudwatch.CloudWatchServiceResource = boto3.resource("cloudwatch")

# Waiters need type annotation on creation
alarm_exists_waiter: cloudwatch.AlarmExistsWaiter = client.get_waiter("alarm_exists")
composite_alarm_exists_waiter: cloudwatch.CompositeAlarmExistsWaiter = client.get_waiter("composite_alarm_exists")

# Paginators need type annotation on creation
describe_alarm_history_paginator: cloudwatch.DescribeAlarmHistoryPaginator = client.get_paginator("describe_alarm_history")
describe_alarms_paginator: cloudwatch.DescribeAlarmsPaginator = client.get_paginator("describe_alarms")
get_metric_data_paginator: cloudwatch.GetMetricDataPaginator = client.get_paginator("get_metric_data")
list_dashboards_paginator: cloudwatch.ListDashboardsPaginator = client.get_paginator("list_dashboards")
list_metrics_paginator: cloudwatch.ListMetricsPaginator = client.get_paginator("list_metrics")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.