# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['CloudInitDisk']


class CloudInitDisk(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 meta_data: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_config: Optional[pulumi.Input[str]] = None,
                 pool: Optional[pulumi.Input[str]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a CloudInitDisk resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] meta_data: cloud-init user data.
        :param pulumi.Input[str] name: A unique name for the resource, required by libvirt.
        :param pulumi.Input[str] network_config: cloud-init network-config data.
        :param pulumi.Input[str] pool: The pool where the resource will be created.
               If not given, the `default` pool will be used.
               For user_data, network_config and meta_data parameters have a look at upstream doc:
               http://cloudinit.readthedocs.io/en/latest/topics/datasources/nocloud.html#datasource-nocloud
        :param pulumi.Input[str] user_data: cloud-init user data.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['meta_data'] = meta_data
            __props__['name'] = name
            __props__['network_config'] = network_config
            __props__['pool'] = pool
            __props__['user_data'] = user_data
        super(CloudInitDisk, __self__).__init__(
            'libvirt:index/cloudInitDisk:CloudInitDisk',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            meta_data: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_config: Optional[pulumi.Input[str]] = None,
            pool: Optional[pulumi.Input[str]] = None,
            user_data: Optional[pulumi.Input[str]] = None) -> 'CloudInitDisk':
        """
        Get an existing CloudInitDisk resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] meta_data: cloud-init user data.
        :param pulumi.Input[str] name: A unique name for the resource, required by libvirt.
        :param pulumi.Input[str] network_config: cloud-init network-config data.
        :param pulumi.Input[str] pool: The pool where the resource will be created.
               If not given, the `default` pool will be used.
               For user_data, network_config and meta_data parameters have a look at upstream doc:
               http://cloudinit.readthedocs.io/en/latest/topics/datasources/nocloud.html#datasource-nocloud
        :param pulumi.Input[str] user_data: cloud-init user data.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["meta_data"] = meta_data
        __props__["name"] = name
        __props__["network_config"] = network_config
        __props__["pool"] = pool
        __props__["user_data"] = user_data
        return CloudInitDisk(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="metaData")
    def meta_data(self) -> pulumi.Output[Optional[str]]:
        """
        cloud-init user data.
        """
        return pulumi.get(self, "meta_data")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A unique name for the resource, required by libvirt.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> pulumi.Output[Optional[str]]:
        """
        cloud-init network-config data.
        """
        return pulumi.get(self, "network_config")

    @property
    @pulumi.getter
    def pool(self) -> pulumi.Output[Optional[str]]:
        """
        The pool where the resource will be created.
        If not given, the `default` pool will be used.
        For user_data, network_config and meta_data parameters have a look at upstream doc:
        http://cloudinit.readthedocs.io/en/latest/topics/datasources/nocloud.html#datasource-nocloud
        """
        return pulumi.get(self, "pool")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[str]]:
        """
        cloud-init user data.
        """
        return pulumi.get(self, "user_data")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

