# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Network']


class Network(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 autostart: Optional[pulumi.Input[bool]] = None,
                 bridge: Optional[pulumi.Input[str]] = None,
                 dhcp: Optional[pulumi.Input[pulumi.InputType['NetworkDhcpArgs']]] = None,
                 dns: Optional[pulumi.Input[pulumi.InputType['NetworkDnsArgs']]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 mtu: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkRouteArgs']]]]] = None,
                 xml: Optional[pulumi.Input[pulumi.InputType['NetworkXmlArgs']]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a VM network resource within libvirt. For more information see
        [the official documentation](https://libvirt.org/formatnetwork.html).

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] addresses: A list of (0 or 1) IPv4 and (0 or 1) IPv6 subnets in
               CIDR notation.  This defines the subnets associated to that network.
               This argument is also used to define the address on the real host.
               If `dhcp {  enabled = true }` addresses is also used to define the address range served by
               the DHCP server.
               No DHCP server will be started if `addresses` is omitted.
        :param pulumi.Input[bool] autostart: Set to `true` to start the network on host boot up.
               If not specified `false` is assumed.
        :param pulumi.Input[str] bridge: The bridge device defines the name of a bridge
               device which will be used to construct the virtual network (when not provided,
               it will be automatically obtained by libvirt in `none`, `nat` and `route` modes).
        :param pulumi.Input[pulumi.InputType['NetworkDhcpArgs']] dhcp: DHCP configuration. 
               You need to use it in conjuction with the adresses variable.
        :param pulumi.Input[pulumi.InputType['NetworkDnsArgs']] dns: configuration of DNS specific settings for the network
        :param pulumi.Input[str] domain: The domain used by the DNS server.
        :param pulumi.Input[str] mode: One of:
               - `none`: the guests can talk to each other and the host OS, but cannot reach
               any other machines on the LAN.
               - `nat`: it is the default network mode. This is a configuration that
               allows guest OS to get outbound connectivity regardless of whether the host
               uses ethernet, wireless, dialup, or VPN networking without requiring any
               specific admin configuration. In the absence of host networking, it at
               least allows guests to talk directly to each other.
               - `route`: this is a variant on the default network which routes traffic from
               the virtual network to the LAN **without applying any NAT**. It requires that
               the IP address range be pre-configured in the routing tables of the router
               on the host network.
               - `bridge`: use a pre-existing host bridge. The guests will effectively be
               directly connected to the physical network (i.e. their IP addresses will
               all be on the subnet of the physical network, and there will be no
               restrictions on inbound or outbound connections). The `bridge` network
               attribute is mandatory in this case.
        :param pulumi.Input[int] mtu: The MTU to set for the underlying network interfaces. When
               not supplied, libvirt will use the default for the interface, usually 1500.
               Libvirt version 5.1 and greater will advertise this value to nodes via DHCP.
        :param pulumi.Input[str] name: A unique name for the resource, required by libvirt.
               Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkRouteArgs']]]] routes: a list of static routes. A `cidr` and a `gateway` must
               be provided. The `gateway` must be reachable via the bridge interface.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['addresses'] = addresses
            __props__['autostart'] = autostart
            __props__['bridge'] = bridge
            __props__['dhcp'] = dhcp
            __props__['dns'] = dns
            __props__['domain'] = domain
            __props__['mode'] = mode
            __props__['mtu'] = mtu
            __props__['name'] = name
            __props__['routes'] = routes
            __props__['xml'] = xml
        super(Network, __self__).__init__(
            'libvirt:index/network:Network',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            autostart: Optional[pulumi.Input[bool]] = None,
            bridge: Optional[pulumi.Input[str]] = None,
            dhcp: Optional[pulumi.Input[pulumi.InputType['NetworkDhcpArgs']]] = None,
            dns: Optional[pulumi.Input[pulumi.InputType['NetworkDnsArgs']]] = None,
            domain: Optional[pulumi.Input[str]] = None,
            mode: Optional[pulumi.Input[str]] = None,
            mtu: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            routes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkRouteArgs']]]]] = None,
            xml: Optional[pulumi.Input[pulumi.InputType['NetworkXmlArgs']]] = None) -> 'Network':
        """
        Get an existing Network resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] addresses: A list of (0 or 1) IPv4 and (0 or 1) IPv6 subnets in
               CIDR notation.  This defines the subnets associated to that network.
               This argument is also used to define the address on the real host.
               If `dhcp {  enabled = true }` addresses is also used to define the address range served by
               the DHCP server.
               No DHCP server will be started if `addresses` is omitted.
        :param pulumi.Input[bool] autostart: Set to `true` to start the network on host boot up.
               If not specified `false` is assumed.
        :param pulumi.Input[str] bridge: The bridge device defines the name of a bridge
               device which will be used to construct the virtual network (when not provided,
               it will be automatically obtained by libvirt in `none`, `nat` and `route` modes).
        :param pulumi.Input[pulumi.InputType['NetworkDhcpArgs']] dhcp: DHCP configuration. 
               You need to use it in conjuction with the adresses variable.
        :param pulumi.Input[pulumi.InputType['NetworkDnsArgs']] dns: configuration of DNS specific settings for the network
        :param pulumi.Input[str] domain: The domain used by the DNS server.
        :param pulumi.Input[str] mode: One of:
               - `none`: the guests can talk to each other and the host OS, but cannot reach
               any other machines on the LAN.
               - `nat`: it is the default network mode. This is a configuration that
               allows guest OS to get outbound connectivity regardless of whether the host
               uses ethernet, wireless, dialup, or VPN networking without requiring any
               specific admin configuration. In the absence of host networking, it at
               least allows guests to talk directly to each other.
               - `route`: this is a variant on the default network which routes traffic from
               the virtual network to the LAN **without applying any NAT**. It requires that
               the IP address range be pre-configured in the routing tables of the router
               on the host network.
               - `bridge`: use a pre-existing host bridge. The guests will effectively be
               directly connected to the physical network (i.e. their IP addresses will
               all be on the subnet of the physical network, and there will be no
               restrictions on inbound or outbound connections). The `bridge` network
               attribute is mandatory in this case.
        :param pulumi.Input[int] mtu: The MTU to set for the underlying network interfaces. When
               not supplied, libvirt will use the default for the interface, usually 1500.
               Libvirt version 5.1 and greater will advertise this value to nodes via DHCP.
        :param pulumi.Input[str] name: A unique name for the resource, required by libvirt.
               Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkRouteArgs']]]] routes: a list of static routes. A `cidr` and a `gateway` must
               be provided. The `gateway` must be reachable via the bridge interface.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["addresses"] = addresses
        __props__["autostart"] = autostart
        __props__["bridge"] = bridge
        __props__["dhcp"] = dhcp
        __props__["dns"] = dns
        __props__["domain"] = domain
        __props__["mode"] = mode
        __props__["mtu"] = mtu
        __props__["name"] = name
        __props__["routes"] = routes
        __props__["xml"] = xml
        return Network(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def addresses(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of (0 or 1) IPv4 and (0 or 1) IPv6 subnets in
        CIDR notation.  This defines the subnets associated to that network.
        This argument is also used to define the address on the real host.
        If `dhcp {  enabled = true }` addresses is also used to define the address range served by
        the DHCP server.
        No DHCP server will be started if `addresses` is omitted.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter
    def autostart(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to `true` to start the network on host boot up.
        If not specified `false` is assumed.
        """
        return pulumi.get(self, "autostart")

    @property
    @pulumi.getter
    def bridge(self) -> pulumi.Output[str]:
        """
        The bridge device defines the name of a bridge
        device which will be used to construct the virtual network (when not provided,
        it will be automatically obtained by libvirt in `none`, `nat` and `route` modes).
        """
        return pulumi.get(self, "bridge")

    @property
    @pulumi.getter
    def dhcp(self) -> pulumi.Output[Optional['outputs.NetworkDhcp']]:
        """
        DHCP configuration. 
        You need to use it in conjuction with the adresses variable.
        """
        return pulumi.get(self, "dhcp")

    @property
    @pulumi.getter
    def dns(self) -> pulumi.Output[Optional['outputs.NetworkDns']]:
        """
        configuration of DNS specific settings for the network
        """
        return pulumi.get(self, "dns")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[Optional[str]]:
        """
        The domain used by the DNS server.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[Optional[str]]:
        """
        One of:
        - `none`: the guests can talk to each other and the host OS, but cannot reach
        any other machines on the LAN.
        - `nat`: it is the default network mode. This is a configuration that
        allows guest OS to get outbound connectivity regardless of whether the host
        uses ethernet, wireless, dialup, or VPN networking without requiring any
        specific admin configuration. In the absence of host networking, it at
        least allows guests to talk directly to each other.
        - `route`: this is a variant on the default network which routes traffic from
        the virtual network to the LAN **without applying any NAT**. It requires that
        the IP address range be pre-configured in the routing tables of the router
        on the host network.
        - `bridge`: use a pre-existing host bridge. The guests will effectively be
        directly connected to the physical network (i.e. their IP addresses will
        all be on the subnet of the physical network, and there will be no
        restrictions on inbound or outbound connections). The `bridge` network
        attribute is mandatory in this case.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def mtu(self) -> pulumi.Output[Optional[int]]:
        """
        The MTU to set for the underlying network interfaces. When
        not supplied, libvirt will use the default for the interface, usually 1500.
        Libvirt version 5.1 and greater will advertise this value to nodes via DHCP.
        """
        return pulumi.get(self, "mtu")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A unique name for the resource, required by libvirt.
        Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def routes(self) -> pulumi.Output[Optional[Sequence['outputs.NetworkRoute']]]:
        """
        a list of static routes. A `cidr` and a `gateway` must
        be provided. The `gateway` must be reachable via the bridge interface.
        """
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter
    def xml(self) -> pulumi.Output[Optional['outputs.NetworkXml']]:
        return pulumi.get(self, "xml")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

