# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs

__all__ = [
    'DomainBootDevice',
    'DomainConsole',
    'DomainCpu',
    'DomainDisk',
    'DomainFilesystem',
    'DomainGraphics',
    'DomainNetworkInterface',
    'DomainNvram',
    'DomainVideo',
    'DomainXml',
    'NetworkDhcp',
    'NetworkDns',
    'NetworkDnsForwarder',
    'NetworkDnsHost',
    'NetworkDnsSrv',
    'NetworkRoute',
    'NetworkXml',
    'PoolXml',
    'VolumeXml',
]

@pulumi.output_type
class DomainBootDevice(dict):
    def __init__(__self__, *,
                 devs: Optional[Sequence[str]] = None):
        if devs is not None:
            pulumi.set(__self__, "devs", devs)

    @property
    @pulumi.getter
    def devs(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "devs")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DomainConsole(dict):
    def __init__(__self__, *,
                 target_port: str,
                 type: str,
                 source_host: Optional[str] = None,
                 source_path: Optional[str] = None,
                 source_service: Optional[str] = None,
                 target_type: Optional[str] = None):
        """
        :param str target_port: Target port
        :param str type: Console device type. Valid values are "pty" and "tcp".
        :param str source_host: IP address to listen on. Defaults to 127.0.0.1.
        :param str source_path: Source path
        :param str source_service: Port number or a service name. Defaults to a
               random port.
        :param str target_type: for the first console and defaults to `serial`.
               Subsequent `console` blocks must have a different type - usually `virtio`.
        """
        pulumi.set(__self__, "target_port", target_port)
        pulumi.set(__self__, "type", type)
        if source_host is not None:
            pulumi.set(__self__, "source_host", source_host)
        if source_path is not None:
            pulumi.set(__self__, "source_path", source_path)
        if source_service is not None:
            pulumi.set(__self__, "source_service", source_service)
        if target_type is not None:
            pulumi.set(__self__, "target_type", target_type)

    @property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> str:
        """
        Target port
        """
        return pulumi.get(self, "target_port")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Console device type. Valid values are "pty" and "tcp".
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="sourceHost")
    def source_host(self) -> Optional[str]:
        """
        IP address to listen on. Defaults to 127.0.0.1.
        """
        return pulumi.get(self, "source_host")

    @property
    @pulumi.getter(name="sourcePath")
    def source_path(self) -> Optional[str]:
        """
        Source path
        """
        return pulumi.get(self, "source_path")

    @property
    @pulumi.getter(name="sourceService")
    def source_service(self) -> Optional[str]:
        """
        Port number or a service name. Defaults to a
        random port.
        """
        return pulumi.get(self, "source_service")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[str]:
        """
        for the first console and defaults to `serial`.
        Subsequent `console` blocks must have a different type - usually `virtio`.
        """
        return pulumi.get(self, "target_type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DomainCpu(dict):
    def __init__(__self__, *,
                 mode: str):
        pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def mode(self) -> str:
        return pulumi.get(self, "mode")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DomainDisk(dict):
    def __init__(__self__, *,
                 block_device: Optional[str] = None,
                 file: Optional[str] = None,
                 scsi: Optional[bool] = None,
                 url: Optional[str] = None,
                 volume_id: Optional[str] = None,
                 wwn: Optional[str] = None):
        """
        :param str block_device: The path to the host device to use as the block device for this disk.
        :param str file: The filename to use as the block device for this disk (read-only)
        :param bool scsi: Use a scsi controller for this disk.  The controller
               model is set to `virtio-scsi`
        :param str url: The http url to use as the block device for this disk (read-only)
        :param str volume_id: The volume id to use for this disk.
        :param str wwn: Specify a WWN to use for the disk if the disk is using
               a scsi controller, if not specified then a random wwn is generated for the disk
        """
        if block_device is not None:
            pulumi.set(__self__, "block_device", block_device)
        if file is not None:
            pulumi.set(__self__, "file", file)
        if scsi is not None:
            pulumi.set(__self__, "scsi", scsi)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)
        if wwn is not None:
            pulumi.set(__self__, "wwn", wwn)

    @property
    @pulumi.getter(name="blockDevice")
    def block_device(self) -> Optional[str]:
        """
        The path to the host device to use as the block device for this disk.
        """
        return pulumi.get(self, "block_device")

    @property
    @pulumi.getter
    def file(self) -> Optional[str]:
        """
        The filename to use as the block device for this disk (read-only)
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter
    def scsi(self) -> Optional[bool]:
        """
        Use a scsi controller for this disk.  The controller
        model is set to `virtio-scsi`
        """
        return pulumi.get(self, "scsi")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The http url to use as the block device for this disk (read-only)
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[str]:
        """
        The volume id to use for this disk.
        """
        return pulumi.get(self, "volume_id")

    @property
    @pulumi.getter
    def wwn(self) -> Optional[str]:
        """
        Specify a WWN to use for the disk if the disk is using
        a scsi controller, if not specified then a random wwn is generated for the disk
        """
        return pulumi.get(self, "wwn")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DomainFilesystem(dict):
    def __init__(__self__, *,
                 source: str,
                 target: str,
                 accessmode: Optional[str] = None,
                 readonly: Optional[bool] = None):
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "target", target)
        if accessmode is not None:
            pulumi.set(__self__, "accessmode", accessmode)
        if readonly is not None:
            pulumi.set(__self__, "readonly", readonly)

    @property
    @pulumi.getter
    def source(self) -> str:
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def target(self) -> str:
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def accessmode(self) -> Optional[str]:
        return pulumi.get(self, "accessmode")

    @property
    @pulumi.getter
    def readonly(self) -> Optional[bool]:
        return pulumi.get(self, "readonly")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DomainGraphics(dict):
    def __init__(__self__, *,
                 autoport: Optional[bool] = None,
                 listen_address: Optional[str] = None,
                 listen_type: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param bool autoport: defaults to "yes"
        :param str listen_address: IP Address where the VNC listener should be started if
               `listen_type` is set to `address`. Defaults to 127.0.0.1
        :param str listen_type: "listen type", defaults to "none"
        :param str type: Console device type. Valid values are "pty" and "tcp".
        """
        if autoport is not None:
            pulumi.set(__self__, "autoport", autoport)
        if listen_address is not None:
            pulumi.set(__self__, "listen_address", listen_address)
        if listen_type is not None:
            pulumi.set(__self__, "listen_type", listen_type)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def autoport(self) -> Optional[bool]:
        """
        defaults to "yes"
        """
        return pulumi.get(self, "autoport")

    @property
    @pulumi.getter(name="listenAddress")
    def listen_address(self) -> Optional[str]:
        """
        IP Address where the VNC listener should be started if
        `listen_type` is set to `address`. Defaults to 127.0.0.1
        """
        return pulumi.get(self, "listen_address")

    @property
    @pulumi.getter(name="listenType")
    def listen_type(self) -> Optional[str]:
        """
        "listen type", defaults to "none"
        """
        return pulumi.get(self, "listen_type")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Console device type. Valid values are "pty" and "tcp".
        """
        return pulumi.get(self, "type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DomainNetworkInterface(dict):
    def __init__(__self__, *,
                 addresses: Optional[Sequence[str]] = None,
                 bridge: Optional[str] = None,
                 hostname: Optional[str] = None,
                 mac: Optional[str] = None,
                 macvtap: Optional[str] = None,
                 network_id: Optional[str] = None,
                 network_name: Optional[str] = None,
                 passthrough: Optional[str] = None,
                 vepa: Optional[str] = None,
                 wait_for_lease: Optional[bool] = None):
        """
        :param Sequence[str] addresses: An IP address for this domain in this network.
        :param str bridge: Provides a bridge from the VM directly to the LAN. This assumes
               there is a bridge device on the host which has one or more of the hosts
               physical NICs enslaved. The guest VM will have an associated _tun_ device
               created and enslaved to the bridge. The IP range / network configuration is
               whatever is used on the LAN. This provides the guest VM full incoming &
               outgoing net access just like a physical machine.
        :param str hostname: A hostname that will be assigned to this domain
               resource in this network.
        :param str mac: The specific MAC address to use for this interface.
        :param str macvtap: Packets whose destination is on the same host as where they
               originate from are directly delivered to the target macvtap device. Both
               origin and destination devices need to be in bridge mode for direct delivery.
               If either one of them is in vepa mode, a VEPA capable bridge is required.
        :param str passthrough: This feature attaches a virtual function of a SRIOV capable
               NIC directly to a VM without losing the migration capability. All packets are
               sent to the VF/IF of the configured network device. Depending on the
               capabilities of the device additional prerequisites or limitations may apply;
               for example, on Linux this requires kernel 2.6.38 or newer.
        :param str vepa: All VMs' packets are sent to the external bridge. Packets whose
               destination is a VM on the same host as where the packet originates from are
               sent back to the host by the VEPA capable bridge (today's bridges are
               typically not VEPA capable).
        :param bool wait_for_lease: When creating the domain resource, wait until the
               network interface gets a DHCP lease from libvirt, so that the computed IP
               addresses will be available when the domain is up and the plan applied.
        """
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if bridge is not None:
            pulumi.set(__self__, "bridge", bridge)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if mac is not None:
            pulumi.set(__self__, "mac", mac)
        if macvtap is not None:
            pulumi.set(__self__, "macvtap", macvtap)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if network_name is not None:
            pulumi.set(__self__, "network_name", network_name)
        if passthrough is not None:
            pulumi.set(__self__, "passthrough", passthrough)
        if vepa is not None:
            pulumi.set(__self__, "vepa", vepa)
        if wait_for_lease is not None:
            pulumi.set(__self__, "wait_for_lease", wait_for_lease)

    @property
    @pulumi.getter
    def addresses(self) -> Optional[Sequence[str]]:
        """
        An IP address for this domain in this network.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter
    def bridge(self) -> Optional[str]:
        """
        Provides a bridge from the VM directly to the LAN. This assumes
        there is a bridge device on the host which has one or more of the hosts
        physical NICs enslaved. The guest VM will have an associated _tun_ device
        created and enslaved to the bridge. The IP range / network configuration is
        whatever is used on the LAN. This provides the guest VM full incoming &
        outgoing net access just like a physical machine.
        """
        return pulumi.get(self, "bridge")

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        """
        A hostname that will be assigned to this domain
        resource in this network.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def mac(self) -> Optional[str]:
        """
        The specific MAC address to use for this interface.
        """
        return pulumi.get(self, "mac")

    @property
    @pulumi.getter
    def macvtap(self) -> Optional[str]:
        """
        Packets whose destination is on the same host as where they
        originate from are directly delivered to the target macvtap device. Both
        origin and destination devices need to be in bridge mode for direct delivery.
        If either one of them is in vepa mode, a VEPA capable bridge is required.
        """
        return pulumi.get(self, "macvtap")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[str]:
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="networkName")
    def network_name(self) -> Optional[str]:
        return pulumi.get(self, "network_name")

    @property
    @pulumi.getter
    def passthrough(self) -> Optional[str]:
        """
        This feature attaches a virtual function of a SRIOV capable
        NIC directly to a VM without losing the migration capability. All packets are
        sent to the VF/IF of the configured network device. Depending on the
        capabilities of the device additional prerequisites or limitations may apply;
        for example, on Linux this requires kernel 2.6.38 or newer.
        """
        return pulumi.get(self, "passthrough")

    @property
    @pulumi.getter
    def vepa(self) -> Optional[str]:
        """
        All VMs' packets are sent to the external bridge. Packets whose
        destination is a VM on the same host as where the packet originates from are
        sent back to the host by the VEPA capable bridge (today's bridges are
        typically not VEPA capable).
        """
        return pulumi.get(self, "vepa")

    @property
    @pulumi.getter(name="waitForLease")
    def wait_for_lease(self) -> Optional[bool]:
        """
        When creating the domain resource, wait until the
        network interface gets a DHCP lease from libvirt, so that the computed IP
        addresses will be available when the domain is up and the plan applied.
        """
        return pulumi.get(self, "wait_for_lease")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DomainNvram(dict):
    def __init__(__self__, *,
                 file: str,
                 template: Optional[str] = None):
        """
        :param str file: The filename to use as the block device for this disk (read-only)
        :param str template: path to the file used to override variables from the master NVRAM
               store.
        """
        pulumi.set(__self__, "file", file)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter
    def file(self) -> str:
        """
        The filename to use as the block device for this disk (read-only)
        """
        return pulumi.get(self, "file")

    @property
    @pulumi.getter
    def template(self) -> Optional[str]:
        """
        path to the file used to override variables from the master NVRAM
        store.
        """
        return pulumi.get(self, "template")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DomainVideo(dict):
    def __init__(__self__, *,
                 type: Optional[str] = None):
        """
        :param str type: Console device type. Valid values are "pty" and "tcp".
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Console device type. Valid values are "pty" and "tcp".
        """
        return pulumi.get(self, "type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DomainXml(dict):
    def __init__(__self__, *,
                 xslt: Optional[str] = None):
        if xslt is not None:
            pulumi.set(__self__, "xslt", xslt)

    @property
    @pulumi.getter
    def xslt(self) -> Optional[str]:
        return pulumi.get(self, "xslt")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NetworkDhcp(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        :param bool enabled: when false, disable the DHCP server
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        when false, disable the DHCP server
        """
        return pulumi.get(self, "enabled")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NetworkDns(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None,
                 forwarders: Optional[Sequence['outputs.NetworkDnsForwarder']] = None,
                 hosts: Optional[Sequence['outputs.NetworkDnsHost']] = None,
                 local_only: Optional[bool] = None,
                 srvs: Optional[Sequence['outputs.NetworkDnsSrv']] = None):
        """
        :param bool enabled: when false, disable the DHCP server
        :param Sequence['NetworkDnsForwarderArgs'] forwarders: Either `address`, `domain`, or both must be set
        :param Sequence['NetworkDnsHostArgs'] hosts: a DNS host entry block. You can have one or more of these
               blocks in your DNS definition. You must specify both `ip` and `hostname`.
        :param bool local_only: true/false: true means 'do not forward unresolved requests for this domain to the part DNS server
        :param Sequence['NetworkDnsSrvArgs'] srvs: a DNS SRV entry block. You can have one or more of these blocks
               in your DNS definition. You must specify `service` and `protocol`.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if forwarders is not None:
            pulumi.set(__self__, "forwarders", forwarders)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if local_only is not None:
            pulumi.set(__self__, "local_only", local_only)
        if srvs is not None:
            pulumi.set(__self__, "srvs", srvs)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        when false, disable the DHCP server
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def forwarders(self) -> Optional[Sequence['outputs.NetworkDnsForwarder']]:
        """
        Either `address`, `domain`, or both must be set
        """
        return pulumi.get(self, "forwarders")

    @property
    @pulumi.getter
    def hosts(self) -> Optional[Sequence['outputs.NetworkDnsHost']]:
        """
        a DNS host entry block. You can have one or more of these
        blocks in your DNS definition. You must specify both `ip` and `hostname`.
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter(name="localOnly")
    def local_only(self) -> Optional[bool]:
        """
        true/false: true means 'do not forward unresolved requests for this domain to the part DNS server
        """
        return pulumi.get(self, "local_only")

    @property
    @pulumi.getter
    def srvs(self) -> Optional[Sequence['outputs.NetworkDnsSrv']]:
        """
        a DNS SRV entry block. You can have one or more of these blocks
        in your DNS definition. You must specify `service` and `protocol`.
        """
        return pulumi.get(self, "srvs")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NetworkDnsForwarder(dict):
    def __init__(__self__, *,
                 address: Optional[str] = None,
                 domain: Optional[str] = None):
        """
        :param str domain: The domain used by the DNS server.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        The domain used by the DNS server.
        """
        return pulumi.get(self, "domain")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NetworkDnsHost(dict):
    def __init__(__self__, *,
                 hostname: Optional[str] = None,
                 ip: Optional[str] = None):
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[str]:
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        return pulumi.get(self, "ip")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NetworkDnsSrv(dict):
    def __init__(__self__, *,
                 domain: Optional[str] = None,
                 port: Optional[str] = None,
                 priority: Optional[str] = None,
                 protocol: Optional[str] = None,
                 service: Optional[str] = None,
                 target: Optional[str] = None,
                 weight: Optional[str] = None):
        """
        :param str domain: The domain used by the DNS server.
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        The domain used by the DNS server.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def priority(self) -> Optional[str]:
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def service(self) -> Optional[str]:
        return pulumi.get(self, "service")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def weight(self) -> Optional[str]:
        return pulumi.get(self, "weight")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NetworkRoute(dict):
    def __init__(__self__, *,
                 cidr: str,
                 gateway: str):
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "gateway", gateway)

    @property
    @pulumi.getter
    def cidr(self) -> str:
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter
    def gateway(self) -> str:
        return pulumi.get(self, "gateway")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NetworkXml(dict):
    def __init__(__self__, *,
                 xslt: Optional[str] = None):
        if xslt is not None:
            pulumi.set(__self__, "xslt", xslt)

    @property
    @pulumi.getter
    def xslt(self) -> Optional[str]:
        return pulumi.get(self, "xslt")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class PoolXml(dict):
    def __init__(__self__, *,
                 xslt: Optional[str] = None):
        if xslt is not None:
            pulumi.set(__self__, "xslt", xslt)

    @property
    @pulumi.getter
    def xslt(self) -> Optional[str]:
        return pulumi.get(self, "xslt")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class VolumeXml(dict):
    def __init__(__self__, *,
                 xslt: Optional[str] = None):
        if xslt is not None:
            pulumi.set(__self__, "xslt", xslt)

    @property
    @pulumi.getter
    def xslt(self) -> Optional[str]:
        return pulumi.get(self, "xslt")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


