# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Pool']


class Pool(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocation: Optional[pulumi.Input[int]] = None,
                 available: Optional[pulumi.Input[str]] = None,
                 capacity: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 xml: Optional[pulumi.Input[pulumi.InputType['PoolXmlArgs']]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Manages a storage pool in libvirt. Currently only directory-based storage pool are supported. For more information on
        storage pools in libvirt, see [the official documentation](https://libvirt.org/formatstorage.html).

        **WARNING:** This is experimental API and may change in the future.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_libvirt as libvirt

        # A pool for all cluster volumes
        cluster = libvirt.Pool("cluster",
            type="dir",
            path="/home/user/cluster_storage")
        opensuse_leap = libvirt.Volume("opensuseLeap",
            pool=cluster.name,
            source="http://download.opensuse.org/repositories/Cloud:/Images:/Leap_42.1/images/openSUSE-Leap-42.1-OpenStack.x86_64.qcow2")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: A unique name for the resource, required by libvirt.
        :param pulumi.Input[str] path: The directory where the pool will keep all its volumes. This is only relevant to (and required by)
               the "dir" type pools.
        :param pulumi.Input[str] type: The type of the pool. Currently, only "dir" supported.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['allocation'] = allocation
            __props__['available'] = available
            __props__['capacity'] = capacity
            __props__['name'] = name
            __props__['path'] = path
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__['type'] = type
            __props__['xml'] = xml
        super(Pool, __self__).__init__(
            'libvirt:index/pool:Pool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocation: Optional[pulumi.Input[int]] = None,
            available: Optional[pulumi.Input[str]] = None,
            capacity: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            path: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            xml: Optional[pulumi.Input[pulumi.InputType['PoolXmlArgs']]] = None) -> 'Pool':
        """
        Get an existing Pool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: A unique name for the resource, required by libvirt.
        :param pulumi.Input[str] path: The directory where the pool will keep all its volumes. This is only relevant to (and required by)
               the "dir" type pools.
        :param pulumi.Input[str] type: The type of the pool. Currently, only "dir" supported.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["allocation"] = allocation
        __props__["available"] = available
        __props__["capacity"] = capacity
        __props__["name"] = name
        __props__["path"] = path
        __props__["type"] = type
        __props__["xml"] = xml
        return Pool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def allocation(self) -> pulumi.Output[int]:
        return pulumi.get(self, "allocation")

    @property
    @pulumi.getter
    def available(self) -> pulumi.Output[str]:
        return pulumi.get(self, "available")

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[int]:
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A unique name for the resource, required by libvirt.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[Optional[str]]:
        """
        The directory where the pool will keep all its volumes. This is only relevant to (and required by)
        the "dir" type pools.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the pool. Currently, only "dir" supported.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def xml(self) -> pulumi.Output[Optional['outputs.PoolXml']]:
        return pulumi.get(self, "xml")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

