# coding: utf-8

"""
    Signadot API

    API for Signadot Sandboxes  # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from signadot_sdk_snapshot.api_client import ApiClient


class ClusterApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_cluster(self, org_name, cluster_name, **kwargs):  # noqa: E501
        """Add a cluster  # noqa: E501

        Add a Kubernetes cluster to Signadot.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_cluster(org_name, cluster_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :param str cluster_name: Cluster Name (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_cluster_with_http_info(org_name, cluster_name, **kwargs)  # noqa: E501
        else:
            (data) = self.add_cluster_with_http_info(org_name, cluster_name, **kwargs)  # noqa: E501
            return data

    def add_cluster_with_http_info(self, org_name, cluster_name, **kwargs):  # noqa: E501
        """Add a cluster  # noqa: E501

        Add a Kubernetes cluster to Signadot.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_cluster_with_http_info(org_name, cluster_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :param str cluster_name: Cluster Name (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_name', 'cluster_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_name' is set
        if self.api_client.client_side_validation and ('org_name' not in params or
                                                       params['org_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org_name` when calling `add_cluster`")  # noqa: E501
        # verify the required parameter 'cluster_name' is set
        if self.api_client.client_side_validation and ('cluster_name' not in params or
                                                       params['cluster_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `cluster_name` when calling `add_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_name' in params:
            path_params['orgName'] = params['org_name']  # noqa: E501
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgName}/clusters/{clusterName}/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_cluster_token(self, org_name, cluster_name, **kwargs):  # noqa: E501
        """Create cluster token  # noqa: E501

        Create a new token for connecting a cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_cluster_token(org_name, cluster_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :param str cluster_name: Cluster Name (required)
        :return: ClusterToken
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_cluster_token_with_http_info(org_name, cluster_name, **kwargs)  # noqa: E501
        else:
            (data) = self.create_cluster_token_with_http_info(org_name, cluster_name, **kwargs)  # noqa: E501
            return data

    def create_cluster_token_with_http_info(self, org_name, cluster_name, **kwargs):  # noqa: E501
        """Create cluster token  # noqa: E501

        Create a new token for connecting a cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_cluster_token_with_http_info(org_name, cluster_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :param str cluster_name: Cluster Name (required)
        :return: ClusterToken
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_name', 'cluster_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_cluster_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_name' is set
        if self.api_client.client_side_validation and ('org_name' not in params or
                                                       params['org_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org_name` when calling `create_cluster_token`")  # noqa: E501
        # verify the required parameter 'cluster_name' is set
        if self.api_client.client_side_validation and ('cluster_name' not in params or
                                                       params['cluster_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `cluster_name` when calling `create_cluster_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_name' in params:
            path_params['orgName'] = params['org_name']  # noqa: E501
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgName}/clusters/{clusterName}/tokens', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClusterToken',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_cluster_token(self, org_name, cluster_name, token_id, **kwargs):  # noqa: E501
        """Delete cluster token  # noqa: E501

        Delete a cluster token associated with a cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_cluster_token(org_name, cluster_name, token_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :param str cluster_name: Cluster Name (required)
        :param str token_id: Token Id (required)
        :return: EmptyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_cluster_token_with_http_info(org_name, cluster_name, token_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_cluster_token_with_http_info(org_name, cluster_name, token_id, **kwargs)  # noqa: E501
            return data

    def delete_cluster_token_with_http_info(self, org_name, cluster_name, token_id, **kwargs):  # noqa: E501
        """Delete cluster token  # noqa: E501

        Delete a cluster token associated with a cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_cluster_token_with_http_info(org_name, cluster_name, token_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :param str cluster_name: Cluster Name (required)
        :param str token_id: Token Id (required)
        :return: EmptyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_name', 'cluster_name', 'token_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_cluster_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_name' is set
        if self.api_client.client_side_validation and ('org_name' not in params or
                                                       params['org_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org_name` when calling `delete_cluster_token`")  # noqa: E501
        # verify the required parameter 'cluster_name' is set
        if self.api_client.client_side_validation and ('cluster_name' not in params or
                                                       params['cluster_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `cluster_name` when calling `delete_cluster_token`")  # noqa: E501
        # verify the required parameter 'token_id' is set
        if self.api_client.client_side_validation and ('token_id' not in params or
                                                       params['token_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `token_id` when calling `delete_cluster_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_name' in params:
            path_params['orgName'] = params['org_name']  # noqa: E501
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']  # noqa: E501
        if 'token_id' in params:
            path_params['tokenId'] = params['token_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgName}/clusters/{clusterName}/tokens/{tokenId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cluster(self, org_name, cluster_name, **kwargs):  # noqa: E501
        """Get a cluster  # noqa: E501

        Get a cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cluster(org_name, cluster_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :param str cluster_name: Cluster Name (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cluster_with_http_info(org_name, cluster_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cluster_with_http_info(org_name, cluster_name, **kwargs)  # noqa: E501
            return data

    def get_cluster_with_http_info(self, org_name, cluster_name, **kwargs):  # noqa: E501
        """Get a cluster  # noqa: E501

        Get a cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cluster_with_http_info(org_name, cluster_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :param str cluster_name: Cluster Name (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_name', 'cluster_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_name' is set
        if self.api_client.client_side_validation and ('org_name' not in params or
                                                       params['org_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org_name` when calling `get_cluster`")  # noqa: E501
        # verify the required parameter 'cluster_name' is set
        if self.api_client.client_side_validation and ('cluster_name' not in params or
                                                       params['cluster_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_name' in params:
            path_params['orgName'] = params['org_name']  # noqa: E501
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgName}/clusters/{clusterName}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cluster_token(self, org_name, cluster_name, token_id, **kwargs):  # noqa: E501
        """Get a cluster token  # noqa: E501

        Get a cluster token associated with a cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cluster_token(org_name, cluster_name, token_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :param str cluster_name: Cluster Name (required)
        :param str token_id: Token Id (required)
        :return: ClusterToken
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cluster_token_with_http_info(org_name, cluster_name, token_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cluster_token_with_http_info(org_name, cluster_name, token_id, **kwargs)  # noqa: E501
            return data

    def get_cluster_token_with_http_info(self, org_name, cluster_name, token_id, **kwargs):  # noqa: E501
        """Get a cluster token  # noqa: E501

        Get a cluster token associated with a cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cluster_token_with_http_info(org_name, cluster_name, token_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :param str cluster_name: Cluster Name (required)
        :param str token_id: Token Id (required)
        :return: ClusterToken
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_name', 'cluster_name', 'token_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cluster_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_name' is set
        if self.api_client.client_side_validation and ('org_name' not in params or
                                                       params['org_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org_name` when calling `get_cluster_token`")  # noqa: E501
        # verify the required parameter 'cluster_name' is set
        if self.api_client.client_side_validation and ('cluster_name' not in params or
                                                       params['cluster_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `cluster_name` when calling `get_cluster_token`")  # noqa: E501
        # verify the required parameter 'token_id' is set
        if self.api_client.client_side_validation and ('token_id' not in params or
                                                       params['token_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `token_id` when calling `get_cluster_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_name' in params:
            path_params['orgName'] = params['org_name']  # noqa: E501
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']  # noqa: E501
        if 'token_id' in params:
            path_params['tokenId'] = params['token_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgName}/clusters/{clusterName}/tokens/{tokenId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ClusterToken',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_cluster_tokens(self, org_name, cluster_name, **kwargs):  # noqa: E501
        """List cluster tokens  # noqa: E501

        List the cluster tokens associated with a cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_cluster_tokens(org_name, cluster_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :param str cluster_name: Cluster Name (required)
        :return: list[ClusterToken]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_cluster_tokens_with_http_info(org_name, cluster_name, **kwargs)  # noqa: E501
        else:
            (data) = self.list_cluster_tokens_with_http_info(org_name, cluster_name, **kwargs)  # noqa: E501
            return data

    def list_cluster_tokens_with_http_info(self, org_name, cluster_name, **kwargs):  # noqa: E501
        """List cluster tokens  # noqa: E501

        List the cluster tokens associated with a cluster.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_cluster_tokens_with_http_info(org_name, cluster_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :param str cluster_name: Cluster Name (required)
        :return: list[ClusterToken]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_name', 'cluster_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_cluster_tokens" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_name' is set
        if self.api_client.client_side_validation and ('org_name' not in params or
                                                       params['org_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org_name` when calling `list_cluster_tokens`")  # noqa: E501
        # verify the required parameter 'cluster_name' is set
        if self.api_client.client_side_validation and ('cluster_name' not in params or
                                                       params['cluster_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `cluster_name` when calling `list_cluster_tokens`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_name' in params:
            path_params['orgName'] = params['org_name']  # noqa: E501
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgName}/clusters/{clusterName}/tokens/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ClusterToken]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_clusters(self, org_name, **kwargs):  # noqa: E501
        """List clusters  # noqa: E501

        List clusters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_clusters(org_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :return: list[Cluster]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_clusters_with_http_info(org_name, **kwargs)  # noqa: E501
        else:
            (data) = self.list_clusters_with_http_info(org_name, **kwargs)  # noqa: E501
            return data

    def list_clusters_with_http_info(self, org_name, **kwargs):  # noqa: E501
        """List clusters  # noqa: E501

        List clusters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_clusters_with_http_info(org_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :return: list[Cluster]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_clusters" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_name' is set
        if self.api_client.client_side_validation and ('org_name' not in params or
                                                       params['org_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org_name` when calling `list_clusters`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_name' in params:
            path_params['orgName'] = params['org_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgName}/clusters/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Cluster]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_cluster(self, org_name, cluster_name, **kwargs):  # noqa: E501
        """Remove a cluster  # noqa: E501

        Remove a Kubernetes cluster from Signadot.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_cluster(org_name, cluster_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :param str cluster_name: Cluster Name (required)
        :return: EmptyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_cluster_with_http_info(org_name, cluster_name, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_cluster_with_http_info(org_name, cluster_name, **kwargs)  # noqa: E501
            return data

    def remove_cluster_with_http_info(self, org_name, cluster_name, **kwargs):  # noqa: E501
        """Remove a cluster  # noqa: E501

        Remove a Kubernetes cluster from Signadot.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_cluster_with_http_info(org_name, cluster_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_name: Signadot Org Name (required)
        :param str cluster_name: Cluster Name (required)
        :return: EmptyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['org_name', 'cluster_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'org_name' is set
        if self.api_client.client_side_validation and ('org_name' not in params or
                                                       params['org_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `org_name` when calling `remove_cluster`")  # noqa: E501
        # verify the required parameter 'cluster_name' is set
        if self.api_client.client_side_validation and ('cluster_name' not in params or
                                                       params['cluster_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `cluster_name` when calling `remove_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'org_name' in params:
            path_params['orgName'] = params['org_name']  # noqa: E501
        if 'cluster_name' in params:
            path_params['clusterName'] = params['cluster_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/orgs/{orgName}/clusters/{clusterName}/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
