# GeoFabrics

![Linux](https://github.com/rosepearson/GeoFabrics/actions/workflows/linux-test.yml/badge.svg)

The `geofabrics` package includes routines and classes for combining point (i.e. LiDAR), vector (i.e. catchment of interest, infrastructure), and raster (i.e. reference DEM) to generate a hydrologically conditioned raster.

## Installation
`geofabrics` is avaliable on [conda-forge](https://anaconda.org/conda-forge/geofabrics) and [PyPI](https://pypi.org/project/geofabrics/). Conda is recommended due to difficulties installing geopandas (a dependency) with pip on Windows. See the [Wiki Install Instructions](https://github.com/rosepearson/GeoFabrics/wiki/Package-Install-Instructions) for more information.

## General workflow

![DEM_generation_workflow](https://user-images.githubusercontent.com/22883860/161160412-eef14d39-ed92-4998-838a-15176052afb9.png)

## Documentation
### Wiki
For detailed instructions on installation, usage, and testing please check out the repo [wiki](https://github.com/rosepearson/GeoFabrics/wiki).

### API documentation
For auto-generated API documentation, checkout the repo [pages](https://rosepearson.github.io/GeoFabrics).

### Contributions
Please see our [Issue Tracker](https://github.com/rosepearson/GeoFabrics/issues) for details on coming features and additions to the software.

There is no current expectations of contributions to this project. We accept input in code reviews now. If you would like to be involved in the project, please contact the maintainer.

### Contacts
Maintainer: Rose Pearson @rosepearson rose.pearson@niwa.co.nz

### License
[GNU GPL](https://github.com/rosepearson/GeoFabrics/LICENSE)
