#!/usr/bin/env python3

# Copyright (c) Facebook, Inc. and its affiliates.
# This source code is licensed under the MIT license found in the
# LICENSE file in the root directory of this source tree.

WORKER_BLOCK_LIST = [
    # From the Wizard MTDONT block list
    'A2EDGL9NBR4G4N',
    'A1MZX7LJO18B3B',
    'A1362Z1A98OYI0',
    'AVZ5Y3LAPQVJW',
    'A1Y9MNILZTKE3K',
    'A1Z1J4ZFZPTVJU',
    'A2PJBSDDN22XIX',
    'A3OB3T7ZDKXLKE',
    'A23KWI5P9WYEBZ',
    'A1BR4BW8VFDA5C',
    'A1IDHLHIVKMT8D',
    'ATIAMDY7P54P',
    'AOHYIMYZSV858',
    'A21TIBPEO824YA',
    'AIICJA0A5J8NF',
    'A3ROHOZKLKRGQ2',
    'A1KPFZGNYZG7TJ',
    'A3MZXFELFJGA4H',
    'A3RS7UCO7CQ74R',
    'AT49Y7HOUVIYU',
    'AFXSY0RZRE7MJ',
    'AIYLGERYR260',
    'A20JZXXJLI6JI3',
    'A3FAKHP7OAFU6',
    'A1TR5RTETEIV29',
    'A8W8WL1CLMVK',
    'A7VFKFW1UQFTC',
    'AL47AERCCQ4R3',
    'AD14EQ9O9JKRI',
    'A2S5GPVIUV8RJI',
    'A30U4KTXFHR99R',
    'A388GPT6L70040',
    'A3VLHYQMLNOUL7',
    'A1IUFLA3CV7G7P',
    'A4XB9OF4LFHWF',
    'A1ZHKX7IKC9I9I',
    'A2H50O04Y8V8MM',
    'A3KYEREPRMOTS4',
    'A1517L56OPXUPV',
    'A2VDVY6H9PVG2',
    'A53ROP9BGMEF7',
    'A85TM1INY58RQ',
    'A21TGLR9YKV791',
    'A3ICEP6H7JBI15',
    'A3FAQHVPI8OUP0',
    'A35GEHI7589M8O',
    'A4Q0024O4LBST',
    'A2QV8VQP7P4VQ4',
    'A130X6CF795CQ5',
    'A2BMBZIKASUXSY',
    'A2U8QOJRKUCTWG',
    'A1SVE094KGKZW1',
    'A1FOHYPE8E402K',
    'A33OCPETN5JEZV',
    'A2YHNN0QPCX5F2',
    'AG4LSED06GB08',
    'AY0338O900WUQ',
    'A51MJBUE64ZGG',
    'AHG6F47DFETCW',
    'AYYBMS4XQJ9AP',
    'A2GDAB2S846VKO',
    'A1WNVR6YKJ8HAZ',
    'A1HXEXQTZCJ1DW',
    'A143QJ7CIPUR0A',
    'A2AORBOPRWWIO8',
    'A3FE7PVLG3C3Y4',
    'ALDKDKRBR4LXD',
    'AFBS8D6KBKKKY',
    'A1NG1ET0ONXXLR',
    'A74F0A6LW453J',
    'AKWIRTRUXO6R5',
    'A2T3AMPNP8PTDL',
    'A2J5N770I859WE',
    'A26D4H8UHMF9DZ',
    'A1VT4HJ87R2IRL',
    'AO2MNZUGWB5W9',
    'A2LIBGWOF6QSZU',
    'A2P2EFK3L4557B',
    'A28APL4YLROVUU',
    'A19VIBYTAB5T36',
    'A3TOPC0NUS7RNT',
    'A53VYIFCCASOA',
    'A1GD3VIFIN4KCN',
    'A1MRBBA2OLM223',
    'AV8O84CPC5TNI',
    'A1KEK5YSO0JF09',
    'A1U1TW15P3S5KK',
    'A26DHVEZYB1NXX',
    'A2TJ8FJGMEYNAY',
    'AHLK9SWDJHBBZ',
    'A2H2FIPTTOGVTY',
    'AWQTPM5UV35GZ',
    'A3RA2Z4TQPIU8B',
    'A12ZW89N0D9E2Y',
    'A3LVU39B5A9MNI',
    'A3NI7EZC6CNHHL',
    'A1J1QX4X6LR9HT',
    'A2MF659IGL53YO',
    'AXGFWTSWZTBH',
    'A3UOH4UMWWV216',
    'AJI3QQCTL8Y16',
    'ABQM9FJ6AXPCO',
    'A9KPCMO1J1LQF',
    'AVA6HLQVY2T01',
    'AFIA3STXPFRWY',
    'A3CY1ZG93NXQA4',
    'A2AT5B7RW4VXBX',
    'A2FAIBT5CFQK2L',
    'A2G0GS8LJN1YMY',
    'A2IFMHXWL5GOWD',
    'A3T8LBUQU7D5L1',
    'A2KMSW4Y4WZCIF',
    'A35Y99VXVUISP',
    'A3MSYD6PYG4QMM',
    'A290OV59Q76QC8',
    'A1X2NKYJNHB1A5',
    'A1ZLNPA9DJAJMF',
    'A31UVMRUFGGJ12',
    'A129D1YPQA58DJ',
    'A10MJRVBW1Y6EJ',
    'A1YFY5PS1NBG29',
    'ACNHKXWKZRUZ5',
    'A2VSEW6K2UJQTG',
    'A14H63JO45VV04',
    'A2ZCHYV7H7NKHX',
    'A36ECCOBKKRA08',
    'A2WPPMXWLR28LL',
    'A1ILOQZ922TXTW',
    'A1W7FH1HX00NMU',
    'A3O7UJSCIK79FB',
    'ARVR68C1JSTSJ',
    'A3SLO47ZROTY5W',
    'AVSLRTQLC2XK4',
    'A3PUU1XU4C1A3V',
    'A1M24593XO5Z3C',
    'A37Y5CTJ8HCQER',
    'A365NNKWZAZ2YV',
    'A16TP8YGKE1FJ5',
    'A3VI8KVHQ8CLA7',
    'AYRJS25P2DQM',
    'AIX1EB7WS8F0R',
    'A317GCWIBJQR9O',
    'A3A4ZWV53ALGGD',
    'A3T8HK5ZI7XLQI',
    'A1XV5Z9JK3FN7W',
    'A2LP3B5ZI9BXT0',
    'AGC4M8GFX35BE',
    'A3O905K0O9R7AQ',
    'AEQUW13EDOJOY',
    'AQJ3KWBJ1HM5J',
    'A1DIXA7S60TDBD',
    'A36338VUSZ21XJ',
    'A23KAJRDVCVGOE',
    'A1XI2BU5NXB72E',
    'A2T2039IS9SHNT',
    'A13HWFJZAHVYCV',
    'A1WXPOLDS1Y9R4',
    'A3EOUMFMUI2MUF',
    'A24YO9MZ1ZSCUK',
    'A2IOYG5PYLN3G4',
    'A15V8RC36S6N2Q',
    'A3BD9FO5I4ZC72',
    'A1BPD5MQKP11TV',
    'A1ENE99INLYD1G',
    'A1TMYLNRTLGV9E',
    'A2Z43TA0WZ0EG0',
    'AVPITE4HFF3BE',
    'AM47KWCDSFQYG',
    'A3QLCG7UJ3YGP',
    'A39C20H5MYEUFS',
    'A3OVGTQ8PW6EA2',
    'A0450532L5P3GX6JEY8C',
    'A2RL0WVNCSPHH9',
    'AX972W0CA4HMK',
    'ACVLD9BJOPKQP',
    'A3S67QA0SQVPUJ',
    'A25XKNZ3K587KN',
    'A2OTXP7RN0JEK',
    'A11LJQ41984DH',
    'A2IXFVW8GE5NYE',
    'A1FFKJJJTADDXZ',
    'A2GGKN1LCJKZ5F',
    'A10T4Y1QDTY4AX',
    'A3GZLCWLJHINMF',
    'A18B1TWURSJFOL',
    'A2OIWEMVKGV40K',
    'A3W2TEQC53S3WW',
    'AWX99CTT8IKKD',
    'A83DI5Q5K6F1F',
    'A1J5PTXE4YEUEJ',
    'AWHJJ1YYPK65H',
    'A1CQWE7C9ZUZP9',
    'AO5IPYBQGI5XL',
    'AKQP8M2GR7VCL',
    'AXQO833ZREEF',
    'A2Q1YS118AO2BP',
    'A7KDJOFZ52BRW',
    'A1RCP3YTL0TE7W',
    'A1MTRZDRKNB9GV',
    'A1D2WG5CP86F80',
    'A3LOGLCFNAFR9P',
    'A11XL5B029GPV1',
    'A311GYY1EASHUG',
    'AKAPWAUEDPVGV',
    'A2DH4G39VD8L2U',
    'A3862RIFFUV141',
    'A3GLK1KZBI9AYV',
    'A289DF24X3Q8JZ',
    'A3BOFWD3AVRMLC',
    'AYR9VG004VQ3W',
    'A28ZPY6D5AS7GZ',
    'A3EDDSTPCED8I9',
    'A49KQWKKE9TM9',
    'A30H28C1CN9YY1',
    'A37D1Y39RK287X',
    'AHBMTDOQX30UR',
    'AYW62R027PUT1',
    'ASLGHXA4453BQ',
    'A3DFPK9QX1I23Z',
    'A1HE34OAU1V3RN',
    'A1SGOTXJTU97Y',
    'AT6HH4TKU4WNH',
    'AS27MQ1UWFB6F',
    'AUYQS54JFQ0E8',
    'A16NCG28LPCV7M',
    'A3MG7PIXFTF99T',
    'A2JYKLMBRPL2FT',
    'AYKNKCEW00SQ9',
    'A1HWGVZHREV4CK',
    'A1UAY21A93RBWN',
    'AAMDW9AE0UMSD',
    'A1MHKO2XXQDPWK',
    'A1DZWR0SC8403M',
    'A2U80JE3BZEWKP',
    'A2L1MANPHEEEHJ',
    'A3UMXC516ZWMBY',
    'A1RSUIPE2IJ74R',
    'AMZHU0PPQPX2L',
    'AVLUX03TCOCEZ',
    'ASIBZ1YHF6RQ3',
    'A88QVXE9H03O8',
    'A1O038FZWC8391',
    'A2RTJ6BDY0DZVZ',
    'A3914P24XPNPY3',
    'A1PAY3X73PQ16S',
    'A1WAWEY2810TFN',
    'A26I76BUCO0LAO',
    'A31A4YKVSOYRVS',
    'A1D4RC6K6Y5KAV',
    'AEWT71858NL5V',
    'AT3C00TKZK13L',
    'AG5CRD9MQGQRK',
    'A1E00WIPQYL4YV',
    'A2F4YBSVAE3GTV',
    'A13NSQQSABDB8A',
    'A1B7N2P33OXCDX',
    'AKASOE05VGKQX',
    'A6759RSLD1F1U',
    'A11B69T2W3SQJQ',
    'A20UCH2AIB1YJU',
    'A2VHG0ZDQMZ2T0',
    'A3SMS9JDDY660M',
    'A1IL81UMEC9OJI',
    'A3PTO0DMF57GDG',
    'A17FO9JUX4WLR0',
    'A11I1H3D9Y5H0I',
    'AWZCVOUD0LPT',
    'A03172343NB8PHOPICC1',
    'A43JZAX12L2YS',
    'A20A7HSPBPQURF',
    'A8B2XTF3Y7QN1',
    'A29Y7MCUQWQHRI',
    'A2CX92GOFJSA1Q',
    'A2YUCJ28XANFOX',
    'A7XTK0OFY1CL7',
    'A18CFQ3FD3P192',
    'ATHOSAD21J8O5',
    'A2QAQ5GMC9AAN2',
    'AFW6GUZ19ME43',
    'A1WUC82IN5GX1D',
    'A2O6L7PPIEPTGC',
    'A2BP8SSKYDZZ64',
    'A184FTW575KH1O',
    'ASQJ4Z3WF3ZFP',
    'A35CL66BEUSJ5Z',
    'A26YGAOBEY203Q',
    'A398A2SX7V99TP',
    'A2WPHVMLLEV5ZB',
    'A11EKED1DGBPTJ',
    'A2JS2CR2T0YFGF',
    'A8PNOP2TYFFMM',
    'A3LWU3UZROBJ8D',
    'A1FVCMGXK85014',
    'A3P1S5BG8KQFUX',
    'A8KMV9PKBTNFV',
    'A1WQ33VXYM1L22',
    'AGXETS750OB8T',
    'A2TNTYHHICCA3Z',
    'A280TORYM293P6',
    'A3C0NQ2IP5FTZQ',
    'A2KHLQ2YFZRI67',
    'A21JT0ERHV0EAA',
    'A2EE7JRUB0QIUO',
    'ANADXMICQOAEF',
    'A1QO3XBQXLYEZW',
    'A3IO2OG6RUPCYU',
    'A1U5497HIBQOO3',
    'AV8EJRIB8QWZX',
    'A1SFV0N1ND6KOT',
    'AWJQ9L8NKVKSU',
    'A1AEBW8T2SRU96',
    'A37SZMJSY781LD',
    'A12OTV1DZ6B56P',
    'A2E0S4TGQQ2GP4',
    'AFA9AJM6MX0R',
    'A3A34LUDP9B8XV',
    'ASSJAY91L555I',
    'ARQVX5N01PRSF',
    'A2XRYF0L5ACD2E',
    'A293Y9SY2ETQN5',
    'A1HQL1FCG3DL81',
    'A2UGM73EHLK6XI',
    'A3VPG6HISACKAX',
    'AJN3TSX8OTRO2',
    'AI2LRSALOOKKU',
    'AO8GF80JX57Z6',
    'AVN1RGGP00USR',
    'A242BX1K16GKZJ',
    'A1RK9GJZPQTSK2',
    'A2PQ9O4EGEKF4A',
    'A105ZZ36NN238H',
    'A2466VRG17WV4S',
    'ABI1EI8UQK6LK',
    'A1ADGLKC2F1CHS',
    'A2KRPK3GQR0GA9',
    'ABAV4NZ1O9O9U',
    'A3EUFDOUX1GCL',
    'A2ZKHWQQ1SYNKL',
    'A16C6YZ3JXEAIU',
    'A9VOTAQ5SPSK0',
    'A1BQQO4RM0R7LW',
    'A36LW7PXV35Y2Z',
    'A2ZX7580NVWA6I',
    'A302K8B1H9ISJA',
    'A2RGHUEITGT0MG',
    'A3TTM1HZBJUG57',
    'AY4B7SUM68J3G',
    'A1O7WUQDKPZGH4',
    'A1QUNP6IYOQMZ5',
    'A325U72J005UAJ',
    'A39X3UG42U8O0Q',
    'A366XT3FM92R6H',
    'A3767929H3PJ2G',
    'A2NSU16OVT7K66',
    'A7UM4VJR1OEHC',
    'A15A09BRS1Q8W0',
    'A2QFVA7GDCHTU0',
    'A3ENX4KFFW7WI2',
    'A2S8W48IE5CS9N',
    'AC7Z8O1RETQC4',
    'A2ANLYFY8COULI',
    'A3CEEL0C3X3TJA',
    'A1Y8HSTIOFHAPL',
    'A1LB9JOMFQ1UMG',
    'A1K5CFQQ3SA7U0',
    'A3T4D2UBHQRH9',
    'A20WI3VW3CBOWN',
    'A3GUUW46FNRMS3',
    'A229PBL3A53GIY',
    'A24CVNEZ43BXG2',
    'A68DYK4MV2R7X',
    'A20COED6O4CND9',
    'A3M25XYMFHEWIW',
    'A1XZMHUCL0KTT8',
    'AKMQH2MGTUWO9',
    'AUSDM3KALROGI',
    'A3MSDZBF1OIOA6',
    'A30UE6DWFNUCWX',
    'A2P2T7K63H0C7F',
    'A2C25LZB76W44',
    'A1E2O60TTNA1TW',
    'A30YP6TXOXDN7C',
    'A1H544G8MU0EW3',
    'A2JKKGGRDVR6D6',
    'A3PMYE2XCDZL1W',
    'A2ODH6HV36EP88',
    'A160PJA1AHEPBX',
    'A2051CN5YPVQD',
    'A27C4HFS0EZHW8',
    'A287I95QOZYP5Z',
    'A1ICZ6VHY7Y2OY',
    'A1D4BGCNYC0VJE',
    'AUFVIBJPKZH9T',
    'A1ATL3G98SFW4V',
    'A25SORYWGW7RQC',
    'A3UCAJPHZLEO30',
    'A27GHKQVQ0EC6F',
    'A21JCEPVD925OG',
    'A2J9ZWDTAFJW65',
    'ARIMQAMYUB6TH',
    'A2K3MUBO2FWKRD',
    'A2V142ED2SBIDT',
    'A1OVGCI9KUL4MI',
    'A3IF7VYXDS77HY',
    'A1D4CMVMBTSIJQ',
    'A2WAIHLYP5O3XY',
    'AVNSJEVZDPFI0',
    'A2OK7UBINXYAYB',
    'AR8UD52ASM42W',
    'A1H8FU8G2IPTWR',
    'A270BYCBYEWV93',
    'A1VW8Y7XCV3DRW',
    'A2UZEA86KD49LA',
    'A168UD5L4AYS3P',
    'AK77EA1UZ8KJG',
    'AECBS7PZMFA8H',
    'AENL9GIIHVKYP',
    'A3EMEMWJDM5DAR',
    'A3AT9S1CF9QV4K',
    'A28VLQAH7JLSN9',
    'A3G1RZUV6N88MY',
    'A2JTIBE6LUJALD',
    'A3GWRDHAURRNK6',
    'A22V47J8KJ6NVS',
    'A18YNT2YI9HIDZ',
    'A3F9QE205RQFMS',
    'A3AZ6FSHQFW2YI',
    'A3CHSKOAWR1DVA',
    'A1VMXNIV0QG87A',
    'A378OB831PNG1M',
    'A34VLDKMO5OL9A',
    'A3FR9J09Q672FQ',
    'A3SLDTBPEJF1RJ',
    'A1PXIPGR381L27',
    'A34OXAINBMHBTD',
    'AAKUB8J4SL6T7',
    'AULC5HR1BBHMA',
    'A1LKKK4H3XF42C',
    'A3F2J0WFJKEHQ6',
    'A323RBOHUTRW53',
    'A1J4MCCVJF9KFN',
    'A311WZQX23843V',
    'AHOAVGSI4TG30',
    'A1HDD2B9I6D33I',
    'A3N7NW3VUMDL4X',
    'A3G8OON0TDPN1E',
    'AEX9MA72M10DC',
    'A48455XBWV5CN',
    'A2Y6H6QGPWH4N9',
    'A1KET5Z038NMWD',
    'A3ONQGH25UTI53',
    'A3ATHA35D3H03O',
    'A23LW0LD80F6OQ',
    'AWAW665TQQP2F',
    'A399GYOD60WD7M',
    'A38OPVI04AH4JG',
    'A175ZTL2OZO9YU',
    'AHKFBDBQSSRGB',
    'AFUZEIQF6FD30',
    'A3NHJPE6326P9V',
    'A1HJ8WQ4SEKGTP',
    'A29A2MQMPJW1O9',
    'A2KFBLF96DZUT0',
    'A11P0NVTBDLJI0',
    'A12LMSWO1N554W',
    'A1X8Q691YPS49C',
    'A25BFM935BPJ5S',
    'A2ADF6ZWRCABYX',
    'AEAEDLUBCLGBD',
    'A1EJHKM4OQRQ17',
    'A3S4N8VEMSDT2M',
    'A2P944DZPWKHK8',
    'A3IMSZ0F76M3UP',
    'AOON0WJX3Y6D7',
    'AXR3EE06JHWIK',
    'A3EIHWF3BV85M6',
    'A3GWHEQMMHMOBJ',
    'A1K9V708ILKQ0Y',
    'A104V5RLS1VRHC',
    'A3CXNFPFD15IYG',
    'AJCHFC8I9HS9Y',
    'A3FKQV3M6OTBPN',
    'AKC4O88D0D18F',
    'A3JF6PUKRL8CDC',
    'AMV1P2F3J8H46',
    'A2C27YTQSQ1GXS',
    'A3GFZ1XUDP6XND',
    'A1W5XENJPXXRGE',
    'A12EQIULBHM4HJ',
    'A1360QYWZ1RTTC',
    'A3U0OOXDAEEQE9',
    'A1NG6N2ZS58Q5O',
    'AUWJ4NRW4QFFV',
    'AK9ZPW1WLYRL7',
    'A2W6XZ8D8VYZCO',
    'A3MT4SBSBPER68',
    'A4CHLWPHZIP7Y',
    'AYM4WJ6ESPFM7',
    'A1YXA63F8FN0BX',
    'AF8V15OEV6FSK',
    'A2LT9OPQXI1T4S',
    'A2XQVNF7ZABUQZ',
    'A2XWRAT1O29IN1',
    'A1TSD3O3C3ZUT6',
    'A2YBZFSUD5OP7W',
    'AS30B1NLM2G4V',
    'A3UTN0AYFPC3QM',
    'A3NCWMI9JNXUTE',
    'A1O9QNULV6RMYJ',
    'A3VTW0XT1KY8GD',
    'A329QCEUSZE9CM',
    'A2MQGU4NZZ8V0H',
    'A1PZS3UIH64YP7',
    'A3AMKPBPSL8ESW',
    'A16YP2XC4UVPR6',
    'A5AV4YPTTX3HP',
    'A1BHW4QNL2D9EF',
    'A3OKF5QBTZAWTF',
    'AHCSVEPQLPVJR',
    'AWQODNYWCXHJ0',
    'A2KDCBG2V9ERXM',
    'AFHRMJIHMGLDE',
    'A4CO5H9ELU77Q',
    'A21KRIS0LBYYQB',
    'A1Q9DQOLJB8O83',
    'A2M72F8KER9L71',
    'A3QMK14UTWL92B',
    'A1FWIKXTO8TFBD',
    'A39VPS6S6KW20U',
    'AJW399H41QLIZ',
    'ACOA638F4IRRH',
    'A3QPWC4JWEVIUD',
    'A3KFBBAQ4QX9W8',
    'A1LVKTQYZPUKTL',
    'A3CFOOEPHER9E0',
    'ASAH67W5LWK3C',
    'A3LC6M2EMDBBXP',
    'A2X88LNHLU5HGA',
    'AG7C4X3WKKBV',
    'A2D52PK3Z04U7O',
    'A3OSBMDWIRT9NZ',
    'A2DYFS80ZFSPHL',
    'A2MD4K1YFYBLZN',
    'AD2NB2RECDM14',
    'A1KX1CMLUCQNFX',
    'A5SPTV3W3DP4B',
    'A21RG48A9K95AM',
    'A1HF8F8FQLNCSG',
    'A33QEKL88BD877',
    'A1LS1KIHU0J0N5',
    'A2OUBAGL24JS3C',
    'A1B81YYNH0K1M9',
    'A1QMZHBKOIWHZR',
    'A2TXVUF0GQ2ZBS',
    'A2EFD7AW29IXUR',
    'A35IMPTI2U7XGC',
    'A30CGO77OY7WP0',
    'A1M40RACC8SUOX',
    'A1TCVI7XIUYAS6',
    'A3FUKCYLQ1ED8U',
    'A2HVWKO9RY7C4Q',
    'ATPEQQT2JQQE9',
    'A1EP1BT7SH6S1C',
    'A10IOQTQGFL72M',
    'A2EW08X2I87RXL',
    'A2W355OIAMEPCY',
    'A38DC3BG1ZCVZ2',
    'A381VB0CP8OBR1',
    'A21WX8SSWIBC6G',
    'A1TJRJG49T50GU',
    'A2U3PTQXD0ZMOA',
    'A2K2MSP0EFWFTA',
    'A2UA3QR3EUAT9K',
    'A16VVUOYE2BK22',
    'A2Q9EHQMD2LPFO',
    'AC453DGT4TBVR',
    'A38JCBX2DD2ILP',
    'A30U9D1BJPIAAE',
    'A1D2K63U3LCO3F',
    'A2567YRXKOZG7X',
    'A1JGA15NKUP0BB',
    'A68H7B1CV3DNO',
    'A3PUC2F398860K',
    'A3V21KIOQARPV5',
    'A1KFC856Y77UC8',
    'A3ECCKH9FWOB4I',
    'A2NTP7ZK5C0UFK',
    'A2C0DDHHP3M6HB',
    'A1I0IMY55Z55T9',
    'A1PJUYJ7W2LKKQ',
    'A34JKPSBWNK2XX',
    'AKTWA4NBCUQMV',
    'A2OFCO98CSPOAF',
    'A3CSUQJ3WF1BKP',
    'A1NJ0J3SCP668A',
    'A3AHYU9P0HLG4',
    'AMDWITTNI32H5',
    'A3N2BYH5T90UF1',
    'A2XW3EP7VQPVBE',
    'A2B1BT2VPPAI9S',
    'A2JFK6KAWDU0KA',
    'AFLUEBR6W6LGM',
    'A2XCT66R93YLR8',
    'AER0OZMJWSFP4',
    'A11SAV8P55PQGP',
    'A1YCGICA8XCNBH',
    'A3AVTOBAJ6YWDW',
    'A2U7BMG19Q83GE',
    'A290986WDGR6A4',
    'A1DMLM2EKNJ007',
    'A3M0ZYOE111MLH',
    'AM8OWAW9TUVLN',
    'A1KFVQTYH977CO',
    'A18G0M3AZLEK3D',
    'A357V6IFVMK275',
    'A2K05RWEOSTCAJ',
    'A3FHIX6HE7YINC',
    'A33Z8XPZ94UGT2',
    'A2SMBMC531QRIC',
    'A1BBZ5EMNSCZJR',
    'A1JR3T6KQRSW0I',
    'A3MUG02LJ4BM9F',
    'A2HY5BZOYOZKM2',
    'A3DBGP4WIVXO5M',
    'A214HWAW1PYWO8',
    'A315CIDKJ3OSS2',
    'AW47H2ISJWAJC',
    'AI5T6AG8OLZNZ',
    'A38ENY014WTJHC',
    'A26TNG7TG9YCHV',
    'A1O4K7FF7XFOL8',
    'A1A1FB3IFEHJ5W',
    'A2NGN67ZKZKS2E',
    'A2NXLCGAAYHYDE',
    'A5IIP6KF9F0I3',
    'A3MAAY5R0J0IZD',
    'A1RK0C8N3ABXFY',
    'A1PMZUBGXFANCI',
    'A253RKS1MZTGFU',
    'A30FIJIJ2IJPAD',
    'A337KSVP6O577I',
    'APO5M8MGKRXLL',
    'AR80IW15AQII5',
    'A3A07QA5U733HQ',
    'A1Y8O0YZ8YF90H',
    'A30G113XRQO3VL',
    'A27QPURAF97I5W',
    'A12HXF6E0UKMQ3',
    'A125FN8IYVB93O',
    'A1GH0YCDQFS07G',
    'A3DGEVDRQP9LK8',
    'A2FUF8Z8WCFAR2',
    'A19DZAFFZEU6GN',
    'APC99TPURUHR8',
    'AUFUUD4WG9CVO',
    'A2HWMBTTEOTCF1',
    'APGK6WOJH50Y7',
    'A2UHI4DFC0LJ7W',
    'A3U31DOK7IJWPO',
    'A31WTERLIX9YJP',
    'A94ON4UELLEJV',
    'A27KN0KE5B7GGH',
    'A329XUHB78C2IK',
    'A2898VVCB32Y9W',
    'A17EPR0YBHIE09',
    'A1B84JJ7ATWVJA',
    'ATI2O3UUC45SW',
    'A3OFBVS7MCZMFB',
    'A3857UIWNWA45Z',
    'A321YWMP74ULKH',
    'A1OWD7P7MBDGTX',
    'A3SUIFV1F6Z60F',
    'A1C8FHSV86SIEK',
    'A15GMGDDLG2509',
    'A3V8C77FN4FLUA',
    'A2QWERWB75X8YU',
    'AEKDJM945F19R',
    'AIX33DZVKYC9Q',
    'A3TDELAGEYIB4U',
    'A24DDWABLZUX1H',
    'A1Y9Q612OQDA9B',
    'AHYVYJPFB6XGO',
    'A1E2AB5N0CWJHJ',
    'A1SMTECZU2UDYD',
    'A33W1ACHPHBIRQ',
    'A10414LQZ8VRAA',
    'A2XCNCNDI5YESN',
    'A2H8Q7AYXA4JM8',
    'A2IUUSQGQDEYID',
    'A1KC4BJOSTHCP3',
    'A357C0NLWK75L0',
    'AS5X6GRDJKWG3',
    'A2KPTC4K228GM3',
    'A197W7KY610MH1',
    'ARVB74PB6MINQ',
    'A2BKRXTTEE6F1K',
    'A1H8R02GMT1NIC',
    'A7E83RKHY0YBF',
    'A1KQ4XZM996XWW',
    'A3FDQG4KZOX0JY',
    'APR6H3HAOE9OU',
    'A7EUMZT21JWWW',
    'A3A5F4HMT8FDC2',
    'A3RT1GLGZ28OSU',
    'A26PNBW1H8182U',
    'A3LT5ZA52JHPJW',
    'A298FAWY76NZA9',
    'A2KBZ75HMJ7KVX',
    'A280U3UM2MSRWI',
    'A1NMKXK04PZ6KK',
    'A1RC3JPBW8T70D',
    'A29GIO8KW6X9PZ',
    'A3EJ1M6L3HGI81',
    'A31F3XNJWBYD0E',
    'A37JSPNB4CT7E0',
    'ATFUOQPYO550Z',
    'A37JR1K53GSXZ6',
    'ASGZ8ROT96507',
    'A2YRYIORUK1BFV',
    'A1UWSZ35ZUHC6Z',
    'A2IJWR2G8W4VSM',
    'A2Q2WYJ2Q71HY1',
    'A22T6X73W11DT8',
    'A3UBK9IMSSH84G',
    'A3RV2YAY6GXG8Y',
    'A2UBN2HBOSP3BL',
    'A2UNQJXOZT4O8V',
    'A2QTFUJ1ON2ZR2',
    'A2QQE2ZP8NSRKX',
    'AZA9IIBI3NQJI',
    'A3CQ5YC3Q6NG6D',
    'A2YTO4EY3MNYAJ',
    'AQ09TR8WM6V68',
    'A1BF3P4XXJ479',
    'A2XZQ8ZG115G6S',
    'A14IKNI99J7GAK',
    'A1C0GPV7RMMC8J',
    'AUZ3YWTVBISNH',
    'A26FIQ42LD6QIO',
    'A14IK3PBRHG1SZ',
    'AHPOH7GFQK14J',
    'A17PAQSQ74L915',
    'A8ON2E4QW6361',
    'A38EPBV0ED7Y47',
    'A3M9447COF4XXK',
    'A19KF02ULCISTQ',
    'A2NNR9TH3LRUNO',
    'A2V9LNBP8V10WR',
    'A11YVNWG6PABDH',
    'A1HYMGPYXU97ZN',
    'A1FBX0YF8W9SVL',
    'A19HF68K3BLYW',
    'A11KZN36WNEOP1',
    'A3RW8GZMZM1NUM',
    'A10058991HDYL2XK2CYF5',
    'A35GGNXZVHDU23',
    'A1SNX3UY85DHJ8',
    'A1AL6LLQZMCX63',
    'A1HZC44BSP0812',
    'A1Z8H4TFUP7DP1',
    'A1Q16A7AICS0C4',
    'A3KWM8WSJMGI45',
    'A2F2DDH12YU4AK',
    'A5GORMMBKM5MW',
    'A1UF3O4T7JIT11',
    # From the historical block list as per @ems
    'A110SC5K5Y3IHS',
    'A2P3WROT1JFU0C',
    'A30H28F41UBJGK',
    'A30QWXG142B3I7',
    'A3U7EIF0P9GQKI',
    'A18B1TWURSJFOL',
    'A25KM3PUOUZFN1',
    'A30GPAEVFFIAIW',
    'A7SXWHGK8B40R',
    'ADYMIMV1PE14V',
    'APQU1QQ738JV9',
    'A12VQHPT0YHMIS',
    'A1GKOXB766FPYV',
    'A2YRYS17DU3A8R',
    'A3A8P4UR9A0DWQ',
    'AZOK0NYBJ9ZCS',
    'ARB80JPV0HQ5O',
    'AZXHJOJDNOKY9',
    'A3F51C49T9A34D',
    'A3H6KECCE83132',
    'ALJMVJ1L3NUTE',
    'A1KEAHVVML6319',
    'A3V8RTCR7QOGTU',
    'A2D30R5ZNQS01W',
    # From the BST block list
    'A2V7RTBYCIY1CC',
    'A12FTSX85NQ8N9',
    'A10XVXENJSMVXK',
    'A15CQX79LVBP47',
    'A18XFOKU5G1OL1',
    'A1D4AADVETZBJL',
    'A1M7UZIDHYM5OW',
    'A1SYEEL3UI2798',
    'A1WUIBYF6LYDE6',
    'A1XY4JBD8W2NAK',
    'A1YKYHR21SH7LV',
    'A20MS0C8F8SO9A',
    'A21AA9YRALZMTL',
    'A22KYUSPCMWIKR',
    'A238OD6LO49BQB',
    'A23SRPD0V5TQWN',
    'A24HPZ4V1DMERW',
    'A265ZWW6RE1HMR',
    'A26EN6J1ENYOC',
    'A26LVPQPUVF0CS',
    'A2E286WNSB7KPL',
    'A2ROUAYT2602ZS',
    'A2SW0Q0WFUEQ7W',
    'A2WEEHSZ6LRPIQ',
    'A2XZU2LON0FYDQ',
    'A2Y2ITJ2MOUWDQ',
    'A3388HIWAKD3DV',
    'A35CL66BEUSJ5Z',
    'A35J1SKAW9FTJX',
    'A38KMNO228K3JN',
    'A38VE3N9O0332D',
    'A3FAH5S2RGZ5AK',
    'A3HDUN4OCT9VOH',
    'A3IGG3RX4HXUV9',
    'A3UQ814LD79TYI',
    'A3V4D3VRPG4IIB',
    'A4IPFWI1G83KJ',
    'A5X1KZ9CCHREK',
    'A7GUGMM7FW0B0',
    'A9MGD6PRW1N7K',
    'ACDG7LLXBKIO3',
    'AD1PP40BCLSD2',
    'AG9LMLEPXP2YC',
    'AK97EWXEUC3US',
    'AKZAA5LI5LPK1',
    'AMCCMY6BFKAAY',
    'ANE1LCDVE08VP',
    'AS0ILOJM70MNS',
    'ATDX69AZL4Y49',
    'AW9V44YSOJRZ7',
    'AXD4AU1WLVRA5',
    # MRW 03/03/2020 Q-Learning task blocking
    'A3F9CSBY2TWKYD',
    'AISTD1HQ435V6',
    'A3PG0JLE2ASS5Q',
    'A3SU8ZRZ89Y1HP',
    'A1ZEMY6A0UZSQE',
    'AH09APLOU5WTZ',
    'A11M5KWP2835VO',
    'A2HL6X4KR2TYDH',
    # MRW 03/05/2020 Q-Learning task blocking
    'A1OIHI9UX426J6',
    'A3F9CSBY2TWKYD',
    'AISTD1HQ435V6',
    'A3PG0JLE2ASS5Q',
    'A3SU8ZRZ89Y1HP',
    'A1ZEMY6A0UZSQE',
    'AH09APLOU5WTZ',
    'A11M5KWP2835VO',
    'A2HL6X4KR2TYDH',
    'A2V7M4R4Z9X4KZ',
    'A27IRXEUGO2QFY',
    'AQCRAZMX81FPM',
    'A1OIHI9UX426J6',
    'A3ABAYPIXFEJ7O',
    'A1Q27X84KILQHI',
    'A1OIHI9UX426J6',
    'A5SXFV4SG610A',
    'A1BWS7AMV8U76P',
    'A134S0D2DGBLZM',
    'A2NXFT6TYMOZX4',
    'A23XY6QTMLKP7S',
    'AY8FPZU1FGL7U',
    'A23XY6QTMLKP7S',
    'AY8FPZU1FGL7U',
    'AJ59Z3XXI1F65',
    'AUVVC285EV5ED',
    'A5SXFV4SG610A',
    'AQCRAZMX81FPM',
    'A5SXFV4SG610A',
    'A28VOJYW06BFXN',
    'AKU98LCT727Z4',
    'AGGO60OK8U21',
    'A1ONTPD4RQHVYK',
    'A2UQ3T8JW2TDD3',
    'A2UQ3T8JW2TDD3',
    'A15WSCSOBILQUL',
    'A1ZJLRH64XQTUV',
    'A15W556RLL7WMX',
    'A2FIKTYGZDS95G',
    'A1GXUCBX3YNEG1',
    'AISN46S2QWGR',
    'AQCRAZMX81FPM',
    'A24015P7FUGTMF',
    'A2L6V30CL1RU6',
    'AQCA3A11Y2O7J',
    'AQCA3A11Y2O7J'
    # MRW 03/08 new workers to block from q-learning
    'AZXG2N87ERWCV',
    'A31DHCPF9VKR84',
    'AW02W1A865GT4',
    'A3F8Q89RWR2XPV',
    'A17EMVJWIK9KNU',
    'AKYQFIQ5412PW',
    'A3MGQJM5IXD0J7',
    'A3MGQJM5IXD0J7',
    'A1FKUZN5M2FSOP',
    'A26PKIZV08W9H6',
    'A19NQCJKNO6WUZ',
    'A3R5P4URN7QKU8',
    # MRW 03/09 new workers to block from q-learning
    'AZXG2N87ERWCV',
    'A1F2QH2LX69A2D',
    'A1F2QH2LX69A2D',
    'A2E9730O1S6JJM',
    'A38OIA83NQZP1A',
    'A1TYMXIYUUUL6F',
    'A37GN2WIEMKT2W',
    'A1XWTAY2OMLG3I',
    'A39PONM7PGW1NP',
    'A28SYXQL3YOKVL',
    'AM2NZYM1ODCK0',
    'AOWLCXNXCSQAC',
    'A3HFS6Q0TONAB9',
    'A3HFS6Q0TONAB9',
    'A3RPBCCE8DRZSX',
    'A1LJMGAUGAL3YY',
    'A3SH61ZK61F06M',
    'A3HFS6Q0TONAB9',
    'AOWLCXNXCSQAC',
    'A2E9730O1S6JJM',
    'AOWLCXNXCSQAC',
    'AOWLCXNXCSQAC',
    # MRW added 04/01/2020
    'A3SDFAOJW87FGP',
    'A2DN53DIE3049T',
    'A3FT3XPTOWHJMY',
    'A3QUAM5Y482D4U',
    'A1PCG4KUR2922R',
    'A3IGX9S92GTNMI',
    'A3UFVY83ZLTOZ8',
    'A3UFVY83ZLTOZ8',
    'A1FAK4VQ6WQUDC',
    'A3UFVY83ZLTOZ8',
    'A1FAK4VQ6WQUDC',
    'A1FAK4VQ6WQUDC',
    'A3UFVY83ZLTOZ8',
    'A3UFVY83ZLTOZ8',
    'A1ZK2YLW30ZNAG',
    'A1FAK4VQ6WQUDC',
    'AUAN582MLI96N',
    # MRW added 04/15/2020
    'A3VNI44GLZ5A0O',
    'A2AG8QSD4IWEC9',
    'A2XHNHSBAHOGHZ',
    'A1MHQQGREWFKLV',
    'A1AS4S7BOJPOEY',
    'A1HSUZYC7KXZGJ',
    'A2LG8338VPNGSE',
    # MRW added 05/15/2020
    'A3JPWEQUCQNQDB',
    'A1WD456M5VSUQ5',
    'A2QK5YDM3YP9A',
    'A2C9NR5DY668JU',
    'A2QK5YDM3YP9A',
    'A3O0EZG0VNIE1J',
    'A3O0EZG0VNIE1J',
    'A25NZKEWQAGAXS',
    'AY999MGRE1NTA',
    'A2PQ54NMDG0DWT',
    'A2PQ54NMDG0DWT',
    # JX added 05/19/2020 from all live_adversarial, _v2, _v3
    'A3JPWEQUCQNQDB',
    # JX added 05/20/2020 from safeway
    'A322Q7T81OFBBR',
    'A110J8N6U4HSTY',
    'A16XRFDLE32RQ9',
    'A16XRFDLE32RQ9',
    'A110J8N6U4HSTY',
    'A16XRFDLE32RQ9',
    'A16XRFDLE32RQ9',
    'A110J8N6U4HSTY',
    # JX added 05/23/2020 from safeway2
    'A322Q7T81OFBBR',
    'A110J8N6U4HSTY',
    'A16XRFDLE32RQ9',
    'A16XRFDLE32RQ9',
    'A110J8N6U4HSTY',
    'A16XRFDLE32RQ9',
    'A16XRFDLE32RQ9',
    'A110J8N6U4HSTY',
    # JX added 05/27/2020 from nonseq3
    'A2X71093CCDW7V',
    # JX added 05/29/2020 from safeagent_topic, safeagent_topic_safety
    'A1NLKLRUV2JP9U',
    'A1NLKLRUV2JP9U',
    'A17B4Y3PTYJC3R',
    'A17B4Y3PTYJC3R',
    'A17B4Y3PTYJC3R',
    'A17B4Y3PTYJC3R',
]
