# EC2 Manager

[![Publish Package](https://github.com/jamesbaber1/ec2-manager/actions/workflows/publish-package.yaml/badge.svg)](https://github.com/jamesbaber1/ec2-manager/actions/workflows/publish-package.yaml)

A python wrapper around a terraform ec2 deployment. It awaits instances till their done initializing and allows the user more control over updating or not updating particular instances.
It also streamlines project setup and deployments with GitHub workflows.

## Dependencies
* [Terraform](https://www.terraform.io/downloads.html) The python package deploys a terraform module.
* [AWS CLI](https://docs.aws.amazon.com/cli/latest/userguide/install-cliv2.html) Boto3 commands check the instance status and send it ssm commands. 
* [GitHub](https://github.com) The deployment updates based on a GitHub repo. 
* [Docker](https://docs.docker.com/) Centered around docker deployments, but it is not a requirement.
* [Python](https://www.python.org/downloads/) The tool is written is python.

## Installation
You can install this package with pip by running the command below.
```shell
pip install ec2-manager
```

## Usage
Here is a basic example of 

1. Setup your project and make sure to check it into GitHub
    ```shell
    ec2-manger init
    ```
   This will setup your repo with a template and a config that looks like this:
   ### config.yaml
   ```yaml
   # globals
   type: example
   aws_region: us-east-1
   vpc_name: "Default VPC"
   public_subnet_cidr: "172.31.0.0/20"
   
   # instance configurations
   instances:
     example-instance-1:
       instance_type: t4g.nano
       update: True
       volume_size: 8
       commands:
         start: "docker-compose up --detach"
         stop: "docker-compose down"
       envs:
         EXAMPLE: HelloWorld
       ports:
         - protocol: tcp
           from_port: 80
           to_port: 80
   
   ```
2. Add your secrets to your repo via the prompts
    ```shell
    ec2-manger set-secrets
    ```
3. Apply your changes to deploy, or use the workflow in the template to auto deploy on push.
   ```shell
   ec2-manger apply
   ```

## Override 
You can subclass ec2-manager to script in any custom steps or additional remote commands.
### custom_manager.py
```python
import ec2_manager

class CustomManager(ec2_manager.EC2Manager):
    def update(self):
        print('Override!!')
        self.create_instances()
        self.update_repos()
        self.stop()
        self.start()
```

Then run ec2-manager with the these flags
```shell
ec2-manager --subclass-file ./custom_manager.py --subclass-name CustomManager
```