# vrt_lss_lastmile
Veeroute.LSS Lastmile API

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 3.7.167066
- Package version: 3.7.167066
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import vrt_lss_lastmile
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import vrt_lss_lastmile
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import vrt_lss_lastmile
from pprint import pprint
from vrt_lss_lastmile.api import actualize_api
from vrt_lss_lastmile.model.actualize_task import ActualizeTask
from vrt_lss_lastmile.model.inline_response400 import InlineResponse400
from vrt_lss_lastmile.model.inline_response401 import InlineResponse401
from vrt_lss_lastmile.model.inline_response415 import InlineResponse415
from vrt_lss_lastmile.model.inline_response429 import InlineResponse429
from vrt_lss_lastmile.model.inline_response500 import InlineResponse500
from vrt_lss_lastmile.model.inline_response501 import InlineResponse501
from vrt_lss_lastmile.model.inline_response502 import InlineResponse502
from vrt_lss_lastmile.model.inline_response503 import InlineResponse503
from vrt_lss_lastmile.model.inline_response504 import InlineResponse504
from vrt_lss_lastmile.model.inline_response_default import InlineResponseDefault
from vrt_lss_lastmile.model.plan_result import PlanResult
# Defining the host is optional and defaults to https://api.veeroute.tech/v3
# See configuration.py for a list of all supported configuration parameters.
configuration = vrt_lss_lastmile.Configuration(
    host = "https://api.veeroute.tech/v3"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization (JWT): ApiKeyAuth
configuration = vrt_lss_lastmile.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)


# Enter a context with an instance of the API client
with vrt_lss_lastmile.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = actualize_api.ActualizeApi(api_client)
    actualize_task = ActualizeTask(
        plan_task=PlanTask(
            locations=[
                AdvancedLocation(
                    key="location01",
                    location=Location(
                        latitude=55.692789,
                        longitude=37.554554,
                        arrival_duration=15,
                        departure_duration=5,
                    ),
                    transport_restrictions=["2T"],
                    load_windows=[
                        LoadWindow(
                            time_window=TimeWindow(
                                _from=dateutil_parser('2021-02-21T09:30:00+03:00'),
                                to=dateutil_parser('2021-02-21T19:45:00Z'),
                            ),
                            gates_count=1,
                        ),
                    ],
                    attributes=Attributes(["Name:X51"],
                ),
            ],
            orders=[
                Order(
                    key="order01",
                    order_features=OrderFeatures(["Special"],
                    order_restrictions=OrderRestrictions(["Special"],
                    performer_restrictions=PerformerRestrictions(["Special"],
                    performer_blacklist=PerformerBlacklist(["A0"],
                    cargos=[
                        Cargo(
                            key="cargo01",
                            capacity=Capacity(
                                mass=10,
                                volume=2,
                                capacity_x=1,
                                capacity_y=2,
                                capacity_z=3,
                            ),
                            rotation=Rotation(["ALL"],
                            width=1,
                            height=0.3,
                            length=2.2,
                            max_storage_time=60,
                            restrictions=BoxRestrictions(["Freezer"],
                            cargo_features=CargoFeatures(["Clean"],
                            cargo_restrictions=CargoRestrictions(["Warm"],
                        ),
                    ],
                    demands=[
                        Demand(
                            key="demand_1",
                            demand_type="WORK",
                            target_cargos=["cargo01"],
                            precedence_in_trip=1,
                            precedence_in_order=1,
                            possible_events=[
                                PossibleEvent(
                                    key="event_1",
                                    location_key="location01",
                                    duration=10,
                                    reward=199.9,
                                    time_window=TimeWindow(
                                        _from=dateutil_parser('2021-02-21T09:30:00+03:00'),
                                        to=dateutil_parser('2021-02-21T19:45:00Z'),
                                    ),
                                    soft_time_window=TimeWindow(
                                        _from=dateutil_parser('2021-02-21T09:30:00+03:00'),
                                        to=dateutil_parser('2021-02-21T19:45:00Z'),
                                    ),
                                ),
                            ],
                            attributes=Attributes(["Name:X51"],
                        ),
                    ],
                    attributes=Attributes(["Name:X51"],
                ),
            ],
            performers=[
                Performer(
                    key="performer0001",
                    max_work_shifts=3,
                    performer_features=PerformerFeatures(["B1","Special"],
                    transport_restrictions=TransportRestrictions(["B1"],
                    own_transport_type=TransportType("CAR"),
                    attributes=Attributes(["Name:X51"],
                ),
            ],
            transports=[
                Transport(
                    key="transport0001",
                    transport_type=TransportType("CAR"),
                    transport_features=TransportFeatures(["20T"],
                    performer_restrictions=PerformerRestrictions(["Special"],
                    boxes=[
                        Box(
                            key="box01",
                            capacity=Capacity(
                                mass=10,
                                volume=2,
                                capacity_x=1,
                                capacity_y=2,
                                capacity_z=3,
                            ),
                            max_size=Capacity(
                                mass=10,
                                volume=2,
                                capacity_x=1,
                                capacity_y=2,
                                capacity_z=3,
                            ),
                            width=1,
                            height=3.1,
                            length=2.1,
                            features=["Freezer"],
                        ),
                    ],
                    attributes=Attributes(["Name:X51"],
                ),
            ],
            shifts=[
                Shift(
                    key="shift01",
                    shift_type="PERFORMER",
                    resource_key="performer01",
                    availability_time=TimeWindow(
                        _from=dateutil_parser('2021-02-21T09:30:00+03:00'),
                        to=dateutil_parser('2021-02-21T19:45:00Z'),
                    ),
                    working_time=TimeWindow(
                        _from=dateutil_parser('2021-02-21T09:30:00+03:00'),
                        to=dateutil_parser('2021-02-21T19:45:00Z'),
                    ),
                    start_location_key="location01",
                    finish_location_key="location01",
                    tariff=UniversalTariff(
                        cost_per_shift=2000,
                        constraints=[
                            TariffConstraint(
                                stage_length=200000,
                                cost_per_unit=1.5,
                            ),
                        ],
                    ),
                    attributes=Attributes(["Name:X51"],
                ),
            ],
            hardlinks=[
                Hardlink(
                    key="group01",
                    links=[
                        HardlinkElement(
                            type="ORDER",
                            entity_key="ord0001",
                        ),
                    ],
                ),
            ],
            trips=[
                Trip(
                    key="TRIP0001",
                    assigned_shifts=[
                        AssignedShift(
                            shift_key="performer01",
                            shift_time=TimeWindow(
                                _from=dateutil_parser('2021-02-21T09:30:00+03:00'),
                                to=dateutil_parser('2021-02-21T19:45:00Z'),
                            ),
                        ),
                    ],
                    actions=[
                        TripAction(
                            order_key="order01",
                            demand_key="demand01.1",
                            event_key="location01",
                            location_key="location01",
                            todolist=[
                                TripJob(
                                    job_type=JobType("START_WORK"),
                                    job_time=dateutil_parser('2020-11-21T09:30:00+03:00'),
                                ),
                            ],
                            cargo_placements=[
                                CargoPlacement(
                                    box_key="box01",
                                    cargo_key="cargo01",
                                ),
                            ],
                            attributes=Attributes(["Name:X51"],
                        ),
                    ],
                    waitlist=["order02"],
                    start_location_key="location01",
                    finish_location_key="location01",
                    attributes=Attributes(["Name:X51"],
                ),
            ],
            settings=PlanSettings(
                configuration="optimize_distance",
                planning_time=30,
                result_ttl=10,
                result_timezone=3,
                predict_slots=2,
                transport_factor=[],
                capacity_factor=[],
                routing=[],
                assumptions=PlanAssumptions(
                    traffic_jams=False,
                    toll_roads=False,
                    ferry_crossing=False,
                    flight_distance=True,
                    disable_compatibility=True,
                    disable_capacity=True,
                    same_order_time_window=True,
                    expand_shift_time_window=True,
                ),
                precision=3,
            ),
        ),
        plan_result=PlanResult(
            tracedata=TraceData(
                code="client_server_service_time_id",
            ),
            trips=[
                Trip(
                    key="TRIP0001",
                    assigned_shifts=[],
                    actions=[],
                    waitlist=["order02"],
                    start_location_key="location01",
                    finish_location_key="location01",
                    attributes=Attributes(["Name:X51"],
                ),
            ],
            statistics=PlanStatistics(
                total_statistics=Statistics(
                    cost=1231.1,
                    reward=2343.3,
                    measurements=Measurements(
                        driving_time=15,
                        waiting_time=5,
                        working_time=50,
                        arriving_time=30,
                        departure_time=20,
                        total_time=120,
                        distance=5200,
                        time_window=TimeWindow(
                            _from=dateutil_parser('2021-02-21T09:30:00+03:00'),
                            to=dateutil_parser('2021-02-21T19:45:00Z'),
                        ),
                    ),
                    orders_count=1700,
                    plan_orders_count=1000,
                    waitlist_orders_count=700,
                    performers_count=257,
                    capacity_utilization=Capacity(
                        mass=10,
                        volume=2,
                        capacity_x=1,
                        capacity_y=2,
                        capacity_z=3,
                    ),
                    capacity_max=Capacity(
                        mass=10,
                        volume=2,
                        capacity_x=1,
                        capacity_y=2,
                        capacity_z=3,
                    ),
                    quality=QualityStatistics(
                        soft_time_window_violations=TimeWindowViolation(
                            before=ObjectsMetrics(
                                keys=["obj1"],
                                count=1700,
                            ),
                            after=ObjectsMetrics(
                                keys=["obj1"],
                                count=1700,
                            ),
                        ),
                        hard_time_window_violations=TimeWindowViolation(
                            before=ObjectsMetrics(
                                keys=["obj1"],
                                count=1700,
                            ),
                            after=ObjectsMetrics(
                                keys=["obj1"],
                                count=1700,
                            ),
                        ),
                    ),
                ),
                trips_statistics=[
                    TripStatistics(
                        trip_key="trip01",
                        statistics=Statistics(
                            cost=1231.1,
                            reward=2343.3,
                            measurements=Measurements(
                                driving_time=15,
                                waiting_time=5,
                                working_time=50,
                                arriving_time=30,
                                departure_time=20,
                                total_time=120,
                                distance=5200,
                                time_window=TimeWindow(
                                    _from=dateutil_parser('2021-02-21T09:30:00+03:00'),
                                    to=dateutil_parser('2021-02-21T19:45:00Z'),
                                ),
                            ),
                            orders_count=1700,
                            plan_orders_count=1000,
                            waitlist_orders_count=700,
                            performers_count=257,
                            capacity_utilization=Capacity(
                                mass=10,
                                volume=2,
                                capacity_x=1,
                                capacity_y=2,
                                capacity_z=3,
                            ),
                            capacity_max=Capacity(
                                mass=10,
                                volume=2,
                                capacity_x=1,
                                capacity_y=2,
                                capacity_z=3,
                            ),
                            quality=QualityStatistics(
                                soft_time_window_violations=TimeWindowViolation(
                                    before=ObjectsMetrics(
                                        keys=["obj1"],
                                        count=1700,
                                    ),
                                    after=ObjectsMetrics(
                                        keys=["obj1"],
                                        count=1700,
                                    ),
                                ),
                                hard_time_window_violations=TimeWindowViolation(
                                    before=ObjectsMetrics(
                                        keys=["obj1"],
                                        count=1700,
                                    ),
                                    after=ObjectsMetrics(
                                        keys=["obj1"],
                                        count=1700,
                                    ),
                                ),
                            ),
                        ),
                        stop_statistics=[
                            StopStatistics(
                                location=Location(
                                    latitude=55.692789,
                                    longitude=37.554554,
                                    arrival_duration=15,
                                    departure_duration=5,
                                ),
                                location_key="location01",
                                demand_ids=[
                                    "demand01",
                                ],
                                measurements=Measurements(
                                    driving_time=15,
                                    waiting_time=5,
                                    working_time=50,
                                    arriving_time=30,
                                    departure_time=20,
                                    total_time=120,
                                    distance=5200,
                                    time_window=TimeWindow(
                                        _from=dateutil_parser('2021-02-21T09:30:00+03:00'),
                                        to=dateutil_parser('2021-02-21T19:45:00Z'),
                                    ),
                                ),
                                upload=TransportLoad(
                                    count=460,
                                    capacity=Capacity(
                                        mass=10,
                                        volume=2,
                                        capacity_x=1,
                                        capacity_y=2,
                                        capacity_z=3,
                                    ),
                                ),
                                download=TransportLoad(
                                    count=460,
                                    capacity=Capacity(
                                        mass=10,
                                        volume=2,
                                        capacity_x=1,
                                        capacity_y=2,
                                        capacity_z=3,
                                    ),
                                ),
                                current_load=TransportLoad(
                                    count=460,
                                    capacity=Capacity(
                                        mass=10,
                                        volume=2,
                                        capacity_x=1,
                                        capacity_y=2,
                                        capacity_z=3,
                                    ),
                                ),
                            ),
                        ],
                        total_load=TransportLoad(
                            count=460,
                            capacity=Capacity(
                                mass=10,
                                volume=2,
                                capacity_x=1,
                                capacity_y=2,
                                capacity_z=3,
                            ),
                        ),
                        max_load=TransportLoad(
                            count=460,
                            capacity=Capacity(
                                mass=10,
                                volume=2,
                                capacity_x=1,
                                capacity_y=2,
                                capacity_z=3,
                            ),
                        ),
                    ),
                ],
            ),
            validations=[
                Validation(
                    type="info",
                    entity_key="ord0001",
                    entity_type="order",
                    info="bad time windows",
                ),
            ],
            unplanned_orders=[
                UnplannedOrder(
                    order=Order(
                        key="order01",
                        order_features=OrderFeatures(["Special"],
                        order_restrictions=OrderRestrictions(["Special"],
                        performer_restrictions=PerformerRestrictions(["Special"],
                        performer_blacklist=PerformerBlacklist(["A0"],
                        cargos=[],
                        demands=[],
                        attributes=Attributes(["Name:X51"],
                    ),
                    reason="undefined",
                ),
            ],
            progress=50,
            info=PlanInfo(
                status=PlanStatus("FINISHED_IN_TIME"),
                result_version=13,
                planning_time=10,
                waiting_time=5,
            ),
        ),
        facts=Facts(
            order_facts=[
                OrderFact(
                    type="DONE",
                    time=dateutil_parser('2020-11-21T09:30:00+03:00'),
                    order_key="order_01",
                    demand_facts=[
                        DemandFact(
                            type="DONE",
                            time=dateutil_parser('2020-11-21T09:30:00+03:00'),
                            demand_key="demand_01",
                            job_facts=[
                                JobFact(
                                    time=dateutil_parser('2020-11-21T09:30:00+03:00'),
                                    job_type=JobType("START_WORK"),
                                ),
                            ],
                        ),
                    ],
                ),
            ],
            performer_facts=[
                PerformerFact(
                    time=dateutil_parser('2020-11-21T09:30:00+03:00'),
                    performer_key="performer_01",
                    position=TrackPoint(
                        latitude=55.692789,
                        longitude=37.554554,
                        time=dateutil_parser('2020-11-21T19:45:00Z'),
                    ),
                ),
            ],
            transport_facts=[
                TransportFact(
                    time=dateutil_parser('2020-11-21T09:30:00+03:00'),
                    transport_key="transport_01",
                    position=TrackPoint(
                        latitude=55.692789,
                        longitude=37.554554,
                        time=dateutil_parser('2020-11-21T19:45:00Z'),
                    ),
                ),
            ],
        ),
        actualize_settings=ActualizeSettings(
            current_time=dateutil_parser('2020-11-21T09:30:00+03:00'),
            result_timezone=3,
            geo_provider="OSRM",
            toll_roads=False,
            ferry_crossing=False,
        ),
    ) # ActualizeTask | New request for actualization.

    try:
        # Trips actualization.
        api_response = api_instance.actualize(actualize_task)
        pprint(api_response)
    except vrt_lss_lastmile.ApiException as e:
        print("Exception when calling ActualizeApi->actualize: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.veeroute.tech/v3*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ActualizeApi* | [**actualize**](docs/ActualizeApi.md#actualize) | **POST** /lastmile/actualize | Trips actualization.
*AnalyticsApi* | [**analytics**](docs/AnalyticsApi.md#analytics) | **POST** /lastmile/analytics/xlsx | Planning result analytics.
*ConvertApi* | [**convert_to_json**](docs/ConvertApi.md#convert_to_json) | **POST** /lastmile/convert/json | Conversion of planning task and result.
*ConvertApi* | [**convert_to_lss**](docs/ConvertApi.md#convert_to_lss) | **POST** /lastmile/convert/lss | Conversion from the UD format to the LSS format.
*ConvertApi* | [**convert_to_processing**](docs/ConvertApi.md#convert_to_processing) | **POST** /lastmile/convert/processing | Conversion from the LSS format to the LSS Processing format.
*ConvertApi* | [**convert_to_xlsx**](docs/ConvertApi.md#convert_to_xlsx) | **POST** /lastmile/convert/xlsx | Conversion of planning task and result.
*PlanApi* | [**delete_result**](docs/PlanApi.md#delete_result) | **DELETE** /lastmile/result/{id} | Removal of the planning result.
*PlanApi* | [**get_result**](docs/PlanApi.md#get_result) | **GET** /lastmile/result/{id} | Getting the planning result.
*PlanApi* | [**get_result_xlsx**](docs/PlanApi.md#get_result_xlsx) | **GET** /lastmile/result/xlsx/{id} | Getting the planning result in XLSX format.
*PlanApi* | [**plan**](docs/PlanApi.md#plan) | **POST** /lastmile/plan | Planning, synchronous call.
*PlanApi* | [**run_plan**](docs/PlanApi.md#run_plan) | **POST** /lastmile/run_plan | Launching the planning process.
*PlanApi* | [**run_plan_xlsx**](docs/PlanApi.md#run_plan_xlsx) | **POST** /lastmile/run_plan/xlsx | Launching the planning process based on data from XLSX file.
*PredictApi* | [**predict**](docs/PredictApi.md#predict) | **POST** /lastmile/predict | Time window prediction.
*SystemApi* | [**check**](docs/SystemApi.md#check) | **GET** /lastmile/check | Checking the service availability.
*SystemApi* | [**version**](docs/SystemApi.md#version) | **GET** /lastmile/version | Getting the service version.
*ValidateApi* | [**validate**](docs/ValidateApi.md#validate) | **POST** /lastmile/validate | Data validation for planning.


## Documentation For Models

 - [ActualizeSettings](docs/ActualizeSettings.md)
 - [ActualizeTask](docs/ActualizeTask.md)
 - [AdvancedLocation](docs/AdvancedLocation.md)
 - [AnalyticsTask](docs/AnalyticsTask.md)
 - [AssignedShift](docs/AssignedShift.md)
 - [Attributes](docs/Attributes.md)
 - [Box](docs/Box.md)
 - [BoxRestrictions](docs/BoxRestrictions.md)
 - [CalculationDetail](docs/CalculationDetail.md)
 - [Capacity](docs/Capacity.md)
 - [CapacityFactor](docs/CapacityFactor.md)
 - [Cargo](docs/Cargo.md)
 - [CargoFeatures](docs/CargoFeatures.md)
 - [CargoPlacement](docs/CargoPlacement.md)
 - [CargoRestrictions](docs/CargoRestrictions.md)
 - [CheckResult](docs/CheckResult.md)
 - [ConvertSettings](docs/ConvertSettings.md)
 - [ConvertTask](docs/ConvertTask.md)
 - [DateWindow](docs/DateWindow.md)
 - [Demand](docs/Demand.md)
 - [DemandFact](docs/DemandFact.md)
 - [Facts](docs/Facts.md)
 - [Hardlink](docs/Hardlink.md)
 - [HardlinkElement](docs/HardlinkElement.md)
 - [InlineResponse400](docs/InlineResponse400.md)
 - [InlineResponse401](docs/InlineResponse401.md)
 - [InlineResponse403](docs/InlineResponse403.md)
 - [InlineResponse404](docs/InlineResponse404.md)
 - [InlineResponse406](docs/InlineResponse406.md)
 - [InlineResponse415](docs/InlineResponse415.md)
 - [InlineResponse429](docs/InlineResponse429.md)
 - [InlineResponse500](docs/InlineResponse500.md)
 - [InlineResponse501](docs/InlineResponse501.md)
 - [InlineResponse502](docs/InlineResponse502.md)
 - [InlineResponse503](docs/InlineResponse503.md)
 - [InlineResponse504](docs/InlineResponse504.md)
 - [InlineResponseDefault](docs/InlineResponseDefault.md)
 - [JobFact](docs/JobFact.md)
 - [JobType](docs/JobType.md)
 - [LoadWindow](docs/LoadWindow.md)
 - [Location](docs/Location.md)
 - [MatrixLine](docs/MatrixLine.md)
 - [Measurements](docs/Measurements.md)
 - [ObjectsMetrics](docs/ObjectsMetrics.md)
 - [Order](docs/Order.md)
 - [OrderFact](docs/OrderFact.md)
 - [OrderFeatures](docs/OrderFeatures.md)
 - [OrderPlanWindows](docs/OrderPlanWindows.md)
 - [OrderRestrictions](docs/OrderRestrictions.md)
 - [Performer](docs/Performer.md)
 - [PerformerBlacklist](docs/PerformerBlacklist.md)
 - [PerformerFact](docs/PerformerFact.md)
 - [PerformerFeatures](docs/PerformerFeatures.md)
 - [PerformerRestrictions](docs/PerformerRestrictions.md)
 - [PlanAssumptions](docs/PlanAssumptions.md)
 - [PlanId](docs/PlanId.md)
 - [PlanInfo](docs/PlanInfo.md)
 - [PlanResult](docs/PlanResult.md)
 - [PlanSettings](docs/PlanSettings.md)
 - [PlanStatistics](docs/PlanStatistics.md)
 - [PlanStatus](docs/PlanStatus.md)
 - [PlanTask](docs/PlanTask.md)
 - [PossibleEvent](docs/PossibleEvent.md)
 - [PredictResult](docs/PredictResult.md)
 - [PredictResultWindow](docs/PredictResultWindow.md)
 - [PredictTask](docs/PredictTask.md)
 - [QualityStatistics](docs/QualityStatistics.md)
 - [Rotation](docs/Rotation.md)
 - [RotationType](docs/RotationType.md)
 - [Routing](docs/Routing.md)
 - [RoutingMatrix](docs/RoutingMatrix.md)
 - [Shift](docs/Shift.md)
 - [Statistics](docs/Statistics.md)
 - [StopStatistics](docs/StopStatistics.md)
 - [TariffConstraint](docs/TariffConstraint.md)
 - [TimeWindow](docs/TimeWindow.md)
 - [TimeWindowViolation](docs/TimeWindowViolation.md)
 - [TraceData](docs/TraceData.md)
 - [TrackPoint](docs/TrackPoint.md)
 - [TrafficFactor](docs/TrafficFactor.md)
 - [Transport](docs/Transport.md)
 - [TransportFact](docs/TransportFact.md)
 - [TransportFactor](docs/TransportFactor.md)
 - [TransportFeatures](docs/TransportFeatures.md)
 - [TransportLoad](docs/TransportLoad.md)
 - [TransportRestrictions](docs/TransportRestrictions.md)
 - [TransportType](docs/TransportType.md)
 - [Trip](docs/Trip.md)
 - [TripAction](docs/TripAction.md)
 - [TripJob](docs/TripJob.md)
 - [TripStatistics](docs/TripStatistics.md)
 - [UniversalTariff](docs/UniversalTariff.md)
 - [UnplannedOrder](docs/UnplannedOrder.md)
 - [ValidateResult](docs/ValidateResult.md)
 - [Validation](docs/Validation.md)
 - [VersionResult](docs/VersionResult.md)
 - [Waypoint](docs/Waypoint.md)


## Documentation For Authorization


## ApiKeyAuth

- **Type**: Bearer authentication (JWT)


## Author

support@veeroute.com


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in vrt_lss_lastmile.apis and vrt_lss_lastmile.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from vrt_lss_lastmile.api.default_api import DefaultApi`
- `from vrt_lss_lastmile.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import vrt_lss_lastmile
from vrt_lss_lastmile.apis import *
from vrt_lss_lastmile.models import *
```

