"""
    Veeroute.LSS Lastmile

    Veeroute.LSS Lastmile API  # noqa: E501

    The version of the OpenAPI document: 3.7.167066
    Contact: support@veeroute.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from vrt_lss_lastmile.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from vrt_lss_lastmile.model.attributes import Attributes
    from vrt_lss_lastmile.model.possible_event import PossibleEvent
    globals()['Attributes'] = Attributes
    globals()['PossibleEvent'] = PossibleEvent


class Demand(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('demand_type',): {
            'PICKUP': "PICKUP",
            'DROP': "DROP",
            'WORK': "WORK",
        },
    }

    validations = {
        ('key',): {
            'max_length': 1024,
            'min_length': 1,
        },
        ('possible_events',): {
            'max_items': 500,
            'min_items': 1,
        },
        ('target_cargos',): {
            'max_items': 1000,
            'min_items': 0,
        },
        ('precedence_in_trip',): {
            'inclusive_maximum': 9000,
            'inclusive_minimum': 0,
        },
        ('precedence_in_order',): {
            'inclusive_maximum': 9000,
            'inclusive_minimum': 0,
        },
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'key': (str,),  # noqa: E501
            'demand_type': (str,),  # noqa: E501
            'possible_events': ([PossibleEvent],),  # noqa: E501
            'target_cargos': ([str],),  # noqa: E501
            'precedence_in_trip': (int,),  # noqa: E501
            'precedence_in_order': (int,),  # noqa: E501
            'attributes': (Attributes,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'key': 'key',  # noqa: E501
        'demand_type': 'demand_type',  # noqa: E501
        'possible_events': 'possible_events',  # noqa: E501
        'target_cargos': 'target_cargos',  # noqa: E501
        'precedence_in_trip': 'precedence_in_trip',  # noqa: E501
        'precedence_in_order': 'precedence_in_order',  # noqa: E501
        'attributes': 'attributes',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, key, demand_type, possible_events, *args, **kwargs):  # noqa: E501
        """Demand - a model defined in OpenAPI

        Args:
            key (str): Location key, unique ID.
            demand_type (str): The demand types are loading (`PICKUP`), unloading (`DROP`), work at the location (`WORK`).
            possible_events ([PossibleEvent]): List of possible time windows and location keys to fulfil an order.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            target_cargos ([str]): Cargo keys list for `PICKUP`, one cargo key for  `DROP`, empty key for `WORK`.. [optional]  # noqa: E501
            precedence_in_trip (int): Precedence within a trip, 0 - the precedence is not taken into account.. [optional] if omitted the server will use the default value of 0  # noqa: E501
            precedence_in_order (int): Precedence within an order, 0 - the precedence is not taken into account.. [optional] if omitted the server will use the default value of 0  # noqa: E501
            attributes (Attributes): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.key = key
        self.demand_type = demand_type
        self.possible_events = possible_events
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
