#include "main.hpp"
#include <unicode/uidna.h>

void init_uidna(py::module &m) {
  m.attr("UIDNA_DEFAULT") = int32_t{UIDNA_DEFAULT};
#ifndef U_HIDE_DEPRECATED_API
  m.attr("UIDNA_ALLOW_UNASSIGNED") = int32_t{UIDNA_ALLOW_UNASSIGNED};
#endif // U_HIDE_DEPRECATED_API
  m.attr("UIDNA_USE_STD3_RULES") = int32_t{UIDNA_USE_STD3_RULES};
  m.attr("UIDNA_CHECK_BIDI") = int32_t{UIDNA_CHECK_BIDI};
  m.attr("UIDNA_CHECK_CONTEXTJ") = int32_t{UIDNA_CHECK_CONTEXTJ};
  m.attr("UIDNA_NONTRANSITIONAL_TO_ASCII") = int32_t{UIDNA_NONTRANSITIONAL_TO_ASCII};
  m.attr("UIDNA_NONTRANSITIONAL_TO_UNICODE") = int32_t{UIDNA_NONTRANSITIONAL_TO_UNICODE};
#if (U_ICU_VERSION_MAJOR_NUM >= 49)
  m.attr("UIDNA_CHECK_CONTEXTO") = int32_t{UIDNA_CHECK_CONTEXTO};
#endif // (U_ICU_VERSION_MAJOR_NUM >= 49)

  m.attr("UIDNA_ERROR_EMPTY_LABEL") = int32_t{UIDNA_ERROR_EMPTY_LABEL};
  m.attr("UIDNA_ERROR_LABEL_TOO_LONG") = int32_t{UIDNA_ERROR_LABEL_TOO_LONG};
  m.attr("UIDNA_ERROR_DOMAIN_NAME_TOO_LONG") = int32_t{UIDNA_ERROR_DOMAIN_NAME_TOO_LONG};
  m.attr("UIDNA_ERROR_LEADING_HYPHEN") = int32_t{UIDNA_ERROR_LEADING_HYPHEN};
  m.attr("UIDNA_ERROR_TRAILING_HYPHEN") = int32_t{UIDNA_ERROR_TRAILING_HYPHEN};
  m.attr("UIDNA_ERROR_HYPHEN_3_4") = int32_t{UIDNA_ERROR_HYPHEN_3_4};
  m.attr("UIDNA_ERROR_LEADING_COMBINING_MARK") = int32_t{UIDNA_ERROR_LEADING_COMBINING_MARK};
  m.attr("UIDNA_ERROR_DISALLOWED") = int32_t{UIDNA_ERROR_DISALLOWED};
  m.attr("UIDNA_ERROR_PUNYCODE") = int32_t{UIDNA_ERROR_PUNYCODE};
  m.attr("UIDNA_ERROR_LABEL_HAS_DOT") = int32_t{UIDNA_ERROR_LABEL_HAS_DOT};
  m.attr("UIDNA_ERROR_INVALID_ACE_LABEL") = int32_t{UIDNA_ERROR_INVALID_ACE_LABEL};
  m.attr("UIDNA_ERROR_BIDI") = int32_t{UIDNA_ERROR_BIDI};
  m.attr("UIDNA_ERROR_CONTEXTJ") = int32_t{UIDNA_ERROR_CONTEXTJ};
  m.attr("UIDNA_ERROR_CONTEXTO_PUNCTUATION") = int32_t{UIDNA_ERROR_CONTEXTO_PUNCTUATION};
#if (U_ICU_VERSION_MAJOR_NUM >= 49)
  m.attr("UIDNA_ERROR_CONTEXTO_DIGITS") = int32_t{UIDNA_ERROR_CONTEXTO_DIGITS};
#endif // (U_ICU_VERSION_MAJOR_NUM >= 49)
}
