"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cfn = require("@aws-cdk/aws-cloudformation");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const cpactions = require("@aws-cdk/aws-codepipeline-actions");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
const cicd = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'CICD');
const pipeline = new codepipeline.Pipeline(stack, 'CodePipeline', {
    artifactBucket: new s3.Bucket(stack, 'ArtifactBucket', {
        removalPolicy: cdk.RemovalPolicy.DESTROY
    })
});
const sourceOutput = new codepipeline.Artifact('Artifact_CICDGitHubF8BA7ADD');
const source = new cpactions.GitHubSourceAction({
    actionName: 'GitHub',
    owner: 'awslabs',
    repo: 'aws-cdk',
    oauthToken: cdk.SecretValue.plainText('DummyToken'),
    trigger: cpactions.GitHubTrigger.POLL,
    output: sourceOutput,
});
pipeline.addStage({
    stageName: 'Source',
    actions: [source],
});
const stage = pipeline.addStage({ stageName: 'Deploy' });
stage.addAction(new cicd.PipelineDeployStackAction({
    stack,
    changeSetName: 'CICD-ChangeSet',
    createChangeSetRunOrder: 10,
    executeChangeSetRunOrder: 999,
    input: sourceOutput,
    adminPermissions: false,
    capabilities: [cfn.CloudFormationCapabilities.NONE],
}));
app.synth();
//# sourceMappingURL=data:application/json;base64,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