#
# Copyright © 2012–2022 Michal Čihař <michal@cihar.com>
#
# This file is part of Weblate <https://weblate.org/>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#

"""License data definitions.

This is an automatically generated file, see scripts/generate-license-data
"""

LICENSES = (
    ("Glide", "3dfx Glide License", "https://spdx.org/licenses/Glide.html", False),
    ("Abstyles", "Abstyles License", "https://spdx.org/licenses/Abstyles.html", False),
    (
        "AFL-1.1",
        "Academic Free License v1.1",
        "https://spdx.org/licenses/AFL-1.1.html",
        True,
    ),
    (
        "AFL-1.2",
        "Academic Free License v1.2",
        "https://spdx.org/licenses/AFL-1.2.html",
        True,
    ),
    (
        "AFL-2.0",
        "Academic Free License v2.0",
        "https://spdx.org/licenses/AFL-2.0.html",
        True,
    ),
    (
        "AFL-2.1",
        "Academic Free License v2.1",
        "https://spdx.org/licenses/AFL-2.1.html",
        True,
    ),
    (
        "AFL-3.0",
        "Academic Free License v3.0",
        "https://spdx.org/licenses/AFL-3.0.html",
        True,
    ),
    (
        "AMPAS",
        "Academy of Motion Picture Arts and Sciences BSD",
        "https://spdx.org/licenses/AMPAS.html",
        False,
    ),
    (
        "APL-1.0",
        "Adaptive Public License 1.0",
        "https://spdx.org/licenses/APL-1.0.html",
        True,
    ),
    (
        "Adobe-Glyph",
        "Adobe Glyph List License",
        "https://spdx.org/licenses/Adobe-Glyph.html",
        False,
    ),
    (
        "APAFML",
        "Adobe Postscript AFM License",
        "https://spdx.org/licenses/APAFML.html",
        False,
    ),
    (
        "Adobe-2006",
        "Adobe Systems Incorporated Source Code License Agreement",
        "https://spdx.org/licenses/Adobe-2006.html",
        False,
    ),
    (
        "AGPL-1.0-only",
        "Affero General Public License v1.0 only",
        "https://spdx.org/licenses/AGPL-1.0-only.html",
        False,
    ),
    (
        "AGPL-1.0-or-later",
        "Affero General Public License v1.0 or later",
        "https://spdx.org/licenses/AGPL-1.0-or-later.html",
        False,
    ),
    ("Afmparse", "Afmparse License", "https://spdx.org/licenses/Afmparse.html", False),
    (
        "Aladdin",
        "Aladdin Free Public License",
        "https://spdx.org/licenses/Aladdin.html",
        False,
    ),
    (
        "ADSL",
        "Amazon Digital Services License",
        "https://spdx.org/licenses/ADSL.html",
        False,
    ),
    (
        "AMDPLPA",
        "AMD's plpa_map.c License",
        "https://spdx.org/licenses/AMDPLPA.html",
        False,
    ),
    (
        "ANTLR-PD",
        "ANTLR Software Rights Notice",
        "https://spdx.org/licenses/ANTLR-PD.html",
        False,
    ),
    (
        "ANTLR-PD-fallback",
        "ANTLR Software Rights Notice with license fallback",
        "https://spdx.org/licenses/ANTLR-PD-fallback.html",
        False,
    ),
    (
        "Apache-1.0",
        "Apache License 1.0",
        "https://spdx.org/licenses/Apache-1.0.html",
        True,
    ),
    (
        "Apache-1.1",
        "Apache License 1.1",
        "https://spdx.org/licenses/Apache-1.1.html",
        True,
    ),
    (
        "Apache-2.0",
        "Apache License 2.0",
        "https://spdx.org/licenses/Apache-2.0.html",
        True,
    ),
    ("App-s2p", "App::s2p License", "https://spdx.org/licenses/App-s2p.html", False),
    ("AML", "Apple MIT License", "https://spdx.org/licenses/AML.html", False),
    (
        "APSL-1.0",
        "Apple Public Source License 1.0",
        "https://spdx.org/licenses/APSL-1.0.html",
        True,
    ),
    (
        "APSL-1.1",
        "Apple Public Source License 1.1",
        "https://spdx.org/licenses/APSL-1.1.html",
        True,
    ),
    (
        "APSL-1.2",
        "Apple Public Source License 1.2",
        "https://spdx.org/licenses/APSL-1.2.html",
        True,
    ),
    (
        "APSL-2.0",
        "Apple Public Source License 2.0",
        "https://spdx.org/licenses/APSL-2.0.html",
        True,
    ),
    (
        "Arphic-1999",
        "Arphic Public License",
        "https://spdx.org/licenses/Arphic-1999.html",
        False,
    ),
    (
        "Artistic-1.0",
        "Artistic License 1.0",
        "https://spdx.org/licenses/Artistic-1.0.html",
        True,
    ),
    (
        "Artistic-1.0-Perl",
        "Artistic License 1.0 (Perl)",
        "https://spdx.org/licenses/Artistic-1.0-Perl.html",
        True,
    ),
    (
        "Artistic-1.0-cl8",
        "Artistic License 1.0 w/clause 8",
        "https://spdx.org/licenses/Artistic-1.0-cl8.html",
        True,
    ),
    (
        "Artistic-2.0",
        "Artistic License 2.0",
        "https://spdx.org/licenses/Artistic-2.0.html",
        True,
    ),
    (
        "AAL",
        "Attribution Assurance License",
        "https://spdx.org/licenses/AAL.html",
        True,
    ),
    ("Baekmuk", "Baekmuk License", "https://spdx.org/licenses/Baekmuk.html", False),
    ("Bahyph", "Bahyph License", "https://spdx.org/licenses/Bahyph.html", False),
    ("Barr", "Barr License", "https://spdx.org/licenses/Barr.html", False),
    ("Beerware", "Beerware License", "https://spdx.org/licenses/Beerware.html", True),
    (
        "BitTorrent-1.0",
        "BitTorrent Open Source License v1.0",
        "https://spdx.org/licenses/BitTorrent-1.0.html",
        False,
    ),
    (
        "BitTorrent-1.1",
        "BitTorrent Open Source License v1.1",
        "https://spdx.org/licenses/BitTorrent-1.1.html",
        True,
    ),
    (
        "BlueOak-1.0.0",
        "Blue Oak Model License 1.0.0",
        "https://spdx.org/licenses/BlueOak-1.0.0.html",
        False,
    ),
    (
        "BSL-1.0",
        "Boost Software License 1.0",
        "https://spdx.org/licenses/BSL-1.0.html",
        True,
    ),
    ("Borceux", "Borceux license", "https://spdx.org/licenses/Borceux.html", False),
    (
        "BSD-1-Clause",
        "BSD 1-Clause License",
        "https://spdx.org/licenses/BSD-1-Clause.html",
        True,
    ),
    (
        "BSD-2-Clause",
        'BSD 2-Clause "Simplified" License',
        "https://spdx.org/licenses/BSD-2-Clause.html",
        True,
    ),
    (
        "BSD-2-Clause-Views",
        "BSD 2-Clause with views sentence",
        "https://spdx.org/licenses/BSD-2-Clause-Views.html",
        False,
    ),
    (
        "BSD-3-Clause",
        'BSD 3-Clause "New" or "Revised" License',
        "https://spdx.org/licenses/BSD-3-Clause.html",
        True,
    ),
    (
        "BSD-3-Clause-Clear",
        "BSD 3-Clause Clear License",
        "https://spdx.org/licenses/BSD-3-Clause-Clear.html",
        True,
    ),
    (
        "BSD-3-Clause-Modification",
        "BSD 3-Clause Modification",
        "https://spdx.org/licenses/BSD-3-Clause-Modification.html",
        False,
    ),
    (
        "BSD-3-Clause-No-Military-License",
        "BSD 3-Clause No Military License",
        "https://spdx.org/licenses/BSD-3-Clause-No-Military-License.html",
        False,
    ),
    (
        "BSD-3-Clause-No-Nuclear-License",
        "BSD 3-Clause No Nuclear License",
        "https://spdx.org/licenses/BSD-3-Clause-No-Nuclear-License.html",
        False,
    ),
    (
        "BSD-3-Clause-No-Nuclear-License-2014",
        "BSD 3-Clause No Nuclear License 2014",
        "https://spdx.org/licenses/BSD-3-Clause-No-Nuclear-License-2014.html",
        False,
    ),
    (
        "BSD-3-Clause-No-Nuclear-Warranty",
        "BSD 3-Clause No Nuclear Warranty",
        "https://spdx.org/licenses/BSD-3-Clause-No-Nuclear-Warranty.html",
        False,
    ),
    (
        "BSD-3-Clause-Open-MPI",
        "BSD 3-Clause Open MPI variant",
        "https://spdx.org/licenses/BSD-3-Clause-Open-MPI.html",
        False,
    ),
    (
        "BSD-4-Clause-Shortened",
        "BSD 4 Clause Shortened",
        "https://spdx.org/licenses/BSD-4-Clause-Shortened.html",
        False,
    ),
    (
        "BSD-4-Clause",
        'BSD 4-Clause "Original" or "Old" License',
        "https://spdx.org/licenses/BSD-4-Clause.html",
        True,
    ),
    (
        "BSD-Protection",
        "BSD Protection License",
        "https://spdx.org/licenses/BSD-Protection.html",
        False,
    ),
    (
        "BSD-Source-Code",
        "BSD Source Code Attribution",
        "https://spdx.org/licenses/BSD-Source-Code.html",
        False,
    ),
    (
        "BSD-3-Clause-Attribution",
        "BSD with attribution",
        "https://spdx.org/licenses/BSD-3-Clause-Attribution.html",
        False,
    ),
    ("0BSD", "BSD Zero Clause License", "https://spdx.org/licenses/0BSD.html", True),
    (
        "BSD-2-Clause-Patent",
        "BSD-2-Clause Plus Patent License",
        "https://spdx.org/licenses/BSD-2-Clause-Patent.html",
        True,
    ),
    (
        "BSD-4-Clause-UC",
        "BSD-4-Clause (University of California-Specific)",
        "https://spdx.org/licenses/BSD-4-Clause-UC.html",
        False,
    ),
    (
        "BUSL-1.1",
        "Business Source License 1.1",
        "https://spdx.org/licenses/BUSL-1.1.html",
        False,
    ),
    (
        "bzip2-1.0.6",
        "bzip2 and libbzip2 License v1.0.6",
        "https://spdx.org/licenses/bzip2-1.0.6.html",
        False,
    ),
    ("Caldera", "Caldera License", "https://spdx.org/licenses/Caldera.html", False),
    (
        "CECILL-1.0",
        "CeCILL Free Software License Agreement v1.0",
        "https://spdx.org/licenses/CECILL-1.0.html",
        False,
    ),
    (
        "CECILL-1.1",
        "CeCILL Free Software License Agreement v1.1",
        "https://spdx.org/licenses/CECILL-1.1.html",
        False,
    ),
    (
        "CECILL-2.0",
        "CeCILL Free Software License Agreement v2.0",
        "https://spdx.org/licenses/CECILL-2.0.html",
        True,
    ),
    (
        "CECILL-2.1",
        "CeCILL Free Software License Agreement v2.1",
        "https://spdx.org/licenses/CECILL-2.1.html",
        True,
    ),
    (
        "CECILL-B",
        "CeCILL-B Free Software License Agreement",
        "https://spdx.org/licenses/CECILL-B.html",
        True,
    ),
    (
        "CECILL-C",
        "CeCILL-C Free Software License Agreement",
        "https://spdx.org/licenses/CECILL-C.html",
        True,
    ),
    (
        "CERN-OHL-1.1",
        "CERN Open Hardware Licence v1.1",
        "https://spdx.org/licenses/CERN-OHL-1.1.html",
        False,
    ),
    (
        "CERN-OHL-1.2",
        "CERN Open Hardware Licence v1.2",
        "https://spdx.org/licenses/CERN-OHL-1.2.html",
        False,
    ),
    (
        "CERN-OHL-P-2.0",
        "CERN Open Hardware Licence Version 2 - Permissive",
        "https://spdx.org/licenses/CERN-OHL-P-2.0.html",
        True,
    ),
    (
        "CERN-OHL-S-2.0",
        "CERN Open Hardware Licence Version 2 - Strongly Reciprocal",
        "https://spdx.org/licenses/CERN-OHL-S-2.0.html",
        True,
    ),
    (
        "CERN-OHL-W-2.0",
        "CERN Open Hardware Licence Version 2 - Weakly Reciprocal",
        "https://spdx.org/licenses/CERN-OHL-W-2.0.html",
        True,
    ),
    (
        "ClArtistic",
        "Clarified Artistic License",
        "https://spdx.org/licenses/ClArtistic.html",
        True,
    ),
    ("MIT-CMU", "CMU License", "https://spdx.org/licenses/MIT-CMU.html", False),
    (
        "CNRI-Jython",
        "CNRI Jython License",
        "https://spdx.org/licenses/CNRI-Jython.html",
        False,
    ),
    (
        "CNRI-Python",
        "CNRI Python License",
        "https://spdx.org/licenses/CNRI-Python.html",
        True,
    ),
    (
        "CNRI-Python-GPL-Compatible",
        "CNRI Python Open Source GPL Compatible License Agreement",
        "https://spdx.org/licenses/CNRI-Python-GPL-Compatible.html",
        False,
    ),
    (
        "CPOL-1.02",
        "Code Project Open License 1.02",
        "https://spdx.org/licenses/CPOL-1.02.html",
        False,
    ),
    (
        "CDDL-1.0",
        "Common Development and Distribution License 1.0",
        "https://spdx.org/licenses/CDDL-1.0.html",
        True,
    ),
    (
        "CDDL-1.1",
        "Common Development and Distribution License 1.1",
        "https://spdx.org/licenses/CDDL-1.1.html",
        False,
    ),
    (
        "CDL-1.0",
        "Common Documentation License 1.0",
        "https://spdx.org/licenses/CDL-1.0.html",
        False,
    ),
    (
        "CPAL-1.0",
        "Common Public Attribution License 1.0",
        "https://spdx.org/licenses/CPAL-1.0.html",
        True,
    ),
    (
        "CPL-1.0",
        "Common Public License 1.0",
        "https://spdx.org/licenses/CPL-1.0.html",
        True,
    ),
    (
        "CDLA-Permissive-1.0",
        "Community Data License Agreement Permissive 1.0",
        "https://spdx.org/licenses/CDLA-Permissive-1.0.html",
        False,
    ),
    (
        "CDLA-Permissive-2.0",
        "Community Data License Agreement Permissive 2.0",
        "https://spdx.org/licenses/CDLA-Permissive-2.0.html",
        False,
    ),
    (
        "CDLA-Sharing-1.0",
        "Community Data License Agreement Sharing 1.0",
        "https://spdx.org/licenses/CDLA-Sharing-1.0.html",
        False,
    ),
    (
        "Community-Spec-1.0",
        "Community Specification License 1.0",
        "https://spdx.org/licenses/Community-Spec-1.0.html",
        False,
    ),
    (
        "C-UDA-1.0",
        "Computational Use of Data Agreement v1.0",
        "https://spdx.org/licenses/C-UDA-1.0.html",
        False,
    ),
    (
        "CATOSL-1.1",
        "Computer Associates Trusted Open Source License 1.1",
        "https://spdx.org/licenses/CATOSL-1.1.html",
        True,
    ),
    (
        "Condor-1.1",
        "Condor Public License v1.1",
        "https://spdx.org/licenses/Condor-1.1.html",
        True,
    ),
    (
        "COIL-1.0",
        "Copyfree Open Innovation License",
        "https://spdx.org/licenses/COIL-1.0.html",
        False,
    ),
    (
        "copyleft-next-0.3.0",
        "copyleft-next 0.3.0",
        "https://spdx.org/licenses/copyleft-next-0.3.0.html",
        False,
    ),
    (
        "copyleft-next-0.3.1",
        "copyleft-next 0.3.1",
        "https://spdx.org/licenses/copyleft-next-0.3.1.html",
        False,
    ),
    (
        "CC-BY-1.0",
        "Creative Commons Attribution 1.0 Generic",
        "https://spdx.org/licenses/CC-BY-1.0.html",
        False,
    ),
    (
        "CC-BY-2.0",
        "Creative Commons Attribution 2.0 Generic",
        "https://spdx.org/licenses/CC-BY-2.0.html",
        False,
    ),
    (
        "CC-BY-2.5-AU",
        "Creative Commons Attribution 2.5 Australia",
        "https://spdx.org/licenses/CC-BY-2.5-AU.html",
        False,
    ),
    (
        "CC-BY-2.5",
        "Creative Commons Attribution 2.5 Generic",
        "https://spdx.org/licenses/CC-BY-2.5.html",
        False,
    ),
    (
        "CC-BY-3.0-AT",
        "Creative Commons Attribution 3.0 Austria",
        "https://spdx.org/licenses/CC-BY-3.0-AT.html",
        False,
    ),
    (
        "CC-BY-3.0-DE",
        "Creative Commons Attribution 3.0 Germany",
        "https://spdx.org/licenses/CC-BY-3.0-DE.html",
        False,
    ),
    (
        "CC-BY-3.0-NL",
        "Creative Commons Attribution 3.0 Netherlands",
        "https://spdx.org/licenses/CC-BY-3.0-NL.html",
        False,
    ),
    (
        "CC-BY-3.0-US",
        "Creative Commons Attribution 3.0 United States",
        "https://spdx.org/licenses/CC-BY-3.0-US.html",
        False,
    ),
    (
        "CC-BY-3.0",
        "Creative Commons Attribution 3.0 Unported",
        "https://spdx.org/licenses/CC-BY-3.0.html",
        True,
    ),
    (
        "CC-BY-4.0",
        "Creative Commons Attribution 4.0 International",
        "https://spdx.org/licenses/CC-BY-4.0.html",
        True,
    ),
    (
        "CC-BY-ND-1.0",
        "Creative Commons Attribution No Derivatives 1.0 Generic",
        "https://spdx.org/licenses/CC-BY-ND-1.0.html",
        False,
    ),
    (
        "CC-BY-ND-2.0",
        "Creative Commons Attribution No Derivatives 2.0 Generic",
        "https://spdx.org/licenses/CC-BY-ND-2.0.html",
        False,
    ),
    (
        "CC-BY-ND-2.5",
        "Creative Commons Attribution No Derivatives 2.5 Generic",
        "https://spdx.org/licenses/CC-BY-ND-2.5.html",
        False,
    ),
    (
        "CC-BY-ND-3.0-DE",
        "Creative Commons Attribution No Derivatives 3.0 Germany",
        "https://spdx.org/licenses/CC-BY-ND-3.0-DE.html",
        False,
    ),
    (
        "CC-BY-ND-3.0",
        "Creative Commons Attribution No Derivatives 3.0 Unported",
        "https://spdx.org/licenses/CC-BY-ND-3.0.html",
        False,
    ),
    (
        "CC-BY-ND-4.0",
        "Creative Commons Attribution No Derivatives 4.0 International",
        "https://spdx.org/licenses/CC-BY-ND-4.0.html",
        False,
    ),
    (
        "CC-BY-NC-1.0",
        "Creative Commons Attribution Non Commercial 1.0 Generic",
        "https://spdx.org/licenses/CC-BY-NC-1.0.html",
        False,
    ),
    (
        "CC-BY-NC-2.0",
        "Creative Commons Attribution Non Commercial 2.0 Generic",
        "https://spdx.org/licenses/CC-BY-NC-2.0.html",
        False,
    ),
    (
        "CC-BY-NC-2.5",
        "Creative Commons Attribution Non Commercial 2.5 Generic",
        "https://spdx.org/licenses/CC-BY-NC-2.5.html",
        False,
    ),
    (
        "CC-BY-NC-3.0-DE",
        "Creative Commons Attribution Non Commercial 3.0 Germany",
        "https://spdx.org/licenses/CC-BY-NC-3.0-DE.html",
        False,
    ),
    (
        "CC-BY-NC-3.0",
        "Creative Commons Attribution Non Commercial 3.0 Unported",
        "https://spdx.org/licenses/CC-BY-NC-3.0.html",
        False,
    ),
    (
        "CC-BY-NC-4.0",
        "Creative Commons Attribution Non Commercial 4.0 International",
        "https://spdx.org/licenses/CC-BY-NC-4.0.html",
        False,
    ),
    (
        "CC-BY-NC-ND-1.0",
        "Creative Commons Attribution Non Commercial No Derivatives 1.0 Generic",
        "https://spdx.org/licenses/CC-BY-NC-ND-1.0.html",
        False,
    ),
    (
        "CC-BY-NC-ND-2.0",
        "Creative Commons Attribution Non Commercial No Derivatives 2.0 Generic",
        "https://spdx.org/licenses/CC-BY-NC-ND-2.0.html",
        False,
    ),
    (
        "CC-BY-NC-ND-2.5",
        "Creative Commons Attribution Non Commercial No Derivatives 2.5 Generic",
        "https://spdx.org/licenses/CC-BY-NC-ND-2.5.html",
        False,
    ),
    (
        "CC-BY-NC-ND-3.0-DE",
        "Creative Commons Attribution Non Commercial No Derivatives 3.0 Germany",
        "https://spdx.org/licenses/CC-BY-NC-ND-3.0-DE.html",
        False,
    ),
    (
        "CC-BY-NC-ND-3.0-IGO",
        "Creative Commons Attribution Non Commercial No Derivatives 3.0 IGO",
        "https://spdx.org/licenses/CC-BY-NC-ND-3.0-IGO.html",
        False,
    ),
    (
        "CC-BY-NC-ND-3.0",
        "Creative Commons Attribution Non Commercial No Derivatives 3.0 Unported",
        "https://spdx.org/licenses/CC-BY-NC-ND-3.0.html",
        False,
    ),
    (
        "CC-BY-NC-ND-4.0",
        "Creative Commons Attribution Non Commercial No Derivatives 4.0 International",
        "https://spdx.org/licenses/CC-BY-NC-ND-4.0.html",
        False,
    ),
    (
        "CC-BY-NC-SA-1.0",
        "Creative Commons Attribution Non Commercial Share Alike 1.0 Generic",
        "https://spdx.org/licenses/CC-BY-NC-SA-1.0.html",
        False,
    ),
    (
        "CC-BY-NC-SA-2.0-UK",
        "Creative Commons Attribution Non Commercial Share Alike 2.0 England and Wales",
        "https://spdx.org/licenses/CC-BY-NC-SA-2.0-UK.html",
        False,
    ),
    (
        "CC-BY-NC-SA-2.0",
        "Creative Commons Attribution Non Commercial Share Alike 2.0 Generic",
        "https://spdx.org/licenses/CC-BY-NC-SA-2.0.html",
        False,
    ),
    (
        "CC-BY-NC-SA-2.5",
        "Creative Commons Attribution Non Commercial Share Alike 2.5 Generic",
        "https://spdx.org/licenses/CC-BY-NC-SA-2.5.html",
        False,
    ),
    (
        "CC-BY-NC-SA-3.0-DE",
        "Creative Commons Attribution Non Commercial Share Alike 3.0 Germany",
        "https://spdx.org/licenses/CC-BY-NC-SA-3.0-DE.html",
        False,
    ),
    (
        "CC-BY-NC-SA-3.0-IGO",
        "Creative Commons Attribution Non Commercial Share Alike 3.0 IGO",
        "https://spdx.org/licenses/CC-BY-NC-SA-3.0-IGO.html",
        False,
    ),
    (
        "CC-BY-NC-SA-3.0",
        "Creative Commons Attribution Non Commercial Share Alike 3.0 Unported",
        "https://spdx.org/licenses/CC-BY-NC-SA-3.0.html",
        False,
    ),
    (
        "CC-BY-NC-SA-4.0",
        "Creative Commons Attribution Non Commercial Share Alike 4.0 International",
        "https://spdx.org/licenses/CC-BY-NC-SA-4.0.html",
        False,
    ),
    (
        "CC-BY-SA-1.0",
        "Creative Commons Attribution Share Alike 1.0 Generic",
        "https://spdx.org/licenses/CC-BY-SA-1.0.html",
        False,
    ),
    (
        "CC-BY-SA-2.0-UK",
        "Creative Commons Attribution Share Alike 2.0 England and Wales",
        "https://spdx.org/licenses/CC-BY-SA-2.0-UK.html",
        False,
    ),
    (
        "CC-BY-SA-2.0",
        "Creative Commons Attribution Share Alike 2.0 Generic",
        "https://spdx.org/licenses/CC-BY-SA-2.0.html",
        False,
    ),
    (
        "CC-BY-SA-2.1-JP",
        "Creative Commons Attribution Share Alike 2.1 Japan",
        "https://spdx.org/licenses/CC-BY-SA-2.1-JP.html",
        False,
    ),
    (
        "CC-BY-SA-2.5",
        "Creative Commons Attribution Share Alike 2.5 Generic",
        "https://spdx.org/licenses/CC-BY-SA-2.5.html",
        False,
    ),
    (
        "CC-BY-SA-3.0-AT",
        "Creative Commons Attribution Share Alike 3.0 Austria",
        "https://spdx.org/licenses/CC-BY-SA-3.0-AT.html",
        False,
    ),
    (
        "CC-BY-SA-3.0-DE",
        "Creative Commons Attribution Share Alike 3.0 Germany",
        "https://spdx.org/licenses/CC-BY-SA-3.0-DE.html",
        False,
    ),
    (
        "CC-BY-SA-3.0",
        "Creative Commons Attribution Share Alike 3.0 Unported",
        "https://spdx.org/licenses/CC-BY-SA-3.0.html",
        True,
    ),
    (
        "CC-BY-SA-4.0",
        "Creative Commons Attribution Share Alike 4.0 International",
        "https://spdx.org/licenses/CC-BY-SA-4.0.html",
        True,
    ),
    (
        "CC-BY-NC-SA-2.0-FR",
        "Creative Commons Attribution-NonCommercial-ShareAlike 2.0 France",
        "https://spdx.org/licenses/CC-BY-NC-SA-2.0-FR.html",
        False,
    ),
    (
        "CC-PDDC",
        "Creative Commons Public Domain Dedication and Certification",
        "https://spdx.org/licenses/CC-PDDC.html",
        False,
    ),
    (
        "CC0-1.0",
        "Creative Commons Zero v1.0 Universal",
        "https://spdx.org/licenses/CC0-1.0.html",
        True,
    ),
    (
        "Crossword",
        "Crossword License",
        "https://spdx.org/licenses/Crossword.html",
        False,
    ),
    (
        "CAL-1.0",
        "Cryptographic Autonomy License 1.0",
        "https://spdx.org/licenses/CAL-1.0.html",
        True,
    ),
    (
        "CAL-1.0-Combined-Work-Exception",
        "Cryptographic Autonomy License 1.0 (Combined Work Exception)",
        "https://spdx.org/licenses/CAL-1.0-Combined-Work-Exception.html",
        True,
    ),
    (
        "CrystalStacker",
        "CrystalStacker License",
        "https://spdx.org/licenses/CrystalStacker.html",
        False,
    ),
    (
        "CUA-OPL-1.0",
        "CUA Office Public License v1.0",
        "https://spdx.org/licenses/CUA-OPL-1.0.html",
        True,
    ),
    ("Cube", "Cube License", "https://spdx.org/licenses/Cube.html", False),
    ("curl", "curl License", "https://spdx.org/licenses/curl.html", False),
    (
        "DL-DE-BY-2.0",
        "Data licence Germany – attribution – version 2.0",
        "https://spdx.org/licenses/DL-DE-BY-2.0.html",
        False,
    ),
    (
        "DRL-1.0",
        "Detection Rule License 1.0",
        "https://spdx.org/licenses/DRL-1.0.html",
        False,
    ),
    (
        "D-FSL-1.0",
        "Deutsche Freie Software Lizenz",
        "https://spdx.org/licenses/D-FSL-1.0.html",
        False,
    ),
    ("diffmark", "diffmark license", "https://spdx.org/licenses/diffmark.html", False),
    (
        "WTFPL",
        "Do What The F*ck You Want To Public License",
        "https://spdx.org/licenses/WTFPL.html",
        True,
    ),
    ("DOC", "DOC License", "https://spdx.org/licenses/DOC.html", False),
    ("Dotseqn", "Dotseqn License", "https://spdx.org/licenses/Dotseqn.html", False),
    ("DSDP", "DSDP License", "https://spdx.org/licenses/DSDP.html", False),
    ("dvipdfm", "dvipdfm License", "https://spdx.org/licenses/dvipdfm.html", False),
    (
        "EPL-1.0",
        "Eclipse Public License 1.0",
        "https://spdx.org/licenses/EPL-1.0.html",
        True,
    ),
    (
        "EPL-2.0",
        "Eclipse Public License 2.0",
        "https://spdx.org/licenses/EPL-2.0.html",
        True,
    ),
    (
        "ECL-1.0",
        "Educational Community License v1.0",
        "https://spdx.org/licenses/ECL-1.0.html",
        True,
    ),
    (
        "ECL-2.0",
        "Educational Community License v2.0",
        "https://spdx.org/licenses/ECL-2.0.html",
        True,
    ),
    (
        "eGenix",
        "eGenix.com Public License 1.1.0",
        "https://spdx.org/licenses/eGenix.html",
        False,
    ),
    (
        "EFL-1.0",
        "Eiffel Forum License v1.0",
        "https://spdx.org/licenses/EFL-1.0.html",
        True,
    ),
    (
        "EFL-2.0",
        "Eiffel Forum License v2.0",
        "https://spdx.org/licenses/EFL-2.0.html",
        True,
    ),
    (
        "Elastic-2.0",
        "Elastic License 2.0",
        "https://spdx.org/licenses/Elastic-2.0.html",
        False,
    ),
    (
        "MIT-advertising",
        "Enlightenment License (e16)",
        "https://spdx.org/licenses/MIT-advertising.html",
        False,
    ),
    ("MIT-enna", "enna License", "https://spdx.org/licenses/MIT-enna.html", False),
    (
        "Entessa",
        "Entessa Public License v1.0",
        "https://spdx.org/licenses/Entessa.html",
        True,
    ),
    ("EPICS", "EPICS Open License", "https://spdx.org/licenses/EPICS.html", False),
    (
        "ErlPL-1.1",
        "Erlang Public License v1.1",
        "https://spdx.org/licenses/ErlPL-1.1.html",
        False,
    ),
    (
        "etalab-2.0",
        "Etalab Open License 2.0",
        "https://spdx.org/licenses/etalab-2.0.html",
        False,
    ),
    (
        "EUDatagrid",
        "EU DataGrid Software License",
        "https://spdx.org/licenses/EUDatagrid.html",
        True,
    ),
    (
        "EUPL-1.0",
        "European Union Public License 1.0",
        "https://spdx.org/licenses/EUPL-1.0.html",
        False,
    ),
    (
        "EUPL-1.1",
        "European Union Public License 1.1",
        "https://spdx.org/licenses/EUPL-1.1.html",
        True,
    ),
    (
        "EUPL-1.2",
        "European Union Public License 1.2",
        "https://spdx.org/licenses/EUPL-1.2.html",
        True,
    ),
    ("Eurosym", "Eurosym License", "https://spdx.org/licenses/Eurosym.html", False),
    ("Fair", "Fair License", "https://spdx.org/licenses/Fair.html", True),
    ("MIT-feh", "feh License", "https://spdx.org/licenses/MIT-feh.html", False),
    (
        "Frameworx-1.0",
        "Frameworx Open License 1.0",
        "https://spdx.org/licenses/Frameworx-1.0.html",
        True,
    ),
    (
        "FDK-AAC",
        "Fraunhofer FDK AAC Codec Library",
        "https://spdx.org/licenses/FDK-AAC.html",
        False,
    ),
    (
        "FreeBSD-DOC",
        "FreeBSD Documentation License",
        "https://spdx.org/licenses/FreeBSD-DOC.html",
        False,
    ),
    (
        "FreeImage",
        "FreeImage Public License v1.0",
        "https://spdx.org/licenses/FreeImage.html",
        False,
    ),
    ("FTL", "Freetype Project License", "https://spdx.org/licenses/FTL.html", True),
    (
        "FSFAP",
        "FSF All Permissive License",
        "https://spdx.org/licenses/FSFAP.html",
        True,
    ),
    ("FSFUL", "FSF Unlimited License", "https://spdx.org/licenses/FSFUL.html", False),
    (
        "FSFULLR",
        "FSF Unlimited License (with License Retention)",
        "https://spdx.org/licenses/FSFULLR.html",
        False,
    ),
    ("GD", "GD License", "https://spdx.org/licenses/GD.html", False),
    ("Giftware", "Giftware License", "https://spdx.org/licenses/Giftware.html", False),
    ("GL2PS", "GL2PS License", "https://spdx.org/licenses/GL2PS.html", False),
    ("Glulxe", "Glulxe License", "https://spdx.org/licenses/Glulxe.html", False),
    (
        "AGPL-3.0-only",
        "GNU Affero General Public License v3.0 only",
        "https://spdx.org/licenses/AGPL-3.0-only.html",
        True,
    ),
    (
        "AGPL-3.0-or-later",
        "GNU Affero General Public License v3.0 or later",
        "https://spdx.org/licenses/AGPL-3.0-or-later.html",
        True,
    ),
    (
        "GFDL-1.1-only",
        "GNU Free Documentation License v1.1 only",
        "https://spdx.org/licenses/GFDL-1.1-only.html",
        True,
    ),
    (
        "GFDL-1.1-invariants-only",
        "GNU Free Documentation License v1.1 only - invariants",
        "https://spdx.org/licenses/GFDL-1.1-invariants-only.html",
        False,
    ),
    (
        "GFDL-1.1-no-invariants-only",
        "GNU Free Documentation License v1.1 only - no invariants",
        "https://spdx.org/licenses/GFDL-1.1-no-invariants-only.html",
        False,
    ),
    (
        "GFDL-1.1-or-later",
        "GNU Free Documentation License v1.1 or later",
        "https://spdx.org/licenses/GFDL-1.1-or-later.html",
        True,
    ),
    (
        "GFDL-1.1-invariants-or-later",
        "GNU Free Documentation License v1.1 or later - invariants",
        "https://spdx.org/licenses/GFDL-1.1-invariants-or-later.html",
        False,
    ),
    (
        "GFDL-1.1-no-invariants-or-later",
        "GNU Free Documentation License v1.1 or later - no invariants",
        "https://spdx.org/licenses/GFDL-1.1-no-invariants-or-later.html",
        False,
    ),
    (
        "GFDL-1.2-only",
        "GNU Free Documentation License v1.2 only",
        "https://spdx.org/licenses/GFDL-1.2-only.html",
        True,
    ),
    (
        "GFDL-1.2-invariants-only",
        "GNU Free Documentation License v1.2 only - invariants",
        "https://spdx.org/licenses/GFDL-1.2-invariants-only.html",
        False,
    ),
    (
        "GFDL-1.2-no-invariants-only",
        "GNU Free Documentation License v1.2 only - no invariants",
        "https://spdx.org/licenses/GFDL-1.2-no-invariants-only.html",
        False,
    ),
    (
        "GFDL-1.2-or-later",
        "GNU Free Documentation License v1.2 or later",
        "https://spdx.org/licenses/GFDL-1.2-or-later.html",
        True,
    ),
    (
        "GFDL-1.2-invariants-or-later",
        "GNU Free Documentation License v1.2 or later - invariants",
        "https://spdx.org/licenses/GFDL-1.2-invariants-or-later.html",
        False,
    ),
    (
        "GFDL-1.2-no-invariants-or-later",
        "GNU Free Documentation License v1.2 or later - no invariants",
        "https://spdx.org/licenses/GFDL-1.2-no-invariants-or-later.html",
        False,
    ),
    (
        "GFDL-1.3-only",
        "GNU Free Documentation License v1.3 only",
        "https://spdx.org/licenses/GFDL-1.3-only.html",
        True,
    ),
    (
        "GFDL-1.3-invariants-only",
        "GNU Free Documentation License v1.3 only - invariants",
        "https://spdx.org/licenses/GFDL-1.3-invariants-only.html",
        False,
    ),
    (
        "GFDL-1.3-no-invariants-only",
        "GNU Free Documentation License v1.3 only - no invariants",
        "https://spdx.org/licenses/GFDL-1.3-no-invariants-only.html",
        False,
    ),
    (
        "GFDL-1.3-or-later",
        "GNU Free Documentation License v1.3 or later",
        "https://spdx.org/licenses/GFDL-1.3-or-later.html",
        True,
    ),
    (
        "GFDL-1.3-invariants-or-later",
        "GNU Free Documentation License v1.3 or later - invariants",
        "https://spdx.org/licenses/GFDL-1.3-invariants-or-later.html",
        False,
    ),
    (
        "GFDL-1.3-no-invariants-or-later",
        "GNU Free Documentation License v1.3 or later - no invariants",
        "https://spdx.org/licenses/GFDL-1.3-no-invariants-or-later.html",
        False,
    ),
    (
        "GPL-1.0-only",
        "GNU General Public License v1.0 only",
        "https://spdx.org/licenses/GPL-1.0-only.html",
        False,
    ),
    (
        "GPL-1.0-or-later",
        "GNU General Public License v1.0 or later",
        "https://spdx.org/licenses/GPL-1.0-or-later.html",
        False,
    ),
    (
        "GPL-2.0-only",
        "GNU General Public License v2.0 only",
        "https://spdx.org/licenses/GPL-2.0-only.html",
        True,
    ),
    (
        "GPL-2.0-or-later",
        "GNU General Public License v2.0 or later",
        "https://spdx.org/licenses/GPL-2.0-or-later.html",
        True,
    ),
    (
        "GPL-3.0-only",
        "GNU General Public License v3.0 only",
        "https://spdx.org/licenses/GPL-3.0-only.html",
        True,
    ),
    (
        "GPL-3.0-or-later",
        "GNU General Public License v3.0 or later",
        "https://spdx.org/licenses/GPL-3.0-or-later.html",
        True,
    ),
    (
        "LGPL-2.1-only",
        "GNU Lesser General Public License v2.1 only",
        "https://spdx.org/licenses/LGPL-2.1-only.html",
        True,
    ),
    (
        "LGPL-2.1-or-later",
        "GNU Lesser General Public License v2.1 or later",
        "https://spdx.org/licenses/LGPL-2.1-or-later.html",
        True,
    ),
    (
        "LGPL-3.0-only",
        "GNU Lesser General Public License v3.0 only",
        "https://spdx.org/licenses/LGPL-3.0-only.html",
        True,
    ),
    (
        "LGPL-3.0-or-later",
        "GNU Lesser General Public License v3.0 or later",
        "https://spdx.org/licenses/LGPL-3.0-or-later.html",
        True,
    ),
    (
        "LGPL-2.0-only",
        "GNU Library General Public License v2 only",
        "https://spdx.org/licenses/LGPL-2.0-only.html",
        True,
    ),
    (
        "LGPL-2.0-or-later",
        "GNU Library General Public License v2 or later",
        "https://spdx.org/licenses/LGPL-2.0-or-later.html",
        True,
    ),
    ("gnuplot", "gnuplot License", "https://spdx.org/licenses/gnuplot.html", True),
    (
        "GLWTPL",
        "Good Luck With That Public License",
        "https://spdx.org/licenses/GLWTPL.html",
        False,
    ),
    (
        "gSOAP-1.3b",
        "gSOAP Public License v1.3b",
        "https://spdx.org/licenses/gSOAP-1.3b.html",
        False,
    ),
    (
        "HaskellReport",
        "Haskell Language Report License",
        "https://spdx.org/licenses/HaskellReport.html",
        False,
    ),
    (
        "Hippocratic-2.1",
        "Hippocratic License 2.1",
        "https://spdx.org/licenses/Hippocratic-2.1.html",
        False,
    ),
    (
        "HPND",
        "Historical Permission Notice and Disclaimer",
        "https://spdx.org/licenses/HPND.html",
        True,
    ),
    (
        "HPND-sell-variant",
        "Historical Permission Notice and Disclaimer - sell variant",
        "https://spdx.org/licenses/HPND-sell-variant.html",
        False,
    ),
    ("HTMLTIDY", "HTML Tidy License", "https://spdx.org/licenses/HTMLTIDY.html", False),
    (
        "IBM-pibs",
        "IBM PowerPC Initialization and Boot Software",
        "https://spdx.org/licenses/IBM-pibs.html",
        False,
    ),
    (
        "IPL-1.0",
        "IBM Public License v1.0",
        "https://spdx.org/licenses/IPL-1.0.html",
        True,
    ),
    ("ICU", "ICU License", "https://spdx.org/licenses/ICU.html", False),
    (
        "ImageMagick",
        "ImageMagick License",
        "https://spdx.org/licenses/ImageMagick.html",
        False,
    ),
    (
        "iMatix",
        "iMatix Standard Function Library Agreement",
        "https://spdx.org/licenses/iMatix.html",
        True,
    ),
    ("Imlib2", "Imlib2 License", "https://spdx.org/licenses/Imlib2.html", True),
    (
        "IJG",
        "Independent JPEG Group License",
        "https://spdx.org/licenses/IJG.html",
        True,
    ),
    ("Info-ZIP", "Info-ZIP License", "https://spdx.org/licenses/Info-ZIP.html", False),
    (
        "Intel-ACPI",
        "Intel ACPI Software License Agreement",
        "https://spdx.org/licenses/Intel-ACPI.html",
        False,
    ),
    (
        "Intel",
        "Intel Open Source License",
        "https://spdx.org/licenses/Intel.html",
        True,
    ),
    (
        "Interbase-1.0",
        "Interbase Public License v1.0",
        "https://spdx.org/licenses/Interbase-1.0.html",
        False,
    ),
    ("IPA", "IPA Font License", "https://spdx.org/licenses/IPA.html", True),
    ("ISC", "ISC License", "https://spdx.org/licenses/ISC.html", True),
    ("Jam", "Jam License", "https://spdx.org/licenses/Jam.html", True),
    (
        "JPNIC",
        "Japan Network Information Center License",
        "https://spdx.org/licenses/JPNIC.html",
        False,
    ),
    (
        "JasPer-2.0",
        "JasPer License",
        "https://spdx.org/licenses/JasPer-2.0.html",
        False,
    ),
    ("JSON", "JSON License", "https://spdx.org/licenses/JSON.html", False),
    (
        "KiCad-libraries-exception",
        "KiCad Libraries Exception",
        "https://spdx.org/licenses/KiCad-libraries-exception.html",
        False,
    ),
    (
        "LPPL-1.0",
        "LaTeX Project Public License v1.0",
        "https://spdx.org/licenses/LPPL-1.0.html",
        False,
    ),
    (
        "LPPL-1.1",
        "LaTeX Project Public License v1.1",
        "https://spdx.org/licenses/LPPL-1.1.html",
        False,
    ),
    (
        "LPPL-1.2",
        "LaTeX Project Public License v1.2",
        "https://spdx.org/licenses/LPPL-1.2.html",
        True,
    ),
    (
        "LPPL-1.3a",
        "LaTeX Project Public License v1.3a",
        "https://spdx.org/licenses/LPPL-1.3a.html",
        True,
    ),
    (
        "LPPL-1.3c",
        "LaTeX Project Public License v1.3c",
        "https://spdx.org/licenses/LPPL-1.3c.html",
        True,
    ),
    ("Latex2e", "Latex2e License", "https://spdx.org/licenses/Latex2e.html", False),
    (
        "BSD-3-Clause-LBNL",
        "Lawrence Berkeley National Labs BSD variant license",
        "https://spdx.org/licenses/BSD-3-Clause-LBNL.html",
        True,
    ),
    (
        "Leptonica",
        "Leptonica License",
        "https://spdx.org/licenses/Leptonica.html",
        False,
    ),
    (
        "LGPLLR",
        "Lesser General Public License For Linguistic Resources",
        "https://spdx.org/licenses/LGPLLR.html",
        False,
    ),
    ("Libpng", "libpng License", "https://spdx.org/licenses/Libpng.html", False),
    (
        "libselinux-1.0",
        "libselinux public domain notice",
        "https://spdx.org/licenses/libselinux-1.0.html",
        False,
    ),
    ("libtiff", "libtiff License", "https://spdx.org/licenses/libtiff.html", False),
    (
        "LAL-1.2",
        "Licence Art Libre 1.2",
        "https://spdx.org/licenses/LAL-1.2.html",
        False,
    ),
    (
        "LAL-1.3",
        "Licence Art Libre 1.3",
        "https://spdx.org/licenses/LAL-1.3.html",
        False,
    ),
    (
        "LiLiQ-P-1.1",
        "Licence Libre du Québec – Permissive version 1.1",
        "https://spdx.org/licenses/LiLiQ-P-1.1.html",
        True,
    ),
    (
        "LiLiQ-Rplus-1.1",
        "Licence Libre du Québec – Réciprocité forte version 1.1",
        "https://spdx.org/licenses/LiLiQ-Rplus-1.1.html",
        True,
    ),
    (
        "LiLiQ-R-1.1",
        "Licence Libre du Québec – Réciprocité version 1.1",
        "https://spdx.org/licenses/LiLiQ-R-1.1.html",
        True,
    ),
    (
        "Linux-OpenIB",
        "Linux Kernel Variant of OpenIB.org license",
        "https://spdx.org/licenses/Linux-OpenIB.html",
        False,
    ),
    (
        "Linux-man-pages-copyleft",
        "Linux man-pages Copyleft",
        "https://spdx.org/licenses/Linux-man-pages-copyleft.html",
        False,
    ),
    (
        "LPL-1.02",
        "Lucent Public License v1.02",
        "https://spdx.org/licenses/LPL-1.02.html",
        True,
    ),
    (
        "LPL-1.0",
        "Lucent Public License Version 1.0",
        "https://spdx.org/licenses/LPL-1.0.html",
        True,
    ),
    (
        "MakeIndex",
        "MakeIndex License",
        "https://spdx.org/licenses/MakeIndex.html",
        False,
    ),
    (
        "MTLL",
        "Matrix Template Library License",
        "https://spdx.org/licenses/MTLL.html",
        False,
    ),
    ("MS-PL", "Microsoft Public License", "https://spdx.org/licenses/MS-PL.html", True),
    (
        "MS-RL",
        "Microsoft Reciprocal License",
        "https://spdx.org/licenses/MS-RL.html",
        True,
    ),
    (
        "MITNFA",
        "MIT +no-false-attribs license",
        "https://spdx.org/licenses/MITNFA.html",
        False,
    ),
    ("MIT", "MIT License", "https://spdx.org/licenses/MIT.html", True),
    (
        "MIT-Modern-Variant",
        "MIT License Modern Variant",
        "https://spdx.org/licenses/MIT-Modern-Variant.html",
        True,
    ),
    ("MIT-0", "MIT No Attribution", "https://spdx.org/licenses/MIT-0.html", True),
    (
        "MIT-open-group",
        "MIT Open Group variant",
        "https://spdx.org/licenses/MIT-open-group.html",
        False,
    ),
    ("Motosoto", "Motosoto License", "https://spdx.org/licenses/Motosoto.html", True),
    (
        "MPL-1.0",
        "Mozilla Public License 1.0",
        "https://spdx.org/licenses/MPL-1.0.html",
        True,
    ),
    (
        "MPL-1.1",
        "Mozilla Public License 1.1",
        "https://spdx.org/licenses/MPL-1.1.html",
        True,
    ),
    (
        "MPL-2.0",
        "Mozilla Public License 2.0",
        "https://spdx.org/licenses/MPL-2.0.html",
        True,
    ),
    (
        "MPL-2.0-no-copyleft-exception",
        "Mozilla Public License 2.0 (no copyleft exception)",
        "https://spdx.org/licenses/MPL-2.0-no-copyleft-exception.html",
        True,
    ),
    ("mpich2", "mpich2 License", "https://spdx.org/licenses/mpich2.html", False),
    ("mplus", "mplus Font License", "https://spdx.org/licenses/mplus.html", False),
    (
        "MulanPSL-1.0",
        "Mulan Permissive Software License, Version 1",
        "https://spdx.org/licenses/MulanPSL-1.0.html",
        False,
    ),
    (
        "MulanPSL-2.0",
        "Mulan Permissive Software License, Version 2",
        "https://spdx.org/licenses/MulanPSL-2.0.html",
        True,
    ),
    ("Multics", "Multics License", "https://spdx.org/licenses/Multics.html", True),
    ("Mup", "Mup License", "https://spdx.org/licenses/Mup.html", False),
    (
        "NAIST-2003",
        "Nara Institute of Science and Technology License (2003)",
        "https://spdx.org/licenses/NAIST-2003.html",
        False,
    ),
    (
        "NASA-1.3",
        "NASA Open Source Agreement 1.3",
        "https://spdx.org/licenses/NASA-1.3.html",
        True,
    ),
    ("Naumen", "Naumen Public License", "https://spdx.org/licenses/Naumen.html", True),
    (
        "NBPL-1.0",
        "Net Boolean Public License v1",
        "https://spdx.org/licenses/NBPL-1.0.html",
        False,
    ),
    ("Net-SNMP", "Net-SNMP License", "https://spdx.org/licenses/Net-SNMP.html", False),
    ("NetCDF", "NetCDF license", "https://spdx.org/licenses/NetCDF.html", False),
    (
        "NGPL",
        "Nethack General Public License",
        "https://spdx.org/licenses/NGPL.html",
        True,
    ),
    (
        "NOSL",
        "Netizen Open Source License",
        "https://spdx.org/licenses/NOSL.html",
        True,
    ),
    (
        "NPL-1.0",
        "Netscape Public License v1.0",
        "https://spdx.org/licenses/NPL-1.0.html",
        True,
    ),
    (
        "NPL-1.1",
        "Netscape Public License v1.1",
        "https://spdx.org/licenses/NPL-1.1.html",
        True,
    ),
    ("Newsletr", "Newsletr License", "https://spdx.org/licenses/Newsletr.html", False),
    (
        "NIST-PD",
        "NIST Public Domain Notice",
        "https://spdx.org/licenses/NIST-PD.html",
        False,
    ),
    (
        "NIST-PD-fallback",
        "NIST Public Domain Notice with license fallback",
        "https://spdx.org/licenses/NIST-PD-fallback.html",
        False,
    ),
    ("NLPL", "No Limit Public License", "https://spdx.org/licenses/NLPL.html", False),
    (
        "Nokia",
        "Nokia Open Source License",
        "https://spdx.org/licenses/Nokia.html",
        True,
    ),
    (
        "NCGL-UK-2.0",
        "Non-Commercial Government Licence",
        "https://spdx.org/licenses/NCGL-UK-2.0.html",
        False,
    ),
    (
        "NPOSL-3.0",
        "Non-Profit Open Software License 3.0",
        "https://spdx.org/licenses/NPOSL-3.0.html",
        True,
    ),
    (
        "NLOD-1.0",
        "Norwegian Licence for Open Government Data (NLOD) 1.0",
        "https://spdx.org/licenses/NLOD-1.0.html",
        False,
    ),
    (
        "NLOD-2.0",
        "Norwegian Licence for Open Government Data (NLOD) 2.0",
        "https://spdx.org/licenses/NLOD-2.0.html",
        False,
    ),
    ("Noweb", "Noweb License", "https://spdx.org/licenses/Noweb.html", False),
    ("NRL", "NRL License", "https://spdx.org/licenses/NRL.html", False),
    ("NTP", "NTP License", "https://spdx.org/licenses/NTP.html", True),
    ("NTP-0", "NTP No Attribution", "https://spdx.org/licenses/NTP-0.html", False),
    (
        "OCLC-2.0",
        "OCLC Research Public License 2.0",
        "https://spdx.org/licenses/OCLC-2.0.html",
        True,
    ),
    (
        "OGC-1.0",
        "OGC Software License, Version 1.0",
        "https://spdx.org/licenses/OGC-1.0.html",
        False,
    ),
    (
        "OCCT-PL",
        "Open CASCADE Technology Public License",
        "https://spdx.org/licenses/OCCT-PL.html",
        False,
    ),
    (
        "ODC-By-1.0",
        "Open Data Commons Attribution License v1.0",
        "https://spdx.org/licenses/ODC-By-1.0.html",
        False,
    ),
    (
        "ODbL-1.0",
        "Open Data Commons Open Database License v1.0",
        "https://spdx.org/licenses/ODbL-1.0.html",
        True,
    ),
    (
        "PDDL-1.0",
        "Open Data Commons Public Domain Dedication & License 1.0",
        "https://spdx.org/licenses/PDDL-1.0.html",
        False,
    ),
    (
        "OGL-Canada-2.0",
        "Open Government Licence - Canada",
        "https://spdx.org/licenses/OGL-Canada-2.0.html",
        False,
    ),
    (
        "OGL-UK-1.0",
        "Open Government Licence v1.0",
        "https://spdx.org/licenses/OGL-UK-1.0.html",
        False,
    ),
    (
        "OGL-UK-2.0",
        "Open Government Licence v2.0",
        "https://spdx.org/licenses/OGL-UK-2.0.html",
        False,
    ),
    (
        "OGL-UK-3.0",
        "Open Government Licence v3.0",
        "https://spdx.org/licenses/OGL-UK-3.0.html",
        False,
    ),
    (
        "OGTSL",
        "Open Group Test Suite License",
        "https://spdx.org/licenses/OGTSL.html",
        True,
    ),
    (
        "OLDAP-2.2.2",
        "Open LDAP Public License 2.2.2",
        "https://spdx.org/licenses/OLDAP-2.2.2.html",
        False,
    ),
    (
        "OLDAP-1.1",
        "Open LDAP Public License v1.1",
        "https://spdx.org/licenses/OLDAP-1.1.html",
        False,
    ),
    (
        "OLDAP-1.2",
        "Open LDAP Public License v1.2",
        "https://spdx.org/licenses/OLDAP-1.2.html",
        False,
    ),
    (
        "OLDAP-1.3",
        "Open LDAP Public License v1.3",
        "https://spdx.org/licenses/OLDAP-1.3.html",
        False,
    ),
    (
        "OLDAP-1.4",
        "Open LDAP Public License v1.4",
        "https://spdx.org/licenses/OLDAP-1.4.html",
        False,
    ),
    (
        "OLDAP-2.0",
        "Open LDAP Public License v2.0 (or possibly 2.0A and 2.0B)",
        "https://spdx.org/licenses/OLDAP-2.0.html",
        False,
    ),
    (
        "OLDAP-2.0.1",
        "Open LDAP Public License v2.0.1",
        "https://spdx.org/licenses/OLDAP-2.0.1.html",
        False,
    ),
    (
        "OLDAP-2.1",
        "Open LDAP Public License v2.1",
        "https://spdx.org/licenses/OLDAP-2.1.html",
        False,
    ),
    (
        "OLDAP-2.2",
        "Open LDAP Public License v2.2",
        "https://spdx.org/licenses/OLDAP-2.2.html",
        False,
    ),
    (
        "OLDAP-2.2.1",
        "Open LDAP Public License v2.2.1",
        "https://spdx.org/licenses/OLDAP-2.2.1.html",
        False,
    ),
    (
        "OLDAP-2.3",
        "Open LDAP Public License v2.3",
        "https://spdx.org/licenses/OLDAP-2.3.html",
        True,
    ),
    (
        "OLDAP-2.4",
        "Open LDAP Public License v2.4",
        "https://spdx.org/licenses/OLDAP-2.4.html",
        False,
    ),
    (
        "OLDAP-2.5",
        "Open LDAP Public License v2.5",
        "https://spdx.org/licenses/OLDAP-2.5.html",
        False,
    ),
    (
        "OLDAP-2.6",
        "Open LDAP Public License v2.6",
        "https://spdx.org/licenses/OLDAP-2.6.html",
        False,
    ),
    (
        "OLDAP-2.7",
        "Open LDAP Public License v2.7",
        "https://spdx.org/licenses/OLDAP-2.7.html",
        True,
    ),
    (
        "OLDAP-2.8",
        "Open LDAP Public License v2.8",
        "https://spdx.org/licenses/OLDAP-2.8.html",
        True,
    ),
    ("OML", "Open Market License", "https://spdx.org/licenses/OML.html", False),
    (
        "OPL-1.0",
        "Open Public License v1.0",
        "https://spdx.org/licenses/OPL-1.0.html",
        False,
    ),
    (
        "OPUBL-1.0",
        "Open Publication License v1.0",
        "https://spdx.org/licenses/OPUBL-1.0.html",
        False,
    ),
    (
        "OSL-1.0",
        "Open Software License 1.0",
        "https://spdx.org/licenses/OSL-1.0.html",
        True,
    ),
    (
        "OSL-1.1",
        "Open Software License 1.1",
        "https://spdx.org/licenses/OSL-1.1.html",
        True,
    ),
    (
        "OSL-2.0",
        "Open Software License 2.0",
        "https://spdx.org/licenses/OSL-2.0.html",
        True,
    ),
    (
        "OSL-2.1",
        "Open Software License 2.1",
        "https://spdx.org/licenses/OSL-2.1.html",
        True,
    ),
    (
        "OSL-3.0",
        "Open Software License 3.0",
        "https://spdx.org/licenses/OSL-3.0.html",
        True,
    ),
    (
        "O-UDA-1.0",
        "Open Use of Data Agreement v1.0",
        "https://spdx.org/licenses/O-UDA-1.0.html",
        False,
    ),
    ("OpenSSL", "OpenSSL License", "https://spdx.org/licenses/OpenSSL.html", True),
    (
        "OSET-PL-2.1",
        "OSET Public License version 2.1",
        "https://spdx.org/licenses/OSET-PL-2.1.html",
        True,
    ),
    ("PHP-3.0", "PHP License v3.0", "https://spdx.org/licenses/PHP-3.0.html", True),
    ("PHP-3.01", "PHP License v3.01", "https://spdx.org/licenses/PHP-3.01.html", True),
    (
        "Plexus",
        "Plexus Classworlds License",
        "https://spdx.org/licenses/Plexus.html",
        False,
    ),
    (
        "libpng-2.0",
        "PNG Reference Library version 2",
        "https://spdx.org/licenses/libpng-2.0.html",
        False,
    ),
    (
        "PolyForm-Noncommercial-1.0.0",
        "PolyForm Noncommercial License 1.0.0",
        "https://spdx.org/licenses/PolyForm-Noncommercial-1.0.0.html",
        False,
    ),
    (
        "PolyForm-Small-Business-1.0.0",
        "PolyForm Small Business License 1.0.0",
        "https://spdx.org/licenses/PolyForm-Small-Business-1.0.0.html",
        False,
    ),
    (
        "PostgreSQL",
        "PostgreSQL License",
        "https://spdx.org/licenses/PostgreSQL.html",
        True,
    ),
    ("psfrag", "psfrag License", "https://spdx.org/licenses/psfrag.html", False),
    ("psutils", "psutils License", "https://spdx.org/licenses/psutils.html", False),
    (
        "Python-2.0",
        "Python License 2.0",
        "https://spdx.org/licenses/Python-2.0.html",
        True,
    ),
    (
        "PSF-2.0",
        "Python Software Foundation License 2.0",
        "https://spdx.org/licenses/PSF-2.0.html",
        False,
    ),
    ("QPL-1.0", "Q Public License 1.0", "https://spdx.org/licenses/QPL-1.0.html", True),
    ("Qhull", "Qhull License", "https://spdx.org/licenses/Qhull.html", False),
    ("Rdisc", "Rdisc License", "https://spdx.org/licenses/Rdisc.html", False),
    (
        "RPSL-1.0",
        "RealNetworks Public Source License v1.0",
        "https://spdx.org/licenses/RPSL-1.0.html",
        True,
    ),
    (
        "RPL-1.1",
        "Reciprocal Public License 1.1",
        "https://spdx.org/licenses/RPL-1.1.html",
        True,
    ),
    (
        "RPL-1.5",
        "Reciprocal Public License 1.5",
        "https://spdx.org/licenses/RPL-1.5.html",
        True,
    ),
    (
        "RHeCos-1.1",
        "Red Hat eCos Public License v1.1",
        "https://spdx.org/licenses/RHeCos-1.1.html",
        False,
    ),
    (
        "RSCPL",
        "Ricoh Source Code Public License",
        "https://spdx.org/licenses/RSCPL.html",
        True,
    ),
    (
        "RSA-MD",
        "RSA Message-Digest License",
        "https://spdx.org/licenses/RSA-MD.html",
        False,
    ),
    ("Ruby", "Ruby License", "https://spdx.org/licenses/Ruby.html", True),
    (
        "SAX-PD",
        "Sax Public Domain Notice",
        "https://spdx.org/licenses/SAX-PD.html",
        False,
    ),
    ("Saxpath", "Saxpath License", "https://spdx.org/licenses/Saxpath.html", False),
    (
        "SCEA",
        "SCEA Shared Source License",
        "https://spdx.org/licenses/SCEA.html",
        False,
    ),
    (
        "SchemeReport",
        "Scheme Language Report License",
        "https://spdx.org/licenses/SchemeReport.html",
        False,
    ),
    (
        "SWL",
        "Scheme Widget Library (SWL) Software License Agreement",
        "https://spdx.org/licenses/SWL.html",
        False,
    ),
    (
        "SMPPL",
        "Secure Messaging Protocol Public License",
        "https://spdx.org/licenses/SMPPL.html",
        False,
    ),
    ("Sendmail", "Sendmail License", "https://spdx.org/licenses/Sendmail.html", False),
    (
        "Sendmail-8.23",
        "Sendmail License 8.23",
        "https://spdx.org/licenses/Sendmail-8.23.html",
        False,
    ),
    (
        "SSPL-1.0",
        "Server Side Public License, v 1",
        "https://spdx.org/licenses/SSPL-1.0.html",
        False,
    ),
    (
        "SGI-B-1.0",
        "SGI Free Software License B v1.0",
        "https://spdx.org/licenses/SGI-B-1.0.html",
        False,
    ),
    (
        "SGI-B-1.1",
        "SGI Free Software License B v1.1",
        "https://spdx.org/licenses/SGI-B-1.1.html",
        False,
    ),
    (
        "SGI-B-2.0",
        "SGI Free Software License B v2.0",
        "https://spdx.org/licenses/SGI-B-2.0.html",
        True,
    ),
    (
        "OFL-1.0",
        "SIL Open Font License 1.0",
        "https://spdx.org/licenses/OFL-1.0.html",
        True,
    ),
    (
        "OFL-1.0-no-RFN",
        "SIL Open Font License 1.0 with no Reserved Font Name",
        "https://spdx.org/licenses/OFL-1.0-no-RFN.html",
        False,
    ),
    (
        "OFL-1.0-RFN",
        "SIL Open Font License 1.0 with Reserved Font Name",
        "https://spdx.org/licenses/OFL-1.0-RFN.html",
        False,
    ),
    (
        "OFL-1.1",
        "SIL Open Font License 1.1",
        "https://spdx.org/licenses/OFL-1.1.html",
        True,
    ),
    (
        "OFL-1.1-no-RFN",
        "SIL Open Font License 1.1 with no Reserved Font Name",
        "https://spdx.org/licenses/OFL-1.1-no-RFN.html",
        True,
    ),
    (
        "OFL-1.1-RFN",
        "SIL Open Font License 1.1 with Reserved Font Name",
        "https://spdx.org/licenses/OFL-1.1-RFN.html",
        True,
    ),
    (
        "SimPL-2.0",
        "Simple Public License 2.0",
        "https://spdx.org/licenses/SimPL-2.0.html",
        True,
    ),
    (
        "Sleepycat",
        "Sleepycat License",
        "https://spdx.org/licenses/Sleepycat.html",
        True,
    ),
    ("SNIA", "SNIA Public License 1.1", "https://spdx.org/licenses/SNIA.html", False),
    (
        "SHL-0.5",
        "Solderpad Hardware License v0.5",
        "https://spdx.org/licenses/SHL-0.5.html",
        False,
    ),
    (
        "SHL-0.51",
        "Solderpad Hardware License, Version 0.51",
        "https://spdx.org/licenses/SHL-0.51.html",
        False,
    ),
    (
        "Spencer-86",
        "Spencer License 86",
        "https://spdx.org/licenses/Spencer-86.html",
        False,
    ),
    (
        "Spencer-94",
        "Spencer License 94",
        "https://spdx.org/licenses/Spencer-94.html",
        False,
    ),
    (
        "Spencer-99",
        "Spencer License 99",
        "https://spdx.org/licenses/Spencer-99.html",
        False,
    ),
    ("blessing", "SQLite Blessing", "https://spdx.org/licenses/blessing.html", False),
    (
        "SSH-OpenSSH",
        "SSH OpenSSH license",
        "https://spdx.org/licenses/SSH-OpenSSH.html",
        False,
    ),
    (
        "SSH-short",
        "SSH short notice",
        "https://spdx.org/licenses/SSH-short.html",
        False,
    ),
    (
        "SMLNJ",
        "Standard ML of New Jersey License",
        "https://spdx.org/licenses/SMLNJ.html",
        True,
    ),
    (
        "SugarCRM-1.1.3",
        "SugarCRM Public License v1.1.3",
        "https://spdx.org/licenses/SugarCRM-1.1.3.html",
        False,
    ),
    (
        "SISSL",
        "Sun Industry Standards Source License v1.1",
        "https://spdx.org/licenses/SISSL.html",
        True,
    ),
    (
        "SISSL-1.2",
        "Sun Industry Standards Source License v1.2",
        "https://spdx.org/licenses/SISSL-1.2.html",
        False,
    ),
    (
        "SPL-1.0",
        "Sun Public License v1.0",
        "https://spdx.org/licenses/SPL-1.0.html",
        True,
    ),
    (
        "Watcom-1.0",
        "Sybase Open Watcom Public License 1.0",
        "https://spdx.org/licenses/Watcom-1.0.html",
        True,
    ),
    (
        "OGDL-Taiwan-1.0",
        "Taiwan Open Government Data License, version 1.0",
        "https://spdx.org/licenses/OGDL-Taiwan-1.0.html",
        False,
    ),
    (
        "TAPR-OHL-1.0",
        "TAPR Open Hardware License v1.0",
        "https://spdx.org/licenses/TAPR-OHL-1.0.html",
        False,
    ),
    ("TCL", "TCL/TK License", "https://spdx.org/licenses/TCL.html", False),
    (
        "TCP-wrappers",
        "TCP Wrappers License",
        "https://spdx.org/licenses/TCP-wrappers.html",
        False,
    ),
    (
        "TU-Berlin-1.0",
        "Technische Universitaet Berlin License 1.0",
        "https://spdx.org/licenses/TU-Berlin-1.0.html",
        False,
    ),
    (
        "TU-Berlin-2.0",
        "Technische Universitaet Berlin License 2.0",
        "https://spdx.org/licenses/TU-Berlin-2.0.html",
        False,
    ),
    ("MirOS", "The MirOS Licence", "https://spdx.org/licenses/MirOS.html", True),
    (
        "Parity-6.0.0",
        "The Parity Public License 6.0.0",
        "https://spdx.org/licenses/Parity-6.0.0.html",
        False,
    ),
    (
        "Parity-7.0.0",
        "The Parity Public License 7.0.0",
        "https://spdx.org/licenses/Parity-7.0.0.html",
        False,
    ),
    ("Unlicense", "The Unlicense", "https://spdx.org/licenses/Unlicense.html", True),
    (
        "TMate",
        "TMate Open Source License",
        "https://spdx.org/licenses/TMate.html",
        False,
    ),
    (
        "TORQUE-1.1",
        "TORQUE v2.5+ Software License v1.1",
        "https://spdx.org/licenses/TORQUE-1.1.html",
        False,
    ),
    (
        "TOSL",
        "Trusster Open Source License",
        "https://spdx.org/licenses/TOSL.html",
        False,
    ),
    (
        "Unicode-DFS-2015",
        "Unicode License Agreement - Data Files and Software (2015)",
        "https://spdx.org/licenses/Unicode-DFS-2015.html",
        False,
    ),
    (
        "Unicode-DFS-2016",
        "Unicode License Agreement - Data Files and Software (2016)",
        "https://spdx.org/licenses/Unicode-DFS-2016.html",
        True,
    ),
    (
        "Unicode-TOU",
        "Unicode Terms of Use",
        "https://spdx.org/licenses/Unicode-TOU.html",
        False,
    ),
    (
        "UPL-1.0",
        "Universal Permissive License v1.0",
        "https://spdx.org/licenses/UPL-1.0.html",
        True,
    ),
    (
        "NCSA",
        "University of Illinois/NCSA Open Source License",
        "https://spdx.org/licenses/NCSA.html",
        True,
    ),
    (
        "UCL-1.0",
        "Upstream Compatibility License v1.0",
        "https://spdx.org/licenses/UCL-1.0.html",
        True,
    ),
    ("Vim", "Vim License", "https://spdx.org/licenses/Vim.html", True),
    (
        "VOSTROM",
        "VOSTROM Public License for Open Source",
        "https://spdx.org/licenses/VOSTROM.html",
        False,
    ),
    (
        "VSL-1.0",
        "Vovida Software License v1.0",
        "https://spdx.org/licenses/VSL-1.0.html",
        True,
    ),
    (
        "W3C-20150513",
        "W3C Software Notice and Document License (2015-05-13)",
        "https://spdx.org/licenses/W3C-20150513.html",
        False,
    ),
    (
        "W3C-19980720",
        "W3C Software Notice and License (1998-07-20)",
        "https://spdx.org/licenses/W3C-19980720.html",
        False,
    ),
    (
        "W3C",
        "W3C Software Notice and License (2002-12-31)",
        "https://spdx.org/licenses/W3C.html",
        True,
    ),
    ("Wsuipa", "Wsuipa License", "https://spdx.org/licenses/Wsuipa.html", False),
    ("Xnet", "X.Net License", "https://spdx.org/licenses/Xnet.html", True),
    ("X11", "X11 License", "https://spdx.org/licenses/X11.html", True),
    (
        "X11-distribute-modifications-variant",
        "X11 License Distribution Modification Variant",
        "https://spdx.org/licenses/X11-distribute-modifications-variant.html",
        False,
    ),
    ("Xerox", "Xerox License", "https://spdx.org/licenses/Xerox.html", False),
    (
        "XFree86-1.1",
        "XFree86 License 1.1",
        "https://spdx.org/licenses/XFree86-1.1.html",
        True,
    ),
    ("xinetd", "xinetd License", "https://spdx.org/licenses/xinetd.html", True),
    ("xpp", "XPP License", "https://spdx.org/licenses/xpp.html", False),
    ("XSkat", "XSkat License", "https://spdx.org/licenses/XSkat.html", False),
    (
        "YPL-1.0",
        "Yahoo! Public License v1.0",
        "https://spdx.org/licenses/YPL-1.0.html",
        False,
    ),
    (
        "YPL-1.1",
        "Yahoo! Public License v1.1",
        "https://spdx.org/licenses/YPL-1.1.html",
        True,
    ),
    ("Zed", "Zed License", "https://spdx.org/licenses/Zed.html", False),
    ("Zend-2.0", "Zend License v2.0", "https://spdx.org/licenses/Zend-2.0.html", True),
    (
        "Zimbra-1.3",
        "Zimbra Public License v1.3",
        "https://spdx.org/licenses/Zimbra-1.3.html",
        True,
    ),
    (
        "Zimbra-1.4",
        "Zimbra Public License v1.4",
        "https://spdx.org/licenses/Zimbra-1.4.html",
        False,
    ),
    ("Zlib", "zlib License", "https://spdx.org/licenses/Zlib.html", True),
    (
        "zlib-acknowledgement",
        "zlib/libpng License with Acknowledgement",
        "https://spdx.org/licenses/zlib-acknowledgement.html",
        False,
    ),
    (
        "ZPL-1.1",
        "Zope Public License 1.1",
        "https://spdx.org/licenses/ZPL-1.1.html",
        False,
    ),
    (
        "ZPL-2.0",
        "Zope Public License 2.0",
        "https://spdx.org/licenses/ZPL-2.0.html",
        True,
    ),
    (
        "ZPL-2.1",
        "Zope Public License 2.1",
        "https://spdx.org/licenses/ZPL-2.1.html",
        True,
    ),
)
