# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict


class AddAddressBookRequestAckLabels(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class AddAddressBookRequestTagList(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # The key of the ECS tag.
        self.tag_key = tag_key
        # The value of the ECS tag.
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class AddAddressBookRequest(TeaModel):
    def __init__(
        self,
        ack_cluster_connector_id: str = None,
        ack_labels: List[AddAddressBookRequestAckLabels] = None,
        ack_namespaces: List[str] = None,
        address_list: str = None,
        auto_add_tag_ecs: str = None,
        description: str = None,
        group_name: str = None,
        group_type: str = None,
        lang: str = None,
        source_ip: str = None,
        tag_list: List[AddAddressBookRequestTagList] = None,
        tag_relation: str = None,
    ):
        self.ack_cluster_connector_id = ack_cluster_connector_id
        self.ack_labels = ack_labels
        self.ack_namespaces = ack_namespaces
        # The addresses that you want to add to the address book. Separate multiple addresses with commas (,).
        # 
        # >  If you set GroupType to `ip`, `port` or `domain`, you must specify AddressList.
        # 
        # *   If you set GroupType to `ip`, you must add IP addresses to the address book. Example: 192.0.XX.XX/32,192.0.XX.XX/24.
        # *   If you set GroupType to `port`, you must add port numbers or port ranges to the address book. Example: 80,100/200.
        # *   If you set GroupType to `domain`, you must add domain names to the address book. Example: example.com,aliyundoc.com.
        self.address_list = address_list
        # Specifies whether to automatically add public IP addresses of ECS instances to the address book if the instances match the specified tags. Valid values:
        # 
        # *   **1**: yes
        # *   **0** (default): no
        self.auto_add_tag_ecs = auto_add_tag_ecs
        # The description of the address book.
        # 
        # This parameter is required.
        self.description = description
        # The name of the address book.
        # 
        # This parameter is required.
        self.group_name = group_name
        # The type of the address book. Valid values:
        # 
        # *   **ip**: IP address book
        # *   **domain**: domain address book
        # *   **port**: port address book
        # *   **tag**: ECS tag-based address book
        # 
        # This parameter is required.
        self.group_type = group_type
        # The language of the content within the response. Valid values:
        # 
        # *   **zh** (default): Chinese
        # *   **en**: English
        self.lang = lang
        # The source IP address of the request.
        self.source_ip = source_ip
        # The ECS tags that you want to match.
        self.tag_list = tag_list
        # The logical relation among the ECS tags that you want to match. Valid values:
        # 
        # *   **and** (default): Only the public IP addresses of ECS instances that match all the specified tags can be added to the address book.
        # *   **or**: The public IP addresses of ECS instances that match one of the specified tags can be added to the address book.
        self.tag_relation = tag_relation

    def validate(self):
        if self.ack_labels:
            for k in self.ack_labels:
                if k:
                    k.validate()
        if self.tag_list:
            for k in self.tag_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ack_cluster_connector_id is not None:
            result['AckClusterConnectorId'] = self.ack_cluster_connector_id
        result['AckLabels'] = []
        if self.ack_labels is not None:
            for k in self.ack_labels:
                result['AckLabels'].append(k.to_map() if k else None)
        if self.ack_namespaces is not None:
            result['AckNamespaces'] = self.ack_namespaces
        if self.address_list is not None:
            result['AddressList'] = self.address_list
        if self.auto_add_tag_ecs is not None:
            result['AutoAddTagEcs'] = self.auto_add_tag_ecs
        if self.description is not None:
            result['Description'] = self.description
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.group_type is not None:
            result['GroupType'] = self.group_type
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        result['TagList'] = []
        if self.tag_list is not None:
            for k in self.tag_list:
                result['TagList'].append(k.to_map() if k else None)
        if self.tag_relation is not None:
            result['TagRelation'] = self.tag_relation
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AckClusterConnectorId') is not None:
            self.ack_cluster_connector_id = m.get('AckClusterConnectorId')
        self.ack_labels = []
        if m.get('AckLabels') is not None:
            for k in m.get('AckLabels'):
                temp_model = AddAddressBookRequestAckLabels()
                self.ack_labels.append(temp_model.from_map(k))
        if m.get('AckNamespaces') is not None:
            self.ack_namespaces = m.get('AckNamespaces')
        if m.get('AddressList') is not None:
            self.address_list = m.get('AddressList')
        if m.get('AutoAddTagEcs') is not None:
            self.auto_add_tag_ecs = m.get('AutoAddTagEcs')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('GroupType') is not None:
            self.group_type = m.get('GroupType')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        self.tag_list = []
        if m.get('TagList') is not None:
            for k in m.get('TagList'):
                temp_model = AddAddressBookRequestTagList()
                self.tag_list.append(temp_model.from_map(k))
        if m.get('TagRelation') is not None:
            self.tag_relation = m.get('TagRelation')
        return self


class AddAddressBookResponseBody(TeaModel):
    def __init__(
        self,
        group_uuid: str = None,
        request_id: str = None,
    ):
        # The UUID of the returned address book.
        self.group_uuid = group_uuid
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_uuid is not None:
            result['GroupUuid'] = self.group_uuid
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupUuid') is not None:
            self.group_uuid = m.get('GroupUuid')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddAddressBookResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddAddressBookResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddAddressBookResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddControlPolicyRequest(TeaModel):
    def __init__(
        self,
        acl_action: str = None,
        application_name: str = None,
        application_name_list: List[str] = None,
        description: str = None,
        dest_port: str = None,
        dest_port_group: str = None,
        dest_port_type: str = None,
        destination: str = None,
        destination_type: str = None,
        direction: str = None,
        domain_resolve_type: str = None,
        end_time: int = None,
        ip_version: str = None,
        lang: str = None,
        new_order: str = None,
        proto: str = None,
        release: str = None,
        repeat_days: List[int] = None,
        repeat_end_time: str = None,
        repeat_start_time: str = None,
        repeat_type: str = None,
        source: str = None,
        source_ip: str = None,
        source_type: str = None,
        start_time: int = None,
    ):
        # The action that Cloud Firewall performs on the traffic. Valid values:
        # 
        # *   **accept**: allows the traffic.
        # *   **drop**: denies the traffic.
        # *   **log**: monitors the traffic.
        # 
        # This parameter is required.
        self.acl_action = acl_action
        # The application type supported by the access control policy. Valid values:
        # 
        # *   **FTP**\
        # *   **HTTP**\
        # *   **HTTPS**\
        # *   **Memcache**\
        # *   **MongoDB**\
        # *   **MQTT**\
        # *   **MySQL**\
        # *   **RDP**\
        # *   **Redis**\
        # *   **SMTP**\
        # *   **SMTPS**\
        # *   **SSH**\
        # *   **SSL_No_Cert**\
        # *   **SSL**\
        # *   **VNC**\
        # *   **ANY**\
        # 
        # > The value of this parameter is based on the value of Proto. If Proto is set to TCP, you can set ApplicationName to any valid value. If Proto is set to UDP, ICMP, or ANY, you can set ApplicationName only to ANY. You must specify at least one of the ApplicationNameList and ApplicationName parameters.
        self.application_name = application_name
        # The application types supported by the access control policy.
        self.application_name_list = application_name_list
        # The description of the access control policy.
        # 
        # This parameter is required.
        self.description = description
        # The destination port in the access control policy. Valid values:
        # 
        # *   If Proto is set to ICMP, DestPort is automatically left empty.
        # 
        # > If Proto is set to ICMP, access control does not take effect on the destination port.
        # 
        # *   If Proto is set to TCP, UDP, or ANY and DestPortType is set to group, DestPort is empty.
        # 
        # > If DestPortType is set to group, you do not need to specify the destination port number. All ports on which the access control policy takes effect are included in the destination port address book.
        # 
        # *   If Proto is set to TCP, UDP, or ANY and DestPortType is set to port, the value of DestPort is the destination port number.
        self.dest_port = dest_port
        # The name of the destination port address book in the access control policy.
        # 
        # > If DestPortType is set to group, you must specify the name of the destination port address book.
        self.dest_port_group = dest_port_group
        # The type of the destination port in the access control policy.
        # 
        # Valid values:
        # 
        # *   **port**: port
        # *   **group**: port address book
        self.dest_port_type = dest_port_type
        # The destination address in the access control policy.
        # 
        # Valid values:
        # 
        # *   If DestinationType is set to net, the value of this parameter is a CIDR block.
        # 
        #     Example: 1.2.XX.XX/24
        # 
        # *   If DestinationType is set to group, the value of this parameter is an address book name.
        # 
        #     Example: db_group
        # 
        # *   If DestinationType is set to domain, the value of this parameter is a domain name.
        # 
        #     Example: \\*.aliyuncs.com
        # 
        # *   If DestinationType is set to location, the value of this parameter is a location.
        # 
        #     Example: ["BJ11", "ZB"]
        # 
        # This parameter is required.
        self.destination = destination
        # The type of the destination address in the access control policy. Valid values:
        # 
        # *   **net**: CIDR block
        # *   **group**: address book
        # *   **domain**: domain name
        # *   **location**: location
        # 
        # This parameter is required.
        self.destination_type = destination_type
        # The direction of the traffic to which the access control policy applies. Valid values:
        # 
        # *   **in**: inbound traffic
        # *   **out**: outbound traffic
        # 
        # This parameter is required.
        self.direction = direction
        # The domain name resolution method of the access control policy. Valid values:
        # 
        # * **FQDN**: fully qualified domain name (FQDN)-based resolution
        # * **DNS**: DNS-based dynamic resolution
        # * **FQDN_AND_DNS**: FQDN and DNS-based dynamic resolution
        self.domain_resolve_type = domain_resolve_type
        # The time when the access control policy stops taking effect. The value is a UNIX timestamp. Unit: seconds. The value must be on the hour or on the half hour, and at least 30 minutes later than the start time.
        # 
        # >  If you set RepeatType to Permanent, leave this parameter empty. If you set RepeatType to None, Daily, Weekly, or Monthly, you must specify this parameter.
        self.end_time = end_time
        # The IP version supported by the access control policy.
        # 
        # Valid values:
        # 
        # *   **4**: IPv4
        # *   **6**: IPv6
        self.ip_version = ip_version
        # The language of the content within the request and response. Valid values:
        # 
        # *   **zh**: Chinese (default)
        # *   **en**: English
        self.lang = lang
        # The priority of the access control policy. The priority value starts from 1. A smaller priority value indicates a higher priority.
        # 
        # This parameter is required.
        self.new_order = new_order
        # The protocol type supported by the access control policy. Valid values:
        # 
        # *   **ANY**\
        # *   **TCP**\
        # *   **UDP**\
        # *   **ICMP**\
        # 
        # This parameter is required.
        self.proto = proto
        # Specifies whether to enable the access control policy. By default, an access control policy is enabled after the policy is created. Valid values:
        # 
        # *   **true**: enables the access control policy.
        # *   **false**: disables the access control policy.
        self.release = release
        # The days of a week or of a month on which the access control policy takes effect.
        # 
        # *   If you set RepeatType to `Permanent`, `None`, or `Daily`, leave this parameter empty. Example: [].
        # *   If you set RepeatType to Weekly, you must specify this parameter. Example: [0, 6].
        # 
        # >  If you set RepeatType to Weekly, the fields in the value of this parameter cannot be repeated.
        # 
        # *   If you set RepeatType to `Monthly`, you must specify this parameter. Example: [1, 31].
        # 
        # >  If you set RepeatType to Monthly, the fields in the value of this parameter cannot be repeated.
        self.repeat_days = repeat_days
        # The point in time when the recurrence ends. Example: 23:30. The end time must be on the hour or on the half hour, and at least 30 minutes later than the start time.
        # 
        # >  If you set RepeatType to Permanent or None, leave this parameter empty. If you set RepeatType to Daily, Weekly, or Monthly, you must specify this parameter.
        self.repeat_end_time = repeat_end_time
        # The point in time when the recurrence starts. Example: 08:00. The start time must be on the hour or on the half hour, and at least 30 minutes earlier than the end time.
        # 
        # >  If you set RepeatType to Permanent or None, leave this parameter empty. If you set RepeatType to Daily, Weekly, or Monthly, you must specify this parameter.
        self.repeat_start_time = repeat_start_time
        # The recurrence type for the access control policy to take effect. Valid values:
        # 
        # *   **Permanent** (default): The policy always takes effect.
        # *   **None**: The policy takes effect for only once.
        # *   **Daily**: The policy takes effect on a daily basis.
        # *   **Weekly**: The policy takes effect on a weekly basis.
        # *   **Monthly**: The policy takes effect on a monthly basis.
        self.repeat_type = repeat_type
        # The source address in the access control policy. Valid values:
        # 
        # *   If SourceType is set to net, the value of this parameter is a CIDR block.
        # 
        #     Example: 1.1.XX.XX/24
        # 
        # *   If SourceType is set to group, the value of this parameter is an address book name.
        # 
        #     Example: db_group
        # 
        # *   If SourceType is set to location, the value of this parameter is a location.
        # 
        #     Example: ["BJ11", "ZB"]
        # 
        # This parameter is required.
        self.source = source
        # The source IP address of the request.
        self.source_ip = source_ip
        # The type of the source address in the access control policy. Valid values:
        # 
        # *   **net**: CIDR block
        # *   **group**: address book
        # *   **location**: location
        # 
        # This parameter is required.
        self.source_type = source_type
        # The time when the access control policy starts to take effect. The value is a UNIX timestamp. Unit: seconds. The value must be on the hour or on the half hour, and at least 30 minutes earlier than the end time.
        # 
        # >  If you set RepeatType to Permanent, leave this parameter empty. If you set RepeatType to None, Daily, Weekly, or Monthly, you must specify this parameter.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_action is not None:
            result['AclAction'] = self.acl_action
        if self.application_name is not None:
            result['ApplicationName'] = self.application_name
        if self.application_name_list is not None:
            result['ApplicationNameList'] = self.application_name_list
        if self.description is not None:
            result['Description'] = self.description
        if self.dest_port is not None:
            result['DestPort'] = self.dest_port
        if self.dest_port_group is not None:
            result['DestPortGroup'] = self.dest_port_group
        if self.dest_port_type is not None:
            result['DestPortType'] = self.dest_port_type
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.destination_type is not None:
            result['DestinationType'] = self.destination_type
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.domain_resolve_type is not None:
            result['DomainResolveType'] = self.domain_resolve_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.ip_version is not None:
            result['IpVersion'] = self.ip_version
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.new_order is not None:
            result['NewOrder'] = self.new_order
        if self.proto is not None:
            result['Proto'] = self.proto
        if self.release is not None:
            result['Release'] = self.release
        if self.repeat_days is not None:
            result['RepeatDays'] = self.repeat_days
        if self.repeat_end_time is not None:
            result['RepeatEndTime'] = self.repeat_end_time
        if self.repeat_start_time is not None:
            result['RepeatStartTime'] = self.repeat_start_time
        if self.repeat_type is not None:
            result['RepeatType'] = self.repeat_type
        if self.source is not None:
            result['Source'] = self.source
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclAction') is not None:
            self.acl_action = m.get('AclAction')
        if m.get('ApplicationName') is not None:
            self.application_name = m.get('ApplicationName')
        if m.get('ApplicationNameList') is not None:
            self.application_name_list = m.get('ApplicationNameList')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestPort') is not None:
            self.dest_port = m.get('DestPort')
        if m.get('DestPortGroup') is not None:
            self.dest_port_group = m.get('DestPortGroup')
        if m.get('DestPortType') is not None:
            self.dest_port_type = m.get('DestPortType')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('DestinationType') is not None:
            self.destination_type = m.get('DestinationType')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('DomainResolveType') is not None:
            self.domain_resolve_type = m.get('DomainResolveType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IpVersion') is not None:
            self.ip_version = m.get('IpVersion')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NewOrder') is not None:
            self.new_order = m.get('NewOrder')
        if m.get('Proto') is not None:
            self.proto = m.get('Proto')
        if m.get('Release') is not None:
            self.release = m.get('Release')
        if m.get('RepeatDays') is not None:
            self.repeat_days = m.get('RepeatDays')
        if m.get('RepeatEndTime') is not None:
            self.repeat_end_time = m.get('RepeatEndTime')
        if m.get('RepeatStartTime') is not None:
            self.repeat_start_time = m.get('RepeatStartTime')
        if m.get('RepeatType') is not None:
            self.repeat_type = m.get('RepeatType')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class AddControlPolicyResponseBody(TeaModel):
    def __init__(
        self,
        acl_uuid: str = None,
        request_id: str = None,
    ):
        # The ID of the access control policy that is created on the Internet firewall.
        self.acl_uuid = acl_uuid
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_uuid is not None:
            result['AclUuid'] = self.acl_uuid
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclUuid') is not None:
            self.acl_uuid = m.get('AclUuid')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddControlPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddControlPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddControlPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddDnsFirewallPolicyRequest(TeaModel):
    def __init__(
        self,
        acl_action: str = None,
        description: str = None,
        destination: str = None,
        destination_type: str = None,
        direction: str = None,
        ip_version: str = None,
        lang: str = None,
        priority: str = None,
        release: str = None,
        source: str = None,
        source_ip: str = None,
        source_type: str = None,
    ):
        # This parameter is required.
        self.acl_action = acl_action
        # This parameter is required.
        self.description = description
        # This parameter is required.
        self.destination = destination
        # This parameter is required.
        self.destination_type = destination_type
        self.direction = direction
        # This parameter is required.
        self.ip_version = ip_version
        self.lang = lang
        # This parameter is required.
        self.priority = priority
        # This parameter is required.
        self.release = release
        # This parameter is required.
        self.source = source
        self.source_ip = source_ip
        # This parameter is required.
        self.source_type = source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_action is not None:
            result['AclAction'] = self.acl_action
        if self.description is not None:
            result['Description'] = self.description
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.destination_type is not None:
            result['DestinationType'] = self.destination_type
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.ip_version is not None:
            result['IpVersion'] = self.ip_version
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.release is not None:
            result['Release'] = self.release
        if self.source is not None:
            result['Source'] = self.source
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclAction') is not None:
            self.acl_action = m.get('AclAction')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('DestinationType') is not None:
            self.destination_type = m.get('DestinationType')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('IpVersion') is not None:
            self.ip_version = m.get('IpVersion')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Release') is not None:
            self.release = m.get('Release')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        return self


class AddDnsFirewallPolicyResponseBody(TeaModel):
    def __init__(
        self,
        acl_uuid: str = None,
        request_id: str = None,
    ):
        self.acl_uuid = acl_uuid
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_uuid is not None:
            result['AclUuid'] = self.acl_uuid
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclUuid') is not None:
            self.acl_uuid = m.get('AclUuid')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddDnsFirewallPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddDnsFirewallPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddDnsFirewallPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddInstanceMembersRequestMembers(TeaModel):
    def __init__(
        self,
        member_desc: str = None,
        member_uid: int = None,
    ):
        # The remarks of the member. The value must be 1 to 256 characters in length.
        self.member_desc = member_desc
        # The UID of the member. You can add up to 20 members to Cloud Firewall at a time.
        # 
        # This parameter is required.
        self.member_uid = member_uid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.member_desc is not None:
            result['MemberDesc'] = self.member_desc
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MemberDesc') is not None:
            self.member_desc = m.get('MemberDesc')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        return self


class AddInstanceMembersRequest(TeaModel):
    def __init__(
        self,
        members: List[AddInstanceMembersRequestMembers] = None,
    ):
        # The members.
        # 
        # This parameter is required.
        self.members = members

    def validate(self):
        if self.members:
            for k in self.members:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Members'] = []
        if self.members is not None:
            for k in self.members:
                result['Members'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.members = []
        if m.get('Members') is not None:
            for k in m.get('Members'):
                temp_model = AddInstanceMembersRequestMembers()
                self.members.append(temp_model.from_map(k))
        return self


class AddInstanceMembersResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddInstanceMembersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddInstanceMembersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddInstanceMembersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddPrivateDnsDomainNameRequest(TeaModel):
    def __init__(
        self,
        access_instance_id: str = None,
        domain_name_list: List[str] = None,
        region_no: str = None,
    ):
        # This parameter is required.
        self.access_instance_id = access_instance_id
        # This parameter is required.
        self.domain_name_list = domain_name_list
        # This parameter is required.
        self.region_no = region_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_instance_id is not None:
            result['AccessInstanceId'] = self.access_instance_id
        if self.domain_name_list is not None:
            result['DomainNameList'] = self.domain_name_list
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessInstanceId') is not None:
            self.access_instance_id = m.get('AccessInstanceId')
        if m.get('DomainNameList') is not None:
            self.domain_name_list = m.get('DomainNameList')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        return self


class AddPrivateDnsDomainNameResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # Id of the request
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddPrivateDnsDomainNameResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddPrivateDnsDomainNameResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddPrivateDnsDomainNameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchCopyVpcFirewallControlPolicyRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        source_ip: str = None,
        source_vpc_firewall_id: str = None,
        target_vpc_firewall_id: str = None,
    ):
        # The language of the content within the request and response. Valid values:
        # 
        # *   **zh**: Chinese (default)
        # *   **en**: English
        self.lang = lang
        # The source IP address of the request.
        self.source_ip = source_ip
        # The ID of the policy group of the source VPC firewall. Valid values:
        # 
        # *   If the VPC firewall protects mutual access traffic between a VPC and a specified network instance that is attached to a Cloud Enterprise Network (CEN) instance, the value of this parameter is the ID of the CEN instance. The network instance can be a VPC, a virtual border router (VBR), or a Cloud Connect Network (CCN) instance.
        # *   If the VPC firewall protects traffic between two VPCs that are connected by using an Express Connect circuit, the value of this parameter is the instance ID of the VPC firewall.
        # 
        # >  You can call the [DescribeVpcFirewallAclGroupList](https://help.aliyun.com/document_detail/159760.html) operation to query the IDs of policy groups.
        # 
        # This parameter is required.
        self.source_vpc_firewall_id = source_vpc_firewall_id
        # The ID of the policy group of the destination VPC firewall. Valid values:
        # 
        # *   If the VPC firewall protects mutual access traffic between a VPC and a specified network instance that is attached to a CEN instance, the value of this parameter is the ID of the CEN instance. The network instance can be a VPC, a VBR, or a CCN instance.
        # *   If the VPC firewall protects traffic between two VPCs that are connected by using an Express Connect circuit, the value of this parameter is the instance ID of the VPC firewall.
        # 
        # >  You can call the [DescribeVpcFirewallAclGroupList](https://help.aliyun.com/document_detail/159760.html) operation to query the IDs of policy groups.
        # 
        # This parameter is required.
        self.target_vpc_firewall_id = target_vpc_firewall_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.source_vpc_firewall_id is not None:
            result['SourceVpcFirewallId'] = self.source_vpc_firewall_id
        if self.target_vpc_firewall_id is not None:
            result['TargetVpcFirewallId'] = self.target_vpc_firewall_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('SourceVpcFirewallId') is not None:
            self.source_vpc_firewall_id = m.get('SourceVpcFirewallId')
        if m.get('TargetVpcFirewallId') is not None:
            self.target_vpc_firewall_id = m.get('TargetVpcFirewallId')
        return self


class BatchCopyVpcFirewallControlPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchCopyVpcFirewallControlPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchCopyVpcFirewallControlPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchCopyVpcFirewallControlPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchDeleteVpcFirewallControlPolicyRequest(TeaModel):
    def __init__(
        self,
        acl_uuid_list: List[str] = None,
        vpc_firewall_id: str = None,
    ):
        # The UUIDs of access control policies.
        # 
        # This parameter is required.
        self.acl_uuid_list = acl_uuid_list
        # The instance ID of the VPC firewall.
        # 
        # This parameter is required.
        self.vpc_firewall_id = vpc_firewall_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_uuid_list is not None:
            result['AclUuidList'] = self.acl_uuid_list
        if self.vpc_firewall_id is not None:
            result['VpcFirewallId'] = self.vpc_firewall_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclUuidList') is not None:
            self.acl_uuid_list = m.get('AclUuidList')
        if m.get('VpcFirewallId') is not None:
            self.vpc_firewall_id = m.get('VpcFirewallId')
        return self


class BatchDeleteVpcFirewallControlPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchDeleteVpcFirewallControlPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchDeleteVpcFirewallControlPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchDeleteVpcFirewallControlPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAckClusterConnectorRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        connector_name: str = None,
        member_uid: str = None,
        primary_vswitch_id: str = None,
        primary_vswitch_ip: str = None,
        region_no: str = None,
        standby_vswitch_id: str = None,
        standby_vswitch_ip: str = None,
        ttl: str = None,
    ):
        # This parameter is required.
        self.cluster_id = cluster_id
        # This parameter is required.
        self.connector_name = connector_name
        self.member_uid = member_uid
        # This parameter is required.
        self.primary_vswitch_id = primary_vswitch_id
        self.primary_vswitch_ip = primary_vswitch_ip
        # This parameter is required.
        self.region_no = region_no
        self.standby_vswitch_id = standby_vswitch_id
        self.standby_vswitch_ip = standby_vswitch_ip
        # This parameter is required.
        self.ttl = ttl

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.connector_name is not None:
            result['ConnectorName'] = self.connector_name
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.primary_vswitch_id is not None:
            result['PrimaryVswitchId'] = self.primary_vswitch_id
        if self.primary_vswitch_ip is not None:
            result['PrimaryVswitchIp'] = self.primary_vswitch_ip
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.standby_vswitch_id is not None:
            result['StandbyVswitchId'] = self.standby_vswitch_id
        if self.standby_vswitch_ip is not None:
            result['StandbyVswitchIp'] = self.standby_vswitch_ip
        if self.ttl is not None:
            result['Ttl'] = self.ttl
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ConnectorName') is not None:
            self.connector_name = m.get('ConnectorName')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('PrimaryVswitchId') is not None:
            self.primary_vswitch_id = m.get('PrimaryVswitchId')
        if m.get('PrimaryVswitchIp') is not None:
            self.primary_vswitch_ip = m.get('PrimaryVswitchIp')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('StandbyVswitchId') is not None:
            self.standby_vswitch_id = m.get('StandbyVswitchId')
        if m.get('StandbyVswitchIp') is not None:
            self.standby_vswitch_ip = m.get('StandbyVswitchIp')
        if m.get('Ttl') is not None:
            self.ttl = m.get('Ttl')
        return self


class CreateAckClusterConnectorResponseBodyAckClusterConnector(TeaModel):
    def __init__(
        self,
        ack_client_host_ip: str = None,
        cluster_id: str = None,
        cluster_name: str = None,
        connector_health_check_status: str = None,
        connector_id: str = None,
        connector_name: str = None,
        connector_status: str = None,
        create_time: str = None,
        member_uid: str = None,
        primary_vswitch_id: str = None,
        primary_vswitch_ip: str = None,
        primary_vswitch_zone_id: str = None,
        region_no: str = None,
        standby_vswitch_id: str = None,
        standby_vswitch_ip: str = None,
        standby_vswitch_zone_id: str = None,
        task_id: str = None,
        ttl: int = None,
        vpc_id: str = None,
    ):
        self.ack_client_host_ip = ack_client_host_ip
        self.cluster_id = cluster_id
        self.cluster_name = cluster_name
        self.connector_health_check_status = connector_health_check_status
        self.connector_id = connector_id
        self.connector_name = connector_name
        self.connector_status = connector_status
        self.create_time = create_time
        self.member_uid = member_uid
        self.primary_vswitch_id = primary_vswitch_id
        self.primary_vswitch_ip = primary_vswitch_ip
        self.primary_vswitch_zone_id = primary_vswitch_zone_id
        self.region_no = region_no
        self.standby_vswitch_id = standby_vswitch_id
        self.standby_vswitch_ip = standby_vswitch_ip
        self.standby_vswitch_zone_id = standby_vswitch_zone_id
        self.task_id = task_id
        self.ttl = ttl
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ack_client_host_ip is not None:
            result['AckClientHostIp'] = self.ack_client_host_ip
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.connector_health_check_status is not None:
            result['ConnectorHealthCheckStatus'] = self.connector_health_check_status
        if self.connector_id is not None:
            result['ConnectorId'] = self.connector_id
        if self.connector_name is not None:
            result['ConnectorName'] = self.connector_name
        if self.connector_status is not None:
            result['ConnectorStatus'] = self.connector_status
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.primary_vswitch_id is not None:
            result['PrimaryVswitchId'] = self.primary_vswitch_id
        if self.primary_vswitch_ip is not None:
            result['PrimaryVswitchIp'] = self.primary_vswitch_ip
        if self.primary_vswitch_zone_id is not None:
            result['PrimaryVswitchZoneId'] = self.primary_vswitch_zone_id
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.standby_vswitch_id is not None:
            result['StandbyVswitchId'] = self.standby_vswitch_id
        if self.standby_vswitch_ip is not None:
            result['StandbyVswitchIp'] = self.standby_vswitch_ip
        if self.standby_vswitch_zone_id is not None:
            result['StandbyVswitchZoneId'] = self.standby_vswitch_zone_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.ttl is not None:
            result['Ttl'] = self.ttl
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AckClientHostIp') is not None:
            self.ack_client_host_ip = m.get('AckClientHostIp')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ConnectorHealthCheckStatus') is not None:
            self.connector_health_check_status = m.get('ConnectorHealthCheckStatus')
        if m.get('ConnectorId') is not None:
            self.connector_id = m.get('ConnectorId')
        if m.get('ConnectorName') is not None:
            self.connector_name = m.get('ConnectorName')
        if m.get('ConnectorStatus') is not None:
            self.connector_status = m.get('ConnectorStatus')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('PrimaryVswitchId') is not None:
            self.primary_vswitch_id = m.get('PrimaryVswitchId')
        if m.get('PrimaryVswitchIp') is not None:
            self.primary_vswitch_ip = m.get('PrimaryVswitchIp')
        if m.get('PrimaryVswitchZoneId') is not None:
            self.primary_vswitch_zone_id = m.get('PrimaryVswitchZoneId')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('StandbyVswitchId') is not None:
            self.standby_vswitch_id = m.get('StandbyVswitchId')
        if m.get('StandbyVswitchIp') is not None:
            self.standby_vswitch_ip = m.get('StandbyVswitchIp')
        if m.get('StandbyVswitchZoneId') is not None:
            self.standby_vswitch_zone_id = m.get('StandbyVswitchZoneId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Ttl') is not None:
            self.ttl = m.get('Ttl')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class CreateAckClusterConnectorResponseBody(TeaModel):
    def __init__(
        self,
        ack_cluster_connector: CreateAckClusterConnectorResponseBodyAckClusterConnector = None,
        request_id: str = None,
    ):
        self.ack_cluster_connector = ack_cluster_connector
        self.request_id = request_id

    def validate(self):
        if self.ack_cluster_connector:
            self.ack_cluster_connector.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ack_cluster_connector is not None:
            result['AckClusterConnector'] = self.ack_cluster_connector.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AckClusterConnector') is not None:
            temp_model = CreateAckClusterConnectorResponseBodyAckClusterConnector()
            self.ack_cluster_connector = temp_model.from_map(m['AckClusterConnector'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAckClusterConnectorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAckClusterConnectorResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAckClusterConnectorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAclCheckRequest(TeaModel):
    def __init__(
        self,
        acl_type: str = None,
        check_names: List[str] = None,
        lang: str = None,
    ):
        # This parameter is required.
        self.acl_type = acl_type
        self.check_names = check_names
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_type is not None:
            result['AclType'] = self.acl_type
        if self.check_names is not None:
            result['CheckNames'] = self.check_names
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclType') is not None:
            self.acl_type = m.get('AclType')
        if m.get('CheckNames') is not None:
            self.check_names = m.get('CheckNames')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class CreateAclCheckResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        task_ids: List[str] = None,
    ):
        self.request_id = request_id
        self.task_ids = task_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_ids is not None:
            result['TaskIds'] = self.task_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskIds') is not None:
            self.task_ids = m.get('TaskIds')
        return self


class CreateAclCheckResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAclCheckResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAclCheckResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDownloadTaskRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        task_data: str = None,
        task_type: str = None,
        time_zone: str = None,
    ):
        # The language of the content within the response.
        # 
        # Valid values:
        # 
        # *   **zh**: Chinese (default)
        # *   **en**: English
        self.lang = lang
        # The query condition of the download task.
        self.task_data = task_data
        # The type of the task. For more information about task types, see the descriptions in the "DescribeDownloadTaskType" topic.
        self.task_type = task_type
        # The time zone of the time information in the downloaded file. The value must be an identifier of a time zone in the Internet Assigned Numbers Authority (IANA) database. The default value is Asia/Shanghai, which indicates UTC+8.
        self.time_zone = time_zone

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.task_data is not None:
            result['TaskData'] = self.task_data
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        if self.time_zone is not None:
            result['TimeZone'] = self.time_zone
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('TaskData') is not None:
            self.task_data = m.get('TaskData')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        if m.get('TimeZone') is not None:
            self.time_zone = m.get('TimeZone')
        return self


class CreateDownloadTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        status: str = None,
        task_id: int = None,
        task_name: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The status of the task. Valid values:
        # 
        # finish: The task finished. You can query the task to obtain the download link of the file.
        # 
        # start: The task start.
        # 
        # error: An error occurred.
        # 
        # expire: The task file is invalid and cannot be downloaded.
        self.status = status
        # The unique ID of the task.
        self.task_id = task_id
        # The name of the file download task.
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class CreateDownloadTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateDownloadTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDownloadTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNatFirewallControlPolicyRequest(TeaModel):
    def __init__(
        self,
        acl_action: str = None,
        application_name_list: List[str] = None,
        description: str = None,
        dest_port: str = None,
        dest_port_group: str = None,
        dest_port_type: str = None,
        destination: str = None,
        destination_type: str = None,
        direction: str = None,
        domain_resolve_type: int = None,
        end_time: int = None,
        ip_version: str = None,
        lang: str = None,
        nat_gateway_id: str = None,
        new_order: str = None,
        proto: str = None,
        release: str = None,
        repeat_days: List[int] = None,
        repeat_end_time: str = None,
        repeat_start_time: str = None,
        repeat_type: str = None,
        source: str = None,
        source_type: str = None,
        start_time: int = None,
    ):
        # The action that Cloud Firewall performs on the traffic.
        # 
        # Valid values:
        # 
        # *   **accept**: allows the traffic.
        # *   **drop**: denies the traffic.
        # *   **log**: monitors the traffic.
        # 
        # This parameter is required.
        self.acl_action = acl_action
        # The application types supported by the access control policy.
        # 
        # This parameter is required.
        self.application_name_list = application_name_list
        # The description of the access control policy.
        # 
        # This parameter is required.
        self.description = description
        # The destination port in the access control policy. Valid values:
        # 
        # *   If Proto is set to ICMP, DestPort is automatically left empty.
        # 
        # > If Proto is set to ICMP, access control does not take effect on the destination port.
        # 
        # *   If Proto is set to TCP, UDP, or ANY and DestPortType is set to group, DestPort is empty.
        # 
        # > If DestPortType is set to group, you do not need to specify the destination port number. All ports on which the access control policy takes effect are included in the destination port address book.
        # 
        # *   If Proto is set to TCP, UDP, or ANY and DestPortType is set to port, the value of DestPort is the destination port number.
        self.dest_port = dest_port
        # The name of the destination port address book in the access control policy.
        # 
        # > If DestPortType is set to group, you must specify the name of the destination port address book.
        self.dest_port_group = dest_port_group
        # The type of the destination port in the access control policy. Valid values:
        # 
        # *   **port**: port
        # *   **group**: port address book
        self.dest_port_type = dest_port_type
        # The destination address in the access control policy.
        # 
        # Valid values:
        # 
        # *   If DestinationType is set to net, the value of this parameter is a CIDR block.
        # 
        #     Example: 1.2.XX.XX/24
        # 
        # *   If DestinationType is set to group, the value of this parameter is an address book.
        # 
        #     Example: db_group
        # 
        # *   If DestinationType is set to domain, the value of this parameter is a domain name.
        # 
        #     Example: \\*.aliyuncs.com
        # 
        # *   If DestinationType is set to location, the value of this parameter is a location.
        # 
        #     Example: ["BJ11", "ZB"]
        # 
        # This parameter is required.
        self.destination = destination
        # The type of the destination address in the access control policy.
        # 
        # Valid values:
        # 
        # *   **net**: CIDR block
        # *   **group**: address book
        # *   **domain**: domain name
        # 
        # This parameter is required.
        self.destination_type = destination_type
        # The direction of the traffic to which the access control policy applies. Valid value:
        # 
        # *   **out**: outbound.
        # 
        # This parameter is required.
        self.direction = direction
        # The domain name resolution method of the access control policy. Valid values:
        # 
        # *   **0**: fully qualified domain name (FQDN)-based resolution
        # *   **1**: Domain Name System (DNS)-based dynamic resolution
        # *   **2**: FQDN and DNS-based dynamic resolution
        self.domain_resolve_type = domain_resolve_type
        # The time when the access control policy stops taking effect. The value is a UNIX timestamp. Unit: seconds. The value must be on the hour or on the half hour, and at least 30 minutes later than the value of StartTime.
        # 
        # >  If RepeatType is set to Permanent, EndTime is left empty. If RepeatType is set to None, Daily, Weekly, or Monthly, this parameter must be specified.
        self.end_time = end_time
        # The IP version supported by the access control policy. Valid values:
        # 
        # *   **4**: IPv4 (default)
        self.ip_version = ip_version
        # The language of the content within the response.
        # 
        # Valid values:
        # 
        # *   **zh**: Chinese (default)
        # *   **en**: English
        self.lang = lang
        # The ID of the NAT gateway.
        # 
        # This parameter is required.
        self.nat_gateway_id = nat_gateway_id
        # The priority of the access control policy. The priority value starts from 1. A small priority value indicates a high priority.
        # 
        # This parameter is required.
        self.new_order = new_order
        # The protocol type in the access control policy.
        # 
        # Valid values:
        # 
        # *   ANY: all types of protocols.
        # *   TCP
        # *   UDP
        # *   ICMP
        # 
        # >  If the destination address is a threat intelligence address book of the domain name type or a cloud service address book, you can set Proto only to TCP and set ApplicationNameList to HTTP, HTTPS, SMTP, SMTPS, or SSL.
        # 
        # This parameter is required.
        self.proto = proto
        # Specifies whether to enable the access control policy. By default, an access control policy is enabled after it is created. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.release = release
        # The days of a week or of a month on which the access control policy takes effect.
        # 
        # *   If RepeatType is set to `Permanent`, `None`, or `Daily`, RepeatDays is left empty. Example: [].
        # *   If RepeatType is set to Weekly, RepeatDays must be specified. Example: [0, 6].
        # 
        # >  If RepeatType is set to Weekly, the fields in the value of RepeatDays cannot be repeated.
        # 
        # *   If RepeatType is set to `Monthly`, RepeatDays must be specified. Example: [1, 31].
        # 
        # >  If RepeatType is set to Monthly, the fields in the value of RepeatDays cannot be repeated.
        self.repeat_days = repeat_days
        # The point in time when the recurrence ends. Example: 23:30. The value must be on the hour or on the half hour, and at least 30 minutes later than the value of RepeatStartTime.
        # 
        # >  If RepeatType is set to Permanent or None, RepeatEndTime is left empty. If RepeatType is set to Daily, Weekly, or Monthly, this parameter must be specified.
        self.repeat_end_time = repeat_end_time
        # The point in time when the recurrence starts. Example: 08:00. The value must be on the hour or on the half hour, and at least 30 minutes earlier than the value of RepeatEndTime.
        # 
        # >  If RepeatType is set to Permanent or None, RepeatStartTime is left empty. If RepeatType is set to Daily, Weekly, or Monthly, this parameter must be specified.
        self.repeat_start_time = repeat_start_time
        # The recurrence type for the access control policy to take effect. Valid values:
        # 
        # *   **Permanent** (default): The policy always takes effect.
        # *   **None**: The policy takes effect for only once.
        # *   **Daily**: The policy takes effect on a daily basis.
        # *   **Weekly**: The policy takes effect on a weekly basis.
        # *   **Monthly**: The policy takes effect on a monthly basis.
        self.repeat_type = repeat_type
        # The source address in the access control policy.
        # 
        # Valid values:
        # 
        # *   If **SourceType** is set to `net`, the value of Source is a CIDR block.
        # 
        #     Example: 10.2.4.0/24
        # 
        # *   If **SourceType** is set to `group`, the value of this parameter must be an address book name.
        # 
        #     Example: db_group
        # 
        # This parameter is required.
        self.source = source
        # The type of the source address in the access control policy.
        # 
        # Valid values:
        # 
        # *   **net**: source CIDR block
        # *   **group**: source address book
        # 
        # This parameter is required.
        self.source_type = source_type
        # The time when the access control policy starts to take effect. The value is a UNIX timestamp. Unit: seconds. The value must be on the hour or on the half hour, and at least 30 minutes earlier than the value of EndTime.
        # 
        # >  If RepeatType is set to Permanent, StartTime is left empty. If RepeatType is set to None, Daily, Weekly, or Monthly, this parameter must be specified.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_action is not None:
            result['AclAction'] = self.acl_action
        if self.application_name_list is not None:
            result['ApplicationNameList'] = self.application_name_list
        if self.description is not None:
            result['Description'] = self.description
        if self.dest_port is not None:
            result['DestPort'] = self.dest_port
        if self.dest_port_group is not None:
            result['DestPortGroup'] = self.dest_port_group
        if self.dest_port_type is not None:
            result['DestPortType'] = self.dest_port_type
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.destination_type is not None:
            result['DestinationType'] = self.destination_type
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.domain_resolve_type is not None:
            result['DomainResolveType'] = self.domain_resolve_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.ip_version is not None:
            result['IpVersion'] = self.ip_version
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.new_order is not None:
            result['NewOrder'] = self.new_order
        if self.proto is not None:
            result['Proto'] = self.proto
        if self.release is not None:
            result['Release'] = self.release
        if self.repeat_days is not None:
            result['RepeatDays'] = self.repeat_days
        if self.repeat_end_time is not None:
            result['RepeatEndTime'] = self.repeat_end_time
        if self.repeat_start_time is not None:
            result['RepeatStartTime'] = self.repeat_start_time
        if self.repeat_type is not None:
            result['RepeatType'] = self.repeat_type
        if self.source is not None:
            result['Source'] = self.source
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclAction') is not None:
            self.acl_action = m.get('AclAction')
        if m.get('ApplicationNameList') is not None:
            self.application_name_list = m.get('ApplicationNameList')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestPort') is not None:
            self.dest_port = m.get('DestPort')
        if m.get('DestPortGroup') is not None:
            self.dest_port_group = m.get('DestPortGroup')
        if m.get('DestPortType') is not None:
            self.dest_port_type = m.get('DestPortType')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('DestinationType') is not None:
            self.destination_type = m.get('DestinationType')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('DomainResolveType') is not None:
            self.domain_resolve_type = m.get('DomainResolveType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IpVersion') is not None:
            self.ip_version = m.get('IpVersion')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('NewOrder') is not None:
            self.new_order = m.get('NewOrder')
        if m.get('Proto') is not None:
            self.proto = m.get('Proto')
        if m.get('Release') is not None:
            self.release = m.get('Release')
        if m.get('RepeatDays') is not None:
            self.repeat_days = m.get('RepeatDays')
        if m.get('RepeatEndTime') is not None:
            self.repeat_end_time = m.get('RepeatEndTime')
        if m.get('RepeatStartTime') is not None:
            self.repeat_start_time = m.get('RepeatStartTime')
        if m.get('RepeatType') is not None:
            self.repeat_type = m.get('RepeatType')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class CreateNatFirewallControlPolicyResponseBody(TeaModel):
    def __init__(
        self,
        acl_uuid: str = None,
        request_id: str = None,
    ):
        # The unique ID of the access control policy.
        # 
        # >  To modify an access control policy, you must specify the unique ID of the policy. You can call the DescribeNatFirewallControlPolicy operation to obtain the ID.
        self.acl_uuid = acl_uuid
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_uuid is not None:
            result['AclUuid'] = self.acl_uuid
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclUuid') is not None:
            self.acl_uuid = m.get('AclUuid')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateNatFirewallControlPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateNatFirewallControlPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateNatFirewallControlPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNatFirewallPreCheckRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        nat_gateway_id: str = None,
        region_no: str = None,
        vpc_id: str = None,
    ):
        self.lang = lang
        # This parameter is required.
        self.nat_gateway_id = nat_gateway_id
        # This parameter is required.
        self.region_no = region_no
        # This parameter is required.
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class CreateNatFirewallPreCheckResponseBody(TeaModel):
    def __init__(
        self,
        pre_check_id: str = None,
        request_id: str = None,
    ):
        self.pre_check_id = pre_check_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pre_check_id is not None:
            result['PreCheckId'] = self.pre_check_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PreCheckId') is not None:
            self.pre_check_id = m.get('PreCheckId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateNatFirewallPreCheckResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateNatFirewallPreCheckResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateNatFirewallPreCheckResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePrivateDnsEndpointRequest(TeaModel):
    def __init__(
        self,
        access_instance_name: str = None,
        firewall_type: List[str] = None,
        ip_protocol: str = None,
        member_uid: int = None,
        port: int = None,
        primary_dns: str = None,
        primary_vswitch_id: str = None,
        primary_vswitch_ip: str = None,
        private_dns_type: str = None,
        region_no: str = None,
        standby_dns: str = None,
        standby_vswitch_id: str = None,
        standby_vswitch_ip: str = None,
        vpc_id: str = None,
    ):
        # This parameter is required.
        self.access_instance_name = access_instance_name
        # This parameter is required.
        self.firewall_type = firewall_type
        self.ip_protocol = ip_protocol
        self.member_uid = member_uid
        self.port = port
        self.primary_dns = primary_dns
        self.primary_vswitch_id = primary_vswitch_id
        self.primary_vswitch_ip = primary_vswitch_ip
        # This parameter is required.
        self.private_dns_type = private_dns_type
        # This parameter is required.
        self.region_no = region_no
        self.standby_dns = standby_dns
        self.standby_vswitch_id = standby_vswitch_id
        self.standby_vswitch_ip = standby_vswitch_ip
        # This parameter is required.
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_instance_name is not None:
            result['AccessInstanceName'] = self.access_instance_name
        if self.firewall_type is not None:
            result['FirewallType'] = self.firewall_type
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.port is not None:
            result['Port'] = self.port
        if self.primary_dns is not None:
            result['PrimaryDns'] = self.primary_dns
        if self.primary_vswitch_id is not None:
            result['PrimaryVSwitchId'] = self.primary_vswitch_id
        if self.primary_vswitch_ip is not None:
            result['PrimaryVSwitchIp'] = self.primary_vswitch_ip
        if self.private_dns_type is not None:
            result['PrivateDnsType'] = self.private_dns_type
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.standby_dns is not None:
            result['StandbyDns'] = self.standby_dns
        if self.standby_vswitch_id is not None:
            result['StandbyVSwitchId'] = self.standby_vswitch_id
        if self.standby_vswitch_ip is not None:
            result['StandbyVSwitchIp'] = self.standby_vswitch_ip
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessInstanceName') is not None:
            self.access_instance_name = m.get('AccessInstanceName')
        if m.get('FirewallType') is not None:
            self.firewall_type = m.get('FirewallType')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('PrimaryDns') is not None:
            self.primary_dns = m.get('PrimaryDns')
        if m.get('PrimaryVSwitchId') is not None:
            self.primary_vswitch_id = m.get('PrimaryVSwitchId')
        if m.get('PrimaryVSwitchIp') is not None:
            self.primary_vswitch_ip = m.get('PrimaryVSwitchIp')
        if m.get('PrivateDnsType') is not None:
            self.private_dns_type = m.get('PrivateDnsType')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('StandbyDns') is not None:
            self.standby_dns = m.get('StandbyDns')
        if m.get('StandbyVSwitchId') is not None:
            self.standby_vswitch_id = m.get('StandbyVSwitchId')
        if m.get('StandbyVSwitchIp') is not None:
            self.standby_vswitch_ip = m.get('StandbyVSwitchIp')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class CreatePrivateDnsEndpointResponseBody(TeaModel):
    def __init__(
        self,
        access_instance_id: str = None,
        request_id: str = None,
        task_id: str = None,
    ):
        self.access_instance_id = access_instance_id
        # Id of the request
        self.request_id = request_id
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_instance_id is not None:
            result['AccessInstanceId'] = self.access_instance_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessInstanceId') is not None:
            self.access_instance_id = m.get('AccessInstanceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreatePrivateDnsEndpointResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreatePrivateDnsEndpointResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreatePrivateDnsEndpointResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSecurityProxyRequestNatRouteEntryList(TeaModel):
    def __init__(
        self,
        destination_cidr: str = None,
        next_hop_id: str = None,
        next_hop_type: str = None,
        route_table_id: str = None,
    ):
        # The destination CIDR block of the default route.
        # 
        # This parameter is required.
        self.destination_cidr = destination_cidr
        # The next hop of the original NAT gateway.
        # 
        # This parameter is required.
        self.next_hop_id = next_hop_id
        # The network type of the next hop. Set the value to NatGateway.
        # 
        # This parameter is required.
        self.next_hop_type = next_hop_type
        # The route table to which the default route of the NAT gateway belongs.
        # 
        # This parameter is required.
        self.route_table_id = route_table_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_cidr is not None:
            result['DestinationCidr'] = self.destination_cidr
        if self.next_hop_id is not None:
            result['NextHopId'] = self.next_hop_id
        if self.next_hop_type is not None:
            result['NextHopType'] = self.next_hop_type
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DestinationCidr') is not None:
            self.destination_cidr = m.get('DestinationCidr')
        if m.get('NextHopId') is not None:
            self.next_hop_id = m.get('NextHopId')
        if m.get('NextHopType') is not None:
            self.next_hop_type = m.get('NextHopType')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        return self


class CreateSecurityProxyRequest(TeaModel):
    def __init__(
        self,
        firewall_switch: str = None,
        lang: str = None,
        nat_gateway_id: str = None,
        nat_route_entry_list: List[CreateSecurityProxyRequestNatRouteEntryList] = None,
        proxy_name: str = None,
        region_no: str = None,
        strict_mode: int = None,
        vpc_id: str = None,
        vswitch_auto: str = None,
        vswitch_cidr: str = None,
        vswitch_id: str = None,
    ):
        # The status of the NAT firewall. Valid values:
        # 
        # *   **open**: enabled
        # *   **close**: disabled
        self.firewall_switch = firewall_switch
        # The language of the content within the response. Valid values:
        # 
        # *   **zh** (default): Chinese
        # *   **en**: English
        self.lang = lang
        # The ID of the NAT gateway.
        # 
        # This parameter is required.
        self.nat_gateway_id = nat_gateway_id
        # The routes to be switched to the NAT gateway.
        # 
        # This parameter is required.
        self.nat_route_entry_list = nat_route_entry_list
        # The name of the NAT firewall. The name must be 4 to 50 characters in length, and can contain letters, digits, and underscores (_). However, it cannot start with an underscore.
        # 
        # This parameter is required.
        self.proxy_name = proxy_name
        # The region ID of the virtual private cloud (VPC).
        # 
        # >  For more information about Cloud Firewall supported regions, see [Supported regions](https://help.aliyun.com/document_detail/195657.html).
        # 
        # This parameter is required.
        self.region_no = region_no
        # Specifies whether to enable the strict mode. Valid values:
        # 
        # *   1: yes
        # *   0: no
        self.strict_mode = strict_mode
        # The ID of the VPC.
        # 
        # This parameter is required.
        self.vpc_id = vpc_id
        # The mode of the vSwitch that you want to use. Valid values:
        # 
        # *   **true**: automatic
        # *   **false**: manual
        self.vswitch_auto = vswitch_auto
        # The CIDR block of the vSwitch.
        self.vswitch_cidr = vswitch_cidr
        # The ID of the vSwitch. This parameter is required if you set the VswitchAuto parameter to true.
        self.vswitch_id = vswitch_id

    def validate(self):
        if self.nat_route_entry_list:
            for k in self.nat_route_entry_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.firewall_switch is not None:
            result['FirewallSwitch'] = self.firewall_switch
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        result['NatRouteEntryList'] = []
        if self.nat_route_entry_list is not None:
            for k in self.nat_route_entry_list:
                result['NatRouteEntryList'].append(k.to_map() if k else None)
        if self.proxy_name is not None:
            result['ProxyName'] = self.proxy_name
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.strict_mode is not None:
            result['StrictMode'] = self.strict_mode
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vswitch_auto is not None:
            result['VswitchAuto'] = self.vswitch_auto
        if self.vswitch_cidr is not None:
            result['VswitchCidr'] = self.vswitch_cidr
        if self.vswitch_id is not None:
            result['VswitchId'] = self.vswitch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FirewallSwitch') is not None:
            self.firewall_switch = m.get('FirewallSwitch')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        self.nat_route_entry_list = []
        if m.get('NatRouteEntryList') is not None:
            for k in m.get('NatRouteEntryList'):
                temp_model = CreateSecurityProxyRequestNatRouteEntryList()
                self.nat_route_entry_list.append(temp_model.from_map(k))
        if m.get('ProxyName') is not None:
            self.proxy_name = m.get('ProxyName')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('StrictMode') is not None:
            self.strict_mode = m.get('StrictMode')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VswitchAuto') is not None:
            self.vswitch_auto = m.get('VswitchAuto')
        if m.get('VswitchCidr') is not None:
            self.vswitch_cidr = m.get('VswitchCidr')
        if m.get('VswitchId') is not None:
            self.vswitch_id = m.get('VswitchId')
        return self


class CreateSecurityProxyResponseBody(TeaModel):
    def __init__(
        self,
        proxy_id: str = None,
        request_id: str = None,
    ):
        # The ID of the NAT firewall.
        self.proxy_id = proxy_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.proxy_id is not None:
            result['ProxyId'] = self.proxy_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProxyId') is not None:
            self.proxy_id = m.get('ProxyId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateSecurityProxyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSecurityProxyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSecurityProxyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSlsLogDispatchRequest(TeaModel):
    def __init__(
        self,
        sls_region_id: str = None,
        ttl: int = None,
    ):
        # The region ID of the Simple Log Service project.
        self.sls_region_id = sls_region_id
        # The log retention period. Unit: days.
        self.ttl = ttl

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.sls_region_id is not None:
            result['SlsRegionId'] = self.sls_region_id
        if self.ttl is not None:
            result['Ttl'] = self.ttl
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SlsRegionId') is not None:
            self.sls_region_id = m.get('SlsRegionId')
        if m.get('Ttl') is not None:
            self.ttl = m.get('Ttl')
        return self


class CreateSlsLogDispatchResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateSlsLogDispatchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSlsLogDispatchResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSlsLogDispatchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTrFirewallV2Request(TeaModel):
    def __init__(
        self,
        cen_id: str = None,
        firewall_description: str = None,
        firewall_name: str = None,
        firewall_subnet_cidr: str = None,
        firewall_vpc_cidr: str = None,
        firewall_vpc_id: str = None,
        firewall_vswitch_id: str = None,
        lang: str = None,
        region_no: str = None,
        route_mode: str = None,
        tr_attachment_master_cidr: str = None,
        tr_attachment_master_zone: str = None,
        tr_attachment_slave_cidr: str = None,
        tr_attachment_slave_zone: str = None,
        transit_router_id: str = None,
    ):
        # The ID of the Cloud Enterprise Network (CEN) instance.
        self.cen_id = cen_id
        # The description of the firewall.
        self.firewall_description = firewall_description
        # The name of the firewall.
        self.firewall_name = firewall_name
        # The subnet CIDR block of the VPC in which the ENI of the firewall is stored in automatic mode.
        self.firewall_subnet_cidr = firewall_subnet_cidr
        # The CIDR block that is allocated to the VPC created for the VPC firewall in automatic mode.
        self.firewall_vpc_cidr = firewall_vpc_cidr
        # The ID of the VPC in which the ENI associated with the VPC firewall is created in manual mode.
        self.firewall_vpc_id = firewall_vpc_id
        # The ID of the vSwitch that is used to create the ENI in manual mode.
        self.firewall_vswitch_id = firewall_vswitch_id
        # The language of the content within the response. Valid values:
        # 
        # *   **zh**: Chinese (default)
        # *   **en**: English
        self.lang = lang
        # The region ID of the route router.
        self.region_no = region_no
        # The routing mode of the VPC firewall. Valid values:
        # 
        # *   **managed**: automatic mode
        # *   **manual**: manual mode
        self.route_mode = route_mode
        # The primary subnet CIDR block that the VPC uses to connect to the transit router in automatic mode.
        self.tr_attachment_master_cidr = tr_attachment_master_cidr
        # The primary zone for the vSwitch.
        self.tr_attachment_master_zone = tr_attachment_master_zone
        # The secondary subnet CIDR block that the VPC uses to connect to the transit router in automatic mode.
        self.tr_attachment_slave_cidr = tr_attachment_slave_cidr
        # The secondary zone for the vSwitch.
        self.tr_attachment_slave_zone = tr_attachment_slave_zone
        # The ID of the transit router.
        self.transit_router_id = transit_router_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.firewall_description is not None:
            result['FirewallDescription'] = self.firewall_description
        if self.firewall_name is not None:
            result['FirewallName'] = self.firewall_name
        if self.firewall_subnet_cidr is not None:
            result['FirewallSubnetCidr'] = self.firewall_subnet_cidr
        if self.firewall_vpc_cidr is not None:
            result['FirewallVpcCidr'] = self.firewall_vpc_cidr
        if self.firewall_vpc_id is not None:
            result['FirewallVpcId'] = self.firewall_vpc_id
        if self.firewall_vswitch_id is not None:
            result['FirewallVswitchId'] = self.firewall_vswitch_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.route_mode is not None:
            result['RouteMode'] = self.route_mode
        if self.tr_attachment_master_cidr is not None:
            result['TrAttachmentMasterCidr'] = self.tr_attachment_master_cidr
        if self.tr_attachment_master_zone is not None:
            result['TrAttachmentMasterZone'] = self.tr_attachment_master_zone
        if self.tr_attachment_slave_cidr is not None:
            result['TrAttachmentSlaveCidr'] = self.tr_attachment_slave_cidr
        if self.tr_attachment_slave_zone is not None:
            result['TrAttachmentSlaveZone'] = self.tr_attachment_slave_zone
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('FirewallDescription') is not None:
            self.firewall_description = m.get('FirewallDescription')
        if m.get('FirewallName') is not None:
            self.firewall_name = m.get('FirewallName')
        if m.get('FirewallSubnetCidr') is not None:
            self.firewall_subnet_cidr = m.get('FirewallSubnetCidr')
        if m.get('FirewallVpcCidr') is not None:
            self.firewall_vpc_cidr = m.get('FirewallVpcCidr')
        if m.get('FirewallVpcId') is not None:
            self.firewall_vpc_id = m.get('FirewallVpcId')
        if m.get('FirewallVswitchId') is not None:
            self.firewall_vswitch_id = m.get('FirewallVswitchId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('RouteMode') is not None:
            self.route_mode = m.get('RouteMode')
        if m.get('TrAttachmentMasterCidr') is not None:
            self.tr_attachment_master_cidr = m.get('TrAttachmentMasterCidr')
        if m.get('TrAttachmentMasterZone') is not None:
            self.tr_attachment_master_zone = m.get('TrAttachmentMasterZone')
        if m.get('TrAttachmentSlaveCidr') is not None:
            self.tr_attachment_slave_cidr = m.get('TrAttachmentSlaveCidr')
        if m.get('TrAttachmentSlaveZone') is not None:
            self.tr_attachment_slave_zone = m.get('TrAttachmentSlaveZone')
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        return self


class CreateTrFirewallV2ResponseBody(TeaModel):
    def __init__(
        self,
        firewall_id: str = None,
        request_id: str = None,
    ):
        # The instance ID of the VPC firewall.
        self.firewall_id = firewall_id
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.firewall_id is not None:
            result['FirewallId'] = self.firewall_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FirewallId') is not None:
            self.firewall_id = m.get('FirewallId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateTrFirewallV2Response(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateTrFirewallV2ResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTrFirewallV2ResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTrFirewallV2RoutePolicyRequestDestCandidateList(TeaModel):
    def __init__(
        self,
        candidate_id: str = None,
        candidate_type: str = None,
    ):
        # The ID of the traffic redirection instance.
        self.candidate_id = candidate_id
        # The type of the traffic redirection instance.
        self.candidate_type = candidate_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.candidate_id is not None:
            result['CandidateId'] = self.candidate_id
        if self.candidate_type is not None:
            result['CandidateType'] = self.candidate_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CandidateId') is not None:
            self.candidate_id = m.get('CandidateId')
        if m.get('CandidateType') is not None:
            self.candidate_type = m.get('CandidateType')
        return self


class CreateTrFirewallV2RoutePolicyRequestSrcCandidateList(TeaModel):
    def __init__(
        self,
        candidate_id: str = None,
        candidate_type: str = None,
    ):
        # The ID of the traffic redirection instance.
        self.candidate_id = candidate_id
        # The type of the traffic redirection instance.
        self.candidate_type = candidate_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.candidate_id is not None:
            result['CandidateId'] = self.candidate_id
        if self.candidate_type is not None:
            result['CandidateType'] = self.candidate_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CandidateId') is not None:
            self.candidate_id = m.get('CandidateId')
        if m.get('CandidateType') is not None:
            self.candidate_type = m.get('CandidateType')
        return self


class CreateTrFirewallV2RoutePolicyRequest(TeaModel):
    def __init__(
        self,
        dest_candidate_list: List[CreateTrFirewallV2RoutePolicyRequestDestCandidateList] = None,
        firewall_id: str = None,
        lang: str = None,
        policy_description: str = None,
        policy_name: str = None,
        policy_type: str = None,
        src_candidate_list: List[CreateTrFirewallV2RoutePolicyRequestSrcCandidateList] = None,
    ):
        # The secondary traffic redirection instances.
        self.dest_candidate_list = dest_candidate_list
        # The instance ID of the VPC firewall.
        self.firewall_id = firewall_id
        # The language of the content within the response. Valid values:
        # 
        # *   **zh** (default): Chinese
        # *   **en**: English
        self.lang = lang
        # The description of the traffic redirection instance.
        self.policy_description = policy_description
        # The name of the traffic redirection instance.
        self.policy_name = policy_name
        # The type of the traffic redirection scenario of the VPC firewall. Valid values:
        # 
        # *   **fullmesh**: interconnected instances
        # *   **one_to_one**: instance to instance
        # *   **end_to_end**: instance to instances
        self.policy_type = policy_type
        # The primary traffic redirection instances.
        self.src_candidate_list = src_candidate_list

    def validate(self):
        if self.dest_candidate_list:
            for k in self.dest_candidate_list:
                if k:
                    k.validate()
        if self.src_candidate_list:
            for k in self.src_candidate_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DestCandidateList'] = []
        if self.dest_candidate_list is not None:
            for k in self.dest_candidate_list:
                result['DestCandidateList'].append(k.to_map() if k else None)
        if self.firewall_id is not None:
            result['FirewallId'] = self.firewall_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.policy_description is not None:
            result['PolicyDescription'] = self.policy_description
        if self.policy_name is not None:
            result['PolicyName'] = self.policy_name
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        result['SrcCandidateList'] = []
        if self.src_candidate_list is not None:
            for k in self.src_candidate_list:
                result['SrcCandidateList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dest_candidate_list = []
        if m.get('DestCandidateList') is not None:
            for k in m.get('DestCandidateList'):
                temp_model = CreateTrFirewallV2RoutePolicyRequestDestCandidateList()
                self.dest_candidate_list.append(temp_model.from_map(k))
        if m.get('FirewallId') is not None:
            self.firewall_id = m.get('FirewallId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PolicyDescription') is not None:
            self.policy_description = m.get('PolicyDescription')
        if m.get('PolicyName') is not None:
            self.policy_name = m.get('PolicyName')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        self.src_candidate_list = []
        if m.get('SrcCandidateList') is not None:
            for k in m.get('SrcCandidateList'):
                temp_model = CreateTrFirewallV2RoutePolicyRequestSrcCandidateList()
                self.src_candidate_list.append(temp_model.from_map(k))
        return self


class CreateTrFirewallV2RoutePolicyShrinkRequest(TeaModel):
    def __init__(
        self,
        dest_candidate_list_shrink: str = None,
        firewall_id: str = None,
        lang: str = None,
        policy_description: str = None,
        policy_name: str = None,
        policy_type: str = None,
        src_candidate_list_shrink: str = None,
    ):
        # The secondary traffic redirection instances.
        self.dest_candidate_list_shrink = dest_candidate_list_shrink
        # The instance ID of the VPC firewall.
        self.firewall_id = firewall_id
        # The language of the content within the response. Valid values:
        # 
        # *   **zh** (default): Chinese
        # *   **en**: English
        self.lang = lang
        # The description of the traffic redirection instance.
        self.policy_description = policy_description
        # The name of the traffic redirection instance.
        self.policy_name = policy_name
        # The type of the traffic redirection scenario of the VPC firewall. Valid values:
        # 
        # *   **fullmesh**: interconnected instances
        # *   **one_to_one**: instance to instance
        # *   **end_to_end**: instance to instances
        self.policy_type = policy_type
        # The primary traffic redirection instances.
        self.src_candidate_list_shrink = src_candidate_list_shrink

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dest_candidate_list_shrink is not None:
            result['DestCandidateList'] = self.dest_candidate_list_shrink
        if self.firewall_id is not None:
            result['FirewallId'] = self.firewall_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.policy_description is not None:
            result['PolicyDescription'] = self.policy_description
        if self.policy_name is not None:
            result['PolicyName'] = self.policy_name
        if self.policy_type is not None:
            result['PolicyType'] = self.policy_type
        if self.src_candidate_list_shrink is not None:
            result['SrcCandidateList'] = self.src_candidate_list_shrink
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DestCandidateList') is not None:
            self.dest_candidate_list_shrink = m.get('DestCandidateList')
        if m.get('FirewallId') is not None:
            self.firewall_id = m.get('FirewallId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PolicyDescription') is not None:
            self.policy_description = m.get('PolicyDescription')
        if m.get('PolicyName') is not None:
            self.policy_name = m.get('PolicyName')
        if m.get('PolicyType') is not None:
            self.policy_type = m.get('PolicyType')
        if m.get('SrcCandidateList') is not None:
            self.src_candidate_list_shrink = m.get('SrcCandidateList')
        return self


class CreateTrFirewallV2RoutePolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        tr_firewall_route_policy_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The ID of the routing policy.
        self.tr_firewall_route_policy_id = tr_firewall_route_policy_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.tr_firewall_route_policy_id is not None:
            result['TrFirewallRoutePolicyId'] = self.tr_firewall_route_policy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TrFirewallRoutePolicyId') is not None:
            self.tr_firewall_route_policy_id = m.get('TrFirewallRoutePolicyId')
        return self


class CreateTrFirewallV2RoutePolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateTrFirewallV2RoutePolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTrFirewallV2RoutePolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVpcFirewallCenConfigureRequest(TeaModel):
    def __init__(
        self,
        cen_id: str = None,
        firewall_switch: str = None,
        firewall_vswitch_cidr_block: str = None,
        firewall_vpc_cidr_block: str = None,
        firewall_vpc_standby_zone_id: str = None,
        firewall_vpc_zone_id: str = None,
        lang: str = None,
        member_uid: str = None,
        network_instance_id: str = None,
        v_switch_id: str = None,
        vpc_firewall_name: str = None,
        vpc_region: str = None,
    ):
        # The ID of the CEN instance.
        # 
        # This parameter is required.
        self.cen_id = cen_id
        # Specifies whether to enable the VPC firewall. Valid values:
        # 
        # *   **open**: After you create the VPC firewall, the VPC firewall is automatically enabled. This is the default value.
        # *   **close**: After you create the VPC firewall, the VPC firewall is disabled. You can call the [ModifyVpcFirewallCenSwitchStatus](https://help.aliyun.com/document_detail/345780.html) operation to manually enable the VPC firewall.
        # 
        # This parameter is required.
        self.firewall_switch = firewall_switch
        # The CIDR block of the vSwitch that is automatically created for the VPC firewall. You must specify a CIDR block for the Cloud_Firewall_VSWITCH VPC that is automatically created for the VPC firewall for traffic redirection. The CIDR block does not conflict with your network plan. The subnet mask of the CIDR block must be less than or equal to 29 bits in length. The CIDR block of the vSwitch must be within the network segment of the VPC.
        # 
        # If you do not specify a value, the CIDR block 10.219.219.216/29 is automatically allocated.
        # 
        # >  This parameter takes effect only when you create a VPC firewall for the first time in the current CEN instance and region.
        self.firewall_vswitch_cidr_block = firewall_vswitch_cidr_block
        # The CIDR block of the VPC that is automatically created for the VPC firewall. You must specify a CIDR block for the Cloud_Firewall_VPC VPC that is automatically created for the VPC firewall for traffic redirection. The subnet mask of the CIDR block must be less than or equal to 28 bits in length.
        # 
        # If you do not specify a value, the CIDR block 10.0.0.0/8 is automatically allocated.
        # 
        # >  This parameter takes effect only when you create a VPC firewall for the first time in the current CEN instance and region.
        self.firewall_vpc_cidr_block = firewall_vpc_cidr_block
        # The ID of the backup availability zone to which the firewall belongs. The firewall will automatically switch to the backup availability zone to continue running only if the primary availability zone service is unavailable.
        # If this parameter is not filled, the backup availability zone for the firewall will be automatically assigned.
        # > This parameter is only effective when creating a VPC firewall for the first time in this CEN region.
        self.firewall_vpc_standby_zone_id = firewall_vpc_standby_zone_id
        # The ID of the zone to which the vSwitch belongs. If your service is latency-sensitive, you can specify the same zone for the vSwitch of the firewall and the vSwitch of your business VPC to minimize latency.
        # 
        # If you do not specify a value, a zone is automatically assigned for the vSwitch.
        # 
        # >  This parameter takes effect only when you create a VPC firewall for the first time in the current CEN instance and region. For more information about zones that are supported by each region, see [Query zones](https://help.aliyun.com/document_detail/36064.html).
        self.firewall_vpc_zone_id = firewall_vpc_zone_id
        # The language of the content within the request and response. Valid values:
        # 
        # *   **zh**: Chinese (default)
        # *   **en**: English
        self.lang = lang
        # The UID of the member that is managed by your Alibaba Cloud account.
        self.member_uid = member_uid
        # The ID of the VPC for which you want to create the VPC firewall.
        # 
        # This parameter is required.
        self.network_instance_id = network_instance_id
        # The ID of the vSwitch that is used to associate with the elastic network interface (ENI) required by the VPC firewall.
        self.v_switch_id = v_switch_id
        # The instance name of the VPC firewall.
        # 
        # This parameter is required.
        self.vpc_firewall_name = vpc_firewall_name
        # The ID of the region to which the VPC belongs.
        # 
        # > For more information about the regions, see [Supported regions](https://help.aliyun.com/document_detail/195657.html).
        # 
        # This parameter is required.
        self.vpc_region = vpc_region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.firewall_switch is not None:
            result['FirewallSwitch'] = self.firewall_switch
        if self.firewall_vswitch_cidr_block is not None:
            result['FirewallVSwitchCidrBlock'] = self.firewall_vswitch_cidr_block
        if self.firewall_vpc_cidr_block is not None:
            result['FirewallVpcCidrBlock'] = self.firewall_vpc_cidr_block
        if self.firewall_vpc_standby_zone_id is not None:
            result['FirewallVpcStandbyZoneId'] = self.firewall_vpc_standby_zone_id
        if self.firewall_vpc_zone_id is not None:
            result['FirewallVpcZoneId'] = self.firewall_vpc_zone_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.network_instance_id is not None:
            result['NetworkInstanceId'] = self.network_instance_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpc_firewall_name is not None:
            result['VpcFirewallName'] = self.vpc_firewall_name
        if self.vpc_region is not None:
            result['VpcRegion'] = self.vpc_region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('FirewallSwitch') is not None:
            self.firewall_switch = m.get('FirewallSwitch')
        if m.get('FirewallVSwitchCidrBlock') is not None:
            self.firewall_vswitch_cidr_block = m.get('FirewallVSwitchCidrBlock')
        if m.get('FirewallVpcCidrBlock') is not None:
            self.firewall_vpc_cidr_block = m.get('FirewallVpcCidrBlock')
        if m.get('FirewallVpcStandbyZoneId') is not None:
            self.firewall_vpc_standby_zone_id = m.get('FirewallVpcStandbyZoneId')
        if m.get('FirewallVpcZoneId') is not None:
            self.firewall_vpc_zone_id = m.get('FirewallVpcZoneId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('NetworkInstanceId') is not None:
            self.network_instance_id = m.get('NetworkInstanceId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VpcFirewallName') is not None:
            self.vpc_firewall_name = m.get('VpcFirewallName')
        if m.get('VpcRegion') is not None:
            self.vpc_region = m.get('VpcRegion')
        return self


class CreateVpcFirewallCenConfigureResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        vpc_firewall_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The instance ID of the VPC firewall.
        self.vpc_firewall_id = vpc_firewall_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.vpc_firewall_id is not None:
            result['VpcFirewallId'] = self.vpc_firewall_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VpcFirewallId') is not None:
            self.vpc_firewall_id = m.get('VpcFirewallId')
        return self


class CreateVpcFirewallCenConfigureResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateVpcFirewallCenConfigureResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateVpcFirewallCenConfigureResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVpcFirewallCenManualConfigureRequest(TeaModel):
    def __init__(
        self,
        cen_id: str = None,
        lang: str = None,
        member_uid: str = None,
        v_switch_id: str = None,
        vpc_firewall_name: str = None,
        vpc_id: str = None,
    ):
        # This parameter is required.
        self.cen_id = cen_id
        self.lang = lang
        self.member_uid = member_uid
        # This parameter is required.
        self.v_switch_id = v_switch_id
        # This parameter is required.
        self.vpc_firewall_name = vpc_firewall_name
        # This parameter is required.
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpc_firewall_name is not None:
            result['VpcFirewallName'] = self.vpc_firewall_name
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VpcFirewallName') is not None:
            self.vpc_firewall_name = m.get('VpcFirewallName')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class CreateVpcFirewallCenManualConfigureResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        vpc_firewall_id: str = None,
    ):
        self.request_id = request_id
        self.vpc_firewall_id = vpc_firewall_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.vpc_firewall_id is not None:
            result['VpcFirewallId'] = self.vpc_firewall_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VpcFirewallId') is not None:
            self.vpc_firewall_id = m.get('VpcFirewallId')
        return self


class CreateVpcFirewallCenManualConfigureResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateVpcFirewallCenManualConfigureResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateVpcFirewallCenManualConfigureResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVpcFirewallConfigureRequest(TeaModel):
    def __init__(
        self,
        firewall_switch: str = None,
        lang: str = None,
        local_vpc_cidr_table_list: str = None,
        local_vpc_id: str = None,
        local_vpc_region: str = None,
        member_uid: str = None,
        peer_vpc_cidr_table_list: str = None,
        peer_vpc_id: str = None,
        peer_vpc_region: str = None,
        vpc_firewall_name: str = None,
    ):
        # The status of the VPC firewall after you create the firewall. Valid values:
        # 
        # *   **open**: After you create the VPC firewall, the VPC firewall is automatically enabled. This is the default value.
        # *   **close**: After you create the VPC firewall, the VPC firewall is disabled. To enable the firewall, you can call the [ModifyVpcFirewallSwitchStatus](https://help.aliyun.com/document_detail/342935.html) operation.
        # 
        # This parameter is required.
        self.firewall_switch = firewall_switch
        # The language of the content within the request and the response. Valid values:
        # 
        # *   **zh**: Chinese (default)
        # *   **en**: English.
        self.lang = lang
        # The CIDR blocks of the local VPC. The value is a JSON string that contains the following parameters:
        # 
        # *   **RouteTableId**: the ID of the route table for the local VPC.
        # *   **RouteEntryList**: The value is a JSON string that contains the DestinationCidr and NextHopInstanceId parameters. The DestinationCidr parameter indicates the destination CIDR block of the local VPC. The NextHopInstanceId parameter indicates the instance ID of the next hop for the local VPC.
        # 
        # This parameter is required.
        self.local_vpc_cidr_table_list = local_vpc_cidr_table_list
        # The ID of the local VPC.
        # 
        # This parameter is required.
        self.local_vpc_id = local_vpc_id
        # The region ID of the local VPC.
        # 
        # >  For more information about the regions in which Cloud Firewall is available, see [Supported regions](https://help.aliyun.com/document_detail/195657.html).
        # 
        # This parameter is required.
        self.local_vpc_region = local_vpc_region
        # The UID of the member that is managed by your Alibaba Cloud account.
        self.member_uid = member_uid
        # The CIDR blocks of the peer VPC. The value is a JSON string that contains the following parameters:
        # 
        # *   **RouteTableId**: the ID of the route table for the peer VPC.
        # *   **RouteEntryList**: The value is a JSON string that contains the DestinationCidr and NextHopInstanceId parameters. The DestinationCidr parameter indicates the destination CIDR block of the peer VPC. The NextHopInstanceId parameter indicates the instance ID of the next hop for the peer VPC.
        # 
        # This parameter is required.
        self.peer_vpc_cidr_table_list = peer_vpc_cidr_table_list
        # The ID of the peer VPC.
        # 
        # This parameter is required.
        self.peer_vpc_id = peer_vpc_id
        # The region ID of the peer VPC.
        # 
        # >  For more information about Cloud Firewall supported regions, see [Supported regions](https://help.aliyun.com/document_detail/195657.html).
        # 
        # This parameter is required.
        self.peer_vpc_region = peer_vpc_region
        # The instance name of the VPC firewall.
        # 
        # This parameter is required.
        self.vpc_firewall_name = vpc_firewall_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.firewall_switch is not None:
            result['FirewallSwitch'] = self.firewall_switch
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.local_vpc_cidr_table_list is not None:
            result['LocalVpcCidrTableList'] = self.local_vpc_cidr_table_list
        if self.local_vpc_id is not None:
            result['LocalVpcId'] = self.local_vpc_id
        if self.local_vpc_region is not None:
            result['LocalVpcRegion'] = self.local_vpc_region
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.peer_vpc_cidr_table_list is not None:
            result['PeerVpcCidrTableList'] = self.peer_vpc_cidr_table_list
        if self.peer_vpc_id is not None:
            result['PeerVpcId'] = self.peer_vpc_id
        if self.peer_vpc_region is not None:
            result['PeerVpcRegion'] = self.peer_vpc_region
        if self.vpc_firewall_name is not None:
            result['VpcFirewallName'] = self.vpc_firewall_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FirewallSwitch') is not None:
            self.firewall_switch = m.get('FirewallSwitch')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('LocalVpcCidrTableList') is not None:
            self.local_vpc_cidr_table_list = m.get('LocalVpcCidrTableList')
        if m.get('LocalVpcId') is not None:
            self.local_vpc_id = m.get('LocalVpcId')
        if m.get('LocalVpcRegion') is not None:
            self.local_vpc_region = m.get('LocalVpcRegion')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('PeerVpcCidrTableList') is not None:
            self.peer_vpc_cidr_table_list = m.get('PeerVpcCidrTableList')
        if m.get('PeerVpcId') is not None:
            self.peer_vpc_id = m.get('PeerVpcId')
        if m.get('PeerVpcRegion') is not None:
            self.peer_vpc_region = m.get('PeerVpcRegion')
        if m.get('VpcFirewallName') is not None:
            self.vpc_firewall_name = m.get('VpcFirewallName')
        return self


class CreateVpcFirewallConfigureResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        vpc_firewall_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The instance ID of the VPC firewall.
        self.vpc_firewall_id = vpc_firewall_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.vpc_firewall_id is not None:
            result['VpcFirewallId'] = self.vpc_firewall_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VpcFirewallId') is not None:
            self.vpc_firewall_id = m.get('VpcFirewallId')
        return self


class CreateVpcFirewallConfigureResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateVpcFirewallConfigureResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateVpcFirewallConfigureResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVpcFirewallControlPolicyRequest(TeaModel):
    def __init__(
        self,
        acl_action: str = None,
        application_name: str = None,
        application_name_list: List[str] = None,
        description: str = None,
        dest_port: str = None,
        dest_port_group: str = None,
        dest_port_type: str = None,
        destination: str = None,
        destination_type: str = None,
        domain_resolve_type: str = None,
        end_time: int = None,
        lang: str = None,
        member_uid: str = None,
        new_order: str = None,
        proto: str = None,
        release: str = None,
        repeat_days: List[int] = None,
        repeat_end_time: str = None,
        repeat_start_time: str = None,
        repeat_type: str = None,
        source: str = None,
        source_type: str = None,
        start_time: int = None,
        vpc_firewall_id: str = None,
    ):
        # The action that Cloud Firewall performs on the traffic. Valid values:
        # 
        # - **accept**: allows the traffic.
        # - **drop**: blocks the traffic.
        # - **log**: monitors the traffic.
        # 
        # This parameter is required.
        self.acl_action = acl_action
        # The type of the applications that the access control policy supports. Valid values:
        # 
        # - **FTP**\
        # - **HTTP**\
        # - **HTTPS**\
        # - **MySQL**\
        # - **SMTP**\
        # - **SMTPS**\
        # - **RDP**\
        # - **VNC**\
        # - **SSH**\
        # - **Redis**\
        # - **MQTT**\
        # - **MongoDB**\
        # - **Memcache**\
        # - **SSL**\
        # - **ANY**: all types of applications
        self.application_name = application_name
        # The application types supported by the access control policy.
        self.application_name_list = application_name_list
        # The description of the access control policy.
        # 
        # This parameter is required.
        self.description = description
        # The destination port in the access control policy. 
        # 
        # >  If **DestPortType** is set to `port`, you must specify this parameter.
        self.dest_port = dest_port
        # The name of the destination port address book in the access control policy. 
        # 
        # >  If **DestPortType** is set to `group`, you must specify this parameter.
        self.dest_port_group = dest_port_group
        # The type of the destination port in the access control policy. Valid values:
        # 
        # - **port**: port
        # - **group**: port address book
        self.dest_port_type = dest_port_type
        # The destination address in the access control policy. Valid values:
        # 
        # - If **DestinationType** is set to `net`, the value of **Destination** must be a CIDR block.
        # - If **DestinationType** is set to `group`, the value of **Destination** must be an address book.
        # - If **DestinationType** is set to `domain`, the value of **Destination** must be a domain name.
        # 
        # This parameter is required.
        self.destination = destination
        # The type of the destination address in the access control policy. Valid values:
        # 
        # - **net**: CIDR block
        # - **group**: address book
        # - **domain**: domain name
        # 
        # This parameter is required.
        self.destination_type = destination_type
        # The domain name resolution method of the access control policy. Valid values:
        # 
        # * **FQDN**: fully qualified domain name (FQDN)-based resolution
        # * **DNS**: DNS-based dynamic resolution
        # * **FQDN_AND_DNS**: FQDN and DNS-based dynamic resolution
        self.domain_resolve_type = domain_resolve_type
        # The time when the access control policy stops taking effect. The value is a UNIX timestamp. Unit: seconds. The value must be on the hour or on the half hour, and at least 30 minutes later than the start time.
        # 
        # >  If you set RepeatType to Permanent, leave this parameter empty. If you set RepeatType to None, Daily, Weekly, or Monthly, you must specify this parameter.
        self.end_time = end_time
        # The language of the content within the request and response. Valid values:
        # 
        # - **zh**: Chinese (default)
        # - **en**: English
        self.lang = lang
        # The UID of the member that is managed by your Alibaba Cloud account.
        self.member_uid = member_uid
        # The priority of the access control policy. 
        # 
        # The priority value starts from 1. A smaller priority value indicates a higher priority.
        # 
        # This parameter is required.
        self.new_order = new_order
        # The type of the protocol in the access control policy. Valid values:
        # 
        # - **ANY** (If you are not sure about the protocol type, you can set this parameter to ANY.)
        # - **TCP**\
        # - **UDP**\
        # - **ICMP**\
        # 
        # This parameter is required.
        self.proto = proto
        # Specifies whether to enable the access control policy. By default, an access control policy is enabled after the policy is created. Valid values: 
        # 
        # - **true**: enables the access control policy.
        # - **false**: disables the access control policy.
        self.release = release
        # The days of a week or of a month on which the access control policy takes effect.
        # 
        # *   If you set RepeatType to `Permanent`, `None`, or `Daily`, leave this parameter empty. Example: [].
        # *   If you set RepeatType to Weekly, you must specify this parameter. Example: [0, 6].
        # 
        # >  If you set RepeatType to Weekly, the fields in the value of this parameter cannot be repeated.
        # 
        # *   If you set RepeatType to `Monthly`, you must specify this parameter. Example: [1, 31].
        # 
        # >  If you set RepeatType to Monthly, the fields in the value of this parameter cannot be repeated.
        self.repeat_days = repeat_days
        # The point in time when the recurrence ends. Example: 23:30. The value must be on the hour or on the half hour, and at least 30 minutes later than the start time.
        # 
        # >  If you set RepeatType to Permanent or None, leave this parameter empty. If you set RepeatType to Daily, Weekly, or Monthly, you must specify this parameter.
        self.repeat_end_time = repeat_end_time
        # The point in time when the recurrence starts. Example: 08:00. The value must be on the hour or on the half hour, and at least 30 minutes earlier than the end time.
        # 
        # >  If you set RepeatType to Permanent or None, leave this parameter empty. If you set RepeatType to Daily, Weekly, or Monthly, you must specify this parameter.
        self.repeat_start_time = repeat_start_time
        # The recurrence type for the access control policy to take effect. Valid values:
        # 
        # *   **Permanent** (default): The policy always takes effect.
        # *   **None**: The policy takes effect for only once.
        # *   **Daily**: The policy takes effect on a daily basis.
        # *   **Weekly**: The policy takes effect on a weekly basis.
        # *   **Monthly**: The policy takes effect on a monthly basis.
        self.repeat_type = repeat_type
        # The source address in the access control policy. 
        # 
        # - If SourceType is set to `net`, the value of Source must be a CIDR block.
        # - If SourceType is set to `group`, the value of Source must be an address book.
        # 
        # This parameter is required.
        self.source = source
        # The type of the source address in the access control policy. Valid values:
        # 
        # - **net**: CIDR block
        # - **group**: address book
        # 
        # This parameter is required.
        self.source_type = source_type
        # The time when the access control policy starts to take effect. The value is a UNIX timestamp. Unit: seconds. The value must be on the hour or on the half hour, and at least 30 minutes earlier than the end time.
        # 
        # >  If you set RepeatType to Permanent, leave this parameter empty. If you set RepeatType to None, Daily, Weekly, or Monthly, you must specify this parameter.
        self.start_time = start_time
        # The ID of the policy group in which you want to create the access control policy. 
        # 
        # - If a VPC firewall protects the traffic between two VPCs that are connected by using a CEN instance, the value of this parameter must be the ID of the CEN instance.
        # - If a VPC firewall protects the traffic between two VPCs that are connected by using an Express Connect circuit, the value of this parameter must be the instance ID of the VPC firewall.
        # 
        # >  You can call the [DescribeVpcFirewallAclGroupList](https://www.alibabacloud.com/help/en/cloud-firewall/latest/describevpcfirewallaclgrouplist) operation to query the IDs.
        # 
        # This parameter is required.
        self.vpc_firewall_id = vpc_firewall_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_action is not None:
            result['AclAction'] = self.acl_action
        if self.application_name is not None:
            result['ApplicationName'] = self.application_name
        if self.application_name_list is not None:
            result['ApplicationNameList'] = self.application_name_list
        if self.description is not None:
            result['Description'] = self.description
        if self.dest_port is not None:
            result['DestPort'] = self.dest_port
        if self.dest_port_group is not None:
            result['DestPortGroup'] = self.dest_port_group
        if self.dest_port_type is not None:
            result['DestPortType'] = self.dest_port_type
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.destination_type is not None:
            result['DestinationType'] = self.destination_type
        if self.domain_resolve_type is not None:
            result['DomainResolveType'] = self.domain_resolve_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.new_order is not None:
            result['NewOrder'] = self.new_order
        if self.proto is not None:
            result['Proto'] = self.proto
        if self.release is not None:
            result['Release'] = self.release
        if self.repeat_days is not None:
            result['RepeatDays'] = self.repeat_days
        if self.repeat_end_time is not None:
            result['RepeatEndTime'] = self.repeat_end_time
        if self.repeat_start_time is not None:
            result['RepeatStartTime'] = self.repeat_start_time
        if self.repeat_type is not None:
            result['RepeatType'] = self.repeat_type
        if self.source is not None:
            result['Source'] = self.source
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.vpc_firewall_id is not None:
            result['VpcFirewallId'] = self.vpc_firewall_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclAction') is not None:
            self.acl_action = m.get('AclAction')
        if m.get('ApplicationName') is not None:
            self.application_name = m.get('ApplicationName')
        if m.get('ApplicationNameList') is not None:
            self.application_name_list = m.get('ApplicationNameList')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestPort') is not None:
            self.dest_port = m.get('DestPort')
        if m.get('DestPortGroup') is not None:
            self.dest_port_group = m.get('DestPortGroup')
        if m.get('DestPortType') is not None:
            self.dest_port_type = m.get('DestPortType')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('DestinationType') is not None:
            self.destination_type = m.get('DestinationType')
        if m.get('DomainResolveType') is not None:
            self.domain_resolve_type = m.get('DomainResolveType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('NewOrder') is not None:
            self.new_order = m.get('NewOrder')
        if m.get('Proto') is not None:
            self.proto = m.get('Proto')
        if m.get('Release') is not None:
            self.release = m.get('Release')
        if m.get('RepeatDays') is not None:
            self.repeat_days = m.get('RepeatDays')
        if m.get('RepeatEndTime') is not None:
            self.repeat_end_time = m.get('RepeatEndTime')
        if m.get('RepeatStartTime') is not None:
            self.repeat_start_time = m.get('RepeatStartTime')
        if m.get('RepeatType') is not None:
            self.repeat_type = m.get('RepeatType')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('VpcFirewallId') is not None:
            self.vpc_firewall_id = m.get('VpcFirewallId')
        return self


class CreateVpcFirewallControlPolicyResponseBody(TeaModel):
    def __init__(
        self,
        acl_uuid: str = None,
        request_id: str = None,
    ):
        # The ID of the access control policy.
        self.acl_uuid = acl_uuid
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_uuid is not None:
            result['AclUuid'] = self.acl_uuid
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclUuid') is not None:
            self.acl_uuid = m.get('AclUuid')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateVpcFirewallControlPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateVpcFirewallControlPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateVpcFirewallControlPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVpcFirewallPrecheckRequest(TeaModel):
    def __init__(
        self,
        cen_id: str = None,
        lang: str = None,
        member_uid: str = None,
        network_instance_type: str = None,
        region: str = None,
        transit_router_id: str = None,
        vpc_id: str = None,
    ):
        self.cen_id = cen_id
        self.lang = lang
        self.member_uid = member_uid
        self.network_instance_type = network_instance_type
        self.region = region
        self.transit_router_id = transit_router_id
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.network_instance_type is not None:
            result['NetworkInstanceType'] = self.network_instance_type
        if self.region is not None:
            result['Region'] = self.region
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('NetworkInstanceType') is not None:
            self.network_instance_type = m.get('NetworkInstanceType')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class CreateVpcFirewallPrecheckResponseBody(TeaModel):
    def __init__(
        self,
        precheck_id: str = None,
        request_id: str = None,
    ):
        self.precheck_id = precheck_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.precheck_id is not None:
            result['PrecheckId'] = self.precheck_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PrecheckId') is not None:
            self.precheck_id = m.get('PrecheckId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateVpcFirewallPrecheckResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateVpcFirewallPrecheckResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateVpcFirewallPrecheckResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVpcFirewallTaskRequest(TeaModel):
    def __init__(
        self,
        content: str = None,
        lang: str = None,
        priority: str = None,
        task_action: str = None,
    ):
        self.content = content
        self.lang = lang
        self.priority = priority
        # This parameter is required.
        self.task_action = task_action

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.task_action is not None:
            result['TaskAction'] = self.task_action
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('TaskAction') is not None:
            self.task_action = m.get('TaskAction')
        return self


class CreateVpcFirewallTaskResponseBody(TeaModel):
    def __init__(
        self,
        module: str = None,
        request_id: str = None,
    ):
        self.module = module
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.module is not None:
            result['Module'] = self.module
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Module') is not None:
            self.module = m.get('Module')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateVpcFirewallTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateVpcFirewallTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateVpcFirewallTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAckClusterConnectorRequest(TeaModel):
    def __init__(
        self,
        connector_id: str = None,
    ):
        # This parameter is required.
        self.connector_id = connector_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connector_id is not None:
            result['ConnectorId'] = self.connector_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectorId') is not None:
            self.connector_id = m.get('ConnectorId')
        return self


class DeleteAckClusterConnectorResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAckClusterConnectorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAckClusterConnectorResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAckClusterConnectorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAclBackupDataRequest(TeaModel):
    def __init__(
        self,
        back_up_time: str = None,
        lang: str = None,
        source_ip: str = None,
    ):
        # This parameter is required.
        self.back_up_time = back_up_time
        self.lang = lang
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.back_up_time is not None:
            result['BackUpTime'] = self.back_up_time
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackUpTime') is not None:
            self.back_up_time = m.get('BackUpTime')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DeleteAclBackupDataResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAclBackupDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAclBackupDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAclBackupDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAddressBookRequest(TeaModel):
    def __init__(
        self,
        group_uuid: str = None,
        lang: str = None,
        source_ip: str = None,
    ):
        # The ID of the address book.
        # 
        # To delete the address book, you must provide the ID of the address book. You can call the DescribeAddressBook operation to query the ID.
        # 
        # This parameter is required.
        self.group_uuid = group_uuid
        # The natural language of the request and response. Valid values:
        # 
        # *   **zh**: Chinese (default)
        # *   **en**: English
        self.lang = lang
        # The source IP address of the request.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_uuid is not None:
            result['GroupUuid'] = self.group_uuid
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupUuid') is not None:
            self.group_uuid = m.get('GroupUuid')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DeleteAddressBookResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAddressBookResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAddressBookResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAddressBookResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteControlPolicyRequest(TeaModel):
    def __init__(
        self,
        acl_uuid: str = None,
        direction: str = None,
        lang: str = None,
        source_ip: str = None,
    ):
        # The UUID of the access control policy.
        # 
        # To delete an access control policy, you must specify the UUID of the policy. You can call the [DescribeControlPolicy](https://help.aliyun.com/document_detail/138866.html) operation to query the UUID.
        # 
        # This parameter is required.
        self.acl_uuid = acl_uuid
        # The direction of the traffic to which the access control policy applies.
        # 
        # Valid values:
        # 
        # *   **in**: inbound.
        # *   **out**: outbound.
        self.direction = direction
        # The language of the content within the request and response.
        # 
        # Valid values:
        # 
        # *   **zh** (default)
        # *   **en**\
        self.lang = lang
        # The source IP address of the traffic.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_uuid is not None:
            result['AclUuid'] = self.acl_uuid
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclUuid') is not None:
            self.acl_uuid = m.get('AclUuid')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DeleteControlPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteControlPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteControlPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteControlPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteControlPolicyTemplateRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        source_ip: str = None,
        template_id: str = None,
    ):
        # The language of the content within the request and response. Valid values:
        # 
        # *   **zh** (default): Chinese
        # *   **en**: English
        self.lang = lang
        # The source IP address of the request.
        self.source_ip = source_ip
        # The ID of the access control policy template.
        # 
        # This parameter is required.
        self.template_id = template_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.template_id is not None:
            result['TemplateId'] = self.template_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('TemplateId') is not None:
            self.template_id = m.get('TemplateId')
        return self


class DeleteControlPolicyTemplateResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteControlPolicyTemplateResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteControlPolicyTemplateResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteControlPolicyTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDnsFirewallPolicyRequest(TeaModel):
    def __init__(
        self,
        acl_uuid: str = None,
        lang: str = None,
        source_ip: str = None,
    ):
        # This parameter is required.
        self.acl_uuid = acl_uuid
        self.lang = lang
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_uuid is not None:
            result['AclUuid'] = self.acl_uuid
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclUuid') is not None:
            self.acl_uuid = m.get('AclUuid')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DeleteDnsFirewallPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDnsFirewallPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDnsFirewallPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDnsFirewallPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDownloadTaskRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        task_id: str = None,
    ):
        # The language of the content within the request and response. Valid values:
        # 
        # *   **zh** (default): Chinese
        # *   **en**: English
        self.lang = lang
        # The ID of the file download task.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DeleteDownloadTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDownloadTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDownloadTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDownloadTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFirewallV2RoutePoliciesRequest(TeaModel):
    def __init__(
        self,
        firewall_id: str = None,
        lang: str = None,
        tr_firewall_route_policy_id: str = None,
    ):
        # The instance ID of the VPC firewall.
        self.firewall_id = firewall_id
        # The language of the content within the response. Valid values:
        # 
        # *   **zh** (default): Chinese
        # *   **en**: English
        self.lang = lang
        # The ID of the routing policy.
        self.tr_firewall_route_policy_id = tr_firewall_route_policy_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.firewall_id is not None:
            result['FirewallId'] = self.firewall_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.tr_firewall_route_policy_id is not None:
            result['TrFirewallRoutePolicyId'] = self.tr_firewall_route_policy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FirewallId') is not None:
            self.firewall_id = m.get('FirewallId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('TrFirewallRoutePolicyId') is not None:
            self.tr_firewall_route_policy_id = m.get('TrFirewallRoutePolicyId')
        return self


class DeleteFirewallV2RoutePoliciesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteFirewallV2RoutePoliciesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteFirewallV2RoutePoliciesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteFirewallV2RoutePoliciesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteInstanceMembersRequest(TeaModel):
    def __init__(
        self,
        member_uids: List[int] = None,
    ):
        # The UIDs of the members.
        # 
        # This parameter is required.
        self.member_uids = member_uids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.member_uids is not None:
            result['MemberUids'] = self.member_uids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MemberUids') is not None:
            self.member_uids = m.get('MemberUids')
        return self


class DeleteInstanceMembersResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteInstanceMembersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteInstanceMembersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteInstanceMembersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteIpsPrivateAssocRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        resource_id: str = None,
    ):
        self.lang = lang
        self.resource_id = resource_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class DeleteIpsPrivateAssocResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteIpsPrivateAssocResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteIpsPrivateAssocResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteIpsPrivateAssocResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNatFirewallControlPolicyRequest(TeaModel):
    def __init__(
        self,
        acl_uuid: str = None,
        direction: str = None,
        lang: str = None,
        nat_gateway_id: str = None,
    ):
        # The UUID of the access control policy.
        # 
        # To delete an access control policy, you must provide the ID of the policy. You can call the DescribeNatFirewallControlPolicy operation to query the UUIDs of access control policies.
        # 
        # This parameter is required.
        self.acl_uuid = acl_uuid
        # The direction of the traffic to which the access control policy applies.
        # 
        # Valid values:
        # 
        # *   **out**: outbound traffic
        # 
        # This parameter is required.
        self.direction = direction
        # The language of the content within the response. Valid values:
        # 
        # *   **zh**: Chinese (default)
        # *   **en**: English
        self.lang = lang
        # The ID of the NAT gateway.
        # 
        # This parameter is required.
        self.nat_gateway_id = nat_gateway_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_uuid is not None:
            result['AclUuid'] = self.acl_uuid
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclUuid') is not None:
            self.acl_uuid = m.get('AclUuid')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        return self


class DeleteNatFirewallControlPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteNatFirewallControlPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteNatFirewallControlPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteNatFirewallControlPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNatFirewallControlPolicyBatchRequest(TeaModel):
    def __init__(
        self,
        acl_uuid_list: List[str] = None,
        direction: str = None,
        lang: str = None,
        nat_gateway_id: str = None,
    ):
        # The UUIDs of access control policies.
        # 
        # This parameter is required.
        self.acl_uuid_list = acl_uuid_list
        # The direction of the traffic to which the access control policy applies. Valid values:
        # 
        # *   **out**: outbound traffic
        self.direction = direction
        # The language of the content within the request and response. Valid values:
        # 
        # *   **zh** (default): Chinese
        # *   **en**: English
        self.lang = lang
        # The ID of the NAT gateway.
        # 
        # This parameter is required.
        self.nat_gateway_id = nat_gateway_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_uuid_list is not None:
            result['AclUuidList'] = self.acl_uuid_list
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclUuidList') is not None:
            self.acl_uuid_list = m.get('AclUuidList')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        return self


class DeleteNatFirewallControlPolicyBatchResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteNatFirewallControlPolicyBatchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteNatFirewallControlPolicyBatchResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteNatFirewallControlPolicyBatchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePrivateDnsAllDomainNameRequest(TeaModel):
    def __init__(
        self,
        access_instance_id: str = None,
        region_no: str = None,
    ):
        # This parameter is required.
        self.access_instance_id = access_instance_id
        # This parameter is required.
        self.region_no = region_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_instance_id is not None:
            result['AccessInstanceId'] = self.access_instance_id
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessInstanceId') is not None:
            self.access_instance_id = m.get('AccessInstanceId')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        return self


class DeletePrivateDnsAllDomainNameResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePrivateDnsAllDomainNameResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeletePrivateDnsAllDomainNameResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePrivateDnsAllDomainNameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePrivateDnsDomainNameRequest(TeaModel):
    def __init__(
        self,
        access_instance_id: str = None,
        domain_name_list: List[str] = None,
        region_no: str = None,
    ):
        # This parameter is required.
        self.access_instance_id = access_instance_id
        # This parameter is required.
        self.domain_name_list = domain_name_list
        # This parameter is required.
        self.region_no = region_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_instance_id is not None:
            result['AccessInstanceId'] = self.access_instance_id
        if self.domain_name_list is not None:
            result['DomainNameList'] = self.domain_name_list
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessInstanceId') is not None:
            self.access_instance_id = m.get('AccessInstanceId')
        if m.get('DomainNameList') is not None:
            self.domain_name_list = m.get('DomainNameList')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        return self


class DeletePrivateDnsDomainNameResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePrivateDnsDomainNameResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeletePrivateDnsDomainNameResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePrivateDnsDomainNameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePrivateDnsEndpointRequest(TeaModel):
    def __init__(
        self,
        access_instance_id: str = None,
        region_no: str = None,
    ):
        # This parameter is required.
        self.access_instance_id = access_instance_id
        # This parameter is required.
        self.region_no = region_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_instance_id is not None:
            result['AccessInstanceId'] = self.access_instance_id
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessInstanceId') is not None:
            self.access_instance_id = m.get('AccessInstanceId')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        return self


class DeletePrivateDnsEndpointResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePrivateDnsEndpointResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeletePrivateDnsEndpointResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePrivateDnsEndpointResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSecurityProxyRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        proxy_id: str = None,
    ):
        # The language of the content within the response. Valid values:
        # 
        # *   **zh** (default): Chinese
        # *   **en**: English
        self.lang = lang
        # The ID of the NAT firewall.
        # 
        # This parameter is required.
        self.proxy_id = proxy_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.proxy_id is not None:
            result['ProxyId'] = self.proxy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ProxyId') is not None:
            self.proxy_id = m.get('ProxyId')
        return self


class DeleteSecurityProxyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSecurityProxyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSecurityProxyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSecurityProxyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTrFirewallV2Request(TeaModel):
    def __init__(
        self,
        firewall_id: str = None,
        lang: str = None,
    ):
        # The instance ID of the VPC firewall.
        self.firewall_id = firewall_id
        # The language of the content within the response. Valid values:
        # 
        # *   **zh**: Chinese (default)
        # *   **en**: English
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.firewall_id is not None:
            result['FirewallId'] = self.firewall_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FirewallId') is not None:
            self.firewall_id = m.get('FirewallId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DeleteTrFirewallV2ResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The request ID.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTrFirewallV2Response(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteTrFirewallV2ResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTrFirewallV2ResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVpcFirewallCenConfigureRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        member_uid: str = None,
        vpc_firewall_id_list: List[str] = None,
    ):
        # The language of the content within the request and response. Valid values:
        # 
        # *   **zh**: Chinese (default)
        # *   **en**: English
        self.lang = lang
        # The UID of the member that is managed by your Alibaba Cloud account.
        self.member_uid = member_uid
        # The instance IDs of VPC firewalls.
        # 
        # This parameter is required.
        self.vpc_firewall_id_list = vpc_firewall_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.vpc_firewall_id_list is not None:
            result['VpcFirewallIdList'] = self.vpc_firewall_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('VpcFirewallIdList') is not None:
            self.vpc_firewall_id_list = m.get('VpcFirewallIdList')
        return self


class DeleteVpcFirewallCenConfigureResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVpcFirewallCenConfigureResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteVpcFirewallCenConfigureResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteVpcFirewallCenConfigureResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVpcFirewallConfigureRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        member_uid: str = None,
        vpc_firewall_id_list: List[str] = None,
    ):
        # The language of the content within the request and response. Valid values:
        # 
        # *   **zh**: Chinese (default)
        # *   **en**: English
        self.lang = lang
        # The UID of the member that is managed by your Alibaba Cloud account.
        self.member_uid = member_uid
        # The instance IDs of VPC firewalls.
        # 
        # This parameter is required.
        self.vpc_firewall_id_list = vpc_firewall_id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.vpc_firewall_id_list is not None:
            result['VpcFirewallIdList'] = self.vpc_firewall_id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('VpcFirewallIdList') is not None:
            self.vpc_firewall_id_list = m.get('VpcFirewallIdList')
        return self


class DeleteVpcFirewallConfigureResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVpcFirewallConfigureResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteVpcFirewallConfigureResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteVpcFirewallConfigureResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVpcFirewallControlPolicyRequest(TeaModel):
    def __init__(
        self,
        acl_uuid: str = None,
        lang: str = None,
        vpc_firewall_id: str = None,
    ):
        # The ID of the access control policy. 
        # 
        # To delete an access control policy, you must provide the ID of the policy. You can call the **DescribeVpcFirewallControlPolicy** operation to query the ID.
        # 
        # This parameter is required.
        self.acl_uuid = acl_uuid
        # The natural language of the request and response. Valid values: 
        # 
        # - **zh**: Chinese
        # - **en**: English
        self.lang = lang
        # The ID of the group to which the access control policy belongs. You can call the **DescribeVpcFirewallAclGroupList** operation to query the ID.  
        # 
        # Valid values:
        # 
        # - If the VPC firewall is used to protect a CEN instance, the value of this parameter is the ID of the CEN instance.  
        # 
        # Example: cen-ervw0g12b5jbw****\
        # - If the VPC firewall is used to protect an Express Connect circuit, the value of this parameter is the ID of the VPC firewall.  
        # 
        # Example: vfw-a42bbb7b887148c9****\
        # 
        # This parameter is required.
        self.vpc_firewall_id = vpc_firewall_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_uuid is not None:
            result['AclUuid'] = self.acl_uuid
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.vpc_firewall_id is not None:
            result['VpcFirewallId'] = self.vpc_firewall_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclUuid') is not None:
            self.acl_uuid = m.get('AclUuid')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('VpcFirewallId') is not None:
            self.vpc_firewall_id = m.get('VpcFirewallId')
        return self


class DeleteVpcFirewallControlPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVpcFirewallControlPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteVpcFirewallControlPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteVpcFirewallControlPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeACLProtectTrendRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        lang: str = None,
        source_ip: str = None,
        start_time: str = None,
    ):
        # The end of the time range to query. The value is a UNIX timestamp that is accurate to seconds.
        self.end_time = end_time
        # The language of the content within the request and the response. Valid values:
        # 
        # *   **zh** (default): Chinese
        # *   **en**: English
        self.lang = lang
        # This parameter is deprecated.
        self.source_ip = source_ip
        # The beginning of the time range to query. The value is a UNIX timestamp that is accurate to seconds.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeACLProtectTrendResponseBodyTrendList(TeaModel):
    def __init__(
        self,
        protect_cnt: int = None,
        time: int = None,
    ):
        # The number of requests that are blocked by ACL on the current day.
        self.protect_cnt = protect_cnt
        # The UNIX timestamp at midnight (00:00:00) of each day, which indicates the date of the current day. Unit: seconds.
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.protect_cnt is not None:
            result['ProtectCnt'] = self.protect_cnt
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProtectCnt') is not None:
            self.protect_cnt = m.get('ProtectCnt')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class DescribeACLProtectTrendResponseBody(TeaModel):
    def __init__(
        self,
        in_protect_cnt: int = None,
        inter_vpcprotect_cnt: int = None,
        interval: int = None,
        out_protect_cnt: int = None,
        request_id: str = None,
        total_protect_cnt: int = None,
        trend_list: List[DescribeACLProtectTrendResponseBodyTrendList] = None,
    ):
        # The number of internal requests that are blocked by the ACL feature.
        self.in_protect_cnt = in_protect_cnt
        # This parameter is deprecated.
        self.inter_vpcprotect_cnt = inter_vpcprotect_cnt
        # The interval for returning data. Unit: seconds.
        self.interval = interval
        # The number of external requests that are blocked by the ACL feature.
        self.out_protect_cnt = out_protect_cnt
        # The request ID.
        self.request_id = request_id
        # The total number of requests that are blocked by the ACL feature.
        self.total_protect_cnt = total_protect_cnt
        # The statistics on the requests that are blocked by the ACL feature.
        self.trend_list = trend_list

    def validate(self):
        if self.trend_list:
            for k in self.trend_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.in_protect_cnt is not None:
            result['InProtectCnt'] = self.in_protect_cnt
        if self.inter_vpcprotect_cnt is not None:
            result['InterVPCProtectCnt'] = self.inter_vpcprotect_cnt
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.out_protect_cnt is not None:
            result['OutProtectCnt'] = self.out_protect_cnt
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_protect_cnt is not None:
            result['TotalProtectCnt'] = self.total_protect_cnt
        result['TrendList'] = []
        if self.trend_list is not None:
            for k in self.trend_list:
                result['TrendList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InProtectCnt') is not None:
            self.in_protect_cnt = m.get('InProtectCnt')
        if m.get('InterVPCProtectCnt') is not None:
            self.inter_vpcprotect_cnt = m.get('InterVPCProtectCnt')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('OutProtectCnt') is not None:
            self.out_protect_cnt = m.get('OutProtectCnt')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalProtectCnt') is not None:
            self.total_protect_cnt = m.get('TotalProtectCnt')
        self.trend_list = []
        if m.get('TrendList') is not None:
            for k in m.get('TrendList'):
                temp_model = DescribeACLProtectTrendResponseBodyTrendList()
                self.trend_list.append(temp_model.from_map(k))
        return self


class DescribeACLProtectTrendResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeACLProtectTrendResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeACLProtectTrendResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAITrafficAnalysisStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        status: str = None,
    ):
        self.request_id = request_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeAITrafficAnalysisStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAITrafficAnalysisStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAITrafficAnalysisStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAccessInstanceRegionListRequest(TeaModel):
    def __init__(
        self,
        access_instance_status: str = None,
        access_instance_type: str = None,
    ):
        self.access_instance_status = access_instance_status
        self.access_instance_type = access_instance_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_instance_status is not None:
            result['AccessInstanceStatus'] = self.access_instance_status
        if self.access_instance_type is not None:
            result['AccessInstanceType'] = self.access_instance_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessInstanceStatus') is not None:
            self.access_instance_status = m.get('AccessInstanceStatus')
        if m.get('AccessInstanceType') is not None:
            self.access_instance_type = m.get('AccessInstanceType')
        return self


class DescribeAccessInstanceRegionListResponseBody(TeaModel):
    def __init__(
        self,
        region_no_list: List[str] = None,
        request_id: str = None,
    ):
        self.region_no_list = region_no_list
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_no_list is not None:
            result['RegionNoList'] = self.region_no_list
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionNoList') is not None:
            self.region_no_list = m.get('RegionNoList')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAccessInstanceRegionListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAccessInstanceRegionListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAccessInstanceRegionListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAccessInstanceTaskRequest(TeaModel):
    def __init__(
        self,
        access_instance_id: str = None,
        access_instance_type: str = None,
        lang: str = None,
        region_no: str = None,
        task_id: str = None,
    ):
        self.access_instance_id = access_instance_id
        self.access_instance_type = access_instance_type
        self.lang = lang
        self.region_no = region_no
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_instance_id is not None:
            result['AccessInstanceId'] = self.access_instance_id
        if self.access_instance_type is not None:
            result['AccessInstanceType'] = self.access_instance_type
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessInstanceId') is not None:
            self.access_instance_id = m.get('AccessInstanceId')
        if m.get('AccessInstanceType') is not None:
            self.access_instance_type = m.get('AccessInstanceType')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeAccessInstanceTaskResponseBodyTaskSteps(TeaModel):
    def __init__(
        self,
        step_name: str = None,
        step_progress: str = None,
        step_status: str = None,
    ):
        self.step_name = step_name
        self.step_progress = step_progress
        self.step_status = step_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.step_name is not None:
            result['StepName'] = self.step_name
        if self.step_progress is not None:
            result['StepProgress'] = self.step_progress
        if self.step_status is not None:
            result['StepStatus'] = self.step_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StepName') is not None:
            self.step_name = m.get('StepName')
        if m.get('StepProgress') is not None:
            self.step_progress = m.get('StepProgress')
        if m.get('StepStatus') is not None:
            self.step_status = m.get('StepStatus')
        return self


class DescribeAccessInstanceTaskResponseBody(TeaModel):
    def __init__(
        self,
        is_found: bool = None,
        request_id: str = None,
        task_finish_timestamp: int = None,
        task_id: str = None,
        task_name: str = None,
        task_start_timestamp: int = None,
        task_status: str = None,
        task_steps: List[DescribeAccessInstanceTaskResponseBodyTaskSteps] = None,
    ):
        self.is_found = is_found
        self.request_id = request_id
        self.task_finish_timestamp = task_finish_timestamp
        self.task_id = task_id
        self.task_name = task_name
        self.task_start_timestamp = task_start_timestamp
        self.task_status = task_status
        self.task_steps = task_steps

    def validate(self):
        if self.task_steps:
            for k in self.task_steps:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_found is not None:
            result['IsFound'] = self.is_found
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_finish_timestamp is not None:
            result['TaskFinishTimestamp'] = self.task_finish_timestamp
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_start_timestamp is not None:
            result['TaskStartTimestamp'] = self.task_start_timestamp
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        result['TaskSteps'] = []
        if self.task_steps is not None:
            for k in self.task_steps:
                result['TaskSteps'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsFound') is not None:
            self.is_found = m.get('IsFound')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskFinishTimestamp') is not None:
            self.task_finish_timestamp = m.get('TaskFinishTimestamp')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskStartTimestamp') is not None:
            self.task_start_timestamp = m.get('TaskStartTimestamp')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        self.task_steps = []
        if m.get('TaskSteps') is not None:
            for k in m.get('TaskSteps'):
                temp_model = DescribeAccessInstanceTaskResponseBodyTaskSteps()
                self.task_steps.append(temp_model.from_map(k))
        return self


class DescribeAccessInstanceTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAccessInstanceTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAccessInstanceTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAccessInstanceVSwitchListRequest(TeaModel):
    def __init__(
        self,
        member_uid: int = None,
        page_no: int = None,
        page_size: int = None,
        region_no: str = None,
        v_switch_id: str = None,
        vpc_id: str = None,
        zone_id: str = None,
    ):
        self.member_uid = member_uid
        self.page_no = page_no
        self.page_size = page_size
        # This parameter is required.
        self.region_no = region_no
        self.v_switch_id = v_switch_id
        self.vpc_id = vpc_id
        self.zone_id = zone_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeAccessInstanceVSwitchListResponseBodyZonesVSwitchList(TeaModel):
    def __init__(
        self,
        available_ip_address_count: int = None,
        cidr_block: str = None,
        firewall_vswitch: bool = None,
        v_switch_id: str = None,
        v_switch_name: str = None,
        vpc_id: str = None,
    ):
        self.available_ip_address_count = available_ip_address_count
        self.cidr_block = cidr_block
        self.firewall_vswitch = firewall_vswitch
        self.v_switch_id = v_switch_id
        self.v_switch_name = v_switch_name
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_ip_address_count is not None:
            result['AvailableIpAddressCount'] = self.available_ip_address_count
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.firewall_vswitch is not None:
            result['FirewallVSwitch'] = self.firewall_vswitch
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.v_switch_name is not None:
            result['VSwitchName'] = self.v_switch_name
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvailableIpAddressCount') is not None:
            self.available_ip_address_count = m.get('AvailableIpAddressCount')
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('FirewallVSwitch') is not None:
            self.firewall_vswitch = m.get('FirewallVSwitch')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VSwitchName') is not None:
            self.v_switch_name = m.get('VSwitchName')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DescribeAccessInstanceVSwitchListResponseBodyZones(TeaModel):
    def __init__(
        self,
        v_switch_list: List[DescribeAccessInstanceVSwitchListResponseBodyZonesVSwitchList] = None,
        zone_id: str = None,
    ):
        self.v_switch_list = v_switch_list
        self.zone_id = zone_id

    def validate(self):
        if self.v_switch_list:
            for k in self.v_switch_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VSwitchList'] = []
        if self.v_switch_list is not None:
            for k in self.v_switch_list:
                result['VSwitchList'].append(k.to_map() if k else None)
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.v_switch_list = []
        if m.get('VSwitchList') is not None:
            for k in m.get('VSwitchList'):
                temp_model = DescribeAccessInstanceVSwitchListResponseBodyZonesVSwitchList()
                self.v_switch_list.append(temp_model.from_map(k))
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeAccessInstanceVSwitchListResponseBody(TeaModel):
    def __init__(
        self,
        page_no: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
        zones: List[DescribeAccessInstanceVSwitchListResponseBodyZones] = None,
    ):
        self.page_no = page_no
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count
        self.zones = zones

    def validate(self):
        if self.zones:
            for k in self.zones:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Zones'] = []
        if self.zones is not None:
            for k in self.zones:
                result['Zones'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.zones = []
        if m.get('Zones') is not None:
            for k in m.get('Zones'):
                temp_model = DescribeAccessInstanceVSwitchListResponseBodyZones()
                self.zones.append(temp_model.from_map(k))
        return self


class DescribeAccessInstanceVSwitchListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAccessInstanceVSwitchListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAccessInstanceVSwitchListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAccessInstanceVpcListRequest(TeaModel):
    def __init__(
        self,
        member_uid: int = None,
        page_no: int = None,
        page_size: int = None,
        region_no: str = None,
        vpc_id: str = None,
    ):
        self.member_uid = member_uid
        self.page_no = page_no
        self.page_size = page_size
        # This parameter is required.
        self.region_no = region_no
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DescribeAccessInstanceVpcListResponseBodyVpcList(TeaModel):
    def __init__(
        self,
        firewall_vpc: bool = None,
        vpc_id: str = None,
        vpc_name: str = None,
    ):
        self.firewall_vpc = firewall_vpc
        self.vpc_id = vpc_id
        self.vpc_name = vpc_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.firewall_vpc is not None:
            result['FirewallVpc'] = self.firewall_vpc
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vpc_name is not None:
            result['VpcName'] = self.vpc_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FirewallVpc') is not None:
            self.firewall_vpc = m.get('FirewallVpc')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VpcName') is not None:
            self.vpc_name = m.get('VpcName')
        return self


class DescribeAccessInstanceVpcListResponseBody(TeaModel):
    def __init__(
        self,
        page_no: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
        vpc_list: List[DescribeAccessInstanceVpcListResponseBodyVpcList] = None,
    ):
        self.page_no = page_no
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count
        self.vpc_list = vpc_list

    def validate(self):
        if self.vpc_list:
            for k in self.vpc_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['VpcList'] = []
        if self.vpc_list is not None:
            for k in self.vpc_list:
                result['VpcList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.vpc_list = []
        if m.get('VpcList') is not None:
            for k in m.get('VpcList'):
                temp_model = DescribeAccessInstanceVpcListResponseBodyVpcList()
                self.vpc_list.append(temp_model.from_map(k))
        return self


class DescribeAccessInstanceVpcListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAccessInstanceVpcListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAccessInstanceVpcListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAccessInstanceZoneListRequest(TeaModel):
    def __init__(
        self,
        access_instance_type: str = None,
        lang: str = None,
        region_no: str = None,
    ):
        self.access_instance_type = access_instance_type
        self.lang = lang
        self.region_no = region_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_instance_type is not None:
            result['AccessInstanceType'] = self.access_instance_type
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessInstanceType') is not None:
            self.access_instance_type = m.get('AccessInstanceType')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        return self


class DescribeAccessInstanceZoneListResponseBodyZones(TeaModel):
    def __init__(
        self,
        local_name: str = None,
        zone_id: str = None,
    ):
        self.local_name = local_name
        self.zone_id = zone_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.local_name is not None:
            result['LocalName'] = self.local_name
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LocalName') is not None:
            self.local_name = m.get('LocalName')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeAccessInstanceZoneListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        zone_list: List[str] = None,
        zones: List[DescribeAccessInstanceZoneListResponseBodyZones] = None,
    ):
        self.request_id = request_id
        self.zone_list = zone_list
        self.zones = zones

    def validate(self):
        if self.zones:
            for k in self.zones:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.zone_list is not None:
            result['ZoneList'] = self.zone_list
        result['Zones'] = []
        if self.zones is not None:
            for k in self.zones:
                result['Zones'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ZoneList') is not None:
            self.zone_list = m.get('ZoneList')
        self.zones = []
        if m.get('Zones') is not None:
            for k in m.get('Zones'):
                temp_model = DescribeAccessInstanceZoneListResponseBodyZones()
                self.zones.append(temp_model.from_map(k))
        return self


class DescribeAccessInstanceZoneListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAccessInstanceZoneListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAccessInstanceZoneListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAckClusterConnectorRequest(TeaModel):
    def __init__(
        self,
        connector_id: str = None,
        lang: str = None,
    ):
        # This parameter is required.
        self.connector_id = connector_id
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connector_id is not None:
            result['ConnectorId'] = self.connector_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectorId') is not None:
            self.connector_id = m.get('ConnectorId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeAckClusterConnectorResponseBodyAckClusterConnector(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        cluster_name: str = None,
        connector_health_check_status: str = None,
        connector_id: str = None,
        connector_name: str = None,
        connector_status: str = None,
        create_time: str = None,
        member_uid: str = None,
        primary_vswitch_id: str = None,
        primary_vswitch_ip: str = None,
        primary_vswitch_zone_id: str = None,
        region_no: str = None,
        standby_vswitch_id: str = None,
        standby_vswitch_ip: str = None,
        standby_vswitch_zone_id: str = None,
        ttl: int = None,
        unhealthy_reason: str = None,
        vpc_id: str = None,
    ):
        self.cluster_id = cluster_id
        self.cluster_name = cluster_name
        self.connector_health_check_status = connector_health_check_status
        self.connector_id = connector_id
        self.connector_name = connector_name
        self.connector_status = connector_status
        self.create_time = create_time
        self.member_uid = member_uid
        self.primary_vswitch_id = primary_vswitch_id
        self.primary_vswitch_ip = primary_vswitch_ip
        self.primary_vswitch_zone_id = primary_vswitch_zone_id
        self.region_no = region_no
        self.standby_vswitch_id = standby_vswitch_id
        self.standby_vswitch_ip = standby_vswitch_ip
        self.standby_vswitch_zone_id = standby_vswitch_zone_id
        self.ttl = ttl
        self.unhealthy_reason = unhealthy_reason
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.connector_health_check_status is not None:
            result['ConnectorHealthCheckStatus'] = self.connector_health_check_status
        if self.connector_id is not None:
            result['ConnectorId'] = self.connector_id
        if self.connector_name is not None:
            result['ConnectorName'] = self.connector_name
        if self.connector_status is not None:
            result['ConnectorStatus'] = self.connector_status
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.primary_vswitch_id is not None:
            result['PrimaryVswitchId'] = self.primary_vswitch_id
        if self.primary_vswitch_ip is not None:
            result['PrimaryVswitchIp'] = self.primary_vswitch_ip
        if self.primary_vswitch_zone_id is not None:
            result['PrimaryVswitchZoneId'] = self.primary_vswitch_zone_id
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.standby_vswitch_id is not None:
            result['StandbyVswitchId'] = self.standby_vswitch_id
        if self.standby_vswitch_ip is not None:
            result['StandbyVswitchIp'] = self.standby_vswitch_ip
        if self.standby_vswitch_zone_id is not None:
            result['StandbyVswitchZoneId'] = self.standby_vswitch_zone_id
        if self.ttl is not None:
            result['Ttl'] = self.ttl
        if self.unhealthy_reason is not None:
            result['UnhealthyReason'] = self.unhealthy_reason
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ConnectorHealthCheckStatus') is not None:
            self.connector_health_check_status = m.get('ConnectorHealthCheckStatus')
        if m.get('ConnectorId') is not None:
            self.connector_id = m.get('ConnectorId')
        if m.get('ConnectorName') is not None:
            self.connector_name = m.get('ConnectorName')
        if m.get('ConnectorStatus') is not None:
            self.connector_status = m.get('ConnectorStatus')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('PrimaryVswitchId') is not None:
            self.primary_vswitch_id = m.get('PrimaryVswitchId')
        if m.get('PrimaryVswitchIp') is not None:
            self.primary_vswitch_ip = m.get('PrimaryVswitchIp')
        if m.get('PrimaryVswitchZoneId') is not None:
            self.primary_vswitch_zone_id = m.get('PrimaryVswitchZoneId')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('StandbyVswitchId') is not None:
            self.standby_vswitch_id = m.get('StandbyVswitchId')
        if m.get('StandbyVswitchIp') is not None:
            self.standby_vswitch_ip = m.get('StandbyVswitchIp')
        if m.get('StandbyVswitchZoneId') is not None:
            self.standby_vswitch_zone_id = m.get('StandbyVswitchZoneId')
        if m.get('Ttl') is not None:
            self.ttl = m.get('Ttl')
        if m.get('UnhealthyReason') is not None:
            self.unhealthy_reason = m.get('UnhealthyReason')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DescribeAckClusterConnectorResponseBody(TeaModel):
    def __init__(
        self,
        ack_cluster_connector: DescribeAckClusterConnectorResponseBodyAckClusterConnector = None,
        request_id: str = None,
    ):
        self.ack_cluster_connector = ack_cluster_connector
        self.request_id = request_id

    def validate(self):
        if self.ack_cluster_connector:
            self.ack_cluster_connector.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ack_cluster_connector is not None:
            result['AckClusterConnector'] = self.ack_cluster_connector.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AckClusterConnector') is not None:
            temp_model = DescribeAckClusterConnectorResponseBodyAckClusterConnector()
            self.ack_cluster_connector = temp_model.from_map(m['AckClusterConnector'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAckClusterConnectorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAckClusterConnectorResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAckClusterConnectorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAckClusterConnectorsRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        connector_name: str = None,
        lang: str = None,
        member_uid: str = None,
        page_no: str = None,
        page_size: str = None,
        region_no: str = None,
        vpc_id: str = None,
    ):
        self.cluster_id = cluster_id
        self.connector_name = connector_name
        self.lang = lang
        self.member_uid = member_uid
        # This parameter is required.
        self.page_no = page_no
        # This parameter is required.
        self.page_size = page_size
        self.region_no = region_no
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.connector_name is not None:
            result['ConnectorName'] = self.connector_name
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ConnectorName') is not None:
            self.connector_name = m.get('ConnectorName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DescribeAckClusterConnectorsResponseBodyAckClusterConnectors(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        cluster_name: str = None,
        connector_health_check_status: str = None,
        connector_id: str = None,
        connector_name: str = None,
        connector_status: str = None,
        create_time: str = None,
        group_uuids: List[str] = None,
        member_uid: str = None,
        primary_vswitch_id: str = None,
        primary_vswitch_ip: str = None,
        primary_vswitch_zone_id: str = None,
        region_no: str = None,
        standby_vswitch_id: str = None,
        standby_vswitch_ip: str = None,
        standby_vswitch_zone_id: str = None,
        ttl: int = None,
        unhealthy_reason: str = None,
        vpc_id: str = None,
    ):
        self.cluster_id = cluster_id
        self.cluster_name = cluster_name
        self.connector_health_check_status = connector_health_check_status
        self.connector_id = connector_id
        self.connector_name = connector_name
        self.connector_status = connector_status
        self.create_time = create_time
        self.group_uuids = group_uuids
        self.member_uid = member_uid
        self.primary_vswitch_id = primary_vswitch_id
        self.primary_vswitch_ip = primary_vswitch_ip
        self.primary_vswitch_zone_id = primary_vswitch_zone_id
        self.region_no = region_no
        self.standby_vswitch_id = standby_vswitch_id
        self.standby_vswitch_ip = standby_vswitch_ip
        self.standby_vswitch_zone_id = standby_vswitch_zone_id
        self.ttl = ttl
        self.unhealthy_reason = unhealthy_reason
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.connector_health_check_status is not None:
            result['ConnectorHealthCheckStatus'] = self.connector_health_check_status
        if self.connector_id is not None:
            result['ConnectorId'] = self.connector_id
        if self.connector_name is not None:
            result['ConnectorName'] = self.connector_name
        if self.connector_status is not None:
            result['ConnectorStatus'] = self.connector_status
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.group_uuids is not None:
            result['GroupUuids'] = self.group_uuids
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.primary_vswitch_id is not None:
            result['PrimaryVswitchId'] = self.primary_vswitch_id
        if self.primary_vswitch_ip is not None:
            result['PrimaryVswitchIp'] = self.primary_vswitch_ip
        if self.primary_vswitch_zone_id is not None:
            result['PrimaryVswitchZoneId'] = self.primary_vswitch_zone_id
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.standby_vswitch_id is not None:
            result['StandbyVswitchId'] = self.standby_vswitch_id
        if self.standby_vswitch_ip is not None:
            result['StandbyVswitchIp'] = self.standby_vswitch_ip
        if self.standby_vswitch_zone_id is not None:
            result['StandbyVswitchZoneId'] = self.standby_vswitch_zone_id
        if self.ttl is not None:
            result['Ttl'] = self.ttl
        if self.unhealthy_reason is not None:
            result['UnhealthyReason'] = self.unhealthy_reason
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ConnectorHealthCheckStatus') is not None:
            self.connector_health_check_status = m.get('ConnectorHealthCheckStatus')
        if m.get('ConnectorId') is not None:
            self.connector_id = m.get('ConnectorId')
        if m.get('ConnectorName') is not None:
            self.connector_name = m.get('ConnectorName')
        if m.get('ConnectorStatus') is not None:
            self.connector_status = m.get('ConnectorStatus')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('GroupUuids') is not None:
            self.group_uuids = m.get('GroupUuids')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('PrimaryVswitchId') is not None:
            self.primary_vswitch_id = m.get('PrimaryVswitchId')
        if m.get('PrimaryVswitchIp') is not None:
            self.primary_vswitch_ip = m.get('PrimaryVswitchIp')
        if m.get('PrimaryVswitchZoneId') is not None:
            self.primary_vswitch_zone_id = m.get('PrimaryVswitchZoneId')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('StandbyVswitchId') is not None:
            self.standby_vswitch_id = m.get('StandbyVswitchId')
        if m.get('StandbyVswitchIp') is not None:
            self.standby_vswitch_ip = m.get('StandbyVswitchIp')
        if m.get('StandbyVswitchZoneId') is not None:
            self.standby_vswitch_zone_id = m.get('StandbyVswitchZoneId')
        if m.get('Ttl') is not None:
            self.ttl = m.get('Ttl')
        if m.get('UnhealthyReason') is not None:
            self.unhealthy_reason = m.get('UnhealthyReason')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DescribeAckClusterConnectorsResponseBody(TeaModel):
    def __init__(
        self,
        ack_cluster_connectors: List[DescribeAckClusterConnectorsResponseBodyAckClusterConnectors] = None,
        page_no: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.ack_cluster_connectors = ack_cluster_connectors
        self.page_no = page_no
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.ack_cluster_connectors:
            for k in self.ack_cluster_connectors:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AckClusterConnectors'] = []
        if self.ack_cluster_connectors is not None:
            for k in self.ack_cluster_connectors:
                result['AckClusterConnectors'].append(k.to_map() if k else None)
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ack_cluster_connectors = []
        if m.get('AckClusterConnectors') is not None:
            for k in m.get('AckClusterConnectors'):
                temp_model = DescribeAckClusterConnectorsResponseBodyAckClusterConnectors()
                self.ack_cluster_connectors.append(temp_model.from_map(k))
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAckClusterConnectorsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAckClusterConnectorsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAckClusterConnectorsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAckClusterNamespacesRequest(TeaModel):
    def __init__(
        self,
        connector_id: str = None,
    ):
        # This parameter is required.
        self.connector_id = connector_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connector_id is not None:
            result['ConnectorId'] = self.connector_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectorId') is not None:
            self.connector_id = m.get('ConnectorId')
        return self


class DescribeAckClusterNamespacesResponseBody(TeaModel):
    def __init__(
        self,
        ack_namespaces: List[str] = None,
        request_id: str = None,
    ):
        self.ack_namespaces = ack_namespaces
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ack_namespaces is not None:
            result['AckNamespaces'] = self.ack_namespaces
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AckNamespaces') is not None:
            self.ack_namespaces = m.get('AckNamespaces')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAckClusterNamespacesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAckClusterNamespacesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAckClusterNamespacesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAckClusterPodLabelsRequest(TeaModel):
    def __init__(
        self,
        connector_id: str = None,
    ):
        # This parameter is required.
        self.connector_id = connector_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connector_id is not None:
            result['ConnectorId'] = self.connector_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectorId') is not None:
            self.connector_id = m.get('ConnectorId')
        return self


class DescribeAckClusterPodLabelsResponseBodyAckLabels(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeAckClusterPodLabelsResponseBody(TeaModel):
    def __init__(
        self,
        ack_labels: List[DescribeAckClusterPodLabelsResponseBodyAckLabels] = None,
        request_id: str = None,
    ):
        self.ack_labels = ack_labels
        self.request_id = request_id

    def validate(self):
        if self.ack_labels:
            for k in self.ack_labels:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AckLabels'] = []
        if self.ack_labels is not None:
            for k in self.ack_labels:
                result['AckLabels'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ack_labels = []
        if m.get('AckLabels') is not None:
            for k in m.get('AckLabels'):
                temp_model = DescribeAckClusterPodLabelsResponseBodyAckLabels()
                self.ack_labels.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAckClusterPodLabelsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAckClusterPodLabelsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAckClusterPodLabelsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAckClustersRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        cluster_name: str = None,
        cluster_spec: str = None,
        connector_status: str = None,
        member_uid: str = None,
        page_no: str = None,
        page_size: str = None,
        region_no: str = None,
    ):
        self.cluster_id = cluster_id
        self.cluster_name = cluster_name
        self.cluster_spec = cluster_spec
        self.connector_status = connector_status
        self.member_uid = member_uid
        # This parameter is required.
        self.page_no = page_no
        # This parameter is required.
        self.page_size = page_size
        # This parameter is required.
        self.region_no = region_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.cluster_spec is not None:
            result['ClusterSpec'] = self.cluster_spec
        if self.connector_status is not None:
            result['ConnectorStatus'] = self.connector_status
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ClusterSpec') is not None:
            self.cluster_spec = m.get('ClusterSpec')
        if m.get('ConnectorStatus') is not None:
            self.connector_status = m.get('ConnectorStatus')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        return self


class DescribeAckClustersResponseBodyClusters(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        cluster_name: str = None,
        cluster_spec: str = None,
        cluster_type: str = None,
        member_uid: str = None,
        network: str = None,
        profile: str = None,
        region_id: str = None,
        state: str = None,
        vpc_id: str = None,
    ):
        self.cluster_id = cluster_id
        self.cluster_name = cluster_name
        self.cluster_spec = cluster_spec
        self.cluster_type = cluster_type
        self.member_uid = member_uid
        self.network = network
        self.profile = profile
        self.region_id = region_id
        self.state = state
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.cluster_spec is not None:
            result['ClusterSpec'] = self.cluster_spec
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.network is not None:
            result['Network'] = self.network
        if self.profile is not None:
            result['Profile'] = self.profile
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.state is not None:
            result['State'] = self.state
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ClusterSpec') is not None:
            self.cluster_spec = m.get('ClusterSpec')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('Network') is not None:
            self.network = m.get('Network')
        if m.get('Profile') is not None:
            self.profile = m.get('Profile')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DescribeAckClustersResponseBody(TeaModel):
    def __init__(
        self,
        clusters: List[DescribeAckClustersResponseBodyClusters] = None,
        page_no: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.clusters = clusters
        self.page_no = page_no
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.clusters:
            for k in self.clusters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Clusters'] = []
        if self.clusters is not None:
            for k in self.clusters:
                result['Clusters'].append(k.to_map() if k else None)
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.clusters = []
        if m.get('Clusters') is not None:
            for k in m.get('Clusters'):
                temp_model = DescribeAckClustersResponseBodyClusters()
                self.clusters.append(temp_model.from_map(k))
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAckClustersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAckClustersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAckClustersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAclAppsRequest(TeaModel):
    def __init__(
        self,
        acl_type: str = None,
        lang: str = None,
        page_no: int = None,
        page_size: int = None,
        popular: int = None,
        protocols: List[str] = None,
    ):
        # This parameter is required.
        self.acl_type = acl_type
        self.lang = lang
        # This parameter is required.
        self.page_no = page_no
        # This parameter is required.
        self.page_size = page_size
        self.popular = popular
        self.protocols = protocols

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_type is not None:
            result['AclType'] = self.acl_type
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.popular is not None:
            result['Popular'] = self.popular
        if self.protocols is not None:
            result['Protocols'] = self.protocols
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclType') is not None:
            self.acl_type = m.get('AclType')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Popular') is not None:
            self.popular = m.get('Popular')
        if m.get('Protocols') is not None:
            self.protocols = m.get('Protocols')
        return self


class DescribeAclAppsResponseBodyAclApps(TeaModel):
    def __init__(
        self,
        app_id: int = None,
        app_name: str = None,
        popular: int = None,
        protocols: List[str] = None,
        risk_level: int = None,
        support_fqdn: int = None,
    ):
        self.app_id = app_id
        self.app_name = app_name
        self.popular = popular
        self.protocols = protocols
        self.risk_level = risk_level
        self.support_fqdn = support_fqdn

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.popular is not None:
            result['Popular'] = self.popular
        if self.protocols is not None:
            result['Protocols'] = self.protocols
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.support_fqdn is not None:
            result['SupportFqdn'] = self.support_fqdn
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('Popular') is not None:
            self.popular = m.get('Popular')
        if m.get('Protocols') is not None:
            self.protocols = m.get('Protocols')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('SupportFqdn') is not None:
            self.support_fqdn = m.get('SupportFqdn')
        return self


class DescribeAclAppsResponseBody(TeaModel):
    def __init__(
        self,
        acl_apps: List[DescribeAclAppsResponseBodyAclApps] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.acl_apps = acl_apps
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.acl_apps:
            for k in self.acl_apps:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AclApps'] = []
        if self.acl_apps is not None:
            for k in self.acl_apps:
                result['AclApps'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.acl_apps = []
        if m.get('AclApps') is not None:
            for k in m.get('AclApps'):
                temp_model = DescribeAclAppsResponseBodyAclApps()
                self.acl_apps.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAclAppsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAclAppsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAclAppsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAclCheckRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        page_no: int = None,
        page_size: int = None,
        task_id: str = None,
    ):
        self.lang = lang
        # This parameter is required.
        self.page_no = page_no
        # This parameter is required.
        self.page_size = page_size
        # This parameter is required.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeAclCheckResponseBodyCheckRecordAclsAclAddresses(TeaModel):
    def __init__(
        self,
        address: str = None,
        note: str = None,
    ):
        self.address = address
        self.note = note

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        if self.note is not None:
            result['Note'] = self.note
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('Note') is not None:
            self.note = m.get('Note')
        return self


class DescribeAclCheckResponseBodyCheckRecordAclsAclTagList(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        self.tag_key = tag_key
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class DescribeAclCheckResponseBodyCheckRecordAclsAcl(TeaModel):
    def __init__(
        self,
        acl_action: str = None,
        acl_uuid: str = None,
        address_list: List[str] = None,
        address_list_count: int = None,
        addresses: List[DescribeAclCheckResponseBodyCheckRecordAclsAclAddresses] = None,
        application_id: str = None,
        application_name: str = None,
        application_name_list: List[str] = None,
        auto_add_tag_ecs: int = None,
        create_time: int = None,
        description: str = None,
        dest_port: str = None,
        dest_port_group: str = None,
        dest_port_group_ports: List[str] = None,
        dest_port_type: str = None,
        destination: str = None,
        destination_group_cidrs: List[str] = None,
        destination_group_type: str = None,
        destination_type: str = None,
        direction: str = None,
        dns_result: str = None,
        dns_result_time: int = None,
        domain_resolve_type: int = None,
        end_time: int = None,
        group_name: str = None,
        group_type: str = None,
        group_uuid: str = None,
        hit_last_time: int = None,
        hit_times: int = None,
        ip_version: int = None,
        modify_time: int = None,
        nat_gateway_id: str = None,
        order: int = None,
        proto: str = None,
        reference_count: int = None,
        release: str = None,
        repeat_days: List[int] = None,
        repeat_end_time: str = None,
        repeat_start_time: str = None,
        repeat_type: str = None,
        source: str = None,
        source_group_cidrs: List[str] = None,
        source_group_type: str = None,
        source_type: str = None,
        spread_cnt: int = None,
        start_time: int = None,
        tag_list: List[DescribeAclCheckResponseBodyCheckRecordAclsAclTagList] = None,
        tag_relation: str = None,
        vpc_firewall_id: str = None,
    ):
        self.acl_action = acl_action
        self.acl_uuid = acl_uuid
        self.address_list = address_list
        self.address_list_count = address_list_count
        self.addresses = addresses
        self.application_id = application_id
        self.application_name = application_name
        self.application_name_list = application_name_list
        self.auto_add_tag_ecs = auto_add_tag_ecs
        self.create_time = create_time
        self.description = description
        self.dest_port = dest_port
        self.dest_port_group = dest_port_group
        self.dest_port_group_ports = dest_port_group_ports
        self.dest_port_type = dest_port_type
        self.destination = destination
        self.destination_group_cidrs = destination_group_cidrs
        self.destination_group_type = destination_group_type
        self.destination_type = destination_type
        self.direction = direction
        self.dns_result = dns_result
        self.dns_result_time = dns_result_time
        self.domain_resolve_type = domain_resolve_type
        self.end_time = end_time
        self.group_name = group_name
        self.group_type = group_type
        self.group_uuid = group_uuid
        self.hit_last_time = hit_last_time
        self.hit_times = hit_times
        self.ip_version = ip_version
        self.modify_time = modify_time
        self.nat_gateway_id = nat_gateway_id
        self.order = order
        self.proto = proto
        self.reference_count = reference_count
        self.release = release
        self.repeat_days = repeat_days
        self.repeat_end_time = repeat_end_time
        self.repeat_start_time = repeat_start_time
        self.repeat_type = repeat_type
        self.source = source
        self.source_group_cidrs = source_group_cidrs
        self.source_group_type = source_group_type
        self.source_type = source_type
        self.spread_cnt = spread_cnt
        self.start_time = start_time
        self.tag_list = tag_list
        self.tag_relation = tag_relation
        self.vpc_firewall_id = vpc_firewall_id

    def validate(self):
        if self.addresses:
            for k in self.addresses:
                if k:
                    k.validate()
        if self.tag_list:
            for k in self.tag_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_action is not None:
            result['AclAction'] = self.acl_action
        if self.acl_uuid is not None:
            result['AclUuid'] = self.acl_uuid
        if self.address_list is not None:
            result['AddressList'] = self.address_list
        if self.address_list_count is not None:
            result['AddressListCount'] = self.address_list_count
        result['Addresses'] = []
        if self.addresses is not None:
            for k in self.addresses:
                result['Addresses'].append(k.to_map() if k else None)
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.application_name is not None:
            result['ApplicationName'] = self.application_name
        if self.application_name_list is not None:
            result['ApplicationNameList'] = self.application_name_list
        if self.auto_add_tag_ecs is not None:
            result['AutoAddTagEcs'] = self.auto_add_tag_ecs
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.dest_port is not None:
            result['DestPort'] = self.dest_port
        if self.dest_port_group is not None:
            result['DestPortGroup'] = self.dest_port_group
        if self.dest_port_group_ports is not None:
            result['DestPortGroupPorts'] = self.dest_port_group_ports
        if self.dest_port_type is not None:
            result['DestPortType'] = self.dest_port_type
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.destination_group_cidrs is not None:
            result['DestinationGroupCidrs'] = self.destination_group_cidrs
        if self.destination_group_type is not None:
            result['DestinationGroupType'] = self.destination_group_type
        if self.destination_type is not None:
            result['DestinationType'] = self.destination_type
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.dns_result is not None:
            result['DnsResult'] = self.dns_result
        if self.dns_result_time is not None:
            result['DnsResultTime'] = self.dns_result_time
        if self.domain_resolve_type is not None:
            result['DomainResolveType'] = self.domain_resolve_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.group_type is not None:
            result['GroupType'] = self.group_type
        if self.group_uuid is not None:
            result['GroupUuid'] = self.group_uuid
        if self.hit_last_time is not None:
            result['HitLastTime'] = self.hit_last_time
        if self.hit_times is not None:
            result['HitTimes'] = self.hit_times
        if self.ip_version is not None:
            result['IpVersion'] = self.ip_version
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.order is not None:
            result['Order'] = self.order
        if self.proto is not None:
            result['Proto'] = self.proto
        if self.reference_count is not None:
            result['ReferenceCount'] = self.reference_count
        if self.release is not None:
            result['Release'] = self.release
        if self.repeat_days is not None:
            result['RepeatDays'] = self.repeat_days
        if self.repeat_end_time is not None:
            result['RepeatEndTime'] = self.repeat_end_time
        if self.repeat_start_time is not None:
            result['RepeatStartTime'] = self.repeat_start_time
        if self.repeat_type is not None:
            result['RepeatType'] = self.repeat_type
        if self.source is not None:
            result['Source'] = self.source
        if self.source_group_cidrs is not None:
            result['SourceGroupCidrs'] = self.source_group_cidrs
        if self.source_group_type is not None:
            result['SourceGroupType'] = self.source_group_type
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.spread_cnt is not None:
            result['SpreadCnt'] = self.spread_cnt
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        result['TagList'] = []
        if self.tag_list is not None:
            for k in self.tag_list:
                result['TagList'].append(k.to_map() if k else None)
        if self.tag_relation is not None:
            result['TagRelation'] = self.tag_relation
        if self.vpc_firewall_id is not None:
            result['VpcFirewallId'] = self.vpc_firewall_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclAction') is not None:
            self.acl_action = m.get('AclAction')
        if m.get('AclUuid') is not None:
            self.acl_uuid = m.get('AclUuid')
        if m.get('AddressList') is not None:
            self.address_list = m.get('AddressList')
        if m.get('AddressListCount') is not None:
            self.address_list_count = m.get('AddressListCount')
        self.addresses = []
        if m.get('Addresses') is not None:
            for k in m.get('Addresses'):
                temp_model = DescribeAclCheckResponseBodyCheckRecordAclsAclAddresses()
                self.addresses.append(temp_model.from_map(k))
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ApplicationName') is not None:
            self.application_name = m.get('ApplicationName')
        if m.get('ApplicationNameList') is not None:
            self.application_name_list = m.get('ApplicationNameList')
        if m.get('AutoAddTagEcs') is not None:
            self.auto_add_tag_ecs = m.get('AutoAddTagEcs')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestPort') is not None:
            self.dest_port = m.get('DestPort')
        if m.get('DestPortGroup') is not None:
            self.dest_port_group = m.get('DestPortGroup')
        if m.get('DestPortGroupPorts') is not None:
            self.dest_port_group_ports = m.get('DestPortGroupPorts')
        if m.get('DestPortType') is not None:
            self.dest_port_type = m.get('DestPortType')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('DestinationGroupCidrs') is not None:
            self.destination_group_cidrs = m.get('DestinationGroupCidrs')
        if m.get('DestinationGroupType') is not None:
            self.destination_group_type = m.get('DestinationGroupType')
        if m.get('DestinationType') is not None:
            self.destination_type = m.get('DestinationType')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('DnsResult') is not None:
            self.dns_result = m.get('DnsResult')
        if m.get('DnsResultTime') is not None:
            self.dns_result_time = m.get('DnsResultTime')
        if m.get('DomainResolveType') is not None:
            self.domain_resolve_type = m.get('DomainResolveType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('GroupType') is not None:
            self.group_type = m.get('GroupType')
        if m.get('GroupUuid') is not None:
            self.group_uuid = m.get('GroupUuid')
        if m.get('HitLastTime') is not None:
            self.hit_last_time = m.get('HitLastTime')
        if m.get('HitTimes') is not None:
            self.hit_times = m.get('HitTimes')
        if m.get('IpVersion') is not None:
            self.ip_version = m.get('IpVersion')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('Proto') is not None:
            self.proto = m.get('Proto')
        if m.get('ReferenceCount') is not None:
            self.reference_count = m.get('ReferenceCount')
        if m.get('Release') is not None:
            self.release = m.get('Release')
        if m.get('RepeatDays') is not None:
            self.repeat_days = m.get('RepeatDays')
        if m.get('RepeatEndTime') is not None:
            self.repeat_end_time = m.get('RepeatEndTime')
        if m.get('RepeatStartTime') is not None:
            self.repeat_start_time = m.get('RepeatStartTime')
        if m.get('RepeatType') is not None:
            self.repeat_type = m.get('RepeatType')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SourceGroupCidrs') is not None:
            self.source_group_cidrs = m.get('SourceGroupCidrs')
        if m.get('SourceGroupType') is not None:
            self.source_group_type = m.get('SourceGroupType')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('SpreadCnt') is not None:
            self.spread_cnt = m.get('SpreadCnt')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        self.tag_list = []
        if m.get('TagList') is not None:
            for k in m.get('TagList'):
                temp_model = DescribeAclCheckResponseBodyCheckRecordAclsAclTagList()
                self.tag_list.append(temp_model.from_map(k))
        if m.get('TagRelation') is not None:
            self.tag_relation = m.get('TagRelation')
        if m.get('VpcFirewallId') is not None:
            self.vpc_firewall_id = m.get('VpcFirewallId')
        return self


class DescribeAclCheckResponseBodyCheckRecordAcls(TeaModel):
    def __init__(
        self,
        acl: DescribeAclCheckResponseBodyCheckRecordAclsAcl = None,
        acl_assessment_detail: str = None,
        acl_status: str = None,
    ):
        self.acl = acl
        self.acl_assessment_detail = acl_assessment_detail
        self.acl_status = acl_status

    def validate(self):
        if self.acl:
            self.acl.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl is not None:
            result['Acl'] = self.acl.to_map()
        if self.acl_assessment_detail is not None:
            result['AclAssessmentDetail'] = self.acl_assessment_detail
        if self.acl_status is not None:
            result['AclStatus'] = self.acl_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Acl') is not None:
            temp_model = DescribeAclCheckResponseBodyCheckRecordAclsAcl()
            self.acl = temp_model.from_map(m['Acl'])
        if m.get('AclAssessmentDetail') is not None:
            self.acl_assessment_detail = m.get('AclAssessmentDetail')
        if m.get('AclStatus') is not None:
            self.acl_status = m.get('AclStatus')
        return self


class DescribeAclCheckResponseBodyCheckRecord(TeaModel):
    def __init__(
        self,
        acl_total_count: int = None,
        acls: List[DescribeAclCheckResponseBodyCheckRecordAcls] = None,
        check_name: str = None,
        description: str = None,
        last_check_time: str = None,
        level: str = None,
        record_assessment_detail: str = None,
        task_id: str = None,
    ):
        self.acl_total_count = acl_total_count
        self.acls = acls
        self.check_name = check_name
        self.description = description
        self.last_check_time = last_check_time
        self.level = level
        self.record_assessment_detail = record_assessment_detail
        self.task_id = task_id

    def validate(self):
        if self.acls:
            for k in self.acls:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_total_count is not None:
            result['AclTotalCount'] = self.acl_total_count
        result['Acls'] = []
        if self.acls is not None:
            for k in self.acls:
                result['Acls'].append(k.to_map() if k else None)
        if self.check_name is not None:
            result['CheckName'] = self.check_name
        if self.description is not None:
            result['Description'] = self.description
        if self.last_check_time is not None:
            result['LastCheckTime'] = self.last_check_time
        if self.level is not None:
            result['Level'] = self.level
        if self.record_assessment_detail is not None:
            result['RecordAssessmentDetail'] = self.record_assessment_detail
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclTotalCount') is not None:
            self.acl_total_count = m.get('AclTotalCount')
        self.acls = []
        if m.get('Acls') is not None:
            for k in m.get('Acls'):
                temp_model = DescribeAclCheckResponseBodyCheckRecordAcls()
                self.acls.append(temp_model.from_map(k))
        if m.get('CheckName') is not None:
            self.check_name = m.get('CheckName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('LastCheckTime') is not None:
            self.last_check_time = m.get('LastCheckTime')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('RecordAssessmentDetail') is not None:
            self.record_assessment_detail = m.get('RecordAssessmentDetail')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeAclCheckResponseBody(TeaModel):
    def __init__(
        self,
        check_record: DescribeAclCheckResponseBodyCheckRecord = None,
        request_id: str = None,
    ):
        self.check_record = check_record
        self.request_id = request_id

    def validate(self):
        if self.check_record:
            self.check_record.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_record is not None:
            result['CheckRecord'] = self.check_record.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckRecord') is not None:
            temp_model = DescribeAclCheckResponseBodyCheckRecord()
            self.check_record = temp_model.from_map(m['CheckRecord'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAclCheckResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAclCheckResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAclCheckResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAclCheckQuotaRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeAclCheckQuotaResponseBodyQuota(TeaModel):
    def __init__(
        self,
        available_quota: int = None,
        consumed_quota: int = None,
        total_quota: int = None,
        update_time: str = None,
    ):
        self.available_quota = available_quota
        self.consumed_quota = consumed_quota
        self.total_quota = total_quota
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_quota is not None:
            result['AvailableQuota'] = self.available_quota
        if self.consumed_quota is not None:
            result['ConsumedQuota'] = self.consumed_quota
        if self.total_quota is not None:
            result['TotalQuota'] = self.total_quota
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvailableQuota') is not None:
            self.available_quota = m.get('AvailableQuota')
        if m.get('ConsumedQuota') is not None:
            self.consumed_quota = m.get('ConsumedQuota')
        if m.get('TotalQuota') is not None:
            self.total_quota = m.get('TotalQuota')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeAclCheckQuotaResponseBody(TeaModel):
    def __init__(
        self,
        quota: DescribeAclCheckQuotaResponseBodyQuota = None,
        request_id: str = None,
    ):
        self.quota = quota
        self.request_id = request_id

    def validate(self):
        if self.quota:
            self.quota.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quota is not None:
            result['Quota'] = self.quota.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Quota') is not None:
            temp_model = DescribeAclCheckQuotaResponseBodyQuota()
            self.quota = temp_model.from_map(m['Quota'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAclCheckQuotaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAclCheckQuotaResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAclCheckQuotaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAclChecksRequest(TeaModel):
    def __init__(
        self,
        acl_type: str = None,
        lang: str = None,
    ):
        # This parameter is required.
        self.acl_type = acl_type
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_type is not None:
            result['AclType'] = self.acl_type
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclType') is not None:
            self.acl_type = m.get('AclType')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeAclChecksResponseBodyCheckRecordsRecords(TeaModel):
    def __init__(
        self,
        acl_pending_count: int = None,
        acl_total_count: int = None,
        check_name: str = None,
        check_status: str = None,
        check_type: str = None,
        last_check_time: str = None,
        level: str = None,
        task_id: str = None,
    ):
        self.acl_pending_count = acl_pending_count
        self.acl_total_count = acl_total_count
        self.check_name = check_name
        self.check_status = check_status
        self.check_type = check_type
        self.last_check_time = last_check_time
        self.level = level
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_pending_count is not None:
            result['AclPendingCount'] = self.acl_pending_count
        if self.acl_total_count is not None:
            result['AclTotalCount'] = self.acl_total_count
        if self.check_name is not None:
            result['CheckName'] = self.check_name
        if self.check_status is not None:
            result['CheckStatus'] = self.check_status
        if self.check_type is not None:
            result['CheckType'] = self.check_type
        if self.last_check_time is not None:
            result['LastCheckTime'] = self.last_check_time
        if self.level is not None:
            result['Level'] = self.level
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclPendingCount') is not None:
            self.acl_pending_count = m.get('AclPendingCount')
        if m.get('AclTotalCount') is not None:
            self.acl_total_count = m.get('AclTotalCount')
        if m.get('CheckName') is not None:
            self.check_name = m.get('CheckName')
        if m.get('CheckStatus') is not None:
            self.check_status = m.get('CheckStatus')
        if m.get('CheckType') is not None:
            self.check_type = m.get('CheckType')
        if m.get('LastCheckTime') is not None:
            self.last_check_time = m.get('LastCheckTime')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeAclChecksResponseBodyCheckRecords(TeaModel):
    def __init__(
        self,
        acl_type: str = None,
        records: List[DescribeAclChecksResponseBodyCheckRecordsRecords] = None,
    ):
        self.acl_type = acl_type
        self.records = records

    def validate(self):
        if self.records:
            for k in self.records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_type is not None:
            result['AclType'] = self.acl_type
        result['Records'] = []
        if self.records is not None:
            for k in self.records:
                result['Records'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclType') is not None:
            self.acl_type = m.get('AclType')
        self.records = []
        if m.get('Records') is not None:
            for k in m.get('Records'):
                temp_model = DescribeAclChecksResponseBodyCheckRecordsRecords()
                self.records.append(temp_model.from_map(k))
        return self


class DescribeAclChecksResponseBody(TeaModel):
    def __init__(
        self,
        check_records: DescribeAclChecksResponseBodyCheckRecords = None,
        request_id: str = None,
    ):
        self.check_records = check_records
        self.request_id = request_id

    def validate(self):
        if self.check_records:
            self.check_records.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_records is not None:
            result['CheckRecords'] = self.check_records.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckRecords') is not None:
            temp_model = DescribeAclChecksResponseBodyCheckRecords()
            self.check_records = temp_model.from_map(m['CheckRecords'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAclChecksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAclChecksResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAclChecksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAclRuleCountRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        source_ip: str = None,
    ):
        self.lang = lang
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeAclRuleCountResponseBody(TeaModel):
    def __init__(
        self,
        internet_in_acl_count: int = None,
        internet_out_acl_count: int = None,
        nat_in_acl_count: int = None,
        nat_out_acl_count: int = None,
        request_id: str = None,
        total_acl_count: int = None,
        vpc_acl_count: int = None,
    ):
        self.internet_in_acl_count = internet_in_acl_count
        self.internet_out_acl_count = internet_out_acl_count
        self.nat_in_acl_count = nat_in_acl_count
        self.nat_out_acl_count = nat_out_acl_count
        self.request_id = request_id
        self.total_acl_count = total_acl_count
        self.vpc_acl_count = vpc_acl_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.internet_in_acl_count is not None:
            result['InternetInAclCount'] = self.internet_in_acl_count
        if self.internet_out_acl_count is not None:
            result['InternetOutAclCount'] = self.internet_out_acl_count
        if self.nat_in_acl_count is not None:
            result['NatInAclCount'] = self.nat_in_acl_count
        if self.nat_out_acl_count is not None:
            result['NatOutAclCount'] = self.nat_out_acl_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_acl_count is not None:
            result['TotalAclCount'] = self.total_acl_count
        if self.vpc_acl_count is not None:
            result['VpcAclCount'] = self.vpc_acl_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InternetInAclCount') is not None:
            self.internet_in_acl_count = m.get('InternetInAclCount')
        if m.get('InternetOutAclCount') is not None:
            self.internet_out_acl_count = m.get('InternetOutAclCount')
        if m.get('NatInAclCount') is not None:
            self.nat_in_acl_count = m.get('NatInAclCount')
        if m.get('NatOutAclCount') is not None:
            self.nat_out_acl_count = m.get('NatOutAclCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalAclCount') is not None:
            self.total_acl_count = m.get('TotalAclCount')
        if m.get('VpcAclCount') is not None:
            self.vpc_acl_count = m.get('VpcAclCount')
        return self


class DescribeAclRuleCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAclRuleCountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAclRuleCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAclWhitelistRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        source_ip: str = None,
    ):
        self.lang = lang
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeAclWhitelistResponseBody(TeaModel):
    def __init__(
        self,
        domain_group_use_dns: bool = None,
        nat_domain_group_use_dns: bool = None,
        request_id: str = None,
        support_message_type: bool = None,
        vpc_domain_group_use_dns: bool = None,
    ):
        self.domain_group_use_dns = domain_group_use_dns
        self.nat_domain_group_use_dns = nat_domain_group_use_dns
        self.request_id = request_id
        self.support_message_type = support_message_type
        self.vpc_domain_group_use_dns = vpc_domain_group_use_dns

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_group_use_dns is not None:
            result['DomainGroupUseDns'] = self.domain_group_use_dns
        if self.nat_domain_group_use_dns is not None:
            result['NatDomainGroupUseDns'] = self.nat_domain_group_use_dns
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.support_message_type is not None:
            result['SupportMessageType'] = self.support_message_type
        if self.vpc_domain_group_use_dns is not None:
            result['VpcDomainGroupUseDns'] = self.vpc_domain_group_use_dns
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainGroupUseDns') is not None:
            self.domain_group_use_dns = m.get('DomainGroupUseDns')
        if m.get('NatDomainGroupUseDns') is not None:
            self.nat_domain_group_use_dns = m.get('NatDomainGroupUseDns')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SupportMessageType') is not None:
            self.support_message_type = m.get('SupportMessageType')
        if m.get('VpcDomainGroupUseDns') is not None:
            self.vpc_domain_group_use_dns = m.get('VpcDomainGroupUseDns')
        return self


class DescribeAclWhitelistResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAclWhitelistResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAclWhitelistResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAddressBookRequest(TeaModel):
    def __init__(
        self,
        contain_port: str = None,
        current_page: str = None,
        group_type: str = None,
        lang: str = None,
        page_size: str = None,
        query: str = None,
    ):
        # The port that is included in the address book. This parameter takes effect only when the **GroupType** parameter is set to **port**.
        self.contain_port = contain_port
        # The page number.
        # 
        # Pages start from page 1. Default value: 1.
        self.current_page = current_page
        # The type of the address book. Valid values:
        # 
        # *   **ip**: IP address book
        # *   **domain**: domain address book
        # *   **port**: port address book
        # *   **tag**: Elastic Compute Service (ECS) tag-based address book
        # *   **allCloud**: cloud service address book
        # *   **threat**: threat intelligence address book
        # *   **ipv6**: IPv6 address book
        # >  If you do not specify a type, the domain address books and ECS tag-based address books are queried.
        self.group_type = group_type
        # The language of the content within the request. Valid values:
        # 
        # *   **zh** (default): Chinese
        # *   **en**: English
        self.lang = lang
        # The number of entries per page.
        # 
        # Default value: 10. Maximum value: 50.
        self.page_size = page_size
        # The query condition that is used to search for the address book.
        self.query = query

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contain_port is not None:
            result['ContainPort'] = self.contain_port
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.group_type is not None:
            result['GroupType'] = self.group_type
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query is not None:
            result['Query'] = self.query
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContainPort') is not None:
            self.contain_port = m.get('ContainPort')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('GroupType') is not None:
            self.group_type = m.get('GroupType')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Query') is not None:
            self.query = m.get('Query')
        return self


class DescribeAddressBookResponseBodyAclsAckLabels(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeAddressBookResponseBodyAclsAddresses(TeaModel):
    def __init__(
        self,
        address: str = None,
        note: str = None,
    ):
        # Address information in the address book.
        self.address = address
        # Single address description.
        self.note = note

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        if self.note is not None:
            result['Note'] = self.note
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('Note') is not None:
            self.note = m.get('Note')
        return self


class DescribeAddressBookResponseBodyAclsTagList(TeaModel):
    def __init__(
        self,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # The key of the ECS tag.
        self.tag_key = tag_key
        # The value of the ECS tag.
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class DescribeAddressBookResponseBodyAcls(TeaModel):
    def __init__(
        self,
        ack_cluster_connector_id: str = None,
        ack_cluster_connector_name: str = None,
        ack_labels: List[DescribeAddressBookResponseBodyAclsAckLabels] = None,
        ack_namespaces: List[str] = None,
        address_list: List[str] = None,
        address_list_count: int = None,
        addresses: List[DescribeAddressBookResponseBodyAclsAddresses] = None,
        auto_add_tag_ecs: int = None,
        description: str = None,
        group_name: str = None,
        group_type: str = None,
        group_uuid: str = None,
        reference_count: int = None,
        region_no: str = None,
        tag_list: List[DescribeAddressBookResponseBodyAclsTagList] = None,
        tag_relation: str = None,
    ):
        self.ack_cluster_connector_id = ack_cluster_connector_id
        self.ack_cluster_connector_name = ack_cluster_connector_name
        self.ack_labels = ack_labels
        self.ack_namespaces = ack_namespaces
        # The addresses in the address book.
        self.address_list = address_list
        # The number of addresses in the address book.
        self.address_list_count = address_list_count
        # A list of addresses in the address book, each with a single address description.
        self.addresses = addresses
        # Indicates whether the public IP addresses of ECS instances are automatically added to the address book if the instances match the specified tags. The setting takes effect on both newly purchased ECS instances whose tag settings are complete and ECS instances whose tag settings are modified. Valid values:
        # 
        # *   **1**: yes
        # *   **0**: no
        self.auto_add_tag_ecs = auto_add_tag_ecs
        # The description of the address book.
        self.description = description
        # The name of the address book.
        self.group_name = group_name
        # The type of the address book. Valid values:
        # 
        # *   **ip**: IP address book
        # *   **domain**: domain address book
        # *   **port**: port address book
        # *   **tag**: ECS tag-based address book
        # *   **allCloud**: cloud service address book
        # *   **threat**: threat intelligence address book
        self.group_type = group_type
        # The UUID of the address book.
        self.group_uuid = group_uuid
        # The number of times that the address book is referenced.
        self.reference_count = reference_count
        self.region_no = region_no
        # The details about the ECS tags that can be automatically added to the address book.
        self.tag_list = tag_list
        # The logical relationship among ECS tags. Valid values:
        # 
        # *   **and**: Only the public IP addresses of ECS instances that match all the specified tags can be added to the address book.
        # *   **or**: The public IP addresses of ECS instances that match any of the specified tags can be added to the address book.
        self.tag_relation = tag_relation

    def validate(self):
        if self.ack_labels:
            for k in self.ack_labels:
                if k:
                    k.validate()
        if self.addresses:
            for k in self.addresses:
                if k:
                    k.validate()
        if self.tag_list:
            for k in self.tag_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ack_cluster_connector_id is not None:
            result['AckClusterConnectorId'] = self.ack_cluster_connector_id
        if self.ack_cluster_connector_name is not None:
            result['AckClusterConnectorName'] = self.ack_cluster_connector_name
        result['AckLabels'] = []
        if self.ack_labels is not None:
            for k in self.ack_labels:
                result['AckLabels'].append(k.to_map() if k else None)
        if self.ack_namespaces is not None:
            result['AckNamespaces'] = self.ack_namespaces
        if self.address_list is not None:
            result['AddressList'] = self.address_list
        if self.address_list_count is not None:
            result['AddressListCount'] = self.address_list_count
        result['Addresses'] = []
        if self.addresses is not None:
            for k in self.addresses:
                result['Addresses'].append(k.to_map() if k else None)
        if self.auto_add_tag_ecs is not None:
            result['AutoAddTagEcs'] = self.auto_add_tag_ecs
        if self.description is not None:
            result['Description'] = self.description
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.group_type is not None:
            result['GroupType'] = self.group_type
        if self.group_uuid is not None:
            result['GroupUuid'] = self.group_uuid
        if self.reference_count is not None:
            result['ReferenceCount'] = self.reference_count
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        result['TagList'] = []
        if self.tag_list is not None:
            for k in self.tag_list:
                result['TagList'].append(k.to_map() if k else None)
        if self.tag_relation is not None:
            result['TagRelation'] = self.tag_relation
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AckClusterConnectorId') is not None:
            self.ack_cluster_connector_id = m.get('AckClusterConnectorId')
        if m.get('AckClusterConnectorName') is not None:
            self.ack_cluster_connector_name = m.get('AckClusterConnectorName')
        self.ack_labels = []
        if m.get('AckLabels') is not None:
            for k in m.get('AckLabels'):
                temp_model = DescribeAddressBookResponseBodyAclsAckLabels()
                self.ack_labels.append(temp_model.from_map(k))
        if m.get('AckNamespaces') is not None:
            self.ack_namespaces = m.get('AckNamespaces')
        if m.get('AddressList') is not None:
            self.address_list = m.get('AddressList')
        if m.get('AddressListCount') is not None:
            self.address_list_count = m.get('AddressListCount')
        self.addresses = []
        if m.get('Addresses') is not None:
            for k in m.get('Addresses'):
                temp_model = DescribeAddressBookResponseBodyAclsAddresses()
                self.addresses.append(temp_model.from_map(k))
        if m.get('AutoAddTagEcs') is not None:
            self.auto_add_tag_ecs = m.get('AutoAddTagEcs')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('GroupType') is not None:
            self.group_type = m.get('GroupType')
        if m.get('GroupUuid') is not None:
            self.group_uuid = m.get('GroupUuid')
        if m.get('ReferenceCount') is not None:
            self.reference_count = m.get('ReferenceCount')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        self.tag_list = []
        if m.get('TagList') is not None:
            for k in m.get('TagList'):
                temp_model = DescribeAddressBookResponseBodyAclsTagList()
                self.tag_list.append(temp_model.from_map(k))
        if m.get('TagRelation') is not None:
            self.tag_relation = m.get('TagRelation')
        return self


class DescribeAddressBookResponseBody(TeaModel):
    def __init__(
        self,
        acls: List[DescribeAddressBookResponseBodyAcls] = None,
        page_no: str = None,
        page_size: str = None,
        request_id: str = None,
        total_count: str = None,
    ):
        # The information about the address book.
        self.acls = acls
        # The page number.
        self.page_no = page_no
        # The number of entries per page.
        self.page_size = page_size
        # The request ID.
        self.request_id = request_id
        # The total number of the returned address books.
        self.total_count = total_count

    def validate(self):
        if self.acls:
            for k in self.acls:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Acls'] = []
        if self.acls is not None:
            for k in self.acls:
                result['Acls'].append(k.to_map() if k else None)
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.acls = []
        if m.get('Acls') is not None:
            for k in m.get('Acls'):
                temp_model = DescribeAddressBookResponseBodyAcls()
                self.acls.append(temp_model.from_map(k))
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAddressBookResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAddressBookResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAddressBookResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAssetListRequest(TeaModel):
    def __init__(
        self,
        current_page: str = None,
        ip_version: str = None,
        lang: str = None,
        member_uid: int = None,
        new_resource_tag: str = None,
        out_statistic: str = None,
        page_size: str = None,
        region_no: str = None,
        resource_type: str = None,
        search_item: str = None,
        sensitive_status: str = None,
        sg_status: str = None,
        status: str = None,
        type: str = None,
        user_type: str = None,
    ):
        # The page number. Valid values: 1 to 50.
        # 
        # This parameter is required.
        self.current_page = current_page
        # The IP version of the asset that is protected by Cloud Firewall. Valid values:
        # 
        # *   **4**: IPv4 (default)
        # *   **6**: IPv6
        self.ip_version = ip_version
        # The language of the content within the response. Valid values:
        # 
        # *   **zh**: Chinese (default)
        # *   **en**: English
        self.lang = lang
        # The UID of the member that is added to Cloud Firewall.
        self.member_uid = member_uid
        # The time when the asset was added. Valid values:
        # 
        # *   **discovered in 1 hour**: within one hour.
        # *   **discovered in 1 day**: within one day.
        # *   **discovered in 7 days**: within seven days.
        self.new_resource_tag = new_resource_tag
        # Whether to query external traffic information.
        self.out_statistic = out_statistic
        # The number of entries per page. Valid values: 1 to 50.
        # 
        # This parameter is required.
        self.page_size = page_size
        # The region ID of your Cloud Firewall.
        # 
        # > For more information about the regions, see [Supported regions](https://help.aliyun.com/document_detail/195657.html).
        self.region_no = region_no
        # The type of the asset. Valid values:
        # 
        # *   **BastionHostEgressIP**: the egress IP address of a bastion host
        # *   **BastionHostIngressIP**: the ingress IP address of a bastion host
        # *   **EcsEIP**: the elastic IP address (EIP) of an Elastic Compute Service (ECS) instance
        # *   **EcsPublicIP**: the public IP address of an ECS instance
        # *   **EIP**: the EIP
        # *   **EniEIP**: the EIP of an elastic network interface (ENI)
        # *   **NatEIP**: the EIP of a NAT gateway
        # *   **SlbEIP**: the EIP of a Server Load Balancer (SLB) instance or a Classic Load Balancer (CLB) instance
        # *   **SlbPublicIP**: the public IP address of an SLB instance or a CLB instance
        # *   **NatPublicIP**: the public IP address of a NAT gateway
        # *   **HAVIP**: the high-availability virtual IP address (HAVIP)
        self.resource_type = resource_type
        # The instance ID or IP address of the asset.
        self.search_item = search_item
        # Data leakage detection activation status.
        self.sensitive_status = sensitive_status
        # The status of the security group policy. Valid values:
        # 
        # *   **pass**: delivered
        # *   **block**: undelivered
        # *   **unsupport**: unsupported
        # 
        # > If you do not specify this parameter, the assets on which security group policies in all states take effect are queried.
        self.sg_status = sg_status
        # The status of the firewall. Valid values:
        # 
        # *   **open**: The firewall is enabled.
        # *   **opening**: The firewall is being enabled.
        # *   **closed**: The firewall is disabled.
        # *   **closing**: The firewall is being disabled.
        # 
        # > If you do not specify this parameter, the assets that are configured for firewalls in all states are queried.
        self.status = status
        # This parameter is deprecated.
        self.type = type
        # The edition of Cloud Firewall. Valid values:
        # 
        # *   **buy**: a paid edition (default)
        # *   **free**: Free Edition
        self.user_type = user_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.ip_version is not None:
            result['IpVersion'] = self.ip_version
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.new_resource_tag is not None:
            result['NewResourceTag'] = self.new_resource_tag
        if self.out_statistic is not None:
            result['OutStatistic'] = self.out_statistic
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.search_item is not None:
            result['SearchItem'] = self.search_item
        if self.sensitive_status is not None:
            result['SensitiveStatus'] = self.sensitive_status
        if self.sg_status is not None:
            result['SgStatus'] = self.sg_status
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.user_type is not None:
            result['UserType'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('IpVersion') is not None:
            self.ip_version = m.get('IpVersion')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('NewResourceTag') is not None:
            self.new_resource_tag = m.get('NewResourceTag')
        if m.get('OutStatistic') is not None:
            self.out_statistic = m.get('OutStatistic')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('SearchItem') is not None:
            self.search_item = m.get('SearchItem')
        if m.get('SensitiveStatus') is not None:
            self.sensitive_status = m.get('SensitiveStatus')
        if m.get('SgStatus') is not None:
            self.sg_status = m.get('SgStatus')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UserType') is not None:
            self.user_type = m.get('UserType')
        return self


class DescribeAssetListResponseBodyAssets(TeaModel):
    def __init__(
        self,
        ali_uid: int = None,
        bind_instance_id: str = None,
        bind_instance_name: str = None,
        create_time_stamp: str = None,
        internet_address: str = None,
        intranet_address: str = None,
        ip_version: int = None,
        last_7day_out_traffic_bytes: int = None,
        member_uid: int = None,
        name: str = None,
        new_resource_tag: str = None,
        note: str = None,
        protect_status: str = None,
        region_id: str = None,
        region_status: str = None,
        resource_instance_id: str = None,
        resource_type: str = None,
        risk_level: str = None,
        sensitive_data_status: str = None,
        sg_status: str = None,
        sg_status_time: int = None,
        sync_status: str = None,
        type: str = None,
    ):
        # The UID of the Alibaba Cloud account.
        # 
        # >  The value of this parameter indicates the management account to which the member is added.
        self.ali_uid = ali_uid
        # The ID of the cloud resource with which the asset is associated.
        self.bind_instance_id = bind_instance_id
        # The instance name of the asset.
        self.bind_instance_name = bind_instance_name
        # The timestamp when the asset is added to Cloud Firewall.
        self.create_time_stamp = create_time_stamp
        # The public IP address of the server.
        self.internet_address = internet_address
        # The internal IP address of the server.
        self.intranet_address = intranet_address
        # The IP version of the asset that is protected by Cloud Firewall.
        # 
        # Valid values:
        # 
        # *   **4**: IPv4
        # *   **6**: IPv6
        self.ip_version = ip_version
        # Outbound traffic in the last 7 days.
        self.last_7day_out_traffic_bytes = last_7day_out_traffic_bytes
        # The UID of the member.
        self.member_uid = member_uid
        # The instance name of the asset that is protected by Cloud Firewall.
        self.name = name
        # The time when the asset was added. Valid values:
        # 
        # *   **discovered in 1 hour**: within one hour.
        # *   **discovered in 1 day**: within one day.
        # *   **discovered in 7 days**: within seven days.
        self.new_resource_tag = new_resource_tag
        # The remarks of the asset. Valid values:
        # 
        # *   **REGION_NOT_SUPPORT**: The region is not supported.
        # *   **NETWORK_NOT_SUPPORT**: The network is not supported.
        self.note = note
        # The status of the firewall. Valid values:
        # 
        # *   **open**: enabled.
        # *   **opening**: being enabled.
        # *   **closed**: disabled.
        # *   **closing**: being disabled.
        self.protect_status = protect_status
        # The ID of the region in which the asset resides.
        self.region_id = region_id
        # Indicates whether the firewall is supported in the region in which the asset resides. Valid values:
        # 
        # *   **enable**: yes
        # *   **disable**: no
        self.region_status = region_status
        # The instance ID of the asset.
        self.resource_instance_id = resource_instance_id
        # The type of the asset. Valid values:
        # 
        # *   **BastionHostEgressIP**: the egress IP address of a bastion host
        # *   **BastionHostIngressIP**: the ingress IP address of a bastion host
        # *   **EcsEIP**: the elastic IP address (EIP) of an Elastic Compute Service (ECS) instance
        # *   **EcsPublicIP**: the public IP address of an ECS instance
        # *   **EIP**: the EIP
        # *   **EniEIP**: the EIP of an elastic network interface (ENI)
        # *   **NatEIP**: the EIP of a NAT gateway
        # *   **SlbEIP**: the EIP of a Server Load Balancer (SLB) instance
        # *   **SlbPublicIP**: the public IP address of an SLB instance
        # *   **NatPublicIP**: the public IP address of a NAT gateway
        # *   **HAVIP**: the high-availability virtual IP address (HAVIP)
        self.resource_type = resource_type
        # The risk level of the asset. Valid values:
        # 
        # *   **low**: low
        # *   **middle**: medium
        # *   **hight**: high
        # 
        # >  The value of this parameter is returned only when the UserType parameter is set to free.
        self.risk_level = risk_level
        # Data leakage detection enabled status.
        self.sensitive_data_status = sensitive_data_status
        # The status of the security group policy. Valid values:
        # 
        # *   **pass**: applied
        # *   **block**: not applied
        # *   **unsupport**: unsupported
        self.sg_status = sg_status
        # The time when the status of the security group was last checked. The value is a UNIX timestamp. Unit: seconds.
        self.sg_status_time = sg_status_time
        # Indicates whether traffic redirection is supported for the asset. Valid values:
        # 
        # *   **enable**: yes
        # *   **disable**: no
        self.sync_status = sync_status
        # This parameter is deprecated.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.bind_instance_id is not None:
            result['BindInstanceId'] = self.bind_instance_id
        if self.bind_instance_name is not None:
            result['BindInstanceName'] = self.bind_instance_name
        if self.create_time_stamp is not None:
            result['CreateTimeStamp'] = self.create_time_stamp
        if self.internet_address is not None:
            result['InternetAddress'] = self.internet_address
        if self.intranet_address is not None:
            result['IntranetAddress'] = self.intranet_address
        if self.ip_version is not None:
            result['IpVersion'] = self.ip_version
        if self.last_7day_out_traffic_bytes is not None:
            result['Last7DayOutTrafficBytes'] = self.last_7day_out_traffic_bytes
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.name is not None:
            result['Name'] = self.name
        if self.new_resource_tag is not None:
            result['NewResourceTag'] = self.new_resource_tag
        if self.note is not None:
            result['Note'] = self.note
        if self.protect_status is not None:
            result['ProtectStatus'] = self.protect_status
        if self.region_id is not None:
            result['RegionID'] = self.region_id
        if self.region_status is not None:
            result['RegionStatus'] = self.region_status
        if self.resource_instance_id is not None:
            result['ResourceInstanceId'] = self.resource_instance_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.sensitive_data_status is not None:
            result['SensitiveDataStatus'] = self.sensitive_data_status
        if self.sg_status is not None:
            result['SgStatus'] = self.sg_status
        if self.sg_status_time is not None:
            result['SgStatusTime'] = self.sg_status_time
        if self.sync_status is not None:
            result['SyncStatus'] = self.sync_status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('BindInstanceId') is not None:
            self.bind_instance_id = m.get('BindInstanceId')
        if m.get('BindInstanceName') is not None:
            self.bind_instance_name = m.get('BindInstanceName')
        if m.get('CreateTimeStamp') is not None:
            self.create_time_stamp = m.get('CreateTimeStamp')
        if m.get('InternetAddress') is not None:
            self.internet_address = m.get('InternetAddress')
        if m.get('IntranetAddress') is not None:
            self.intranet_address = m.get('IntranetAddress')
        if m.get('IpVersion') is not None:
            self.ip_version = m.get('IpVersion')
        if m.get('Last7DayOutTrafficBytes') is not None:
            self.last_7day_out_traffic_bytes = m.get('Last7DayOutTrafficBytes')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NewResourceTag') is not None:
            self.new_resource_tag = m.get('NewResourceTag')
        if m.get('Note') is not None:
            self.note = m.get('Note')
        if m.get('ProtectStatus') is not None:
            self.protect_status = m.get('ProtectStatus')
        if m.get('RegionID') is not None:
            self.region_id = m.get('RegionID')
        if m.get('RegionStatus') is not None:
            self.region_status = m.get('RegionStatus')
        if m.get('ResourceInstanceId') is not None:
            self.resource_instance_id = m.get('ResourceInstanceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('SensitiveDataStatus') is not None:
            self.sensitive_data_status = m.get('SensitiveDataStatus')
        if m.get('SgStatus') is not None:
            self.sg_status = m.get('SgStatus')
        if m.get('SgStatusTime') is not None:
            self.sg_status_time = m.get('SgStatusTime')
        if m.get('SyncStatus') is not None:
            self.sync_status = m.get('SyncStatus')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeAssetListResponseBody(TeaModel):
    def __init__(
        self,
        assets: List[DescribeAssetListResponseBodyAssets] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The assets that are protected by Cloud Firewall.
        self.assets = assets
        # The ID of the request.
        self.request_id = request_id
        # The total number of the assets that are protected by Cloud Firewall.
        self.total_count = total_count

    def validate(self):
        if self.assets:
            for k in self.assets:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Assets'] = []
        if self.assets is not None:
            for k in self.assets:
                result['Assets'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.assets = []
        if m.get('Assets') is not None:
            for k in m.get('Assets'):
                temp_model = DescribeAssetListResponseBodyAssets()
                self.assets.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAssetListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAssetListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAssetListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAssetRiskListRequest(TeaModel):
    def __init__(
        self,
        ip_addr_list: List[str] = None,
        ip_version: int = None,
        lang: str = None,
        source_ip: str = None,
    ):
        # The IP addresses to query. Separate the IP addresses with commas (,). You can specify up to 20 IP addresses at a time.
        # 
        # > 
        # 
        # *   Example IPv4 address: 47.97.XX.XX.
        # 
        # *   Example IPv6 address: 2001:db8:ffff:ffff:ffff:XXXX:ffff.
        self.ip_addr_list = ip_addr_list
        # The IP version of the asset that is protected by Cloud Firewall.
        # 
        # Valid values:
        # 
        # *   **4** (default): IPv4
        # *   **6**: IPv6
        # 
        # This parameter is required.
        self.ip_version = ip_version
        # The language of the content within the response. Valid values:
        # 
        # *   **zh** (default): Chinese
        # *   **en**: English
        self.lang = lang
        # The source IP address of the request.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_addr_list is not None:
            result['IpAddrList'] = self.ip_addr_list
        if self.ip_version is not None:
            result['IpVersion'] = self.ip_version
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IpAddrList') is not None:
            self.ip_addr_list = m.get('IpAddrList')
        if m.get('IpVersion') is not None:
            self.ip_version = m.get('IpVersion')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeAssetRiskListResponseBodyAssetList(TeaModel):
    def __init__(
        self,
        ip: str = None,
        ip_version: int = None,
        reason: str = None,
        risk_level: str = None,
    ):
        # The IP address of the server.
        self.ip = ip
        # The IP version of the asset that is protected by Cloud Firewall.
        # 
        # Valid values:
        # 
        # *   **4**: IPv4
        # *   **6**: IPv6
        self.ip_version = ip_version
        # The reason for the risk.
        self.reason = reason
        # The risk level. Valid values:
        # 
        # *   **low**\
        # *   **middle**\
        # *   **high**\
        self.risk_level = risk_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.ip_version is not None:
            result['IpVersion'] = self.ip_version
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('IpVersion') is not None:
            self.ip_version = m.get('IpVersion')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        return self


class DescribeAssetRiskListResponseBody(TeaModel):
    def __init__(
        self,
        asset_list: List[DescribeAssetRiskListResponseBodyAssetList] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The details of the assets.
        self.asset_list = asset_list
        # The ID of the request.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.asset_list:
            for k in self.asset_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AssetList'] = []
        if self.asset_list is not None:
            for k in self.asset_list:
                result['AssetList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.asset_list = []
        if m.get('AssetList') is not None:
            for k in m.get('AssetList'):
                temp_model = DescribeAssetRiskListResponseBodyAssetList()
                self.asset_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAssetRiskListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAssetRiskListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAssetRiskListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAssetStatisticRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        source_ip: str = None,
    ):
        # The language of the content within the request. Valid values:
        # 
        # *   **zh** (default): Chinese
        # *   **en**: English
        self.lang = lang
        # The source IP address of the request.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeAssetStatisticResponseBodyGeneralInstanceSpecStatisticCfwGeneralInstanceRegionStatistic(TeaModel):
    def __init__(
        self,
        member_list: List[str] = None,
        region_no: str = None,
    ):
        self.member_list = member_list
        self.region_no = region_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.member_list is not None:
            result['MemberList'] = self.member_list
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MemberList') is not None:
            self.member_list = m.get('MemberList')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        return self


class DescribeAssetStatisticResponseBodyGeneralInstanceSpecStatistic(TeaModel):
    def __init__(
        self,
        cfw_general_instance_region_statistic: List[DescribeAssetStatisticResponseBodyGeneralInstanceSpecStatisticCfwGeneralInstanceRegionStatistic] = None,
        total_cfw_general_instance_cnt: int = None,
        total_cfw_general_instance_used_cnt: int = None,
        total_general_instance_used_cnt: int = None,
        total_nat_general_instance_cnt: int = None,
        total_nat_general_instance_used_cnt: int = None,
        total_vfw_general_instance_used_cnt: int = None,
    ):
        self.cfw_general_instance_region_statistic = cfw_general_instance_region_statistic
        self.total_cfw_general_instance_cnt = total_cfw_general_instance_cnt
        self.total_cfw_general_instance_used_cnt = total_cfw_general_instance_used_cnt
        self.total_general_instance_used_cnt = total_general_instance_used_cnt
        self.total_nat_general_instance_cnt = total_nat_general_instance_cnt
        self.total_nat_general_instance_used_cnt = total_nat_general_instance_used_cnt
        self.total_vfw_general_instance_used_cnt = total_vfw_general_instance_used_cnt

    def validate(self):
        if self.cfw_general_instance_region_statistic:
            for k in self.cfw_general_instance_region_statistic:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CfwGeneralInstanceRegionStatistic'] = []
        if self.cfw_general_instance_region_statistic is not None:
            for k in self.cfw_general_instance_region_statistic:
                result['CfwGeneralInstanceRegionStatistic'].append(k.to_map() if k else None)
        if self.total_cfw_general_instance_cnt is not None:
            result['TotalCfwGeneralInstanceCnt'] = self.total_cfw_general_instance_cnt
        if self.total_cfw_general_instance_used_cnt is not None:
            result['TotalCfwGeneralInstanceUsedCnt'] = self.total_cfw_general_instance_used_cnt
        if self.total_general_instance_used_cnt is not None:
            result['TotalGeneralInstanceUsedCnt'] = self.total_general_instance_used_cnt
        if self.total_nat_general_instance_cnt is not None:
            result['TotalNatGeneralInstanceCnt'] = self.total_nat_general_instance_cnt
        if self.total_nat_general_instance_used_cnt is not None:
            result['TotalNatGeneralInstanceUsedCnt'] = self.total_nat_general_instance_used_cnt
        if self.total_vfw_general_instance_used_cnt is not None:
            result['TotalVfwGeneralInstanceUsedCnt'] = self.total_vfw_general_instance_used_cnt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cfw_general_instance_region_statistic = []
        if m.get('CfwGeneralInstanceRegionStatistic') is not None:
            for k in m.get('CfwGeneralInstanceRegionStatistic'):
                temp_model = DescribeAssetStatisticResponseBodyGeneralInstanceSpecStatisticCfwGeneralInstanceRegionStatistic()
                self.cfw_general_instance_region_statistic.append(temp_model.from_map(k))
        if m.get('TotalCfwGeneralInstanceCnt') is not None:
            self.total_cfw_general_instance_cnt = m.get('TotalCfwGeneralInstanceCnt')
        if m.get('TotalCfwGeneralInstanceUsedCnt') is not None:
            self.total_cfw_general_instance_used_cnt = m.get('TotalCfwGeneralInstanceUsedCnt')
        if m.get('TotalGeneralInstanceUsedCnt') is not None:
            self.total_general_instance_used_cnt = m.get('TotalGeneralInstanceUsedCnt')
        if m.get('TotalNatGeneralInstanceCnt') is not None:
            self.total_nat_general_instance_cnt = m.get('TotalNatGeneralInstanceCnt')
        if m.get('TotalNatGeneralInstanceUsedCnt') is not None:
            self.total_nat_general_instance_used_cnt = m.get('TotalNatGeneralInstanceUsedCnt')
        if m.get('TotalVfwGeneralInstanceUsedCnt') is not None:
            self.total_vfw_general_instance_used_cnt = m.get('TotalVfwGeneralInstanceUsedCnt')
        return self


class DescribeAssetStatisticResponseBodyResourceSpecStatistic(TeaModel):
    def __init__(
        self,
        ip_num_spec: int = None,
        ip_num_used: int = None,
        sensitive_data_ip_num_spec: int = None,
        sensitive_data_ip_num_used: int = None,
    ):
        # The number of public IP addresses that can be protected.
        self.ip_num_spec = ip_num_spec
        # The number of public IP addresses that are protected.
        self.ip_num_used = ip_num_used
        # The number of public IP addresses that can enable data leakage detection.
        self.sensitive_data_ip_num_spec = sensitive_data_ip_num_spec
        # The number of public IP addresses that enabled data leakage detection.
        self.sensitive_data_ip_num_used = sensitive_data_ip_num_used

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_num_spec is not None:
            result['IpNumSpec'] = self.ip_num_spec
        if self.ip_num_used is not None:
            result['IpNumUsed'] = self.ip_num_used
        if self.sensitive_data_ip_num_spec is not None:
            result['SensitiveDataIpNumSpec'] = self.sensitive_data_ip_num_spec
        if self.sensitive_data_ip_num_used is not None:
            result['SensitiveDataIpNumUsed'] = self.sensitive_data_ip_num_used
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IpNumSpec') is not None:
            self.ip_num_spec = m.get('IpNumSpec')
        if m.get('IpNumUsed') is not None:
            self.ip_num_used = m.get('IpNumUsed')
        if m.get('SensitiveDataIpNumSpec') is not None:
            self.sensitive_data_ip_num_spec = m.get('SensitiveDataIpNumSpec')
        if m.get('SensitiveDataIpNumUsed') is not None:
            self.sensitive_data_ip_num_used = m.get('SensitiveDataIpNumUsed')
        return self


class DescribeAssetStatisticResponseBody(TeaModel):
    def __init__(
        self,
        general_instance_spec_statistic: DescribeAssetStatisticResponseBodyGeneralInstanceSpecStatistic = None,
        request_id: str = None,
        resource_spec_statistic: DescribeAssetStatisticResponseBodyResourceSpecStatistic = None,
    ):
        self.general_instance_spec_statistic = general_instance_spec_statistic
        # The request ID.
        self.request_id = request_id
        # The statistics on specifications.
        self.resource_spec_statistic = resource_spec_statistic

    def validate(self):
        if self.general_instance_spec_statistic:
            self.general_instance_spec_statistic.validate()
        if self.resource_spec_statistic:
            self.resource_spec_statistic.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.general_instance_spec_statistic is not None:
            result['GeneralInstanceSpecStatistic'] = self.general_instance_spec_statistic.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_spec_statistic is not None:
            result['ResourceSpecStatistic'] = self.resource_spec_statistic.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GeneralInstanceSpecStatistic') is not None:
            temp_model = DescribeAssetStatisticResponseBodyGeneralInstanceSpecStatistic()
            self.general_instance_spec_statistic = temp_model.from_map(m['GeneralInstanceSpecStatistic'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceSpecStatistic') is not None:
            temp_model = DescribeAssetStatisticResponseBodyResourceSpecStatistic()
            self.resource_spec_statistic = temp_model.from_map(m['ResourceSpecStatistic'])
        return self


class DescribeAssetStatisticResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAssetStatisticResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAssetStatisticResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCfwRiskLevelSummaryRequest(TeaModel):
    def __init__(
        self,
        instance_type: str = None,
        lang: str = None,
        region_id: str = None,
    ):
        # The instance type.
        self.instance_type = instance_type
        # The language of the content within the response.
        # 
        # Valid values:
        # 
        # *   **zh** (default): Chinese
        # *   **en**: English
        self.lang = lang
        # The region ID of your Cloud Firewall.
        # 
        # >  For more information about Cloud Firewall supported regions, see [Supported regions](https://help.aliyun.com/document_detail/195657.html).
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeCfwRiskLevelSummaryResponseBodyRiskList(TeaModel):
    def __init__(
        self,
        level: str = None,
        num: str = None,
        type: str = None,
    ):
        # The risk levels. Valid values:
        # 
        # *   **medium**\
        self.level = level
        # The number of at-risk Elastic Compute Service (ECS) instances.
        self.num = num
        # The type.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['Level'] = self.level
        if self.num is not None:
            result['Num'] = self.num
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Num') is not None:
            self.num = m.get('Num')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeCfwRiskLevelSummaryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        risk_list: List[DescribeCfwRiskLevelSummaryResponseBodyRiskList] = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The list of risks.
        self.risk_list = risk_list

    def validate(self):
        if self.risk_list:
            for k in self.risk_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['RiskList'] = []
        if self.risk_list is not None:
            for k in self.risk_list:
                result['RiskList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.risk_list = []
        if m.get('RiskList') is not None:
            for k in m.get('RiskList'):
                temp_model = DescribeCfwRiskLevelSummaryResponseBodyRiskList()
                self.risk_list.append(temp_model.from_map(k))
        return self


class DescribeCfwRiskLevelSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCfwRiskLevelSummaryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCfwRiskLevelSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClearAuthInfoResponseBody(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        left_times: int = None,
        request_id: str = None,
    ):
        self.end_time = end_time
        self.left_times = left_times
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.left_times is not None:
            result['LeftTimes'] = self.left_times
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('LeftTimes') is not None:
            self.left_times = m.get('LeftTimes')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeClearAuthInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeClearAuthInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeClearAuthInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeControlPolicyRequest(TeaModel):
    def __init__(
        self,
        acl_action: str = None,
        acl_uuid: str = None,
        current_page: str = None,
        description: str = None,
        destination: str = None,
        direction: str = None,
        ip_version: str = None,
        lang: str = None,
        page_size: str = None,
        proto: str = None,
        release: str = None,
        repeat_type: str = None,
        source: str = None,
    ):
        # The action that Cloud Firewall performs on the traffic. Valid values:
        # 
        # *   **accept**: allows the traffic.
        # *   **drop**: denies the traffic.
        # *   **log**: monitors the traffic.
        # 
        # >  If you do not specify this parameter, access control policies of all action types are queried.
        self.acl_action = acl_action
        # The unique ID of the access control policy.
        self.acl_uuid = acl_uuid
        # The number of the page to return.
        # 
        # Default value: 1.
        # 
        # This parameter is required.
        self.current_page = current_page
        # The description of the access control policy. Fuzzy match is supported.
        # 
        # >  If you do not specify this parameter, access control policies that have descriptions are queried.
        self.description = description
        # The destination address in the access control policy. Fuzzy match is supported. The value of this parameter varies based on the value of the DestinationType parameter.
        # 
        # *   If you set DestinationType to `net`, the value of Destination is a CIDR block. Example: 10.0.3.0/24.
        # *   If you set DestinationType to `domain`, the value of Destination is a domain name. Example: aliyun.
        # *   If you set DestinationType to `group`, the value of Destination is the name of an address book. Example: db_group.
        # *   If you set DestinationType to `location`, the value of Destination is the name of a location. For more information about location codes, see AddControlPolicy. Example: ["BJ11", "ZB"].
        # 
        # >  If you do not specify this parameter, access control policies of all destination address types are queried.
        self.destination = destination
        # The direction of the traffic to which the access control policies apply. Valid values:
        # 
        # *   **in**: inbound.
        # *   **out**: outbound.
        self.direction = direction
        # The IP version of the address in the access control policy. Valid values:
        # 
        # *   **4**: IPv4 (default)
        # *   **6**: IPv6
        self.ip_version = ip_version
        # The language of the content within the response. Valid values:
        # 
        # *   **zh**: Chinese (default)
        # *   **en**: English
        self.lang = lang
        # The number of entries to return on each page.
        # 
        # This parameter is required.
        self.page_size = page_size
        # The type of the protocol in the access control policy. Valid values:
        # 
        # * **TCP**\
        # * **UDP**\
        # * **ICMP**\
        # * **ANY**: all types of protocols
        # 
        # >  If you do not specify this parameter, access control policies of all protocol types are queried.
        self.proto = proto
        # Specifies whether the access control policy is enabled. By default, an access control policy is enabled after it is created. Valid values:
        # 
        # *   **true**: The access control policy is enabled.
        # *   **false**: The access control policy is disabled.
        self.release = release
        # The recurrence type for the access control policy to take effect. Valid values:
        # 
        # *   **Permanent** (default): The policy always takes effect.
        # *   **None**: The policy takes effect for only once.
        # *   **Daily**: The policy takes effect on a daily basis.
        # *   **Weekly**: The policy takes effect on a weekly basis.
        # *   **Monthly**: The policy takes effect on a monthly basis.
        self.repeat_type = repeat_type
        # The source address in the access control policy. Fuzzy match is supported. The value of this parameter depends on the value of the SourceType parameter.
        # 
        # *   If SourceType is set to `net`, the value of Source must be a CIDR block. Example: 192.0.XX.XX/24.
        # *   If SourceType is set to `group`, the value of Source must be the name of an address book. Example: db_group. If the db_group address book does not contain addresses, all source addresses are queried.
        # *   If SourceType is set to `location`, the value of Source must be a location. Example: beijing.
        # 
        # >  If you do not specify this parameter, access control policies of all source address types are queried.
        self.source = source

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_action is not None:
            result['AclAction'] = self.acl_action
        if self.acl_uuid is not None:
            result['AclUuid'] = self.acl_uuid
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.description is not None:
            result['Description'] = self.description
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.ip_version is not None:
            result['IpVersion'] = self.ip_version
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.proto is not None:
            result['Proto'] = self.proto
        if self.release is not None:
            result['Release'] = self.release
        if self.repeat_type is not None:
            result['RepeatType'] = self.repeat_type
        if self.source is not None:
            result['Source'] = self.source
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclAction') is not None:
            self.acl_action = m.get('AclAction')
        if m.get('AclUuid') is not None:
            self.acl_uuid = m.get('AclUuid')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('IpVersion') is not None:
            self.ip_version = m.get('IpVersion')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Proto') is not None:
            self.proto = m.get('Proto')
        if m.get('Release') is not None:
            self.release = m.get('Release')
        if m.get('RepeatType') is not None:
            self.repeat_type = m.get('RepeatType')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        return self


class DescribeControlPolicyResponseBodyPolicys(TeaModel):
    def __init__(
        self,
        acl_action: str = None,
        acl_uuid: str = None,
        application_id: str = None,
        application_name: str = None,
        application_name_list: List[str] = None,
        create_time: int = None,
        description: str = None,
        dest_port: str = None,
        dest_port_group: str = None,
        dest_port_group_ports: List[str] = None,
        dest_port_type: str = None,
        destination: str = None,
        destination_group_cidrs: List[str] = None,
        destination_group_type: str = None,
        destination_type: str = None,
        direction: str = None,
        dns_result: str = None,
        dns_result_time: int = None,
        domain_resolve_type: str = None,
        end_time: int = None,
        hit_last_time: int = None,
        hit_times: int = None,
        ip_version: int = None,
        modify_time: int = None,
        order: int = None,
        proto: str = None,
        release: str = None,
        repeat_days: List[int] = None,
        repeat_end_time: str = None,
        repeat_start_time: str = None,
        repeat_type: str = None,
        source: str = None,
        source_group_cidrs: List[str] = None,
        source_group_type: str = None,
        source_type: str = None,
        spread_cnt: int = None,
        start_time: int = None,
    ):
        # The action that Cloud Firewall performs on the traffic. Valid values:
        # 
        # *   **accept**: allows the traffic.
        # *   **drop**: denies the traffic.
        # *   **log**: monitors the traffic.
        self.acl_action = acl_action
        # The UUID of the access control policy.
        self.acl_uuid = acl_uuid
        # The application ID in the access control policy.
        self.application_id = application_id
        # The application type supported by the access control policy. We recommend that you specify ApplicationNameList. Valid values:
        # 
        # *   **FTP**\
        # *   **HTTP**\
        # *   **HTTPS**\
        # *   **Memcache**\
        # *   **MongoDB**\
        # *   **MQTT**\
        # *   **MySQL**\
        # *   **RDP**\
        # *   **Redis**\
        # *   **SMTP**\
        # *   **SMTPS**\
        # *   **SSH**\
        # *   **SSL**\
        # *   **VNC**\
        # *   **ANY**: all types of applications
        self.application_name = application_name
        # The application names.
        self.application_name_list = application_name_list
        # The time when the access control policy was created.
        self.create_time = create_time
        # The description of the access control policy.
        self.description = description
        # The destination port in the access control policy.
        self.dest_port = dest_port
        # The name of the destination port address book in the access control policy.
        self.dest_port_group = dest_port_group
        # The ports in the destination port address book.
        self.dest_port_group_ports = dest_port_group_ports
        # The type of the destination port in the access control policy. Valid values:
        # 
        # *   **port**: port
        # *   **group**: port address book
        self.dest_port_type = dest_port_type
        # The destination address in the access control policy. The value of this parameter varies based on the value of DestinationType.
        # 
        # *   If the value of **DestinationType** is **net**, the value of Destination is a CIDR block. Example: 192.0.XX.XX/24.
        # *   If the value of **DestinationType** is **domain**, the value of Destination is a domain name. Example: aliyuncs.com.
        # *   If the value of **DestinationType** is **group**, the value of Destination is the name of an address book. Example: db_group.
        # *   If the value of **DestinationType** is **location**, the value of Destination is the name of a location. For more information about location codes, see AddControlPolicy. Example: ["BJ11", "ZB"].
        self.destination = destination
        # The CIDR blocks in the destination address book.
        self.destination_group_cidrs = destination_group_cidrs
        # The type of the destination address book in the access control policy. Valid values:
        # 
        # *   **ip**: an address book that includes one or more IP addresses
        # *   **tag**: an ECS tag-based address book that includes the IP addresses of the ECS instances with one or more specific tags
        # *   **domain**: an address book that includes one or more domain names
        # *   **threat**: an address book that includes one or more malicious IP addresses or domain names
        # *   **backsrc**: an address book that includes one or more back-to-origin addresses of Anti-DDoS Pro or Anti-DDoS Premium instances or WAF instances
        self.destination_group_type = destination_group_type
        # The type of the destination address in the access control policy. Valid values:
        # 
        # *   **net**: CIDR block
        # *   **group**: address book
        # *   **domain**: domain name
        # *   **location**: location
        self.destination_type = destination_type
        # The direction of the traffic to which the access control policy applies. Valid values:
        # 
        # *   **in**: inbound traffic
        # *   **out**: outbound traffic
        self.direction = direction
        # The DNS resolution results.
        self.dns_result = dns_result
        # The time when the Domain Name System (DNS) resolution was performed. The value is a timestamp. Unit: seconds.
        self.dns_result_time = dns_result_time
        # The domain name resolution method of the access control policy. By default, an access control policy is enabled after the policy is created. Valid values:
        # 
        # * **FQDN**: fully qualified domain name (FQDN)-based resolution
        # * **DNS**: DNS-based dynamic resolution
        # * **FQDN_AND_DNS**: FQDN and DNS-based dynamic resolution
        self.domain_resolve_type = domain_resolve_type
        # The time when the access control policy stops taking effect. The value is a timestamp. Unit: seconds. The end time must be on the hour or on the half hour, and at least 30 minutes later than the start time.
        # 
        # >  If RepeatType is set to Permanent, this parameter is left empty. If RepeatType is set to None, Daily, Weekly, or Monthly, this parameter must be specified.
        self.end_time = end_time
        # The time when the access control policy was last hit. The value is a timestamp. Unit: seconds.
        self.hit_last_time = hit_last_time
        # The number of hits for the access control policy.
        self.hit_times = hit_times
        # The IP version used in the access control policy. Valid values:
        # 
        # *   **4**: IPv4
        # *   **6**: IPv6
        self.ip_version = ip_version
        # The time when the access control policy was modified.
        self.modify_time = modify_time
        # The priority of the access control policy.
        # 
        # The priority value starts from 1. A smaller priority value indicates a higher priority.
        self.order = order
        # The protocol type in the access control policy. Valid values:
        # 
        # *   **ANY**\
        # *   **TCP**\
        # *   **UDP**\
        # *   **ICMP**\
        self.proto = proto
        # The status of the access control policy. By default, an access control policy is enabled after it is created. Valid values:
        # 
        # *   **true**: enabled
        # *   **false**: disabled
        self.release = release
        # The days of a week or of a month on which the access control policy takes effect.
        # 
        # *   If RepeatType is set to `Permanent`, `None`, or `Daily`, this parameter is left empty. Example: [].
        # *   If RepeatType is set to Weekly, this parameter must be specified. Example: [0, 6].
        # 
        # >  If RepeatType is set to Weekly, the fields in the value of RepeatDays cannot be repeated.
        # 
        # *   If RepeatType is set to `Monthly`, this parameter must be specified. Example: [1, 31].
        # 
        # >  If RepeatType is set to Monthly, the fields in the value of RepeatDays cannot be repeated.
        self.repeat_days = repeat_days
        # The point in time when the recurrence ends. Example: 23:30. The value must be on the hour or on the half hour, and at least 30 minutes later than the start time.
        # 
        # >  If RepeatType is set to Permanent or None, this parameter is left empty. If RepeatType is set to Daily, Weekly, or Monthly, this parameter must be specified.
        self.repeat_end_time = repeat_end_time
        # The point in time when the recurrence starts. Example: 08:00. The value must be on the hour or on the half hour, and at least 30 minutes earlier than the end time.
        # 
        # >  If RepeatType is set to Permanent or None, this parameter is left empty. If RepeatType is set to Daily, Weekly, or Monthly, this parameter must be specified.
        self.repeat_start_time = repeat_start_time
        # The recurrence type based on which the access control policy takes effect. Valid values:
        # 
        # *   **Permanent** (default): The policy always takes effect.
        # *   **None**: The policy takes effect for only once.
        # *   **Daily**: The policy takes effect on a daily basis.
        # *   **Weekly**: The policy takes effect on a weekly basis.
        # *   **Monthly**: The policy takes effect on a monthly basis.
        self.repeat_type = repeat_type
        # The source address in the access control policy. Valid values:
        # 
        # *   If **SourceType** is set to `net`, the value of Source is a CIDR block. Example: 192.0.XX.XX/24.
        # *   If **SourceType** is set to `group`, the value of Source is the name of an address book. Example: db_group.
        # *   If **SourceType** is set to `location`, the value of Source is a location. For more information about location codes, see [AddControlPolicy](https://help.aliyun.com/document_detail/138867.html). Example: ["BJ11", "ZB"].
        self.source = source
        # The CIDR blocks in the source address book.
        self.source_group_cidrs = source_group_cidrs
        # The type of the source address book in the access control policy. Valid values:
        # 
        # *   **ip**: an address book that includes one or more IP addresses
        # *   **tag**: an Elastic Compute Service (ECS) tag-based address book that includes the IP addresses of the ECS instances with one or more specific tags
        # *   **domain**: an address book that includes one or more domain names
        # *   **threat**: an address book that includes one or more malicious IP addresses or domain names
        # *   **backsrc**: an address book that includes one or more back-to-origin addresses of Anti-DDoS Pro or Anti-DDoS Premium instances or Web Application Firewall (WAF) instances
        self.source_group_type = source_group_type
        # The type of the source address in the access control policy. Valid values:
        # 
        # *   **net**: CIDR block
        # *   **group**: address book
        # *   **location**: location
        self.source_type = source_type
        # The total quota consumed by the returned access control policies, which is the sum of the quota consumed by each policy. The quota that is consumed by an access control policy is calculated by using the following formula: Quota that is consumed by an access control policy = Number of source addresses (number of CIDR blocks or regions) × Number of destination addresses (number of CIDR blocks, regions, or domain names) × Number of port ranges × Number of applications.
        self.spread_cnt = spread_cnt
        # The time when the access control policy starts to take effect. The value is a timestamp. Unit: seconds. The start time must be on the hour or on the half hour, and at least 30 minutes earlier than the end time.
        # 
        # >  If RepeatType is set to Permanent, this parameter is left empty. If RepeatType is set to None, Daily, Weekly, or Monthly, this parameter must be specified.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_action is not None:
            result['AclAction'] = self.acl_action
        if self.acl_uuid is not None:
            result['AclUuid'] = self.acl_uuid
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.application_name is not None:
            result['ApplicationName'] = self.application_name
        if self.application_name_list is not None:
            result['ApplicationNameList'] = self.application_name_list
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.dest_port is not None:
            result['DestPort'] = self.dest_port
        if self.dest_port_group is not None:
            result['DestPortGroup'] = self.dest_port_group
        if self.dest_port_group_ports is not None:
            result['DestPortGroupPorts'] = self.dest_port_group_ports
        if self.dest_port_type is not None:
            result['DestPortType'] = self.dest_port_type
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.destination_group_cidrs is not None:
            result['DestinationGroupCidrs'] = self.destination_group_cidrs
        if self.destination_group_type is not None:
            result['DestinationGroupType'] = self.destination_group_type
        if self.destination_type is not None:
            result['DestinationType'] = self.destination_type
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.dns_result is not None:
            result['DnsResult'] = self.dns_result
        if self.dns_result_time is not None:
            result['DnsResultTime'] = self.dns_result_time
        if self.domain_resolve_type is not None:
            result['DomainResolveType'] = self.domain_resolve_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.hit_last_time is not None:
            result['HitLastTime'] = self.hit_last_time
        if self.hit_times is not None:
            result['HitTimes'] = self.hit_times
        if self.ip_version is not None:
            result['IpVersion'] = self.ip_version
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.order is not None:
            result['Order'] = self.order
        if self.proto is not None:
            result['Proto'] = self.proto
        if self.release is not None:
            result['Release'] = self.release
        if self.repeat_days is not None:
            result['RepeatDays'] = self.repeat_days
        if self.repeat_end_time is not None:
            result['RepeatEndTime'] = self.repeat_end_time
        if self.repeat_start_time is not None:
            result['RepeatStartTime'] = self.repeat_start_time
        if self.repeat_type is not None:
            result['RepeatType'] = self.repeat_type
        if self.source is not None:
            result['Source'] = self.source
        if self.source_group_cidrs is not None:
            result['SourceGroupCidrs'] = self.source_group_cidrs
        if self.source_group_type is not None:
            result['SourceGroupType'] = self.source_group_type
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.spread_cnt is not None:
            result['SpreadCnt'] = self.spread_cnt
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclAction') is not None:
            self.acl_action = m.get('AclAction')
        if m.get('AclUuid') is not None:
            self.acl_uuid = m.get('AclUuid')
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ApplicationName') is not None:
            self.application_name = m.get('ApplicationName')
        if m.get('ApplicationNameList') is not None:
            self.application_name_list = m.get('ApplicationNameList')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestPort') is not None:
            self.dest_port = m.get('DestPort')
        if m.get('DestPortGroup') is not None:
            self.dest_port_group = m.get('DestPortGroup')
        if m.get('DestPortGroupPorts') is not None:
            self.dest_port_group_ports = m.get('DestPortGroupPorts')
        if m.get('DestPortType') is not None:
            self.dest_port_type = m.get('DestPortType')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('DestinationGroupCidrs') is not None:
            self.destination_group_cidrs = m.get('DestinationGroupCidrs')
        if m.get('DestinationGroupType') is not None:
            self.destination_group_type = m.get('DestinationGroupType')
        if m.get('DestinationType') is not None:
            self.destination_type = m.get('DestinationType')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('DnsResult') is not None:
            self.dns_result = m.get('DnsResult')
        if m.get('DnsResultTime') is not None:
            self.dns_result_time = m.get('DnsResultTime')
        if m.get('DomainResolveType') is not None:
            self.domain_resolve_type = m.get('DomainResolveType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('HitLastTime') is not None:
            self.hit_last_time = m.get('HitLastTime')
        if m.get('HitTimes') is not None:
            self.hit_times = m.get('HitTimes')
        if m.get('IpVersion') is not None:
            self.ip_version = m.get('IpVersion')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('Proto') is not None:
            self.proto = m.get('Proto')
        if m.get('Release') is not None:
            self.release = m.get('Release')
        if m.get('RepeatDays') is not None:
            self.repeat_days = m.get('RepeatDays')
        if m.get('RepeatEndTime') is not None:
            self.repeat_end_time = m.get('RepeatEndTime')
        if m.get('RepeatStartTime') is not None:
            self.repeat_start_time = m.get('RepeatStartTime')
        if m.get('RepeatType') is not None:
            self.repeat_type = m.get('RepeatType')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SourceGroupCidrs') is not None:
            self.source_group_cidrs = m.get('SourceGroupCidrs')
        if m.get('SourceGroupType') is not None:
            self.source_group_type = m.get('SourceGroupType')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('SpreadCnt') is not None:
            self.spread_cnt = m.get('SpreadCnt')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeControlPolicyResponseBody(TeaModel):
    def __init__(
        self,
        page_no: str = None,
        page_size: str = None,
        policys: List[DescribeControlPolicyResponseBodyPolicys] = None,
        request_id: str = None,
        total_count: str = None,
    ):
        # The page number of the returned page.
        self.page_no = page_no
        # The number of entries returned per page.
        self.page_size = page_size
        # The information about the access control policies.
        self.policys = policys
        # The ID of the request.
        self.request_id = request_id
        # The total number of the returned access control policies.
        self.total_count = total_count

    def validate(self):
        if self.policys:
            for k in self.policys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Policys'] = []
        if self.policys is not None:
            for k in self.policys:
                result['Policys'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.policys = []
        if m.get('Policys') is not None:
            for k in m.get('Policys'):
                temp_model = DescribeControlPolicyResponseBodyPolicys()
                self.policys.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeControlPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeControlPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeControlPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCtrlInstanceMemberAccountsResponseBody(TeaModel):
    def __init__(
        self,
        instance_member_count: int = None,
        max_instance_member_num: int = None,
        request_id: str = None,
    ):
        self.instance_member_count = instance_member_count
        self.max_instance_member_num = max_instance_member_num
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_member_count is not None:
            result['InstanceMemberCount'] = self.instance_member_count
        if self.max_instance_member_num is not None:
            result['MaxInstanceMemberNum'] = self.max_instance_member_num
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceMemberCount') is not None:
            self.instance_member_count = m.get('InstanceMemberCount')
        if m.get('MaxInstanceMemberNum') is not None:
            self.max_instance_member_num = m.get('MaxInstanceMemberNum')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCtrlInstanceMemberAccountsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCtrlInstanceMemberAccountsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCtrlInstanceMemberAccountsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDefaultIPSConfigRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        # The language of the content within the response. Valid values:
        # 
        # *   **zh** (default)
        # *   **en**\
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeDefaultIPSConfigResponseBody(TeaModel):
    def __init__(
        self,
        basic_rules: int = None,
        cti_rules: int = None,
        max_sdl: int = None,
        patch_rules: int = None,
        request_id: str = None,
        rule_class: int = None,
        run_mode: int = None,
    ):
        # Indicates whether basic protection is enabled. Valid values:
        # 
        # *   **1**: yes
        # *   **0**: no
        self.basic_rules = basic_rules
        # Indicates whether threat intelligence is enabled. Valid values:
        # 
        # *   **1**: yes
        # *   **0**: no
        self.cti_rules = cti_rules
        # The maximum amount of traffic that can be processed by the sensitive data leak detection feature each day.
        self.max_sdl = max_sdl
        # Indicates whether virtual patching is enabled. Valid values:
        # 
        # *   **1**: yes
        # *   **0**: no
        self.patch_rules = patch_rules
        # The request ID.
        self.request_id = request_id
        # The level of the rule group for the IPS. Valid values:
        # 
        # *   **1**: loose
        # *   **2**: medium
        # *   **3**: strict
        self.rule_class = rule_class
        # The mode of the IPS. Valid values:
        # 
        # *   **1**: block mode
        # *   **0**: monitor mode
        self.run_mode = run_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.basic_rules is not None:
            result['BasicRules'] = self.basic_rules
        if self.cti_rules is not None:
            result['CtiRules'] = self.cti_rules
        if self.max_sdl is not None:
            result['MaxSdl'] = self.max_sdl
        if self.patch_rules is not None:
            result['PatchRules'] = self.patch_rules
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.rule_class is not None:
            result['RuleClass'] = self.rule_class
        if self.run_mode is not None:
            result['RunMode'] = self.run_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BasicRules') is not None:
            self.basic_rules = m.get('BasicRules')
        if m.get('CtiRules') is not None:
            self.cti_rules = m.get('CtiRules')
        if m.get('MaxSdl') is not None:
            self.max_sdl = m.get('MaxSdl')
        if m.get('PatchRules') is not None:
            self.patch_rules = m.get('PatchRules')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RuleClass') is not None:
            self.rule_class = m.get('RuleClass')
        if m.get('RunMode') is not None:
            self.run_mode = m.get('RunMode')
        return self


class DescribeDefaultIPSConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDefaultIPSConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDefaultIPSConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDnsFirewallPolicyRequest(TeaModel):
    def __init__(
        self,
        acl_action: str = None,
        acl_uuid: str = None,
        current_page: str = None,
        description: str = None,
        destination: str = None,
        ip_version: str = None,
        lang: str = None,
        page_size: str = None,
        release: str = None,
        source: str = None,
        source_ip: str = None,
    ):
        self.acl_action = acl_action
        self.acl_uuid = acl_uuid
        # This parameter is required.
        self.current_page = current_page
        self.description = description
        self.destination = destination
        self.ip_version = ip_version
        self.lang = lang
        # This parameter is required.
        self.page_size = page_size
        self.release = release
        self.source = source
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_action is not None:
            result['AclAction'] = self.acl_action
        if self.acl_uuid is not None:
            result['AclUuid'] = self.acl_uuid
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.description is not None:
            result['Description'] = self.description
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.ip_version is not None:
            result['IpVersion'] = self.ip_version
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.release is not None:
            result['Release'] = self.release
        if self.source is not None:
            result['Source'] = self.source
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclAction') is not None:
            self.acl_action = m.get('AclAction')
        if m.get('AclUuid') is not None:
            self.acl_uuid = m.get('AclUuid')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('IpVersion') is not None:
            self.ip_version = m.get('IpVersion')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Release') is not None:
            self.release = m.get('Release')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeDnsFirewallPolicyResponseBodyPolicys(TeaModel):
    def __init__(
        self,
        acl_action: str = None,
        acl_uuid: str = None,
        description: str = None,
        destination: str = None,
        destination_addrs: List[str] = None,
        destination_group_type: str = None,
        destination_type: str = None,
        direction: str = None,
        hit_last_time: int = None,
        hit_times: int = None,
        ip_version: int = None,
        priority: int = None,
        release: str = None,
        source: str = None,
        source_addrs: List[str] = None,
        source_group_type: str = None,
        source_type: str = None,
    ):
        self.acl_action = acl_action
        self.acl_uuid = acl_uuid
        self.description = description
        self.destination = destination
        self.destination_addrs = destination_addrs
        self.destination_group_type = destination_group_type
        self.destination_type = destination_type
        self.direction = direction
        self.hit_last_time = hit_last_time
        self.hit_times = hit_times
        self.ip_version = ip_version
        self.priority = priority
        self.release = release
        self.source = source
        self.source_addrs = source_addrs
        self.source_group_type = source_group_type
        self.source_type = source_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_action is not None:
            result['AclAction'] = self.acl_action
        if self.acl_uuid is not None:
            result['AclUuid'] = self.acl_uuid
        if self.description is not None:
            result['Description'] = self.description
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.destination_addrs is not None:
            result['DestinationAddrs'] = self.destination_addrs
        if self.destination_group_type is not None:
            result['DestinationGroupType'] = self.destination_group_type
        if self.destination_type is not None:
            result['DestinationType'] = self.destination_type
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.hit_last_time is not None:
            result['HitLastTime'] = self.hit_last_time
        if self.hit_times is not None:
            result['HitTimes'] = self.hit_times
        if self.ip_version is not None:
            result['IpVersion'] = self.ip_version
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.release is not None:
            result['Release'] = self.release
        if self.source is not None:
            result['Source'] = self.source
        if self.source_addrs is not None:
            result['SourceAddrs'] = self.source_addrs
        if self.source_group_type is not None:
            result['SourceGroupType'] = self.source_group_type
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclAction') is not None:
            self.acl_action = m.get('AclAction')
        if m.get('AclUuid') is not None:
            self.acl_uuid = m.get('AclUuid')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('DestinationAddrs') is not None:
            self.destination_addrs = m.get('DestinationAddrs')
        if m.get('DestinationGroupType') is not None:
            self.destination_group_type = m.get('DestinationGroupType')
        if m.get('DestinationType') is not None:
            self.destination_type = m.get('DestinationType')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('HitLastTime') is not None:
            self.hit_last_time = m.get('HitLastTime')
        if m.get('HitTimes') is not None:
            self.hit_times = m.get('HitTimes')
        if m.get('IpVersion') is not None:
            self.ip_version = m.get('IpVersion')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Release') is not None:
            self.release = m.get('Release')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SourceAddrs') is not None:
            self.source_addrs = m.get('SourceAddrs')
        if m.get('SourceGroupType') is not None:
            self.source_group_type = m.get('SourceGroupType')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        return self


class DescribeDnsFirewallPolicyResponseBody(TeaModel):
    def __init__(
        self,
        page_no: str = None,
        page_size: str = None,
        policys: List[DescribeDnsFirewallPolicyResponseBodyPolicys] = None,
        request_id: str = None,
        total_count: str = None,
    ):
        self.page_no = page_no
        self.page_size = page_size
        self.policys = policys
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.policys:
            for k in self.policys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Policys'] = []
        if self.policys is not None:
            for k in self.policys:
                result['Policys'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.policys = []
        if m.get('Policys') is not None:
            for k in m.get('Policys'):
                temp_model = DescribeDnsFirewallPolicyResponseBodyPolicys()
                self.policys.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDnsFirewallPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDnsFirewallPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDnsFirewallPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainResolveRequest(TeaModel):
    def __init__(
        self,
        domain: str = None,
        ip_version: str = None,
        lang: str = None,
        source_ip: str = None,
    ):
        # The domain name whose DNS record you want to query.
        # 
        # This parameter is required.
        self.domain = domain
        # The IP version of the asset that is protected by Cloud Firewall. Valid values:
        # 
        # *   **4**: IPv4 (default)
        # *   **6**: IPv6
        self.ip_version = ip_version
        # The language of the content within the response.
        # 
        # Valid values:
        # 
        # *   **zh**: Chinese (default)
        # *   **en**: English
        self.lang = lang
        # The source IP address of the request.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.ip_version is not None:
            result['IpVersion'] = self.ip_version
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('IpVersion') is not None:
            self.ip_version = m.get('IpVersion')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeDomainResolveResponseBodyResolveResult(TeaModel):
    def __init__(
        self,
        ip_addrs: str = None,
        update_time: int = None,
    ):
        # The IP address to which the domain name is resolved. Multiple IP addresses are separated by commas (,).
        self.ip_addrs = ip_addrs
        # The time when the domain name was resolved. The value of this parameter is a timestamp. Unit: seconds.
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_addrs is not None:
            result['IpAddrs'] = self.ip_addrs
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IpAddrs') is not None:
            self.ip_addrs = m.get('IpAddrs')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeDomainResolveResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resolve_result: DescribeDomainResolveResponseBodyResolveResult = None,
    ):
        # The request ID.
        self.request_id = request_id
        # The details about the DNS record of the domain name.
        self.resolve_result = resolve_result

    def validate(self):
        if self.resolve_result:
            self.resolve_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resolve_result is not None:
            result['ResolveResult'] = self.resolve_result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResolveResult') is not None:
            temp_model = DescribeDomainResolveResponseBodyResolveResult()
            self.resolve_result = temp_model.from_map(m['ResolveResult'])
        return self


class DescribeDomainResolveResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDomainResolveResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDomainResolveResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDownloadTaskRequest(TeaModel):
    def __init__(
        self,
        current_page: str = None,
        lang: str = None,
        page_size: str = None,
        task_type: str = None,
    ):
        # The page number.
        self.current_page = current_page
        # The language of the content within the response. Valid values:
        # 
        # *   **zh** (default): Chinese
        # *   **en**: English
        self.lang = lang
        # The number of entries per page. Default value: 10. Maximum value: 50.
        self.page_size = page_size
        # The type of the task. For more information about task types, see the descriptions in the "DescribeDownloadTaskType" topic. If you do not specify this parameter, all files are queried by default.
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeDownloadTaskResponseBodyTasks(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        expire_time: int = None,
        file_size: str = None,
        file_url: str = None,
        status: str = None,
        task_id: str = None,
        task_name: str = None,
        task_type: str = None,
    ):
        # The time when the task was created. The value is a UNIX timestamp. Unit: seconds.
        self.create_time = create_time
        # The time when the task expires. The value is a UNIX timestamp. Unit: seconds.
        self.expire_time = expire_time
        # The size of the file.
        self.file_size = file_size
        # The URL of the OSS file.
        self.file_url = file_url
        # The status of the task. Valid values:
        # 
        # *   **finish**\
        # *   **start**\
        # *   **error**\
        # *   **expire**: The task file is invalid and cannot be downloaded.
        self.status = status
        # The task ID.
        self.task_id = task_id
        # The name of the task.
        self.task_name = task_name
        # The type of the task.
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.file_url is not None:
            result['FileURL'] = self.file_url
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('FileURL') is not None:
            self.file_url = m.get('FileURL')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeDownloadTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        tasks: List[DescribeDownloadTaskResponseBodyTasks] = None,
        total_count: int = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The tasks.
        self.tasks = tasks
        # The total number of tasks.
        self.total_count = total_count

    def validate(self):
        if self.tasks:
            for k in self.tasks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Tasks'] = []
        if self.tasks is not None:
            for k in self.tasks:
                result['Tasks'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.tasks = []
        if m.get('Tasks') is not None:
            for k in m.get('Tasks'):
                temp_model = DescribeDownloadTaskResponseBodyTasks()
                self.tasks.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDownloadTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDownloadTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDownloadTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDownloadTaskTypeRequest(TeaModel):
    def __init__(
        self,
        current_page: str = None,
        lang: str = None,
        page_size: str = None,
        task_type: str = None,
    ):
        # The page number. Pages start from page 1. Default value: **1**.
        self.current_page = current_page
        # The language of the content within the response. Valid values:
        # 
        # *   **zh** (default): Chinese
        # *   **en**: English
        self.lang = lang
        # The number of entries per page. Default value: 10. Maximum value: 50.
        self.page_size = page_size
        # The type of the task.
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeDownloadTaskTypeResponseBodyTaskTypeArray(TeaModel):
    def __init__(
        self,
        task_name: str = None,
        task_type: str = None,
    ):
        # The name of the task type.
        self.task_name = task_name
        # The type of the task.
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeDownloadTaskTypeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        task_type_array: List[DescribeDownloadTaskTypeResponseBodyTaskTypeArray] = None,
        total_count: int = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The task types.
        self.task_type_array = task_type_array
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.task_type_array:
            for k in self.task_type_array:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['TaskTypeArray'] = []
        if self.task_type_array is not None:
            for k in self.task_type_array:
                result['TaskTypeArray'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.task_type_array = []
        if m.get('TaskTypeArray') is not None:
            for k in m.get('TaskTypeArray'):
                temp_model = DescribeDownloadTaskTypeResponseBodyTaskTypeArray()
                self.task_type_array.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDownloadTaskTypeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDownloadTaskTypeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDownloadTaskTypeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFirewallDropStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        acl_drop_cnt: int = None,
        ips_drop_cnt: int = None,
        request_id: str = None,
        total_drop_cnt: int = None,
        vuln_drop_cnt: int = None,
    ):
        self.acl_drop_cnt = acl_drop_cnt
        self.ips_drop_cnt = ips_drop_cnt
        self.request_id = request_id
        self.total_drop_cnt = total_drop_cnt
        self.vuln_drop_cnt = vuln_drop_cnt

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_drop_cnt is not None:
            result['AclDropCnt'] = self.acl_drop_cnt
        if self.ips_drop_cnt is not None:
            result['IpsDropCnt'] = self.ips_drop_cnt
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_drop_cnt is not None:
            result['TotalDropCnt'] = self.total_drop_cnt
        if self.vuln_drop_cnt is not None:
            result['VulnDropCnt'] = self.vuln_drop_cnt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclDropCnt') is not None:
            self.acl_drop_cnt = m.get('AclDropCnt')
        if m.get('IpsDropCnt') is not None:
            self.ips_drop_cnt = m.get('IpsDropCnt')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalDropCnt') is not None:
            self.total_drop_cnt = m.get('TotalDropCnt')
        if m.get('VulnDropCnt') is not None:
            self.vuln_drop_cnt = m.get('VulnDropCnt')
        return self


class DescribeFirewallDropStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeFirewallDropStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeFirewallDropStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFirewallTaskRequest(TeaModel):
    def __init__(
        self,
        child_instance_id: str = None,
        lang: str = None,
        task_id: str = None,
        task_type: str = None,
    ):
        self.child_instance_id = child_instance_id
        self.lang = lang
        self.task_id = task_id
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.child_instance_id is not None:
            result['ChildInstanceId'] = self.child_instance_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChildInstanceId') is not None:
            self.child_instance_id = m.get('ChildInstanceId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeFirewallTaskResponseBodyTaskSteps(TeaModel):
    def __init__(
        self,
        step_info: str = None,
        step_name: str = None,
        step_progress: str = None,
        step_status: str = None,
    ):
        self.step_info = step_info
        self.step_name = step_name
        self.step_progress = step_progress
        self.step_status = step_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.step_info is not None:
            result['StepInfo'] = self.step_info
        if self.step_name is not None:
            result['StepName'] = self.step_name
        if self.step_progress is not None:
            result['StepProgress'] = self.step_progress
        if self.step_status is not None:
            result['StepStatus'] = self.step_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StepInfo') is not None:
            self.step_info = m.get('StepInfo')
        if m.get('StepName') is not None:
            self.step_name = m.get('StepName')
        if m.get('StepProgress') is not None:
            self.step_progress = m.get('StepProgress')
        if m.get('StepStatus') is not None:
            self.step_status = m.get('StepStatus')
        return self


class DescribeFirewallTaskResponseBody(TeaModel):
    def __init__(
        self,
        is_found: bool = None,
        request_id: str = None,
        task_finish_timestamp: str = None,
        task_id: int = None,
        task_name: str = None,
        task_start_timestamp: str = None,
        task_status: str = None,
        task_steps: List[DescribeFirewallTaskResponseBodyTaskSteps] = None,
        task_waiting_time: str = None,
    ):
        self.is_found = is_found
        self.request_id = request_id
        self.task_finish_timestamp = task_finish_timestamp
        self.task_id = task_id
        self.task_name = task_name
        self.task_start_timestamp = task_start_timestamp
        self.task_status = task_status
        self.task_steps = task_steps
        self.task_waiting_time = task_waiting_time

    def validate(self):
        if self.task_steps:
            for k in self.task_steps:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_found is not None:
            result['IsFound'] = self.is_found
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_finish_timestamp is not None:
            result['TaskFinishTimestamp'] = self.task_finish_timestamp
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_start_timestamp is not None:
            result['TaskStartTimestamp'] = self.task_start_timestamp
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        result['TaskSteps'] = []
        if self.task_steps is not None:
            for k in self.task_steps:
                result['TaskSteps'].append(k.to_map() if k else None)
        if self.task_waiting_time is not None:
            result['TaskWaitingTime'] = self.task_waiting_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IsFound') is not None:
            self.is_found = m.get('IsFound')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskFinishTimestamp') is not None:
            self.task_finish_timestamp = m.get('TaskFinishTimestamp')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskStartTimestamp') is not None:
            self.task_start_timestamp = m.get('TaskStartTimestamp')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        self.task_steps = []
        if m.get('TaskSteps') is not None:
            for k in m.get('TaskSteps'):
                temp_model = DescribeFirewallTaskResponseBodyTaskSteps()
                self.task_steps.append(temp_model.from_map(k))
        if m.get('TaskWaitingTime') is not None:
            self.task_waiting_time = m.get('TaskWaitingTime')
        return self


class DescribeFirewallTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeFirewallTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeFirewallTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFirewallVSwitchRequest(TeaModel):
    def __init__(
        self,
        firewall_id: str = None,
        lang: str = None,
        member_uid: str = None,
        page_no: str = None,
        page_size: str = None,
        region_no: str = None,
        vpc_id: str = None,
        vswitch_id: str = None,
    ):
        self.firewall_id = firewall_id
        self.lang = lang
        self.member_uid = member_uid
        self.page_no = page_no
        self.page_size = page_size
        self.region_no = region_no
        self.vpc_id = vpc_id
        self.vswitch_id = vswitch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.firewall_id is not None:
            result['FirewallId'] = self.firewall_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vswitch_id is not None:
            result['VswitchId'] = self.vswitch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FirewallId') is not None:
            self.firewall_id = m.get('FirewallId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VswitchId') is not None:
            self.vswitch_id = m.get('VswitchId')
        return self


class DescribeFirewallVSwitchResponseBodyVswitchListFirewallList(TeaModel):
    def __init__(
        self,
        firewall_id: str = None,
        firewall_name: str = None,
    ):
        self.firewall_id = firewall_id
        self.firewall_name = firewall_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.firewall_id is not None:
            result['FirewallId'] = self.firewall_id
        if self.firewall_name is not None:
            result['FirewallName'] = self.firewall_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FirewallId') is not None:
            self.firewall_id = m.get('FirewallId')
        if m.get('FirewallName') is not None:
            self.firewall_name = m.get('FirewallName')
        return self


class DescribeFirewallVSwitchResponseBodyVswitchList(TeaModel):
    def __init__(
        self,
        available_ip_count: str = None,
        cidr_block: str = None,
        firewall_count: str = None,
        firewall_list: List[DescribeFirewallVSwitchResponseBodyVswitchListFirewallList] = None,
        member_uid: str = None,
        region_no: str = None,
        vpc_id: str = None,
        vswitch_id: str = None,
        vswitch_name: str = None,
        zone_id: str = None,
    ):
        self.available_ip_count = available_ip_count
        self.cidr_block = cidr_block
        self.firewall_count = firewall_count
        self.firewall_list = firewall_list
        self.member_uid = member_uid
        self.region_no = region_no
        self.vpc_id = vpc_id
        self.vswitch_id = vswitch_id
        self.vswitch_name = vswitch_name
        self.zone_id = zone_id

    def validate(self):
        if self.firewall_list:
            for k in self.firewall_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_ip_count is not None:
            result['AvailableIpCount'] = self.available_ip_count
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.firewall_count is not None:
            result['FirewallCount'] = self.firewall_count
        result['FirewallList'] = []
        if self.firewall_list is not None:
            for k in self.firewall_list:
                result['FirewallList'].append(k.to_map() if k else None)
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vswitch_id is not None:
            result['VswitchId'] = self.vswitch_id
        if self.vswitch_name is not None:
            result['VswitchName'] = self.vswitch_name
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvailableIpCount') is not None:
            self.available_ip_count = m.get('AvailableIpCount')
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('FirewallCount') is not None:
            self.firewall_count = m.get('FirewallCount')
        self.firewall_list = []
        if m.get('FirewallList') is not None:
            for k in m.get('FirewallList'):
                temp_model = DescribeFirewallVSwitchResponseBodyVswitchListFirewallList()
                self.firewall_list.append(temp_model.from_map(k))
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VswitchId') is not None:
            self.vswitch_id = m.get('VswitchId')
        if m.get('VswitchName') is not None:
            self.vswitch_name = m.get('VswitchName')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeFirewallVSwitchResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        total_count: int = None,
        vswitch_list: List[DescribeFirewallVSwitchResponseBodyVswitchList] = None,
    ):
        self.request_id = request_id
        self.total_count = total_count
        self.vswitch_list = vswitch_list

    def validate(self):
        if self.vswitch_list:
            for k in self.vswitch_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['VswitchList'] = []
        if self.vswitch_list is not None:
            for k in self.vswitch_list:
                result['VswitchList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.vswitch_list = []
        if m.get('VswitchList') is not None:
            for k in m.get('VswitchList'):
                temp_model = DescribeFirewallVSwitchResponseBodyVswitchList()
                self.vswitch_list.append(temp_model.from_map(k))
        return self


class DescribeFirewallVSwitchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeFirewallVSwitchResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeFirewallVSwitchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceMembersRequest(TeaModel):
    def __init__(
        self,
        current_page: str = None,
        member_desc: str = None,
        member_display_name: str = None,
        member_uid: str = None,
        page_size: str = None,
    ):
        # The page number. Default value: **1**.
        self.current_page = current_page
        # The remarks of the member. The remarks must be 1 to 256 characters in length.
        self.member_desc = member_desc
        # The name of the member.
        self.member_display_name = member_display_name
        # The UID of the member.
        self.member_uid = member_uid
        # The number of entries per page.
        # 
        # Default value: **20**.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.member_desc is not None:
            result['MemberDesc'] = self.member_desc
        if self.member_display_name is not None:
            result['MemberDisplayName'] = self.member_display_name
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('MemberDesc') is not None:
            self.member_desc = m.get('MemberDesc')
        if m.get('MemberDisplayName') is not None:
            self.member_display_name = m.get('MemberDisplayName')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeInstanceMembersResponseBodyMembers(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        member_desc: str = None,
        member_display_name: str = None,
        member_status: str = None,
        member_uid: int = None,
        modify_time: int = None,
    ):
        # The time when the member was added to Cloud Firewall. The value is a timestamp. Unit: seconds.
        self.create_time = create_time
        # The remarks of the member.
        self.member_desc = member_desc
        # The name of the member.
        self.member_display_name = member_display_name
        # The status of the member. Valid values:
        # 
        # *   **normal**\
        # *   **deleting**\
        self.member_status = member_status
        # The UID of the member.
        self.member_uid = member_uid
        # The time when the member was last modified. The value is a timestamp. Unit: seconds.
        self.modify_time = modify_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.member_desc is not None:
            result['MemberDesc'] = self.member_desc
        if self.member_display_name is not None:
            result['MemberDisplayName'] = self.member_display_name
        if self.member_status is not None:
            result['MemberStatus'] = self.member_status
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('MemberDesc') is not None:
            self.member_desc = m.get('MemberDesc')
        if m.get('MemberDisplayName') is not None:
            self.member_display_name = m.get('MemberDisplayName')
        if m.get('MemberStatus') is not None:
            self.member_status = m.get('MemberStatus')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        return self


class DescribeInstanceMembersResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The page number.
        self.current_page = current_page
        # The number of entries per page.
        self.page_size = page_size
        # The total number of the members.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeInstanceMembersResponseBody(TeaModel):
    def __init__(
        self,
        members: List[DescribeInstanceMembersResponseBodyMembers] = None,
        page_info: DescribeInstanceMembersResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        # The information about the member.
        self.members = members
        # The pagination information.
        self.page_info = page_info
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.members:
            for k in self.members:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Members'] = []
        if self.members is not None:
            for k in self.members:
                result['Members'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.members = []
        if m.get('Members') is not None:
            for k in m.get('Members'):
                temp_model = DescribeInstanceMembersResponseBodyMembers()
                self.members.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeInstanceMembersResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeInstanceMembersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInstanceMembersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstanceMembersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceRiskLevelsRequestInstances(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        internet_ip: List[str] = None,
        intranet_ip: str = None,
        uuid: str = None,
    ):
        # The instance ID of your Cloud Firewall.
        self.instance_id = instance_id
        # The public IP addresses of instances.
        self.internet_ip = internet_ip
        # The private IP address of the instance.
        self.intranet_ip = intranet_ip
        # The UUID of the instance.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeInstanceRiskLevelsRequest(TeaModel):
    def __init__(
        self,
        instances: List[DescribeInstanceRiskLevelsRequestInstances] = None,
        lang: str = None,
    ):
        # The information about the instances.
        self.instances = instances
        # The language of the content within the response. Valid values:
        # 
        # *   **zh** (default): Chinese
        # *   **en**: English
        self.lang = lang

    def validate(self):
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = DescribeInstanceRiskLevelsRequestInstances()
                self.instances.append(temp_model.from_map(k))
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeInstanceRiskLevelsResponseBodyInstanceRisksDetails(TeaModel):
    def __init__(
        self,
        ip: str = None,
        level: str = None,
        type: str = None,
    ):
        # The IP addresses of servers.
        self.ip = ip
        # The risk levels. Valid values:
        # 
        # *   **medium**\
        self.level = level
        # The type.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.level is not None:
            result['Level'] = self.level
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeInstanceRiskLevelsResponseBodyInstanceRisks(TeaModel):
    def __init__(
        self,
        details: List[DescribeInstanceRiskLevelsResponseBodyInstanceRisksDetails] = None,
        instance_id: str = None,
        level: str = None,
    ):
        # The risk levels of the Elastic Compute Service (ECS) instance.
        self.details = details
        # The instance ID of your Cloud Firewall.
        self.instance_id = instance_id
        # The risk levels. Valid values:
        # 
        # *   **medium**\
        self.level = level

    def validate(self):
        if self.details:
            for k in self.details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Details'] = []
        if self.details is not None:
            for k in self.details:
                result['Details'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.level is not None:
            result['Level'] = self.level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.details = []
        if m.get('Details') is not None:
            for k in m.get('Details'):
                temp_model = DescribeInstanceRiskLevelsResponseBodyInstanceRisksDetails()
                self.details.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        return self


class DescribeInstanceRiskLevelsResponseBody(TeaModel):
    def __init__(
        self,
        instance_risks: List[DescribeInstanceRiskLevelsResponseBodyInstanceRisks] = None,
        request_id: str = None,
    ):
        # The information about the instances.
        self.instance_risks = instance_risks
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.instance_risks:
            for k in self.instance_risks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InstanceRisks'] = []
        if self.instance_risks is not None:
            for k in self.instance_risks:
                result['InstanceRisks'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.instance_risks = []
        if m.get('InstanceRisks') is not None:
            for k in m.get('InstanceRisks'):
                temp_model = DescribeInstanceRiskLevelsResponseBodyInstanceRisks()
                self.instance_risks.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeInstanceRiskLevelsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInstanceRiskLevelsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstanceRiskLevelsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInternetDropTrafficTrendRequest(TeaModel):
    def __init__(
        self,
        direction: str = None,
        end_time: str = None,
        lang: str = None,
        source_code: str = None,
        source_ip: str = None,
        start_time: str = None,
    ):
        self.direction = direction
        # This parameter is required.
        self.end_time = end_time
        self.lang = lang
        # This parameter is required.
        self.source_code = source_code
        self.source_ip = source_ip
        # This parameter is required.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_code is not None:
            result['SourceCode'] = self.source_code
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceCode') is not None:
            self.source_code = m.get('SourceCode')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeInternetDropTrafficTrendResponseBodyDataList(TeaModel):
    def __init__(
        self,
        acl_drop: int = None,
        data_time: str = None,
        drop_ratio: str = None,
        drop_ring: int = None,
        drop_ring_ratio: str = None,
        drop_session: int = None,
        ips_drop: int = None,
        ring_data_time: str = None,
        ring_time: int = None,
        time: int = None,
        total_session: int = None,
    ):
        self.acl_drop = acl_drop
        self.data_time = data_time
        self.drop_ratio = drop_ratio
        self.drop_ring = drop_ring
        self.drop_ring_ratio = drop_ring_ratio
        self.drop_session = drop_session
        self.ips_drop = ips_drop
        self.ring_data_time = ring_data_time
        self.ring_time = ring_time
        self.time = time
        self.total_session = total_session

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_drop is not None:
            result['AclDrop'] = self.acl_drop
        if self.data_time is not None:
            result['DataTime'] = self.data_time
        if self.drop_ratio is not None:
            result['DropRatio'] = self.drop_ratio
        if self.drop_ring is not None:
            result['DropRing'] = self.drop_ring
        if self.drop_ring_ratio is not None:
            result['DropRingRatio'] = self.drop_ring_ratio
        if self.drop_session is not None:
            result['DropSession'] = self.drop_session
        if self.ips_drop is not None:
            result['IpsDrop'] = self.ips_drop
        if self.ring_data_time is not None:
            result['RingDataTime'] = self.ring_data_time
        if self.ring_time is not None:
            result['RingTime'] = self.ring_time
        if self.time is not None:
            result['Time'] = self.time
        if self.total_session is not None:
            result['TotalSession'] = self.total_session
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclDrop') is not None:
            self.acl_drop = m.get('AclDrop')
        if m.get('DataTime') is not None:
            self.data_time = m.get('DataTime')
        if m.get('DropRatio') is not None:
            self.drop_ratio = m.get('DropRatio')
        if m.get('DropRing') is not None:
            self.drop_ring = m.get('DropRing')
        if m.get('DropRingRatio') is not None:
            self.drop_ring_ratio = m.get('DropRingRatio')
        if m.get('DropSession') is not None:
            self.drop_session = m.get('DropSession')
        if m.get('IpsDrop') is not None:
            self.ips_drop = m.get('IpsDrop')
        if m.get('RingDataTime') is not None:
            self.ring_data_time = m.get('RingDataTime')
        if m.get('RingTime') is not None:
            self.ring_time = m.get('RingTime')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('TotalSession') is not None:
            self.total_session = m.get('TotalSession')
        return self


class DescribeInternetDropTrafficTrendResponseBody(TeaModel):
    def __init__(
        self,
        data_list: List[DescribeInternetDropTrafficTrendResponseBodyDataList] = None,
        drop_session_max: int = None,
        ratio_average: str = None,
        request_id: str = None,
        ring_ratio_average: str = None,
    ):
        self.data_list = data_list
        self.drop_session_max = drop_session_max
        self.ratio_average = ratio_average
        self.request_id = request_id
        self.ring_ratio_average = ring_ratio_average

    def validate(self):
        if self.data_list:
            for k in self.data_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataList'] = []
        if self.data_list is not None:
            for k in self.data_list:
                result['DataList'].append(k.to_map() if k else None)
        if self.drop_session_max is not None:
            result['DropSessionMax'] = self.drop_session_max
        if self.ratio_average is not None:
            result['RatioAverage'] = self.ratio_average
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ring_ratio_average is not None:
            result['RingRatioAverage'] = self.ring_ratio_average
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_list = []
        if m.get('DataList') is not None:
            for k in m.get('DataList'):
                temp_model = DescribeInternetDropTrafficTrendResponseBodyDataList()
                self.data_list.append(temp_model.from_map(k))
        if m.get('DropSessionMax') is not None:
            self.drop_session_max = m.get('DropSessionMax')
        if m.get('RatioAverage') is not None:
            self.ratio_average = m.get('RatioAverage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RingRatioAverage') is not None:
            self.ring_ratio_average = m.get('RingRatioAverage')
        return self


class DescribeInternetDropTrafficTrendResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInternetDropTrafficTrendResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInternetDropTrafficTrendResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInternetOpenIpRequest(TeaModel):
    def __init__(
        self,
        assets_instance_id: str = None,
        assets_instance_name: str = None,
        assets_type: str = None,
        current_page: str = None,
        end_time: str = None,
        lang: str = None,
        page_size: str = None,
        port: str = None,
        public_ip: str = None,
        region_no: str = None,
        risk_level: str = None,
        service_name: str = None,
        start_time: str = None,
    ):
        # The instance ID.
        self.assets_instance_id = assets_instance_id
        # The instance name.
        self.assets_instance_name = assets_instance_name
        # The asset type of the instance.
        self.assets_type = assets_type
        # The page number.
        # 
        # This parameter is required.
        self.current_page = current_page
        # The end of the time range to query. The value is a UNIX timestamp. Unit: seconds.
        self.end_time = end_time
        # The language of the content within the response. Valid values:
        # 
        # *   **zh**: Chinese (default)
        # *   **en**: English
        self.lang = lang
        # The number of entries per page.
        # 
        # This parameter is required.
        self.page_size = page_size
        # The port number.
        self.port = port
        # The public IP address of the instance.
        self.public_ip = public_ip
        # The region ID of the instance.
        self.region_no = region_no
        # The risk level. If you leave this parameter empty, all risk levels are queried. Valid values:
        # 
        # *   **3**: high risk
        # *   **2**: medium risk
        # *   **1**: low risk
        # *   **0**: no risk
        self.risk_level = risk_level
        # The application.
        self.service_name = service_name
        # The beginning of the time range to query. The value is a UNIX timestamp. Unit: seconds.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assets_instance_id is not None:
            result['AssetsInstanceId'] = self.assets_instance_id
        if self.assets_instance_name is not None:
            result['AssetsInstanceName'] = self.assets_instance_name
        if self.assets_type is not None:
            result['AssetsType'] = self.assets_type
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.port is not None:
            result['Port'] = self.port
        if self.public_ip is not None:
            result['PublicIp'] = self.public_ip
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssetsInstanceId') is not None:
            self.assets_instance_id = m.get('AssetsInstanceId')
        if m.get('AssetsInstanceName') is not None:
            self.assets_instance_name = m.get('AssetsInstanceName')
        if m.get('AssetsType') is not None:
            self.assets_type = m.get('AssetsType')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('PublicIp') is not None:
            self.public_ip = m.get('PublicIp')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeInternetOpenIpResponseBodyDataList(TeaModel):
    def __init__(
        self,
        acl_recommend_detail: str = None,
        assets_instance_id: str = None,
        assets_name: str = None,
        assets_type: str = None,
        detail_num: int = None,
        has_acl_recommend: bool = None,
        in_bytes: int = None,
        member_uid: int = None,
        out_bytes: int = None,
        port_list: List[str] = None,
        public_ip: str = None,
        region_no: str = None,
        risk_level: int = None,
        risk_reason: str = None,
        service_name_list: List[str] = None,
        src_ip_cnt: int = None,
        total_bytes: int = None,
        total_reply_bytes: int = None,
        traffic_percent_1day: str = None,
        traffic_percent_30day: str = None,
        traffic_percent_7day: str = None,
        unknown_reason: List[str] = None,
    ):
        # The reason why recommended intelligent policies are unavailable. Valid values:
        # 
        # *   No recommended intelligent policies are available.
        # *   This feature is available only to some users.
        # *   The policy configuration has been modified. No recommended intelligent policies are available.
        # *   The recommended intelligent policies have been configured. No new recommended intelligent policies are available.
        self.acl_recommend_detail = acl_recommend_detail
        # The instance ID.
        self.assets_instance_id = assets_instance_id
        # The instance name.
        self.assets_name = assets_name
        # The asset type of the instance.
        self.assets_type = assets_type
        # The total number of ports.
        self.detail_num = detail_num
        # Specifies whether an access control policy is recommended. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.has_acl_recommend = has_acl_recommend
        # The inbound network throughput, which indicates the total number of bytes that are sent inbound. Unit: bytes.
        self.in_bytes = in_bytes
        # The UID of the member that is managed by your Alibaba Cloud account.
        self.member_uid = member_uid
        # The outbound network throughput, which indicates the total number of bytes that are sent outbound. Unit: bytes.
        self.out_bytes = out_bytes
        # The list of ports.
        self.port_list = port_list
        # The public IP address of the instance.
        self.public_ip = public_ip
        # The region ID of the instance.
        self.region_no = region_no
        # The risk level. Valid values:
        # 
        # *   **3**: high risk
        # *   **2**: medium risk
        # *   **1**: low risk
        # *   **0**: no risk
        self.risk_level = risk_level
        # The reason for the risk.
        self.risk_reason = risk_reason
        # The list of applications.
        self.service_name_list = service_name_list
        # Number of source IPs.
        self.src_ip_cnt = src_ip_cnt
        # The total inbound and outbound network throughput, which indicates the total number of bytes that are sent inbound and outbound. Unit: bytes.
        self.total_bytes = total_bytes
        # Outbound traffic in the last 7 days.
        self.total_reply_bytes = total_reply_bytes
        # For detailed traffic information, see the TotalBytes field.
        self.traffic_percent_1day = traffic_percent_1day
        # For detailed traffic information, see the TotalBytes field.
        self.traffic_percent_30day = traffic_percent_30day
        # For detailed traffic information, see the TotalBytes field.
        self.traffic_percent_7day = traffic_percent_7day
        # Reasons for not analyzing the protocol when the protocol is identified as Unknown.
        self.unknown_reason = unknown_reason

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_recommend_detail is not None:
            result['AclRecommendDetail'] = self.acl_recommend_detail
        if self.assets_instance_id is not None:
            result['AssetsInstanceId'] = self.assets_instance_id
        if self.assets_name is not None:
            result['AssetsName'] = self.assets_name
        if self.assets_type is not None:
            result['AssetsType'] = self.assets_type
        if self.detail_num is not None:
            result['DetailNum'] = self.detail_num
        if self.has_acl_recommend is not None:
            result['HasAclRecommend'] = self.has_acl_recommend
        if self.in_bytes is not None:
            result['InBytes'] = self.in_bytes
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.out_bytes is not None:
            result['OutBytes'] = self.out_bytes
        if self.port_list is not None:
            result['PortList'] = self.port_list
        if self.public_ip is not None:
            result['PublicIp'] = self.public_ip
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.risk_reason is not None:
            result['RiskReason'] = self.risk_reason
        if self.service_name_list is not None:
            result['ServiceNameList'] = self.service_name_list
        if self.src_ip_cnt is not None:
            result['SrcIpCnt'] = self.src_ip_cnt
        if self.total_bytes is not None:
            result['TotalBytes'] = self.total_bytes
        if self.total_reply_bytes is not None:
            result['TotalReplyBytes'] = self.total_reply_bytes
        if self.traffic_percent_1day is not None:
            result['TrafficPercent1Day'] = self.traffic_percent_1day
        if self.traffic_percent_30day is not None:
            result['TrafficPercent30Day'] = self.traffic_percent_30day
        if self.traffic_percent_7day is not None:
            result['TrafficPercent7Day'] = self.traffic_percent_7day
        if self.unknown_reason is not None:
            result['UnknownReason'] = self.unknown_reason
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclRecommendDetail') is not None:
            self.acl_recommend_detail = m.get('AclRecommendDetail')
        if m.get('AssetsInstanceId') is not None:
            self.assets_instance_id = m.get('AssetsInstanceId')
        if m.get('AssetsName') is not None:
            self.assets_name = m.get('AssetsName')
        if m.get('AssetsType') is not None:
            self.assets_type = m.get('AssetsType')
        if m.get('DetailNum') is not None:
            self.detail_num = m.get('DetailNum')
        if m.get('HasAclRecommend') is not None:
            self.has_acl_recommend = m.get('HasAclRecommend')
        if m.get('InBytes') is not None:
            self.in_bytes = m.get('InBytes')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('OutBytes') is not None:
            self.out_bytes = m.get('OutBytes')
        if m.get('PortList') is not None:
            self.port_list = m.get('PortList')
        if m.get('PublicIp') is not None:
            self.public_ip = m.get('PublicIp')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('RiskReason') is not None:
            self.risk_reason = m.get('RiskReason')
        if m.get('ServiceNameList') is not None:
            self.service_name_list = m.get('ServiceNameList')
        if m.get('SrcIpCnt') is not None:
            self.src_ip_cnt = m.get('SrcIpCnt')
        if m.get('TotalBytes') is not None:
            self.total_bytes = m.get('TotalBytes')
        if m.get('TotalReplyBytes') is not None:
            self.total_reply_bytes = m.get('TotalReplyBytes')
        if m.get('TrafficPercent1Day') is not None:
            self.traffic_percent_1day = m.get('TrafficPercent1Day')
        if m.get('TrafficPercent30Day') is not None:
            self.traffic_percent_30day = m.get('TrafficPercent30Day')
        if m.get('TrafficPercent7Day') is not None:
            self.traffic_percent_7day = m.get('TrafficPercent7Day')
        if m.get('UnknownReason') is not None:
            self.unknown_reason = m.get('UnknownReason')
        return self


class DescribeInternetOpenIpResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The page number.
        self.current_page = current_page
        # The number of entries per page.
        self.page_size = page_size
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeInternetOpenIpResponseBody(TeaModel):
    def __init__(
        self,
        data_list: List[DescribeInternetOpenIpResponseBodyDataList] = None,
        page_info: DescribeInternetOpenIpResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        # The data returned.
        self.data_list = data_list
        # The pagination information.
        self.page_info = page_info
        # The request ID.
        self.request_id = request_id

    def validate(self):
        if self.data_list:
            for k in self.data_list:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataList'] = []
        if self.data_list is not None:
            for k in self.data_list:
                result['DataList'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_list = []
        if m.get('DataList') is not None:
            for k in m.get('DataList'):
                temp_model = DescribeInternetOpenIpResponseBodyDataList()
                self.data_list.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeInternetOpenIpResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeInternetOpenIpResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInternetOpenIpResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInternetOpenIpResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInternetOpenPortRequest(TeaModel):
    def __init__(
        self,
        current_page: str = None,
        end_time: str = None,
        lang: str = None,
        page_size: str = None,
        port: str = None,
        risk_level: str = None,
        service_name: str = None,
        service_name_fuzzy: str = None,
        source_ip: str = None,
        start_time: str = None,
        suggest_level: str = None,
    ):
        self.current_page = current_page
        self.end_time = end_time
        self.lang = lang
        self.page_size = page_size
        self.port = port
        self.risk_level = risk_level
        self.service_name = service_name
        self.service_name_fuzzy = service_name_fuzzy
        self.source_ip = source_ip
        self.start_time = start_time
        self.suggest_level = suggest_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.port is not None:
            result['Port'] = self.port
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.service_name_fuzzy is not None:
            result['ServiceNameFuzzy'] = self.service_name_fuzzy
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.suggest_level is not None:
            result['SuggestLevel'] = self.suggest_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ServiceNameFuzzy') is not None:
            self.service_name_fuzzy = m.get('ServiceNameFuzzy')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('SuggestLevel') is not None:
            self.suggest_level = m.get('SuggestLevel')
        return self


class DescribeInternetOpenPortResponseBodyDataList(TeaModel):
    def __init__(
        self,
        detail_num: int = None,
        in_bytes: int = None,
        out_bytes: int = None,
        port: int = None,
        prob_risk: str = None,
        prob_risk_desc: str = None,
        protocol: str = None,
        public_ip_num: int = None,
        risk_level: int = None,
        risk_reason: str = None,
        service_name_list: List[str] = None,
        suggest_level: int = None,
        total_bytes: int = None,
        traffic_percent_1day: str = None,
        traffic_percent_30day: str = None,
        traffic_percent_7day: str = None,
        unknown_reason: List[str] = None,
    ):
        self.detail_num = detail_num
        self.in_bytes = in_bytes
        self.out_bytes = out_bytes
        self.port = port
        self.prob_risk = prob_risk
        self.prob_risk_desc = prob_risk_desc
        self.protocol = protocol
        self.public_ip_num = public_ip_num
        self.risk_level = risk_level
        self.risk_reason = risk_reason
        self.service_name_list = service_name_list
        self.suggest_level = suggest_level
        self.total_bytes = total_bytes
        self.traffic_percent_1day = traffic_percent_1day
        self.traffic_percent_30day = traffic_percent_30day
        self.traffic_percent_7day = traffic_percent_7day
        self.unknown_reason = unknown_reason

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.detail_num is not None:
            result['DetailNum'] = self.detail_num
        if self.in_bytes is not None:
            result['InBytes'] = self.in_bytes
        if self.out_bytes is not None:
            result['OutBytes'] = self.out_bytes
        if self.port is not None:
            result['Port'] = self.port
        if self.prob_risk is not None:
            result['ProbRisk'] = self.prob_risk
        if self.prob_risk_desc is not None:
            result['ProbRiskDesc'] = self.prob_risk_desc
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.public_ip_num is not None:
            result['PublicIpNum'] = self.public_ip_num
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.risk_reason is not None:
            result['RiskReason'] = self.risk_reason
        if self.service_name_list is not None:
            result['ServiceNameList'] = self.service_name_list
        if self.suggest_level is not None:
            result['SuggestLevel'] = self.suggest_level
        if self.total_bytes is not None:
            result['TotalBytes'] = self.total_bytes
        if self.traffic_percent_1day is not None:
            result['TrafficPercent1Day'] = self.traffic_percent_1day
        if self.traffic_percent_30day is not None:
            result['TrafficPercent30Day'] = self.traffic_percent_30day
        if self.traffic_percent_7day is not None:
            result['TrafficPercent7Day'] = self.traffic_percent_7day
        if self.unknown_reason is not None:
            result['UnknownReason'] = self.unknown_reason
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DetailNum') is not None:
            self.detail_num = m.get('DetailNum')
        if m.get('InBytes') is not None:
            self.in_bytes = m.get('InBytes')
        if m.get('OutBytes') is not None:
            self.out_bytes = m.get('OutBytes')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('ProbRisk') is not None:
            self.prob_risk = m.get('ProbRisk')
        if m.get('ProbRiskDesc') is not None:
            self.prob_risk_desc = m.get('ProbRiskDesc')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('PublicIpNum') is not None:
            self.public_ip_num = m.get('PublicIpNum')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('RiskReason') is not None:
            self.risk_reason = m.get('RiskReason')
        if m.get('ServiceNameList') is not None:
            self.service_name_list = m.get('ServiceNameList')
        if m.get('SuggestLevel') is not None:
            self.suggest_level = m.get('SuggestLevel')
        if m.get('TotalBytes') is not None:
            self.total_bytes = m.get('TotalBytes')
        if m.get('TrafficPercent1Day') is not None:
            self.traffic_percent_1day = m.get('TrafficPercent1Day')
        if m.get('TrafficPercent30Day') is not None:
            self.traffic_percent_30day = m.get('TrafficPercent30Day')
        if m.get('TrafficPercent7Day') is not None:
            self.traffic_percent_7day = m.get('TrafficPercent7Day')
        if m.get('UnknownReason') is not None:
            self.unknown_reason = m.get('UnknownReason')
        return self


class DescribeInternetOpenPortResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeInternetOpenPortResponseBody(TeaModel):
    def __init__(
        self,
        data_list: List[DescribeInternetOpenPortResponseBodyDataList] = None,
        page_info: DescribeInternetOpenPortResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        self.data_list = data_list
        self.page_info = page_info
        self.request_id = request_id

    def validate(self):
        if self.data_list:
            for k in self.data_list:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataList'] = []
        if self.data_list is not None:
            for k in self.data_list:
                result['DataList'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_list = []
        if m.get('DataList') is not None:
            for k in m.get('DataList'):
                temp_model = DescribeInternetOpenPortResponseBodyDataList()
                self.data_list.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeInternetOpenPortResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeInternetOpenPortResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInternetOpenPortResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInternetOpenPortResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInternetOpenServiceRequest(TeaModel):
    def __init__(
        self,
        current_page: str = None,
        end_time: str = None,
        lang: str = None,
        page_size: str = None,
        port: str = None,
        risk_level: str = None,
        service_name: str = None,
        service_name_fuzzy: str = None,
        source_ip: str = None,
        start_time: str = None,
        suggest_level: str = None,
    ):
        self.current_page = current_page
        self.end_time = end_time
        self.lang = lang
        self.page_size = page_size
        self.port = port
        self.risk_level = risk_level
        self.service_name = service_name
        self.service_name_fuzzy = service_name_fuzzy
        self.source_ip = source_ip
        self.start_time = start_time
        self.suggest_level = suggest_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.port is not None:
            result['Port'] = self.port
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.service_name_fuzzy is not None:
            result['ServiceNameFuzzy'] = self.service_name_fuzzy
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.suggest_level is not None:
            result['SuggestLevel'] = self.suggest_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ServiceNameFuzzy') is not None:
            self.service_name_fuzzy = m.get('ServiceNameFuzzy')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('SuggestLevel') is not None:
            self.suggest_level = m.get('SuggestLevel')
        return self


class DescribeInternetOpenServiceResponseBodyDataList(TeaModel):
    def __init__(
        self,
        detail_num: int = None,
        in_bytes: int = None,
        out_bytes: int = None,
        port_list: List[str] = None,
        prob_risk: str = None,
        prob_risk_desc: str = None,
        protocol: str = None,
        public_ip_num: int = None,
        risk_level: int = None,
        risk_reason: str = None,
        service_name: int = None,
        suggest_level: int = None,
        total_bytes: int = None,
        traffic_percent_1day: str = None,
        traffic_percent_30day: str = None,
        traffic_percent_7day: str = None,
        unknown_reason: List[str] = None,
    ):
        self.detail_num = detail_num
        self.in_bytes = in_bytes
        self.out_bytes = out_bytes
        self.port_list = port_list
        self.prob_risk = prob_risk
        self.prob_risk_desc = prob_risk_desc
        self.protocol = protocol
        self.public_ip_num = public_ip_num
        self.risk_level = risk_level
        self.risk_reason = risk_reason
        self.service_name = service_name
        self.suggest_level = suggest_level
        self.total_bytes = total_bytes
        self.traffic_percent_1day = traffic_percent_1day
        self.traffic_percent_30day = traffic_percent_30day
        self.traffic_percent_7day = traffic_percent_7day
        self.unknown_reason = unknown_reason

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.detail_num is not None:
            result['DetailNum'] = self.detail_num
        if self.in_bytes is not None:
            result['InBytes'] = self.in_bytes
        if self.out_bytes is not None:
            result['OutBytes'] = self.out_bytes
        if self.port_list is not None:
            result['PortList'] = self.port_list
        if self.prob_risk is not None:
            result['ProbRisk'] = self.prob_risk
        if self.prob_risk_desc is not None:
            result['ProbRiskDesc'] = self.prob_risk_desc
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.public_ip_num is not None:
            result['PublicIpNum'] = self.public_ip_num
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.risk_reason is not None:
            result['RiskReason'] = self.risk_reason
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.suggest_level is not None:
            result['SuggestLevel'] = self.suggest_level
        if self.total_bytes is not None:
            result['TotalBytes'] = self.total_bytes
        if self.traffic_percent_1day is not None:
            result['TrafficPercent1Day'] = self.traffic_percent_1day
        if self.traffic_percent_30day is not None:
            result['TrafficPercent30Day'] = self.traffic_percent_30day
        if self.traffic_percent_7day is not None:
            result['TrafficPercent7Day'] = self.traffic_percent_7day
        if self.unknown_reason is not None:
            result['UnknownReason'] = self.unknown_reason
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DetailNum') is not None:
            self.detail_num = m.get('DetailNum')
        if m.get('InBytes') is not None:
            self.in_bytes = m.get('InBytes')
        if m.get('OutBytes') is not None:
            self.out_bytes = m.get('OutBytes')
        if m.get('PortList') is not None:
            self.port_list = m.get('PortList')
        if m.get('ProbRisk') is not None:
            self.prob_risk = m.get('ProbRisk')
        if m.get('ProbRiskDesc') is not None:
            self.prob_risk_desc = m.get('ProbRiskDesc')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('PublicIpNum') is not None:
            self.public_ip_num = m.get('PublicIpNum')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('RiskReason') is not None:
            self.risk_reason = m.get('RiskReason')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('SuggestLevel') is not None:
            self.suggest_level = m.get('SuggestLevel')
        if m.get('TotalBytes') is not None:
            self.total_bytes = m.get('TotalBytes')
        if m.get('TrafficPercent1Day') is not None:
            self.traffic_percent_1day = m.get('TrafficPercent1Day')
        if m.get('TrafficPercent30Day') is not None:
            self.traffic_percent_30day = m.get('TrafficPercent30Day')
        if m.get('TrafficPercent7Day') is not None:
            self.traffic_percent_7day = m.get('TrafficPercent7Day')
        if m.get('UnknownReason') is not None:
            self.unknown_reason = m.get('UnknownReason')
        return self


class DescribeInternetOpenServiceResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeInternetOpenServiceResponseBody(TeaModel):
    def __init__(
        self,
        data_list: List[DescribeInternetOpenServiceResponseBodyDataList] = None,
        page_info: DescribeInternetOpenServiceResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        self.data_list = data_list
        self.page_info = page_info
        self.request_id = request_id

    def validate(self):
        if self.data_list:
            for k in self.data_list:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataList'] = []
        if self.data_list is not None:
            for k in self.data_list:
                result['DataList'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_list = []
        if m.get('DataList') is not None:
            for k in m.get('DataList'):
                temp_model = DescribeInternetOpenServiceResponseBodyDataList()
                self.data_list.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeInternetOpenServiceResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeInternetOpenServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInternetOpenServiceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInternetOpenServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInternetTrafficTrendRequest(TeaModel):
    def __init__(
        self,
        direction: str = None,
        end_time: str = None,
        lang: str = None,
        source_code: str = None,
        source_ip: str = None,
        src_private_ip: str = None,
        src_public_ip: str = None,
        start_time: str = None,
        traffic_type: str = None,
    ):
        # The direction of the internet traffic.
        # 
        # Valid values:
        # 
        # *   **in**: inbound traffic
        # *   **out**: outbound traffic
        self.direction = direction
        # The end of the time range to query. The value is a UNIX timestamp. Unit: seconds.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The language of the content in the request and response. Valid values:
        # 
        # *   **zh** (default): Chinese
        # *   **en**: English
        self.lang = lang
        # The source code.
        # 
        # This parameter is required.
        self.source_code = source_code
        # The IP address of the access source.
        self.source_ip = source_ip
        # The private IP address of the source.
        self.src_private_ip = src_private_ip
        # The public IP address of the source.
        self.src_public_ip = src_public_ip
        # The beginning of the time range to query. The value is a UNIX timestamp. Unit: seconds.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The type of the traffic that is captured. Valid values:
        # 
        # *   **max** (default): peak traffic
        # *   **avg**: average traffic
        self.traffic_type = traffic_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_code is not None:
            result['SourceCode'] = self.source_code
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.src_private_ip is not None:
            result['SrcPrivateIP'] = self.src_private_ip
        if self.src_public_ip is not None:
            result['SrcPublicIP'] = self.src_public_ip
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.traffic_type is not None:
            result['TrafficType'] = self.traffic_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceCode') is not None:
            self.source_code = m.get('SourceCode')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('SrcPrivateIP') is not None:
            self.src_private_ip = m.get('SrcPrivateIP')
        if m.get('SrcPublicIP') is not None:
            self.src_public_ip = m.get('SrcPublicIP')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TrafficType') is not None:
            self.traffic_type = m.get('TrafficType')
        return self


class DescribeInternetTrafficTrendResponseBodyDataList(TeaModel):
    def __init__(
        self,
        in_bps: int = None,
        in_bytes: int = None,
        in_pps: int = None,
        new_conn: int = None,
        out_bps: int = None,
        out_bytes: int = None,
        out_pps: int = None,
        session_count: int = None,
        time: int = None,
        total_bps: int = None,
    ):
        # The inbound network throughput, which indicates the number of bits that are sent inbound per second. Unit: bit/s.
        self.in_bps = in_bps
        # The inbound network throughput, which indicates the total number of bytes that are sent inbound. Unit: bytes.
        self.in_bytes = in_bytes
        # The inbound network throughput, which indicates the number of packets that are sent inbound per second. Unit: packets per second (pps).
        self.in_pps = in_pps
        # The number of new connections.
        self.new_conn = new_conn
        # The outbound network throughput, which indicates the number of bits that are sent outbound per second. Unit: bit/s.
        self.out_bps = out_bps
        # The outbound network throughput, which indicates the total number of bytes that are sent outbound. Unit: bytes.
        self.out_bytes = out_bytes
        # The outbound network throughput, which indicates the number of packets that are sent outbound per second. Unit: pps.
        self.out_pps = out_pps
        # The number of requests.
        self.session_count = session_count
        # The time when traffic is generated. The value is a UNIX timestamp. Unit: seconds.
        # 
        # If processing is not complete at this point in time, -1 is returned for all other fields.
        self.time = time
        # The total outbound and inbound network throughput, which indicates the total number of bits that are sent inbound and outbound per second. Unit: bit/s.
        self.total_bps = total_bps

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.in_bps is not None:
            result['InBps'] = self.in_bps
        if self.in_bytes is not None:
            result['InBytes'] = self.in_bytes
        if self.in_pps is not None:
            result['InPps'] = self.in_pps
        if self.new_conn is not None:
            result['NewConn'] = self.new_conn
        if self.out_bps is not None:
            result['OutBps'] = self.out_bps
        if self.out_bytes is not None:
            result['OutBytes'] = self.out_bytes
        if self.out_pps is not None:
            result['OutPps'] = self.out_pps
        if self.session_count is not None:
            result['SessionCount'] = self.session_count
        if self.time is not None:
            result['Time'] = self.time
        if self.total_bps is not None:
            result['TotalBps'] = self.total_bps
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InBps') is not None:
            self.in_bps = m.get('InBps')
        if m.get('InBytes') is not None:
            self.in_bytes = m.get('InBytes')
        if m.get('InPps') is not None:
            self.in_pps = m.get('InPps')
        if m.get('NewConn') is not None:
            self.new_conn = m.get('NewConn')
        if m.get('OutBps') is not None:
            self.out_bps = m.get('OutBps')
        if m.get('OutBytes') is not None:
            self.out_bytes = m.get('OutBytes')
        if m.get('OutPps') is not None:
            self.out_pps = m.get('OutPps')
        if m.get('SessionCount') is not None:
            self.session_count = m.get('SessionCount')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('TotalBps') is not None:
            self.total_bps = m.get('TotalBps')
        return self


class DescribeInternetTrafficTrendResponseBody(TeaModel):
    def __init__(
        self,
        avg_in_bps: int = None,
        avg_out_bps: int = None,
        avg_session: int = None,
        avg_total_bps: int = None,
        data_list: List[DescribeInternetTrafficTrendResponseBodyDataList] = None,
        max_bandwidth_time: int = None,
        max_day_exceed_bytes: int = None,
        max_in_bps: int = None,
        max_out_bps: int = None,
        max_session: int = None,
        max_total_bps: int = None,
        request_id: str = None,
        total_bytes: int = None,
        total_exceed_bytes: int = None,
        total_in_bytes: int = None,
        total_out_bytes: int = None,
        total_session: int = None,
    ):
        # The average inbound network throughput, which indicates the average number of bits that are sent inbound per second. Unit: bit/s.
        self.avg_in_bps = avg_in_bps
        # The average outbound network throughput, which indicates the average number of bits that are sent outbound per second. Unit: bit/s.
        self.avg_out_bps = avg_out_bps
        # The average number of requests.
        self.avg_session = avg_session
        # The total average inbound and outbound network throughput, which indicates the average number of bits that are sent inbound and outbound per second. Unit: bit/s.
        self.avg_total_bps = avg_total_bps
        # The statistics on traffic.
        self.data_list = data_list
        # The timestamp generated when the bandwidth reaches the peak value. The value is a UNIX timestamp. Unit: seconds.
        self.max_bandwidth_time = max_bandwidth_time
        # The maximum volume of excess traffic allowed per day.
        self.max_day_exceed_bytes = max_day_exceed_bytes
        # The maximum inbound network throughput, which indicates the maximum number of bits that are sent inbound per second. Unit: bit/s.
        self.max_in_bps = max_in_bps
        # The maximum outbound network throughput, which indicates the maximum number of bits that are sent outbound per second. Unit: bit/s.
        self.max_out_bps = max_out_bps
        # The number of requests during the peak hour of the network throughout.
        self.max_session = max_session
        # The total maximum inbound and outbound network throughput, which indicates the maximum number of bits that are sent inbound and outbound per second. Unit: bit/s.
        self.max_total_bps = max_total_bps
        # The request ID.
        self.request_id = request_id
        # The total inbound and outbound network throughput, which indicates the total number of bytes that are sent inbound and outbound. Unit: bytes.
        self.total_bytes = total_bytes
        # The total volume of excess traffic.
        self.total_exceed_bytes = total_exceed_bytes
        # The inbound network throughput, which indicates the total number of bytes that are sent inbound. Unit: bytes.
        self.total_in_bytes = total_in_bytes
        # The outbound network throughput, which indicates the total number of bytes that are sent outbound. Unit: bytes.
        self.total_out_bytes = total_out_bytes
        # The total number of requests.
        self.total_session = total_session

    def validate(self):
        if self.data_list:
            for k in self.data_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avg_in_bps is not None:
            result['AvgInBps'] = self.avg_in_bps
        if self.avg_out_bps is not None:
            result['AvgOutBps'] = self.avg_out_bps
        if self.avg_session is not None:
            result['AvgSession'] = self.avg_session
        if self.avg_total_bps is not None:
            result['AvgTotalBps'] = self.avg_total_bps
        result['DataList'] = []
        if self.data_list is not None:
            for k in self.data_list:
                result['DataList'].append(k.to_map() if k else None)
        if self.max_bandwidth_time is not None:
            result['MaxBandwidthTime'] = self.max_bandwidth_time
        if self.max_day_exceed_bytes is not None:
            result['MaxDayExceedBytes'] = self.max_day_exceed_bytes
        if self.max_in_bps is not None:
            result['MaxInBps'] = self.max_in_bps
        if self.max_out_bps is not None:
            result['MaxOutBps'] = self.max_out_bps
        if self.max_session is not None:
            result['MaxSession'] = self.max_session
        if self.max_total_bps is not None:
            result['MaxTotalBps'] = self.max_total_bps
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_bytes is not None:
            result['TotalBytes'] = self.total_bytes
        if self.total_exceed_bytes is not None:
            result['TotalExceedBytes'] = self.total_exceed_bytes
        if self.total_in_bytes is not None:
            result['TotalInBytes'] = self.total_in_bytes
        if self.total_out_bytes is not None:
            result['TotalOutBytes'] = self.total_out_bytes
        if self.total_session is not None:
            result['TotalSession'] = self.total_session
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvgInBps') is not None:
            self.avg_in_bps = m.get('AvgInBps')
        if m.get('AvgOutBps') is not None:
            self.avg_out_bps = m.get('AvgOutBps')
        if m.get('AvgSession') is not None:
            self.avg_session = m.get('AvgSession')
        if m.get('AvgTotalBps') is not None:
            self.avg_total_bps = m.get('AvgTotalBps')
        self.data_list = []
        if m.get('DataList') is not None:
            for k in m.get('DataList'):
                temp_model = DescribeInternetTrafficTrendResponseBodyDataList()
                self.data_list.append(temp_model.from_map(k))
        if m.get('MaxBandwidthTime') is not None:
            self.max_bandwidth_time = m.get('MaxBandwidthTime')
        if m.get('MaxDayExceedBytes') is not None:
            self.max_day_exceed_bytes = m.get('MaxDayExceedBytes')
        if m.get('MaxInBps') is not None:
            self.max_in_bps = m.get('MaxInBps')
        if m.get('MaxOutBps') is not None:
            self.max_out_bps = m.get('MaxOutBps')
        if m.get('MaxSession') is not None:
            self.max_session = m.get('MaxSession')
        if m.get('MaxTotalBps') is not None:
            self.max_total_bps = m.get('MaxTotalBps')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalBytes') is not None:
            self.total_bytes = m.get('TotalBytes')
        if m.get('TotalExceedBytes') is not None:
            self.total_exceed_bytes = m.get('TotalExceedBytes')
        if m.get('TotalInBytes') is not None:
            self.total_in_bytes = m.get('TotalInBytes')
        if m.get('TotalOutBytes') is not None:
            self.total_out_bytes = m.get('TotalOutBytes')
        if m.get('TotalSession') is not None:
            self.total_session = m.get('TotalSession')
        return self


class DescribeInternetTrafficTrendResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInternetTrafficTrendResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInternetTrafficTrendResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInvadeEventListRequest(TeaModel):
    def __init__(
        self,
        assets_ip: str = None,
        assets_instance_id: str = None,
        assets_instance_name: str = None,
        current_page: str = None,
        end_time: str = None,
        event_key: str = None,
        event_name: str = None,
        event_uuid: str = None,
        is_ignore: str = None,
        lang: str = None,
        member_uid: int = None,
        page_size: str = None,
        process_status_list: List[int] = None,
        risk_level: List[int] = None,
        source_ip: str = None,
        start_time: str = None,
    ):
        # The IP address of the affected asset.
        self.assets_ip = assets_ip
        # The ID of the instance.
        self.assets_instance_id = assets_instance_id
        # The name of the instance.
        self.assets_instance_name = assets_instance_name
        # The number of the page to return.
        # 
        # Default value: 1.
        self.current_page = current_page
        # The end of the time range to query. The value is a UNIX timestamp. Unit: seconds. If you do not specify this parameter, the query ends at the current time.
        self.end_time = end_time
        # The ID of the breach awareness event.
        self.event_key = event_key
        # The name of the breach awareness event.
        self.event_name = event_name
        # The UUID of the breach awareness event.
        self.event_uuid = event_uuid
        # Specifies whether the breach awareness event is ignored. Valid values:
        # 
        # *   **true**: The breach awareness event is ignored.
        # *   **false**: The breach awareness event is not ignored.
        self.is_ignore = is_ignore
        # The language of the content within the response. Valid values:
        # 
        # *   **zh**: Chinese (default)
        # *   **en**: English
        self.lang = lang
        # The ID of the member.
        self.member_uid = member_uid
        # The number of entries to return on each page.
        # 
        # Default value: 6. Maximum value: 10.
        self.page_size = page_size
        # The handling status of breach awareness events.
        self.process_status_list = process_status_list
        # The risk levels.
        self.risk_level = risk_level
        # The source IP address of the request.
        self.source_ip = source_ip
        # The beginning of the time range to query. The value is a UNIX timestamp. Unit: seconds. If you do not specify this parameter, the query starts from 30 days before the current time.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assets_ip is not None:
            result['AssetsIP'] = self.assets_ip
        if self.assets_instance_id is not None:
            result['AssetsInstanceId'] = self.assets_instance_id
        if self.assets_instance_name is not None:
            result['AssetsInstanceName'] = self.assets_instance_name
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.event_key is not None:
            result['EventKey'] = self.event_key
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.event_uuid is not None:
            result['EventUuid'] = self.event_uuid
        if self.is_ignore is not None:
            result['IsIgnore'] = self.is_ignore
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.process_status_list is not None:
            result['ProcessStatusList'] = self.process_status_list
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssetsIP') is not None:
            self.assets_ip = m.get('AssetsIP')
        if m.get('AssetsInstanceId') is not None:
            self.assets_instance_id = m.get('AssetsInstanceId')
        if m.get('AssetsInstanceName') is not None:
            self.assets_instance_name = m.get('AssetsInstanceName')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EventKey') is not None:
            self.event_key = m.get('EventKey')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('EventUuid') is not None:
            self.event_uuid = m.get('EventUuid')
        if m.get('IsIgnore') is not None:
            self.is_ignore = m.get('IsIgnore')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProcessStatusList') is not None:
            self.process_status_list = m.get('ProcessStatusList')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeInvadeEventListResponseBodyEventList(TeaModel):
    def __init__(
        self,
        assets_instance_id: str = None,
        assets_instance_name: str = None,
        assets_type: str = None,
        event_key: str = None,
        event_name: str = None,
        event_src: str = None,
        event_uuid: str = None,
        first_time: int = None,
        is_ignore: bool = None,
        last_time: int = None,
        member_uid: str = None,
        private_ip: str = None,
        process_status: int = None,
        public_ip: str = None,
        public_ip_type: str = None,
        risk_level: int = None,
    ):
        # The ID of the affected asset.
        self.assets_instance_id = assets_instance_id
        # The name of the affected asset.
        self.assets_instance_name = assets_instance_name
        # The type of the affected asset. Valid values:
        # 
        # *   **BastionHostIP**: the egress IP address of a bastion host
        # *   **BastionHostIngressIP**: the ingress IP address of a bastion host
        # *   **EcsEIP**: the elastic IP address (EIP) of an Elastic Compute Service (ECS) instance
        # *   **EcsPublicIP**: the public IP address of an ECS instance
        # *   **EIP**: the EIP
        # *   **EniEIP**: the EIP of an elastic network interface (ENI)
        # *   **NatEIP**: the EIP of a NAT gateway
        # *   **SlbEIP**: the EIP of a Server Load Balancer (SLB) instance
        # *   **SlbPublicIP**: the public IP address of an SLB instance
        # *   **NatPublicIP**: the public IP address of a NAT gateway
        # *   **HAVIP**: the high-availability virtual IP address (HAVIP)
        self.assets_type = assets_type
        # The ID of the breach awareness event.
        self.event_key = event_key
        # The name of the breach awareness event.
        self.event_name = event_name
        # The type of the breach awareness event. Valid values:
        # 
        # *   **IPS**: intrusion prevention event
        # *   **offline**: disconnection event
        self.event_src = event_src
        # The UUID of the breach awareness event.
        self.event_uuid = event_uuid
        # The time when the breach awareness event first occurred. The value is a UNIX timestamp. Unit: seconds.
        self.first_time = first_time
        # Indicates whether the breach awareness event is ignored. Valid values:
        # 
        # *   **true**: The breach awareness event is ignored.
        # *   **false**: The breach awareness event is not ignored.
        self.is_ignore = is_ignore
        # The time when the breach awareness event last occurred. The value is a UNIX timestamp. Unit: seconds.
        self.last_time = last_time
        # The ID of the member.
        self.member_uid = member_uid
        # The private IP address of the affected asset.
        self.private_ip = private_ip
        # The handling status of the breach awareness event. Valid values:
        # 
        # *   **0**: unhandled
        # *   **20**: handled
        self.process_status = process_status
        # The public IP address of the affected asset.
        self.public_ip = public_ip
        # The type of the affected asset. Valid values:
        # 
        # *   **BastionHostIP**: the egress IP address of a bastion host
        # *   **BastionHostIngressIP**: the ingress IP address of a bastion host
        # *   **EcsEIP**: the EIP of an ECS instance
        # *   **EcsPublicIP**: the public IP address of an ECS instance
        # *   **EIP**: the EIP
        # *   **EniEIP**: the EIP of an ENI
        # *   **NatEIP**: the EIP of a NAT gateway
        # *   **SlbEIP**: the EIP of an SLB instance
        # *   **SlbPublicIP**: the public IP address of an SLB instance
        # *   **NatPublicIP**: the public IP address of a NAT gateway
        # *   **HAVIP**: the HAVIP
        self.public_ip_type = public_ip_type
        # The risk level. Valid values:
        # 
        # *   **1**: low
        # *   **2**: medium
        # *   **3**: high
        self.risk_level = risk_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assets_instance_id is not None:
            result['AssetsInstanceId'] = self.assets_instance_id
        if self.assets_instance_name is not None:
            result['AssetsInstanceName'] = self.assets_instance_name
        if self.assets_type is not None:
            result['AssetsType'] = self.assets_type
        if self.event_key is not None:
            result['EventKey'] = self.event_key
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.event_src is not None:
            result['EventSrc'] = self.event_src
        if self.event_uuid is not None:
            result['EventUuid'] = self.event_uuid
        if self.first_time is not None:
            result['FirstTime'] = self.first_time
        if self.is_ignore is not None:
            result['IsIgnore'] = self.is_ignore
        if self.last_time is not None:
            result['LastTime'] = self.last_time
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.private_ip is not None:
            result['PrivateIP'] = self.private_ip
        if self.process_status is not None:
            result['ProcessStatus'] = self.process_status
        if self.public_ip is not None:
            result['PublicIP'] = self.public_ip
        if self.public_ip_type is not None:
            result['PublicIpType'] = self.public_ip_type
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssetsInstanceId') is not None:
            self.assets_instance_id = m.get('AssetsInstanceId')
        if m.get('AssetsInstanceName') is not None:
            self.assets_instance_name = m.get('AssetsInstanceName')
        if m.get('AssetsType') is not None:
            self.assets_type = m.get('AssetsType')
        if m.get('EventKey') is not None:
            self.event_key = m.get('EventKey')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('EventSrc') is not None:
            self.event_src = m.get('EventSrc')
        if m.get('EventUuid') is not None:
            self.event_uuid = m.get('EventUuid')
        if m.get('FirstTime') is not None:
            self.first_time = m.get('FirstTime')
        if m.get('IsIgnore') is not None:
            self.is_ignore = m.get('IsIgnore')
        if m.get('LastTime') is not None:
            self.last_time = m.get('LastTime')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('PrivateIP') is not None:
            self.private_ip = m.get('PrivateIP')
        if m.get('ProcessStatus') is not None:
            self.process_status = m.get('ProcessStatus')
        if m.get('PublicIP') is not None:
            self.public_ip = m.get('PublicIP')
        if m.get('PublicIpType') is not None:
            self.public_ip_type = m.get('PublicIpType')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        return self


class DescribeInvadeEventListResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The page number of the returned page.
        self.current_page = current_page
        # The number of entries returned per page.
        self.page_size = page_size
        # The total number of breach awareness events.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeInvadeEventListResponseBody(TeaModel):
    def __init__(
        self,
        event_list: List[DescribeInvadeEventListResponseBodyEventList] = None,
        high_level_percent: int = None,
        low_level_percent: int = None,
        middle_level_percent: int = None,
        page_info: DescribeInvadeEventListResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        # An array that consists of breach awareness events.
        self.event_list = event_list
        # The percentage of high-risk events.
        self.high_level_percent = high_level_percent
        # The percentage of low-risk events.
        self.low_level_percent = low_level_percent
        # The percentage of medium-risk events.
        self.middle_level_percent = middle_level_percent
        # The pagination information.
        self.page_info = page_info
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.event_list:
            for k in self.event_list:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EventList'] = []
        if self.event_list is not None:
            for k in self.event_list:
                result['EventList'].append(k.to_map() if k else None)
        if self.high_level_percent is not None:
            result['HighLevelPercent'] = self.high_level_percent
        if self.low_level_percent is not None:
            result['LowLevelPercent'] = self.low_level_percent
        if self.middle_level_percent is not None:
            result['MiddleLevelPercent'] = self.middle_level_percent
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.event_list = []
        if m.get('EventList') is not None:
            for k in m.get('EventList'):
                temp_model = DescribeInvadeEventListResponseBodyEventList()
                self.event_list.append(temp_model.from_map(k))
        if m.get('HighLevelPercent') is not None:
            self.high_level_percent = m.get('HighLevelPercent')
        if m.get('LowLevelPercent') is not None:
            self.low_level_percent = m.get('LowLevelPercent')
        if m.get('MiddleLevelPercent') is not None:
            self.middle_level_percent = m.get('MiddleLevelPercent')
        if m.get('PageInfo') is not None:
            temp_model = DescribeInvadeEventListResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeInvadeEventListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInvadeEventListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInvadeEventListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInvadeEventNameListRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        lang: str = None,
        source_ip: str = None,
        start_time: str = None,
    ):
        self.end_time = end_time
        self.lang = lang
        self.source_ip = source_ip
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeInvadeEventNameListResponseBodyEventNameList(TeaModel):
    def __init__(
        self,
        event_key: str = None,
        event_name: str = None,
    ):
        self.event_key = event_key
        self.event_name = event_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_key is not None:
            result['EventKey'] = self.event_key
        if self.event_name is not None:
            result['EventName'] = self.event_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventKey') is not None:
            self.event_key = m.get('EventKey')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        return self


class DescribeInvadeEventNameListResponseBody(TeaModel):
    def __init__(
        self,
        event_name_list: List[DescribeInvadeEventNameListResponseBodyEventNameList] = None,
        name_list: List[str] = None,
        request_id: str = None,
    ):
        self.event_name_list = event_name_list
        self.name_list = name_list
        self.request_id = request_id

    def validate(self):
        if self.event_name_list:
            for k in self.event_name_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EventNameList'] = []
        if self.event_name_list is not None:
            for k in self.event_name_list:
                result['EventNameList'].append(k.to_map() if k else None)
        if self.name_list is not None:
            result['NameList'] = self.name_list
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.event_name_list = []
        if m.get('EventNameList') is not None:
            for k in m.get('EventNameList'):
                temp_model = DescribeInvadeEventNameListResponseBodyEventNameList()
                self.event_name_list.append(temp_model.from_map(k))
        if m.get('NameList') is not None:
            self.name_list = m.get('NameList')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeInvadeEventNameListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInvadeEventNameListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInvadeEventNameListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInvadeEventStatisticRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        lang: str = None,
        source_ip: str = None,
        start_time: str = None,
    ):
        self.end_time = end_time
        self.lang = lang
        self.source_ip = source_ip
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeInvadeEventStatisticResponseBody(TeaModel):
    def __init__(
        self,
        high_open_event_cnt: int = None,
        low_open_event_cnt: int = None,
        middle_open_event_cnt: int = None,
        request_id: str = None,
        total_open_event_cnt: int = None,
    ):
        self.high_open_event_cnt = high_open_event_cnt
        self.low_open_event_cnt = low_open_event_cnt
        self.middle_open_event_cnt = middle_open_event_cnt
        self.request_id = request_id
        self.total_open_event_cnt = total_open_event_cnt

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.high_open_event_cnt is not None:
            result['HighOpenEventCnt'] = self.high_open_event_cnt
        if self.low_open_event_cnt is not None:
            result['LowOpenEventCnt'] = self.low_open_event_cnt
        if self.middle_open_event_cnt is not None:
            result['MiddleOpenEventCnt'] = self.middle_open_event_cnt
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_open_event_cnt is not None:
            result['TotalOpenEventCnt'] = self.total_open_event_cnt
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HighOpenEventCnt') is not None:
            self.high_open_event_cnt = m.get('HighOpenEventCnt')
        if m.get('LowOpenEventCnt') is not None:
            self.low_open_event_cnt = m.get('LowOpenEventCnt')
        if m.get('MiddleOpenEventCnt') is not None:
            self.middle_open_event_cnt = m.get('MiddleOpenEventCnt')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalOpenEventCnt') is not None:
            self.total_open_event_cnt = m.get('TotalOpenEventCnt')
        return self


class DescribeInvadeEventStatisticResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInvadeEventStatisticResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInvadeEventStatisticResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLogStoreInfoResponseBody(TeaModel):
    def __init__(
        self,
        log_store_name: str = None,
        project_name: str = None,
        quota: int = None,
        region_id: str = None,
        request_id: str = None,
        ttl: int = None,
        used: int = None,
    ):
        # The name of the SLS LogStore in the log service.
        self.log_store_name = log_store_name
        # The Project name of the log service.
        self.project_name = project_name
        # Available log storage capacity. Unit: Byte.
        self.quota = quota
        # The region ID for log delivery.
        self.region_id = region_id
        # The ID of this request.
        self.request_id = request_id
        # Log storage duration. Unit: days.
        self.ttl = ttl
        # Used storage capacity. Unit: Byte.
        # 
        # > The statistics of the log service have a delay of approximately two hours.
        self.used = used

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log_store_name is not None:
            result['LogStoreName'] = self.log_store_name
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.quota is not None:
            result['Quota'] = self.quota
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ttl is not None:
            result['Ttl'] = self.ttl
        if self.used is not None:
            result['Used'] = self.used
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LogStoreName') is not None:
            self.log_store_name = m.get('LogStoreName')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('Quota') is not None:
            self.quota = m.get('Quota')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Ttl') is not None:
            self.ttl = m.get('Ttl')
        if m.get('Used') is not None:
            self.used = m.get('Used')
        return self


class DescribeLogStoreInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeLogStoreInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeLogStoreInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNatAclPageStatusRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        # The language of the content within the request and response. Valid values:
        # 
        # *   **zh** (default): Chinese
        # *   **en**: English
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeNatAclPageStatusResponseBody(TeaModel):
    def __init__(
        self,
        detail: str = None,
        nat_acl_page_enable: bool = None,
        request_id: str = None,
    ):
        # Extra error information.
        self.detail = detail
        # Indicates whether pagination for access control policies for NAT firewalls is supported.
        self.nat_acl_page_enable = nat_acl_page_enable
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.detail is not None:
            result['Detail'] = self.detail
        if self.nat_acl_page_enable is not None:
            result['NatAclPageEnable'] = self.nat_acl_page_enable
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        if m.get('NatAclPageEnable') is not None:
            self.nat_acl_page_enable = m.get('NatAclPageEnable')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeNatAclPageStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeNatAclPageStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNatAclPageStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNatFirewallControlPolicyRequest(TeaModel):
    def __init__(
        self,
        acl_action: str = None,
        acl_uuid: str = None,
        current_page: str = None,
        description: str = None,
        destination: str = None,
        direction: str = None,
        lang: str = None,
        nat_gateway_id: str = None,
        page_size: str = None,
        proto: str = None,
        release: str = None,
        repeat_type: str = None,
        source: str = None,
    ):
        # The action that Cloud Firewall performs on the traffic.
        # 
        # Valid values:
        # 
        # *   **accept**: allows the traffic.
        # *   **drop**: denies the traffic.
        # *   **log**: monitors the traffic.
        self.acl_action = acl_action
        # The UUID of the access control policy.
        self.acl_uuid = acl_uuid
        # The page number.
        self.current_page = current_page
        # The description of the access control policy. Fuzzy match is supported.
        # 
        # > If you do not specify this parameter, the descriptions of all policies are queried.
        self.description = description
        # The destination address in the access control policy. Fuzzy match is supported. The value of this parameter varies based on the value of the DestinationType parameter.
        # 
        # *   If DestinationType is set to `net`, the value of Destination must be a CIDR block. Example: 10.0.3.0/24.
        # *   If DestinationType is set to `domain`, the value of Destination must be a domain name. Example: aliyun.
        # *   If DestinationType is set to `group`, the value of Destination must be the name of an address book. Example: db_group.
        # *   If DestinationType is set to `location`, the value of Destination is a location. For more information about location codes, see [AddControlPolicy](https://help.aliyun.com/document_detail/474128.html). Example: ["BJ11", "ZB"].
        # 
        # > If you do not specify this parameter, all types of destination addresses are queried.
        self.destination = destination
        # The direction of the traffic to which the access control policy applies. Valid values:
        # 
        # *   **out**: outbound traffic
        # 
        # This parameter is required.
        self.direction = direction
        # The language of the content within the response. Valid values:
        # 
        # *   **zh**: Chinese (default)
        # *   **en**: English
        self.lang = lang
        # The ID of the NAT gateway.
        # 
        # This parameter is required.
        self.nat_gateway_id = nat_gateway_id
        # The number of entries per page. Default value: 10.
        self.page_size = page_size
        # The type of the protocol in the access control policy. Valid values:
        # 
        # *   **TCP**\
        # *   **UDP**\
        # *   **ICMP**\
        # *   **ANY**: all types of protocols
        # 
        # > If you do not specify this parameter, access control policies of all protocol types are queried.
        self.proto = proto
        # Specifies whether the access control policy is enabled. By default, an access control policy is enabled after it is created. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.release = release
        # The recurrence type for the access control policy to take effect. Valid values:
        # 
        # *   **Permanent** (default): The policy always takes effect.
        # *   **None**: The policy takes effect only once.
        # *   **Daily**: The policy takes effect on a daily basis.
        # *   **Weekly**: The policy takes effect on a weekly basis.
        # *   **Monthly**: The policy takes effect on a monthly basis.
        self.repeat_type = repeat_type
        # The source address in the access control policy. Fuzzy match is supported. The value of this parameter varies based on the value of the SourceType parameter.
        # 
        # *   If SourceType is set to `net`, the value of Source must be a CIDR block. Example: 192.0.XX.XX/24.
        # *   If SourceType is set to `group`, the value of Source must be the name of an address book. Example: db_group. If the db_group address book does not contain addresses, all source addresses are queried.
        # *   If SourceType is set to `location`, the value of Source must be a location. Example: beijing.
        # 
        # > If you do not specify this parameter, all types of source addresses are queried.
        self.source = source

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_action is not None:
            result['AclAction'] = self.acl_action
        if self.acl_uuid is not None:
            result['AclUuid'] = self.acl_uuid
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.description is not None:
            result['Description'] = self.description
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.proto is not None:
            result['Proto'] = self.proto
        if self.release is not None:
            result['Release'] = self.release
        if self.repeat_type is not None:
            result['RepeatType'] = self.repeat_type
        if self.source is not None:
            result['Source'] = self.source
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclAction') is not None:
            self.acl_action = m.get('AclAction')
        if m.get('AclUuid') is not None:
            self.acl_uuid = m.get('AclUuid')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Proto') is not None:
            self.proto = m.get('Proto')
        if m.get('Release') is not None:
            self.release = m.get('Release')
        if m.get('RepeatType') is not None:
            self.repeat_type = m.get('RepeatType')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        return self


class DescribeNatFirewallControlPolicyResponseBodyPolicys(TeaModel):
    def __init__(
        self,
        acl_action: str = None,
        acl_uuid: str = None,
        application_name_list: List[str] = None,
        create_time: int = None,
        description: str = None,
        dest_port: str = None,
        dest_port_group: str = None,
        dest_port_group_ports: List[str] = None,
        dest_port_type: str = None,
        destination: str = None,
        destination_group_cidrs: List[str] = None,
        destination_group_type: str = None,
        destination_type: str = None,
        dns_result: str = None,
        dns_result_time: int = None,
        domain_resolve_type: int = None,
        end_time: int = None,
        hit_last_time: int = None,
        hit_times: int = None,
        modify_time: int = None,
        nat_gateway_id: str = None,
        order: int = None,
        proto: str = None,
        release: str = None,
        repeat_days: List[int] = None,
        repeat_end_time: str = None,
        repeat_start_time: str = None,
        repeat_type: str = None,
        source: str = None,
        source_group_cidrs: List[str] = None,
        source_group_type: str = None,
        source_type: str = None,
        spread_cnt: str = None,
        start_time: int = None,
    ):
        # The action that Cloud Firewall performs on the traffic. Valid values:
        # 
        # *   **accept**: allows the traffic.
        # *   **drop**: denies the traffic.
        # *   **log**: monitors the traffic.
        self.acl_action = acl_action
        # The UUID of the access control policy.
        self.acl_uuid = acl_uuid
        # The application names.
        self.application_name_list = application_name_list
        # The time when the access control policy was created.
        self.create_time = create_time
        # The description of the access control policy.
        self.description = description
        # The destination port in the access control policy.
        self.dest_port = dest_port
        # The name of the destination port address book in the access control policy.
        self.dest_port_group = dest_port_group
        # The ports in the destination port address book.
        self.dest_port_group_ports = dest_port_group_ports
        # The type of the destination port in the access control policy. Valid values:
        # 
        # *   **port**: port
        # *   **group**: port address book
        self.dest_port_type = dest_port_type
        # The destination address in the access control policy. The value of this parameter varies based on the value of DestinationType. Valid values:
        # 
        # *   If the value of **DestinationType** is **net**, the value of this parameter is a CIDR block. Example: 192.0.XX.XX/24.
        # *   If the value of **DestinationType** is **domain**, the value of this parameter is a domain name. Example: aliyuncs.com.
        # *   If the value of **DestinationType** is **group**, the value of this parameter is the name of an address book. Example: db_group.
        # *   If the value of **DestinationType** is **location**, the value of this parameter is a location. For more information about location codes, see [AddControlPolicy](https://help.aliyun.com/document_detail/138867.html). Example: ["BJ11", "ZB"].
        self.destination = destination
        # The CIDR blocks in the destination address book.
        self.destination_group_cidrs = destination_group_cidrs
        # The type of the destination address book in the access control policy. Valid values:
        # 
        # *   **ip**: an address book that includes one or more CIDR blocks
        # *   **domain**: an address book that includes one or more domain names
        self.destination_group_type = destination_group_type
        # The type of the destination address in the access control policy. Valid values:
        # 
        # *   **net**: CIDR block
        # *   **group**: address book
        # *   **domain**: domain name
        # *   **location**: location
        self.destination_type = destination_type
        # The DNS resolution result.
        self.dns_result = dns_result
        # The time when the Domain Name System (DNS) resolution was performed. The value is a UNIX timestamp. Unit: seconds.
        self.dns_result_time = dns_result_time
        # The domain name resolution method of the access control policy. By default, an access control policy is enabled after the policy is created. Valid values:
        # 
        # *   **0**: fully qualified domain name (FQDN)-based resolution
        # *   **1**: DNS-based dynamic resolution
        # *   **2**: FQDN and DNS-based dynamic resolution
        self.domain_resolve_type = domain_resolve_type
        # The time when the access control policy stops taking effect. The value is a UNIX timestamp. Unit: seconds. The end time must be on the hour or on the half hour, and at least 30 minutes later than the start time.
        # 
        # >  If RepeatType is set to Permanent, this parameter is left empty. If RepeatType is set to None, Daily, Weekly, or Monthly, this parameter must be specified.
        self.end_time = end_time
        # The time when the access control policy was last hit. The value is a UNIX timestamp. Unit: seconds.
        self.hit_last_time = hit_last_time
        # The number of hits for the access control policy.
        self.hit_times = hit_times
        # The time when the access control policy was modified.
        self.modify_time = modify_time
        # The ID of the NAT gateway.
        self.nat_gateway_id = nat_gateway_id
        # The priority of the access control policy.
        # 
        # The priority value starts from 1. A smaller priority value indicates a higher priority.
        self.order = order
        # The protocol type in the access control policy. Valid values:
        # 
        # *   **ANY**\
        # *   **TCP**\
        # *   **UDP**\
        # *   **ICMP**\
        self.proto = proto
        # The status of the access control policy. By default, an access control policy is enabled after it is created. Valid values:
        # 
        # *   **true**: enabled
        # *   **false**: disabled
        self.release = release
        # The days of a week or of a month on which the access control policy takes effect.
        # 
        # *   If RepeatType is set to `Permanent`, `None`, or `Daily`, the value of this parameter is an empty array. Example: [].
        # *   If RepeatType is set to Weekly, this parameter must be specified. Example: [0, 6].
        # 
        # >  If RepeatType is set to Weekly, the fields in the value of this parameter cannot be repeated.
        # 
        # *   If RepeatType is set to `Monthly`, this parameter must be specified. Example: [1, 31].
        # 
        # >  If RepeatType is set to Monthly, the fields in the value of this parameter cannot be repeated.
        self.repeat_days = repeat_days
        # The point in time when the recurrence ends. Example: 23:30. The end time must be on the hour or on the half hour, and at least 30 minutes later than the start time.
        # 
        # >  If RepeatType is set to Permanent or None, this parameter is left empty. If RepeatType is set to Daily, Weekly, or Monthly, this parameter must be specified.
        self.repeat_end_time = repeat_end_time
        # The point in time when the recurrence starts. Example: 08:00. The start time must be on the hour or on the half hour, and at least 30 minutes earlier than the end time.
        # 
        # >  If RepeatType is set to Permanent or None, this parameter is left empty. If RepeatType is set to Daily, Weekly, or Monthly, this parameter must be specified.
        self.repeat_start_time = repeat_start_time
        # The recurrence type for the access control policy to take effect. Valid values:
        # 
        # *   **Permanent** (default): The policy always takes effect.
        # *   **None**: The policy takes effect for only once.
        # *   **Daily**: The policy takes effect on a daily basis.
        # *   **Weekly**: The policy takes effect on a weekly basis.
        # *   **Monthly**: The policy takes effect on a monthly basis.
        self.repeat_type = repeat_type
        # The source address in the access control policy. Valid values:
        # 
        # *   If the value of **SourceType** is `net`, the value of this parameter is a CIDR block. Example: 192.0.XX.XX/24.
        # *   If the value of **SourceType** is `group`, the value of this parameter is the name of an address book. Example: db_group.
        # *   If the value of **SourceType** is `location`, the value of this parameter is a location. For more information about location codes, see [AddControlPolicy](https://help.aliyun.com/document_detail/138867.html). Example: ["BJ11", "ZB"].
        self.source = source
        # The CIDR blocks in the source address book.
        self.source_group_cidrs = source_group_cidrs
        # The type of the source address book in the access control policy. The value is fixed as **ip**. The value indicates an address book that includes one or more CIDR blocks.
        self.source_group_type = source_group_type
        # The type of the source address in the access control policy. Valid values:
        # 
        # *   **net**: CIDR block
        # *   **group**: address book
        # *   **location**: location
        self.source_type = source_type
        # The total quota consumed by the returned access control policies, which is the sum of the quota consumed by each policy. The quota that is consumed by an access control policy is calculated by using the following formula: Quota that is consumed by an access control policy = Number of source addresses (number of CIDR blocks or regions) × Number of destination addresses (number of CIDR blocks, regions, or domain names) × Number of port ranges × Number of applications.
        self.spread_cnt = spread_cnt
        # The time when the access control policy starts to take effect. The value is a UNIX timestamp. Unit: seconds. The start time must be on the hour or on the half hour, and at least 30 minutes earlier than the end time.
        # 
        # >  If RepeatType is set to Permanent, this parameter is left empty. If RepeatType is set to None, Daily, Weekly, or Monthly, this parameter must be specified.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_action is not None:
            result['AclAction'] = self.acl_action
        if self.acl_uuid is not None:
            result['AclUuid'] = self.acl_uuid
        if self.application_name_list is not None:
            result['ApplicationNameList'] = self.application_name_list
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.dest_port is not None:
            result['DestPort'] = self.dest_port
        if self.dest_port_group is not None:
            result['DestPortGroup'] = self.dest_port_group
        if self.dest_port_group_ports is not None:
            result['DestPortGroupPorts'] = self.dest_port_group_ports
        if self.dest_port_type is not None:
            result['DestPortType'] = self.dest_port_type
        if self.destination is not None:
            result['Destination'] = self.destination
        if self.destination_group_cidrs is not None:
            result['DestinationGroupCidrs'] = self.destination_group_cidrs
        if self.destination_group_type is not None:
            result['DestinationGroupType'] = self.destination_group_type
        if self.destination_type is not None:
            result['DestinationType'] = self.destination_type
        if self.dns_result is not None:
            result['DnsResult'] = self.dns_result
        if self.dns_result_time is not None:
            result['DnsResultTime'] = self.dns_result_time
        if self.domain_resolve_type is not None:
            result['DomainResolveType'] = self.domain_resolve_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.hit_last_time is not None:
            result['HitLastTime'] = self.hit_last_time
        if self.hit_times is not None:
            result['HitTimes'] = self.hit_times
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.order is not None:
            result['Order'] = self.order
        if self.proto is not None:
            result['Proto'] = self.proto
        if self.release is not None:
            result['Release'] = self.release
        if self.repeat_days is not None:
            result['RepeatDays'] = self.repeat_days
        if self.repeat_end_time is not None:
            result['RepeatEndTime'] = self.repeat_end_time
        if self.repeat_start_time is not None:
            result['RepeatStartTime'] = self.repeat_start_time
        if self.repeat_type is not None:
            result['RepeatType'] = self.repeat_type
        if self.source is not None:
            result['Source'] = self.source
        if self.source_group_cidrs is not None:
            result['SourceGroupCidrs'] = self.source_group_cidrs
        if self.source_group_type is not None:
            result['SourceGroupType'] = self.source_group_type
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.spread_cnt is not None:
            result['SpreadCnt'] = self.spread_cnt
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclAction') is not None:
            self.acl_action = m.get('AclAction')
        if m.get('AclUuid') is not None:
            self.acl_uuid = m.get('AclUuid')
        if m.get('ApplicationNameList') is not None:
            self.application_name_list = m.get('ApplicationNameList')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestPort') is not None:
            self.dest_port = m.get('DestPort')
        if m.get('DestPortGroup') is not None:
            self.dest_port_group = m.get('DestPortGroup')
        if m.get('DestPortGroupPorts') is not None:
            self.dest_port_group_ports = m.get('DestPortGroupPorts')
        if m.get('DestPortType') is not None:
            self.dest_port_type = m.get('DestPortType')
        if m.get('Destination') is not None:
            self.destination = m.get('Destination')
        if m.get('DestinationGroupCidrs') is not None:
            self.destination_group_cidrs = m.get('DestinationGroupCidrs')
        if m.get('DestinationGroupType') is not None:
            self.destination_group_type = m.get('DestinationGroupType')
        if m.get('DestinationType') is not None:
            self.destination_type = m.get('DestinationType')
        if m.get('DnsResult') is not None:
            self.dns_result = m.get('DnsResult')
        if m.get('DnsResultTime') is not None:
            self.dns_result_time = m.get('DnsResultTime')
        if m.get('DomainResolveType') is not None:
            self.domain_resolve_type = m.get('DomainResolveType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('HitLastTime') is not None:
            self.hit_last_time = m.get('HitLastTime')
        if m.get('HitTimes') is not None:
            self.hit_times = m.get('HitTimes')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('Proto') is not None:
            self.proto = m.get('Proto')
        if m.get('Release') is not None:
            self.release = m.get('Release')
        if m.get('RepeatDays') is not None:
            self.repeat_days = m.get('RepeatDays')
        if m.get('RepeatEndTime') is not None:
            self.repeat_end_time = m.get('RepeatEndTime')
        if m.get('RepeatStartTime') is not None:
            self.repeat_start_time = m.get('RepeatStartTime')
        if m.get('RepeatType') is not None:
            self.repeat_type = m.get('RepeatType')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SourceGroupCidrs') is not None:
            self.source_group_cidrs = m.get('SourceGroupCidrs')
        if m.get('SourceGroupType') is not None:
            self.source_group_type = m.get('SourceGroupType')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('SpreadCnt') is not None:
            self.spread_cnt = m.get('SpreadCnt')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeNatFirewallControlPolicyResponseBody(TeaModel):
    def __init__(
        self,
        policys: List[DescribeNatFirewallControlPolicyResponseBodyPolicys] = None,
        request_id: str = None,
        total_count: str = None,
    ):
        # The information about the access control policies.
        self.policys = policys
        # The request ID.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.policys:
            for k in self.policys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Policys'] = []
        if self.policys is not None:
            for k in self.policys:
                result['Policys'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.policys = []
        if m.get('Policys') is not None:
            for k in m.get('Policys'):
                temp_model = DescribeNatFirewallControlPolicyResponseBodyPolicys()
                self.policys.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeNatFirewallControlPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeNatFirewallControlPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNatFirewallControlPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNatFirewallDropTrafficTrendRequest(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        source_ip: str = None,
        start_time: int = None,
    ):
        self.end_time = end_time
        self.source_ip = source_ip
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeNatFirewallDropTrafficTrendResponseBodyDataList(TeaModel):
    def __init__(
        self,
        drop_session: int = None,
        time: int = None,
        total_session: int = None,
    ):
        self.drop_session = drop_session
        self.time = time
        self.total_session = total_session

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.drop_session is not None:
            result['DropSession'] = self.drop_session
        if self.time is not None:
            result['Time'] = self.time
        if self.total_session is not None:
            result['TotalSession'] = self.total_session
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DropSession') is not None:
            self.drop_session = m.get('DropSession')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        if m.get('TotalSession') is not None:
            self.total_session = m.get('TotalSession')
        return self


class DescribeNatFirewallDropTrafficTrendResponseBody(TeaModel):
    def __init__(
        self,
        data_list: List[DescribeNatFirewallDropTrafficTrendResponseBodyDataList] = None,
        drop_session_max: int = None,
        drop_session_max_time: str = None,
        request_id: str = None,
    ):
        self.data_list = data_list
        self.drop_session_max = drop_session_max
        self.drop_session_max_time = drop_session_max_time
        self.request_id = request_id

    def validate(self):
        if self.data_list:
            for k in self.data_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataList'] = []
        if self.data_list is not None:
            for k in self.data_list:
                result['DataList'].append(k.to_map() if k else None)
        if self.drop_session_max is not None:
            result['DropSessionMax'] = self.drop_session_max
        if self.drop_session_max_time is not None:
            result['DropSessionMaxTime'] = self.drop_session_max_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_list = []
        if m.get('DataList') is not None:
            for k in m.get('DataList'):
                temp_model = DescribeNatFirewallDropTrafficTrendResponseBodyDataList()
                self.data_list.append(temp_model.from_map(k))
        if m.get('DropSessionMax') is not None:
            self.drop_session_max = m.get('DropSessionMax')
        if m.get('DropSessionMaxTime') is not None:
            self.drop_session_max_time = m.get('DropSessionMaxTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeNatFirewallDropTrafficTrendResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeNatFirewallDropTrafficTrendResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNatFirewallDropTrafficTrendResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNatFirewallListRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        member_uid: int = None,
        nat_gateway_id: str = None,
        page_no: int = None,
        page_size: int = None,
        proxy_id: str = None,
        proxy_name: str = None,
        region_no: str = None,
        status: str = None,
        vpc_id: str = None,
    ):
        # The language of the content within the response. Valid values:
        # *   **zh** (default)
        # *   **en**\
        self.lang = lang
        # The UID of the member that is managed by your Alibaba Cloud account.
        self.member_uid = member_uid
        # The ID of the NAT gateway.
        self.nat_gateway_id = nat_gateway_id
        # The page number.
        self.page_no = page_no
        # The number of entries per page.
        # 
        # Default value: **10**.**** Maximum value: **50**.
        self.page_size = page_size
        # The ID of the NAT firewall.
        self.proxy_id = proxy_id
        # The name of the NAT firewall. The name must be 4 to 50 characters in length, and can contain letters, digits, and underscores (_). The name cannot start with an underscore.
        self.proxy_name = proxy_name
        # The region ID of the virtual private cloud (VPC).
        self.region_no = region_no
        # The status of the NAT firewall. Valid values:
        # 
        # *   configuring
        # *   deleting
        # *   normal
        # *   abnormal
        # *   opening
        # *   closing
        # *   closed
        self.status = status
        # The ID of the VPC.
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.proxy_id is not None:
            result['ProxyId'] = self.proxy_id
        if self.proxy_name is not None:
            result['ProxyName'] = self.proxy_name
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.status is not None:
            result['Status'] = self.status
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProxyId') is not None:
            self.proxy_id = m.get('ProxyId')
        if m.get('ProxyName') is not None:
            self.proxy_name = m.get('ProxyName')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DescribeNatFirewallListResponseBodyNatFirewallListNatRouteEntryList(TeaModel):
    def __init__(
        self,
        destination_cidr: str = None,
        next_hop_id: str = None,
        next_hop_type: str = None,
        route_table_id: str = None,
    ):
        # The destination CIDR block of the default route.
        self.destination_cidr = destination_cidr
        # The next hop of the original NAT gateway.
        self.next_hop_id = next_hop_id
        # The network type of the next hop. The value is fixed as NatGateway.
        self.next_hop_type = next_hop_type
        # The route table to which the default route of the NAT gateway belongs.
        self.route_table_id = route_table_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_cidr is not None:
            result['DestinationCidr'] = self.destination_cidr
        if self.next_hop_id is not None:
            result['NextHopId'] = self.next_hop_id
        if self.next_hop_type is not None:
            result['NextHopType'] = self.next_hop_type
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DestinationCidr') is not None:
            self.destination_cidr = m.get('DestinationCidr')
        if m.get('NextHopId') is not None:
            self.next_hop_id = m.get('NextHopId')
        if m.get('NextHopType') is not None:
            self.next_hop_type = m.get('NextHopType')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        return self


class DescribeNatFirewallListResponseBodyNatFirewallList(TeaModel):
    def __init__(
        self,
        ali_uid: int = None,
        error_detail: str = None,
        member_uid: int = None,
        nat_gateway_id: str = None,
        nat_gateway_name: str = None,
        nat_route_entry_list: List[DescribeNatFirewallListResponseBodyNatFirewallListNatRouteEntryList] = None,
        proxy_id: str = None,
        proxy_name: str = None,
        proxy_network_interface_id: str = None,
        proxy_route_table_id: str = None,
        proxy_status: str = None,
        proxy_vswitch_id: str = None,
        region_id: str = None,
        strict_mode: int = None,
        vpc_id: str = None,
        vpc_name: str = None,
    ):
        # The UID of the Alibaba Cloud account.
        # 
        # >  The value of this parameter indicates the management account to which the member is added.
        self.ali_uid = ali_uid
        # The cause of the error.
        self.error_detail = error_detail
        # The UID of the member in Cloud Firewall.
        self.member_uid = member_uid
        # The ID of the NAT gateway.
        self.nat_gateway_id = nat_gateway_id
        # The name of the NAT gateway.
        self.nat_gateway_name = nat_gateway_name
        # The default route entries of the NAT gateway.
        self.nat_route_entry_list = nat_route_entry_list
        # The ID of the NAT firewall.
        self.proxy_id = proxy_id
        # The name of the NAT firewall.
        self.proxy_name = proxy_name
        self.proxy_network_interface_id = proxy_network_interface_id
        self.proxy_route_table_id = proxy_route_table_id
        # The status of the NAT firewall. Valid values:
        # 
        # *   configuring
        # *   deleting
        # *   normal
        # *   abnormal
        # *   opening
        # *   closing
        # *   closed
        self.proxy_status = proxy_status
        self.proxy_vswitch_id = proxy_vswitch_id
        # The region ID of your Cloud Firewall.
        # 
        # >  For more information about the supported regions of Cloud Firewall, see [Supported regions](https://help.aliyun.com/document_detail/195657.html).
        self.region_id = region_id
        # Indicates whether the strict mode is enabled. Valid values: 1, which specifies yes, and 0, which specifies no.
        self.strict_mode = strict_mode
        # The ID of the VPC.
        self.vpc_id = vpc_id
        # The name of the VPC.
        self.vpc_name = vpc_name

    def validate(self):
        if self.nat_route_entry_list:
            for k in self.nat_route_entry_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.error_detail is not None:
            result['ErrorDetail'] = self.error_detail
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.nat_gateway_name is not None:
            result['NatGatewayName'] = self.nat_gateway_name
        result['NatRouteEntryList'] = []
        if self.nat_route_entry_list is not None:
            for k in self.nat_route_entry_list:
                result['NatRouteEntryList'].append(k.to_map() if k else None)
        if self.proxy_id is not None:
            result['ProxyId'] = self.proxy_id
        if self.proxy_name is not None:
            result['ProxyName'] = self.proxy_name
        if self.proxy_network_interface_id is not None:
            result['ProxyNetworkInterfaceId'] = self.proxy_network_interface_id
        if self.proxy_route_table_id is not None:
            result['ProxyRouteTableId'] = self.proxy_route_table_id
        if self.proxy_status is not None:
            result['ProxyStatus'] = self.proxy_status
        if self.proxy_vswitch_id is not None:
            result['ProxyVSwitchId'] = self.proxy_vswitch_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.strict_mode is not None:
            result['StrictMode'] = self.strict_mode
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vpc_name is not None:
            result['VpcName'] = self.vpc_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('ErrorDetail') is not None:
            self.error_detail = m.get('ErrorDetail')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('NatGatewayName') is not None:
            self.nat_gateway_name = m.get('NatGatewayName')
        self.nat_route_entry_list = []
        if m.get('NatRouteEntryList') is not None:
            for k in m.get('NatRouteEntryList'):
                temp_model = DescribeNatFirewallListResponseBodyNatFirewallListNatRouteEntryList()
                self.nat_route_entry_list.append(temp_model.from_map(k))
        if m.get('ProxyId') is not None:
            self.proxy_id = m.get('ProxyId')
        if m.get('ProxyName') is not None:
            self.proxy_name = m.get('ProxyName')
        if m.get('ProxyNetworkInterfaceId') is not None:
            self.proxy_network_interface_id = m.get('ProxyNetworkInterfaceId')
        if m.get('ProxyRouteTableId') is not None:
            self.proxy_route_table_id = m.get('ProxyRouteTableId')
        if m.get('ProxyStatus') is not None:
            self.proxy_status = m.get('ProxyStatus')
        if m.get('ProxyVSwitchId') is not None:
            self.proxy_vswitch_id = m.get('ProxyVSwitchId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('StrictMode') is not None:
            self.strict_mode = m.get('StrictMode')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VpcName') is not None:
            self.vpc_name = m.get('VpcName')
        return self


class DescribeNatFirewallListResponseBody(TeaModel):
    def __init__(
        self,
        nat_firewall_list: List[DescribeNatFirewallListResponseBodyNatFirewallList] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The NAT firewalls.
        self.nat_firewall_list = nat_firewall_list
        # The request ID.
        self.request_id = request_id
        # The total number of NAT firewalls.
        self.total_count = total_count

    def validate(self):
        if self.nat_firewall_list:
            for k in self.nat_firewall_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NatFirewallList'] = []
        if self.nat_firewall_list is not None:
            for k in self.nat_firewall_list:
                result['NatFirewallList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.nat_firewall_list = []
        if m.get('NatFirewallList') is not None:
            for k in m.get('NatFirewallList'):
                temp_model = DescribeNatFirewallListResponseBodyNatFirewallList()
                self.nat_firewall_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeNatFirewallListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeNatFirewallListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNatFirewallListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNatFirewallPolicyPriorUsedRequest(TeaModel):
    def __init__(
        self,
        direction: str = None,
        ip_version: str = None,
        lang: str = None,
        nat_gateway_id: str = None,
    ):
        # The direction of the traffic to which the access control policy applies.
        # 
        # Valid values:
        # 
        # *   **out**: outbound traffic
        # 
        # This parameter is required.
        self.direction = direction
        # The IP version supported by the access control policy. Valid values:
        # 
        # *   **4**: IPv4 (default)
        self.ip_version = ip_version
        # The language of the content within the request and the response. Valid values:
        # 
        # *   **zh**: Chinese (default)
        # *   **en**: English
        self.lang = lang
        # The ID of the NAT gateway.
        # 
        # This parameter is required.
        self.nat_gateway_id = nat_gateway_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.ip_version is not None:
            result['IpVersion'] = self.ip_version
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('IpVersion') is not None:
            self.ip_version = m.get('IpVersion')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        return self


class DescribeNatFirewallPolicyPriorUsedResponseBody(TeaModel):
    def __init__(
        self,
        end: int = None,
        request_id: str = None,
        start: int = None,
    ):
        # The lowest priority for the access control policy.
        self.end = end
        # The request ID.
        self.request_id = request_id
        # The highest priority for the access control policy.
        self.start = start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end is not None:
            result['End'] = self.end
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class DescribeNatFirewallPolicyPriorUsedResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeNatFirewallPolicyPriorUsedResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNatFirewallPolicyPriorUsedResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNatFirewallQuotaRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        source_ip: str = None,
    ):
        self.lang = lang
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeNatFirewallQuotaResponseBody(TeaModel):
    def __init__(
        self,
        exception_count: int = None,
        request_id: str = None,
        total_count: int = None,
        unprotected_count: int = None,
        used_count: int = None,
    ):
        self.exception_count = exception_count
        self.request_id = request_id
        self.total_count = total_count
        self.unprotected_count = unprotected_count
        self.used_count = used_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exception_count is not None:
            result['ExceptionCount'] = self.exception_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.unprotected_count is not None:
            result['UnprotectedCount'] = self.unprotected_count
        if self.used_count is not None:
            result['UsedCount'] = self.used_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExceptionCount') is not None:
            self.exception_count = m.get('ExceptionCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('UnprotectedCount') is not None:
            self.unprotected_count = m.get('UnprotectedCount')
        if m.get('UsedCount') is not None:
            self.used_count = m.get('UsedCount')
        return self


class DescribeNatFirewallQuotaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeNatFirewallQuotaResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNatFirewallQuotaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNatFirewallTrafficTrendRequest(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        interval: int = None,
        nat_gateway_id: str = None,
        src_private_ip: str = None,
        src_public_ip: str = None,
        start_time: int = None,
    ):
        # The end of the time range to query. The value is a UNIX timestamp that is accurate to seconds.
        self.end_time = end_time
        # The time interval between the data entries to return. Unit: seconds. Valid values:
        # 
        # *   **60**: 1 minute
        # *   **1800**: 30 minutes
        self.interval = interval
        # The ID of the NAT gateway.
        self.nat_gateway_id = nat_gateway_id
        # The private IP address of the source.
        self.src_private_ip = src_private_ip
        # The public IP address of the source.
        self.src_public_ip = src_public_ip
        # The beginning of the time range to query. The value is a UNIX timestamp. Unit: seconds.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.src_private_ip is not None:
            result['SrcPrivateIP'] = self.src_private_ip
        if self.src_public_ip is not None:
            result['SrcPublicIP'] = self.src_public_ip
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('SrcPrivateIP') is not None:
            self.src_private_ip = m.get('SrcPrivateIP')
        if m.get('SrcPublicIP') is not None:
            self.src_public_ip = m.get('SrcPublicIP')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeNatFirewallTrafficTrendResponseBodyDataList(TeaModel):
    def __init__(
        self,
        max_in_bps: int = None,
        max_out_bps: int = None,
        max_total_bps: int = None,
        traffic_time: int = None,
    ):
        # The maximum inbound network throughput, which indicates the maximum number of bits that are sent inbound per second. Unit: bit/s.
        self.max_in_bps = max_in_bps
        # The maximum outbound network throughput, which indicates the maximum number of bits that are sent outbound per second. Unit: bit/s.
        self.max_out_bps = max_out_bps
        # The total maximum inbound and outbound network throughput, which indicates the maximum number of bits that are sent inbound and outbound per second. Unit: bit/s.
        self.max_total_bps = max_total_bps
        # The time range to query. The value is a UNIX timestamp. Unit: seconds.
        self.traffic_time = traffic_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_in_bps is not None:
            result['MaxInBps'] = self.max_in_bps
        if self.max_out_bps is not None:
            result['MaxOutBps'] = self.max_out_bps
        if self.max_total_bps is not None:
            result['MaxTotalBps'] = self.max_total_bps
        if self.traffic_time is not None:
            result['TrafficTime'] = self.traffic_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxInBps') is not None:
            self.max_in_bps = m.get('MaxInBps')
        if m.get('MaxOutBps') is not None:
            self.max_out_bps = m.get('MaxOutBps')
        if m.get('MaxTotalBps') is not None:
            self.max_total_bps = m.get('MaxTotalBps')
        if m.get('TrafficTime') is not None:
            self.traffic_time = m.get('TrafficTime')
        return self


class DescribeNatFirewallTrafficTrendResponseBody(TeaModel):
    def __init__(
        self,
        data_list: List[DescribeNatFirewallTrafficTrendResponseBodyDataList] = None,
        max_in_bps: int = None,
        max_out_bps: int = None,
        max_total_bps: int = None,
        request_id: str = None,
    ):
        # The statistics on traffic.
        self.data_list = data_list
        # The maximum inbound network throughput, which indicates the maximum number of bits that are sent inbound per second. Unit: bit/s.
        self.max_in_bps = max_in_bps
        # The maximum outbound network throughput, which indicates the maximum number of bits that are sent outbound per second. Unit: bit/s.
        self.max_out_bps = max_out_bps
        # The total maximum inbound and outbound network throughput, which indicates the maximum number of bits that are sent inbound and outbound per second. Unit: bit/s.
        self.max_total_bps = max_total_bps
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.data_list:
            for k in self.data_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataList'] = []
        if self.data_list is not None:
            for k in self.data_list:
                result['DataList'].append(k.to_map() if k else None)
        if self.max_in_bps is not None:
            result['MaxInBps'] = self.max_in_bps
        if self.max_out_bps is not None:
            result['MaxOutBps'] = self.max_out_bps
        if self.max_total_bps is not None:
            result['MaxTotalBps'] = self.max_total_bps
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_list = []
        if m.get('DataList') is not None:
            for k in m.get('DataList'):
                temp_model = DescribeNatFirewallTrafficTrendResponseBodyDataList()
                self.data_list.append(temp_model.from_map(k))
        if m.get('MaxInBps') is not None:
            self.max_in_bps = m.get('MaxInBps')
        if m.get('MaxOutBps') is not None:
            self.max_out_bps = m.get('MaxOutBps')
        if m.get('MaxTotalBps') is not None:
            self.max_total_bps = m.get('MaxTotalBps')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeNatFirewallTrafficTrendResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeNatFirewallTrafficTrendResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNatFirewallTrafficTrendResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNetworkInstanceListRequest(TeaModel):
    def __init__(
        self,
        cen_id: str = None,
        connect_type: str = None,
        lang: str = None,
    ):
        self.cen_id = cen_id
        self.connect_type = connect_type
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.connect_type is not None:
            result['ConnectType'] = self.connect_type
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ConnectType') is not None:
            self.connect_type = m.get('ConnectType')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeNetworkInstanceListResponseBodyNetworkInstanceList(TeaModel):
    def __init__(
        self,
        network_instance_id: str = None,
        network_instance_name: str = None,
        network_instance_type: str = None,
        region_no: str = None,
    ):
        self.network_instance_id = network_instance_id
        self.network_instance_name = network_instance_name
        self.network_instance_type = network_instance_type
        self.region_no = region_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_instance_id is not None:
            result['NetworkInstanceId'] = self.network_instance_id
        if self.network_instance_name is not None:
            result['NetworkInstanceName'] = self.network_instance_name
        if self.network_instance_type is not None:
            result['NetworkInstanceType'] = self.network_instance_type
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NetworkInstanceId') is not None:
            self.network_instance_id = m.get('NetworkInstanceId')
        if m.get('NetworkInstanceName') is not None:
            self.network_instance_name = m.get('NetworkInstanceName')
        if m.get('NetworkInstanceType') is not None:
            self.network_instance_type = m.get('NetworkInstanceType')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        return self


class DescribeNetworkInstanceListResponseBody(TeaModel):
    def __init__(
        self,
        network_instance_list: List[DescribeNetworkInstanceListResponseBodyNetworkInstanceList] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.network_instance_list = network_instance_list
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.network_instance_list:
            for k in self.network_instance_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NetworkInstanceList'] = []
        if self.network_instance_list is not None:
            for k in self.network_instance_list:
                result['NetworkInstanceList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.network_instance_list = []
        if m.get('NetworkInstanceList') is not None:
            for k in m.get('NetworkInstanceList'):
                temp_model = DescribeNetworkInstanceListResponseBodyNetworkInstanceList()
                self.network_instance_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeNetworkInstanceListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeNetworkInstanceListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNetworkInstanceListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNetworkInstanceRelationListRequest(TeaModel):
    def __init__(
        self,
        connect_type: str = None,
        firewall_configure_status: str = None,
        lang: str = None,
        network_instance_id: str = None,
        peer_network_instance_id: str = None,
    ):
        self.connect_type = connect_type
        self.firewall_configure_status = firewall_configure_status
        self.lang = lang
        self.network_instance_id = network_instance_id
        self.peer_network_instance_id = peer_network_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.connect_type is not None:
            result['ConnectType'] = self.connect_type
        if self.firewall_configure_status is not None:
            result['FirewallConfigureStatus'] = self.firewall_configure_status
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.network_instance_id is not None:
            result['NetworkInstanceId'] = self.network_instance_id
        if self.peer_network_instance_id is not None:
            result['PeerNetworkInstanceId'] = self.peer_network_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConnectType') is not None:
            self.connect_type = m.get('ConnectType')
        if m.get('FirewallConfigureStatus') is not None:
            self.firewall_configure_status = m.get('FirewallConfigureStatus')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NetworkInstanceId') is not None:
            self.network_instance_id = m.get('NetworkInstanceId')
        if m.get('PeerNetworkInstanceId') is not None:
            self.peer_network_instance_id = m.get('PeerNetworkInstanceId')
        return self


class DescribeNetworkInstanceRelationListResponseBodyNetworkInstanceListAssociatedCen(TeaModel):
    def __init__(
        self,
        attachment_id: str = None,
        attachment_name: str = None,
        cen_id: str = None,
        cen_name: str = None,
        transit_router_type: str = None,
    ):
        self.attachment_id = attachment_id
        self.attachment_name = attachment_name
        self.cen_id = cen_id
        self.cen_name = cen_name
        self.transit_router_type = transit_router_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attachment_id is not None:
            result['AttachmentId'] = self.attachment_id
        if self.attachment_name is not None:
            result['AttachmentName'] = self.attachment_name
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.cen_name is not None:
            result['CenName'] = self.cen_name
        if self.transit_router_type is not None:
            result['TransitRouterType'] = self.transit_router_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttachmentId') is not None:
            self.attachment_id = m.get('AttachmentId')
        if m.get('AttachmentName') is not None:
            self.attachment_name = m.get('AttachmentName')
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('CenName') is not None:
            self.cen_name = m.get('CenName')
        if m.get('TransitRouterType') is not None:
            self.transit_router_type = m.get('TransitRouterType')
        return self


class DescribeNetworkInstanceRelationListResponseBodyNetworkInstanceListPeerNetworkInstanceListAssociatedCen(TeaModel):
    def __init__(
        self,
        attachment_id: str = None,
        attachment_name: str = None,
        cen_id: str = None,
        cen_name: str = None,
        transit_router_type: str = None,
    ):
        self.attachment_id = attachment_id
        self.attachment_name = attachment_name
        self.cen_id = cen_id
        self.cen_name = cen_name
        self.transit_router_type = transit_router_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attachment_id is not None:
            result['AttachmentId'] = self.attachment_id
        if self.attachment_name is not None:
            result['AttachmentName'] = self.attachment_name
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.cen_name is not None:
            result['CenName'] = self.cen_name
        if self.transit_router_type is not None:
            result['TransitRouterType'] = self.transit_router_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttachmentId') is not None:
            self.attachment_id = m.get('AttachmentId')
        if m.get('AttachmentName') is not None:
            self.attachment_name = m.get('AttachmentName')
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('CenName') is not None:
            self.cen_name = m.get('CenName')
        if m.get('TransitRouterType') is not None:
            self.transit_router_type = m.get('TransitRouterType')
        return self


class DescribeNetworkInstanceRelationListResponseBodyNetworkInstanceListPeerNetworkInstanceList(TeaModel):
    def __init__(
        self,
        associated_cen: List[DescribeNetworkInstanceRelationListResponseBodyNetworkInstanceListPeerNetworkInstanceListAssociatedCen] = None,
        network_instance_id: str = None,
        network_instance_name: str = None,
        network_instance_type: str = None,
        region_no: str = None,
    ):
        self.associated_cen = associated_cen
        self.network_instance_id = network_instance_id
        self.network_instance_name = network_instance_name
        self.network_instance_type = network_instance_type
        self.region_no = region_no

    def validate(self):
        if self.associated_cen:
            for k in self.associated_cen:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AssociatedCen'] = []
        if self.associated_cen is not None:
            for k in self.associated_cen:
                result['AssociatedCen'].append(k.to_map() if k else None)
        if self.network_instance_id is not None:
            result['NetworkInstanceId'] = self.network_instance_id
        if self.network_instance_name is not None:
            result['NetworkInstanceName'] = self.network_instance_name
        if self.network_instance_type is not None:
            result['NetworkInstanceType'] = self.network_instance_type
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.associated_cen = []
        if m.get('AssociatedCen') is not None:
            for k in m.get('AssociatedCen'):
                temp_model = DescribeNetworkInstanceRelationListResponseBodyNetworkInstanceListPeerNetworkInstanceListAssociatedCen()
                self.associated_cen.append(temp_model.from_map(k))
        if m.get('NetworkInstanceId') is not None:
            self.network_instance_id = m.get('NetworkInstanceId')
        if m.get('NetworkInstanceName') is not None:
            self.network_instance_name = m.get('NetworkInstanceName')
        if m.get('NetworkInstanceType') is not None:
            self.network_instance_type = m.get('NetworkInstanceType')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        return self


class DescribeNetworkInstanceRelationListResponseBodyNetworkInstanceList(TeaModel):
    def __init__(
        self,
        associated_cen: List[DescribeNetworkInstanceRelationListResponseBodyNetworkInstanceListAssociatedCen] = None,
        connect_type: str = None,
        network_instance_id: str = None,
        network_instance_name: str = None,
        network_instance_type: str = None,
        peer_network_instance_list: List[DescribeNetworkInstanceRelationListResponseBodyNetworkInstanceListPeerNetworkInstanceList] = None,
        region_no: str = None,
    ):
        self.associated_cen = associated_cen
        self.connect_type = connect_type
        self.network_instance_id = network_instance_id
        self.network_instance_name = network_instance_name
        self.network_instance_type = network_instance_type
        self.peer_network_instance_list = peer_network_instance_list
        self.region_no = region_no

    def validate(self):
        if self.associated_cen:
            for k in self.associated_cen:
                if k:
                    k.validate()
        if self.peer_network_instance_list:
            for k in self.peer_network_instance_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AssociatedCen'] = []
        if self.associated_cen is not None:
            for k in self.associated_cen:
                result['AssociatedCen'].append(k.to_map() if k else None)
        if self.connect_type is not None:
            result['ConnectType'] = self.connect_type
        if self.network_instance_id is not None:
            result['NetworkInstanceId'] = self.network_instance_id
        if self.network_instance_name is not None:
            result['NetworkInstanceName'] = self.network_instance_name
        if self.network_instance_type is not None:
            result['NetworkInstanceType'] = self.network_instance_type
        result['PeerNetworkInstanceList'] = []
        if self.peer_network_instance_list is not None:
            for k in self.peer_network_instance_list:
                result['PeerNetworkInstanceList'].append(k.to_map() if k else None)
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.associated_cen = []
        if m.get('AssociatedCen') is not None:
            for k in m.get('AssociatedCen'):
                temp_model = DescribeNetworkInstanceRelationListResponseBodyNetworkInstanceListAssociatedCen()
                self.associated_cen.append(temp_model.from_map(k))
        if m.get('ConnectType') is not None:
            self.connect_type = m.get('ConnectType')
        if m.get('NetworkInstanceId') is not None:
            self.network_instance_id = m.get('NetworkInstanceId')
        if m.get('NetworkInstanceName') is not None:
            self.network_instance_name = m.get('NetworkInstanceName')
        if m.get('NetworkInstanceType') is not None:
            self.network_instance_type = m.get('NetworkInstanceType')
        self.peer_network_instance_list = []
        if m.get('PeerNetworkInstanceList') is not None:
            for k in m.get('PeerNetworkInstanceList'):
                temp_model = DescribeNetworkInstanceRelationListResponseBodyNetworkInstanceListPeerNetworkInstanceList()
                self.peer_network_instance_list.append(temp_model.from_map(k))
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        return self


class DescribeNetworkInstanceRelationListResponseBody(TeaModel):
    def __init__(
        self,
        network_instance_list: List[DescribeNetworkInstanceRelationListResponseBodyNetworkInstanceList] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.network_instance_list = network_instance_list
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.network_instance_list:
            for k in self.network_instance_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NetworkInstanceList'] = []
        if self.network_instance_list is not None:
            for k in self.network_instance_list:
                result['NetworkInstanceList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.network_instance_list = []
        if m.get('NetworkInstanceList') is not None:
            for k in m.get('NetworkInstanceList'):
                temp_model = DescribeNetworkInstanceRelationListResponseBodyNetworkInstanceList()
                self.network_instance_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeNetworkInstanceRelationListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeNetworkInstanceRelationListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNetworkInstanceRelationListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNetworkTrafficTopRatioRequest(TeaModel):
    def __init__(
        self,
        app_name: str = None,
        asset_ip: str = None,
        asset_region: str = None,
        data_type: str = None,
        direction: str = None,
        dst_ip: str = None,
        dst_port: str = None,
        end_time: str = None,
        ip_property: str = None,
        isp: str = None,
        lang: str = None,
        location: str = None,
        rule_result: str = None,
        sort: str = None,
        source_code: str = None,
        source_ip: str = None,
        src_ip: str = None,
        start_time: str = None,
    ):
        self.app_name = app_name
        self.asset_ip = asset_ip
        self.asset_region = asset_region
        # This parameter is required.
        self.data_type = data_type
        self.direction = direction
        self.dst_ip = dst_ip
        self.dst_port = dst_port
        # This parameter is required.
        self.end_time = end_time
        self.ip_property = ip_property
        self.isp = isp
        self.lang = lang
        self.location = location
        self.rule_result = rule_result
        self.sort = sort
        # This parameter is required.
        self.source_code = source_code
        self.source_ip = source_ip
        self.src_ip = src_ip
        # This parameter is required.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.asset_ip is not None:
            result['AssetIP'] = self.asset_ip
        if self.asset_region is not None:
            result['AssetRegion'] = self.asset_region
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.dst_ip is not None:
            result['DstIP'] = self.dst_ip
        if self.dst_port is not None:
            result['DstPort'] = self.dst_port
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.ip_property is not None:
            result['IpProperty'] = self.ip_property
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.location is not None:
            result['Location'] = self.location
        if self.rule_result is not None:
            result['RuleResult'] = self.rule_result
        if self.sort is not None:
            result['Sort'] = self.sort
        if self.source_code is not None:
            result['SourceCode'] = self.source_code
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.src_ip is not None:
            result['SrcIP'] = self.src_ip
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('AssetIP') is not None:
            self.asset_ip = m.get('AssetIP')
        if m.get('AssetRegion') is not None:
            self.asset_region = m.get('AssetRegion')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('DstIP') is not None:
            self.dst_ip = m.get('DstIP')
        if m.get('DstPort') is not None:
            self.dst_port = m.get('DstPort')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IpProperty') is not None:
            self.ip_property = m.get('IpProperty')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('RuleResult') is not None:
            self.rule_result = m.get('RuleResult')
        if m.get('Sort') is not None:
            self.sort = m.get('Sort')
        if m.get('SourceCode') is not None:
            self.source_code = m.get('SourceCode')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('SrcIP') is not None:
            self.src_ip = m.get('SrcIP')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeNetworkTrafficTopRatioResponseBodyDataList(TeaModel):
    def __init__(
        self,
        data_name: str = None,
        data_value: str = None,
    ):
        self.data_name = data_name
        self.data_value = data_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_name is not None:
            result['DataName'] = self.data_name
        if self.data_value is not None:
            result['DataValue'] = self.data_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataName') is not None:
            self.data_name = m.get('DataName')
        if m.get('DataValue') is not None:
            self.data_value = m.get('DataValue')
        return self


class DescribeNetworkTrafficTopRatioResponseBody(TeaModel):
    def __init__(
        self,
        data_count: int = None,
        data_list: List[DescribeNetworkTrafficTopRatioResponseBodyDataList] = None,
        data_type: str = None,
        request_id: str = None,
    ):
        self.data_count = data_count
        self.data_list = data_list
        self.data_type = data_type
        self.request_id = request_id

    def validate(self):
        if self.data_list:
            for k in self.data_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_count is not None:
            result['DataCount'] = self.data_count
        result['DataList'] = []
        if self.data_list is not None:
            for k in self.data_list:
                result['DataList'].append(k.to_map() if k else None)
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DataCount') is not None:
            self.data_count = m.get('DataCount')
        self.data_list = []
        if m.get('DataList') is not None:
            for k in m.get('DataList'):
                temp_model = DescribeNetworkTrafficTopRatioResponseBodyDataList()
                self.data_list.append(temp_model.from_map(k))
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeNetworkTrafficTopRatioResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeNetworkTrafficTopRatioResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNetworkTrafficTopRatioResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeOpenIpAccessSrcStatRequest(TeaModel):
    def __init__(
        self,
        current_page: str = None,
        dst_ip: str = None,
        lang: str = None,
        page_size: str = None,
        source_ip: str = None,
    ):
        self.current_page = current_page
        self.dst_ip = dst_ip
        self.lang = lang
        self.page_size = page_size
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dst_ip is not None:
            result['DstIp'] = self.dst_ip
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DstIp') is not None:
            self.dst_ip = m.get('DstIp')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeOpenIpAccessSrcStatResponseBodyStatList(TeaModel):
    def __init__(
        self,
        abnormal_src_ip: int = None,
        app: str = None,
        normal_src_ip: int = None,
        port: str = None,
    ):
        self.abnormal_src_ip = abnormal_src_ip
        self.app = app
        self.normal_src_ip = normal_src_ip
        self.port = port

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.abnormal_src_ip is not None:
            result['AbnormalSrcIp'] = self.abnormal_src_ip
        if self.app is not None:
            result['App'] = self.app
        if self.normal_src_ip is not None:
            result['NormalSrcIp'] = self.normal_src_ip
        if self.port is not None:
            result['Port'] = self.port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AbnormalSrcIp') is not None:
            self.abnormal_src_ip = m.get('AbnormalSrcIp')
        if m.get('App') is not None:
            self.app = m.get('App')
        if m.get('NormalSrcIp') is not None:
            self.normal_src_ip = m.get('NormalSrcIp')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        return self


class DescribeOpenIpAccessSrcStatResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        stat_list: List[DescribeOpenIpAccessSrcStatResponseBodyStatList] = None,
        total_count: int = None,
    ):
        self.request_id = request_id
        self.stat_list = stat_list
        self.total_count = total_count

    def validate(self):
        if self.stat_list:
            for k in self.stat_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['StatList'] = []
        if self.stat_list is not None:
            for k in self.stat_list:
                result['StatList'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.stat_list = []
        if m.get('StatList') is not None:
            for k in m.get('StatList'):
                temp_model = DescribeOpenIpAccessSrcStatResponseBodyStatList()
                self.stat_list.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeOpenIpAccessSrcStatResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeOpenIpAccessSrcStatResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeOpenIpAccessSrcStatResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeOutgoingAssetListRequest(TeaModel):
    def __init__(
        self,
        assets_region: str = None,
        current_page: str = None,
        end_time: str = None,
        group_name: str = None,
        iptype: str = None,
        lang: str = None,
        nat_gateway_id: str = None,
        nat_gateway_name: str = None,
        order: str = None,
        page_size: str = None,
        private_ip: str = None,
        public_ip: str = None,
        resource_type: str = None,
        security_risk: str = None,
        sort: str = None,
        start_time: str = None,
    ):
        self.assets_region = assets_region
        self.current_page = current_page
        # This parameter is required.
        self.end_time = end_time
        self.group_name = group_name
        self.iptype = iptype
        self.lang = lang
        self.nat_gateway_id = nat_gateway_id
        self.nat_gateway_name = nat_gateway_name
        self.order = order
        self.page_size = page_size
        self.private_ip = private_ip
        self.public_ip = public_ip
        self.resource_type = resource_type
        self.security_risk = security_risk
        self.sort = sort
        # This parameter is required.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assets_region is not None:
            result['AssetsRegion'] = self.assets_region
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.iptype is not None:
            result['IPType'] = self.iptype
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.nat_gateway_name is not None:
            result['NatGatewayName'] = self.nat_gateway_name
        if self.order is not None:
            result['Order'] = self.order
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.private_ip is not None:
            result['PrivateIP'] = self.private_ip
        if self.public_ip is not None:
            result['PublicIP'] = self.public_ip
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.security_risk is not None:
            result['SecurityRisk'] = self.security_risk
        if self.sort is not None:
            result['Sort'] = self.sort
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssetsRegion') is not None:
            self.assets_region = m.get('AssetsRegion')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('IPType') is not None:
            self.iptype = m.get('IPType')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('NatGatewayName') is not None:
            self.nat_gateway_name = m.get('NatGatewayName')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PrivateIP') is not None:
            self.private_ip = m.get('PrivateIP')
        if m.get('PublicIP') is not None:
            self.public_ip = m.get('PublicIP')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('SecurityRisk') is not None:
            self.security_risk = m.get('SecurityRisk')
        if m.get('Sort') is not None:
            self.sort = m.get('Sort')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeOutgoingAssetListResponseBodyAssetList(TeaModel):
    def __init__(
        self,
        asset_instance_id: str = None,
        asset_instance_name: str = None,
        assets_region: str = None,
        group_name: str = None,
        in_bytes: int = None,
        ips_hit_cnt: int = None,
        nat_gateway_id: str = None,
        nat_gateway_name: str = None,
        out_bytes: int = None,
        outgoing_domain_cnt: int = None,
        outgoing_dst_ipcnt: int = None,
        private_ip: str = None,
        private_iplist: List[str] = None,
        public_ip: str = None,
        resource_type: str = None,
        security_risk: str = None,
        session_count: int = None,
        total_bytes: int = None,
    ):
        self.asset_instance_id = asset_instance_id
        self.asset_instance_name = asset_instance_name
        self.assets_region = assets_region
        self.group_name = group_name
        self.in_bytes = in_bytes
        self.ips_hit_cnt = ips_hit_cnt
        self.nat_gateway_id = nat_gateway_id
        self.nat_gateway_name = nat_gateway_name
        self.out_bytes = out_bytes
        self.outgoing_domain_cnt = outgoing_domain_cnt
        self.outgoing_dst_ipcnt = outgoing_dst_ipcnt
        self.private_ip = private_ip
        self.private_iplist = private_iplist
        self.public_ip = public_ip
        self.resource_type = resource_type
        self.security_risk = security_risk
        self.session_count = session_count
        self.total_bytes = total_bytes

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_instance_id is not None:
            result['AssetInstanceId'] = self.asset_instance_id
        if self.asset_instance_name is not None:
            result['AssetInstanceName'] = self.asset_instance_name
        if self.assets_region is not None:
            result['AssetsRegion'] = self.assets_region
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.in_bytes is not None:
            result['InBytes'] = self.in_bytes
        if self.ips_hit_cnt is not None:
            result['IpsHitCnt'] = self.ips_hit_cnt
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.nat_gateway_name is not None:
            result['NatGatewayName'] = self.nat_gateway_name
        if self.out_bytes is not None:
            result['OutBytes'] = self.out_bytes
        if self.outgoing_domain_cnt is not None:
            result['OutgoingDomainCnt'] = self.outgoing_domain_cnt
        if self.outgoing_dst_ipcnt is not None:
            result['OutgoingDstIPCnt'] = self.outgoing_dst_ipcnt
        if self.private_ip is not None:
            result['PrivateIP'] = self.private_ip
        if self.private_iplist is not None:
            result['PrivateIPList'] = self.private_iplist
        if self.public_ip is not None:
            result['PublicIP'] = self.public_ip
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.security_risk is not None:
            result['SecurityRisk'] = self.security_risk
        if self.session_count is not None:
            result['SessionCount'] = self.session_count
        if self.total_bytes is not None:
            result['TotalBytes'] = self.total_bytes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssetInstanceId') is not None:
            self.asset_instance_id = m.get('AssetInstanceId')
        if m.get('AssetInstanceName') is not None:
            self.asset_instance_name = m.get('AssetInstanceName')
        if m.get('AssetsRegion') is not None:
            self.assets_region = m.get('AssetsRegion')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('InBytes') is not None:
            self.in_bytes = m.get('InBytes')
        if m.get('IpsHitCnt') is not None:
            self.ips_hit_cnt = m.get('IpsHitCnt')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('NatGatewayName') is not None:
            self.nat_gateway_name = m.get('NatGatewayName')
        if m.get('OutBytes') is not None:
            self.out_bytes = m.get('OutBytes')
        if m.get('OutgoingDomainCnt') is not None:
            self.outgoing_domain_cnt = m.get('OutgoingDomainCnt')
        if m.get('OutgoingDstIPCnt') is not None:
            self.outgoing_dst_ipcnt = m.get('OutgoingDstIPCnt')
        if m.get('PrivateIP') is not None:
            self.private_ip = m.get('PrivateIP')
        if m.get('PrivateIPList') is not None:
            self.private_iplist = m.get('PrivateIPList')
        if m.get('PublicIP') is not None:
            self.public_ip = m.get('PublicIP')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('SecurityRisk') is not None:
            self.security_risk = m.get('SecurityRisk')
        if m.get('SessionCount') is not None:
            self.session_count = m.get('SessionCount')
        if m.get('TotalBytes') is not None:
            self.total_bytes = m.get('TotalBytes')
        return self


class DescribeOutgoingAssetListResponseBody(TeaModel):
    def __init__(
        self,
        asset_list: List[DescribeOutgoingAssetListResponseBodyAssetList] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.asset_list = asset_list
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.asset_list:
            for k in self.asset_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AssetList'] = []
        if self.asset_list is not None:
            for k in self.asset_list:
                result['AssetList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.asset_list = []
        if m.get('AssetList') is not None:
            for k in m.get('AssetList'):
                temp_model = DescribeOutgoingAssetListResponseBodyAssetList()
                self.asset_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeOutgoingAssetListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeOutgoingAssetListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeOutgoingAssetListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeOutgoingDestinationIPRequest(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        category_id: str = None,
        current_page: str = None,
        dst_ip: str = None,
        end_time: str = None,
        lang: str = None,
        order: str = None,
        page_size: str = None,
        port: str = None,
        private_ip: str = None,
        public_ip: str = None,
        sort: str = None,
        start_time: str = None,
        tag_id_new: str = None,
    ):
        # The application type in the access control policy. Valid values:
        # 
        # *   **FTP**\
        # *   **HTTP**\
        # *   **HTTPS**\
        # *   **Memcache**\
        # *   **MongoDB**\
        # *   **MQTT**\
        # *   **MySQL**\
        # *   **RDP**\
        # *   **Redis**\
        # *   **SMTP**\
        # *   **SMTPS**\
        # *   **SSH**\
        # *   **SSL_No_Cert**\
        # *   **SSL**\
        # *   **VNC**\
        # 
        # >  The value of this parameter depends on the value of Proto. If you set Proto to TCP, you can set ApplicationNameList to any valid value. If you specify both ApplicationNameList and ApplicationName, only the value of ApplicationNameList is used.
        self.application_name = application_name
        # The ID of the service to which the destination IP address belongs. This parameter is left empty by default. Valid values:
        # 
        # *   **All**: all services
        # *   **RiskDomain**: risky domain names
        # *   **RiskIP**: risky IP addresses
        # *   **AliYun**: Alibaba Cloud services
        # *   **NotAliYun**: third-party services
        self.category_id = category_id
        # The number of the page to return.
        # 
        # Default value: 1.
        self.current_page = current_page
        # The destination IP address in the outbound connection that is initiated to access a domain name.
        self.dst_ip = dst_ip
        # The end of the time range to query. The value is a UNIX timestamp. Unit: seconds.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The language of the content within the response. Valid values:
        # 
        # *   **zh** (default)
        # *   **en**\
        self.lang = lang
        # The method that you want to use to sort the query results. Valid values:
        # 
        # *   **asc**\
        # *   **desc** (default)
        self.order = order
        # The number of entries to return on each page.
        # 
        # Default value: 6. Maximum value: 10.
        self.page_size = page_size
        # The port number.
        self.port = port
        # The private IP address of the ECS instance that initiates the outbound connection.
        self.private_ip = private_ip
        # The public IP address of the Elastic Compute Service (ECS) instance that initiates the outbound connection.
        self.public_ip = public_ip
        # The field based on which you want to sort the query results. Valid values:
        # 
        # *   **SessionCount** (default): the number of requests.
        # *   **TotalBytes**: the total volume of traffic.
        self.sort = sort
        # The beginning of the time range to query. The value is a UNIX timestamp. Unit: seconds.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The ID of the tag. Valid values:
        # 
        # *   **AliYun**: Alibaba Cloud service
        # *   **RiskDomain**: risky domain name
        # *   **RiskIP**: risky IP address
        # *   **TrustedDomain**: trusted website
        # *   **AliPay**: Alipay
        # *   **DingDing**: DingTalk
        # *   **WeChat**: WeChat
        # *   **QQ**: Tencent QQ
        # *   **SecurityService**: security service
        # *   **Microsoft**: Microsoft
        # *   **Amazon**: Amazon Web Services (AWS)
        # *   **Pan**: cloud disk
        # *   **Map**: map
        # *   **Code**: code hosting
        # *   **SystemService**: system service
        # *   **Taobao**: Taobao
        # *   **Google**: Google
        # *   **ThirdPartyService**: third-party service
        # *   **FirstFlow**: the first time
        # *   **Downloader**: malicious download
        # *   **Alexa Top1M**: popular website
        # *   **Miner**: mining pool
        # *   **Intelligence**: threat intelligence
        # *   **DDoS**: DDoS trojan
        # *   **Ransomware**: ransomware
        # *   **Spyware**: spyware
        # *   **Rogue**: rogue software
        # *   **Botnet**: botnet
        # *   **Suspicious**: suspicious website
        # *   **C\\&C**: command and control (C\\&C)
        # *   **Gang**: gang
        # *   **CVE**: Common Vulnerabilities and Exposures (CVE)
        # *   **Backdoor**: webshell
        # *   **Phishing**: phishing website
        # *   **APT**: advanced persistent threat (APT) attack
        # *   **Supply Chain Attack**: supply chain attack
        # *   **Malicious software**: malware
        self.tag_id_new = tag_id_new

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['ApplicationName'] = self.application_name
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dst_ip is not None:
            result['DstIP'] = self.dst_ip
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.order is not None:
            result['Order'] = self.order
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.port is not None:
            result['Port'] = self.port
        if self.private_ip is not None:
            result['PrivateIP'] = self.private_ip
        if self.public_ip is not None:
            result['PublicIP'] = self.public_ip
        if self.sort is not None:
            result['Sort'] = self.sort
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.tag_id_new is not None:
            result['TagIdNew'] = self.tag_id_new
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationName') is not None:
            self.application_name = m.get('ApplicationName')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DstIP') is not None:
            self.dst_ip = m.get('DstIP')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('PrivateIP') is not None:
            self.private_ip = m.get('PrivateIP')
        if m.get('PublicIP') is not None:
            self.public_ip = m.get('PublicIP')
        if m.get('Sort') is not None:
            self.sort = m.get('Sort')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TagIdNew') is not None:
            self.tag_id_new = m.get('TagIdNew')
        return self


class DescribeOutgoingDestinationIPResponseBodyDstIPListAddressGroupList(TeaModel):
    def __init__(
        self,
        address_group_name: str = None,
        address_group_uuid: str = None,
    ):
        # The name of the address book.
        self.address_group_name = address_group_name
        # The UUID of the address book.
        self.address_group_uuid = address_group_uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address_group_name is not None:
            result['AddressGroupName'] = self.address_group_name
        if self.address_group_uuid is not None:
            result['AddressGroupUUID'] = self.address_group_uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddressGroupName') is not None:
            self.address_group_name = m.get('AddressGroupName')
        if m.get('AddressGroupUUID') is not None:
            self.address_group_uuid = m.get('AddressGroupUUID')
        return self


class DescribeOutgoingDestinationIPResponseBodyDstIPListApplicationPortList(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        port: int = None,
        unknown_reason: List[str] = None,
    ):
        # The application type used in the access control policy. Valid values:
        # 
        # *   **FTP**\
        # *   **HTTP**\
        # *   **HTTPS**\
        # *   **Memcache**\
        # *   **MongoDB**\
        # *   **MQTT**\
        # *   **MySQL**\
        # *   **RDP**\
        # *   **Redis**\
        # *   **SMTP**\
        # *   **SMTPS**\
        # *   **SSH**\
        # *   **SSL_No_Cert**\
        # *   **SSL**\
        # *   **VNC**\
        # 
        # >  The value of this parameter depends on the value of the Proto parameter. If you set Proto to TCP, you can set ApplicationNameList to any valid value. If you configure both ApplicationNameList and ApplicationName, only the value of ApplicationNameList is used.
        self.application_name = application_name
        # The application port.
        self.port = port
        # List of reasons for failing to analyze the protocol when it is identified as Unknown.
        self.unknown_reason = unknown_reason

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['ApplicationName'] = self.application_name
        if self.port is not None:
            result['Port'] = self.port
        if self.unknown_reason is not None:
            result['UnknownReason'] = self.unknown_reason
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationName') is not None:
            self.application_name = m.get('ApplicationName')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('UnknownReason') is not None:
            self.unknown_reason = m.get('UnknownReason')
        return self


class DescribeOutgoingDestinationIPResponseBodyDstIPListTagList(TeaModel):
    def __init__(
        self,
        class_id: str = None,
        risk_level: int = None,
        tag_describe: str = None,
        tag_id: str = None,
        tag_name: str = None,
    ):
        # The type of the tag. Valid values:
        # 
        # *   **Suspicious**\
        # *   **Malicious**\
        # *   **Trusted**\
        self.class_id = class_id
        # The risk level. Valid values:
        # 
        # *   **1**: low.
        # *   **2**: medium.
        # *   **3**: high.
        self.risk_level = risk_level
        # The description of the tag.
        self.tag_describe = tag_describe
        # The ID of the tag.
        self.tag_id = tag_id
        # The name of the tag.
        self.tag_name = tag_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_id is not None:
            result['ClassId'] = self.class_id
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.tag_describe is not None:
            result['TagDescribe'] = self.tag_describe
        if self.tag_id is not None:
            result['TagId'] = self.tag_id
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClassId') is not None:
            self.class_id = m.get('ClassId')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('TagDescribe') is not None:
            self.tag_describe = m.get('TagDescribe')
        if m.get('TagId') is not None:
            self.tag_id = m.get('TagId')
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        return self


class DescribeOutgoingDestinationIPResponseBodyDstIPList(TeaModel):
    def __init__(
        self,
        acl_coverage: str = None,
        acl_recommend_detail: str = None,
        acl_status: str = None,
        address_group_list: List[DescribeOutgoingDestinationIPResponseBodyDstIPListAddressGroupList] = None,
        application_port_list: List[DescribeOutgoingDestinationIPResponseBodyDstIPListApplicationPortList] = None,
        asset_count: int = None,
        category_class_id: str = None,
        category_id: str = None,
        category_name: str = None,
        dst_ip: str = None,
        group_name: str = None,
        has_acl: str = None,
        has_acl_recommend: bool = None,
        in_bytes: int = None,
        is_mark_normal: bool = None,
        location_name: str = None,
        out_bytes: int = None,
        private_asset_count: int = None,
        rule_id: str = None,
        rule_name: str = None,
        security_reason: str = None,
        security_suggest: str = None,
        session_count: int = None,
        tag_list: List[DescribeOutgoingDestinationIPResponseBodyDstIPListTagList] = None,
        total_bytes: str = None,
    ):
        # Indicates whether an access control policy is configured. Valid values:
        # 
        # *   **Uncovered**: no
        # *   **FullCoverage**: yes
        self.acl_coverage = acl_coverage
        # The suggestion to configure an access control policy.
        self.acl_recommend_detail = acl_recommend_detail
        # The status of the access control policy. Valid values:
        # 
        # *   **normal**: healthy
        # *   **Abnormal**: unhealthy
        self.acl_status = acl_status
        # The information about the address book.
        self.address_group_list = address_group_list
        # The application ports.
        # 
        # >  Only the first 100 application ports are displayed.
        self.application_port_list = application_port_list
        # The outbound asset count.
        self.asset_count = asset_count
        # The type of the tag. Valid values:
        # 
        # *   **Suspicious**\
        # *   **Malicious**\
        # *   **Trusted**\
        self.category_class_id = category_class_id
        # The ID of the service type. Valid values:
        # 
        # *   **Aliyun**: Alibaba Cloud services
        # *   **NotAliyun**: third-party services
        self.category_id = category_id
        # The type of the service to which the destination IP address belongs. Valid values:
        # 
        # *   **Alibaba Cloud services**\
        # *   **Third-party services**\
        self.category_name = category_name
        # The destination IP addresses in outbound connections.
        self.dst_ip = dst_ip
        # The name of the group to which the access control policy belongs.
        self.group_name = group_name
        # Indicates whether an access control policy is configured. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.has_acl = has_acl
        # Indicates whether an access control policy is recommended. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.has_acl_recommend = has_acl_recommend
        # The inbound traffic. Unit: bytes.
        self.in_bytes = in_bytes
        # Indicates whether the destination IP address is added to a whitelist. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.is_mark_normal = is_mark_normal
        # Location name.
        self.location_name = location_name
        # The outbound traffic. Unit: bytes.
        self.out_bytes = out_bytes
        # The outbound private asset count.
        self.private_asset_count = private_asset_count
        # The UUID of the access control policy.
        self.rule_id = rule_id
        # The name of the access control policy.
        self.rule_name = rule_name
        # The reason why the domain name is secure.
        self.security_reason = security_reason
        # The suggestion to handle the traffic of the domain name in outbound connections. Valid values:
        # 
        # *   **pass**: allow
        # *   **alert**: deny
        # *   **drop**: monitor
        self.security_suggest = security_suggest
        # The number of requests.
        self.session_count = session_count
        # The tags.
        self.tag_list = tag_list
        # The total traffic. Unit: bytes
        self.total_bytes = total_bytes

    def validate(self):
        if self.address_group_list:
            for k in self.address_group_list:
                if k:
                    k.validate()
        if self.application_port_list:
            for k in self.application_port_list:
                if k:
                    k.validate()
        if self.tag_list:
            for k in self.tag_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_coverage is not None:
            result['AclCoverage'] = self.acl_coverage
        if self.acl_recommend_detail is not None:
            result['AclRecommendDetail'] = self.acl_recommend_detail
        if self.acl_status is not None:
            result['AclStatus'] = self.acl_status
        result['AddressGroupList'] = []
        if self.address_group_list is not None:
            for k in self.address_group_list:
                result['AddressGroupList'].append(k.to_map() if k else None)
        result['ApplicationPortList'] = []
        if self.application_port_list is not None:
            for k in self.application_port_list:
                result['ApplicationPortList'].append(k.to_map() if k else None)
        if self.asset_count is not None:
            result['AssetCount'] = self.asset_count
        if self.category_class_id is not None:
            result['CategoryClassId'] = self.category_class_id
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.category_name is not None:
            result['CategoryName'] = self.category_name
        if self.dst_ip is not None:
            result['DstIP'] = self.dst_ip
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.has_acl is not None:
            result['HasAcl'] = self.has_acl
        if self.has_acl_recommend is not None:
            result['HasAclRecommend'] = self.has_acl_recommend
        if self.in_bytes is not None:
            result['InBytes'] = self.in_bytes
        if self.is_mark_normal is not None:
            result['IsMarkNormal'] = self.is_mark_normal
        if self.location_name is not None:
            result['LocationName'] = self.location_name
        if self.out_bytes is not None:
            result['OutBytes'] = self.out_bytes
        if self.private_asset_count is not None:
            result['PrivateAssetCount'] = self.private_asset_count
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.security_reason is not None:
            result['SecurityReason'] = self.security_reason
        if self.security_suggest is not None:
            result['SecuritySuggest'] = self.security_suggest
        if self.session_count is not None:
            result['SessionCount'] = self.session_count
        result['TagList'] = []
        if self.tag_list is not None:
            for k in self.tag_list:
                result['TagList'].append(k.to_map() if k else None)
        if self.total_bytes is not None:
            result['TotalBytes'] = self.total_bytes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclCoverage') is not None:
            self.acl_coverage = m.get('AclCoverage')
        if m.get('AclRecommendDetail') is not None:
            self.acl_recommend_detail = m.get('AclRecommendDetail')
        if m.get('AclStatus') is not None:
            self.acl_status = m.get('AclStatus')
        self.address_group_list = []
        if m.get('AddressGroupList') is not None:
            for k in m.get('AddressGroupList'):
                temp_model = DescribeOutgoingDestinationIPResponseBodyDstIPListAddressGroupList()
                self.address_group_list.append(temp_model.from_map(k))
        self.application_port_list = []
        if m.get('ApplicationPortList') is not None:
            for k in m.get('ApplicationPortList'):
                temp_model = DescribeOutgoingDestinationIPResponseBodyDstIPListApplicationPortList()
                self.application_port_list.append(temp_model.from_map(k))
        if m.get('AssetCount') is not None:
            self.asset_count = m.get('AssetCount')
        if m.get('CategoryClassId') is not None:
            self.category_class_id = m.get('CategoryClassId')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('CategoryName') is not None:
            self.category_name = m.get('CategoryName')
        if m.get('DstIP') is not None:
            self.dst_ip = m.get('DstIP')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('HasAcl') is not None:
            self.has_acl = m.get('HasAcl')
        if m.get('HasAclRecommend') is not None:
            self.has_acl_recommend = m.get('HasAclRecommend')
        if m.get('InBytes') is not None:
            self.in_bytes = m.get('InBytes')
        if m.get('IsMarkNormal') is not None:
            self.is_mark_normal = m.get('IsMarkNormal')
        if m.get('LocationName') is not None:
            self.location_name = m.get('LocationName')
        if m.get('OutBytes') is not None:
            self.out_bytes = m.get('OutBytes')
        if m.get('PrivateAssetCount') is not None:
            self.private_asset_count = m.get('PrivateAssetCount')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SecurityReason') is not None:
            self.security_reason = m.get('SecurityReason')
        if m.get('SecuritySuggest') is not None:
            self.security_suggest = m.get('SecuritySuggest')
        if m.get('SessionCount') is not None:
            self.session_count = m.get('SessionCount')
        self.tag_list = []
        if m.get('TagList') is not None:
            for k in m.get('TagList'):
                temp_model = DescribeOutgoingDestinationIPResponseBodyDstIPListTagList()
                self.tag_list.append(temp_model.from_map(k))
        if m.get('TotalBytes') is not None:
            self.total_bytes = m.get('TotalBytes')
        return self


class DescribeOutgoingDestinationIPResponseBody(TeaModel):
    def __init__(
        self,
        dst_iplist: List[DescribeOutgoingDestinationIPResponseBodyDstIPList] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The IP addresses in outbound connections.
        self.dst_iplist = dst_iplist
        # The ID of the request.
        self.request_id = request_id
        # The total number of destination IP addresses in outbound connections.
        self.total_count = total_count

    def validate(self):
        if self.dst_iplist:
            for k in self.dst_iplist:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DstIPList'] = []
        if self.dst_iplist is not None:
            for k in self.dst_iplist:
                result['DstIPList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dst_iplist = []
        if m.get('DstIPList') is not None:
            for k in m.get('DstIPList'):
                temp_model = DescribeOutgoingDestinationIPResponseBodyDstIPList()
                self.dst_iplist.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeOutgoingDestinationIPResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeOutgoingDestinationIPResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeOutgoingDestinationIPResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeOutgoingDomainRequest(TeaModel):
    def __init__(
        self,
        category_id: str = None,
        current_page: str = None,
        data_type: str = None,
        domain: str = None,
        end_time: str = None,
        is_aitraffic: str = None,
        lang: str = None,
        order: str = None,
        page_size: str = None,
        public_ip: str = None,
        sort: str = None,
        start_time: str = None,
        tag_id_new: str = None,
    ):
        # The type of the service. This parameter is empty by default. Valid values:
        # 
        # *   **All**: all services
        # *   **RiskDomain**: risky domain names
        # *   **RiskIP**: risky IP addresses
        # *   **AliYun**: Alibaba Cloud services
        # *   **NotAliYun**: third-party services
        self.category_id = category_id
        # The number of the page to return.
        # 
        # Default value: 1.
        self.current_page = current_page
        # The source of traffic for statistics. Valid values:
        # 
        # *   **internet** (default): the Internet firewall.
        # *   **nat**: NAT firewalls.
        self.data_type = data_type
        # The domain name in outbound connections.
        self.domain = domain
        # The end of the time range to query. The value is a UNIX timestamp. Unit: seconds.
        # 
        # This parameter is required.
        self.end_time = end_time
        # Specifies whether to collect statistics only on AI service access traffic. Valid values:
        # 
        # *   **true**\
        # *   **false** (default)
        self.is_aitraffic = is_aitraffic
        # The language of the content within the request. Valid values:
        # 
        # *   **zh**: Chinese (default)
        # *   **en**: English
        self.lang = lang
        # The method that you want to use to sort the query results. Valid values:
        # 
        # *   **asc**\
        # *   **desc** (default)
        self.order = order
        # The number of entries to return on each page.
        # 
        # Default value: 6. Maximum value: 100.
        self.page_size = page_size
        # The public IP address of the Elastic Compute Service (ECS) instance that initiates outbound connections.
        self.public_ip = public_ip
        # The field based on which you want to sort the query results. Valid values:
        # 
        # *   **SessionCount** (default): the number of requests.
        # *   **TotalBytes**: the total volume of traffic.
        self.sort = sort
        # The beginning of the time range to query. The value is a UNIX timestamp. Unit: seconds.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The ID of the tag. Valid values:
        # 
        # *   **AliYun**: Alibaba Cloud service
        # *   **RiskDomain**: risky domain name
        # *   **RiskIP**: risky IP address
        # *   **TrustedDomain**: trusted website
        # *   **AliPay**: Alipay
        # *   **DingDing**: DingTalk
        # *   **WeChat**: WeChat
        # *   **QQ**: Tencent QQ
        # *   **SecurityService**: security service
        # *   **Microsoft**: Microsoft
        # *   **Amazon**: Amazon Web Services (AWS)
        # *   **Pan**: cloud disk
        # *   **Map**: map
        # *   **Code**: code hosting
        # *   **SystemService**: system service
        # *   **Taobao**: Taobao
        # *   **Google**: Google
        # *   **ThirdPartyService**: third-party service
        # *   **FirstFlow**: the first time when an outbound connection is initiated
        # *   **Downloader**: malicious download
        # *   **Alexa Top1M**: popular website
        # *   **Miner**: mining pool
        # *   **Intelligence**: threat intelligence
        # *   **DDoS**: DDoS trojan
        # *   **Ransomware**: ransomware
        # *   **Spyware**: spyware
        # *   **Rogue**: rogue software
        # *   **Botnet**: botnet
        # *   **Suspicious**: suspicious website
        # *   **C\\&C**: command and control (C\\&C)
        # *   **Gang**: gang
        # *   **CVE**: Common Vulnerabilities and Exposures (CVE)
        # *   **Backdoor**: webshell
        # *   **Phishing**: phishing website
        # *   **APT**: advanced persistent threat (APT) attack
        # *   **Supply Chain Attack**: supply chain attack
        # *   **Malicious software**: malware
        self.tag_id_new = tag_id_new

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.is_aitraffic is not None:
            result['IsAITraffic'] = self.is_aitraffic
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.order is not None:
            result['Order'] = self.order
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.public_ip is not None:
            result['PublicIP'] = self.public_ip
        if self.sort is not None:
            result['Sort'] = self.sort
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.tag_id_new is not None:
            result['TagIdNew'] = self.tag_id_new
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IsAITraffic') is not None:
            self.is_aitraffic = m.get('IsAITraffic')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PublicIP') is not None:
            self.public_ip = m.get('PublicIP')
        if m.get('Sort') is not None:
            self.sort = m.get('Sort')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TagIdNew') is not None:
            self.tag_id_new = m.get('TagIdNew')
        return self


class DescribeOutgoingDomainResponseBodyDomainListTagList(TeaModel):
    def __init__(
        self,
        class_id: str = None,
        risk_level: int = None,
        tag_describe: str = None,
        tag_id: str = None,
        tag_name: str = None,
    ):
        # The type of the tag. Valid values:
        # 
        # *   **Suspicious**\
        # *   **Malicious**\
        # *   **Trusted**\
        self.class_id = class_id
        # The risk level. Valid values:
        # 
        # *   **1**: low
        # *   **2**: medium
        # *   **3**: high
        self.risk_level = risk_level
        # The description of the tag.
        self.tag_describe = tag_describe
        # The ID of the tag.
        self.tag_id = tag_id
        # The name of the tag.
        self.tag_name = tag_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_id is not None:
            result['ClassId'] = self.class_id
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.tag_describe is not None:
            result['TagDescribe'] = self.tag_describe
        if self.tag_id is not None:
            result['TagId'] = self.tag_id
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClassId') is not None:
            self.class_id = m.get('ClassId')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('TagDescribe') is not None:
            self.tag_describe = m.get('TagDescribe')
        if m.get('TagId') is not None:
            self.tag_id = m.get('TagId')
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        return self


class DescribeOutgoingDomainResponseBodyDomainList(TeaModel):
    def __init__(
        self,
        acl_coverage: str = None,
        acl_recommend_detail: str = None,
        acl_status: str = None,
        address_group_name: str = None,
        address_group_uuid: str = None,
        application_name_list: List[str] = None,
        asset_count: int = None,
        business: str = None,
        category_class_id: str = None,
        category_id: str = None,
        category_name: str = None,
        domain: str = None,
        group_name: str = None,
        has_acl: str = None,
        has_acl_recommend: bool = None,
        in_bytes: int = None,
        is_mark_normal: bool = None,
        organization: str = None,
        out_bytes: int = None,
        private_asset_count: int = None,
        rule_id: str = None,
        rule_name: str = None,
        security_reason: str = None,
        security_suggest: str = None,
        session_count: int = None,
        tag_list: List[DescribeOutgoingDomainResponseBodyDomainListTagList] = None,
        total_bytes: str = None,
    ):
        # Indicates whether an access control policy is configured. Valid values:
        # 
        # *   **Uncovered**: no
        # *   **FullCoverage**: yes
        self.acl_coverage = acl_coverage
        # The suggestion in an access control policy.
        self.acl_recommend_detail = acl_recommend_detail
        # The state of the access control policy. Valid values:
        # 
        # *   **normal**: healthy
        # *   **abnormal**: unhealthy
        self.acl_status = acl_status
        # The name of the address book.
        self.address_group_name = address_group_name
        # The UUID of the address book.
        self.address_group_uuid = address_group_uuid
        # The application names.
        self.application_name_list = application_name_list
        # The outbound asset count.
        self.asset_count = asset_count
        # The website service.
        self.business = business
        # The type of the tag. Valid values:
        # 
        # *   **Suspicious**\
        # *   **Malicious**\
        # *   **Trusted**\
        self.category_class_id = category_class_id
        # The type ID of the service to which the domain name belongs. Valid values:
        # 
        # *   **Aliyun**: Alibaba Cloud services
        # *   **NotAliyun**: third-party services
        self.category_id = category_id
        # The type of the service to which the domain name belongs. Valid values:
        # 
        # *   **Alibaba Cloud services**\
        # *   **Third-party services**\
        self.category_name = category_name
        # The domain name in outbound connections.
        self.domain = domain
        # The name of the group to which the access control policy belongs.
        self.group_name = group_name
        # Indicates whether an `access control policy` is configured for the domain name. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.has_acl = has_acl
        # Indicates whether an access control policy is recommended. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.has_acl_recommend = has_acl_recommend
        # The volume of inbound traffic.
        self.in_bytes = in_bytes
        # Indicates whether the domain name is marked as normal. Valid values:
        # 
        # *   **true**: normal
        # *   **false**: abnormal
        self.is_mark_normal = is_mark_normal
        # The name of the organization.
        self.organization = organization
        # The volume of outbound traffic.
        self.out_bytes = out_bytes
        # The outbound private asset count.
        self.private_asset_count = private_asset_count
        # The ID of the access control policy.
        self.rule_id = rule_id
        # The name of the access control policy.
        self.rule_name = rule_name
        # The reason why the domain name is secure.
        self.security_reason = security_reason
        # The suggestion to handle the traffic of the domain name in outbound connections. Valid values:
        # 
        # *   **pass**: allow
        # *   **alert**: monitor
        # *   **drop**: deny
        self.security_suggest = security_suggest
        # The number of requests.
        self.session_count = session_count
        # An array that consists of tags.
        self.tag_list = tag_list
        # The total volume of traffic. Unit: bytes.
        self.total_bytes = total_bytes

    def validate(self):
        if self.tag_list:
            for k in self.tag_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_coverage is not None:
            result['AclCoverage'] = self.acl_coverage
        if self.acl_recommend_detail is not None:
            result['AclRecommendDetail'] = self.acl_recommend_detail
        if self.acl_status is not None:
            result['AclStatus'] = self.acl_status
        if self.address_group_name is not None:
            result['AddressGroupName'] = self.address_group_name
        if self.address_group_uuid is not None:
            result['AddressGroupUUID'] = self.address_group_uuid
        if self.application_name_list is not None:
            result['ApplicationNameList'] = self.application_name_list
        if self.asset_count is not None:
            result['AssetCount'] = self.asset_count
        if self.business is not None:
            result['Business'] = self.business
        if self.category_class_id is not None:
            result['CategoryClassId'] = self.category_class_id
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.category_name is not None:
            result['CategoryName'] = self.category_name
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.has_acl is not None:
            result['HasAcl'] = self.has_acl
        if self.has_acl_recommend is not None:
            result['HasAclRecommend'] = self.has_acl_recommend
        if self.in_bytes is not None:
            result['InBytes'] = self.in_bytes
        if self.is_mark_normal is not None:
            result['IsMarkNormal'] = self.is_mark_normal
        if self.organization is not None:
            result['Organization'] = self.organization
        if self.out_bytes is not None:
            result['OutBytes'] = self.out_bytes
        if self.private_asset_count is not None:
            result['PrivateAssetCount'] = self.private_asset_count
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.security_reason is not None:
            result['SecurityReason'] = self.security_reason
        if self.security_suggest is not None:
            result['SecuritySuggest'] = self.security_suggest
        if self.session_count is not None:
            result['SessionCount'] = self.session_count
        result['TagList'] = []
        if self.tag_list is not None:
            for k in self.tag_list:
                result['TagList'].append(k.to_map() if k else None)
        if self.total_bytes is not None:
            result['TotalBytes'] = self.total_bytes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclCoverage') is not None:
            self.acl_coverage = m.get('AclCoverage')
        if m.get('AclRecommendDetail') is not None:
            self.acl_recommend_detail = m.get('AclRecommendDetail')
        if m.get('AclStatus') is not None:
            self.acl_status = m.get('AclStatus')
        if m.get('AddressGroupName') is not None:
            self.address_group_name = m.get('AddressGroupName')
        if m.get('AddressGroupUUID') is not None:
            self.address_group_uuid = m.get('AddressGroupUUID')
        if m.get('ApplicationNameList') is not None:
            self.application_name_list = m.get('ApplicationNameList')
        if m.get('AssetCount') is not None:
            self.asset_count = m.get('AssetCount')
        if m.get('Business') is not None:
            self.business = m.get('Business')
        if m.get('CategoryClassId') is not None:
            self.category_class_id = m.get('CategoryClassId')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('CategoryName') is not None:
            self.category_name = m.get('CategoryName')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('HasAcl') is not None:
            self.has_acl = m.get('HasAcl')
        if m.get('HasAclRecommend') is not None:
            self.has_acl_recommend = m.get('HasAclRecommend')
        if m.get('InBytes') is not None:
            self.in_bytes = m.get('InBytes')
        if m.get('IsMarkNormal') is not None:
            self.is_mark_normal = m.get('IsMarkNormal')
        if m.get('Organization') is not None:
            self.organization = m.get('Organization')
        if m.get('OutBytes') is not None:
            self.out_bytes = m.get('OutBytes')
        if m.get('PrivateAssetCount') is not None:
            self.private_asset_count = m.get('PrivateAssetCount')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SecurityReason') is not None:
            self.security_reason = m.get('SecurityReason')
        if m.get('SecuritySuggest') is not None:
            self.security_suggest = m.get('SecuritySuggest')
        if m.get('SessionCount') is not None:
            self.session_count = m.get('SessionCount')
        self.tag_list = []
        if m.get('TagList') is not None:
            for k in m.get('TagList'):
                temp_model = DescribeOutgoingDomainResponseBodyDomainListTagList()
                self.tag_list.append(temp_model.from_map(k))
        if m.get('TotalBytes') is not None:
            self.total_bytes = m.get('TotalBytes')
        return self


class DescribeOutgoingDomainResponseBody(TeaModel):
    def __init__(
        self,
        domain_list: List[DescribeOutgoingDomainResponseBodyDomainList] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The domain names in outbound connections.
        self.domain_list = domain_list
        # The ID of the request.
        self.request_id = request_id
        # The total number of the domain names in outbound connections.
        self.total_count = total_count

    def validate(self):
        if self.domain_list:
            for k in self.domain_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DomainList'] = []
        if self.domain_list is not None:
            for k in self.domain_list:
                result['DomainList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.domain_list = []
        if m.get('DomainList') is not None:
            for k in m.get('DomainList'):
                temp_model = DescribeOutgoingDomainResponseBodyDomainList()
                self.domain_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeOutgoingDomainResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeOutgoingDomainResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeOutgoingDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeOutgoingDomainDetailRequest(TeaModel):
    def __init__(
        self,
        acl_coverage: str = None,
        current_page: str = None,
        domain: str = None,
        domain_list: List[str] = None,
        end_time: str = None,
        iptype: str = None,
        lang: str = None,
        nat_gateway_id: str = None,
        order: str = None,
        page_size: str = None,
        private_ip: str = None,
        public_ip: str = None,
        sort: str = None,
        source_ip: str = None,
        start_time: str = None,
        tag_id: str = None,
    ):
        self.acl_coverage = acl_coverage
        self.current_page = current_page
        self.domain = domain
        self.domain_list = domain_list
        # This parameter is required.
        self.end_time = end_time
        self.iptype = iptype
        self.lang = lang
        self.nat_gateway_id = nat_gateway_id
        self.order = order
        self.page_size = page_size
        self.private_ip = private_ip
        self.public_ip = public_ip
        self.sort = sort
        self.source_ip = source_ip
        # This parameter is required.
        self.start_time = start_time
        self.tag_id = tag_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_coverage is not None:
            result['AclCoverage'] = self.acl_coverage
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.domain_list is not None:
            result['DomainList'] = self.domain_list
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.iptype is not None:
            result['IPType'] = self.iptype
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.order is not None:
            result['Order'] = self.order
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.private_ip is not None:
            result['PrivateIP'] = self.private_ip
        if self.public_ip is not None:
            result['PublicIP'] = self.public_ip
        if self.sort is not None:
            result['Sort'] = self.sort
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.tag_id is not None:
            result['TagId'] = self.tag_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclCoverage') is not None:
            self.acl_coverage = m.get('AclCoverage')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('DomainList') is not None:
            self.domain_list = m.get('DomainList')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('IPType') is not None:
            self.iptype = m.get('IPType')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PrivateIP') is not None:
            self.private_ip = m.get('PrivateIP')
        if m.get('PublicIP') is not None:
            self.public_ip = m.get('PublicIP')
        if m.get('Sort') is not None:
            self.sort = m.get('Sort')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TagId') is not None:
            self.tag_id = m.get('TagId')
        return self


class DescribeOutgoingDomainDetailResponseBodyAssetListTagList(TeaModel):
    def __init__(
        self,
        class_id: str = None,
        risk_level: int = None,
        tag_describe: str = None,
        tag_id: str = None,
        tag_name: str = None,
    ):
        self.class_id = class_id
        self.risk_level = risk_level
        self.tag_describe = tag_describe
        self.tag_id = tag_id
        self.tag_name = tag_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_id is not None:
            result['ClassId'] = self.class_id
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.tag_describe is not None:
            result['TagDescribe'] = self.tag_describe
        if self.tag_id is not None:
            result['TagId'] = self.tag_id
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClassId') is not None:
            self.class_id = m.get('ClassId')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('TagDescribe') is not None:
            self.tag_describe = m.get('TagDescribe')
        if m.get('TagId') is not None:
            self.tag_id = m.get('TagId')
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        return self


class DescribeOutgoingDomainDetailResponseBodyAssetList(TeaModel):
    def __init__(
        self,
        acl_coverage: str = None,
        domain: str = None,
        first_time: int = None,
        in_bytes: int = None,
        ips_hit_cnt: int = None,
        last_time: int = None,
        nat_gateway_id: str = None,
        nat_gateway_name: str = None,
        out_bytes: int = None,
        private_ip: str = None,
        public_ip: str = None,
        region_no: str = None,
        resource_instance_id: str = None,
        resource_instance_name: str = None,
        resource_type: str = None,
        rule_id: str = None,
        rule_name: str = None,
        session_count: int = None,
        tag_list: List[DescribeOutgoingDomainDetailResponseBodyAssetListTagList] = None,
        total_bytes: str = None,
        vpc_id: str = None,
    ):
        self.acl_coverage = acl_coverage
        self.domain = domain
        self.first_time = first_time
        self.in_bytes = in_bytes
        self.ips_hit_cnt = ips_hit_cnt
        self.last_time = last_time
        self.nat_gateway_id = nat_gateway_id
        self.nat_gateway_name = nat_gateway_name
        self.out_bytes = out_bytes
        self.private_ip = private_ip
        self.public_ip = public_ip
        self.region_no = region_no
        self.resource_instance_id = resource_instance_id
        self.resource_instance_name = resource_instance_name
        self.resource_type = resource_type
        self.rule_id = rule_id
        self.rule_name = rule_name
        self.session_count = session_count
        self.tag_list = tag_list
        self.total_bytes = total_bytes
        self.vpc_id = vpc_id

    def validate(self):
        if self.tag_list:
            for k in self.tag_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_coverage is not None:
            result['AclCoverage'] = self.acl_coverage
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.first_time is not None:
            result['FirstTime'] = self.first_time
        if self.in_bytes is not None:
            result['InBytes'] = self.in_bytes
        if self.ips_hit_cnt is not None:
            result['IpsHitCnt'] = self.ips_hit_cnt
        if self.last_time is not None:
            result['LastTime'] = self.last_time
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.nat_gateway_name is not None:
            result['NatGatewayName'] = self.nat_gateway_name
        if self.out_bytes is not None:
            result['OutBytes'] = self.out_bytes
        if self.private_ip is not None:
            result['PrivateIP'] = self.private_ip
        if self.public_ip is not None:
            result['PublicIP'] = self.public_ip
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.resource_instance_id is not None:
            result['ResourceInstanceId'] = self.resource_instance_id
        if self.resource_instance_name is not None:
            result['ResourceInstanceName'] = self.resource_instance_name
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.session_count is not None:
            result['SessionCount'] = self.session_count
        result['TagList'] = []
        if self.tag_list is not None:
            for k in self.tag_list:
                result['TagList'].append(k.to_map() if k else None)
        if self.total_bytes is not None:
            result['TotalBytes'] = self.total_bytes
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AclCoverage') is not None:
            self.acl_coverage = m.get('AclCoverage')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('FirstTime') is not None:
            self.first_time = m.get('FirstTime')
        if m.get('InBytes') is not None:
            self.in_bytes = m.get('InBytes')
        if m.get('IpsHitCnt') is not None:
            self.ips_hit_cnt = m.get('IpsHitCnt')
        if m.get('LastTime') is not None:
            self.last_time = m.get('LastTime')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('NatGatewayName') is not None:
            self.nat_gateway_name = m.get('NatGatewayName')
        if m.get('OutBytes') is not None:
            self.out_bytes = m.get('OutBytes')
        if m.get('PrivateIP') is not None:
            self.private_ip = m.get('PrivateIP')
        if m.get('PublicIP') is not None:
            self.public_ip = m.get('PublicIP')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('ResourceInstanceId') is not None:
            self.resource_instance_id = m.get('ResourceInstanceId')
        if m.get('ResourceInstanceName') is not None:
            self.resource_instance_name = m.get('ResourceInstanceName')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('SessionCount') is not None:
            self.session_count = m.get('SessionCount')
        self.tag_list = []
        if m.get('TagList') is not None:
            for k in m.get('TagList'):
                temp_model = DescribeOutgoingDomainDetailResponseBodyAssetListTagList()
                self.tag_list.append(temp_model.from_map(k))
        if m.get('TotalBytes') is not None:
            self.total_bytes = m.get('TotalBytes')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DescribeOutgoingDomainDetailResponseBody(TeaModel):
    def __init__(
        self,
        application_name_list: List[str] = None,
        asset_list: List[DescribeOutgoingDomainDetailResponseBodyAssetList] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.application_name_list = application_name_list
        self.asset_list = asset_list
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.asset_list:
            for k in self.asset_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name_list is not None:
            result['ApplicationNameList'] = self.application_name_list
        result['AssetList'] = []
        if self.asset_list is not None:
            for k in self.asset_list:
                result['AssetList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationNameList') is not None:
            self.application_name_list = m.get('ApplicationNameList')
        self.asset_list = []
        if m.get('AssetList') is not None:
            for k in m.get('AssetList'):
                temp_model = DescribeOutgoingDomainDetailResponseBodyAssetList()
                self.asset_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeOutgoingDomainDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeOutgoingDomainDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeOutgoingDomainDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeOutgoingStatisticRequest(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        lang: str = None,
        source_ip: str = None,
        start_time: str = None,
    ):
        # This parameter is required.
        self.end_time = end_time
        self.lang = lang
        self.source_ip = source_ip
        # This parameter is required.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeOutgoingStatisticResponseBody(TeaModel):
    def __init__(
        self,
        ignore_asset_count: int = None,
        ignore_domain_count: int = None,
        ignore_dst_ipcount: int = None,
        private_risk_asset_count: int = None,
        private_total_asset_count: int = None,
        request_id: str = None,
        risk_asset_count: int = None,
        risk_domain_count: int = None,
        risk_dst_ipcount: int = None,
        subscribe_asset_count: int = None,
        subscribe_domain_count: int = None,
        subscribe_dst_ipcount: int = None,
        total_asset_count: int = None,
        total_domain_count: int = None,
        total_dst_ipcount: int = None,
        total_protocol_count: int = None,
        uncovered_acl_domain: int = None,
        uncovered_acl_dst_ip: int = None,
        unknown_protocol_radio: str = None,
    ):
        self.ignore_asset_count = ignore_asset_count
        self.ignore_domain_count = ignore_domain_count
        self.ignore_dst_ipcount = ignore_dst_ipcount
        self.private_risk_asset_count = private_risk_asset_count
        self.private_total_asset_count = private_total_asset_count
        self.request_id = request_id
        self.risk_asset_count = risk_asset_count
        self.risk_domain_count = risk_domain_count
        self.risk_dst_ipcount = risk_dst_ipcount
        self.subscribe_asset_count = subscribe_asset_count
        self.subscribe_domain_count = subscribe_domain_count
        self.subscribe_dst_ipcount = subscribe_dst_ipcount
        self.total_asset_count = total_asset_count
        self.total_domain_count = total_domain_count
        self.total_dst_ipcount = total_dst_ipcount
        self.total_protocol_count = total_protocol_count
        self.uncovered_acl_domain = uncovered_acl_domain
        self.uncovered_acl_dst_ip = uncovered_acl_dst_ip
        self.unknown_protocol_radio = unknown_protocol_radio

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ignore_asset_count is not None:
            result['IgnoreAssetCount'] = self.ignore_asset_count
        if self.ignore_domain_count is not None:
            result['IgnoreDomainCount'] = self.ignore_domain_count
        if self.ignore_dst_ipcount is not None:
            result['IgnoreDstIPCount'] = self.ignore_dst_ipcount
        if self.private_risk_asset_count is not None:
            result['PrivateRiskAssetCount'] = self.private_risk_asset_count
        if self.private_total_asset_count is not None:
            result['PrivateTotalAssetCount'] = self.private_total_asset_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.risk_asset_count is not None:
            result['RiskAssetCount'] = self.risk_asset_count
        if self.risk_domain_count is not None:
            result['RiskDomainCount'] = self.risk_domain_count
        if self.risk_dst_ipcount is not None:
            result['RiskDstIPCount'] = self.risk_dst_ipcount
        if self.subscribe_asset_count is not None:
            result['SubscribeAssetCount'] = self.subscribe_asset_count
        if self.subscribe_domain_count is not None:
            result['SubscribeDomainCount'] = self.subscribe_domain_count
        if self.subscribe_dst_ipcount is not None:
            result['SubscribeDstIPCount'] = self.subscribe_dst_ipcount
        if self.total_asset_count is not None:
            result['TotalAssetCount'] = self.total_asset_count
        if self.total_domain_count is not None:
            result['TotalDomainCount'] = self.total_domain_count
        if self.total_dst_ipcount is not None:
            result['TotalDstIPCount'] = self.total_dst_ipcount
        if self.total_protocol_count is not None:
            result['TotalProtocolCount'] = self.total_protocol_count
        if self.uncovered_acl_domain is not None:
            result['UncoveredAclDomain'] = self.uncovered_acl_domain
        if self.uncovered_acl_dst_ip is not None:
            result['UncoveredAclDstIP'] = self.uncovered_acl_dst_ip
        if self.unknown_protocol_radio is not None:
            result['UnknownProtocolRadio'] = self.unknown_protocol_radio
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IgnoreAssetCount') is not None:
            self.ignore_asset_count = m.get('IgnoreAssetCount')
        if m.get('IgnoreDomainCount') is not None:
            self.ignore_domain_count = m.get('IgnoreDomainCount')
        if m.get('IgnoreDstIPCount') is not None:
            self.ignore_dst_ipcount = m.get('IgnoreDstIPCount')
        if m.get('PrivateRiskAssetCount') is not None:
            self.private_risk_asset_count = m.get('PrivateRiskAssetCount')
        if m.get('PrivateTotalAssetCount') is not None:
            self.private_total_asset_count = m.get('PrivateTotalAssetCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RiskAssetCount') is not None:
            self.risk_asset_count = m.get('RiskAssetCount')
        if m.get('RiskDomainCount') is not None:
            self.risk_domain_count = m.get('RiskDomainCount')
        if m.get('RiskDstIPCount') is not None:
            self.risk_dst_ipcount = m.get('RiskDstIPCount')
        if m.get('SubscribeAssetCount') is not None:
            self.subscribe_asset_count = m.get('SubscribeAssetCount')
        if m.get('SubscribeDomainCount') is not None:
            self.subscribe_domain_count = m.get('SubscribeDomainCount')
        if m.get('SubscribeDstIPCount') is not None:
            self.subscribe_dst_ipcount = m.get('SubscribeDstIPCount')
        if m.get('TotalAssetCount') is not None:
            self.total_asset_count = m.get('TotalAssetCount')
        if m.get('TotalDomainCount') is not None:
            self.total_domain_count = m.get('TotalDomainCount')
        if m.get('TotalDstIPCount') is not None:
            self.total_dst_ipcount = m.get('TotalDstIPCount')
        if m.get('TotalProtocolCount') is not None:
            self.total_protocol_count = m.get('TotalProtocolCount')
        if m.get('UncoveredAclDomain') is not None:
            self.uncovered_acl_domain = m.get('UncoveredAclDomain')
        if m.get('UncoveredAclDstIP') is not None:
            self.uncovered_acl_dst_ip = m.get('UncoveredAclDstIP')
        if m.get('UnknownProtocolRadio') is not None:
            self.unknown_protocol_radio = m.get('UnknownProtocolRadio')
        return self


class DescribeOutgoingStatisticResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeOutgoingStatisticResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeOutgoingStatisticResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeOutgoingTagRequest(TeaModel):
    def __init__(
        self,
        dst_type: str = None,
        end_time: str = None,
        lang: str = None,
        source_ip: str = None,
        start_time: str = None,
        tag_id: str = None,
    ):
        self.dst_type = dst_type
        # This parameter is required.
        self.end_time = end_time
        self.lang = lang
        self.source_ip = source_ip
        # This parameter is required.
        self.start_time = start_time
        self.tag_id = tag_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dst_type is not None:
            result['DstType'] = self.dst_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.tag_id is not None:
            result['TagId'] = self.tag_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DstType') is not None:
            self.dst_type = m.get('DstType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TagId') is not None:
            self.tag_id = m.get('TagId')
        return self


class DescribeOutgoingTagResponseBodyTagList(TeaModel):
    def __init__(
        self,
        class_id: str = None,
        risk_level: int = None,
        tag_describe: str = None,
        tag_id: str = None,
        tag_name: str = None,
    ):
        self.class_id = class_id
        self.risk_level = risk_level
        self.tag_describe = tag_describe
        self.tag_id = tag_id
        self.tag_name = tag_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.class_id is not None:
            result['ClassId'] = self.class_id
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.tag_describe is not None:
            result['TagDescribe'] = self.tag_describe
        if self.tag_id is not None:
            result['TagId'] = self.tag_id
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClassId') is not None:
            self.class_id = m.get('ClassId')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('TagDescribe') is not None:
            self.tag_describe = m.get('TagDescribe')
        if m.get('TagId') is not None:
            self.tag_id = m.get('TagId')
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        return self


class DescribeOutgoingTagResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        tag_list: List[DescribeOutgoingTagResponseBodyTagList] = None,
        total_count: int = None,
    ):
        self.request_id = request_id
        self.tag_list = tag_list
        self.total_count = total_count

    def validate(self):
        if self.tag_list:
            for k in self.tag_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['TagList'] = []
        if self.tag_list is not None:
            for k in self.tag_list:
                result['TagList'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.tag_list = []
        if m.get('TagList') is not None:
            for k in m.get('TagList'):
                temp_model = DescribeOutgoingTagResponseBodyTagList()
                self.tag_list.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeOutgoingTagResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeOutgoingTagResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeOutgoingTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePageDocumentsRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        page_name: str = None,
        source_code: str = None,
        source_ip: str = None,
        tab_name: str = None,
    ):
        self.lang = lang
        # This parameter is required.
        self.page_name = page_name
        # This parameter is required.
        self.source_code = source_code
        self.source_ip = source_ip
        # This parameter is required.
        self.tab_name = tab_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_name is not None:
            result['PageName'] = self.page_name
        if self.source_code is not None:
            result['SourceCode'] = self.source_code
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.tab_name is not None:
            result['TabName'] = self.tab_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageName') is not None:
            self.page_name = m.get('PageName')
        if m.get('SourceCode') is not None:
            self.source_code = m.get('SourceCode')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('TabName') is not None:
            self.tab_name = m.get('TabName')
        return self


class DescribePageDocumentsResponseBodyDocs(TeaModel):
    def __init__(
        self,
        title: str = None,
        url: str = None,
    ):
        self.title = title
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.title is not None:
            result['Title'] = self.title
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class DescribePageDocumentsResponseBodyMore(TeaModel):
    def __init__(
        self,
        title: str = None,
        url: str = None,
    ):
        self.title = title
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.title is not None:
            result['Title'] = self.title
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class DescribePageDocumentsResponseBody(TeaModel):
    def __init__(
        self,
        docs: List[DescribePageDocumentsResponseBodyDocs] = None,
        image_url: str = None,
        module: str = None,
        more: DescribePageDocumentsResponseBodyMore = None,
        request_id: str = None,
    ):
        self.docs = docs
        self.image_url = image_url
        self.module = module
        self.more = more
        self.request_id = request_id

    def validate(self):
        if self.docs:
            for k in self.docs:
                if k:
                    k.validate()
        if self.more:
            self.more.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Docs'] = []
        if self.docs is not None:
            for k in self.docs:
                result['Docs'].append(k.to_map() if k else None)
        if self.image_url is not None:
            result['ImageUrl'] = self.image_url
        if self.module is not None:
            result['Module'] = self.module
        if self.more is not None:
            result['More'] = self.more.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.docs = []
        if m.get('Docs') is not None:
            for k in m.get('Docs'):
                temp_model = DescribePageDocumentsResponseBodyDocs()
                self.docs.append(temp_model.from_map(k))
        if m.get('ImageUrl') is not None:
            self.image_url = m.get('ImageUrl')
        if m.get('Module') is not None:
            self.module = m.get('Module')
        if m.get('More') is not None:
            temp_model = DescribePageDocumentsResponseBodyMore()
            self.more = temp_model.from_map(m['More'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePageDocumentsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePageDocumentsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePageDocumentsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePolicyAdvancedConfigRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        source_ip: str = None,
    ):
        # The natural language of the request and response. Valid values:
        # 
        # *   **zh**: Chinese (default)
        # *   **en**: English
        self.lang = lang
        # The source IP address of the request.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribePolicyAdvancedConfigResponseBody(TeaModel):
    def __init__(
        self,
        internet_switch: str = None,
        request_id: str = None,
    ):
        # Indicates whether the strict mode is enabled for the access control policy. Valid values:
        # 
        # *   **on**: The strict mode is enabled.
        # *   **off**: The strict mode is disabled.
        self.internet_switch = internet_switch
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.internet_switch is not None:
            result['InternetSwitch'] = self.internet_switch
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InternetSwitch') is not None:
            self.internet_switch = m.get('InternetSwitch')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePolicyAdvancedConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePolicyAdvancedConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePolicyAdvancedConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePolicyPriorUsedRequest(TeaModel):
    def __init__(
        self,
        direction: str = None,
        ip_version: str = None,
        lang: str = None,
        source_ip: str = None,
    ):
        # The direction of the traffic to which the access control policy applies.
        # 
        # Valid values:
        # 
        # *   **in**: inbound.
        # *   **out**: outbound.
        # 
        # This parameter is required.
        self.direction = direction
        # The IP version of the asset that is protected by Cloud Firewall.
        # 
        # Valid values:
        # 
        # *   **4** (default): IPv4.
        # *   **6**: IPv6.
        self.ip_version = ip_version
        # The language of the content within the request and response.
        # 
        # Valid values:
        # 
        # *   **zh** (default)
        # *   **en**\
        self.lang = lang
        # The source IP address of the request.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.ip_version is not None:
            result['IpVersion'] = self.ip_version
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('IpVersion') is not None:
            self.ip_version = m.get('IpVersion')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribePolicyPriorUsedResponseBody(TeaModel):
    def __init__(
        self,
        end: int = None,
        request_id: str = None,
        start: int = None,
    ):
        # The lowest priority of existing access control policies.
        # 
        # >  The value -1 indicates the lowest priority.
        self.end = end
        # The request ID.
        self.request_id = request_id
        # The highest priority of existing access control policies.
        # 
        # >  The value 0 indicates the highest priority.
        self.start = start

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end is not None:
            result['End'] = self.end
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.start is not None:
            result['Start'] = self.start
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Start') is not None:
            self.start = m.get('Start')
        return self


class DescribePolicyPriorUsedResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePolicyPriorUsedResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePolicyPriorUsedResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePostpayTrafficDetailRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        end_time: str = None,
        lang: str = None,
        order: str = None,
        page_size: int = None,
        region_no: str = None,
        search_item: str = None,
        start_time: str = None,
        traffic_type: str = None,
    ):
        # The page number. Default value: 1.
        self.current_page = current_page
        # The end of the time range to query. Specify a value in the YYYYMMDD format.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The language of the content within the request and response. Valid values:
        # 
        # *   **zh** (default): Chinese
        # *   **en**: English
        self.lang = lang
        # The field based on which you want to sort the query results. Valid values:
        # 
        # *   **resourceId**\
        # *   **trafficDay**\
        self.order = order
        # The number of entries per page. Default value: 10. Maximum value: 50.
        self.page_size = page_size
        # The region ID.
        self.region_no = region_no
        # The instance ID or the IP address of the asset.
        self.search_item = search_item
        # The beginning of the time range to query. Specify a value in the YYYYMMDD format.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The traffic type. This parameter is required. Valid values:
        # 
        # *   **EIP_TRAFFIC**: traffic for the Internet firewall.
        # *   **NatGateway_TRAFFIC**: traffic for NAT firewalls.
        # *   **VPC_TRAFFIC**: traffic for virtual private cloud (VPC) firewalls.
        # 
        # This parameter is required.
        self.traffic_type = traffic_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.order is not None:
            result['Order'] = self.order
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.search_item is not None:
            result['SearchItem'] = self.search_item
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.traffic_type is not None:
            result['TrafficType'] = self.traffic_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('SearchItem') is not None:
            self.search_item = m.get('SearchItem')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TrafficType') is not None:
            self.traffic_type = m.get('TrafficType')
        return self


class DescribePostpayTrafficDetailResponseBodyTrafficList(TeaModel):
    def __init__(
        self,
        in_bytes: int = None,
        instance_id: str = None,
        instance_type: str = None,
        out_bytes: int = None,
        protection_duration: int = None,
        region_no: str = None,
        resource_id: str = None,
        total_bytes: int = None,
        traffic_day: str = None,
        traffic_type: str = None,
    ):
        # The inbound network throughput, which indicates the total number of bytes that are received Unit: bytes.
        self.in_bytes = in_bytes
        # The instance ID of the asset.
        self.instance_id = instance_id
        # The asset type. This value takes effect only for the Internet firewall.
        self.instance_type = instance_type
        # The outbound network throughput, which indicates the total number of bytes that are sent. Unit: bytes.
        self.out_bytes = out_bytes
        # Protection duration. Unit: hours.
        self.protection_duration = protection_duration
        # The region ID.
        self.region_no = region_no
        # The resource ID. The resource ID for the Internet firewall is the public IP address that is protected the Internet firewall, and the resource ID for a NAT firewall is the instance ID of the NAT firewall.
        self.resource_id = resource_id
        # The total inbound and outbound network throughput, which indicates the total number of bytes that are received and sent. Unit: bytes.
        self.total_bytes = total_bytes
        # The date on which the statistics are collected.
        self.traffic_day = traffic_day
        # The traffic type. Valid values:
        # 
        # *   **EIP_TRAFFIC**: traffic for the Internet firewall
        # *   **NatGateway_TRAFFIC**: traffic for NAT firewalls
        # *   **VPC_TRAFFIC**: traffic for VPC firewalls
        self.traffic_type = traffic_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.in_bytes is not None:
            result['InBytes'] = self.in_bytes
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.out_bytes is not None:
            result['OutBytes'] = self.out_bytes
        if self.protection_duration is not None:
            result['ProtectionDuration'] = self.protection_duration
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.total_bytes is not None:
            result['TotalBytes'] = self.total_bytes
        if self.traffic_day is not None:
            result['TrafficDay'] = self.traffic_day
        if self.traffic_type is not None:
            result['TrafficType'] = self.traffic_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InBytes') is not None:
            self.in_bytes = m.get('InBytes')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('OutBytes') is not None:
            self.out_bytes = m.get('OutBytes')
        if m.get('ProtectionDuration') is not None:
            self.protection_duration = m.get('ProtectionDuration')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('TotalBytes') is not None:
            self.total_bytes = m.get('TotalBytes')
        if m.get('TrafficDay') is not None:
            self.traffic_day = m.get('TrafficDay')
        if m.get('TrafficType') is not None:
            self.traffic_type = m.get('TrafficType')
        return self


class DescribePostpayTrafficDetailResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        total_count: int = None,
        traffic_list: List[DescribePostpayTrafficDetailResponseBodyTrafficList] = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count
        # The statistics on traffic.
        self.traffic_list = traffic_list

    def validate(self):
        if self.traffic_list:
            for k in self.traffic_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['TrafficList'] = []
        if self.traffic_list is not None:
            for k in self.traffic_list:
                result['TrafficList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.traffic_list = []
        if m.get('TrafficList') is not None:
            for k in m.get('TrafficList'):
                temp_model = DescribePostpayTrafficDetailResponseBodyTrafficList()
                self.traffic_list.append(temp_model.from_map(k))
        return self


class DescribePostpayTrafficDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePostpayTrafficDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePostpayTrafficDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePostpayTrafficTotalRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        # The language of the content within the response. Valid values:
        # 
        # *   **zh** (default): Chinese
        # *   **en**: English
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribePostpayTrafficTotalResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        total_assets: int = None,
        total_bill_traffic: int = None,
        total_internet_assets: int = None,
        total_internet_traffic: int = None,
        total_nat_assets: int = None,
        total_nat_traffic: int = None,
        total_sdl_bill_traffic: int = None,
        total_sdl_free_traffic: int = None,
        total_traffic: int = None,
        total_vpc_assets: int = None,
        total_vpc_traffic: int = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The total number of assets protected all types of firewalls.
        self.total_assets = total_assets
        # The volume of burstable protected traffic for which fees are generated. Unit: bytes.
        self.total_bill_traffic = total_bill_traffic
        # The total number of assets protected by the Internet firewall.
        self.total_internet_assets = total_internet_assets
        # The total traffic for the Internet firewall. If you use Cloud Firewall that uses the subscription billing method, this parameter indicates the total volume of burstable protected traffic on the Internet boundary. Unit: bytes.
        self.total_internet_traffic = total_internet_traffic
        # The total number of assets protected by NAT firewalls.
        self.total_nat_assets = total_nat_assets
        # The total traffic for NAT firewalls. If you use Cloud Firewall that uses the subscription billing method, this parameter indicates the total volume of burstable protected traffic on the NAT boundary. Unit: bytes.
        self.total_nat_traffic = total_nat_traffic
        # Data Leak Detection Total Fee Flow.
        self.total_sdl_bill_traffic = total_sdl_bill_traffic
        # Data Leak Detection Total free usage traffic.
        self.total_sdl_free_traffic = total_sdl_free_traffic
        # The total volume of traffic. If you use Cloud Firewall that uses the subscription billing method, this parameter indicates the total volume of burstable protected traffic. Unit: bytes.
        self.total_traffic = total_traffic
        # The total number of assets protected by virtual private cloud (VPC) firewalls.
        self.total_vpc_assets = total_vpc_assets
        # The total traffic for VPC firewalls. If you use Cloud Firewall that uses the subscription billing method, this parameter indicates the total volume of burstable protected traffic on the VPC boundary. Unit: bytes.
        self.total_vpc_traffic = total_vpc_traffic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_assets is not None:
            result['TotalAssets'] = self.total_assets
        if self.total_bill_traffic is not None:
            result['TotalBillTraffic'] = self.total_bill_traffic
        if self.total_internet_assets is not None:
            result['TotalInternetAssets'] = self.total_internet_assets
        if self.total_internet_traffic is not None:
            result['TotalInternetTraffic'] = self.total_internet_traffic
        if self.total_nat_assets is not None:
            result['TotalNatAssets'] = self.total_nat_assets
        if self.total_nat_traffic is not None:
            result['TotalNatTraffic'] = self.total_nat_traffic
        if self.total_sdl_bill_traffic is not None:
            result['TotalSdlBillTraffic'] = self.total_sdl_bill_traffic
        if self.total_sdl_free_traffic is not None:
            result['TotalSdlFreeTraffic'] = self.total_sdl_free_traffic
        if self.total_traffic is not None:
            result['TotalTraffic'] = self.total_traffic
        if self.total_vpc_assets is not None:
            result['TotalVpcAssets'] = self.total_vpc_assets
        if self.total_vpc_traffic is not None:
            result['TotalVpcTraffic'] = self.total_vpc_traffic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalAssets') is not None:
            self.total_assets = m.get('TotalAssets')
        if m.get('TotalBillTraffic') is not None:
            self.total_bill_traffic = m.get('TotalBillTraffic')
        if m.get('TotalInternetAssets') is not None:
            self.total_internet_assets = m.get('TotalInternetAssets')
        if m.get('TotalInternetTraffic') is not None:
            self.total_internet_traffic = m.get('TotalInternetTraffic')
        if m.get('TotalNatAssets') is not None:
            self.total_nat_assets = m.get('TotalNatAssets')
        if m.get('TotalNatTraffic') is not None:
            self.total_nat_traffic = m.get('TotalNatTraffic')
        if m.get('TotalSdlBillTraffic') is not None:
            self.total_sdl_bill_traffic = m.get('TotalSdlBillTraffic')
        if m.get('TotalSdlFreeTraffic') is not None:
            self.total_sdl_free_traffic = m.get('TotalSdlFreeTraffic')
        if m.get('TotalTraffic') is not None:
            self.total_traffic = m.get('TotalTraffic')
        if m.get('TotalVpcAssets') is not None:
            self.total_vpc_assets = m.get('TotalVpcAssets')
        if m.get('TotalVpcTraffic') is not None:
            self.total_vpc_traffic = m.get('TotalVpcTraffic')
        return self


class DescribePostpayTrafficTotalResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePostpayTrafficTotalResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePostpayTrafficTotalResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePostpayUserInternetStatusRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        lang: str = None,
    ):
        # The instance ID of Cloud Firewall.
        self.instance_id = instance_id
        # The language of the content within the response. Valid values:
        # 
        # *   **zh** (default)
        # *   **en**\
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribePostpayUserInternetStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        status: str = None,
        unprotected_date: int = None,
    ):
        # Id of the request
        self.request_id = request_id
        # The status of the Internet Firewall feature. Valid values:
        # 
        # *   **open**: enabled
        # *   **init**: being enabled
        # *   **closed**: disabled
        self.status = status
        # The number of days during which no asset is added to the Internet Firewall feature for protection. This parameter is valid only when the value of Status is open.
        self.unprotected_date = unprotected_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        if self.unprotected_date is not None:
            result['UnprotectedDate'] = self.unprotected_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UnprotectedDate') is not None:
            self.unprotected_date = m.get('UnprotectedDate')
        return self


class DescribePostpayUserInternetStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePostpayUserInternetStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePostpayUserInternetStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePostpayUserNatStatusRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        lang: str = None,
    ):
        # The instance ID of Cloud Firewall.
        self.instance_id = instance_id
        # The language of the content within the response. Valid values:
        # 
        # *   **zh** (default)
        # *   **en**\
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribePostpayUserNatStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        status: str = None,
        unprotected_date: int = None,
    ):
        # Id of the request
        self.request_id = request_id
        # The status of the NAT Firewall feature. Valid values:
        # 
        # *   **open**: enabled
        # *   **init**: being enabled
        # *   **closed**: disabled
        self.status = status
        # The number of days during which no asset is added to the NAT Firewall feature for protection. This parameter is valid only when the value of Status is open.
        self.unprotected_date = unprotected_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        if self.unprotected_date is not None:
            result['UnprotectedDate'] = self.unprotected_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UnprotectedDate') is not None:
            self.unprotected_date = m.get('UnprotectedDate')
        return self


class DescribePostpayUserNatStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePostpayUserNatStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePostpayUserNatStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePostpayUserVpcStatusRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        lang: str = None,
    ):
        # The instance ID of Cloud Firewall.
        self.instance_id = instance_id
        # The language of the content within the response. Valid values:
        # 
        # *   **zh** (default)
        # *   **en**\
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribePostpayUserVpcStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        status: str = None,
        unprotected_date: int = None,
    ):
        # Id of the request
        self.request_id = request_id
        # The status of the VPC Firewall feature. Valid values:
        # 
        # *   **open**: enabled
        # *   **init**: being enabled
        # *   **closed**: disabled
        self.status = status
        # The number of days during which no asset is added to the VPC Firewall feature for protection. This parameter is valid only when the value of Status is open.
        self.unprotected_date = unprotected_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        if self.unprotected_date is not None:
            result['UnprotectedDate'] = self.unprotected_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UnprotectedDate') is not None:
            self.unprotected_date = m.get('UnprotectedDate')
        return self


class DescribePostpayUserVpcStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePostpayUserVpcStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePostpayUserVpcStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePrefixListsRequest(TeaModel):
    def __init__(
        self,
        region_no: str = None,
        source_ip: str = None,
    ):
        # The region ID of the instance.
        # 
        # This parameter is required.
        self.region_no = region_no
        # The source IP address of the request.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribePrefixListsResponseBodyPrefixList(TeaModel):
    def __init__(
        self,
        address_family: str = None,
        association_count: int = None,
        creation_time: str = None,
        description: str = None,
        max_entries: int = None,
        prefix_list_id: str = None,
        prefix_list_name: str = None,
    ):
        # The IP address family of the prefix list. Valid values:
        # 
        # *   IPv4
        # *   IPv6
        self.address_family = address_family
        # The number of associated resources.
        self.association_count = association_count
        # The creation time.
        self.creation_time = creation_time
        # The description.
        self.description = description
        # The maximum number of entries in the prefix list.
        self.max_entries = max_entries
        # The ID of the prefix list.
        self.prefix_list_id = prefix_list_id
        # The name of the prefix list.
        self.prefix_list_name = prefix_list_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address_family is not None:
            result['AddressFamily'] = self.address_family
        if self.association_count is not None:
            result['AssociationCount'] = self.association_count
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.max_entries is not None:
            result['MaxEntries'] = self.max_entries
        if self.prefix_list_id is not None:
            result['PrefixListId'] = self.prefix_list_id
        if self.prefix_list_name is not None:
            result['PrefixListName'] = self.prefix_list_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddressFamily') is not None:
            self.address_family = m.get('AddressFamily')
        if m.get('AssociationCount') is not None:
            self.association_count = m.get('AssociationCount')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('MaxEntries') is not None:
            self.max_entries = m.get('MaxEntries')
        if m.get('PrefixListId') is not None:
            self.prefix_list_id = m.get('PrefixListId')
        if m.get('PrefixListName') is not None:
            self.prefix_list_name = m.get('PrefixListName')
        return self


class DescribePrefixListsResponseBody(TeaModel):
    def __init__(
        self,
        prefix_list: List[DescribePrefixListsResponseBodyPrefixList] = None,
        request_id: str = None,
    ):
        # Details about the prefix lists.
        self.prefix_list = prefix_list
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.prefix_list:
            for k in self.prefix_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PrefixList'] = []
        if self.prefix_list is not None:
            for k in self.prefix_list:
                result['PrefixList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.prefix_list = []
        if m.get('PrefixList') is not None:
            for k in m.get('PrefixList'):
                temp_model = DescribePrefixListsResponseBodyPrefixList()
                self.prefix_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePrefixListsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePrefixListsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePrefixListsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePrivateDnsDomainNameListRequest(TeaModel):
    def __init__(
        self,
        access_instance_id: str = None,
        domain_name: str = None,
        page_no: int = None,
        page_size: int = None,
        region_no: str = None,
    ):
        # This parameter is required.
        self.access_instance_id = access_instance_id
        self.domain_name = domain_name
        self.page_no = page_no
        self.page_size = page_size
        # This parameter is required.
        self.region_no = region_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_instance_id is not None:
            result['AccessInstanceId'] = self.access_instance_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessInstanceId') is not None:
            self.access_instance_id = m.get('AccessInstanceId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        return self


class DescribePrivateDnsDomainNameListResponseBody(TeaModel):
    def __init__(
        self,
        domain_name_list: List[str] = None,
        page_no: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.domain_name_list = domain_name_list
        self.page_no = page_no
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name_list is not None:
            result['DomainNameList'] = self.domain_name_list
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainNameList') is not None:
            self.domain_name_list = m.get('DomainNameList')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePrivateDnsDomainNameListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePrivateDnsDomainNameListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePrivateDnsDomainNameListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePrivateDnsEndpointDetailRequest(TeaModel):
    def __init__(
        self,
        access_instance_id: str = None,
        region_no: str = None,
    ):
        # This parameter is required.
        self.access_instance_id = access_instance_id
        # This parameter is required.
        self.region_no = region_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_instance_id is not None:
            result['AccessInstanceId'] = self.access_instance_id
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessInstanceId') is not None:
            self.access_instance_id = m.get('AccessInstanceId')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        return self


class DescribePrivateDnsEndpointDetailResponseBody(TeaModel):
    def __init__(
        self,
        access_instance_id: str = None,
        access_instance_name: str = None,
        ali_uid: int = None,
        endpoint_id: str = None,
        firewall_type: List[str] = None,
        gmt_create: int = None,
        ip_protocol: str = None,
        member_uid: int = None,
        port: int = None,
        primary_dns: str = None,
        primary_vswitch_id: str = None,
        primary_vswitch_ip: str = None,
        primary_zone_id: str = None,
        private_dns_type: str = None,
        region_no: str = None,
        request_id: str = None,
        standby_dns: str = None,
        standby_vswitch_id: str = None,
        standby_vswitch_ip: str = None,
        standby_zone_id: str = None,
        status: str = None,
        task_id: str = None,
        vpc_id: str = None,
    ):
        self.access_instance_id = access_instance_id
        self.access_instance_name = access_instance_name
        self.ali_uid = ali_uid
        self.endpoint_id = endpoint_id
        self.firewall_type = firewall_type
        self.gmt_create = gmt_create
        self.ip_protocol = ip_protocol
        self.member_uid = member_uid
        self.port = port
        self.primary_dns = primary_dns
        self.primary_vswitch_id = primary_vswitch_id
        self.primary_vswitch_ip = primary_vswitch_ip
        self.primary_zone_id = primary_zone_id
        self.private_dns_type = private_dns_type
        self.region_no = region_no
        self.request_id = request_id
        self.standby_dns = standby_dns
        self.standby_vswitch_id = standby_vswitch_id
        self.standby_vswitch_ip = standby_vswitch_ip
        self.standby_zone_id = standby_zone_id
        self.status = status
        self.task_id = task_id
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_instance_id is not None:
            result['AccessInstanceId'] = self.access_instance_id
        if self.access_instance_name is not None:
            result['AccessInstanceName'] = self.access_instance_name
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.endpoint_id is not None:
            result['EndpointId'] = self.endpoint_id
        if self.firewall_type is not None:
            result['FirewallType'] = self.firewall_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.port is not None:
            result['Port'] = self.port
        if self.primary_dns is not None:
            result['PrimaryDns'] = self.primary_dns
        if self.primary_vswitch_id is not None:
            result['PrimaryVSwitchId'] = self.primary_vswitch_id
        if self.primary_vswitch_ip is not None:
            result['PrimaryVSwitchIp'] = self.primary_vswitch_ip
        if self.primary_zone_id is not None:
            result['PrimaryZoneId'] = self.primary_zone_id
        if self.private_dns_type is not None:
            result['PrivateDnsType'] = self.private_dns_type
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.standby_dns is not None:
            result['StandbyDns'] = self.standby_dns
        if self.standby_vswitch_id is not None:
            result['StandbyVSwitchId'] = self.standby_vswitch_id
        if self.standby_vswitch_ip is not None:
            result['StandbyVSwitchIp'] = self.standby_vswitch_ip
        if self.standby_zone_id is not None:
            result['StandbyZoneId'] = self.standby_zone_id
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessInstanceId') is not None:
            self.access_instance_id = m.get('AccessInstanceId')
        if m.get('AccessInstanceName') is not None:
            self.access_instance_name = m.get('AccessInstanceName')
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('EndpointId') is not None:
            self.endpoint_id = m.get('EndpointId')
        if m.get('FirewallType') is not None:
            self.firewall_type = m.get('FirewallType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('PrimaryDns') is not None:
            self.primary_dns = m.get('PrimaryDns')
        if m.get('PrimaryVSwitchId') is not None:
            self.primary_vswitch_id = m.get('PrimaryVSwitchId')
        if m.get('PrimaryVSwitchIp') is not None:
            self.primary_vswitch_ip = m.get('PrimaryVSwitchIp')
        if m.get('PrimaryZoneId') is not None:
            self.primary_zone_id = m.get('PrimaryZoneId')
        if m.get('PrivateDnsType') is not None:
            self.private_dns_type = m.get('PrivateDnsType')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StandbyDns') is not None:
            self.standby_dns = m.get('StandbyDns')
        if m.get('StandbyVSwitchId') is not None:
            self.standby_vswitch_id = m.get('StandbyVSwitchId')
        if m.get('StandbyVSwitchIp') is not None:
            self.standby_vswitch_ip = m.get('StandbyVSwitchIp')
        if m.get('StandbyZoneId') is not None:
            self.standby_zone_id = m.get('StandbyZoneId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DescribePrivateDnsEndpointDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePrivateDnsEndpointDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePrivateDnsEndpointDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePrivateDnsEndpointListRequest(TeaModel):
    def __init__(
        self,
        access_instance_id: str = None,
        access_instance_name: str = None,
        firewall_type: str = None,
        member_uid: int = None,
        page_no: int = None,
        page_size: int = None,
        region_no: str = None,
        status: str = None,
        vpc_id: str = None,
    ):
        self.access_instance_id = access_instance_id
        self.access_instance_name = access_instance_name
        self.firewall_type = firewall_type
        self.member_uid = member_uid
        self.page_no = page_no
        self.page_size = page_size
        self.region_no = region_no
        self.status = status
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_instance_id is not None:
            result['AccessInstanceId'] = self.access_instance_id
        if self.access_instance_name is not None:
            result['AccessInstanceName'] = self.access_instance_name
        if self.firewall_type is not None:
            result['FirewallType'] = self.firewall_type
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.status is not None:
            result['Status'] = self.status
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessInstanceId') is not None:
            self.access_instance_id = m.get('AccessInstanceId')
        if m.get('AccessInstanceName') is not None:
            self.access_instance_name = m.get('AccessInstanceName')
        if m.get('FirewallType') is not None:
            self.firewall_type = m.get('FirewallType')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DescribePrivateDnsEndpointListResponseBodyAccessInstanceList(TeaModel):
    def __init__(
        self,
        access_instance_id: str = None,
        access_instance_name: str = None,
        ali_uid: int = None,
        domain_name_count: int = None,
        firewall_type: List[str] = None,
        gmt_create: int = None,
        ip_protocol: int = None,
        member_uid: int = None,
        port: int = None,
        primary_dns: str = None,
        private_dns_type: str = None,
        region_no: str = None,
        standby_dns: str = None,
        status: int = None,
        task_id: str = None,
        vpc_id: str = None,
    ):
        self.access_instance_id = access_instance_id
        self.access_instance_name = access_instance_name
        self.ali_uid = ali_uid
        self.domain_name_count = domain_name_count
        self.firewall_type = firewall_type
        self.gmt_create = gmt_create
        self.ip_protocol = ip_protocol
        self.member_uid = member_uid
        self.port = port
        self.primary_dns = primary_dns
        self.private_dns_type = private_dns_type
        self.region_no = region_no
        self.standby_dns = standby_dns
        self.status = status
        self.task_id = task_id
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_instance_id is not None:
            result['AccessInstanceId'] = self.access_instance_id
        if self.access_instance_name is not None:
            result['AccessInstanceName'] = self.access_instance_name
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.domain_name_count is not None:
            result['DomainNameCount'] = self.domain_name_count
        if self.firewall_type is not None:
            result['FirewallType'] = self.firewall_type
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.port is not None:
            result['Port'] = self.port
        if self.primary_dns is not None:
            result['PrimaryDns'] = self.primary_dns
        if self.private_dns_type is not None:
            result['PrivateDnsType'] = self.private_dns_type
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.standby_dns is not None:
            result['StandbyDns'] = self.standby_dns
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessInstanceId') is not None:
            self.access_instance_id = m.get('AccessInstanceId')
        if m.get('AccessInstanceName') is not None:
            self.access_instance_name = m.get('AccessInstanceName')
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('DomainNameCount') is not None:
            self.domain_name_count = m.get('DomainNameCount')
        if m.get('FirewallType') is not None:
            self.firewall_type = m.get('FirewallType')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('PrimaryDns') is not None:
            self.primary_dns = m.get('PrimaryDns')
        if m.get('PrivateDnsType') is not None:
            self.private_dns_type = m.get('PrivateDnsType')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('StandbyDns') is not None:
            self.standby_dns = m.get('StandbyDns')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DescribePrivateDnsEndpointListResponseBody(TeaModel):
    def __init__(
        self,
        access_instance_list: List[DescribePrivateDnsEndpointListResponseBodyAccessInstanceList] = None,
        page_no: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.access_instance_list = access_instance_list
        self.page_no = page_no
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.access_instance_list:
            for k in self.access_instance_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AccessInstanceList'] = []
        if self.access_instance_list is not None:
            for k in self.access_instance_list:
                result['AccessInstanceList'].append(k.to_map() if k else None)
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.access_instance_list = []
        if m.get('AccessInstanceList') is not None:
            for k in m.get('AccessInstanceList'):
                temp_model = DescribePrivateDnsEndpointListResponseBodyAccessInstanceList()
                self.access_instance_list.append(temp_model.from_map(k))
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePrivateDnsEndpointListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePrivateDnsEndpointListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePrivateDnsEndpointListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRegionInfoRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        source_code: str = None,
        source_ip: str = None,
    ):
        self.lang = lang
        # This parameter is required.
        self.source_code = source_code
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_code is not None:
            result['SourceCode'] = self.source_code
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceCode') is not None:
            self.source_code = m.get('SourceCode')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeRegionInfoResponseBodyDataList(TeaModel):
    def __init__(
        self,
        region_id: str = None,
        region_name: str = None,
    ):
        self.region_id = region_id
        self.region_name = region_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.region_name is not None:
            result['RegionName'] = self.region_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RegionName') is not None:
            self.region_name = m.get('RegionName')
        return self


class DescribeRegionInfoResponseBody(TeaModel):
    def __init__(
        self,
        data_list: List[DescribeRegionInfoResponseBodyDataList] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.data_list = data_list
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.data_list:
            for k in self.data_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataList'] = []
        if self.data_list is not None:
            for k in self.data_list:
                result['DataList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_list = []
        if m.get('DataList') is not None:
            for k in m.get('DataList'):
                temp_model = DescribeRegionInfoResponseBodyDataList()
                self.data_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeRegionInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeRegionInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeRegionInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeResourceTypeAutoEnableRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeResourceTypeAutoEnableResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        resource_type_auto_enable: Dict[str, bool] = None,
    ):
        self.request_id = request_id
        self.resource_type_auto_enable = resource_type_auto_enable

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_type_auto_enable is not None:
            result['ResourceTypeAutoEnable'] = self.resource_type_auto_enable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceTypeAutoEnable') is not None:
            self.resource_type_auto_enable = m.get('ResourceTypeAutoEnable')
        return self


class DescribeResourceTypeAutoEnableResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeResourceTypeAutoEnableResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeResourceTypeAutoEnableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRiskEventGroupRequest(TeaModel):
    def __init__(
        self,
        attack_app: List[str] = None,
        attack_app_category: List[str] = None,
        attack_type: str = None,
        buy_version: int = None,
        current_page: str = None,
        data_type: str = None,
        direction: str = None,
        dst_ip: str = None,
        dst_network_instance_id: str = None,
        end_time: str = None,
        event_name: str = None,
        firewall_type: str = None,
        is_only_private_assoc: str = None,
        lang: str = None,
        no_location: str = None,
        order: str = None,
        page_size: str = None,
        rule_result: str = None,
        rule_source: str = None,
        sort: str = None,
        src_ip: str = None,
        src_network_instance_id: str = None,
        start_time: str = None,
        vul_level: str = None,
    ):
        # The names of the attacked applications. Set the value in the `["AttackApp1","AttackApp2"]` format.
        self.attack_app = attack_app
        # A list of categories of attacked applications, expressed in the format ["AttackAppCategory1","AttackAppCategory2"].
        self.attack_app_category = attack_app_category
        # The attack type of the intrusion events. Valid values:
        # 
        # *   **1**: suspicious connection
        # *   **2**: command execution
        # *   **3**: brute-force attack
        # *   **4**: scanning
        # *   **5**: others
        # *   **6**: information leak
        # *   **7**: DoS attack
        # *   **8**: buffer overflow attack
        # *   **9**: web attack
        # *   **10**: trojan backdoor
        # *   **11**: computer worm
        # *   **12**: mining
        # *   **13**: reverse shell
        # 
        # > If you do not specify this parameter, the intrusion events of all attack types are queried.
        self.attack_type = attack_type
        # The edition of Cloud Firewall that you purchase. Valid values:
        # 
        # *   **2**: Premium Edition
        # *   **3**: Enterprise Edition
        # *   **4**: Ultimate Edition
        # *   **10**: Cloud Firewall that uses the pay-as-you-go billing method
        self.buy_version = buy_version
        # The number of the page to return. Default value: **1**.
        self.current_page = current_page
        # The type of the risk events.\\
        # Set the value to **session**, which indicates intrusion events.
        # 
        # This parameter is required.
        self.data_type = data_type
        # The direction of the traffic for the intrusion events. Valid values:
        # 
        # *   **in**: inbound
        # *   **out**: outbound
        # 
        # > If you do not specify this parameter, the intrusion events that are recorded for both inbound and outbound traffic are queried.
        self.direction = direction
        # The destination IP address to query. If you specify this parameter, all intrusion events with the specified destination IP address are queried.
        self.dst_ip = dst_ip
        # The ID of the destination VPC.
        # 
        # > If the FirewallType parameter is set to VpcFirewall, you must specify this parameter.
        self.dst_network_instance_id = dst_network_instance_id
        # The end of the time range to query. The value is a UNIX timestamp. Unit: seconds.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The name of the intrusion event.
        self.event_name = event_name
        # The type of the firewall. Valid values:
        # 
        # *   **VpcFirewall**: virtual private cloud (VPC) firewall
        # *   **InternetFirewall**: Internet firewall (default)
        self.firewall_type = firewall_type
        # Whether to query only the data that has completed private network tracing.
        self.is_only_private_assoc = is_only_private_assoc
        # The language of the content within the request and response. Valid values:
        # 
        # *   **zh**: Chinese (default)
        # *   **en**: English
        self.lang = lang
        # Specifies whether to query the information about the geographical locations of IP addresses.
        # 
        # *   **true**: does not query the information about the geographical locations of IP addresses.
        # *   **false**: queries the information about the geographical locations of IP addresses. This is the default value.
        self.no_location = no_location
        # The order in which you want to sort the results. Valid values:
        # 
        # *   **asc**: the ascending order.
        # *   **desc**: the descending order. This is the default value.
        self.order = order
        # The number of entries to return on each page.
        # 
        # Default value: **6**. Maximum value: **10**.
        self.page_size = page_size
        # The status of the firewall. Valid values:
        # 
        # *   **1**: alerting
        # *   **2**: blocking
        # 
        # > If you do not specify this parameter, all intrusion events that are detected by the firewall are queried, regardless of the firewall status.
        self.rule_result = rule_result
        # The module of the rule that is used to detect the intrusion events. Valid values:
        # 
        # *   **1**: basic protection
        # *   **2**: virtual patching
        # *   **4**: threat intelligence
        # 
        # > If you do not specify this parameter, the intrusion events that are detected by all rules are queried.
        self.rule_source = rule_source
        # The field based on which you want to sort the results. Valid values:
        # 
        # *   **VulLevel**: The results are sorted based on the risk level field. This is the default value.
        # *   **LastTime**: The results are sorted based on the most recent occurrence time.
        self.sort = sort
        # The source IP address to query. If you specify this parameter, all intrusion events with the specified source IP address are queried.
        self.src_ip = src_ip
        # The ID of the source VPC.
        # 
        # > If the FirewallType parameter is set to VpcFirewall, you must specify this parameter.
        self.src_network_instance_id = src_network_instance_id
        # The beginning of the time range to query. The value is a UNIX timestamp. Unit: seconds.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The risk level of the intrusion events. Valid values:
        # 
        # *   **1**: low
        # *   **2**: medium
        # *   **3**: high
        # 
        # > If you do not specify this parameter, the intrusion events that are at all risk levels are queried.
        self.vul_level = vul_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attack_app is not None:
            result['AttackApp'] = self.attack_app
        if self.attack_app_category is not None:
            result['AttackAppCategory'] = self.attack_app_category
        if self.attack_type is not None:
            result['AttackType'] = self.attack_type
        if self.buy_version is not None:
            result['BuyVersion'] = self.buy_version
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data_type is not None:
            result['DataType'] = self.data_type
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.dst_ip is not None:
            result['DstIP'] = self.dst_ip
        if self.dst_network_instance_id is not None:
            result['DstNetworkInstanceId'] = self.dst_network_instance_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.firewall_type is not None:
            result['FirewallType'] = self.firewall_type
        if self.is_only_private_assoc is not None:
            result['IsOnlyPrivateAssoc'] = self.is_only_private_assoc
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.no_location is not None:
            result['NoLocation'] = self.no_location
        if self.order is not None:
            result['Order'] = self.order
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rule_result is not None:
            result['RuleResult'] = self.rule_result
        if self.rule_source is not None:
            result['RuleSource'] = self.rule_source
        if self.sort is not None:
            result['Sort'] = self.sort
        if self.src_ip is not None:
            result['SrcIP'] = self.src_ip
        if self.src_network_instance_id is not None:
            result['SrcNetworkInstanceId'] = self.src_network_instance_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.vul_level is not None:
            result['VulLevel'] = self.vul_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttackApp') is not None:
            self.attack_app = m.get('AttackApp')
        if m.get('AttackAppCategory') is not None:
            self.attack_app_category = m.get('AttackAppCategory')
        if m.get('AttackType') is not None:
            self.attack_type = m.get('AttackType')
        if m.get('BuyVersion') is not None:
            self.buy_version = m.get('BuyVersion')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DataType') is not None:
            self.data_type = m.get('DataType')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('DstIP') is not None:
            self.dst_ip = m.get('DstIP')
        if m.get('DstNetworkInstanceId') is not None:
            self.dst_network_instance_id = m.get('DstNetworkInstanceId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('FirewallType') is not None:
            self.firewall_type = m.get('FirewallType')
        if m.get('IsOnlyPrivateAssoc') is not None:
            self.is_only_private_assoc = m.get('IsOnlyPrivateAssoc')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NoLocation') is not None:
            self.no_location = m.get('NoLocation')
        if m.get('Order') is not None:
            self.order = m.get('Order')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RuleResult') is not None:
            self.rule_result = m.get('RuleResult')
        if m.get('RuleSource') is not None:
            self.rule_source = m.get('RuleSource')
        if m.get('Sort') is not None:
            self.sort = m.get('Sort')
        if m.get('SrcIP') is not None:
            self.src_ip = m.get('SrcIP')
        if m.get('SrcNetworkInstanceId') is not None:
            self.src_network_instance_id = m.get('SrcNetworkInstanceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('VulLevel') is not None:
            self.vul_level = m.get('VulLevel')
        return self


class DescribeRiskEventGroupResponseBodyDataListIPLocationInfo(TeaModel):
    def __init__(
        self,
        city_id: str = None,
        city_name: str = None,
        country_id: str = None,
        country_name: str = None,
    ):
        # The ID of the city to which the IP address belongs.
        self.city_id = city_id
        # The name of the city to which the IP address belongs.
        self.city_name = city_name
        # The ID of the country to which the IP address belongs.
        self.country_id = country_id
        # The name of the country to which the IP address belongs.
        self.country_name = country_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_id is not None:
            result['CityId'] = self.city_id
        if self.city_name is not None:
            result['CityName'] = self.city_name
        if self.country_id is not None:
            result['CountryId'] = self.country_id
        if self.country_name is not None:
            result['CountryName'] = self.country_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CityId') is not None:
            self.city_id = m.get('CityId')
        if m.get('CityName') is not None:
            self.city_name = m.get('CityName')
        if m.get('CountryId') is not None:
            self.country_id = m.get('CountryId')
        if m.get('CountryName') is not None:
            self.country_name = m.get('CountryName')
        return self


class DescribeRiskEventGroupResponseBodyDataListResourcePrivateIPList(TeaModel):
    def __init__(
        self,
        region_no: str = None,
        resource_instance_id: str = None,
        resource_instance_name: str = None,
        resource_private_ip: str = None,
    ):
        # The ID of the region to which the private IP address belongs.
        self.region_no = region_no
        # The ID of the instance that uses the private IP address.
        self.resource_instance_id = resource_instance_id
        # The name of the instance that uses the private IP address.
        self.resource_instance_name = resource_instance_name
        # The private IP address.
        self.resource_private_ip = resource_private_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.resource_instance_id is not None:
            result['ResourceInstanceId'] = self.resource_instance_id
        if self.resource_instance_name is not None:
            result['ResourceInstanceName'] = self.resource_instance_name
        if self.resource_private_ip is not None:
            result['ResourcePrivateIP'] = self.resource_private_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('ResourceInstanceId') is not None:
            self.resource_instance_id = m.get('ResourceInstanceId')
        if m.get('ResourceInstanceName') is not None:
            self.resource_instance_name = m.get('ResourceInstanceName')
        if m.get('ResourcePrivateIP') is not None:
            self.resource_private_ip = m.get('ResourcePrivateIP')
        return self


class DescribeRiskEventGroupResponseBodyDataListVpcDstInfo(TeaModel):
    def __init__(
        self,
        ecs_instance_id: str = None,
        ecs_instance_name: str = None,
        network_instance_id: str = None,
        network_instance_name: str = None,
        region_no: str = None,
    ):
        # The ID of the ECS instance.
        self.ecs_instance_id = ecs_instance_id
        # The name of the ECS instance.
        self.ecs_instance_name = ecs_instance_name
        # The ID of the VPC.
        self.network_instance_id = network_instance_id
        # The name of the VPC.
        self.network_instance_name = network_instance_name
        # The ID of the region in which the destination VPC resides.
        self.region_no = region_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ecs_instance_id is not None:
            result['EcsInstanceId'] = self.ecs_instance_id
        if self.ecs_instance_name is not None:
            result['EcsInstanceName'] = self.ecs_instance_name
        if self.network_instance_id is not None:
            result['NetworkInstanceId'] = self.network_instance_id
        if self.network_instance_name is not None:
            result['NetworkInstanceName'] = self.network_instance_name
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EcsInstanceId') is not None:
            self.ecs_instance_id = m.get('EcsInstanceId')
        if m.get('EcsInstanceName') is not None:
            self.ecs_instance_name = m.get('EcsInstanceName')
        if m.get('NetworkInstanceId') is not None:
            self.network_instance_id = m.get('NetworkInstanceId')
        if m.get('NetworkInstanceName') is not None:
            self.network_instance_name = m.get('NetworkInstanceName')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        return self


class DescribeRiskEventGroupResponseBodyDataListVpcSrcInfo(TeaModel):
    def __init__(
        self,
        ecs_instance_id: str = None,
        ecs_instance_name: str = None,
        network_instance_id: str = None,
        network_instance_name: str = None,
        region_no: str = None,
    ):
        # The ID of the ECS instance.
        self.ecs_instance_id = ecs_instance_id
        # The name of the ECS instance.
        self.ecs_instance_name = ecs_instance_name
        # The ID of the VPC.
        self.network_instance_id = network_instance_id
        # The name of the VPC.
        self.network_instance_name = network_instance_name
        # The ID of the region in which the source VPC resides.
        self.region_no = region_no

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ecs_instance_id is not None:
            result['EcsInstanceId'] = self.ecs_instance_id
        if self.ecs_instance_name is not None:
            result['EcsInstanceName'] = self.ecs_instance_name
        if self.network_instance_id is not None:
            result['NetworkInstanceId'] = self.network_instance_id
        if self.network_instance_name is not None:
            result['NetworkInstanceName'] = self.network_instance_name
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EcsInstanceId') is not None:
            self.ecs_instance_id = m.get('EcsInstanceId')
        if m.get('EcsInstanceName') is not None:
            self.ecs_instance_name = m.get('EcsInstanceName')
        if m.get('NetworkInstanceId') is not None:
            self.network_instance_id = m.get('NetworkInstanceId')
        if m.get('NetworkInstanceName') is not None:
            self.network_instance_name = m.get('NetworkInstanceName')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        return self


class DescribeRiskEventGroupResponseBodyDataList(TeaModel):
    def __init__(
        self,
        attack_app: str = None,
        attack_type: int = None,
        description: str = None,
        direction: str = None,
        dst_ip: str = None,
        event_count: int = None,
        event_id: str = None,
        event_name: str = None,
        first_event_time: int = None,
        iplocation_info: DescribeRiskEventGroupResponseBodyDataListIPLocationInfo = None,
        last_event_time: int = None,
        resource_private_iplist: List[DescribeRiskEventGroupResponseBodyDataListResourcePrivateIPList] = None,
        resource_type: str = None,
        rule_id: str = None,
        rule_result: int = None,
        rule_source: int = None,
        src_ip: str = None,
        src_iptag: str = None,
        src_iptags: List[str] = None,
        src_private_iplist: List[str] = None,
        tag: str = None,
        vpc_dst_info: DescribeRiskEventGroupResponseBodyDataListVpcDstInfo = None,
        vpc_src_info: DescribeRiskEventGroupResponseBodyDataListVpcSrcInfo = None,
        vul_level: int = None,
    ):
        # The name of the attacked application.
        self.attack_app = attack_app
        # The attack type of the intrusion event. Valid values:
        # 
        # *   **1**: suspicious connection
        # *   **2**: command execution
        # *   **3**: brute-force attack
        # *   **4**: scanning
        # *   **5**: others
        # *   **6**: information leak
        # *   **7**: DoS attack
        # *   **8**: buffer overflow attack
        # *   **9**: web attack
        # *   **10**: trojan backdoor
        # *   **11**: computer worm
        # *   **12**: mining
        # *   **13**: reverse shell
        self.attack_type = attack_type
        # The description of the intrusion event.
        self.description = description
        # The direction of the traffic for the intrusion event. Valid values:
        # 
        # *   **in**: inbound
        # *   **out**: outbound
        self.direction = direction
        # The destination IP address that is included in the intrusion event.
        self.dst_ip = dst_ip
        # The number of intrusion events.
        self.event_count = event_count
        # The ID of the intrusion event.
        self.event_id = event_id
        # The name of the intrusion event.
        self.event_name = event_name
        # The time when the intrusion event was first detected. The value is a UNIX timestamp. Unit: seconds.
        self.first_event_time = first_event_time
        # The geographical information about the IP address. The value is a struct that contains the following parameters: **CityId**, **CityName**, **CountryId**, and **CountryName**.\\
        # ****************\
        self.iplocation_info = iplocation_info
        # The time when the intrusion event was last detected. The value is a UNIX timestamp. Unit: seconds.
        self.last_event_time = last_event_time
        # The information about the private IP address in the intrusion event. The value is an array that contains the following parameters: **RegionNo**, **ResourceInstanceId**, **ResourceInstanceName**, and **ResourcePrivateIP**.\\
        # ****************\
        self.resource_private_iplist = resource_private_iplist
        # The type of the public IP address in the intrusion event. Valid values:
        # 
        # *   **EIP**: the elastic IP address (EIP)
        # *   **EcsPublicIP**: the public IP address of an Elastic Compute Service (ECS) instance
        # *   **EcsEIP**: the EIP of an ECS instance
        # *   **NatPublicIP**: the public IP address of a NAT gateway
        # *   **NatEIP**: the EIP of a NAT gateway
        self.resource_type = resource_type
        # The ID of the rule that is used to detect the intrusion event.
        self.rule_id = rule_id
        # The status of the firewall. Valid values:
        # 
        # *   **1**: alerting
        # *   **2**: blocking
        self.rule_result = rule_result
        # The module of the rule that is used to detect the intrusion event. Valid values:
        # 
        # *   **1**: basic protection
        # *   **2**: virtual patching
        # *   **4**: threat intelligence
        self.rule_source = rule_source
        # The source IP address that is included in the intrusion event.
        self.src_ip = src_ip
        # The tag added to the source IP address. The tag helps identify whether the source IP address is a back-to-origin IP address for a cloud service.
        self.src_iptag = src_iptag
        self.src_iptags = src_iptags
        # An array that consists of the source private IP addresses in the intrusion event.
        self.src_private_iplist = src_private_iplist
        # The tag added to the threat intelligence that is provided for major events.
        self.tag = tag
        # The information about the destination VPC of the intrusion event. The value is a struct that contains the following parameters: **EcsInstanceId**, **EcsInstanceName**, **NetworkInstanceId**, **NetworkInstanceName**, and **RegionNo**.\\
        # ********************\
        self.vpc_dst_info = vpc_dst_info
        # The information about the source VPC of the intrusion event. The value is a struct that contains the following parameters: **EcsInstanceId**, **EcsInstanceName**, **NetworkInstanceId**, **NetworkInstanceName**, and **RegionNo**.\\
        # ********************\
        self.vpc_src_info = vpc_src_info
        # The risk level of the intrusion event. Valid values:
        # 
        # *   **1**: low
        # *   **2**: medium
        # *   **3**: high
        self.vul_level = vul_level

    def validate(self):
        if self.iplocation_info:
            self.iplocation_info.validate()
        if self.resource_private_iplist:
            for k in self.resource_private_iplist:
                if k:
                    k.validate()
        if self.vpc_dst_info:
            self.vpc_dst_info.validate()
        if self.vpc_src_info:
            self.vpc_src_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attack_app is not None:
            result['AttackApp'] = self.attack_app
        if self.attack_type is not None:
            result['AttackType'] = self.attack_type
        if self.description is not None:
            result['Description'] = self.description
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.dst_ip is not None:
            result['DstIP'] = self.dst_ip
        if self.event_count is not None:
            result['EventCount'] = self.event_count
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.first_event_time is not None:
            result['FirstEventTime'] = self.first_event_time
        if self.iplocation_info is not None:
            result['IPLocationInfo'] = self.iplocation_info.to_map()
        if self.last_event_time is not None:
            result['LastEventTime'] = self.last_event_time
        result['ResourcePrivateIPList'] = []
        if self.resource_private_iplist is not None:
            for k in self.resource_private_iplist:
                result['ResourcePrivateIPList'].append(k.to_map() if k else None)
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_result is not None:
            result['RuleResult'] = self.rule_result
        if self.rule_source is not None:
            result['RuleSource'] = self.rule_source
        if self.src_ip is not None:
            result['SrcIP'] = self.src_ip
        if self.src_iptag is not None:
            result['SrcIPTag'] = self.src_iptag
        if self.src_iptags is not None:
            result['SrcIPTags'] = self.src_iptags
        if self.src_private_iplist is not None:
            result['SrcPrivateIPList'] = self.src_private_iplist
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.vpc_dst_info is not None:
            result['VpcDstInfo'] = self.vpc_dst_info.to_map()
        if self.vpc_src_info is not None:
            result['VpcSrcInfo'] = self.vpc_src_info.to_map()
        if self.vul_level is not None:
            result['VulLevel'] = self.vul_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttackApp') is not None:
            self.attack_app = m.get('AttackApp')
        if m.get('AttackType') is not None:
            self.attack_type = m.get('AttackType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('DstIP') is not None:
            self.dst_ip = m.get('DstIP')
        if m.get('EventCount') is not None:
            self.event_count = m.get('EventCount')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('FirstEventTime') is not None:
            self.first_event_time = m.get('FirstEventTime')
        if m.get('IPLocationInfo') is not None:
            temp_model = DescribeRiskEventGroupResponseBodyDataListIPLocationInfo()
            self.iplocation_info = temp_model.from_map(m['IPLocationInfo'])
        if m.get('LastEventTime') is not None:
            self.last_event_time = m.get('LastEventTime')
        self.resource_private_iplist = []
        if m.get('ResourcePrivateIPList') is not None:
            for k in m.get('ResourcePrivateIPList'):
                temp_model = DescribeRiskEventGroupResponseBodyDataListResourcePrivateIPList()
                self.resource_private_iplist.append(temp_model.from_map(k))
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleResult') is not None:
            self.rule_result = m.get('RuleResult')
        if m.get('RuleSource') is not None:
            self.rule_source = m.get('RuleSource')
        if m.get('SrcIP') is not None:
            self.src_ip = m.get('SrcIP')
        if m.get('SrcIPTag') is not None:
            self.src_iptag = m.get('SrcIPTag')
        if m.get('SrcIPTags') is not None:
            self.src_iptags = m.get('SrcIPTags')
        if m.get('SrcPrivateIPList') is not None:
            self.src_private_iplist = m.get('SrcPrivateIPList')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('VpcDstInfo') is not None:
            temp_model = DescribeRiskEventGroupResponseBodyDataListVpcDstInfo()
            self.vpc_dst_info = temp_model.from_map(m['VpcDstInfo'])
        if m.get('VpcSrcInfo') is not None:
            temp_model = DescribeRiskEventGroupResponseBodyDataListVpcSrcInfo()
            self.vpc_src_info = temp_model.from_map(m['VpcSrcInfo'])
        if m.get('VulLevel') is not None:
            self.vul_level = m.get('VulLevel')
        return self


class DescribeRiskEventGroupResponseBody(TeaModel):
    def __init__(
        self,
        data_list: List[DescribeRiskEventGroupResponseBodyDataList] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # An array that consists of the details of the intrusion events.
        self.data_list = data_list
        # The ID of the request.
        self.request_id = request_id
        # The total number of risk events.
        self.total_count = total_count

    def validate(self):
        if self.data_list:
            for k in self.data_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DataList'] = []
        if self.data_list is not None:
            for k in self.data_list:
                result['DataList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data_list = []
        if m.get('DataList') is not None:
            for k in m.get('DataList'):
                temp_model = DescribeRiskEventGroupResponseBodyDataList()
                self.data_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeRiskEventGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeRiskEventGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeRiskEventGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRiskEventPayloadRequest(TeaModel):
    def __init__(
        self,
        dst_ip: str = None,
        dst_vpc_id: str = None,
        end_time: str = None,
        firewall_type: str = None,
        public_ip: str = None,
        src_ip: str = None,
        src_vpc_id: str = None,
        start_time: str = None,
        uuid: str = None,
    ):
        # The destination IP address to query. If you specify this parameter, all intrusion events with the specified destination IP address are queried.
        self.dst_ip = dst_ip
        # The ID of the destination VPC to query. If you specify this parameter, all intrusion events that contain the specified ID of the destination VPC are queried.
        self.dst_vpc_id = dst_vpc_id
        # The end of the time range to query. The value is a timestamp. Unit: seconds.
        # 
        # This parameter is required.
        self.end_time = end_time
        # The type of the firewall. Valid values:
        # 
        # *   **VpcFirewall**: virtual private cloud (VPC) firewall
        # *   **InternetFirewall** (default): Internet firewall
        self.firewall_type = firewall_type
        # The public IP address. If you specify this parameter, all intrusion events that contain the specified public IP address are queried.
        self.public_ip = public_ip
        # The source IP address to query. If you specify this parameter, all intrusion events from the specified source IP address are queried.
        self.src_ip = src_ip
        # The ID of the source VPC to query. If you specify this parameter, all intrusion events that contain the specified ID of the source VPC are queried.
        self.src_vpc_id = src_vpc_id
        # The beginning of the time range to query. The value is a timestamp. Unit: seconds.
        # 
        # This parameter is required.
        self.start_time = start_time
        # The UUID of the intrusion event.
        # 
        # This parameter is required.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dst_ip is not None:
            result['DstIP'] = self.dst_ip
        if self.dst_vpc_id is not None:
            result['DstVpcId'] = self.dst_vpc_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.firewall_type is not None:
            result['FirewallType'] = self.firewall_type
        if self.public_ip is not None:
            result['PublicIP'] = self.public_ip
        if self.src_ip is not None:
            result['SrcIP'] = self.src_ip
        if self.src_vpc_id is not None:
            result['SrcVpcId'] = self.src_vpc_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.uuid is not None:
            result['UUID'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DstIP') is not None:
            self.dst_ip = m.get('DstIP')
        if m.get('DstVpcId') is not None:
            self.dst_vpc_id = m.get('DstVpcId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('FirewallType') is not None:
            self.firewall_type = m.get('FirewallType')
        if m.get('PublicIP') is not None:
            self.public_ip = m.get('PublicIP')
        if m.get('SrcIP') is not None:
            self.src_ip = m.get('SrcIP')
        if m.get('SrcVpcId') is not None:
            self.src_vpc_id = m.get('SrcVpcId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('UUID') is not None:
            self.uuid = m.get('UUID')
        return self


class DescribeRiskEventPayloadResponseBody(TeaModel):
    def __init__(
        self,
        dst_ip: str = None,
        dst_port: int = None,
        dst_vpc_id: str = None,
        hit_content_type: int = None,
        hit_to: int = None,
        parsed_content: str = None,
        payload: str = None,
        payload_len: int = None,
        proto: str = None,
        real_ip: str = None,
        request_id: str = None,
        src_ip: str = None,
        src_port: int = None,
        src_vpc_id: str = None,
        xforward_for: str = None,
    ):
        # The destination IP address of the intrusion event.
        self.dst_ip = dst_ip
        # The destination port of the intrusion event.
        self.dst_port = dst_port
        # The destination VPC ID of the intrusion event.
        self.dst_vpc_id = dst_vpc_id
        # Type of the hit.
        self.hit_content_type = hit_content_type
        # The position where the hit ends.
        self.hit_to = hit_to
        # Hit payload.
        self.parsed_content = parsed_content
        # The attack payload of the intrusion event.
        self.payload = payload
        # The length of the attack payload of the intrusion event.
        self.payload_len = payload_len
        # The protocol type of intrusion event. Valid values:
        # 
        # *   **TCP**\
        # *   **UDP**\
        self.proto = proto
        # The HTTP X-Real-IP field.
        self.real_ip = real_ip
        # The request ID.
        self.request_id = request_id
        # The source IP address of the intrusion event.
        self.src_ip = src_ip
        # The source port of the intrusion event.
        self.src_port = src_port
        # The source VPC ID of the intrusion event.
        self.src_vpc_id = src_vpc_id
        # The HTTP X-Forwarded-For field.
        self.xforward_for = xforward_for

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dst_ip is not None:
            result['DstIP'] = self.dst_ip
        if self.dst_port is not None:
            result['DstPort'] = self.dst_port
        if self.dst_vpc_id is not None:
            result['DstVpcId'] = self.dst_vpc_id
        if self.hit_content_type is not None:
            result['HitContentType'] = self.hit_content_type
        if self.hit_to is not None:
            result['HitTo'] = self.hit_to
        if self.parsed_content is not None:
            result['ParsedContent'] = self.parsed_content
        if self.payload is not None:
            result['Payload'] = self.payload
        if self.payload_len is not None:
            result['PayloadLen'] = self.payload_len
        if self.proto is not None:
            result['Proto'] = self.proto
        if self.real_ip is not None:
            result['RealIp'] = self.real_ip
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.src_ip is not None:
            result['SrcIP'] = self.src_ip
        if self.src_port is not None:
            result['SrcPort'] = self.src_port
        if self.src_vpc_id is not None:
            result['SrcVpcId'] = self.src_vpc_id
        if self.xforward_for is not None:
            result['XForwardFor'] = self.xforward_for
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DstIP') is not None:
            self.dst_ip = m.get('DstIP')
        if m.get('DstPort') is not None:
            self.dst_port = m.get('DstPort')
        if m.get('DstVpcId') is not None:
            self.dst_vpc_id = m.get('DstVpcId')
        if m.get('HitContentType') is not None:
            self.hit_content_type = m.get('HitContentType')
        if m.get('HitTo') is not None:
            self.hit_to = m.get('HitTo')
        if m.get('ParsedContent') is not None:
            self.parsed_content = m.get('ParsedContent')
        if m.get('Payload') is not None:
            self.payload = m.get('Payload')
        if m.get('PayloadLen') is not None:
            self.payload_len = m.get('PayloadLen')
        if m.get('Proto') is not None:
            self.proto = m.get('Proto')
        if m.get('RealIp') is not None:
            self.real_ip = m.get('RealIp')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SrcIP') is not None:
            self.src_ip = m.get('SrcIP')
        if m.get('SrcPort') is not None:
            self.src_port = m.get('SrcPort')
        if m.get('SrcVpcId') is not None:
            self.src_vpc_id = m.get('SrcVpcId')
        if m.get('XForwardFor') is not None:
            self.xforward_for = m.get('XForwardFor')
        return self


class DescribeRiskEventPayloadResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeRiskEventPayloadResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeRiskEventPayloadResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRiskEventTopAttackAssetRequest(TeaModel):
    def __init__(
        self,
        attack_app: List[str] = None,
        attack_type: str = None,
        buy_version: str = None,
        end_time: str = None,
        lang: str = None,
        source_ip: str = None,
        start_time: str = None,
    ):
        self.attack_app = attack_app
        self.attack_type = attack_type
        self.buy_version = buy_version
        # This parameter is required.
        self.end_time = end_time
        self.lang = lang
        self.source_ip = source_ip
        # This parameter is required.
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attack_app is not None:
            result['AttackApp'] = self.attack_app
        if self.attack_type is not None:
            result['AttackType'] = self.attack_type
        if self.buy_version is not None:
            result['BuyVersion'] = self.buy_version
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttackApp') is not None:
            self.attack_app = m.get('AttackApp')
        if m.get('AttackType') is not None:
            self.attack_type = m.get('AttackType')
        if m.get('BuyVersion') is not None:
            self.buy_version = m.get('BuyVersion')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeRiskEventTopAttackAssetResponseBodyAssets(TeaModel):
    def __init__(
        self,
        attack_cnt: int = None,
        drop_cnt: int = None,
        ip: str = None,
        region_no: str = None,
        resource_instance_id: str = None,
        resource_instance_name: str = None,
        resource_type: str = None,
    ):
        self.attack_cnt = attack_cnt
        self.drop_cnt = drop_cnt
        self.ip = ip
        self.region_no = region_no
        self.resource_instance_id = resource_instance_id
        self.resource_instance_name = resource_instance_name
        self.resource_type = resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attack_cnt is not None:
            result['AttackCnt'] = self.attack_cnt
        if self.drop_cnt is not None:
            result['DropCnt'] = self.drop_cnt
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.resource_instance_id is not None:
            result['ResourceInstanceId'] = self.resource_instance_id
        if self.resource_instance_name is not None:
            result['ResourceInstanceName'] = self.resource_instance_name
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttackCnt') is not None:
            self.attack_cnt = m.get('AttackCnt')
        if m.get('DropCnt') is not None:
            self.drop_cnt = m.get('DropCnt')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('ResourceInstanceId') is not None:
            self.resource_instance_id = m.get('ResourceInstanceId')
        if m.get('ResourceInstanceName') is not None:
            self.resource_instance_name = m.get('ResourceInstanceName')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class DescribeRiskEventTopAttackAssetResponseBody(TeaModel):
    def __init__(
        self,
        assets: List[DescribeRiskEventTopAttackAssetResponseBodyAssets] = None,
        request_id: str = None,
    ):
        self.assets = assets
        self.request_id = request_id

    def validate(self):
        if self.assets:
            for k in self.assets:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Assets'] = []
        if self.assets is not None:
            for k in self.assets:
                result['Assets'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.assets = []
        if m.get('Assets') is not None:
            for k in m.get('Assets'):
                temp_model = DescribeRiskEventTopAttackAssetResponseBodyAssets()
                self.assets.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeRiskEventTopAttackAssetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeRiskEventTopAttackAssetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeRiskEventTopAttackAssetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRiskSecurityGroupDetailRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        instance_name: str = None,
        lang: str = None,
        page_no: str = None,
        page_size: str = None,
        region_id: str = None,
        rule_uuid: str = None,
        source_ip: str = None,
    ):
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.lang = lang
        # This parameter is required.
        self.page_no = page_no
        # This parameter is required.
        self.page_size = page_size
        self.region_id = region_id
        self.rule_uuid = rule_uuid
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.rule_uuid is not None:
            result['RuleUuid'] = self.rule_uuid
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RuleUuid') is not None:
            self.rule_uuid = m.get('RuleUuid')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeRiskSecurityGroupDetailResponseBodyRiskSgDetailEcsInfo(TeaModel):
    def __init__(
        self,
        ecs_instance_id: str = None,
        ecs_instance_name: str = None,
        private_ip: str = None,
        public_ip: str = None,
    ):
        self.ecs_instance_id = ecs_instance_id
        self.ecs_instance_name = ecs_instance_name
        self.private_ip = private_ip
        self.public_ip = public_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ecs_instance_id is not None:
            result['EcsInstanceId'] = self.ecs_instance_id
        if self.ecs_instance_name is not None:
            result['EcsInstanceName'] = self.ecs_instance_name
        if self.private_ip is not None:
            result['PrivateIp'] = self.private_ip
        if self.public_ip is not None:
            result['PublicIp'] = self.public_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EcsInstanceId') is not None:
            self.ecs_instance_id = m.get('EcsInstanceId')
        if m.get('EcsInstanceName') is not None:
            self.ecs_instance_name = m.get('EcsInstanceName')
        if m.get('PrivateIp') is not None:
            self.private_ip = m.get('PrivateIp')
        if m.get('PublicIp') is not None:
            self.public_ip = m.get('PublicIp')
        return self


class DescribeRiskSecurityGroupDetailResponseBodyRiskSgDetailRuleInfo(TeaModel):
    def __init__(
        self,
        description: str = None,
        risk_level: str = None,
        rule_name: str = None,
        rule_status: str = None,
        rule_uuid: str = None,
        suggestion: str = None,
    ):
        self.description = description
        self.risk_level = risk_level
        self.rule_name = rule_name
        self.rule_status = rule_status
        self.rule_uuid = rule_uuid
        self.suggestion = suggestion

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.rule_status is not None:
            result['RuleStatus'] = self.rule_status
        if self.rule_uuid is not None:
            result['RuleUuid'] = self.rule_uuid
        if self.suggestion is not None:
            result['Suggestion'] = self.suggestion
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('RuleStatus') is not None:
            self.rule_status = m.get('RuleStatus')
        if m.get('RuleUuid') is not None:
            self.rule_uuid = m.get('RuleUuid')
        if m.get('Suggestion') is not None:
            self.suggestion = m.get('Suggestion')
        return self


class DescribeRiskSecurityGroupDetailResponseBodyRiskSgDetail(TeaModel):
    def __init__(
        self,
        ecs_count: int = None,
        ecs_info: List[DescribeRiskSecurityGroupDetailResponseBodyRiskSgDetailEcsInfo] = None,
        instance_id: str = None,
        instance_name: str = None,
        region_no: str = None,
        risk_level: str = None,
        rule_info: List[DescribeRiskSecurityGroupDetailResponseBodyRiskSgDetailRuleInfo] = None,
        vpc_id: str = None,
    ):
        self.ecs_count = ecs_count
        self.ecs_info = ecs_info
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.region_no = region_no
        self.risk_level = risk_level
        self.rule_info = rule_info
        self.vpc_id = vpc_id

    def validate(self):
        if self.ecs_info:
            for k in self.ecs_info:
                if k:
                    k.validate()
        if self.rule_info:
            for k in self.rule_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ecs_count is not None:
            result['EcsCount'] = self.ecs_count
        result['EcsInfo'] = []
        if self.ecs_info is not None:
            for k in self.ecs_info:
                result['EcsInfo'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        result['RuleInfo'] = []
        if self.rule_info is not None:
            for k in self.rule_info:
                result['RuleInfo'].append(k.to_map() if k else None)
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EcsCount') is not None:
            self.ecs_count = m.get('EcsCount')
        self.ecs_info = []
        if m.get('EcsInfo') is not None:
            for k in m.get('EcsInfo'):
                temp_model = DescribeRiskSecurityGroupDetailResponseBodyRiskSgDetailEcsInfo()
                self.ecs_info.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        self.rule_info = []
        if m.get('RuleInfo') is not None:
            for k in m.get('RuleInfo'):
                temp_model = DescribeRiskSecurityGroupDetailResponseBodyRiskSgDetailRuleInfo()
                self.rule_info.append(temp_model.from_map(k))
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DescribeRiskSecurityGroupDetailResponseBody(TeaModel):
    def __init__(
        self,
        page_no: int = None,
        page_size: int = None,
        request_id: str = None,
        risk_sg_detail: List[DescribeRiskSecurityGroupDetailResponseBodyRiskSgDetail] = None,
        total_count: int = None,
    ):
        self.page_no = page_no
        self.page_size = page_size
        self.request_id = request_id
        self.risk_sg_detail = risk_sg_detail
        self.total_count = total_count

    def validate(self):
        if self.risk_sg_detail:
            for k in self.risk_sg_detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['RiskSgDetail'] = []
        if self.risk_sg_detail is not None:
            for k in self.risk_sg_detail:
                result['RiskSgDetail'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.risk_sg_detail = []
        if m.get('RiskSgDetail') is not None:
            for k in m.get('RiskSgDetail'):
                temp_model = DescribeRiskSecurityGroupDetailResponseBodyRiskSgDetail()
                self.risk_sg_detail.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeRiskSecurityGroupDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeRiskSecurityGroupDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeRiskSecurityGroupDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSecurityModeRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        source_ip: str = None,
    ):
        self.lang = lang
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeSecurityModeResponseBody(TeaModel):
    def __init__(
        self,
        module: str = None,
        request_id: str = None,
        security_mode: int = None,
    ):
        self.module = module
        self.request_id = request_id
        self.security_mode = security_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.module is not None:
            result['Module'] = self.module
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.security_mode is not None:
            result['SecurityMode'] = self.security_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Module') is not None:
            self.module = m.get('Module')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SecurityMode') is not None:
            self.security_mode = m.get('SecurityMode')
        return self


class DescribeSecurityModeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSecurityModeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSecurityModeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSecurityProxyRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        member_uid: str = None,
        nat_gateway_id: str = None,
        page_no: str = None,
        page_size: str = None,
        proxy_id: str = None,
        proxy_name: str = None,
        region_no: str = None,
        status: str = None,
        vpc_id: str = None,
    ):
        self.lang = lang
        self.member_uid = member_uid
        self.nat_gateway_id = nat_gateway_id
        self.page_no = page_no
        self.page_size = page_size
        self.proxy_id = proxy_id
        self.proxy_name = proxy_name
        self.region_no = region_no
        self.status = status
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.proxy_id is not None:
            result['ProxyId'] = self.proxy_id
        if self.proxy_name is not None:
            result['ProxyName'] = self.proxy_name
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.status is not None:
            result['Status'] = self.status
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProxyId') is not None:
            self.proxy_id = m.get('ProxyId')
        if m.get('ProxyName') is not None:
            self.proxy_name = m.get('ProxyName')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DescribeSecurityProxyResponseBodyProxyList(TeaModel):
    def __init__(
        self,
        cidr_block: str = None,
        detail: str = None,
        member_uid: str = None,
        nat_gateway_id: str = None,
        nat_gateway_name: str = None,
        proxy_id: str = None,
        proxy_name: str = None,
        region_no: str = None,
        snat_ip_list: List[str] = None,
        status: str = None,
        strict_mode: int = None,
        v_switch_id: str = None,
        vpc_id: str = None,
        vpc_name: str = None,
    ):
        self.cidr_block = cidr_block
        self.detail = detail
        self.member_uid = member_uid
        self.nat_gateway_id = nat_gateway_id
        self.nat_gateway_name = nat_gateway_name
        self.proxy_id = proxy_id
        self.proxy_name = proxy_name
        self.region_no = region_no
        self.snat_ip_list = snat_ip_list
        self.status = status
        self.strict_mode = strict_mode
        self.v_switch_id = v_switch_id
        self.vpc_id = vpc_id
        self.vpc_name = vpc_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.detail is not None:
            result['Detail'] = self.detail
        if self.member_uid is not None:
            result['MemberUid'] = self.member_uid
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.nat_gateway_name is not None:
            result['NatGatewayName'] = self.nat_gateway_name
        if self.proxy_id is not None:
            result['ProxyId'] = self.proxy_id
        if self.proxy_name is not None:
            result['ProxyName'] = self.proxy_name
        if self.region_no is not None:
            result['RegionNo'] = self.region_no
        if self.snat_ip_list is not None:
            result['SnatIpList'] = self.snat_ip_list
        if self.status is not None:
            result['Status'] = self.status
        if self.strict_mode is not None:
            result['StrictMode'] = self.strict_mode
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vpc_name is not None:
            result['VpcName'] = self.vpc_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        if m.get('MemberUid') is not None:
            self.member_uid = m.get('MemberUid')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('NatGatewayName') is not None:
            self.nat_gateway_name = m.get('NatGatewayName')
        if m.get('ProxyId') is not None:
            self.proxy_id = m.get('ProxyId')
        if m.get('ProxyName') is not None:
            self.proxy_name = m.get('ProxyName')
        if m.get('RegionNo') is not None:
            self.region_no = m.get('RegionNo')
        if m.get('SnatIpList') is not None:
            self.snat_ip_list = m.get('SnatIpList')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StrictMode') is not None:
            self.strict_mode = m.get('StrictMode')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VpcName') is not None:
            self.vpc_name = m.get('VpcName')
        return self


class DescribeSecurityProxyResponseBody(TeaModel):
    def __init__(
        self,
        proxy_list: List[DescribeSecurityProxyResponseBodyProxyList] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.proxy_list = proxy_list
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.proxy_list:
            for k in self.proxy_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ProxyList'] = []
        if self.proxy_list is not None:
            for k in self.proxy_list:
                result['ProxyList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.proxy_list = []
        if m.get('ProxyList') is not None:
            for k in m.get('ProxyList'):
                temp_model = DescribeSecurityProxyResponseBodyProxyList()
                self.proxy_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeSecurityProxyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSecurityProxyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSecurityProxyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSignatureLibVersionResponseBodyVersion(TeaModel):
    def __init__(
        self,
        type: str = None,
        update_time: int = None,
        version: str = None,
    ):
        # The type.
        # 
        # Valid values:
        # 
        # *   ips
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     Basic Rules and Virtual Patching
        # 
        #     <!-- -->
        # 
        #     .
        # 
        # *   intelligence
        # 
        #     <!-- -->
        # 
        #     :
        # 
        #     <!-- -->
        # 
        #     Threat Intelligence
        # 
        #     <!-- -->
        self.type = type
        # Update time.
        self.update_time = update_time
        # The version number.
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class DescribeSignatureLibVersionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        total_count: int = None,
        version: List[DescribeSignatureLibVersionResponseBodyVersion] = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count
        # The version information.
        self.version = version

    def validate(self):
        if self.version:
            for k in self.version:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['Version'] = []
        if self.version is not None:
            for k in self.version:
                result['Version'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.version = []
        if m.get('Version') is not None:
            for k in m.get('Version'):
                temp_model = DescribeSignatureLibVersionResponseBodyVersion()
                self.version.append(temp_model.from_map(k))
        return self


class DescribeSignatureLibVersionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSignatureLibVersionResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSignatureLibVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSlsAnalyzeOpenStatusRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeSlsAnalyzeOpenStatusResponseBody(TeaModel):
    def __init__(
        self,
        open_status: str = None,
        request_id: str = None,
    ):
        self.open_status = open_status
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.open_status is not None:
            result['OpenStatus'] = self.open_status
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OpenStatus') is not None:
            self.open_status = m.get('OpenStatus')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeSlsAnalyzeOpenStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSlsAnalyzeOpenStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSlsAnalyzeOpenStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeThreatIntelligenceSwitchResponseBodyCategoryList(TeaModel):
    def __init__(
        self,
        action: str = None,
        category_describe: str = None,
        category_id: str = None,
        category_name: str = None,
        category_parent_id: str = None,
        enable_status: int = None,
    ):
        self.action = action
        self.category_describe = category_describe
        self.category_id = category_id
        self.category_name = category_name
        self.category_parent_id = category_parent_id
        self.enable_status = enable_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action is not None:
            result['Action'] = self.action
        if self.category_describe is not None:
            result['CategoryDescribe'] = self.category_describe
        if self.category_id is not None:
            result['CategoryId'] = self.category_id
        if self.category_name is not None:
            result['CategoryName'] = self.category_name
        if self.category_parent_id is not None:
            result['CategoryParentId'] = self.category_parent_id
        if self.enable_status is not None:
            result['EnableStatus'] = self.enable_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Action') is not None:
            self.action = m.get('Action')
        if m.get('CategoryDescribe') is not None:
            self.category_describe = m.get('CategoryDescribe')
        if m.get('CategoryId') is not None:
            self.category_id = m.get('CategoryId')
        if m.get('CategoryName') is not None:
            self.category_name = m.get('CategoryName')
        if m.get('CategoryParentId') is not None:
            self.category_parent_id = m.get('CategoryParentId')
        if m.get('EnableStatus') is not None:
            self.enable_status = m.get('EnableStatus')
        return self


class DescribeThreatIntelligenceSwitchResponseBody(TeaModel):
    def __init__(
        self,
        category_list: List[DescribeThreatIntelligenceSwitchResponseBodyCategoryList] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.category_list = category_list
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.category_list:
            for k in self.category_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CategoryList'] = []
        if self.category_list is not None:
            for k in self.category_list:
                result['CategoryList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.category_list = []
        if m.get('CategoryList') is not None:
            for k in m.get('CategoryList'):
                temp_model = DescribeThreatIntelligenceSwitchResponseBodyCategoryList()
                self.category_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeThreatIntelligenceSwitchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeThreatIntelligenceSwitchResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeThreatIntelligenceSwitchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeTrFirewallPolicyBackUpAssociationListRequestCandidateList(TeaModel):
    def __init__(
        self,
        candidate_id: str = None,
        candidate_type: str = None,
    ):
        # The ID of the traffic redirection instance.
        self.candidate_id = candidate_id
        # The type of the traffic redirection instance.
        self.candidate_type = candidate_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.candidate_id is not None:
            result['CandidateId'] = self.candidate_id
        if self.candidate_type is not None:
            result['CandidateType'] = self.candidate_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CandidateId') is not None:
            self.candidate_id = m.get('CandidateId')
        if m.get('CandidateType') is not None:
            self.candidate_type = m.get('CandidateType')
        return self


class DescribeTrFirewallPolicyBackUpAssociationListRequest(TeaModel):
    def __init__(
        self,
        candidate_list: List[DescribeTrFirewallPolicyBackUpAssociationListRequestCandidateList] = None,
        firewall_id: str = None,
        lang: str = None,
        tr_firewall_route_policy_id: str = None,
    ):
        # The traffic redirection instances.
        self.candidate_list = candidate_list
        # The instance ID of the VPC firewall.
        self.firewall_id = firewall_id
        # The language of the content within the response. Valid values:
        # 
        # *   **zh** (default): Chinese
        # *   **en**: English
        self.lang = lang
        # The ID of the routing policy.
        self.tr_firewall_route_policy_id = tr_firewall_route_policy_id

    def validate(self):
        if self.candidate_list:
            for k in self.candidate_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CandidateList'] = []
        if self.candidate_list is not None:
            for k in self.candidate_list:
                result['CandidateList'].append(k.to_map() if k else None)
        if self.firewall_id is not None:
            result['FirewallId'] = self.firewall_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.tr_firewall_route_policy_id is not None:
            result['TrFirewallRoutePolicyId'] = self.tr_firewall_route_policy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.candidate_list = []
        if m.get('CandidateList') is not None:
            for k in m.get('CandidateList'):
                temp_model = DescribeTrFirewallPolicyBackUpAssociationListRequestCandidateList()
                self.candidate_list.append(temp_model.from_map(k))
        if m.get('FirewallId') is not None:
            self.firewall_id = m.get('FirewallId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('TrFirewallRoutePolicyId') is not None:
            self.tr_firewall_route_policy_id = m.get('TrFirewallRoutePolicyId')
        return self


class DescribeTrFirewallPolicyBackUpAssociationListShrinkRequest(TeaModel):
    def __init__(
        self,
        candidate_list_shrink: str = None,
        firewall_id: str = None,
        lang: str = None,
        tr_firewall_route_policy_id: str = None,
    ):
        # The traffic redirection instances.
        self.candidate_list_shrink = candidate_list_shrink
        # The instance ID of the VPC firewall.
        self.firewall_id = firewall_id
        # The language of the content within the response. Valid values:
        # 
        # *   **zh** (default): Chinese
        # *   **en**: English
        self.lang = lang
        # The ID of the routing policy.
        self.tr_firewall_route_policy_id = tr_firewall_route_policy_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.candidate_list_shrink is not None:
            result['CandidateList'] = self.candidate_list_shrink
        if self.firewall_id is not None:
            result['FirewallId'] = self.firewall_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.tr_firewall_route_policy_id is not None:
            result['TrFirewallRoutePolicyId'] = self.tr_firewall_route_policy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CandidateList') is not None:
            self.candidate_list_shrink = m.get('CandidateList')
        if m.get('FirewallId') is not None:
            self.firewall_id = m.get('FirewallId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('TrFirewallRoutePolicyId') is not None:
            self.tr_firewall_route_policy_id = m.get('TrFirewallRoutePolicyId')
        return self


class DescribeTrFirewallPolicyBackUpAssociationListResponseBodyPolicyAssociationBackupConfigs(TeaModel):
    def __init__(
        self,
        candidate_id: str = None,
        candidate_name: str = None,
        candidate_type: str = None,
        current_route_table_id: str = None,
        original_route_table_id: str = None,
    ):
        # The ID of the traffic redirection instance.
        self.candidate_id = candidate_id
        # The name of the traffic redirection instance.
        self.candidate_name = candidate_name
        # The type of the traffic redirection instance.
        self.candidate_type = candidate_type
        # The route table that is used after traffic redirection.
        self.current_route_table_id = current_route_table_id
        # The ID of the route table.
        self.original_route_table_id = original_route_table_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.candidate_id is not None:
            result['CandidateId'] = self.candidate_id
        if self.candidate_name is not None:
            result['CandidateName'] = self.candidate_name
        if self.candidate_type is not None:
            result['CandidateType'] = self.candidate_type
        if self.current_route_table_id is not None:
            result['CurrentRouteTableId'] = self.current_route_table_id
        if self.original_route_table_id is not None:
            result['OriginalRouteTableId'] = self.original_route_table_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CandidateId') is not None:
            self.candidate_id = m.get('CandidateId')
        if m.get('CandidateName') is not None:
            self.candidate_name = m.get('CandidateName')
        if m.get('CandidateType') is not None:
            self.candidate_type = m.get('CandidateType')
        if m.get('CurrentRouteTableId') is not None:
            self.current_route_table_id = m.get('CurrentRouteTableId')
        if m.get('OriginalRouteTableId') is not None:
            self.original_route_table_id = m.get('OriginalRouteTableId')
        return self


class DescribeTrFirewallPolicyBackUpAssociationListResponse