#!/usr/bin/env python
""" conjuguer - conjugaison des verbes francais
License: 3-clause BSD (see https://opensource.org/licenses/BSD-3-Clause)
Author: Hubert Tournier
"""

# Blank verb data structure:
blank_verb = {
    "Infinitif": {
        "Présent": "",
        "Passé": "",
    },
    "Indicatif": {
        "Présent": {
            "s": {
                "1": "",
                "2": "",
                "3": "",
            },
            "p": {
                "1": "",
                "2": "",
                "3": "",
            },
        },
        "Imparfait": {
            "s": {
                "1": "",
                "2": "",
                "3": "",
            },
            "p": {
                "1": "",
                "2": "",
                "3": "",
            },
        },
        "Passé simple": {
            "s": {
                "1": "",
                "2": "",
                "3": "",
            },
            "p": {
                "1": "",
                "2": "",
                "3": "",
            },
        },
        "Futur simple": {
            "s": {
                "1": "",
                "2": "",
                "3": "",
            },
            "p": {
                "1": "",
                "2": "",
                "3": "",
            },
        },
        "Passé composé": {
            "s": {
                "1": "",
                "2": "",
                "3": "",
            },
            "p": {
                "1": "",
                "2": "",
                "3": "",
            },
        },
        "Plus-que-parfait": {
            "s": {
                "1": "",
                "2": "",
                "3": "",
            },
            "p": {
                "1": "",
                "2": "",
                "3": "",
            },
        },
        "Passé antérieur": {
            "s": {
                "1": "",
                "2": "",
                "3": "",
            },
            "p": {
                "1": "",
                "2": "",
                "3": "",
            },
        },
        "Futur antérieur": {
            "s": {
                "1": "",
                "2": "",
                "3": "",
            },
            "p": {
                "1": "",
                "2": "",
                "3": "",
            },
        },
    },
    "Conditionnel": {
        "Présent": {
            "s": {
                "1": "",
                "2": "",
                "3": "",
            },
            "p": {
                "1": "",
                "2": "",
                "3": "",
            },
        },
        "Passé": {
            "s": {
                "1": "",
                "2": "",
                "3": "",
            },
            "p": {
                "1": "",
                "2": "",
                "3": "",
            },
        },
    },
    "Subjonctif": {
        "Présent": {
            "s": {
                "1": "",
                "2": "",
                "3": "",
            },
            "p": {
                "1": "",
                "2": "",
                "3": "",
            },
        },
        "Imparfait": {
            "s": {
                "1": "",
                "2": "",
                "3": "",
            },
            "p": {
                "1": "",
                "2": "",
                "3": "",
            },
        },
        "Passé": {
            "s": {
                "1": "",
                "2": "",
                "3": "",
            },
            "p": {
                "1": "",
                "2": "",
                "3": "",
            },
        },
        "Plus-que-parfait": {
            "s": {
                "1": "",
                "2": "",
                "3": "",
            },
            "p": {
                "1": "",
                "2": "",
                "3": "",
            },
        },
    },
    "Impératif": {
        "Présent": {
            "s": {
                "2": "",
            },
            "p": {
                "1": "",
                "2": "",
            },
        },
        "Passé": {
            "s": {
                "2": "",
            },
            "p": {
                "1": "",
                "2": "",
            },
        },
    },
    "Participe": {
        "Présent": "",
        "Passé": {
            "s": {
                "m": "",
                "f": "",
            },
            "p": {
                "m": "",
                "f": "",
            },
            "a": "",
        },
    },
    "Gérondif": {
        "Présent": "",
        "Passé": "",
    },
}
