__all__ = ('ScorePoint',)

from expressmoney.api import *


SERVICE = 'scoring'
APP = 'pdl_ru'


class ScoreCreateContract(Contract):
    user_id = serializers.IntegerField(min_value=1)
    order_id = serializers.IntegerField(min_value=1, allow_null=True)


class ScoreResponseContract(Contract):
    score = serializers.DecimalField(max_digits=3, decimal_places=2)


class ScoreID(ID):
    _service = SERVICE
    _app = APP
    _view_set = 'score'


class ScorePoint(ResponseMixin, CreatePointMixin, ContractPoint):
    _point_id = ScoreID()
    _create_contract = ScoreCreateContract
    _response_contract = ScoreResponseContract
