def config():
    return {
        "test_name": "test_sync_non_report_streams",
        "tap_name": "tap-twitter-ads",
        "type": "platform.twitter-ads",
        "properties": {
            "start_date": "TAP_TWITTER_ADS_START_DATE",
            "account_ids": "TAP_TWITTER_ADS_ACCOUNT_IDS",
            "attribution_window": "TAP_TWITTER_ADS_ATTRIBUTION_WINDOW",
            "with_deleted": "TAP_TWITTER_ADS_WITH_DELETED",
            "country_codes": "TAP_TWITTER_ADS_COUNTRY_CODES"
        },
        "credentials": {
            "consumer_key": "TAP_TWITTER_ADS_CONSUMER_KEY",
            "consumer_secret": "TAP_TWITTER_ADS_CONSUMER_SECRET",
            "access_token": "TAP_TWITTER_ADS_ACCESS_TOKEN",
            "access_token_secret": "TAP_TWITTER_ADS_ACCESS_TOKEN_SECRET",
        },
        "bookmark": {
            "bookmark_key": "accounts",
            "bookmark_timestamp": "2020-03-15T14:30:31+0000"
        },
        "streams": {
            "accounts": {"id"},
            "account_media": {"id"},
            "advertiser_business_categories": {"id"},
            "bidding_rules": {"currency"},
            "campaigns": {"id"},
            "cards_website": {"id"},
            "cards_video_website": {"id"},
            "cards_image_app_download": {"id"},
            "cards_video_app_download": {"id"},
            "cards_poll": {"id"},
            "cards_image_conversation": {"id"},
            "cards_video_conversation": {"id"},
            "cards_image_direct_message": {"id"},
            "cards_video_direct_message": {"id"},
            "content_categories": {"id"},
            "funding_instruments": {"id"},
            "iab_categories": {"id"},
            "line_items": {"id"},
            "targeting_criteria": {"line_item_id", "id"},
            "line_item_apps": {"id"},
            "media_creatives": {"id"},
            "preroll_call_to_actions": {"id"},
            "promoted_accounts": {"id"},
            "promoted_tweets": {"id"},
            "promotable_users": {"id"},
            "scheduled_promoted_tweets": {"id"},
            "tailored_audiences": {"id"},
            "targeting_app_store_categories": {"targeting_value"},
            "targeting_conversations": {"targeting_value"},
            "targeting_devices": {"targeting_value"},
            "targeting_events": {"targeting_value"},
            "targeting_interests": {"targeting_value"},
            "targeting_languages": {"targeting_value"},
            "targeting_locations": {"targeting_value"},
            "targeting_network_operators": {"targeting_value"},
            "targeting_platform_versions": {"targeting_value"},
            "targeting_platforms": {"targeting_value"},
            "targeting_tv_markets": {"locale"},
            "tweets": {"id"}
        },
        "exclude_streams": ["accounts",
                            "accounts_conversion_tags_hourly_report",
                            "campaigns_conversion_tags_daily_report",
                            "cards_image_app_download",
                            "cards_image_conversation",
                            "cards_image_direct_message",
                            "cards_poll",
                            "cards_video_app_download",
                            "cards_video_conversation",
                            "cards_video_direct_message",
                            "cards_video_website",
                            "cards_website",
                            "line_item_apps",
                            "line_items_conversion_tags_hourly_report",
                            "media_creatives",
                            "media_creatives_daily_report",
                            "preroll_call_to_actions",
                            "promotable_users",
                            "promoted_accounts",
                            "promoted_accounts_daily_report",
                            "scheduled_promoted_tweets",
                            "tailored_audiences",
                            "targeting_tv_shows"]
    }