<div align="center">

<img src="https://docs.getpropheto.com/logo-light.svg">

<p align="center">
  <a href="https://getpropheto.com/">Website</a> •
  <a href="https://docs.getpropheto.com/">Docs</a>
</p>

[![PyPI - Propheto Version](https://img.shields.io/pypi/v/zenml.svg?label=pip&logo=PyPI&logoColor=white)](https://pypi.org/project/propheto/)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/propheto)](https://pypi.org/project/propheto/)
[![PyPI Status](https://pepy.tech/badge/propheto)](https://pepy.tech/project/propheto)
![GitHub](https://img.shields.io/github/license/propheto-io/propheto)

</div>


# Propheto - Open ML Platform 

## Overview

Propheto is a flexible, high-performance framework for deploying, managing, and monitoring models. Using Propheto, data scientists can quickly and easily deploy their models as complete, fully functioning microservices. Propheto allows:

- Integration first to support all major data systems, ML frameworks, amd MLOps tools
- No vendor lock in so you can use all the tools and systems your team needs
- Real-time or batch prediction endpoints with minimal overhead and maximum parallelism
- Easy debugging, testing, and versioning for model pipelines
- Security first architecture with portability across cloud and on-prem environments
- Open-core but designed for enterprise (automated logging, monitoring, and documentation)

With only a few simple commands in their IDE (jupyter notebooks, VS Code, Pycharm, etc.) data scientists can deploy models in their cloud architecture with all of the logging, tracking, scaling, and reporting required.

The Propheto package works with all major system architectures so that it can easily integrate into the production data and software applications and can easily be managed by other DevOps or software engineering resources. However, Propheto also makes it such that data scientists can self-manage these resources without any burden and without working through these other teams.

Ready to get started? checkout our [Quickstart guide](https://docs.getpropheto.com/quickstart/) or [sample notebook](https://github.com/Propheto-io/propheto/blob/main/docs/Propheto%20Iris%20Classification.ipynb) to see Propheto in action.


## Installation
Propheto is hosted on [pypi](https://pypi.org/project/propheto/) and can be installed by simply using `pip`

```sh
pip install propheto
```

## Get in Touch
There are several ways to get in touch with us:

* Open an issue at: https://github.com/Propheto-op/propheto 
* Email us at: hello@propheto.io

## Contributing
Thanks so much for your interest in supporting our project. We welcome any contributions to Propheto. We will be putting together a contribution guide but in the meantime please feel free to reach out to us or submit PRs as you see fit.

## License
Propheto is licensed under Apache 2.0