# Adding extra residues

For demonstration purposes, we will add an FMOC residue to the CHARMM36m FF for which the parameters have been kindly supplied by Alexander van Teijlingen.

DataBaseT.crg and DataBaseT.siz are the main files where the charges and radii of atoms have to be added.

The new DataBaseT files will be generated by extend_db.py (tmp.crg and tmp.siz) provided one follows the steps describe below.

If you believe your residue could benefit other users please create a pull request on GitHub or send the new parameters to the developers directly.


### Add residue block to aa.rtp file

The lines should adhere to GROMACS .rtp file logic. Please use unique atom types to describe your residues in order to avoid clashes with previously declared atoms.
Adding the suffix _RESIDUE to the intended atom type should be enough.

```
# EXTRA RESIDUES

[ FMO ] ; - Alexander van Teijlingen 07-12-2020
 [ atoms ]
	C1	C1_FMO	-0.11	0
	H1	H1_FMO	0.135	1
	C2	C2_FMO	-0.11	2
	H2	H2_FMO	0.135	3
```


### Add atom types to ffnonbonded.itp

```
;
; EXTRA RESIDUES
; FMOC - Alexander van Teijlingen 07-12-2020
H1_FMO    1      1.0080  0.000  A  0.242003727796  0.12552
H2_FMO    1      1.0080  0.000  A  0.242003727796  0.12552
H3_FMO    1      1.0080  0.000  A  0.242003727796  0.12552
H4_FMO    1      1.0080  0.000  A  0.242003727796  0.12552
H7_FMO    1      1.0080  0.000  A  0.242003727796  0.12552
```


### Add placeholder info on DataBaseT_old.crg and DataBaseT_old.siz

```
  H1  FMO X.XXX
  H2  FMO X.XXX
  H3  FMO X.XXX
  H4  FMO X.XXX
  H7  FMO X.XXX
  H8  FMO X.XXX
```


### Run extend_db

```
python3 extend_db.py
```

New tmp.crg and tmp.siz have been generated. Please inspect them to check the new residue has been added at the bottom correctly. After the visual inspection, rename them DataBaseT.crg and DataBaseT.siz, respectively.

```
mv tmp.crg DataBaseT.crg
mv tmp.siz DataBaseT.siz
```


### Add residue to pdb2pqr

The residue also needs to be added to PDB2PQR's database of residues, so that is not discarded on the preprocessing step.

/pdb2pqr/dat/CHARMM.DAT
```

# FMOC - Alexander van Teijlingen 07-12-2020
FMO     C1    0.01  0.01    C1
FMO     H1    0.01  0.01    H1
FMO     C2    0.01  0.01    C2
FMO     H2    0.01  0.01    H2
```