"""
    Dropbox Sign API

    Dropbox Sign v3 API  # noqa: E501

    The version of the OpenAPI document: 3.0.0
    Contact: apisupport@hellosign.com
    Generated by: https://openapi-generator.tech
"""


import json  # noqa: F401
import re  # noqa: F401
import sys  # noqa: F401

from dropbox_sign import ApiClient
from dropbox_sign.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from dropbox_sign.exceptions import ApiAttributeError

def lazy_import():
    from dropbox_sign.models import SubFormFieldsPerDocumentCheckbox
    from dropbox_sign.models import SubFormFieldsPerDocumentCheckboxMerge
    from dropbox_sign.models import SubFormFieldsPerDocumentDateSigned
    from dropbox_sign.models import SubFormFieldsPerDocumentDropdown
    from dropbox_sign.models import SubFormFieldsPerDocumentHyperlink
    from dropbox_sign.models import SubFormFieldsPerDocumentInitials
    from dropbox_sign.models import SubFormFieldsPerDocumentRadio
    from dropbox_sign.models import SubFormFieldsPerDocumentSignature
    from dropbox_sign.models import SubFormFieldsPerDocumentText
    from dropbox_sign.models import SubFormFieldsPerDocumentTextMerge
    globals()['SubFormFieldsPerDocumentCheckbox'] = SubFormFieldsPerDocumentCheckbox
    globals()['SubFormFieldsPerDocumentCheckboxMerge'] = SubFormFieldsPerDocumentCheckboxMerge
    globals()['SubFormFieldsPerDocumentDateSigned'] = SubFormFieldsPerDocumentDateSigned
    globals()['SubFormFieldsPerDocumentDropdown'] = SubFormFieldsPerDocumentDropdown
    globals()['SubFormFieldsPerDocumentHyperlink'] = SubFormFieldsPerDocumentHyperlink
    globals()['SubFormFieldsPerDocumentInitials'] = SubFormFieldsPerDocumentInitials
    globals()['SubFormFieldsPerDocumentRadio'] = SubFormFieldsPerDocumentRadio
    globals()['SubFormFieldsPerDocumentSignature'] = SubFormFieldsPerDocumentSignature
    globals()['SubFormFieldsPerDocumentText'] = SubFormFieldsPerDocumentText
    globals()['SubFormFieldsPerDocumentTextMerge'] = SubFormFieldsPerDocumentTextMerge


class SubFormFieldsPerDocumentBase(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'document_index': (int,),  # noqa: E501
            'api_id': (str,),  # noqa: E501
            'height': (int,),  # noqa: E501
            'required': (bool,),  # noqa: E501
            'signer': (str,),  # noqa: E501
            'type': (str,),  # noqa: E501
            'width': (int,),  # noqa: E501
            'x': (int,),  # noqa: E501
            'y': (int,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'page': (int, none_type,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        lazy_import()
        val = {
            'checkbox': SubFormFieldsPerDocumentCheckbox,
            'checkbox-merge': SubFormFieldsPerDocumentCheckboxMerge,
            'date_signed': SubFormFieldsPerDocumentDateSigned,
            'dropdown': SubFormFieldsPerDocumentDropdown,
            'hyperlink': SubFormFieldsPerDocumentHyperlink,
            'initials': SubFormFieldsPerDocumentInitials,
            'radio': SubFormFieldsPerDocumentRadio,
            'signature': SubFormFieldsPerDocumentSignature,
            'text': SubFormFieldsPerDocumentText,
            'text-merge': SubFormFieldsPerDocumentTextMerge,
        }
        if not val:
            return None
        return {'type': val}


    attribute_map = {
        'document_index': 'document_index',  # noqa: E501
        'api_id': 'api_id',  # noqa: E501
        'height': 'height',  # noqa: E501
        'required': 'required',  # noqa: E501
        'signer': 'signer',  # noqa: E501
        'type': 'type',  # noqa: E501
        'width': 'width',  # noqa: E501
        'x': 'x',  # noqa: E501
        'y': 'y',  # noqa: E501
        'name': 'name',  # noqa: E501
        'page': 'page',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, document_index, api_id, height, required, signer, type, width, x, y, *args, **kwargs):  # noqa: E501
        """SubFormFieldsPerDocumentBase - a model defined in OpenAPI

        Args:
            document_index (int): Represents the integer index of the `file` or `file_url` document the field should be attached to.
            api_id (str): An identifier for the field that is unique across all documents in the request.
            height (int): Size of the field in pixels.
            required (bool): Whether this field is required.
            signer (str): Signer index identified by the offset in the signers parameter (0-based indexing), indicating which signer should fill out the field.  **NOTE**: If type is `text-merge` or `checkbox-merge`, you must set this to sender in order to use pre-filled data.
            type (str):
            width (int): Size of the field in pixels.
            x (int): Location coordinates of the field in pixels.
            y (int): Location coordinates of the field in pixels.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            name (str): Display name for the field.. [optional]  # noqa: E501
            page (int, none_type): Page in the document where the field should be placed (requires documents be PDF files).  - When the page number parameter is supplied, the API will use the new coordinate system. - Check out the differences between both [coordinate systems](https://faq.hellosign.com/hc/en-us/articles/217115577) and how to use them.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.document_index = document_index
        self.api_id = api_id
        self.height = height
        self.required = required
        self.signer = signer
        self.type = type
        self.width = width
        self.x = x
        self.y = y
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, document_index, api_id, height, required, signer, type, width, x, y, *args, **kwargs):  # noqa: E501
        """SubFormFieldsPerDocumentBase - a model defined in OpenAPI

        Args:
            document_index (int): Represents the integer index of the `file` or `file_url` document the field should be attached to.
            api_id (str): An identifier for the field that is unique across all documents in the request.
            height (int): Size of the field in pixels.
            required (bool): Whether this field is required.
            signer (str): Signer index identified by the offset in the signers parameter (0-based indexing), indicating which signer should fill out the field.  **NOTE**: If type is `text-merge` or `checkbox-merge`, you must set this to sender in order to use pre-filled data.
            type (str):
            width (int): Size of the field in pixels.
            x (int): Location coordinates of the field in pixels.
            y (int): Location coordinates of the field in pixels.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            name (str): Display name for the field.. [optional]  # noqa: E501
            page (int, none_type): Page in the document where the field should be placed (requires documents be PDF files).  - When the page number parameter is supplied, the API will use the new coordinate system. - Check out the differences between both [coordinate systems](https://faq.hellosign.com/hc/en-us/articles/217115577) and how to use them.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.document_index = document_index
        self.api_id = api_id
        self.height = height
        self.required = required
        self.signer = signer
        self.type = type
        self.width = width
        self.x = x
        self.y = y
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
