"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Connection = exports.ConnectionType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const aws_glue_1 = require("aws-cdk-lib/aws-glue");
/**
 * The type of the glue connection
 *
 * If you need to use a connection type that doesn't exist as a static member, you
 * can instantiate a `ConnectionType` object, e.g: `new ConnectionType('NEW_TYPE')`.
 */
class ConnectionType {
    constructor(name) {
        this.name = name;
    }
    /**
     * The connection type name as expected by Connection resource.
     */
    toString() {
        return this.name;
    }
}
exports.ConnectionType = ConnectionType;
_a = JSII_RTTI_SYMBOL_1;
ConnectionType[_a] = { fqn: "@aws-cdk/aws-glue-alpha.ConnectionType", version: "2.66.0-alpha.0" };
/**
 * Designates a connection to a database through Java Database Connectivity (JDBC).
 */
ConnectionType.JDBC = new ConnectionType('JDBC');
/**
 * Designates a connection to an Apache Kafka streaming platform.
 */
ConnectionType.KAFKA = new ConnectionType('KAFKA');
/**
 * Designates a connection to a MongoDB document database.
 */
ConnectionType.MONGODB = new ConnectionType('MONGODB');
/**
 * Designates a network connection to a data source within an Amazon Virtual Private Cloud environment (Amazon VPC).
 */
ConnectionType.NETWORK = new ConnectionType('NETWORK');
/**
 * An AWS Glue connection to a data source.
 */
class Connection extends cdk.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.connectionName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_glue_alpha_ConnectionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Connection);
            }
            throw error;
        }
        this.properties = props.properties || {};
        const physicalConnectionRequirements = props.subnet || props.securityGroups ? {
            availabilityZone: props.subnet ? props.subnet.availabilityZone : undefined,
            subnetId: props.subnet ? props.subnet.subnetId : undefined,
            securityGroupIdList: props.securityGroups ? props.securityGroups.map(sg => sg.securityGroupId) : undefined,
        } : undefined;
        const connectionResource = new aws_glue_1.CfnConnection(this, 'Resource', {
            catalogId: cdk.Stack.of(this).account,
            connectionInput: {
                connectionProperties: cdk.Lazy.any({ produce: () => Object.keys(this.properties).length > 0 ? this.properties : undefined }),
                connectionType: props.type.name,
                description: props.description,
                matchCriteria: props.matchCriteria,
                name: props.connectionName,
                physicalConnectionRequirements,
            },
        });
        const resourceName = this.getResourceNameAttribute(connectionResource.ref);
        this.connectionArn = Connection.buildConnectionArn(this, resourceName);
        this.connectionName = resourceName;
    }
    /**
     * Creates a Connection construct that represents an external connection.
     *
     * @param scope The scope creating construct (usually `this`).
     * @param id The construct's id.
     * @param connectionArn arn of external connection.
     */
    static fromConnectionArn(scope, id, connectionArn) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.connectionName = cdk.Arn.extractResourceName(connectionArn, 'connection');
                this.connectionArn = connectionArn;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Creates a Connection construct that represents an external connection.
     *
     * @param scope The scope creating construct (usually `this`).
     * @param id The construct's id.
     * @param connectionName name of external connection.
     */
    static fromConnectionName(scope, id, connectionName) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.connectionName = connectionName;
                this.connectionArn = Connection.buildConnectionArn(scope, connectionName);
            }
        }
        return new Import(scope, id);
    }
    static buildConnectionArn(scope, connectionName) {
        return cdk.Stack.of(scope).formatArn({
            service: 'glue',
            resource: 'connection',
            resourceName: connectionName,
        });
    }
    /**
     * Add additional connection parameters
     * @param key parameter key
     * @param value parameter value
     */
    addProperty(key, value) {
        this.properties[key] = value;
    }
}
exports.Connection = Connection;
_b = JSII_RTTI_SYMBOL_1;
Connection[_b] = { fqn: "@aws-cdk/aws-glue-alpha.Connection", version: "2.66.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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