"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
const ses = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-ses-receipt');
const ruleSet = new ses.ReceiptRuleSet(stack, 'RuleSet', {
    dropSpam: true
});
ruleSet.addRule('FirstRule', {
    receiptRuleName: 'FirstRule',
    recipients: ['cdk-ses-receipt-test@yopmail.com'],
    scanEnabled: true,
    tlsPolicy: ses.TlsPolicy.REQUIRE
});
ruleSet.addRule('SecondRule');
new ses.WhiteListReceiptFilter(stack, 'WhiteList', {
    ips: [
        '10.0.0.0/16'
    ]
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcucmVjZWlwdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImludGVnLnJlY2VpcHQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxxQ0FBc0M7QUFDdEMsOEJBQStCO0FBRS9CLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBRTFCLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUscUJBQXFCLENBQUMsQ0FBQztBQUV4RCxNQUFNLE9BQU8sR0FBRyxJQUFJLEdBQUcsQ0FBQyxjQUFjLENBQUMsS0FBSyxFQUFFLFNBQVMsRUFBRTtJQUN2RCxRQUFRLEVBQUUsSUFBSTtDQUNmLENBQUMsQ0FBQztBQUVILE9BQU8sQ0FBQyxPQUFPLENBQUMsV0FBVyxFQUFFO0lBQzNCLGVBQWUsRUFBRSxXQUFXO0lBQzVCLFVBQVUsRUFBRSxDQUFDLGtDQUFrQyxDQUFDO0lBQ2hELFdBQVcsRUFBRSxJQUFJO0lBQ2pCLFNBQVMsRUFBRSxHQUFHLENBQUMsU0FBUyxDQUFDLE9BQU87Q0FDakMsQ0FBQyxDQUFDO0FBRUgsT0FBTyxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUMsQ0FBQztBQUU5QixJQUFJLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxLQUFLLEVBQUUsV0FBVyxFQUFFO0lBQ2pELEdBQUcsRUFBRTtRQUNILGFBQWE7S0FDZDtDQUNGLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBjZGsgPSByZXF1aXJlKCdAYXdzLWNkay9jb3JlJyk7XG5pbXBvcnQgc2VzID0gcmVxdWlyZSgnLi4vbGliJyk7XG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5cbmNvbnN0IHN0YWNrID0gbmV3IGNkay5TdGFjayhhcHAsICdhd3MtY2RrLXNlcy1yZWNlaXB0Jyk7XG5cbmNvbnN0IHJ1bGVTZXQgPSBuZXcgc2VzLlJlY2VpcHRSdWxlU2V0KHN0YWNrLCAnUnVsZVNldCcsIHtcbiAgZHJvcFNwYW06IHRydWVcbn0pO1xuXG5ydWxlU2V0LmFkZFJ1bGUoJ0ZpcnN0UnVsZScsIHtcbiAgcmVjZWlwdFJ1bGVOYW1lOiAnRmlyc3RSdWxlJyxcbiAgcmVjaXBpZW50czogWydjZGstc2VzLXJlY2VpcHQtdGVzdEB5b3BtYWlsLmNvbSddLFxuICBzY2FuRW5hYmxlZDogdHJ1ZSxcbiAgdGxzUG9saWN5OiBzZXMuVGxzUG9saWN5LlJFUVVJUkVcbn0pO1xuXG5ydWxlU2V0LmFkZFJ1bGUoJ1NlY29uZFJ1bGUnKTtcblxubmV3IHNlcy5XaGl0ZUxpc3RSZWNlaXB0RmlsdGVyKHN0YWNrLCAnV2hpdGVMaXN0Jywge1xuICBpcHM6IFtcbiAgICAnMTAuMC4wLjAvMTYnXG4gIF1cbn0pO1xuIl19