# Copyright (c) 2012-2021, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 39.8.0


from troposphere import Tags

from . import AWSObject, AWSProperty
from .validators import boolean, integer


class CsvOptions(AWSProperty):
    props = {
        "Delimiter": (str, False),
        "HeaderRow": (boolean, False),
    }


class ExcelOptions(AWSProperty):
    props = {
        "HeaderRow": (boolean, False),
        "SheetIndexes": ([integer], False),
        "SheetNames": ([str], False),
    }


class JsonOptions(AWSProperty):
    props = {
        "MultiLine": (boolean, False),
    }


class FormatOptions(AWSProperty):
    props = {
        "Csv": (CsvOptions, False),
        "Excel": (ExcelOptions, False),
        "Json": (JsonOptions, False),
    }


class S3Location(AWSProperty):
    props = {
        "Bucket": (str, True),
        "Key": (str, False),
    }


class DataCatalogInputDefinition(AWSProperty):
    props = {
        "CatalogId": (str, False),
        "DatabaseName": (str, False),
        "TableName": (str, False),
        "TempDirectory": (S3Location, False),
    }


class DatabaseInputDefinition(AWSProperty):
    props = {
        "DatabaseTableName": (str, False),
        "GlueConnectionName": (str, False),
        "TempDirectory": (S3Location, False),
    }


class Input(AWSProperty):
    props = {
        "DataCatalogInputDefinition": (DataCatalogInputDefinition, False),
        "DatabaseInputDefinition": (DatabaseInputDefinition, False),
        "S3InputDefinition": (S3Location, False),
    }


class FilesLimit(AWSProperty):
    props = {
        "MaxFiles": (integer, True),
        "Order": (str, False),
        "OrderedBy": (str, False),
    }


class FilterValue(AWSProperty):
    props = {
        "Value": (str, True),
        "ValueReference": (str, True),
    }


class FilterExpression(AWSProperty):
    props = {
        "Expression": (str, True),
        "ValuesMap": ([FilterValue], True),
    }


class DatetimeOptions(AWSProperty):
    props = {
        "Format": (str, True),
        "LocaleCode": (str, False),
        "TimezoneOffset": (str, False),
    }


class DatasetParameter(AWSProperty):
    props = {
        "CreateColumn": (boolean, False),
        "DatetimeOptions": (DatetimeOptions, False),
        "Filter": (FilterExpression, False),
        "Name": (str, True),
        "Type": (str, True),
    }


class PathParameter(AWSProperty):
    props = {
        "DatasetParameter": (DatasetParameter, True),
        "PathParameterName": (str, True),
    }


class PathOptions(AWSProperty):
    props = {
        "FilesLimit": (FilesLimit, False),
        "LastModifiedDateCondition": (FilterExpression, False),
        "Parameters": ([PathParameter], False),
    }


class Dataset(AWSObject):
    resource_type = "AWS::DataBrew::Dataset"

    props = {
        "Format": (str, False),
        "FormatOptions": (FormatOptions, False),
        "Input": (Input, True),
        "Name": (str, True),
        "PathOptions": (PathOptions, False),
        "Tags": (Tags, False),
    }


class DatabaseTableOutputOptions(AWSProperty):
    props = {
        "TableName": (str, True),
        "TempDirectory": (S3Location, False),
    }


class S3TableOutputOptions(AWSProperty):
    props = {
        "Location": (S3Location, True),
    }


class DataCatalogOutput(AWSProperty):
    props = {
        "CatalogId": (str, False),
        "DatabaseName": (str, True),
        "DatabaseOptions": (DatabaseTableOutputOptions, False),
        "Overwrite": (boolean, False),
        "S3Options": (S3TableOutputOptions, False),
        "TableName": (str, True),
    }


class DatabaseOutput(AWSProperty):
    props = {
        "DatabaseOptions": (DatabaseTableOutputOptions, True),
        "DatabaseOutputMode": (str, False),
        "GlueConnectionName": (str, True),
    }


class JobSample(AWSProperty):
    props = {
        "Mode": (str, False),
        "Size": (integer, False),
    }


class CsvOutputOptions(AWSProperty):
    props = {
        "Delimiter": (str, False),
    }


class OutputFormatOptions(AWSProperty):
    props = {
        "Csv": (CsvOutputOptions, False),
    }


class Output(AWSProperty):
    props = {
        "CompressionFormat": (str, False),
        "Format": (str, False),
        "FormatOptions": (OutputFormatOptions, False),
        "Location": (S3Location, True),
        "Overwrite": (boolean, False),
        "PartitionColumns": ([str], False),
    }


class OutputLocation(AWSProperty):
    props = {
        "Bucket": (str, True),
        "Key": (str, False),
    }


class ColumnSelector(AWSProperty):
    props = {
        "Name": (str, False),
        "Regex": (str, False),
    }


class ParameterMap(AWSProperty):
    props = {}


class StatisticOverride(AWSProperty):
    props = {
        "Parameters": (ParameterMap, True),
        "Statistic": (str, True),
    }


class StatisticsConfiguration(AWSProperty):
    props = {
        "IncludedStatistics": ([str], False),
        "Overrides": ([StatisticOverride], False),
    }


class ColumnStatisticsConfiguration(AWSProperty):
    props = {
        "Selectors": ([ColumnSelector], False),
        "Statistics": (StatisticsConfiguration, True),
    }


class ProfileConfiguration(AWSProperty):
    props = {
        "ColumnStatisticsConfigurations": ([ColumnStatisticsConfiguration], False),
        "DatasetStatisticsConfiguration": (StatisticsConfiguration, False),
        "ProfileColumns": ([ColumnSelector], False),
    }


class Job(AWSObject):
    resource_type = "AWS::DataBrew::Job"

    props = {
        "DataCatalogOutputs": ([DataCatalogOutput], False),
        "DatabaseOutputs": ([DatabaseOutput], False),
        "DatasetName": (str, False),
        "EncryptionKeyArn": (str, False),
        "EncryptionMode": (str, False),
        "JobSample": (JobSample, False),
        "LogSubscription": (str, False),
        "MaxCapacity": (integer, False),
        "MaxRetries": (integer, False),
        "Name": (str, True),
        "OutputLocation": (OutputLocation, False),
        "Outputs": ([Output], False),
        "ProfileConfiguration": (ProfileConfiguration, False),
        "ProjectName": (str, False),
        "Recipe": (dict, False),
        "RoleArn": (str, True),
        "Tags": (Tags, False),
        "Timeout": (integer, False),
        "Type": (str, True),
    }


class Sample(AWSProperty):
    props = {
        "Size": (integer, False),
        "Type": (str, True),
    }


class Project(AWSObject):
    resource_type = "AWS::DataBrew::Project"

    props = {
        "DatasetName": (str, True),
        "Name": (str, True),
        "RecipeName": (str, True),
        "RoleArn": (str, True),
        "Sample": (Sample, False),
        "Tags": (Tags, False),
    }


class SecondaryInput(AWSProperty):
    props = {
        "DataCatalogInputDefinition": (DataCatalogInputDefinition, False),
        "S3InputDefinition": (S3Location, False),
    }


class RecipeParameters(AWSProperty):
    props = {
        "AggregateFunction": (str, False),
        "Base": (str, False),
        "CaseStatement": (str, False),
        "CategoryMap": (str, False),
        "CharsToRemove": (str, False),
        "CollapseConsecutiveWhitespace": (str, False),
        "ColumnDataType": (str, False),
        "ColumnRange": (str, False),
        "Count": (str, False),
        "CustomCharacters": (str, False),
        "CustomStopWords": (str, False),
        "CustomValue": (str, False),
        "DatasetsColumns": (str, False),
        "DateAddValue": (str, False),
        "DateTimeFormat": (str, False),
        "DateTimeParameters": (str, False),
        "DeleteOtherRows": (str, False),
        "Delimiter": (str, False),
        "EndPattern": (str, False),
        "EndPosition": (str, False),
        "EndValue": (str, False),
        "ExpandContractions": (str, False),
        "Exponent": (str, False),
        "FalseString": (str, False),
        "GroupByAggFunctionOptions": (str, False),
        "GroupByColumns": (str, False),
        "HiddenColumns": (str, False),
        "IgnoreCase": (str, False),
        "IncludeInSplit": (str, False),
        "Input": (dict, False),
        "Interval": (str, False),
        "IsText": (str, False),
        "JoinKeys": (str, False),
        "JoinType": (str, False),
        "LeftColumns": (str, False),
        "Limit": (str, False),
        "LowerBound": (str, False),
        "MapType": (str, False),
        "ModeType": (str, False),
        "MultiLine": (boolean, False),
        "NumRows": (str, False),
        "NumRowsAfter": (str, False),
        "NumRowsBefore": (str, False),
        "OrderByColumn": (str, False),
        "OrderByColumns": (str, False),
        "Other": (str, False),
        "Pattern": (str, False),
        "PatternOption1": (str, False),
        "PatternOption2": (str, False),
        "PatternOptions": (str, False),
        "Period": (str, False),
        "Position": (str, False),
        "RemoveAllPunctuation": (str, False),
        "RemoveAllQuotes": (str, False),
        "RemoveAllWhitespace": (str, False),
        "RemoveCustomCharacters": (str, False),
        "RemoveCustomValue": (str, False),
        "RemoveLeadingAndTrailingPunctuation": (str, False),
        "RemoveLeadingAndTrailingQuotes": (str, False),
        "RemoveLeadingAndTrailingWhitespace": (str, False),
        "RemoveLetters": (str, False),
        "RemoveNumbers": (str, False),
        "RemoveSourceColumn": (str, False),
        "RemoveSpecialCharacters": (str, False),
        "RightColumns": (str, False),
        "SampleSize": (str, False),
        "SampleType": (str, False),
        "SecondInput": (str, False),
        "SecondaryInputs": ([SecondaryInput], False),
        "SheetIndexes": ([integer], False),
        "SheetNames": ([str], False),
        "SourceColumn": (str, False),
        "SourceColumn1": (str, False),
        "SourceColumn2": (str, False),
        "SourceColumns": (str, False),
        "StartColumnIndex": (str, False),
        "StartPattern": (str, False),
        "StartPosition": (str, False),
        "StartValue": (str, False),
        "StemmingMode": (str, False),
        "StepCount": (str, False),
        "StepIndex": (str, False),
        "StopWordsMode": (str, False),
        "Strategy": (str, False),
        "TargetColumn": (str, False),
        "TargetColumnNames": (str, False),
        "TargetDateFormat": (str, False),
        "TargetIndex": (str, False),
        "TimeZone": (str, False),
        "TokenizerPattern": (str, False),
        "TrueString": (str, False),
        "UdfLang": (str, False),
        "Units": (str, False),
        "UnpivotColumn": (str, False),
        "UpperBound": (str, False),
        "UseNewDataFrame": (str, False),
        "Value": (str, False),
        "Value1": (str, False),
        "Value2": (str, False),
        "ValueColumn": (str, False),
        "ViewFrame": (str, False),
    }


class Action(AWSProperty):
    props = {
        "Operation": (str, True),
        "Parameters": (RecipeParameters, False),
    }


class ConditionExpression(AWSProperty):
    props = {
        "Condition": (str, True),
        "TargetColumn": (str, True),
        "Value": (str, False),
    }


class RecipeStep(AWSProperty):
    props = {
        "Action": (Action, True),
        "ConditionExpressions": ([ConditionExpression], False),
    }


class Recipe(AWSObject):
    resource_type = "AWS::DataBrew::Recipe"

    props = {
        "Description": (str, False),
        "Name": (str, True),
        "Steps": ([RecipeStep], True),
        "Tags": (Tags, False),
    }


class Schedule(AWSObject):
    resource_type = "AWS::DataBrew::Schedule"

    props = {
        "CronExpression": (str, True),
        "JobNames": ([str], False),
        "Name": (str, True),
        "Tags": (Tags, False),
    }
