# Copyright (c) 2012-2021, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 31.0.0


from . import AWSObject, AWSProperty, Tags
from .compat import policytypes


class PublicRepository(AWSObject):
    resource_type = "AWS::ECR::PublicRepository"

    props = {
        "RepositoryCatalogData": (dict, False),
        "RepositoryName": (str, False),
        "RepositoryPolicyText": (policytypes, False),
        "Tags": (Tags, False),
    }


class RegistryPolicy(AWSObject):
    resource_type = "AWS::ECR::RegistryPolicy"

    props = {
        "PolicyText": (policytypes, True),
    }


class ReplicationDestination(AWSProperty):
    props = {
        "Region": (str, True),
        "RegistryId": (str, True),
    }


class RepositoryFilter(AWSProperty):
    props = {
        "Filter": (str, True),
        "FilterType": (str, True),
    }


class ReplicationRule(AWSProperty):
    props = {
        "Destinations": ([ReplicationDestination], True),
        "RepositoryFilters": ([RepositoryFilter], True),
    }


class ReplicationConfigurationProperty(AWSProperty):
    props = {
        "Rules": ([ReplicationRule], True),
    }


class ReplicationConfiguration(AWSObject):
    resource_type = "AWS::ECR::ReplicationConfiguration"

    props = {
        "ReplicationConfigurationProperty": (ReplicationConfigurationProperty, True),
    }


class EncryptionConfiguration(AWSProperty):
    props = {
        "EncryptionType": (str, True),
        "KmsKey": (str, False),
    }


class LifecyclePolicy(AWSProperty):
    props = {
        "LifecyclePolicyText": (str, False),
        "RegistryId": (str, False),
    }


class ImageScanningConfiguration(AWSProperty):
    props = {
        "ScanOnPush": (bool, False),
    }


class Repository(AWSObject):
    resource_type = "AWS::ECR::Repository"

    props = {
        "EncryptionConfiguration": (EncryptionConfiguration, False),
        "ImageScanningConfiguration": (ImageScanningConfiguration, False),
        "ImageTagMutability": (str, False),
        "LifecyclePolicy": (LifecyclePolicy, False),
        "RepositoryName": (str, False),
        "RepositoryPolicyText": (policytypes, False),
        "Tags": (Tags, False),
    }
