# Copyright (c) 2012-2021, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 39.1.0


from troposphere import Tags

from . import AWSObject, AWSProperty
from .validators import boolean, double, integer


class RoutingStrategy(AWSProperty):
    props = {
        "FleetId": (str, False),
        "Message": (str, False),
        "Type": (str, True),
    }


class Alias(AWSObject):
    resource_type = "AWS::GameLift::Alias"

    props = {
        "Description": (str, False),
        "Name": (str, True),
        "RoutingStrategy": (RoutingStrategy, True),
    }


class S3Location(AWSProperty):
    props = {
        "Bucket": (str, True),
        "Key": (str, True),
        "ObjectVersion": (str, False),
        "RoleArn": (str, True),
    }


class Build(AWSObject):
    resource_type = "AWS::GameLift::Build"

    props = {
        "Name": (str, False),
        "OperatingSystem": (str, False),
        "StorageLocation": (S3Location, False),
        "Version": (str, False),
    }


class CertificateConfiguration(AWSProperty):
    props = {
        "CertificateType": (str, True),
    }


class IpPermission(AWSProperty):
    props = {
        "FromPort": (integer, True),
        "IpRange": (str, True),
        "Protocol": (str, True),
        "ToPort": (integer, True),
    }


class LocationCapacity(AWSProperty):
    props = {
        "DesiredEC2Instances": (integer, True),
        "MaxSize": (integer, True),
        "MinSize": (integer, True),
    }


class LocationConfiguration(AWSProperty):
    props = {
        "Location": (str, True),
        "LocationCapacity": (LocationCapacity, False),
    }


class ResourceCreationLimitPolicy(AWSProperty):
    props = {
        "NewGameSessionsPerCreator": (integer, False),
        "PolicyPeriodInMinutes": (integer, False),
    }


class ServerProcess(AWSProperty):
    props = {
        "ConcurrentExecutions": (integer, True),
        "LaunchPath": (str, True),
        "Parameters": (str, False),
    }


class RuntimeConfiguration(AWSProperty):
    props = {
        "GameSessionActivationTimeoutSeconds": (integer, False),
        "MaxConcurrentGameSessionActivations": (integer, False),
        "ServerProcesses": ([ServerProcess], False),
    }


class Fleet(AWSObject):
    resource_type = "AWS::GameLift::Fleet"

    props = {
        "BuildId": (str, False),
        "CertificateConfiguration": (CertificateConfiguration, False),
        "Description": (str, False),
        "DesiredEC2Instances": (integer, False),
        "EC2InboundPermissions": ([IpPermission], False),
        "EC2InstanceType": (str, False),
        "FleetType": (str, False),
        "InstanceRoleARN": (str, False),
        "Locations": ([LocationConfiguration], False),
        "MaxSize": (integer, False),
        "MetricGroups": ([str], False),
        "MinSize": (integer, False),
        "Name": (str, False),
        "NewGameSessionProtectionPolicy": (str, False),
        "PeerVpcAwsAccountId": (str, False),
        "PeerVpcId": (str, False),
        "ResourceCreationLimitPolicy": (ResourceCreationLimitPolicy, False),
        "RuntimeConfiguration": (RuntimeConfiguration, False),
        "ScriptId": (str, False),
    }


class TargetTrackingConfiguration(AWSProperty):
    props = {
        "TargetValue": (double, True),
    }


class AutoScalingPolicy(AWSProperty):
    props = {
        "EstimatedInstanceWarmup": (double, False),
        "TargetTrackingConfiguration": (TargetTrackingConfiguration, True),
    }


class InstanceDefinition(AWSProperty):
    props = {
        "InstanceType": (str, True),
        "WeightedCapacity": (str, False),
    }


class LaunchTemplate(AWSProperty):
    props = {
        "LaunchTemplateId": (str, False),
        "LaunchTemplateName": (str, False),
        "Version": (str, False),
    }


class GameServerGroup(AWSObject):
    resource_type = "AWS::GameLift::GameServerGroup"

    props = {
        "AutoScalingPolicy": (AutoScalingPolicy, False),
        "BalancingStrategy": (str, False),
        "DeleteOption": (str, False),
        "GameServerGroupName": (str, True),
        "GameServerProtectionPolicy": (str, False),
        "InstanceDefinitions": ([InstanceDefinition], True),
        "LaunchTemplate": (LaunchTemplate, True),
        "MaxSize": (double, False),
        "MinSize": (double, False),
        "RoleArn": (str, True),
        "Tags": (Tags, False),
        "VpcSubnets": ([str], False),
    }


class Destination(AWSProperty):
    props = {
        "DestinationArn": (str, False),
    }


class FilterConfiguration(AWSProperty):
    props = {
        "AllowedLocations": ([str], False),
    }


class PlayerLatencyPolicy(AWSProperty):
    props = {
        "MaximumIndividualPlayerLatencyMilliseconds": (integer, False),
        "PolicyDurationSeconds": (integer, False),
    }


class PriorityConfiguration(AWSProperty):
    props = {
        "LocationOrder": ([str], False),
        "PriorityOrder": ([str], False),
    }


class GameSessionQueue(AWSObject):
    resource_type = "AWS::GameLift::GameSessionQueue"

    props = {
        "CustomEventData": (str, False),
        "Destinations": ([Destination], False),
        "FilterConfiguration": (FilterConfiguration, False),
        "Name": (str, True),
        "NotificationTarget": (str, False),
        "PlayerLatencyPolicies": ([PlayerLatencyPolicy], False),
        "PriorityConfiguration": (PriorityConfiguration, False),
        "TimeoutInSeconds": (integer, False),
    }


class GameProperty(AWSProperty):
    props = {
        "Key": (str, True),
        "Value": (str, True),
    }


class MatchmakingConfiguration(AWSObject):
    resource_type = "AWS::GameLift::MatchmakingConfiguration"

    props = {
        "AcceptanceRequired": (boolean, True),
        "AcceptanceTimeoutSeconds": (integer, False),
        "AdditionalPlayerCount": (integer, False),
        "BackfillMode": (str, False),
        "CustomEventData": (str, False),
        "Description": (str, False),
        "FlexMatchMode": (str, False),
        "GameProperties": ([GameProperty], False),
        "GameSessionData": (str, False),
        "GameSessionQueueArns": ([str], False),
        "Name": (str, True),
        "NotificationTarget": (str, False),
        "RequestTimeoutSeconds": (integer, True),
        "RuleSetName": (str, True),
    }


class MatchmakingRuleSet(AWSObject):
    resource_type = "AWS::GameLift::MatchmakingRuleSet"

    props = {
        "Name": (str, True),
        "RuleSetBody": (str, True),
    }


class Script(AWSObject):
    resource_type = "AWS::GameLift::Script"

    props = {
        "Name": (str, False),
        "StorageLocation": (S3Location, True),
        "Version": (str, False),
    }
