# Copyright (c) 2012-2021, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 43.1.0


from troposphere import Tags

from . import AWSObject, AWSProperty
from .validators import boolean, integer


class ACL(AWSObject):
    resource_type = "AWS::MemoryDB::ACL"

    props = {
        "ACLName": (str, True),
        "Tags": (Tags, False),
        "UserNames": ([str], False),
    }


class Endpoint(AWSProperty):
    props = {
        "Address": (str, False),
        "Port": (integer, False),
    }


class Cluster(AWSObject):
    resource_type = "AWS::MemoryDB::Cluster"

    props = {
        "ACLName": (str, False),
        "AutoMinorVersionUpgrade": (boolean, False),
        "ClusterEndpoint": (Endpoint, False),
        "ClusterName": (str, True),
        "Description": (str, False),
        "EngineVersion": (str, False),
        "FinalSnapshotName": (str, False),
        "KmsKeyId": (str, False),
        "MaintenanceWindow": (str, False),
        "NodeType": (str, False),
        "NumReplicasPerShard": (integer, False),
        "NumShards": (integer, False),
        "ParameterGroupName": (str, False),
        "Port": (integer, False),
        "SecurityGroupIds": ([str], False),
        "SnapshotArns": ([str], False),
        "SnapshotName": (str, False),
        "SnapshotRetentionLimit": (integer, False),
        "SnapshotWindow": (str, False),
        "SnsTopicArn": (str, False),
        "SnsTopicStatus": (str, False),
        "SubnetGroupName": (str, False),
        "TLSEnabled": (boolean, False),
        "Tags": (Tags, False),
    }


class ParameterGroup(AWSObject):
    resource_type = "AWS::MemoryDB::ParameterGroup"

    props = {
        "Description": (str, False),
        "Family": (str, False),
        "ParameterGroupName": (str, True),
        "Parameters": (dict, False),
        "Tags": (Tags, False),
    }


class SubnetGroup(AWSObject):
    resource_type = "AWS::MemoryDB::SubnetGroup"

    props = {
        "Description": (str, False),
        "SubnetGroupName": (str, True),
        "SubnetIds": ([str], False),
        "Tags": (Tags, False),
    }


class User(AWSObject):
    resource_type = "AWS::MemoryDB::User"

    props = {
        "AccessString": (str, True),
        "AuthenticationMode": (dict, True),
        "Tags": (Tags, False),
        "UserName": (str, True),
    }
