# Copyright (c) 2012-2021, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 43.1.0


import re

from troposphere import Tags

from . import AWSObject, AWSProperty
from .validators import boolean, integer


def validate_search_service_engine_version(engine_version):
    """Validate Engine Version for OpenSearchServiceDomain. The value must be in the format OpenSearch_X.Y or Elasticsearch_X.Y"""
    engine_version_check = re.compile(r"^(OpenSearch_|Elasticsearch_)\d{1,5}.\d{1,5}")
    if engine_version_check.match(engine_version) is None:
        raise ValueError(
            "OpenSearch EngineVersion must be in the format OpenSearch_X.Y or Elasticsearch_X.Y"
        )
    return engine_version


class MasterUserOptions(AWSProperty):
    props = {
        "MasterUserARN": (str, False),
        "MasterUserName": (str, False),
        "MasterUserPassword": (str, False),
    }


class AdvancedSecurityOptionsInput(AWSProperty):
    props = {
        "Enabled": (boolean, False),
        "InternalUserDatabaseEnabled": (boolean, False),
        "MasterUserOptions": (MasterUserOptions, False),
    }


class ZoneAwarenessConfig(AWSProperty):
    props = {
        "AvailabilityZoneCount": (integer, False),
    }


class ClusterConfig(AWSProperty):
    props = {
        "DedicatedMasterCount": (integer, False),
        "DedicatedMasterEnabled": (boolean, False),
        "DedicatedMasterType": (str, False),
        "InstanceCount": (integer, False),
        "InstanceType": (str, False),
        "WarmCount": (integer, False),
        "WarmEnabled": (boolean, False),
        "WarmType": (str, False),
        "ZoneAwarenessConfig": (ZoneAwarenessConfig, False),
        "ZoneAwarenessEnabled": (boolean, False),
    }


class CognitoOptions(AWSProperty):
    props = {
        "Enabled": (boolean, False),
        "IdentityPoolId": (str, False),
        "RoleArn": (str, False),
        "UserPoolId": (str, False),
    }


class DomainEndpointOptions(AWSProperty):
    props = {
        "CustomEndpoint": (str, False),
        "CustomEndpointCertificateArn": (str, False),
        "CustomEndpointEnabled": (boolean, False),
        "EnforceHTTPS": (boolean, False),
        "TLSSecurityPolicy": (str, False),
    }


class EBSOptions(AWSProperty):
    props = {
        "EBSEnabled": (boolean, False),
        "Iops": (integer, False),
        "VolumeSize": (integer, False),
        "VolumeType": (str, False),
    }


class EncryptionAtRestOptions(AWSProperty):
    props = {
        "Enabled": (boolean, False),
        "KmsKeyId": (str, False),
    }


class NodeToNodeEncryptionOptions(AWSProperty):
    props = {
        "Enabled": (boolean, False),
    }


class SnapshotOptions(AWSProperty):
    props = {
        "AutomatedSnapshotStartHour": (integer, False),
    }


class VPCOptions(AWSProperty):
    props = {
        "SecurityGroupIds": ([str], False),
        "SubnetIds": ([str], False),
    }


class Domain(AWSObject):
    resource_type = "AWS::OpenSearchService::Domain"

    props = {
        "AccessPolicies": (dict, False),
        "AdvancedOptions": (dict, False),
        "AdvancedSecurityOptions": (AdvancedSecurityOptionsInput, False),
        "ClusterConfig": (ClusterConfig, False),
        "CognitoOptions": (CognitoOptions, False),
        "DomainEndpointOptions": (DomainEndpointOptions, False),
        "DomainName": (str, False),
        "EBSOptions": (EBSOptions, False),
        "EncryptionAtRestOptions": (EncryptionAtRestOptions, False),
        "EngineVersion": (validate_search_service_engine_version, False),
        "LogPublishingOptions": (dict, False),
        "NodeToNodeEncryptionOptions": (NodeToNodeEncryptionOptions, False),
        "SnapshotOptions": (SnapshotOptions, False),
        "Tags": (Tags, False),
        "VPCOptions": (VPCOptions, False),
    }
