# Copyright (c) 2012-2021, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 40.0.0


from troposphere import Tags

from . import AWSObject, AWSProperty
from .validators import boolean, integer


class Endpoint(AWSProperty):
    props = {
        "Address": (str, False),
        "Port": (str, False),
    }


class LoggingProperties(AWSProperty):
    props = {
        "BucketName": (str, True),
        "S3KeyPrefix": (str, False),
    }


class Cluster(AWSObject):
    resource_type = "AWS::Redshift::Cluster"

    props = {
        "AllowVersionUpgrade": (boolean, False),
        "AquaConfigurationStatus": (str, False),
        "AutomatedSnapshotRetentionPeriod": (integer, False),
        "AvailabilityZone": (str, False),
        "AvailabilityZoneRelocation": (boolean, False),
        "AvailabilityZoneRelocationStatus": (str, False),
        "Classic": (boolean, False),
        "ClusterIdentifier": (str, False),
        "ClusterParameterGroupName": (str, False),
        "ClusterSecurityGroups": ([str], False),
        "ClusterSubnetGroupName": (str, False),
        "ClusterType": (str, True),
        "ClusterVersion": (str, False),
        "DBName": (str, True),
        "DeferMaintenance": (boolean, False),
        "DeferMaintenanceDuration": (integer, False),
        "DeferMaintenanceEndTime": (str, False),
        "DeferMaintenanceIdentifier": (str, False),
        "DeferMaintenanceStartTime": (str, False),
        "DestinationRegion": (str, False),
        "ElasticIp": (str, False),
        "Encrypted": (boolean, False),
        "Endpoint": (Endpoint, False),
        "EnhancedVpcRouting": (boolean, False),
        "HsmClientCertificateIdentifier": (str, False),
        "HsmConfigurationIdentifier": (str, False),
        "IamRoles": ([str], False),
        "KmsKeyId": (str, False),
        "LoggingProperties": (LoggingProperties, False),
        "MaintenanceTrackName": (str, False),
        "ManualSnapshotRetentionPeriod": (integer, False),
        "MasterUserPassword": (str, True),
        "MasterUsername": (str, True),
        "NodeType": (str, True),
        "NumberOfNodes": (integer, False),
        "OwnerAccount": (str, False),
        "Port": (integer, False),
        "PreferredMaintenanceWindow": (str, False),
        "PubliclyAccessible": (boolean, False),
        "ResourceAction": (str, False),
        "RevisionTarget": (str, False),
        "RotateEncryptionKey": (boolean, False),
        "SnapshotClusterIdentifier": (str, False),
        "SnapshotCopyGrantName": (str, False),
        "SnapshotCopyManual": (boolean, False),
        "SnapshotCopyRetentionPeriod": (integer, False),
        "SnapshotIdentifier": (str, False),
        "Tags": (Tags, False),
        "VpcSecurityGroupIds": ([str], False),
    }


class AmazonRedshiftParameter(AWSProperty):
    props = {
        "ParameterName": (str, True),
        "ParameterValue": (str, True),
    }


class ClusterParameterGroup(AWSObject):
    resource_type = "AWS::Redshift::ClusterParameterGroup"

    props = {
        "Description": (str, True),
        "ParameterGroupFamily": (str, True),
        "Parameters": ([AmazonRedshiftParameter], False),
        "Tags": (Tags, False),
    }


class ClusterSecurityGroup(AWSObject):
    resource_type = "AWS::Redshift::ClusterSecurityGroup"

    props = {
        "Description": (str, True),
        "Tags": (Tags, False),
    }


class ClusterSecurityGroupIngress(AWSObject):
    resource_type = "AWS::Redshift::ClusterSecurityGroupIngress"

    props = {
        "CIDRIP": (str, False),
        "ClusterSecurityGroupName": (str, True),
        "EC2SecurityGroupName": (str, False),
        "EC2SecurityGroupOwnerId": (str, False),
    }


class ClusterSubnetGroup(AWSObject):
    resource_type = "AWS::Redshift::ClusterSubnetGroup"

    props = {
        "Description": (str, True),
        "SubnetIds": ([str], True),
        "Tags": (Tags, False),
    }
