# Copyright (c) 2012-2021, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 39.8.0


from . import AWSObject, AWSProperty
from .validators import boolean, integer


class Cluster(AWSObject):
    resource_type = "AWS::Route53RecoveryControl::Cluster"

    props = {
        "Name": (str, False),
    }


class ControlPanel(AWSObject):
    resource_type = "AWS::Route53RecoveryControl::ControlPanel"

    props = {
        "ClusterArn": (str, False),
        "Name": (str, True),
    }


class RoutingControl(AWSObject):
    resource_type = "AWS::Route53RecoveryControl::RoutingControl"

    props = {
        "ClusterArn": (str, False),
        "ControlPanelArn": (str, False),
        "Name": (str, True),
    }


class AssertionRule(AWSProperty):
    props = {
        "AssertedControls": ([str], True),
        "WaitPeriodMs": (integer, True),
    }


class GatingRule(AWSProperty):
    props = {
        "GatingControls": ([str], True),
        "TargetControls": ([str], True),
        "WaitPeriodMs": (integer, True),
    }


class RuleConfig(AWSProperty):
    props = {
        "Inverted": (boolean, True),
        "Threshold": (integer, True),
        "Type": (str, True),
    }


class SafetyRule(AWSObject):
    resource_type = "AWS::Route53RecoveryControl::SafetyRule"

    props = {
        "AssertionRule": (AssertionRule, False),
        "ControlPanelArn": (str, True),
        "GatingRule": (GatingRule, False),
        "Name": (str, True),
        "RuleConfig": (RuleConfig, True),
    }
