# Copyright (c) 2012-2021, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 39.8.0


from troposphere import Tags

from . import AWSObject, AWSProperty


class Cell(AWSObject):
    resource_type = "AWS::Route53RecoveryReadiness::Cell"

    props = {
        "CellName": (str, True),
        "Cells": ([str], False),
        "Tags": (Tags, False),
    }


class ReadinessCheck(AWSObject):
    resource_type = "AWS::Route53RecoveryReadiness::ReadinessCheck"

    props = {
        "ReadinessCheckName": (str, True),
        "ResourceSetName": (str, False),
        "Tags": (Tags, False),
    }


class RecoveryGroup(AWSObject):
    resource_type = "AWS::Route53RecoveryReadiness::RecoveryGroup"

    props = {
        "Cells": ([str], False),
        "RecoveryGroupName": (str, True),
        "Tags": (Tags, False),
    }


class NLBResource(AWSProperty):
    props = {
        "Arn": (str, False),
    }


class R53ResourceRecord(AWSProperty):
    props = {
        "DomainName": (str, False),
        "RecordSetId": (str, False),
    }


class TargetResource(AWSProperty):
    props = {
        "NLBResource": (NLBResource, False),
        "R53Resource": (R53ResourceRecord, False),
    }


class DNSTargetResource(AWSProperty):
    props = {
        "DomainName": (str, False),
        "HostedZoneArn": (str, False),
        "RecordSetId": (str, False),
        "RecordType": (str, False),
        "TargetResource": (TargetResource, False),
    }


class Resource(AWSProperty):
    props = {
        "ComponentId": (str, False),
        "DnsTargetResource": (DNSTargetResource, False),
        "ReadinessScopes": ([str], False),
        "ResourceArn": (str, False),
    }


class ResourceSet(AWSObject):
    resource_type = "AWS::Route53RecoveryReadiness::ResourceSet"

    props = {
        "ResourceSetName": (str, True),
        "ResourceSetType": (str, True),
        "Resources": ([Resource], True),
        "Tags": (Tags, False),
    }
