# Copyright (c) 2012-2021, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 39.8.0


from troposphere import Tags

from . import AWSObject, AWSProperty
from .validators import integer


class VpcConfiguration(AWSProperty):
    props = {
        "VpcId": (str, False),
    }


class AccessPoint(AWSObject):
    resource_type = "AWS::S3Outposts::AccessPoint"

    props = {
        "Bucket": (str, True),
        "Name": (str, True),
        "Policy": (dict, False),
        "VpcConfiguration": (VpcConfiguration, True),
    }


class AbortIncompleteMultipartUpload(AWSProperty):
    props = {
        "DaysAfterInitiation": (integer, True),
    }


class Rule(AWSProperty):
    props = {
        "AbortIncompleteMultipartUpload": (AbortIncompleteMultipartUpload, False),
        "ExpirationDate": (str, False),
        "ExpirationInDays": (integer, False),
        "Filter": (dict, False),
        "Id": (str, False),
        "Status": (str, False),
    }


class LifecycleConfiguration(AWSProperty):
    props = {
        "Rules": ([Rule], True),
    }


class Bucket(AWSObject):
    resource_type = "AWS::S3Outposts::Bucket"

    props = {
        "BucketName": (str, True),
        "LifecycleConfiguration": (LifecycleConfiguration, False),
        "OutpostId": (str, True),
        "Tags": (Tags, False),
    }


class BucketPolicy(AWSObject):
    resource_type = "AWS::S3Outposts::BucketPolicy"

    props = {
        "Bucket": (str, True),
        "PolicyDocument": (dict, True),
    }


class Endpoint(AWSObject):
    resource_type = "AWS::S3Outposts::Endpoint"

    props = {
        "AccessType": (str, False),
        "CustomerOwnedIpv4Pool": (str, False),
        "OutpostId": (str, True),
        "SecurityGroupId": (str, True),
        "SubnetId": (str, True),
    }
