# Copyright (c) 2012-2021, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 39.1.0


from troposphere import Tags

from . import AWSObject, AWSProperty
from .validators import boolean, integer


class RegionConfiguration(AWSProperty):
    props = {
        "SseKmsKeyId": (str, True),
    }


class ReplicationRegion(AWSProperty):
    props = {
        "RegionConfiguration": (RegionConfiguration, False),
        "RegionName": (str, False),
    }


class ReplicationSet(AWSObject):
    resource_type = "AWS::SSMIncidents::ReplicationSet"

    props = {
        "DeletionProtected": (boolean, False),
        "Regions": ([ReplicationRegion], True),
    }


class SsmParameter(AWSProperty):
    props = {
        "Key": (str, True),
        "Values": ([str], True),
    }


class SsmAutomation(AWSProperty):
    props = {
        "DocumentName": (str, True),
        "DocumentVersion": (str, False),
        "Parameters": ([SsmParameter], False),
        "RoleArn": (str, True),
        "TargetAccount": (str, False),
    }


class Action(AWSProperty):
    props = {
        "SsmAutomation": (SsmAutomation, False),
    }


class ChatChannel(AWSProperty):
    props = {
        "ChatbotSns": ([str], False),
    }


class NotificationTargetItem(AWSProperty):
    props = {
        "SnsTopicArn": (str, False),
    }


class IncidentTemplate(AWSProperty):
    props = {
        "DedupeString": (str, False),
        "Impact": (integer, True),
        "NotificationTargets": ([NotificationTargetItem], False),
        "Summary": (str, False),
        "Title": (str, True),
    }


class ResponsePlan(AWSObject):
    resource_type = "AWS::SSMIncidents::ResponsePlan"

    props = {
        "Actions": ([Action], False),
        "ChatChannel": (ChatChannel, False),
        "DisplayName": (str, False),
        "Engagements": ([str], False),
        "IncidentTemplate": (IncidentTemplate, True),
        "Name": (str, True),
        "Tags": (Tags, False),
    }
