# Copyright (c) 2012-2021, Mark Peek <mark@peek.org>
# All rights reserved.
#
# See LICENSE file for full license.
#
# *** Do not modify - this file is autogenerated ***
# Resource specification version: 44.0.0


from troposphere import Tags

from . import AWSObject, AWSProperty


class ServerSideEncryptionConfiguration(AWSProperty):
    props = {
        "KmsKeyId": (str, False),
    }


class Assistant(AWSObject):
    resource_type = "AWS::Wisdom::Assistant"

    props = {
        "Description": (str, False),
        "Name": (str, True),
        "ServerSideEncryptionConfiguration": (ServerSideEncryptionConfiguration, False),
        "Tags": (Tags, False),
        "Type": (str, True),
    }


class AssociationData(AWSProperty):
    props = {
        "KnowledgeBaseId": (str, True),
    }


class AssistantAssociation(AWSObject):
    resource_type = "AWS::Wisdom::AssistantAssociation"

    props = {
        "AssistantId": (str, True),
        "Association": (AssociationData, True),
        "AssociationType": (str, True),
        "Tags": (Tags, False),
    }


class RenderingConfiguration(AWSProperty):
    props = {
        "TemplateUri": (str, False),
    }


class AppIntegrationsConfiguration(AWSProperty):
    props = {
        "AppIntegrationArn": (str, True),
        "ObjectFields": ([str], True),
    }


class SourceConfiguration(AWSProperty):
    props = {
        "AppIntegrations": (AppIntegrationsConfiguration, False),
    }


class KnowledgeBase(AWSObject):
    resource_type = "AWS::Wisdom::KnowledgeBase"

    props = {
        "Description": (str, False),
        "KnowledgeBaseType": (str, True),
        "Name": (str, True),
        "RenderingConfiguration": (RenderingConfiguration, False),
        "ServerSideEncryptionConfiguration": (ServerSideEncryptionConfiguration, False),
        "SourceConfiguration": (SourceConfiguration, False),
        "Tags": (Tags, False),
    }
